

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{iaria-lite}[2024/09/16 unofficial IARIA-lite conference template v0.4]

\newcounter{iaria@subfigtracker}
\newcounter{iaria@subcaptiontracker}
\newcounter{iaria@pbalancetracker}
\newcounter{iaria@flushendtracker}


\DeclareOption{subfig}{
  \setcounter{iaria@subfigtracker}{1}
  \typeout{iaria class: subfig option is set (use subfloat command).}
}
\DeclareOption{subcaption}{
  \setcounter{iaria@subcaptiontracker}{1}
  \typeout{iaria class: subcaption option is set (use subfigure command).}
}

\DeclareOption{onecolumn}{\OptionNotUsed} % IEEE option onecolumn will be ignored

\DeclareOption{pbalance}{
  \setcounter{iaria@pbalancetracker}{1}
  \typeout{iaria class: pbalance option is set.}
}
\DeclareOption{flushend}{
  \setcounter{iaria@flushendtracker}{1}
  \typeout{iaria class: flushend option is set.}
}

\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{IEEEtran}% required IEEE options: conference (for IARIA purposes)
}

\ProcessOptions\relax

\LoadClass{IEEEtran}

\RequirePackage{times} % Times New Roman

\RequirePackage{graphicx}
\RequirePackage{xcolor}

\RequirePackage{url}
\RequirePackage{orcidlink}
\RequirePackage{hyperref}
\hypersetup{hidelinks,unicode}

\makeatletter
\renewcommand{\fnum@figure}{Figure~\thefigure}
\renewcommand{\title}[1]{\renewcommand{\@title}{\bfseries\Large #1}}
\renewcommand\IEEEkeywordsname{Keywords}
\makeatother

\RequirePackage{xpatch}
\xpatchcmd\IEEEkeywords{---}{-}{}{}

\let\oldIEEEkeywords\IEEEkeywords
\def\IEEEkeywords{\oldIEEEkeywords\itshape\ignorespaces}

\makeatletter
\renewcommand{\IEEEauthorblockN}[1]{%
    \relax\@IEEEauthorblockNstyle% set the default text style
    \gdef\@IEEEauthorblockXinterlinespace{0pt}% disable strut for spacer row
    % the \expandafter hides the \cr in conditional tex, see the array.sty docs
    % for details, probably not needed here as the \cr is in a macro
    % do a spacer row if needed
    \if@IEEEprevauthorblockincol\expandafter\@IEEEauthorblockNtopspaceline\fi
    \global\@IEEEprevauthorblockincoltrue% we now have a block in this column
    %restore the correct strut value
    \gdef\@IEEEauthorblockXinterlinespace{\@IEEEauthorblockNinterlinespace}%
    % input the author names
    \large
    #1%
    % end the row if the user did not already
    \crcr}
\makeatother

\usepackage{etoolbox}
\makeatletter
\patchcmd{\@makecaption}
  {\\}
  {.\ }
  {}
  {}
\makeatother

\ifnum\value{iaria@subfigtracker}=1
  \typeout{iaria class: load subfig package (use subfloat command).}
  \RequirePackage[caption=false,font=footnotesize]{subfig}
\fi
\ifnum\value{iaria@subcaptiontracker}=1
  \typeout{iaria class: load subcaption package (use subfigure command).}
  \RequirePackage{subcaption}
  \captionsetup[subfigure]{labelformat=parens,font=footnotesize}
\fi

\ifnum\value{iaria@pbalancetracker}=1
  \typeout{iaria class: load pbalance package.}
  \RequirePackage{pbalance}
\fi
\ifnum\value{iaria@flushendtracker}=1
  \typeout{iaria class: load flushend package.}
  \RequirePackage{flushend}
\fi

\endinput
%%
%% End of file `iaria-lite.cls'.
