/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.GeomTransform;
import org.odejava.PlaceableGeom;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseCollidableNode;

public abstract class BaseCollidableOffset
extends BaseCollidableNode {
    protected static final int FIELD_COLLIDABLE = 6;
    protected static final int LAST_OFFSET_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    protected static final String COLLIDABLE_PROTO_MSG = "collidable field proto value does not describe a X3DNBodyCollidableNode object.";
    protected static final String COLLIDABLE_NODE_MSG = "collidable field node value does not describe a X3DNBodyCollidableNode object.";
    private static final int[] nodeFields = new int[]{0, 6};
    private static VRMLFieldDeclaration[] fieldDecl = new VRMLFieldDeclaration[7];
    private static HashMap fieldMap = new HashMap(21);
    protected VRMLProtoInstance pCollidable;
    protected VRMLNBodyCollidableNodeType vfCollidable;

    public BaseCollidableOffset() {
        super("CollidableOffset");
        this.hasChanged = new boolean[7];
    }

    public BaseCollidableOffset(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLNBodyCollidableNodeType)vRMLNodeType);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        if (this.pCollidable != null) {
            this.pCollidable.setupFinished();
        } else if (this.vfCollidable != null) {
            this.vfCollidable.setupFinished();
        }
        this.createODEGeom();
        this.odeGeom.setPosition(this.vfTranslation[0], this.vfTranslation[1], this.vfTranslation[2]);
        this.odeGeom.setAxisAndAngle(this.vfRotation[0], this.vfRotation[1], this.vfRotation[2], this.vfRotation[3]);
        super.setupFinished();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pCollidable != null ? this.pCollidable : this.vfCollidable;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 6: {
                this.setCollidable(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setCollidable(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  col");
        }
        VRMLNodeType vRMLNodeType2 = this.pCollidable != null ? this.pCollidable : this.vfCollidable;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof VRMLNBodyCollidableNodeType)) {
                throw new InvalidFieldValueException(COLLIDABLE_PROTO_MSG);
            }
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType3;
            this.pCollidable = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLNBodyCollidableNodeType)) {
                throw new InvalidFieldValueException(COLLIDABLE_NODE_MSG);
            }
            this.pCollidable = null;
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType;
        }
        this.vfCollidable = vRMLNBodyCollidableNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
    }

    private void createODEGeom() {
        if (this.vfCollidable == null) {
            return;
        }
        PlaceableGeom placeableGeom = this.vfCollidable.getODEGeometry();
        this.odeGeom = new GeomTransform();
        ((GeomTransform)this.odeGeom).setEncapsulatedGeom(placeableGeom);
    }

    static {
        BaseCollidableOffset.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCollidableOffset.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseCollidableOffset.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseCollidableOffset.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFNode", "collidable");
        BaseCollidableOffset.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseCollidableOffset.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseCollidableOffset.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(5);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(4);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(3);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("bboxCenter", new Integer(2));
        fieldMap.put("bboxSize", new Integer(1));
        fieldMap.put("collidable", new Integer(6));
    }
}

