/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.NodeTemplateToInstanceCreator;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.WriteableSceneMetaData;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.parser.FieldParserFactory;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.renderer.CRProtoCreator;
import org.web3d.vrml.renderer.CRROUTE;
import org.web3d.vrml.renderer.CRVRMLScene;
import org.web3d.vrml.renderer.DefaultLocator;
import org.web3d.vrml.sav.BinaryContentHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;
import org.web3d.vrml.sav.VRMLParseException;

public abstract class CRMainSceneBuilder
implements StringContentHandler,
BinaryContentHandler,
ProtoHandler,
ScriptHandler,
RouteHandler {
    protected static final String BAD_METHOD_MSG = "This method was called when it should not be. Not used by this impl";
    protected static final int STACK_START_SIZE = 100;
    protected static final int STACK_INCREMENT = 25;
    protected static final String VRML97_PROFILE_STRING = "VRML97";
    protected static final String VRML_IMPORT_ERROR = "IMPORT statements are not permitted in VRML97 files";
    protected static final String VRML_EXPORT_ERROR = "EXPORT statements are not permitted in VRML97 files";
    protected CRProtoCreator protoCreator;
    protected boolean init;
    protected ErrorReporter errorReporter;
    protected Locator locator;
    protected VRMLFieldReader fieldParser;
    protected boolean inScript;
    protected int ignoreNodeCounter;
    protected boolean inStatic;
    protected int staticDepthCounter;
    protected boolean badFieldName;
    protected int currentFieldIndex;
    protected VRMLNodeType currentNode;
    protected VRMLScriptNodeType currentScript;
    protected CRVRMLScene scene;
    protected WriteableSceneMetaData metaData;
    protected VRMLWorldRootNodeType root;
    protected VRMLNodeType[] nodeStack;
    protected int[] childIndexStack;
    protected int topOfStack;
    protected Map defMap;
    protected Map protoMap;
    protected Map externProtoMap;
    protected Map importProxyMap;
    protected Map exportProxyMap;
    protected SimpleStack scriptStack;
    protected VRMLNodeFactory baseNodeFactory;
    protected VRMLNodeFactory nodeFactory;
    protected boolean isVrml97;
    protected HashSet dontLoadTypes;
    protected HashSet ignoreDefSet;
    protected HashSet staticNodeSet;
    protected String worldURL;
    protected int majorVersion;
    protected int minorVersion;
    protected FrameStateManager stateManager;
    private long startTime;

    protected CRMainSceneBuilder(VRMLNodeFactory vRMLNodeFactory) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("The factory reference is null");
        }
        this.baseNodeFactory = vRMLNodeFactory;
        this.init = false;
        this.inScript = false;
        this.inStatic = false;
        this.scriptStack = new SimpleStack();
        this.dontLoadTypes = new HashSet();
        this.ignoreDefSet = new HashSet();
        this.staticNodeSet = new HashSet();
        this.importProxyMap = new HashMap();
        this.exportProxyMap = new HashMap();
        this.nodeStack = new VRMLNodeType[100];
        this.childIndexStack = new int[100];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        int n;
        if (this.locator == null) {
            this.locator = new DefaultLocator();
        }
        this.startTime = System.currentTimeMillis();
        this.topOfStack = 0;
        this.currentFieldIndex = 0;
        this.worldURL = string2;
        this.inScript = false;
        int n2 = 3;
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        try {
            this.nodeFactory = (VRMLNodeFactory)this.baseNodeFactory.clone();
            this.nodeFactory.setErrorReporter(this.errorReporter);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SAVException("Unable to copy node factory");
        }
        if (string4.charAt(1) == 'V') {
            int n5 = n = string5.charAt(1) == '2' ? 1 : 0;
            if (n != 0) {
                n2 = 2;
            }
            n4 = string3.equals("utf8") ? 2 : 1;
            this.metaData = new WriteableSceneMetaData(n != 0 ? "2.0" : "1.0", true, n4);
            this.metaData.setProfileName(VRML97_PROFILE_STRING);
            this.nodeFactory.setSpecVersion(n2, n3);
            this.nodeFactory.setProfile(VRML97_PROFILE_STRING);
            bl = true;
        } else {
            if (this.isVrml97) {
                throw new SAVException("Incompatible version for VRML97");
            }
            n4 = string3.equals("utf8") ? 2 : 3;
            this.metaData = new WriteableSceneMetaData(string5, false, n4);
            n = string5.indexOf(46);
            String string7 = string5.substring(n + 1);
            n3 = Integer.parseInt(string7);
            this.nodeFactory.setSpecVersion(n2, n3);
        }
        if (n2 != this.majorVersion || n3 != this.minorVersion) {
            FieldParserFactory fieldParserFactory = FieldParserFactory.getFieldParserFactory();
            this.fieldParser = fieldParserFactory.newFieldParser(n2, n3);
            this.fieldParser.setDocumentLocator(this.locator);
        }
        this.majorVersion = n2;
        this.minorVersion = n3;
        if (this.majorVersion == 3 && n4 == 3) {
            this.fieldParser.setCaseSensitive(false);
        } else {
            this.fieldParser.setCaseSensitive(true);
        }
        this.scene = new CRVRMLScene(this.majorVersion, this.minorVersion);
        this.scene.setWorldRootURL(string2);
        this.scene.setLoadedURI(string);
        this.scene.setMetaData(this.metaData);
        this.scene.setNodeFactory(this.nodeFactory);
        this.generateProtoCreator();
        if (bl) {
            this.root = (VRMLWorldRootNodeType)this.nodeFactory.createVRMLNode("WorldRoot", false);
            this.root.setFrameStateManager(this.stateManager);
            this.root.setErrorReporter(this.errorReporter);
            this.currentNode = this.root;
            this.nodeStack[0] = this.root;
            this.childIndexStack[0] = this.root.getFieldIndex("children");
            this.currentFieldIndex = this.childIndexStack[0];
            this.scene.setRootNode(this.root);
            this.root.setContainedScene(this.scene);
        }
        if (!this.init) {
            this.defMap = new HashMap();
            this.protoMap = new HashMap();
            this.externProtoMap = new HashMap();
            this.init = true;
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.nodeFactory.setProfile(string);
        this.metaData.setProfileName(string);
        this.root = (VRMLWorldRootNodeType)this.nodeFactory.createVRMLNode("WorldRoot", false);
        this.currentNode = this.root;
        this.nodeStack[0] = this.root;
        this.childIndexStack[0] = this.root.getFieldIndex("children");
        this.currentFieldIndex = this.childIndexStack[0];
        this.scene.setRootNode(this.root);
        this.root.setContainedScene(this.scene);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        Object object;
        int n = string.indexOf(58);
        String string2 = string;
        int n2 = -1;
        if (n != -1) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Component level is malformed");
            }
        } else {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Component statement \"" + string + "\" is malformed. It must include " + "both name and level required.");
        }
        object = this.nodeFactory.addComponent(string2, n2);
        this.metaData.addComponent((ComponentInfo)object);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
        if (string != null && string2 != null) {
            this.metaData.addMetaData(string, string2);
        }
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        if (this.majorVersion < 3) {
            throw new VRMLException(VRML_IMPORT_ERROR);
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLException("DEF name not known for Inline referenced by import " + string);
        }
        if (vRMLNodeType.getPrimaryType() != 24) {
            throw new VRMLException("Import statement refers to a DEF name that is not an Inline node" + string);
        }
        this.scene.addImportedNode(string3, string, string2);
        ImportNodeProxy importNodeProxy = new ImportNodeProxy(string3, string, string2);
        importNodeProxy.setErrorReporter(this.errorReporter);
        this.importProxyMap.put(string3, importNodeProxy);
        HashMap<String, ImportNodeProxy> hashMap = (HashMap<String, ImportNodeProxy>)this.exportProxyMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, ImportNodeProxy>();
            this.exportProxyMap.put(string, hashMap);
            ((VRMLInlineNodeType)vRMLNodeType).setImportNodes(hashMap);
        }
        hashMap.put(string2, importNodeProxy);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        if (this.majorVersion < 3) {
            throw new VRMLException(VRML_EXPORT_ERROR);
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLException("DEF name not known for export " + string);
        }
        this.scene.addExportedNode(string2, string);
    }

    public void endDocument() throws SAVException, VRMLException {
        this.root.setupFinished();
        for (int i = 0; i < this.topOfStack; ++i) {
            this.nodeStack[i] = null;
        }
        this.topOfStack = 0;
        this.currentNode = null;
        this.currentScript = null;
        this.currentFieldIndex = -1;
        this.protoCreator = null;
    }

    public abstract void startNode(String var1, String var2) throws SAVException, VRMLException;

    public void endNode() throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            --this.ignoreNodeCounter;
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        if (this.staticDepthCounter > 0) {
            --this.staticDepthCounter;
            if (this.staticDepthCounter == 0) {
                this.inStatic = false;
            }
        }
        this.nodeStack[this.topOfStack--] = null;
        this.currentNode = this.nodeStack[this.topOfStack];
        this.currentFieldIndex = this.childIndexStack[this.topOfStack];
    }

    public void startField(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        int n = this.nodeStack[this.topOfStack].getFieldIndex(string);
        if (n == -1) {
            this.badFieldName = true;
            throw new InvalidFieldException("Unknown field name: " + string + " for node: " + this.nodeStack[this.topOfStack].getVRMLNodeName());
        }
        this.currentFieldIndex = n;
        this.childIndexStack[this.topOfStack] = n;
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        VRMLFieldDeclaration vRMLFieldDeclaration;
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        if ((vRMLFieldDeclaration = this.currentNode.getFieldDeclaration(this.currentFieldIndex)) == null) {
            throw new InvalidFieldException("Invalid field: " + this.currentNode.getVRMLNodeName() + " " + this.currentFieldIndex);
        }
        this.parseField(this.currentNode, this.currentFieldIndex, vRMLFieldDeclaration.getFieldType(), string);
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        VRMLFieldDeclaration vRMLFieldDeclaration;
        if (this.ignoreNodeCounter > 0 || stringArray.length == 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        if ((vRMLFieldDeclaration = this.currentNode.getFieldDeclaration(this.currentFieldIndex)) == null) {
            throw new InvalidFieldException("Invalid field: " + this.currentNode.getVRMLNodeName() + " " + this.currentFieldIndex);
        }
        this.parseField(this.currentNode, this.currentFieldIndex, vRMLFieldDeclaration.getFieldType(), stringArray);
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0 || this.ignoreDefSet.contains(string)) {
            return;
        }
        if (!this.inStatic && this.staticNodeSet.contains(string)) {
            throw new InvalidFieldValueException("Line: " + this.locator.getLineNumber() + " Column: " + this.locator.getColumnNumber() + " Cannot USE a node that is under a static group. \"" + string + '\"');
        }
        if (this.inStatic && !this.staticNodeSet.contains(string)) {
            throw new InvalidFieldValueException("Line: " + this.locator.getLineNumber() + " Column: " + this.locator.getColumnNumber() + "Cannot USE a node under a StaticGroup that was not DEFd " + "under a StaticGroup \"" + string + '\"');
        }
        if (this.importProxyMap.containsKey(string)) {
            throw new InvalidFieldValueException("Line: " + this.locator.getLineNumber() + " Column: " + this.locator.getColumnNumber() + " Illegal to USE an IMPORTed node: " + string);
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.defMap.get(string);
        if (vRMLNodeType == null) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE declares an unknown source node DEF \"" + string + '\"');
        }
        if (!(this.nodeStack[this.topOfStack] instanceof VRMLScriptNodeType) && !(this.nodeStack[this.topOfStack] instanceof VRMLProtoInstance)) {
            if (vRMLNodeType instanceof VRMLBindableNodeType) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a bindable node \"" + string + '\"');
            }
            if (vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes()) {
                throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "USE references a grouping node that contains bindable node(s). \"" + string + '\"');
            }
        }
        this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, vRMLNodeType);
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void fieldValue(int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, n);
    }

    public void fieldValue(int[] nArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, nArray, n);
    }

    public void fieldValue(boolean bl) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, bl);
    }

    public void fieldValue(boolean[] blArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, blArray, n);
    }

    public void fieldValue(float f) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, f);
    }

    public void fieldValue(float[] fArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, fArray, n);
    }

    public void fieldValue(long l) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, l);
    }

    public void fieldValue(long[] lArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, lArray, n);
    }

    public void fieldValue(double d) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, d);
    }

    public void fieldValue(double[] dArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, dArray, n);
    }

    public void fieldValue(String[] stringArray, int n) throws SAVException, VRMLException {
        if (this.ignoreNodeCounter > 0) {
            return;
        }
        if (this.badFieldName) {
            this.badFieldName = false;
        }
        this.currentNode.setValue(this.currentFieldIndex, stringArray, n);
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void endProtoBody() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        throw new SAVException(BAD_METHOD_MSG);
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.currentNode;
        this.scriptStack.push(this.currentScript);
        this.inScript = true;
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.scriptStack.pop();
        if (this.currentScript == null) {
            this.inScript = false;
        }
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        boolean bl;
        if (!this.inScript) {
            throw new VRMLParseException(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Script declaration not in script!");
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        int n2 = this.currentScript.appendField(vRMLFieldDeclaration);
        int n3 = vRMLFieldDeclaration.getFieldType();
        boolean bl2 = bl = n3 == 11 || n3 == 12;
        if (n == 2 || n == 3) {
            if (bl) {
                this.currentFieldIndex = n2;
            } else if (object instanceof String) {
                this.parseField((VRMLNodeType)this.currentScript, n2, vRMLFieldDeclaration.getFieldType(), (String)object);
            } else {
                this.parseField((VRMLNodeType)this.currentScript, n2, vRMLFieldDeclaration.getFieldType(), (String[])object);
            }
        }
        this.childIndexStack[this.topOfStack] = n2;
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        int n;
        VRMLNodeType vRMLNodeType;
        if (this.ignoreDefSet.contains(string) || this.ignoreDefSet.contains(string3)) {
            return;
        }
        if (this.staticNodeSet.contains(string) || this.staticNodeSet.contains(string3)) {
            throw new InvalidFieldConnectionException("ROUTE references a node under a StaticGroup");
        }
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.defMap.get(string);
        boolean bl = false;
        if (vRMLNodeType2 == null) {
            if (this.majorVersion < 3 || !this.importProxyMap.containsKey(string)) {
                throw new InvalidFieldConnectionException("ROUTE declares an unknown source node DEF: " + string);
            }
            bl = true;
            vRMLNodeType2 = (VRMLNodeType)this.importProxyMap.get(string);
        }
        if ((vRMLNodeType = (VRMLNodeType)this.defMap.get(string3)) == null) {
            if (this.majorVersion < 3 || !this.importProxyMap.containsKey(string3)) {
                throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node DEF: " + string3);
            }
            bl = true;
            vRMLNodeType = (VRMLNodeType)this.importProxyMap.get(string3);
        }
        if ((n = vRMLNodeType2.getFieldIndex(string2)) == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown source node field DEF: " + string + "." + string2);
        }
        int n2 = vRMLNodeType.getFieldIndex(string4);
        if (n2 == -1) {
            throw new InvalidFieldConnectionException("ROUTE declares an unknown destination node field DEF: " + string3 + "." + string4);
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType2.getFieldDeclaration(n);
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(n2);
        if (!bl && vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType()) {
            throw new InvalidFieldConnectionException("The source field(" + string + "." + vRMLFieldDeclaration.getName() + ") type " + vRMLFieldDeclaration.getFieldTypeString() + " and destination field(" + string3 + "." + vRMLFieldDeclaration2.getName() + ") type " + vRMLFieldDeclaration2.getFieldTypeString() + " don't match");
        }
        CRROUTE cRROUTE = new CRROUTE(vRMLNodeType2, n, vRMLNodeType, n2);
        this.scene.addRoute(cRROUTE);
    }

    protected abstract void generateProtoCreator();

    public NodeTemplateToInstanceCreator getProtoCreator() {
        if (this.protoCreator == null) {
            this.generateProtoCreator();
        }
        return this.protoCreator;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.baseNodeFactory.setErrorReporter(this.errorReporter);
    }

    public CRVRMLScene getScene() {
        return this.scene;
    }

    public void reset() {
        this.inScript = false;
        this.badFieldName = false;
        this.worldURL = null;
        this.protoCreator = null;
        this.dontLoadTypes.clear();
        this.ignoreDefSet.clear();
        this.staticNodeSet.clear();
        this.scriptStack.clear();
        this.defMap.clear();
        this.protoMap.clear();
        this.externProtoMap.clear();
        this.importProxyMap.clear();
        this.exportProxyMap.clear();
        this.inStatic = false;
        this.staticDepthCounter = 0;
    }

    public void setGlobals(Map map, Map map2, Map map3) {
        this.defMap = map == null ? new HashMap() : map;
        this.protoMap = map2 == null ? new HashMap() : map2;
        this.externProtoMap = map3 == null ? new HashMap() : map3;
        this.init = true;
    }

    public void setLoadRequirements(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.isVrml97 = bl;
        if (!bl2) {
            this.dontLoadTypes.add(VRMLBackgroundNodeType.class);
        }
        if (!bl3) {
            this.dontLoadTypes.add(VRMLFogNodeType.class);
        }
        if (!bl4) {
            this.dontLoadTypes.add(VRMLLightNodeType.class);
        }
        if (!bl5) {
            this.dontLoadTypes.add(VRMLAudioClipNodeType.class);
        }
        if (!bl6) {
            this.dontLoadTypes.add(VRMLViewpointNodeType.class);
        }
        if (!bl7) {
            this.dontLoadTypes.add(VRMLInlineNodeType.class);
        }
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    protected final void resizeStack() {
        if (this.topOfStack + 1 == this.nodeStack.length) {
            int n = this.nodeStack.length;
            int n2 = n + 25;
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.nodeStack, 0, vRMLNodeTypeArray, 0, n);
            System.arraycopy(this.childIndexStack, 0, vRMLNodeTypeArray, 0, n);
            this.nodeStack = vRMLNodeTypeArray;
            this.childIndexStack = nArray;
        }
    }

    private void parseField(VRMLNodeType vRMLNodeType, int n, int n2, String string) {
        if (n2 != 27 && (string = string.trim()).length() == 0) {
            return;
        }
        switch (n2) {
            case 3: {
                vRMLNodeType.setValue(n, this.fieldParser.SFInt32(string));
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(string);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, this.fieldParser.SFFloat(string));
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, this.fieldParser.SFTime(string));
                break;
            }
            case 7: {
                vRMLNodeType.setValue(n, this.fieldParser.SFDouble(string));
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 31: {
                vRMLNodeType.setValue(n, this.fieldParser.SFLong(string));
                break;
            }
            case 32: {
                long[] lArray = this.fieldParser.MFLong(string);
                vRMLNodeType.setValue(n, lArray, lArray.length);
                break;
            }
            case 1: {
                vRMLNodeType.setValue(n, this.fieldParser.SFBool(string));
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 2: {
                boolean[] blArray = this.fieldParser.MFBool(string);
                vRMLNodeType.setValue(n, blArray, blArray.length);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 33: {
                float[] fArray = this.fieldParser.SFVec4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 34: {
                float[] fArray = this.fieldParser.MFVec4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 35: {
                double[] dArray = this.fieldParser.SFVec4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 36: {
                double[] dArray = this.fieldParser.MFVec4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 27: {
                vRMLNodeType.setValue(n, this.fieldParser.SFString(string));
                break;
            }
            case 28: {
                String[] stringArray = this.fieldParser.MFString(string);
                vRMLNodeType.setValue(n, stringArray, stringArray.length);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(string);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(string);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(string);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(string);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type provided to CRMainSceneBuilder! " + n2, null);
            }
        }
    }

    private void parseField(VRMLNodeType vRMLNodeType, int n, int n2, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 27: 
            case 31: {
                this.errorReporter.warningReport("Field not parsable as String[]. " + vRMLNodeType.getVRMLNodeName() + " index: " + n + " val: " + stringArray[0], null);
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(stringArray);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 32: {
                long[] lArray = this.fieldParser.MFLong(stringArray);
                vRMLNodeType.setValue(n, lArray, lArray.length);
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 2: {
                boolean[] blArray = this.fieldParser.MFBool(stringArray);
                vRMLNodeType.setValue(n, blArray, blArray.length);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 33: {
                float[] fArray = this.fieldParser.SFVec4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 34: {
                float[] fArray = this.fieldParser.MFVec4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 35: {
                double[] dArray = this.fieldParser.SFVec4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 36: {
                double[] dArray = this.fieldParser.MFVec4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 28: {
                String[] stringArray2 = this.fieldParser.MFString(stringArray);
                vRMLNodeType.setValue(n, stringArray2, stringArray2.length);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(stringArray);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(stringArray);
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(stringArray);
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(stringArray);
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type provided to CRMainSceneBuilder! " + n2, null);
            }
        }
    }
}

