/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.web3d.vrml.lang.ComponentInfo;

public class SceneMetaData {
    public static final int SCRIPTED_ENCODING = 0;
    public static final int ASCII_ENCODING = 1;
    public static final int VRML_ENCODING = 2;
    public static final int XML_ENCODING = 3;
    public static final int BINARY_ENCODING = 4;
    public static final int BIFS_ENCODING = 5;
    public static final int LAST_STD_ENCODING = 100;
    private final String version;
    private final boolean isVrml;
    private final int encoding;
    protected String profile;
    protected ArrayList components;
    protected HashMap metaData;

    protected SceneMetaData(String string, boolean bl, int n) {
        this.isVrml = bl;
        this.encoding = n;
        String string2 = string.trim();
        if (!Character.isDigit(string2.charAt(0))) {
            int n2;
            char[] cArray = string2.toCharArray();
            int n3 = 0;
            int n4 = cArray.length - 1;
            for (n2 = 0; n2 < cArray.length; ++n2) {
                if (!Character.isDigit(cArray[n2])) continue;
                n3 = n2;
                break;
            }
            for (n2 = n4; n2 >= 0; --n2) {
                if (!Character.isDigit(cArray[n2])) continue;
                n4 = n2;
                break;
            }
            string2 = new String(cArray, n3, n4 - n3);
        }
        this.version = string2;
        this.components = new ArrayList();
        this.metaData = new HashMap();
    }

    public SceneMetaData(SceneMetaData sceneMetaData) {
        this.isVrml = sceneMetaData.isVrml;
        this.encoding = sceneMetaData.encoding;
        this.version = sceneMetaData.version;
        this.components = new ArrayList(sceneMetaData.components);
        this.metaData = new HashMap(sceneMetaData.metaData);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isVrmlSpec() {
        return this.isVrml;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public String getProfileName() {
        return this.profile;
    }

    public ComponentInfo[] getComponents() {
        ComponentInfo[] componentInfoArray = null;
        if (this.components.size() != 0) {
            componentInfoArray = new ComponentInfo[this.components.size()];
            this.components.toArray(componentInfoArray);
        }
        return componentInfoArray;
    }

    public Map getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }
}

