/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.vrml97;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import org.web3d.parser.vrml97.JavaCharStream;
import org.web3d.parser.vrml97.ParseException;
import org.web3d.parser.vrml97.Token;
import org.web3d.parser.vrml97.VRML97FieldParserConstants;
import org.web3d.parser.vrml97.VRML97FieldParserTokenManager;
import org.web3d.util.BooleanArray;
import org.web3d.util.DoubleArray;
import org.web3d.util.FloatArray;
import org.web3d.util.IntArray;
import org.web3d.util.StringArray;

public class VRML97FieldParser
implements VRML97FieldParserConstants {
    private IntArray intBuf = new IntArray();
    private FloatArray floatBuf = new FloatArray();
    private DoubleArray doubleBuf = new DoubleArray();
    private BooleanArray booleanBuf = new BooleanArray();
    private StringArray stringBuf = new StringArray();
    public VRML97FieldParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[58];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private String stripString() {
        int n;
        String string = this.token.image;
        if (this.token.image.charAt(0) == '\"') {
            string = this.token.image.substring(1, this.token.image.length() - 1);
        }
        if (string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
            string = string.trim();
        }
        if ((n = string.indexOf("\\\"")) != -1) {
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            for (int i = 0; i < n2 - 1; ++i) {
                if (cArray[i] != '\\' || cArray[i + 1] != '\"') continue;
                System.arraycopy(cArray, i + 1, cArray, i, n2 - i - 1);
                ++i;
                --n2;
            }
            string = new String(cArray, 0, n2);
        }
        return string;
    }

    private int parseInt() {
        if (this.token.image.length() > 2 && this.token.image.startsWith("0x")) {
            return (int)Long.parseLong(this.token.image.substring(2), 16);
        }
        return Integer.parseInt(this.token.image);
    }

    public final Object parseUnknownField(boolean bl) throws ParseException {
        this.booleanBuf.clear();
        this.intBuf.clear();
        this.floatBuf.clear();
        this.doubleBuf.clear();
        this.stringBuf.clear();
        Object object = null;
        try {
            if (this.jj_2_1(2)) {
                this.jj_consume_token(5);
                object = Boolean.TRUE;
            } else if (this.jj_2_2(2)) {
                this.jj_consume_token(6);
                object = Boolean.FALSE;
            } else if (this.jj_2_3(2)) {
                this.jj_consume_token(1);
                object = bl ? (Number)new Integer(this.token.image) : (Number)new Float(this.token.image);
            } else if (this.jj_2_4(2)) {
                this.jj_consume_token(2);
                object = this.stripString();
            } else {
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 3: {
                                this.jj_consume_token(3);
                                break;
                            }
                            default: {
                                this.jj_la1[0] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 6: {
                                block32: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 5: {
                                            this.jj_consume_token(5);
                                            this.booleanBuf.add(true);
                                            break;
                                        }
                                        case 6: {
                                            this.jj_consume_token(6);
                                            this.booleanBuf.add(false);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[1] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 5: 
                                        case 6: {
                                            continue block32;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[2] = this.jj_gen;
                                object = this.booleanBuf.toArray();
                                break;
                            }
                            case 1: {
                                block33: while (true) {
                                    this.jj_consume_token(1);
                                    if (bl) {
                                        this.intBuf.add(this.parseInt());
                                    } else {
                                        this.floatBuf.add(Float.parseFloat(this.token.image));
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 1: {
                                            continue block33;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[3] = this.jj_gen;
                                if (bl) {
                                    object = this.intBuf.toArray();
                                    break;
                                }
                                object = this.floatBuf.toArray();
                                break;
                            }
                            case 2: {
                                block34: while (true) {
                                    this.jj_consume_token(2);
                                    this.stringBuf.add(this.stripString());
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 2: {
                                            continue block34;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[4] = this.jj_gen;
                                object = this.stringBuf.toArray();
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 4: {
                                this.jj_consume_token(4);
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 0: {
                                this.jj_consume_token(0);
                                break block1;
                            }
                        }
                        this.jj_la1[7] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unknown badly formatted value somewhere: " + this.token.image);
        }
    }

    public final int SFInt32() throws ParseException {
        this.jj_consume_token(1);
        try {
            return this.parseInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Int parse error: \"" + this.token.image + "\"");
        }
    }

    public final int[] MFInt32() throws ParseException {
        this.intBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(1);
                this.intBuf.add(this.parseInt());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                }
            }
            return this.intBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Int parse error on int # " + this.intBuf.size());
        }
    }

    public final float SFFloat() throws ParseException {
        this.jj_consume_token(1);
        try {
            return Float.parseFloat(this.token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Float parse error\"" + this.token.image + "\"");
        }
    }

    public final float[] MFFloat() throws ParseException {
        this.floatBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                }
            }
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            return this.floatBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Float parse error # " + this.floatBuf.size());
        }
    }

    public final boolean SFBool() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                return true;
            }
            case 6: {
                this.jj_consume_token(6);
                return false;
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean[] MFBool() throws ParseException {
        block14: {
            this.booleanBuf.clear();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                }
            }
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        this.booleanBuf.add(true);
                        continue block13;
                    }
                    case 6: {
                        this.jj_consume_token(6);
                        this.booleanBuf.add(false);
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[23] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        return this.booleanBuf.toArray();
    }

    public final String SFString() throws ParseException {
        this.jj_consume_token(2);
        return this.stripString();
    }

    public final String[] MFString() throws ParseException {
        this.stringBuf.clear();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(2);
            this.stringBuf.add(this.stripString());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        return this.stringBuf.toArray();
    }

    public final float[] SFVec2f() throws ParseException {
        float[] fArray = new float[2];
        try {
            this.jj_consume_token(1);
            fArray[0] = Float.parseFloat(this.token.image);
            this.jj_consume_token(1);
            fArray[1] = Float.parseFloat(this.token.image);
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("SFVec3f parse error # " + this.floatBuf.size());
        }
    }

    public final float[] MFVec2f() throws ParseException {
        this.floatBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                }
            }
            block11: while (true) {
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[33] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                }
            }
            return this.floatBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Float parse error # " + this.floatBuf.size());
        }
    }

    public final float[] SFVec3f() throws ParseException {
        float[] fArray = new float[3];
        try {
            this.jj_consume_token(1);
            fArray[0] = Float.parseFloat(this.token.image);
            this.jj_consume_token(1);
            fArray[1] = Float.parseFloat(this.token.image);
            this.jj_consume_token(1);
            fArray[2] = Float.parseFloat(this.token.image);
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("SFVec3f parse error # " + this.floatBuf.size());
        }
    }

    public final float[] MFVec3f() throws ParseException {
        this.floatBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                }
            }
            block11: while (true) {
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[38] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                }
            }
            return this.floatBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Float parse error # " + this.floatBuf.size());
        }
    }

    public final float[] SFRotation() throws ParseException {
        float[] fArray = new float[4];
        try {
            this.jj_consume_token(1);
            fArray[0] = Float.parseFloat(this.token.image);
            this.jj_consume_token(1);
            fArray[1] = Float.parseFloat(this.token.image);
            this.jj_consume_token(1);
            fArray[2] = Float.parseFloat(this.token.image);
            this.jj_consume_token(1);
            fArray[3] = Float.parseFloat(this.token.image);
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("SFVec3f parse error # " + this.floatBuf.size());
        }
    }

    public final float[] MFRotation() throws ParseException {
        this.floatBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                }
            }
            block11: while (true) {
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                this.jj_consume_token(1);
                this.floatBuf.add(Float.parseFloat(this.token.image));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[43] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                }
            }
            return this.floatBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Float parse error # " + this.floatBuf.size());
        }
    }

    public final double SFTime() throws ParseException {
        this.jj_consume_token(1);
        try {
            return Double.parseDouble(this.token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Double parse error\"" + this.token.image + "\"");
        }
    }

    public final double[] MFTime() throws ParseException {
        this.doubleBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(1);
            }
            this.doubleBuf.add(Double.parseDouble(this.token.image));
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                }
            }
            return this.doubleBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Double parse error # " + this.floatBuf.size());
        }
    }

    public final float[] SFColor() throws ParseException {
        float[] fArray = new float[3];
        try {
            this.jj_consume_token(1);
            float f = Float.parseFloat(this.token.image);
            if (f > 1.0f || f < 0.0f) {
                throw new ParseException("Color value out of range.  Value: " + f);
            }
            fArray[0] = f;
            this.jj_consume_token(1);
            f = Float.parseFloat(this.token.image);
            if (f > 1.0f || f < 0.0f) {
                throw new ParseException("Color value out of range.  Value: " + f);
            }
            fArray[1] = f;
            this.jj_consume_token(1);
            f = Float.parseFloat(this.token.image);
            if (f > 1.0f || f < 0.0f) {
                throw new ParseException("Color value out of range.  Value: " + f);
            }
            fArray[2] = f;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                }
            }
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("SFColor parse error # " + this.floatBuf.size());
        }
    }

    public final float[] MFColor() throws ParseException {
        this.floatBuf.clear();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                }
            }
            block11: while (true) {
                this.jj_consume_token(1);
                float f = Float.parseFloat(this.token.image);
                if (f > 1.0f || f < 0.0f) {
                    throw new ParseException("Color value out of range");
                }
                this.floatBuf.add(f);
                this.jj_consume_token(1);
                f = Float.parseFloat(this.token.image);
                if (f > 1.0f || f < 0.0f) {
                    throw new ParseException("Color value out of range");
                }
                this.floatBuf.add(f);
                this.jj_consume_token(1);
                f = Float.parseFloat(this.token.image);
                if (f > 1.0f || f < 0.0f) {
                    throw new ParseException("Color value out of range");
                }
                this.floatBuf.add(f);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[53] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                }
            }
            return this.floatBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Float parse error # " + this.floatBuf.size());
        }
    }

    public final int[] SFImage() throws ParseException {
        this.intBuf.clear();
        try {
            this.jj_consume_token(1);
            this.intBuf.add(this.parseInt());
            this.jj_consume_token(1);
            this.intBuf.add(this.parseInt());
            this.jj_consume_token(1);
            this.intBuf.add(this.parseInt());
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(1);
                this.intBuf.add(this.parseInt());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                }
            }
            return this.intBuf.toArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Int parse error on int # " + this.intBuf.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(5);
    }

    private final boolean jj_3_3() {
        return this.jj_scan_token(1);
    }

    private final boolean jj_3_4() {
        return this.jj_scan_token(2);
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(6);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{8, 96, 96, 2, 4, 102, 16, 1, 110, 1, 8, 2, 16, 1, 1, 8, 2, 16, 1, 96, 1, 8, 96, 96, 16, 1, 1, 8, 4, 16, 1, 1, 8, 2, 16, 1, 1, 8, 2, 16, 1, 1, 8, 2, 16, 1, 1, 8, 2, 16, 1, 1, 8, 2, 16, 1, 2, 1};
    }

    public VRML97FieldParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public VRML97FieldParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new VRML97FieldParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 58; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 58; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public VRML97FieldParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new VRML97FieldParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 58; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 58; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public VRML97FieldParser(VRML97FieldParserTokenManager vRML97FieldParserTokenManager) {
        int n;
        this.token_source = vRML97FieldParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 58; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(VRML97FieldParserTokenManager vRML97FieldParserTokenManager) {
        int n;
        this.token_source = vRML97FieldParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 58; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[14];
        for (n2 = 0; n2 < 14; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 58; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 14; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        VRML97FieldParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

