/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import org.j3d.util.interpolator.Interpolator;

public class RotationInterpolator
extends Interpolator {
    public static final int QUATERNION = 3;
    private Quat4f sharedPoint;
    private float[] sharedVector;
    private float[][] keyValues;
    private AxisAngle4f angle1;
    private AxisAngle4f angle2;
    private Quat4f quat1;
    private Quat4f quat2;

    public RotationInterpolator() {
        this(20, 1);
    }

    public RotationInterpolator(int n) {
        this(n, 1);
    }

    public RotationInterpolator(int n, int n2) {
        super(n, n2);
        this.keys = new float[n];
        this.keyValues = new float[n][4];
        this.sharedPoint = new Quat4f();
        this.sharedVector = new float[4];
        if (n2 == 3) {
            this.angle1 = new AxisAngle4f();
            this.angle2 = new AxisAngle4f();
            this.quat1 = new Quat4f();
            this.quat2 = new Quat4f();
        }
    }

    public void addKeyFrame(float f, float f2, float f3, float f4, float f5) {
        float[] fArray;
        int n = this.findKeyIndex(f);
        if (n < 0) {
            n = 0;
        }
        while (n < this.currentSize && this.keys[n] <= f) {
            ++n;
        }
        this.realloc();
        if (n >= this.currentSize) {
            fArray = this.keyValues[this.currentSize];
        } else {
            int n2 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n2);
            System.arraycopy(this.keys, n, this.keys, n + 1, n2);
            fArray = new float[4];
            this.keyValues[n] = fArray;
        }
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = f4;
        fArray[3] = f5;
        this.keys[n] = f;
        ++this.currentSize;
    }

    public void addKeyFrame(float f, Quat4f quat4f) {
        this.addKeyFrame(f, quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public Quat4f pointValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedPoint.set(this.keyValues[0]);
        } else if (n >= this.currentSize) {
            this.sharedPoint.set(this.keyValues[this.currentSize - 1]);
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray2 = this.keyValues[n];
                    float f2 = fArray[0] - fArray2[0];
                    float f3 = fArray[1] - fArray2[1];
                    float f4 = fArray[2] - fArray2[2];
                    float f5 = fArray[3] - fArray2[3];
                    float f6 = 0.0f;
                    float f7 = this.keys[n];
                    float f8 = this.keys[n + 1];
                    if (f8 != f7) {
                        f6 = (f - f7) / (f8 - f7);
                    }
                    this.sharedPoint.x = fArray2[0] + f6 * f2;
                    this.sharedPoint.y = fArray2[1] + f6 * f3;
                    this.sharedPoint.z = fArray2[2] + f6 * f4;
                    this.sharedPoint.w = fArray2[3] + f6 * f5;
                    break;
                }
                case 2: {
                    float[] fArray = this.keyValues[n];
                    this.sharedPoint.x = fArray[0];
                    this.sharedPoint.y = fArray[1];
                    this.sharedPoint.z = fArray[2];
                    this.sharedPoint.w = fArray[3];
                    break;
                }
                case 3: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray3 = this.keyValues[n];
                    this.angle1.set(fArray3);
                    this.angle2.set(fArray);
                    this.quat1.set(this.angle1);
                    this.quat2.set(this.angle2);
                    double d = this.quat1.x * this.quat2.x + this.quat1.y * this.quat2.y + this.quat1.z * this.quat2.z + this.quat1.w * this.quat2.w;
                    if (d < 0.0) {
                        this.quat1.negate();
                    }
                    float f9 = 0.0f;
                    float f10 = this.keys[n + 1];
                    float f11 = this.keys[n];
                    if (f10 != f11) {
                        f9 = (f - f11) / (f10 - f11);
                    }
                    this.quat1.interpolate(this.quat2, f9);
                    this.angle1.set(this.quat1);
                    this.angle1.get(this.sharedVector);
                    this.sharedPoint.set(this.sharedVector);
                }
            }
        }
        return this.sharedPoint;
    }

    public float[] floatValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedVector[0] = this.keyValues[0][0];
            this.sharedVector[1] = this.keyValues[0][1];
            this.sharedVector[2] = this.keyValues[0][2];
            this.sharedVector[3] = this.keyValues[0][3];
        } else if (n >= this.currentSize - 1) {
            this.sharedVector[0] = this.keyValues[this.currentSize - 1][0];
            this.sharedVector[1] = this.keyValues[this.currentSize - 1][1];
            this.sharedVector[2] = this.keyValues[this.currentSize - 1][2];
            this.sharedVector[3] = this.keyValues[this.currentSize - 1][3];
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray2 = this.keyValues[n];
                    float f2 = fArray[0] - fArray2[0];
                    float f3 = fArray[1] - fArray2[1];
                    float f4 = fArray[2] - fArray2[2];
                    float f5 = fArray[3] - fArray2[3];
                    float f6 = 0.0f;
                    float f7 = this.keys[n];
                    float f8 = this.keys[n + 1];
                    if (f8 != f7) {
                        f6 = (f - f7) / (f8 - f7);
                    }
                    this.sharedVector[0] = fArray2[0] + f6 * f2;
                    this.sharedVector[1] = fArray2[1] + f6 * f3;
                    this.sharedVector[2] = fArray2[2] + f6 * f4;
                    this.sharedVector[3] = fArray2[3] + f6 * f5;
                    break;
                }
                case 2: {
                    float[] fArray = this.keyValues[n];
                    this.sharedVector[0] = fArray[0];
                    this.sharedVector[1] = fArray[1];
                    this.sharedVector[2] = fArray[2];
                    this.sharedVector[3] = fArray[3];
                    break;
                }
                case 3: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray3 = this.keyValues[n];
                    this.angle1.set(fArray3);
                    this.angle2.set(fArray);
                    this.quat1.set(this.angle1);
                    this.quat2.set(this.angle2);
                    double d = this.quat1.x * this.quat2.x + this.quat1.y * this.quat2.y + this.quat1.z * this.quat2.z + this.quat1.w * this.quat2.w;
                    if (d < 0.0) {
                        this.quat1.negate();
                    }
                    float f9 = 0.0f;
                    float f10 = this.keys[n + 1];
                    float f11 = this.keys[n];
                    if (f10 != f11) {
                        f9 = (f - f11) / (f10 - f11);
                    }
                    this.quat1.interpolate(this.quat2, f9);
                    this.angle1.set(this.quat1);
                    this.angle1.get(this.sharedVector);
                }
            }
        }
        return this.sharedVector;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            float[][] fArrayArray = new float[n][];
            System.arraycopy(this.keyValues, 0, fArrayArray, 0, this.allocatedSize);
            for (int i = this.allocatedSize; i < n; ++i) {
                fArrayArray[i] = new float[4];
            }
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = fArrayArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<rotation interpolator>\n");
        for (int i = 0; i < this.currentSize; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(" x: ");
            stringBuffer.append(this.keyValues[i][0]);
            stringBuffer.append(" y: ");
            stringBuffer.append(this.keyValues[i][1]);
            stringBuffer.append(" z: ");
            stringBuffer.append(this.keyValues[i][2]);
            stringBuffer.append(" w: ");
            stringBuffer.append(this.keyValues[i][3]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("</rotation interpolator>");
        return stringBuffer.toString();
    }
}

