/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceChildNode;

public abstract class BaseImage2D
extends BaseSurfaceChildNode
implements VRMLSurfaceChildNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{42, 52};
    protected static final int FIELD_FIXED_SIZE = 3;
    protected static final int FIELD_TEXTURE = 4;
    protected static final int FIELD_ISACTIVE = 5;
    protected static final int FIELD_ENABLED = 6;
    protected static final int FIELD_ISOVER = 7;
    protected static final int FIELD_TOUCHTIME = 8;
    protected static final int FIELD_TRACKPOINT_CHANGED = 9;
    protected static final int FIELD_WINDOW_RELATIVE = 10;
    protected static final int LAST_IMAGE2D_INDEX = 10;
    protected static final int NUM_FIELDS = 11;
    protected static final String TEXTURE_PROTO_MSG = "Proto does not describe a Texture2D object";
    protected static final String TEXTURE_NODE_MSG = "Node does not describe a Texture2D object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfFixedSize;
    protected VRMLTexture2DNodeType vfTexture;
    protected VRMLProtoInstance pTexture;
    protected boolean vfIsActive;
    protected boolean vfWindowRelative;
    protected boolean vfEnabled;
    protected boolean vfIsOver;
    protected double vfTouchTime;
    protected float[] vfTrackPoint;

    protected BaseImage2D() {
        super("Image2D");
        this.hasChanged = new boolean[11];
        this.vfFixedSize = true;
        this.vfIsActive = false;
        this.vfEnabled = true;
        this.vfIsOver = false;
        this.vfTouchTime = 0.0;
        this.vfWindowRelative = false;
        this.vfTrackPoint = new float[2];
    }

    protected BaseImage2D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSurfaceChildNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("fixedSize");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFixedSize = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("windowRelative");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfWindowRelative = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.vfEnabled) {
            this.vfEnabled = bl;
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pTexture != null) {
            this.pTexture.setupFinished();
        }
        if (this.vfTexture != null) {
            this.vfTexture.setupFinished();
        }
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfFixedSize;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfWindowRelative;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsOver;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfTouchTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfTrackPoint;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pTexture == null ? this.vfTexture : this.pTexture;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfFixedSize);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfWindowRelative);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfIsOver);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfTouchTime);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfTrackPoint, 2);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldFormatException, InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("fixedSize is an initializeOnly field");
                }
                this.vfFixedSize = bl;
                break;
            }
            case 10: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("windowRelative is an initializeOnly field");
                }
                this.vfWindowRelative = bl;
                break;
            }
            case 6: {
                this.vfEnabled = bl;
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.setTextureNode(vRMLNodeType);
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setTextureNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType == null) {
            this.vfTexture = null;
        } else {
            VRMLNodeType vRMLNodeType2;
            if (vRMLNodeType instanceof VRMLProtoInstance) {
                this.pTexture = (VRMLProtoInstance)vRMLNodeType;
                vRMLNodeType2 = this.pTexture.getImplementationNode();
                if (!(vRMLNodeType2 instanceof VRMLTexture2DNodeType)) {
                    throw new InvalidFieldValueException(TEXTURE_PROTO_MSG);
                }
            } else {
                if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTexture2DNodeType)) {
                    throw new InvalidFieldValueException(TEXTURE_NODE_MSG);
                }
                this.pTexture = null;
                vRMLNodeType2 = vRMLNodeType;
            }
            this.vfTexture = (VRMLTexture2DNodeType)vRMLNodeType2;
        }
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    protected void setTrackPoint(int n, int n2) {
        if (!this.vfWindowRelative) {
            this.vfTrackPoint[0] = n;
            this.vfTrackPoint[1] = n2;
        } else {
            this.vfTrackPoint[0] = (float)n - this.screenLocation[0];
            this.vfTrackPoint[1] = (float)n2 - this.screenLocation[1];
        }
        this.hasChanged[9] = true;
        this.fireFieldChanged(9);
    }

    static {
        nodeFields = new int[]{4, 0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseImage2D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseImage2D.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseImage2D.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec2f", "bboxSize");
        BaseImage2D.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFBool", "fixedSize");
        BaseImage2D.fieldDecl[10] = new VRMLFieldDeclaration(2, "SFBool", "windowRelative");
        BaseImage2D.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texture");
        BaseImage2D.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseImage2D.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseImage2D.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFBool", "isOver");
        BaseImage2D.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFTime", "touchTime");
        BaseImage2D.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFVec2f", "trackPoint_changed");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(4);
        fieldMap.put("texture", n);
        fieldMap.put("set_texture", n);
        fieldMap.put("texture_changed", n);
        n = new Integer(6);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("bboxSize", new Integer(2));
        fieldMap.put("fixedSize", new Integer(3));
        fieldMap.put("windowRelative", new Integer(10));
        fieldMap.put("isActive", new Integer(5));
        fieldMap.put("isOver", new Integer(7));
        fieldMap.put("touchTime", new Integer(8));
        fieldMap.put("trackPoint_changed", new Integer(9));
    }
}

