/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SpringGenerator;

public class Spring
extends Shape3D {
    private static final float DEFAULT_INNER_RADIUS = 0.25f;
    private static final float DEFAULT_OUTER_RADIUS = 1.0f;
    private static final int DEFAULT_INNER_FACETS = 16;
    private static final int DEFAULT_OUTER_FACETS = 16;
    private static final int DEFAULT_LOOP_COUNT = 4;
    private static final float DEFAULT_LOOP_SPACING = 1.0f;
    private SpringGenerator generator;
    private GeometryData data = new GeometryData();

    public Spring() {
        this(0.25f, 1.0f, 1.0f, 4, 16, 16, null);
    }

    public Spring(Appearance appearance) {
        this(0.25f, 1.0f, 1.0f, 4, 16, 16, appearance);
    }

    public Spring(float f, float f2) {
        this(f, f2, 1.0f, 4, 16, 16, null);
    }

    public Spring(float f, float f2, Appearance appearance) {
        this(f, f2, 1.0f, 4, 16, 16, appearance);
    }

    public Spring(int n) {
        this(0.25f, 1.0f, 1.0f, n, 16, 16, null);
    }

    public Spring(int n, Appearance appearance) {
        this(0.25f, 1.0f, 1.0f, n, 16, 16, appearance);
    }

    public Spring(float f) {
        this(0.25f, 1.0f, f, 4, 16, 16, null);
    }

    public Spring(float f, Appearance appearance) {
        this(0.25f, 1.0f, f, 4, 16, 16, appearance);
    }

    public Spring(int n, int n2) {
        this(0.25f, 1.0f, 1.0f, 4, n, n2, null);
    }

    public Spring(int n, int n2, Appearance appearance) {
        this(0.25f, 1.0f, 1.0f, 4, n, n2, appearance);
    }

    public Spring(float f, float f2, float f3, int n) {
        this(f, f2, f3, n, 16, 16, null);
    }

    public Spring(float f, float f2, float f3, int n, int n2, int n3, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new SpringGenerator(f, f2, n2, n3);
        this.generator.generate(this.data);
        int n4 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n4, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setCapability(13);
        this.setAppearance(appearance);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setDimensions(float f, float f2) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setDimensions(f, f2);
        this.generator.generate(this.data);
        int n = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setLoopDimensions(float f, int n) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setLoopDimensions(f, n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n2, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setFacetCount(int n, int n2) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setFacetCount(n, n2);
        this.generator.generate(this.data);
        int n3 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n3, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }
}

