/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkbcompodb_form_h_
#define _vdkbcompodb_form_h_
#include <vdk/vdk.h>

class VDKBCompodbForm: public VDKForm
{

 private:

  void GUISetup(void);
  bool Changed;
 public:

  VDKBCompodbForm(VDKForm* owner, char* title);
  ~VDKBCompodbForm();
  void Setup(void);
 protected:

  VDKBox*  vbox1;
  // VDKCustomList*  compoList;
  VDKTreeView* compoList;
  VDKSeparator*  separator0;
  VDKBox*  hbox2;
  VDKCustomButton*  closeButton;
  VDKCustomButton*  deleteButton;
  VDKCustomButton*  addButton;
  VDKCustomButton*  modifyButton;
  VDKCustomButton*  saveButton;
  VDKStatusbar*  statusbar0;
  bool OnRealizeCompoList(VDKObject* sender);
  void LoadComponentDb();
  bool SaveComponentDb();
  bool CanClose(void);
 public:
  DECLARE_SIGNAL_MAP(VDKBCompodbForm);
  bool OncloseButtonClick(VDKObject* sender);
  bool OncompoListSelectRow(VDKObject* sender);
  bool OndeleteButtonClick(VDKObject* sender);
  bool OnaddButtonClick(VDKObject* sender);
  bool OnmodifyButtonClick(VDKObject* sender);
  bool OnsaveButtonClick(VDKObject* sender);
	
};

// input form
class VDKBCompoInputForm: public VDKForm
{

private:

	void GUISetup(void);
	char* libpath, *libname;
public:
	VDKBCompoInputForm(VDKForm* owner, char* libpath, char* libname);
	~VDKBCompoInputForm();
	void Setup(void);
protected:
	VDKBox*  vbox1;
	VDKBox*  vbox2;
	VDKBox*  hbox5;
	VDKLabel*  label0;
	VDKEntry*  libpathEntry;
	VDKBox*  hbox6;
	VDKLabel*  label1;
	VDKEntry*  libnameEntry;
	VDKSeparator*  separator1;
	VDKBox*  hbox10;
	VDKCustomButton*  acceptButton;
	VDKCustomButton*  cancelButton;
 public:
	DECLARE_SIGNAL_MAP(VDKBCompoInputForm);
	bool OnacceptButtonClick(VDKObject* sender);
	bool OncancelButtonClick(VDKObject* sender);
};
#endif
