/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.4
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb.h>
#include <stdio.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_prj.h>
#include <sys/param.h>

static char *making[] = 
{ NULL, NULL, NULL, NULL ,NULL, NULL, NULL, NULL,NULL,NULL
};
static char buff[512];
// below this index does not overwrites
#define DO_NOT_OVERWRITE 6
static char *tobecopied[] =
{ 
 "AUTHORS","COPYING","ChangeLog", "INSTALL",
 "NEWS ", "README", "autogen.sh", "aclocal.m4",0
};
bool
VDKBMainForm::AcAutogen(VDKObject* sender)
{
  int t;
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  // request user confirmation
  sprintf(buff,
_("Autoconf/Automake support will\
\n\t* generate (or overwrite):\
\n\t\t - acconfig.h\n\
\n\t\t - configure.in\
\n\t\t - Makefile.am\
\n\t* copy all required files into %s\
\n\t* invoke ./autogen.sh\
\n\nDo you want apply Automake/Autoconf support ?"), (char*) tgtPath);
  if(Application()->VDKMessageBox(APPNAME,
			     buff,
			     VDK_ICONQUESTION|VDK_YESNO,
			     _(user_messages[user_ok]),
			     _(user_messages[user_no])) == VDK_IDNO)
    return true;
  /*
    copies all default files from vdkbuilder data dir
    to project path
  */
  for(t = 0; tobecopied[t]; t++)
   { 
      /* 
	 does not overwrites :
	 AUTHORS,COPYING,ChangeLog, INSTALL,
	 NEWS, and README
      */
      if( (t < DO_NOT_OVERWRITE) &&  !access(tobecopied[t],F_OK) )
	;
      else
	{
	  sprintf(buff,"cp -a %s/res/%s %s/",
		  VDKB_DATADIR,
		  tobecopied[t],
		  (char*) tgtPath);
	  system(buff);
	}
    }
  sprintf(buff,"chmod +x %s/autogen.sh",(char*) tgtPath);
  system(buff);
  // if configure.in exists ask to user wheter save and
  // unlink configure.in and Makefile.am.
  sprintf(buff,"%s/acconfig.h",(char*) tgtPath);
  bool regenerate = false;
  if(!access(buff,F_OK))
    {
      if(Application()->VDKMessageBox(APPNAME,
"acconfig.h, configure.in and Makefile.am already exist.\n\
Do you want regenerate them ? If you answer yes\n\
they will be regenerated and the old copy saved as\n\
acconfig.h.old,configure.in.old and Makefile.am.old,\n\
otherwise actual copies will be used by autogen",
			     VDK_ICONQUESTION|VDK_YESNO,
			     _(user_messages[user_ok]),
			     _(user_messages[user_no])) == VDK_IDYES)
	{
	  char local[512];
	  sprintf(buff,"%s/acconfig.h",(char*) tgtPath);
	  sprintf(local,"cp %s %s.old",buff,buff);
	  system(local);
	  sprintf(buff,"%s/configure.in",(char*) tgtPath);
	  sprintf(local,"cp %s %s.old",buff,buff);
	  system(local);
	  sprintf(buff,"%s/Makefile.am",(char*) tgtPath);
	  sprintf(local,"cp %s %s.old",buff,buff);
	  system(local);
	  regenerate = true;
	}
    }
  /*
    writes acconfig.h
  */
  FILE* fp = NULL;
  char* defines = NULL;
  char* token = NULL;
  sprintf(buff,"%s/acconfig.h",(char*) tgtPath);
  if(regenerate || (access(buff,F_OK)))
    {
      fp = fopen(buff,"w+");
      if(! fp)
	return true;
      fprintf(fp,"/* acconfig.h.  Generated automatically from configure.in by autoheader.  */\n");
      defines = (char*) project->Options()->defines;
      strcpy(buff,defines);
      token = strtok(buff,"-");
      
      while(token)
	{
	  token++;
	  fprintf(fp,"\n#undef %s\n",token);
	  token = strtok(NULL,"-");
	}
      fclose(fp);
    }
  /*
    writes configure.in
  */
  VDKString prname;
  sprintf(buff,"%s/configure.in",(char*) tgtPath);
  if(regenerate || (access(buff,F_OK)))
    {
      fp = fopen(buff,"w+");
      if(! fp)
	return true;
      fprintf(fp,
	      "# ****************************************\n\
# Copyright Mario Motta <mmotta@guest.net>\n\
# ****************************************\n\
# VDKBuilder autoconf/automake support\n\
# ** WARNING ** overwritten by builder\n\n");
      char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
      prname = project->Name;
      char* p = get_extension((char*) prname);
      if(p)
	*p = '\0';
      fprintf(fp,"AC_INIT(%s.%s)\n\n",(char*) prname,cc_ext);
      char* version = (char*) project->Options()->version;
      fprintf(fp,"VERSION=%s\n",version);
      if(strlen( (char*) project->Options()->package))
	prname = project->Options()->package;
      fprintf(fp,"PACKAGE=%s\n\n", (char*) prname);
      fprintf(fp,
	      "# Initialize automake stuff\n\
AM_INIT_AUTOMAKE($PACKAGE, $VERSION)\n\
AC_CANONICAL_HOST\n\
\n\
# with this line you check libvdk version and set 3 variables for\n\
# your Makefile.am:\n\
# VDK_LIBS: every libs you need\n\
# VDK_CFLAGS: every include dir you need\n\
# VDK_CONFIG: the absolute path to vdk-config-2\n\
AM_PATH_VDK_2(`vdk-config-2 --version`,,AC_MSG_ERROR(Correct version of VDK is not installed))\n\
\n\
# check for C++ compiler, C++ pre-processor flag\n\
AC_PROG_CXX\n\
AC_PROG_CXXCPP\n\
AC_LANG_CPLUSPLUS\n\
\n");
      char* c_flags = (char*) project->Options()->c_flags;
      fprintf(fp,"CXXFLAGS=\"%s\"\n",c_flags);
      fprintf(fp,"AC_SUBST(CXXFLAGS)\n\n");
      // defines
      strcpy(buff,defines);
      token = strtok(buff,"-");
      while(token)
	{
	  token++;
	  fprintf(fp,"\nAC_DEFINE(%s)\n",token);
	  token = strtok(NULL,"-");
	}
      // almost done
      fprintf(fp,"# create a config.h header\n\
AM_CONFIG_HEADER(config.h)\n\
\n\
AC_OUTPUT(Makefile)\n\n");
      
      fclose(fp);
    }

  /* 
     writes Makefile.am 
  */
  sprintf(buff,"%s/Makefile.am",(char*) tgtPath);
  if(regenerate || (access(buff,F_OK)))
    {
      fp = fopen(buff,"w+");
      if(! fp)
	return true;
      fprintf(fp,
	      "# Copyright Mario Motta <mmotta@guest.net>\n\
# VDKBuilder autoconf/automake support\n\
# written by builder\n\n");
      
      fprintf(fp,
	      "#To make any subdir just give SUBDIRS variables\n\n\
#instead of .\n\nSUBDIRS = .\n\n");
      fprintf(fp,"bin_PROGRAMS = %s\n\n",(char*) prname);
      fprintf(fp,"%s_SOURCES = ",(char*) prname);
      project->WriteSourcesForAutomake(fp);
      char* includes = (char*) project->Options()->includes;
      fprintf(fp,"\nINCLUDES = %s\n\n",includes);
      char* libs = (char*) project->Options()->libs;
      fprintf(fp,"%s_LDFLAGS = %s\n\n",(char*) prname,libs);
      fprintf(fp,
	      "#In EXTRA_DIST variable you must put every file which is not used\n\
#to be compiled.\nEXTRA_DIST = \\\n\tautogen.sh");
      // search for <extra_dist.am>
      if(!access("extra_dist.am",F_OK))
	{
	  char local[512];
	  FILE* extra;
	  fprintf(fp,"\\\n\textra_dist.am");
	  extra = fopen("extra_dist.am","r");
	  if(extra)
	    {
	      while(fgets(local,512,extra))
		{
		  local[strlen(local)-1] = '\0';
		  fprintf(fp,"\\\n\t%s",local);
		}
	      fclose(extra);
	    }
	}
      // am_include.am is copied verbatim into Makefile.am if it exists. 
      // So, if it exists, it must be included in EXTRA_DIST, then copied. 
      // am_include.am can be used automake features not yet supported directly
      // by vdkbuilder, like for example check_PROGRAMS
      if(!access("am_include.am",F_OK))
	{
	  // adding to (and terminating) EXTRA_DIST
	  fprintf(fp,"\\\n\tam_include.am\n\n"); 
	  
	  // verbatim copying
	  char local[512];
	  FILE* am_include;
	  am_include = fopen("am_include.am","r");
	  if(am_include)
	    {
	      fprintf(fp,"# The contents of am_include.am are copied verbatim below\n");
	      while(fgets(local,512,am_include))
		{
		  fprintf(fp,"%s",local);
		}
	      fclose(am_include);
	    }
	}
      fclose(fp);
    }
  // save changed files
  if(editor && editor->Visible)
    editor->UpdateFiles();
  // writes gui files 
  PrjManager()->WriteGuiFiles();
  // writes makefile
  VDKString path = project->Path;
  char* file = new char[strlen((char*) path)+16];
  strcpy(file, (char*) path);
  strcat(file,"/vdkbMakefile");
  fp = fopen(file,"w+");
  if(fp)
    {
      project->WriteMakefile(fp);
      fclose(fp);
    }
  else
    {
      delete[] file;
      return true; // FIX ME: with user warning !!!!
    }
  delete[] file;
  /*
    save project
  */
  project->Save();
  /*
    invloke vdkbmaker &&
    runs autogen.sh
  */
  making[0] = "./autogen.sh";
  making[1] = NULL;
  CallMaker(making,(char*) tgtPath,0);
  bool have_config = !access("./configure",F_OK);
  ac_make->Enabled = have_config;
  ac_makeclean->Enabled = have_config;
  ac_makedist->Enabled = have_config;
  ac_makedistclean->Enabled = have_config;
  return true;
}
/*
 */
bool
VDKBMainForm:: AcMake(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  making[0] = "make";
  making[1] = NULL;
  // save changed files,
  if(editor && editor->Visible)
    editor->UpdateFiles();
  CallMaker(making,(char*) tgtPath,0);
  return true;
}
/*
 */
bool 
VDKBMainForm::AcMakeClean(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
 making[0] = "make";
 making[1] = "clean";
 making[2] = NULL;
 CallMaker(making,(char*) tgtPath,0);
 return true;
}
/*
 */
bool 
VDKBMainForm::AcMakeDist(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  making[0] = "make";
  making[1] = "dist";
  making[2] = NULL;
  CallMaker(making,(char*) tgtPath,0);
  return true;
}
/*
 */
bool 
VDKBMainForm::AcMakeDistclean(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  making[0] = "make";
  making[1] = "distclean";
  making[2] = NULL;
  CallMaker(making,(char*) tgtPath,0);
  ac_make->Enabled = false;
  ac_makeclean->Enabled = false;
  ac_makedist->Enabled = false;
  ac_makedistclean->Enabled = false;
  return true;
}
/*
output = 0 uses stderr, 1 stdout
 */
void
VDKBMainForm::CallMaker(char * args[], char* pth,int output)
{

  if(!maker)
    {
      if(editor)
	editor->ClearMessages();
      chdir(pth);
      VDKBStringList* list = new VDKBStringList;
      maker = new VDKBMaker(this,args,list,false,output);
      maker->Setup();
      maker->Show();
    }
  else
    Application()->VDKMessageBox(
			      APPNAME,
			      _("A compilation process is already running"),
			      VDK_ICONINFORMATION|VDK_OK,
			      _(user_messages[user_ok]),
			      NULL,
			      3000);
}


void
VDKBMainForm::LoadEditorWithErrors(VDKBStringList* list)
{
  if( (editor) && 
      (editor->Visible) && 
      (list->size() > 0))
    { 
      int t = 0;
      VDKBStringList slist;
      for(; t < list->size(); t++)
	{
	  char* p;
	  char* local = new char[strlen((char*) (*list)[t]) +1 ];
	  strcpy(local,(char*) (*list)[t]);
	  // tokenize
	  if( (p = strtok(local,"\n")) )
	    {
	      VDKString s = p;
	      slist.add(s);
	      while( ( p = strtok(NULL,"\n")) )
		{
		  VDKString s = p;
		  slist.add(s);
		}
	    }
	  else
	    {
	      VDKString s = local;
	      slist.add(s);
	    }
	  delete[] local;
	}
      editor->FillMessages(&slist);
    } 
}





