/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */ 
#include <vdkb2/vdkb_about.h>
#include <vdkb2/vdkb.h>
#include "pixmaps/stock_button_ok.xpm"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_GNOME
#if ENABLE_NLS
#include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
#else
#define _(str) str
#define N_(str) str 
#endif
#endif


static char buff[512];
static char version[256];
static char* authors = 
"The VDK team:\
 Mario Motta (Italy) \
 Ionutz Borcoman (Romania) \
 Tim Lorenz (Germany) \
 George Boutwell (USA) \
 Pierre-Louis Malatray (France) \
 Mile Lazarovski (Macedonia)";
static int canvasLength = 0;
static int counter = 0;
static VDKFont* canvas0_font = NULL;
static int showed_textW = 0;
static int fontH = 0;
static char* showed_text = authors;
static char* cpuinfo = NULL;
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(VDKBAboutForm,VDKForm)
  ON_SIGNAL(custombutton0,clicked_signal,Oncustombutton0Click),
  ON_SIGNAL(timer,timer_tick_signal,OnTimer)
END_SIGNAL_MAP

// just an exercise on cpu info
DEFINE_EVENT_LIST(VDKBAboutForm,VDKForm);

bool 
VDKBAboutForm::OnCanvas0ButtonPress(VDKObject*, GdkEvent*)
{
  showed_text = showed_text == cpuinfo ? authors : cpuinfo;
  VDKFont* font = canvas0->Font;
  if(font)
    showed_textW = font->Width(showed_text);
  return true;
}

/*
main form gui setup
*/
void
VDKBAboutForm::GUISetup(void)
{
 struct stat info;
  VDKBuilder* app = dynamic_cast<VDKBuilder*>(Application());
  if(!app)
    return;
  Title = "VDKBuilder";
  Box()->BorderWidth(0);
  VDKFrame* frame = new VDKFrame(this);
  frame->BorderWidth(0);
  frame->Shadow = shadow_out;// shadow_none;// shadow_etched_out;
  vbox = new VDKBox(this,v_box);
  frame->Add(vbox,0,0,0,0);
  Add(frame);
  VDKFrame* frame1 = new VDKFrame(this);
  frame1->BorderWidth(0);
  frame1->Shadow = shadow_in;
  canvas0 = new VDKCanvas(this);
  canvas0->SetSize(294,20);
  //  canvas0->SetTip(_("Click to toggle"));
  frame1->Add(canvas0,0,0,0,0);
  vbox->Add(frame1,0,0,0,0);
  separator1 = new VDKSeparator(this,h_separator);
  vbox->Add(separator1,0,0,0,0);
  //  sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_LOGO);
  sprintf(buff,"%s/.vdkb2/%s",(char*) app->user_home,VDKB_LOGO);
  if (stat(buff,&info) == -1)
    sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_LOGO);
  pixmap0 = new VDKImage(this,buff);
  vbox->Add(pixmap0,0,0,0,0);
  separator0 = new VDKSeparator(this,h_separator);
  vbox->Add(separator0,0,0,0,0);
  hbox2 = new VDKBox(this,h_box);
  vbox->Add(hbox2,0,1,1,0);
  hbox2->BorderWidth(0);
  /*
  custombutton0 = new VDKCustomButton(this,
				      (const char**) stock_button_ok_xpm,"Ok",16,(GtkPositionType) 1);
  */
  custombutton0 = new VDKHLButton(this, (const char**) stock_button_ok_xpm);
  custombutton0->SetTip(_("that's all folk !"));
  // custombutton0->SetSize(90,-1);
  hbox2->Add(custombutton0,0,0,0,3);
  label0 = new VDKLabel(this," ");
  // label0->SetSize(150,-1);
  label0->Justify =  (GtkJustification) 2;
  hbox2->Add(label0,0,1,1,0);
  gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_CENTER);
  EventConnect(canvas0,"button_press_event",
	       &VDKBAboutForm::OnCanvas0ButtonPress);

}

/*
main form setup
*/
void
VDKBAboutForm::Setup(void)
{
  GUISetup();
  // put your code below here
  sprintf(version,"VDK %d.%d.%d - Gtk+ %d.%d.%d - glib %d.%d.%d",
  	  VDK_VERSION_MAJOR,
  	  VDK_VERSION_MINOR,
  	  VDK_REVISION,
  	  gtk_major_version,
  	  gtk_minor_version,
  	  gtk_micro_version,
  	  glib_major_version,
  	  glib_minor_version,
  	  glib_micro_version);
  label0->Caption = version;
  // canvas settings
  canvas0->NormalBackground = clIvory;
  canvas0->Foreground = VDKRgb("navyblue");
  canvas0_font = new VDKFont(this,"helvetica bold 10");
  if((GdkFont*) *canvas0_font)
    {
      canvas0->Font = canvas0_font;
      showed_textW = canvas0_font->Width(showed_text);
      fontH = canvas0_font->Height("ABCDEFGHI");
    }
  else
  canvas0_font = NULL;
  // timer settings (does not start here - last arg = false)
  timer = new VDKTimer(this,200,false);
 
  // load cpu info
  /*
  cpuinfo = new char[4096];
  FILE* fp;
  fp = popen("cat /proc/cpuinfo","r");
  if( fp != NULL)
    { 
      memset(cpuinfo,'\0',4096);
      fread(cpuinfo,sizeof(char),4096,fp); 
      pclose(fp);
      char* p = cpuinfo;
      for(;*p;p++)
      if(*p == '\n')
      *p = ' ';
      printf("\n%s",cpuinfo);
      fflush(stdout);
    }
  */
}

/*
main form constructor
*/
VDKBAboutForm::VDKBAboutForm(VDKForm* owner, char* title):
	VDKForm(owner,title,v_box,GTK_WINDOW_POPUP)
{
}

/*
main form destructor
*/
VDKBAboutForm::~VDKBAboutForm()
{
}

/*
*/
bool
VDKBAboutForm::OnTimer(VDKObject*)
{
  int x = canvasLength-counter*6;
  canvas0->Clear();
  canvas0->DrawString(x,canvas0_font ? fontH : 16, showed_text);
  canvas0->Redraw();
  if(abs(x) >= showed_textW)
    counter = 0;
  else
    counter++;
   return true;
}

/*
 */
bool
VDKBAboutForm::Oncustombutton0Click(VDKObject* sender)
{
  Close();
  return true;
}

/*
 */
void
VDKBAboutForm::OnShow(VDKForm* sender)
{
  VDKPoint cs = canvas0->Usize;
  canvasLength = cs.x;
  timer->Start();
  return;
}

/*
 */
bool
VDKBAboutForm::CanClose(void)
{
  counter = 0;
  timer->Stop();
  if(cpuinfo)
    {
      delete[] cpuinfo;
      cpuinfo = NULL;
    }
  return true;
}
