/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.6
 * Revision 7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*
OVERVIEW
--------
This file has the aim to be a footstep that shows how to make a
vdk component.

COMPONENT REFERENCES
--------------------

VDKDigitalClock class <vdkdclock.h>
inherits from VDKEventBox

DESCRIPTION
-----------
VDKDigitalClock is a simple digital clock that shows
time, date and can be set with an alarm time.
The widget is a composite one, made by a canvas and a button.
Operations:
  - When the mouse pass over the canvas a tooltip displays
  current date.
  - Clicking on the canvas shows current alarm time setting
  or "no alarm"
  - Clicking on "Alarm" button emit a signal of "clock_alarm_set"

PUBLIC MEMBERS
--------------
none

PROPERTIES
----------
VDKRgb ClockBackground
  Sets clock background

VDKRgb ClockForeground;
  Sets clock foreground
  By default clock colors are green on black

VDKPoint Alarm;
  where x = hours and y = minutes,  if x || y < 0 alarm is off.
  Setting an alarm time causes the "clock_alarm" signal be emitted
  for 60 seconds or less if user calls StopAlarm().
  i.e: clock->Alarm = VDKPoint(10,35);
  sets alarm at 10:35 am

METHODS
-------
VDKDigitalClock(VDKForm* owner, bool activate = false);
  Constructor, make a VDKDigitalClock. If <activate> arg is true
  the clock begins normal operations displaying time, date etc.
  Default is false and can be later activate using Activate() method.

~VDKDigitalClock();
  Destructor

void Activate();
  Activates clock opertaions.

void StopAlarm()
  Stop alarm signal.

SIGNALS
-------
"clock_alarm"
  Received when and if an alarm time was set. Widget owner receives this
  signal for 60 secs. If the user calls StopAlarm() signal emission will
  be stopped.

"clock_alarm_set"
  Received whenever user presses the "alarm" button.

Tip:
  Since neither "clock_alarm" and "clock_alarm_set"  are signal provided by
  gtk+, user must connect with this signals using dynamic tables and setting
  <gtk> arg to false.
  i.e.:
  SignalConnect(clock,"clock_alarm_set",&ClockForm::OnAlarmSet,false);
  SignalConnect(clock,"clock_alarm",&ClockForm::OnAlarm,false);
*/

#ifndef _vdkdclock_h
#define _vdkdclock_h

#include <vdk/vdk.h>
/*
The clock class
*/
class VDKDigitalClock: 	public VDKEventBox
{
 private:
    bool activated;
 protected:
    bool alarm_enabled;
    VDKTimer* timer; // the clock ticker
    VDKCanvas* clock; // where clock displays
    VDKCustomButton* set; // to set alarm
    VDKForm *popform; // to show alarm time
    char timebuff[64];
    void GetTime();
    bool OnTimer(VDKObject*); // actually shows current time
    bool OnExpose(VDKObject *, GdkEvent* event);
    bool OnClockButtonPress(VDKObject *, GdkEvent* event);
    bool OnClockButtonRelease(VDKObject *, GdkEvent* event);
    bool OnSetClick(VDKObject*);
    void SetClockBackground(VDKRgb back);
    void SetClockForeground(VDKRgb back);
    void SetAlarm(VDKPoint p) { alarm_enabled = true; }

 public:
    __rwproperty(VDKDigitalClock,VDKRgb) ClockBackground;
    __rwproperty(VDKDigitalClock,VDKRgb) ClockForeground;
    __rwproperty(VDKDigitalClock,VDKPoint) Alarm;

    VDKDigitalClock(VDKForm* owner,bool activated = false);
    ~VDKDigitalClock();
    void Activate();
    void Setup(void);
    void StopAlarm() { alarm_enabled = false; }
    DECLARE_SIGNAL_LIST(VDKDigitalClock);
    DECLARE_EVENT_LIST(VDKDigitalClock);
};

/*
a splash form used to show alarm time
*/
class VDKDigitalClockPopForm: public VDKForm
{
	VDKPoint alarm;
public:
	VDKDigitalClockPopForm(VDKForm* owner,VDKPoint alarm):
	 VDKForm(owner,NULL,v_box,GTK_WINDOW_POPUP),alarm(alarm) {}
	~VDKDigitalClockPopForm() {}
	void Setup(void);
};
#endif
