/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_spinbutton_h
#define _vdkb_spinbutton_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_object.h>
#include <vdkb2/vdkb_widpopmenu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBSpinButton: public VDKSpinButton, public VDKBObject
{

 protected:

  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKEntry *digits,*defvalue,*lower,*upper,*step,*climb;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBSpinButton(char* name,VDKForm* owner,
		 float defValue = 0.0,
		 float lower = 0.0,
		 float upper = 1.0,
		 float step_increment = 0.05,
		 float climb_rate = 0.0);
  virtual ~VDKBSpinButton() {}
  virtual int Type() { return vdkbclass_spinbutton; }
  virtual char* VDKName() { return "VDKSpinButton"; }
  virtual int isA() { return vdkbclass_spinbutton; }
  void PopMenu() { popmenu->Popup(); }
  // designer
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  bool OnSetDefValue(VDKObject*);
  bool OnSetLower(VDKObject*);
  bool OnSetUpper(VDKObject*);
  bool OnSetStep(VDKObject*);
  bool OnSetClimb(VDKObject*);
  bool OnSetDigits(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBSpinButton);
  DECLARE_EVENT_LIST(VDKBSpinButton);
};
#endif
