/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Parses a regular expression string and returns a new regular expression.
*
* ## Notes
*
* -   Provided strings should be properly escaped.
* -   If unable to parse a string as a regular expression, the function returns `null`.
*
* @param str - regular expression string
* @throws must provide a regular expression string
* @returns regular expression or null
*
* @example
* var re = reFromString( '/beep/' );
* // returns /beep/
*/
declare function reFromString( str: string ): RegExp | null;


// EXPORTS //

export = reFromString;
