/**
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* String array containing two or three letter abbreviations for each card in a standard 52-card deck.
*
* @module @stdlib/datasets/standard-card-deck
*
* @example
* var cards = require( '@stdlib/datasets/standard-card-deck' );
*
* var list = cards();
* // returns ['AC', '2C', '3C', ... ]
*/

// MODULES //

var cards = require( './main.js' );


// EXPORTS //

module.exports = cards;
