// Generated by LiveScript 1.4.0
(function(){
  var module, test, timeLimitedPromise;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  timeLimitedPromise = function(time, fn){
    return Promise.race([
      new Promise(fn), new Promise(function(res, rej){
        return setTimeout(rej, time);
      })
    ]);
  };
  test('delay', function(assert){
    assert.expect(6);
    assert.isFunction(delay);
    assert.arity(delay, 1);
    assert.name(delay, 'delay');
    assert.looksNative(delay);
    assert.ok(delay(42) instanceof Promise, 'returns promises');
    timeLimitedPromise(1e3, function(res){
      delay(10).then(function(it){
        res(it);
      });
    }).then(function(it){
      return assert.ok(it === true, 'resolves as `true`');
    })['catch'](function(){
      return assert.ok(false, 'rejected');
    }).then(assert.async());
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, keys, create, assign, from, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  keys = Object.keys, create = Object.create, assign = Object.assign;
  from = Array.from;
  test('Dict', function(assert){
    var dict1, dict2, dict3, done, iter;
    assert.isFunction(Dict);
    assert.arity(Dict, 1);
    assert.name(Dict, 'Dict');
    assert.looksNative(Dict);
    dict1 = Dict();
    assert.ok(!(dict1 instanceof Object));
    assert.deepEqual(keys(dict1), []);
    dict2 = Dict({
      q: 1,
      w: 2
    });
    assert.ok(!(dict2 instanceof Object));
    assert.deepEqual(keys(dict2), ['q', 'w']);
    assert.ok(dict2.q === 1);
    assert.ok(dict2.w === 2);
    dict3 = Dict(createIterable([[1, 1], [2, 2]]));
    assert.ok(!(dict3 instanceof Object));
    assert.deepEqual(keys(dict3), ['1', '2']);
    assert.ok(dict3[1] === 1);
    assert.ok(dict3[2] === 2);
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      Dict(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
  });
  test('Dict.every', function(assert){
    var every, obj, ctx;
    every = Dict.every;
    assert.isFunction(every);
    every(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(every({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
    assert.ok(!every({
      q: 1,
      w: '2',
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
  });
  test('Dict.filter', function(assert){
    var filter, obj, ctx;
    filter = Dict.filter;
    assert.isFunction(filter);
    filter(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.deepEqual(filter({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return it % 2;
    }), Dict({
      q: 1,
      e: 3
    }));
  });
  test('Dict.find', function(assert){
    var find, obj, ctx;
    find = Dict.find;
    assert.isFunction(find);
    find(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(find({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return !(it % 2);
    }) === 2);
  });
  test('Dict.findKey', function(assert){
    var findKey, obj, ctx;
    findKey = Dict.findKey;
    assert.isFunction(findKey);
    findKey(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      return assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(findKey({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return it === 2;
    }) === 'w');
  });
  test('Dict.forEach', function(assert){
    var forEach, obj, ctx, rez;
    forEach = Dict.forEach;
    assert.isFunction(forEach);
    forEach(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    rez = {};
    forEach({
      q: 1,
      w: 2
    }, function(){
      rez[arguments[1]] = arguments[0] + this;
    }, '_');
    assert.deepEqual(rez, {
      q: '1_',
      w: '2_'
    });
    rez = true;
    forEach(obj = {
      q: 1,
      w: 2
    }, function(){
      var rez;
      rez && (rez = obj === arguments[2]);
    });
    assert.ok(rez);
    rez = {};
    forEach(Object.make({
      e: 3
    }, {
      q: 1,
      w: 2
    }), function(){
      rez[arguments[1]] = arguments[0];
    });
    assert.ok(!('e' in rez));
    rez = {};
    forEach([1, 2], function(){
      rez[arguments[1]] = arguments[0];
    });
    assert.ok(!('length' in rez));
    rez = {};
    forEach('123', function(){
      rez[arguments[1]] = arguments[0];
    });
    assert.ok('2' in rez);
  });
  test('Dict.keyOf', function(assert){
    var keyOf;
    keyOf = Dict.keyOf;
    assert.isFunction(keyOf);
    assert.ok(keyOf({
      q: 1,
      w: 2,
      e: 3
    }, 2) === 'w');
    assert.ok(keyOf({
      q: 1,
      w: 2,
      e: 3
    }, 4) === void 8);
    assert.ok(keyOf({
      q: 1,
      w: 2,
      e: NaN
    }, NaN) === void 8);
  });
  test('Dict.map', function(assert){
    var map, obj, ctx;
    map = Dict.map;
    assert.isFunction(map);
    map(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.deepEqual(map({
      q: 1,
      w: 2,
      e: 3
    }, (function(it){
      return Math.pow(it, 2);
    })), Dict({
      q: 1,
      w: 4,
      e: 9
    }));
  });
  test('Dict.mapPairs', function(assert){
    var mapPairs, obj, ctx;
    mapPairs = Dict.mapPairs;
    assert.isFunction(mapPairs);
    mapPairs(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.deepEqual(mapPairs({
      q: 1,
      w: 2,
      e: 3
    }, function(v, k){
      return v !== 2 && [k + k, v * v];
    }), Dict({
      qq: 1,
      ee: 9
    }));
  });
  test('Dict.reduce', function(assert){
    var reduce, obj, foo, memo;
    reduce = Dict.reduce;
    assert.isFunction(reduce);
    reduce(obj = {
      a: 1
    }, function(memo, val, key, that){
      assert.ok(memo === foo);
      assert.ok(val === 1);
      assert.ok(key === 'a');
      assert.ok(that === obj);
    }, foo = {});
    reduce({
      a: 1,
      b: 2
    }, function(memo, val, key){
      assert.ok(memo === 1);
      assert.ok(val === 2);
      return assert.ok(key === 'b');
    });
    reduce({
      q: 1,
      w: 2,
      e: 3
    }, function(that, it){
      that[it] = it;
      return that;
    }, memo = {});
    assert.deepEqual(memo, {
      1: 1,
      2: 2,
      3: 3
    });
  });
  test('Dict.some', function(assert){
    var some, obj, ctx;
    some = Dict.some;
    assert.isFunction(some);
    some(obj = {
      q: 1
    }, function(val, key, that){
      assert.ok(val === 1);
      assert.ok(key === 'q');
      assert.ok(that === obj);
      assert.ok(this === ctx);
    }, ctx = {});
    assert.ok(!some({
      q: 1,
      w: 2,
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
    assert.ok(some({
      q: 1,
      w: '2',
      e: 3
    }, function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
  });
  test('Dict.includes', function(assert){
    var includes, dict, o;
    includes = Dict.includes;
    assert.isFunction(includes);
    dict = {
      q: 1,
      w: NaN,
      e: -0,
      r: o = {}
    };
    assert.ok(includes(dict, 1));
    assert.ok(includes(dict, -0));
    assert.ok(includes(dict, 0));
    assert.ok(includes(dict, NaN));
    assert.ok(includes(dict, o));
    assert.ok(!includes(dict, 4));
    assert.ok(!includes(dict, -0.5));
    assert.ok(!includes(dict, {}));
  });
  test('Dict.has', function(assert){
    var has;
    has = Dict.has;
    assert.isFunction(has);
    assert.ok(has({
      q: 1
    }, 'q'));
    assert.ok(!has({
      q: 1
    }, 'w'));
    assert.ok(has([1], 0));
    assert.ok(!has([], 0));
    assert.ok(!has(clone$({
      q: 1
    }), 'q'));
    assert.ok(!has({}, 'toString'));
  });
  test('Dict.get', function(assert){
    var get;
    get = Dict.get;
    assert.isFunction(get);
    assert.ok(get({
      q: 1
    }, 'q') === 1);
    assert.ok(get({
      q: 1
    }, 'w') === void 8);
    assert.ok(get([1], 0) === 1);
    assert.ok(get([], 0) === void 8);
    assert.ok(get(clone$({
      q: 1
    }), 'q') === void 8);
    assert.ok(get({}, 'toString') === void 8);
  });
  test('Dict.values', function(assert){
    var values, iter;
    values = Dict.values;
    assert.isFunction(values);
    iter = values({});
    assert.ok(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8] === 'Dict Iterator');
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(from(values({
      q: 1,
      w: 2,
      e: 3
    })), [1, 2, 3]);
    assert.deepEqual(from(values(new String('qwe'))), ['q', 'w', 'e']);
    assert.deepEqual(from(values(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    }))), [4, 5, 6]);
  });
  test('Dict.keys', function(assert){
    var keys, iter;
    keys = Dict.keys;
    assert.isFunction(keys);
    iter = keys({});
    assert.ok(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8] === 'Dict Iterator');
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(from(keys({
      q: 1,
      w: 2,
      e: 3
    })), ['q', 'w', 'e']);
    assert.deepEqual(from(keys(new String('qwe'))), ['0', '1', '2']);
    assert.deepEqual(from(keys(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    }))), ['a', 's', 'd']);
  });
  test('Dict.entries', function(assert){
    var entries, iter;
    entries = Dict.entries;
    assert.isFunction(entries);
    iter = entries({});
    assert.ok(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8] === 'Dict Iterator');
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(from(entries({
      q: 1,
      w: 2,
      e: 3
    })), [['q', 1], ['w', 2], ['e', 3]]);
    assert.deepEqual(from(entries(new String('qwe'))), [['0', 'q'], ['1', 'w'], ['2', 'e']]);
    assert.deepEqual(from(entries(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    }))), [['a', 4], ['s', 5], ['d', 6]]);
  });
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Function#part', function(assert){
    var obj, $, fn, part;
    assert.isFunction(Function.prototype.part);
    assert.ok(function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }.part('qwe')());
    obj = {
      a: 42
    };
    obj.fn = function(it){
      return this.a + it;
    }.part(21);
    assert.ok(obj.fn() === 63);
    $ = _;
    fn = function(){
      return Array.prototype.map.call(arguments, String).join(' ');
    };
    part = fn.part($, 'Саша', $, 'шоссе', $, 'сосала');
    assert.isFunction(part, '.part with placeholders return function');
    assert.ok(part('Шла', 'по') === 'Шла Саша по шоссе undefined сосала', '.part with placeholders: args < placeholders');
    assert.ok(part('Шла', 'по', 'и') === 'Шла Саша по шоссе и сосала', '.part with placeholders: args == placeholders');
    assert.ok(part('Шла', 'по', 'и', 'сушку') === 'Шла Саша по шоссе и сосала сушку', '.part with placeholders: args > placeholders');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, from;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  from = Array.from;
  test('core.getIteratorMethod', function(assert){
    var getIteratorMethod, iterable, iterFn;
    getIteratorMethod = core.getIteratorMethod;
    assert.isFunction(getIteratorMethod);
    iterable = createIterable([]);
    iterFn = getIteratorMethod(iterable);
    assert.isFunction(iterFn);
    assert.isIterator(iterFn.call(iterable));
    assert.isFunction(getIteratorMethod([]));
    assert.isFunction(getIteratorMethod(function(){
      return arguments;
    }()));
    assert.isFunction(getIteratorMethod(Array.prototype));
    assert.isFunction(getIteratorMethod(String.prototype));
    assert.strictEqual(getIteratorMethod({}), void 8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, from;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  from = Array.from;
  test('core.getIterator', function(assert){
    var getIterator;
    getIterator = core.getIterator;
    assert.isFunction(getIterator);
    assert.isIterator(getIterator([]));
    assert.isIterator(getIterator(function(){
      return arguments;
    }()));
    assert.isIterator(getIterator(createIterable([])));
    assert.throws(function(){
      getIterator({});
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('core.isIterable', function(assert){
    var isIterable;
    isIterable = core.isIterable;
    assert.isFunction(isIterable);
    assert.ok(isIterable(createIterable([])));
    assert.ok(isIterable([]));
    assert.ok(isIterable(function(){
      return arguments;
    }()));
    assert.ok(isIterable(Array.prototype));
    assert.ok(isIterable(String.prototype));
    assert.ok(!isIterable({}));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Number#@@iterator', function(assert){
    var iterator, toStringTag, iter1, iter2, iter3, iter4, iter5, iter6;
    iterator = Symbol.iterator, toStringTag = Symbol.toStringTag;
    assert.isIterable(Number.prototype);
    iter1 = 2[iterator]();
    assert.isIterator(iter1);
    assert.isIterable(iter1);
    assert.ok(iter1[toStringTag] === 'Number Iterator', '@@toStringTag');
    assert.deepEqual(iter1.next(), {
      done: false,
      value: 0
    }, '2 #1');
    assert.deepEqual(iter1.next(), {
      done: false,
      value: 1
    }, '2 #2');
    assert.deepEqual(iter1.next(), {
      done: true,
      value: void 8
    }, '2 #3');
    iter2 = 1.5[iterator]();
    assert.deepEqual(iter2.next(), {
      done: false,
      value: 0
    }, '1.5 #1');
    assert.deepEqual(iter2.next(), {
      done: false,
      value: 1
    }, '1.5 #2');
    assert.deepEqual(iter2.next(), {
      done: true,
      value: void 8
    }, '1.5 #3');
    iter3 = (-1)[iterator]();
    assert.deepEqual(iter3.next(), {
      done: true,
      value: void 8
    }, '-1');
    iter4 = NaN[iterator]();
    assert.deepEqual(iter4.next(), {
      done: true,
      value: void 8
    }, 'NaN');
    iter5 = Infinity[iterator]();
    assert.deepEqual(iter5.next(), {
      done: false,
      value: 0
    }, 'Infinity #1');
    assert.deepEqual(iter5.next(), {
      done: false,
      value: 1
    }, 'Infinity #1');
    assert.deepEqual(iter5.next(), {
      done: false,
      value: 2
    }, 'Infinity #1');
    iter6 = (-Infinity)[iterator]();
    assert.deepEqual(iter6.next(), {
      done: true,
      value: void 8
    }, '-Infinity');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.classof', function(assert){
    var classof, Class;
    classof = Object.classof;
    assert.isFunction(classof);
    assert.ok(classof(void 8) === 'Undefined', 'classof undefined is `Undefined`');
    assert.ok(classof(null) === 'Null', 'classof null is `Null`');
    assert.ok(classof(true) === 'Boolean', 'classof bool is `Boolean`');
    assert.ok(classof('string') === 'String', 'classof string is `String`');
    assert.ok(classof(7) === 'Number', 'classof number is `Number`');
    assert.ok(classof(Symbol()) === 'Symbol', 'classof symbol is `Symbol`');
    assert.ok(classof(new Boolean(false)) === 'Boolean', 'classof new Boolean is `Boolean`');
    assert.ok(classof(new String('')) === 'String', 'classof new String is `String`');
    assert.ok(classof(new Number(7)) === 'Number', 'classof new Number is `Number`');
    assert.ok(classof({}) === 'Object', 'classof {} is `Object`');
    assert.ok(classof([]) === 'Array', 'classof array is `Array`');
    assert.ok(classof(function(){}) === 'Function', 'classof function is `Function`');
    assert.ok(classof(/./) === 'RegExp', 'classof regexp is `Undefined`');
    assert.ok(classof(TypeError()) === 'Error', 'classof new TypeError is `RegExp`');
    assert.ok(classof(function(){
      return arguments;
    }()) === 'Arguments', 'classof arguments list is `Arguments`');
    assert.ok(classof(new Set) === 'Set', 'classof undefined is `Map`');
    assert.ok(classof(new Map) === 'Map', 'classof map is `Undefined`');
    assert.ok(classof(new WeakSet) === 'WeakSet', 'classof weakset is `WeakSet`');
    assert.ok(classof(new WeakMap) === 'WeakMap', 'classof weakmap is `WeakMap`');
    assert.ok(classof(new Promise(function(){})) === 'Promise', 'classof promise is `Promise`');
    assert.ok(classof(''[Symbol.iterator]()) === 'String Iterator', 'classof String Iterator is `String Iterator`');
    assert.ok(classof([].entries()) === 'Array Iterator', 'classof Array Iterator is `Array Iterator`');
    assert.ok(classof(new Set().entries()) === 'Set Iterator', 'classof Set Iterator is `Set Iterator`');
    assert.ok(classof(new Map().entries()) === 'Map Iterator', 'classof Map Iterator is `Map Iterator`');
    assert.ok(classof(Math) === 'Math', 'classof Math is `Math`');
    if (typeof JSON != 'undefined' && JSON !== null) {
      assert.ok(classof(JSON) === 'JSON', 'classof JSON is `JSON`');
    }
    Class = (function(){
      Class.displayName = 'Class';
      var prototype = Class.prototype, constructor = Class;
      Class.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8] = 'Class';
      function Class(){}
      return Class;
    }());
    assert.ok(classof(new Class) === 'Class', 'classof user class is [Symbol.toStringTag]');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.define', function(assert){
    var define, defineProperty, foo, foo2;
    define = Object.define, defineProperty = Object.defineProperty;
    assert.isFunction(define);
    foo = {
      q: 1
    };
    assert.ok(foo === define(foo, {
      w: 2
    }));
    assert.ok(foo.w === 2);
    if (DESCRIPTORS) {
      foo = {
        q: 1
      };
      foo2 = defineProperty({}, 'w', {
        get: function(){
          return this.q + 1;
        }
      });
      define(foo, foo2);
      assert.ok(foo.w === 2);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.isObject', function(assert){
    var isObject;
    isObject = Object.isObject;
    assert.isFunction(isObject);
    assert.ok(!isObject(void 8), 'isObject undefined return false');
    assert.ok(!isObject(null), 'isObject null return false');
    assert.ok(!isObject(1), 'isObject number return false');
    assert.ok(!isObject(true), 'isObject bool return false');
    assert.ok(!isObject('string'), 'isObject string return false');
    assert.ok(isObject(new Number(1)), 'isObject new Number return true');
    assert.ok(isObject(new Boolean(false)), 'isObject new Boolean return true');
    assert.ok(isObject(new String(1)), 'isObject new String return true');
    assert.ok(isObject({}), 'isObject object return true');
    assert.ok(isObject([]), 'isObject array return true');
    assert.ok(isObject(/./), 'isObject regexp return true');
    assert.ok(isObject(function(){}), 'isObject function return true');
    assert.ok(isObject(new function(){}), 'isObject constructor instance return true');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('Object.make', function(assert){
    var make, object, foo;
    make = Object.make;
    assert.isFunction(make);
    object = make(foo = {
      q: 1
    }, {
      w: 2
    });
    assert.ok(Object.getPrototypeOf(object) === foo);
    assert.ok(object.w === 2);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('RegExp.escape', function(assert){
    var escape;
    escape = RegExp.escape;
    assert.isFunction(escape);
    assert.arity(escape, 1);
    assert.name(escape, 'escape');
    assert.looksNative(escape);
    assert.strictEqual(escape('qwe asd'), 'qwe asd', "Don't change simple string");
    assert.strictEqual(escape('\\[]{}()*+?.^$|'), '\\\\\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\^\\$\\|', 'Escape all RegExp special chars');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('String#escapeHTML', function(assert){
    assert.isFunction(String.prototype.escapeHTML);
    assert.arity(String.prototype.escapeHTML, 0);
    assert.name(String.prototype.escapeHTML, 'escapeHTML');
    assert.looksNative(String.prototype.escapeHTML);
    assert.strictEqual('qwe, asd'.escapeHTML(), 'qwe, asd');
    assert.strictEqual('<div>qwe</div>'.escapeHTML(), '&lt;div&gt;qwe&lt;/div&gt;');
    assert.strictEqual("&<>\"'".escapeHTML(), '&amp;&lt;&gt;&quot;&apos;');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('core-js');
  test('String#unescapeHTML', function(assert){
    assert.isFunction(String.prototype.unescapeHTML);
    assert.arity(String.prototype.unescapeHTML, 0);
    assert.name(String.prototype.unescapeHTML, 'unescapeHTML');
    assert.looksNative(String.prototype.unescapeHTML);
    assert.strictEqual('qwe, asd'.unescapeHTML(), 'qwe, asd');
    assert.strictEqual('&lt;div&gt;qwe&lt;/div&gt;'.unescapeHTML(), '<div>qwe</div>');
    assert.strictEqual('&amp;&lt;&gt;&quot;&apos;'.unescapeHTML(), "&<>\"'");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#copyWithin', function(assert){
    var a;
    assert.isFunction(Array.prototype.copyWithin);
    assert.arity(Array.prototype.copyWithin, 2);
    assert.name(Array.prototype.copyWithin, 'copyWithin');
    assert.looksNative(Array.prototype.copyWithin);
    assert.strictEqual(a = [1].copyWithin(0), a);
    assert.nonEnumerable(Array.prototype, 'copyWithin');
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(0, 3), [4, 5, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(1, 3), [1, 4, 5, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(1, 2), [1, 3, 4, 5, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(2, 2), [1, 2, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(0, 3, 4), [4, 2, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(1, 3, 4), [1, 4, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(1, 2, 4), [1, 3, 4, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(0, -2), [4, 5, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(0, -2, -1), [4, 2, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(-4, -3, -2), [1, 3, 3, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(-4, -3, -1), [1, 3, 4, 4, 5]);
    assert.deepEqual([1, 2, 3, 4, 5].copyWithin(-4, -3), [1, 3, 4, 5, 5]);
    if (STRICT) {
      assert.throws(function(){
        return Array.prototype.copyWithin.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        return Array.prototype.copyWithin.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE) {
      assert.deepEqual(Array.prototype.copyWithin.call({
        0: 1,
        1: 2,
        2: 3,
        length: -1
      }, 1, 2), {
        0: 1,
        1: 2,
        2: 3,
        length: -1
      }, 'uses ToLength');
    }
    assert.ok('copyWithin' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#every', function(assert){
    var a, ctx, rez, arr;
    assert.isFunction(Array.prototype.every);
    assert.arity(Array.prototype.every, 1);
    assert.name(Array.prototype.every, 'every');
    assert.looksNative(Array.prototype.every);
    assert.nonEnumerable(Array.prototype, 'every');
    (a = [1]).every(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.ok([1, 2, 3].every(function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
    assert.ok([1, 2, 3].every((function(it){
      return it < 4;
    })));
    assert.ok(![1, 2, 3].every((function(it){
      return it < 3;
    })));
    assert.ok(![1, 2, 3].every(function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
    assert.ok([1, 2, 3].every(function(){
      return +this === 1;
    }, 1));
    rez = '';
    [1, 2, 3].every(function(){
      return rez += arguments[1];
    });
    assert.ok(rez === '012');
    assert.ok((arr = [1, 2, 3]).every(function(){
      return arguments[2] === arr;
    }));
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.every.call(null, function(){});
      }, TypeError);
      assert.throws(function(){
        Array.prototype.every.call(void 8, function(){});
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return true === Array.prototype.every.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#fill', function(assert){
    var a;
    assert.isFunction(Array.prototype.fill);
    assert.arity(Array.prototype.fill, 1);
    assert.name(Array.prototype.fill, 'fill');
    assert.looksNative(Array.prototype.fill);
    assert.nonEnumerable(Array.prototype, 'fill');
    assert.strictEqual(a = Array(5).fill(5), a);
    assert.deepEqual(Array(5).fill(5), [5, 5, 5, 5, 5]);
    assert.deepEqual(Array(5).fill(5, 1), [void 8, 5, 5, 5, 5]);
    assert.deepEqual(Array(5).fill(5, 1, 4), [void 8, 5, 5, 5, void 8]);
    assert.deepEqual(Array(5).fill(5, 6, 1), [void 8, void 8, void 8, void 8, void 8]);
    assert.deepEqual(Array(5).fill(5, -3, 4), [void 8, void 8, 5, 5, void 8]);
    if (STRICT) {
      assert.throws(function(){
        return Array.prototype.fill.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        return Array.prototype.fill.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return Array.prototype.fill.call(Object.defineProperty({
            length: -1
          }, 0, {
            set: function(){
              throw Error();
            }
          }));
        } catch (e$) {}
      }()), 'uses ToLength');
    }
    assert.ok('fill' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#filter', function(assert){
    var a, ctx;
    assert.isFunction(Array.prototype.filter);
    assert.arity(Array.prototype.filter, 1);
    assert.name(Array.prototype.filter, 'filter');
    assert.looksNative(Array.prototype.filter);
    assert.nonEnumerable(Array.prototype, 'filter');
    (a = [1]).filter(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.deepEqual([1, 2, 3, 4, 5], [1, 2, 3, 'q', {}, 4, true, 5].filter(function(it){
      return typeof it === 'number';
    }));
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.filter.call(null, function(){});
      }, TypeError);
      assert.throws(function(){
        Array.prototype.filter.call(void 8, function(){});
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return Array.prototype.filter.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#findIndex', function(assert){
    var a, ctx;
    assert.isFunction(Array.prototype.findIndex);
    assert.arity(Array.prototype.findIndex, 1);
    assert.name(Array.prototype.findIndex, 'findIndex');
    assert.looksNative(Array.prototype.findIndex);
    assert.nonEnumerable(Array.prototype, 'findIndex');
    (a = [1]).findIndex(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.same([1, 3, NaN, 42, {}].findIndex((function(it){
      return it === 42;
    })), 3);
    assert.same([1, 3, NaN, 42, {}].findIndex((function(it){
      return it === 43;
    })), -1);
    if (STRICT) {
      assert.throws(function(){
        return Array.prototype.findIndex.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        return Array.prototype.findIndex.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return -1 === Array.prototype.findIndex.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
    assert.ok('findIndex' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#find', function(assert){
    var a, ctx;
    assert.isFunction(Array.prototype.find);
    assert.arity(Array.prototype.find, 1);
    assert.name(Array.prototype.find, 'find');
    assert.looksNative(Array.prototype.find);
    assert.nonEnumerable(Array.prototype, 'find');
    (a = [1]).find(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.same([1, 3, NaN, 42, {}].find((function(it){
      return it === 42;
    })), 42);
    assert.same([1, 3, NaN, 42, {}].find((function(it){
      return it === 43;
    })), void 8);
    if (STRICT) {
      assert.throws(function(){
        return Array.prototype.find.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        return Array.prototype.find.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return void 8 === Array.prototype.find.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
    assert.ok('find' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#forEach', function(assert){
    var a, ctx, rez, arr;
    assert.isFunction(Array.prototype.forEach);
    assert.arity(Array.prototype.forEach, 1);
    assert.name(Array.prototype.forEach, 'forEach');
    assert.looksNative(Array.prototype.forEach);
    assert.nonEnumerable(Array.prototype, 'forEach');
    (a = [1]).forEach(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    rez = '';
    [1, 2, 3].forEach(function(it){
      rez += it;
    });
    assert.ok(rez === '123');
    rez = '';
    [1, 2, 3].forEach(function(){
      rez += arguments[1];
    });
    assert.ok(rez === '012');
    rez = '';
    [1, 2, 3].forEach(function(){
      rez += arguments[2];
    });
    assert.ok(rez === '1,2,31,2,31,2,3');
    rez = '';
    [1, 2, 3].forEach(function(){
      rez += this;
    }, 1);
    assert.ok(rez === '111');
    rez = '';
    arr = [];
    arr[5] = '';
    arr.forEach(function(arg$, k){
      rez += k;
    });
    assert.ok(rez === '5');
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.forEach.call(null, function(){});
      }, TypeError);
      assert.throws(function(){
        Array.prototype.forEach.call(void 8, function(){});
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return void 8 === Array.prototype.forEach.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array.from', function(assert){
    var from, isArray, defineProperty, iterator, type, ref$, col, ctx, i$, x$, len$, y$, done, iter, F, inst, a, array, called;
    from = Array.from, isArray = Array.isArray;
    defineProperty = Object.defineProperty;
    iterator = typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.name(from, 'from');
    assert.looksNative(from);
    assert.nonEnumerable(Array, 'from');
    for (type in ref$ = {
      'array-like': {
        length: '3',
        0: '1',
        1: '2',
        2: '3'
      },
      arguments: fn$('1', '2', '3'),
      array: ['1', '2', '3'],
      iterable: createIterable(['1', '2', '3']),
      string: '123'
    }) {
      col = ref$[type];
      assert.arrayEqual(from(col), ['1', '2', '3'], "Works with " + type);
      assert.arrayEqual(from(col, (fn1$)), [1, 4, 9], "Works with " + type + "  + mapFn");
    }
    for (type in ref$ = {
      'array-like': {
        length: 1,
        0: 1
      },
      arguments: fn2$(1),
      array: [1],
      iterable: createIterable([1]),
      string: '1'
    }) {
      col = ref$[type];
      assert.arrayEqual(from(col, fn3$, ctx = {}), [42], "Works with " + type + ", correct result");
    }
    for (i$ = 0, len$ = (ref$ = [false, true, 0]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.arrayEqual(from(x$), [], "Works with " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.throws(fn4$, TypeError, "Throws on " + y$);
    }
    assert.arrayEqual(from('𠮷𠮷𠮷'), ['𠮷', '𠮷', '𠮷'], 'Uses correct string iterator');
    done = true;
    iter = createIterable([1, 2, 3], {
      'return': function(){
        return done = false;
      }
    });
    from(iter, function(){
      return false;
    });
    assert.ok(done, '.return #default');
    done = false;
    iter = createIterable([1, 2, 3], {
      'return': function(){
        return done = true;
      }
    });
    try {
      from(iter, function(){
        throw 42;
      });
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    F = function(){};
    inst = from.call(F, createIterable([1, 2]));
    assert.ok(inst instanceof F, 'generic, iterable case, instanceof');
    assert.arrayEqual(inst, [1, 2], 'generic, iterable case, elements');
    inst = from.call(F, {
      0: 1,
      1: 2,
      length: 2
    });
    assert.ok(inst instanceof F, 'generic, array-like case, instanceof');
    assert.arrayEqual(inst, [1, 2], 'generic, array-like case, elements');
    a = [1, 2, 3];
    done = false;
    a['@@iterator'] = void 8;
    a[iterator] = function(){
      done = true;
      return [][iterator].call(this);
    };
    assert.arrayEqual(from(a), [1, 2, 3], 'Array with custom iterator, elements');
    assert.ok(done, 'call @@iterator in Array with custom iterator');
    array = [1, 2, 3];
    delete array[1];
    assert.arrayEqual(from(array, String), ['1', 'undefined', '3'], 'Ignores holes');
    assert.ok((function(){
      try {
        return from({
          length: -1,
          0: 1
        }, function(){
          throw 42;
        });
      } catch (e$) {}
    }()), 'Uses ToLength');
    assert.arrayEqual(from([], undefined), [], "Works with undefined as second argument");
    assert.throws(function(){
      from([], null);
    }, TypeError, "Throws with null as second argument");
    assert.throws(function(){
      from([], 0);
    }, TypeError, "Throws with 0 as second argument");
    assert.throws(function(){
      from([], '');
    }, TypeError, "Throws with '' as second argument");
    assert.throws(function(){
      from([], false);
    }, TypeError, "Throws with false as second argument");
    assert.throws(function(){
      from([], {});
    }, TypeError, "Throws with {} as second argument");
    if (DESCRIPTORS) {
      called = false;
      F = function(){};
      defineProperty(F.prototype, 0, {
        set: function(){
          var called;
          called = true;
        }
      });
      from.call(F, [1, 2, 3]);
      assert.ok(!called, 'Should not call prototype accessors');
    }
    function fn$(){
      return arguments;
    }
    function fn1$(it){
      return Math.pow(it, 2);
    }
    function fn2$(){
      return arguments;
    }
    function fn3$(val, key){
      assert.same(this, ctx, "Works with " + type + ", correct callback context");
      assert.same(val, type === 'string' ? '1' : 1, "Works with " + type + ", correct callback key");
      assert.same(key, 0, "Works with " + type + ", correct callback value");
      assert.same(arguments.length, 2, "Works with " + type + ", correct callback arguments number");
      return 42;
    }
    function fn4$(){
      from(y$);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#indexOf', function(assert){
    assert.isFunction(Array.prototype.indexOf);
    assert.arity(Array.prototype.indexOf, 1);
    assert.name(Array.prototype.indexOf, 'indexOf');
    assert.looksNative(Array.prototype.indexOf);
    assert.nonEnumerable(Array.prototype, 'indexOf');
    assert.same(0, [1, 1, 1].indexOf(1));
    assert.same(-1, [1, 2, 3].indexOf(1, 1));
    assert.same(1, [1, 2, 3].indexOf(2, 1));
    assert.same(-1, [1, 2, 3].indexOf(2, -1));
    assert.same(1, [1, 2, 3].indexOf(2, -2));
    assert.same(-1, [NaN].indexOf(NaN));
    assert.same(3, Array(2).concat([1, 2, 3]).indexOf(2));
    assert.same(-1, Array(1).indexOf(void 8));
    assert.same(0, [1].indexOf(1, -0), "shouldn't return negative zero");
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.indexOf.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        Array.prototype.indexOf.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return -1 === Array.prototype.indexOf.call(Object.defineProperty({
            length: -1
          }, 0, {
            get: function(){
              throw Error();
            }
          }), 1);
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array.isArray', function(assert){
    var isArray;
    isArray = Array.isArray;
    assert.isFunction(isArray);
    assert.arity(isArray, 1);
    assert.name(isArray, 'isArray');
    assert.looksNative(isArray);
    assert.nonEnumerable(Array, 'isArray');
    assert.ok(!isArray({}));
    assert.ok(!isArray(function(){
      return arguments;
    }()));
    assert.ok(isArray([]));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#keys', function(assert){
    var iter;
    assert.isFunction(Array.prototype.keys);
    assert.arity(Array.prototype.keys, 0);
    assert.name(Array.prototype.keys, 'keys');
    assert.looksNative(Array.prototype.keys);
    assert.nonEnumerable(Array.prototype, 'keys');
    iter = ['q', 'w', 'e'].keys();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: 0,
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 1,
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 2,
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
    if (NATIVE) {
      assert.deepEqual(Array.prototype.keys.call({
        length: -1
      }).next(), {
        value: void 8,
        done: true
      }, 'uses ToLength');
    }
    assert.ok('keys' in Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.unscopables : void 8], 'In Array#@@unscopables');
  });
  test('Array#values', function(assert){
    var iter;
    assert.isFunction(Array.prototype.values);
    assert.arity(Array.prototype.values, 0);
    assert.name(Array.prototype.values, 'values');
    assert.looksNative(Array.prototype.values);
    assert.nonEnumerable(Array.prototype, 'values');
    iter = ['q', 'w', 'e'].values();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
    if (NATIVE) {
      assert.deepEqual(Array.prototype.values.call({
        length: -1
      }).next(), {
        value: void 8,
        done: true
      }, 'uses ToLength');
    }
    assert.ok('values' in Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.unscopables : void 8], 'In Array#@@unscopables');
  });
  test('Array#entries', function(assert){
    var iter;
    assert.isFunction(Array.prototype.entries);
    assert.arity(Array.prototype.entries, 0);
    assert.name(Array.prototype.entries, 'entries');
    assert.looksNative(Array.prototype.entries);
    assert.nonEnumerable(Array.prototype, 'entries');
    iter = ['q', 'w', 'e'].entries();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: [0, 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: [1, 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: [2, 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
    if (NATIVE) {
      assert.deepEqual(Array.prototype.entries.call({
        length: -1
      }).next(), {
        value: void 8,
        done: true
      }, 'uses ToLength');
    }
    assert.ok('entries' in Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.unscopables : void 8], 'In Array#@@unscopables');
  });
  test('Array#@@iterator', function(assert){
    var iter;
    assert.isIterable(Array.prototype);
    assert.arity(Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], 0);
    assert.name(Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], 'values');
    assert.looksNative(Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]);
    assert.nonEnumerable(Array.prototype, typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8);
    assert.strictEqual(Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], Array.prototype.values);
    iter = ['q', 'w', 'e'][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
    if (NATIVE) {
      assert.deepEqual(Array.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call({
        length: -1
      }).next(), {
        value: void 8,
        done: true
      }, 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#join', function(assert){
    assert.isFunction(Array.prototype.join);
    assert.arity(Array.prototype.join, 1);
    assert.name(Array.prototype.join, 'join');
    assert.looksNative(Array.prototype.join);
    assert.nonEnumerable(Array.prototype, 'join');
    assert.strictEqual(Array.prototype.join.call([1, 2, 3], void 8), '1,2,3');
    assert.strictEqual(Array.prototype.join.call('123'), '1,2,3');
    assert.strictEqual(Array.prototype.join.call('123', '|'), '1|2|3');
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.join.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        Array.prototype.join.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#lastIndexOf', function(assert){
    assert.isFunction(Array.prototype.lastIndexOf);
    assert.arity(Array.prototype.lastIndexOf, 1);
    assert.name(Array.prototype.lastIndexOf, 'lastIndexOf');
    assert.looksNative(Array.prototype.lastIndexOf);
    assert.nonEnumerable(Array.prototype, 'lastIndexOf');
    assert.same(2, [1, 1, 1].lastIndexOf(1));
    assert.same(-1, [1, 2, 3].lastIndexOf(3, 1));
    assert.same(1, [1, 2, 3].lastIndexOf(2, 1));
    assert.same(-1, [1, 2, 3].lastIndexOf(2, -3));
    assert.same(-1, [1, 2, 3].lastIndexOf(1, -4));
    assert.same(1, [1, 2, 3].lastIndexOf(2, -2));
    assert.same(-1, [NaN].lastIndexOf(NaN));
    assert.same(1, [1, 2, 3].concat(Array(2)).lastIndexOf(2));
    assert.same(0, [1].lastIndexOf(1, -0), "shouldn't return negative zero");
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.lastIndexOf.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        Array.prototype.lastIndexOf.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return -1 === Array.prototype.lastIndexOf.call(Object.defineProperties({
            length: -1
          }, {
            2147483646: {
              get: function(){
                throw Error();
              }
            },
            4294967294: {
              get: function(){
                throw Error();
              }
            }
          }), 1);
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#map', function(assert){
    var a, ctx;
    assert.isFunction(Array.prototype.map);
    assert.arity(Array.prototype.map, 1);
    assert.name(Array.prototype.map, 'map');
    assert.looksNative(Array.prototype.map);
    assert.nonEnumerable(Array.prototype, 'map');
    (a = [1]).map(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.deepEqual([2, 3, 4], [1, 2, 3].map((function(it){
      return it + 1;
    })));
    assert.deepEqual([1, 3, 5], [1, 2, 3].map(curry$(function(x$, y$){
      return x$ + y$;
    })));
    assert.deepEqual([2, 2, 2], [1, 2, 3].map(function(){
      return +this;
    }, 2));
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.map.call(null, function(){});
      }, TypeError);
      assert.throws(function(){
        Array.prototype.map.call(void 8, function(){});
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return Array.prototype.map.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array.of', function(assert){
    var defineProperty, F, inst, called;
    defineProperty = Object.defineProperty;
    assert.isFunction(Array.of);
    assert.arity(Array.of, 0);
    assert.name(Array.of, 'of');
    assert.looksNative(Array.of);
    assert.nonEnumerable(Array, 'of');
    assert.deepEqual(Array.of(1), [1]);
    assert.deepEqual(Array.of(1, 2, 3), [1, 2, 3]);
    F = function(){};
    inst = Array.of.call(F, 1, 2);
    assert.ok(inst instanceof F);
    assert.strictEqual(inst[0], 1);
    assert.strictEqual(inst[1], 2);
    assert.strictEqual(inst.length, 2);
    if (DESCRIPTORS) {
      called = false;
      F = function(){};
      defineProperty(F.prototype, 0, {
        set: function(){
          var called;
          called = true;
        }
      });
      Array.of.call(F, 1, 2, 3);
      assert.ok(!called, 'Should not call prototype accessors');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#reduceRight', function(assert){
    var a, accumulator, v, k;
    assert.isFunction(Array.prototype.reduceRight);
    assert.arity(Array.prototype.reduceRight, 1);
    assert.name(Array.prototype.reduceRight, 'reduceRight');
    assert.looksNative(Array.prototype.reduceRight);
    assert.nonEnumerable(Array.prototype, 'reduceRight');
    (a = [1]).reduceRight(function(memo, val, key, that){
      assert.same(arguments.length, 4, 'correct number of callback arguments');
      assert.same(memo, accumulator, 'correct callback accumulator');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
    }, accumulator = {});
    assert.same([1, 2, 3].reduceRight(curry$(function(x$, y$){
      return x$ + y$;
    }), 1), 7, 'works with initial accumulator');
    (a = [1, 2]).reduceRight(function(memo, val, key, that){
      assert.same(memo, 2, 'correct default accumulator');
      assert.same(val, 1, 'correct start value without initial accumulator');
      assert.same(key, 0, 'correct start index without initial accumulator');
    });
    assert.same([1, 2, 3].reduceRight(curry$(function(x$, y$){
      return x$ + y$;
    })), 6, 'works without initial accumulator');
    v = '';
    k = '';
    [1, 2, 3].reduceRight(function(memo, a, b){
      v += a;
      k += b;
    }, 0);
    assert.same(v, '321', 'correct order #1');
    assert.same(k, '210', 'correct order #2');
    assert.same(Array.prototype.reduceRight.call({
      0: 1,
      1: 2,
      length: 2
    }, curry$(function(x$, y$){
      return x$ + y$;
    })), 3, 'generic');
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.reduceRight.call(null, function(){}, 1);
      }, TypeError);
      assert.throws(function(){
        Array.prototype.reduceRight.call(void 8, function(){}, 1);
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return Array.prototype.reduceRight.call({
            length: -1,
            2147483646: 0,
            4294967294: 0
          }, function(){
            throw 42;
          }, 1);
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#reduce', function(assert){
    var a, accumulator, v, k;
    assert.isFunction(Array.prototype.reduce);
    assert.arity(Array.prototype.reduce, 1);
    assert.name(Array.prototype.reduce, 'reduce');
    assert.looksNative(Array.prototype.reduce);
    assert.nonEnumerable(Array.prototype, 'reduce');
    (a = [1]).reduce(function(memo, val, key, that){
      assert.same(arguments.length, 4, 'correct number of callback arguments');
      assert.same(memo, accumulator, 'correct callback accumulator');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
    }, accumulator = {});
    assert.same([1, 2, 3].reduce(curry$(function(x$, y$){
      return x$ + y$;
    }), 1), 7, 'works with initial accumulator');
    (a = [1, 2]).reduce(function(memo, val, key, that){
      assert.same(memo, 1, 'correct default accumulator');
      assert.same(val, 2, 'correct start value without initial accumulator');
      assert.same(key, 1, 'correct start index without initial accumulator');
    });
    assert.same([1, 2, 3].reduce(curry$(function(x$, y$){
      return x$ + y$;
    })), 6, 'works without initial accumulator');
    v = '';
    k = '';
    [1, 2, 3].reduce(function(memo, a, b){
      v += a;
      k += b;
    }, 0);
    assert.same(v, '123', 'correct order #1');
    assert.same(k, '012', 'correct order #2');
    assert.same(Array.prototype.reduce.call({
      0: 1,
      1: 2,
      length: 2
    }, curry$(function(x$, y$){
      return x$ + y$;
    })), 3, 'generic');
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.reduce.call(null, function(){}, 1);
      }, TypeError);
      assert.throws(function(){
        Array.prototype.reduce.call(void 8, function(){}, 1);
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return Array.prototype.reduce.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          }, 1);
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#slice', function(assert){
    var arr, str, list, ref$, e;
    assert.isFunction(Array.prototype.slice);
    assert.arity(Array.prototype.slice, 2);
    assert.name(Array.prototype.slice, 'slice');
    assert.looksNative(Array.prototype.slice);
    assert.nonEnumerable(Array.prototype, 'slice');
    arr = ['1', '2', '3', '4', '5'];
    assert.deepEqual(arr.slice(), arr);
    assert.deepEqual(arr.slice(1, 3), ['2', '3']);
    assert.deepEqual(arr.slice(1, void 8), ['2', '3', '4', '5']);
    assert.deepEqual(arr.slice(1, -1), ['2', '3', '4']);
    assert.deepEqual(arr.slice(-2, -1), ['4']);
    assert.deepEqual(arr.slice(-2, -3), []);
    str = '12345';
    assert.deepEqual(Array.prototype.slice.call(str), arr);
    assert.deepEqual(Array.prototype.slice.call(str, 1, 3), ['2', '3']);
    assert.deepEqual(Array.prototype.slice.call(str, 1, void 8), ['2', '3', '4', '5']);
    assert.deepEqual(Array.prototype.slice.call(str, 1, -1), ['2', '3', '4']);
    assert.deepEqual(Array.prototype.slice.call(str, -2, -1), ['4']);
    assert.deepEqual(Array.prototype.slice.call(str, -2, -3), []);
    if (list = typeof document != 'undefined' && document !== null ? (ref$ = document.body) != null ? ref$.childNodes : void 8 : void 8) {
      try {
        assert.strictEqual(toString$.call(Array.prototype.slice.call(list)).slice(8, -1), 'Array');
      } catch (e$) {
        e = e$;
        assert.ok(false);
      }
    }
    if (NATIVE) {
      if (STRICT) {
        assert.throws(function(){
          Array.prototype.slice.call(null);
        }, TypeError);
        assert.throws(function(){
          Array.prototype.slice.call(void 8);
        }, TypeError);
      }
      assert.deepEqual(Array.prototype.slice.call({
        length: -1,
        0: 1
      }, 0, 1), [], 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#some', function(assert){
    var a, ctx, rez, arr;
    assert.isFunction(Array.prototype.some);
    assert.arity(Array.prototype.some, 1);
    assert.name(Array.prototype.some, 'some');
    assert.looksNative(Array.prototype.some);
    assert.nonEnumerable(Array.prototype, 'some');
    (a = [1]).some(function(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }, ctx = {});
    assert.ok([1, '2', 3].some(function(it){
      return toString$.call(it).slice(8, -1) === 'Number';
    }));
    assert.ok([1, 2, 3].some((function(it){
      return it < 3;
    })));
    assert.ok(![1, 2, 3].some((function(it){
      return it < 0;
    })));
    assert.ok(![1, 2, 3].some(function(it){
      return toString$.call(it).slice(8, -1) === 'String';
    }));
    assert.ok(![1, 2, 3].some(function(){
      return +this !== 1;
    }, 1));
    rez = '';
    [1, 2, 3].some(function(){
      rez += arguments[1];
      return false;
    });
    assert.ok(rez === '012');
    assert.ok(!(arr = [1, 2, 3]).some(function(){
      return arguments[2] !== arr;
    }));
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.some.call(null, function(){});
      }, TypeError);
      assert.throws(function(){
        Array.prototype.some.call(void 8, function(){});
      }, TypeError);
    }
    if (NATIVE) {
      assert.ok((function(){
        try {
          return false === Array.prototype.some.call({
            length: -1,
            0: 1
          }, function(){
            throw 42;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Array#sort', function(assert){
    assert.isFunction(Array.prototype.sort);
    assert.arity(Array.prototype.sort, 1);
    assert.name(Array.prototype.sort, 'sort');
    assert.looksNative(Array.prototype.sort);
    assert.nonEnumerable(Array.prototype, 'sort');
    assert.ok(!!(function(){
      try {
        return [1, 2, 3].sort(void 8);
      } catch (e$) {}
    }()), 'works with undefined');
    assert.throws(function(){
      [1, 2, 3].sort(null);
    }, 'throws on null');
    assert.throws(function(){
      [1, 2, 3].sort({});
    }, 'throws on {}');
    if (STRICT) {
      assert.throws(function(){
        return Array.prototype.sort.call(null);
      }, TypeError, 'ToObject(this)');
      assert.throws(function(){
        return Array.prototype.sort.call(void 8);
      }, TypeError, 'ToObject(this)');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date.now', function(assert){
    var now;
    now = Date.now;
    assert.isFunction(now);
    assert.arity(now, 0);
    assert.name(now, 'now');
    assert.looksNative(now);
    assert.nonEnumerable(Date, 'now');
    assert.ok(+new Date - now() < 10, 'Date.now() ~ +new Date');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date#toISOString', function(assert){
    var ft, bc;
    assert.isFunction(Date.prototype.toISOString);
    assert.arity(Date.prototype.toISOString, 0);
    assert.name(Date.prototype.toISOString, 'toISOString');
    assert.looksNative(Date.prototype.toISOString);
    assert.nonEnumerable(Date.prototype, 'toISOString');
    assert.strictEqual(new Date(0).toISOString(), '1970-01-01T00:00:00.000Z');
    assert.strictEqual(new Date(1e12 + 1).toISOString(), '2001-09-09T01:46:40.001Z');
    assert.strictEqual(new Date(-5e13 - 1).toISOString(), '0385-07-25T07:06:39.999Z');
    ft = new Date(1e15 + 1).toISOString();
    assert.ok(ft === '+033658-09-27T01:46:40.001Z' || ft === '33658-09-27T01:46:40.001Z');
    bc = new Date(-1e15 + 1).toISOString();
    assert.ok(bc === '-029719-04-05T22:13:20.001Z' || bc === '-29719-04-05T22:13:20.001Z');
    assert.throws(function(){
      new Date(NaN).toISOString();
    }, RangeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date#toJSON', function(assert){
    var d;
    assert.isFunction(Date.prototype.toJSON);
    assert.arity(Date.prototype.toJSON, 1);
    assert.name(Date.prototype.toJSON, 'toJSON');
    assert.looksNative(Date.prototype.toJSON);
    assert.nonEnumerable(Date.prototype, 'toJSON');
    d = new Date();
    assert.same(d.toJSON(), d.toISOString(), 'base');
    assert.same(new Date(NaN).toJSON(), null, 'not finite');
    assert.same(Date.prototype.toJSON.call({
      toISOString: function(){
        return 42;
      }
    }), 42, 'generic');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date#@@toPrimitive', function(assert){
    var TO_PRIMITIVE, toPrimitive, date, i$, x$, ref$, len$, y$;
    TO_PRIMITIVE = Symbol.toPrimitive;
    toPrimitive = Date.prototype[TO_PRIMITIVE];
    assert.isFunction(toPrimitive);
    assert.arity(toPrimitive, 1);
    assert.nonEnumerable(Object.prototype, TO_PRIMITIVE);
    date = new Date;
    assert.same(date[TO_PRIMITIVE]('string'), date.toString(), 'generic, hint "string"');
    assert.same(date[TO_PRIMITIVE]('number'), +date, 'generic, hint "number"');
    assert.same(date[TO_PRIMITIVE]('default'), date.toString(), 'generic, hint "default"');
    assert.same(toPrimitive.call(Object(2), 'string'), '2', 'generic, hint "string"');
    assert.same(toPrimitive.call(Object(2), 'number'), 2, 'generic, hint "number"');
    assert.same(toPrimitive.call(Object(2), 'default'), '2', 'generic, hint "default"');
    for (i$ = 0, len$ = (ref$ = [
      void 8, '', 'foo', {
        toString: fn$
      }
    ]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + x$ + " as a hint");
    }
    if (STRICT) {
      for (i$ = 0, len$ = (ref$ = [1, false, 'string', null, void 8]).length; i$ < len$; ++i$) {
        y$ = ref$[i$];
        assert.throws(fn2$, TypeError, "throws on " + y$ + " as `this`");
      }
    }
    function fn$(){
      return 'string';
    }
    function fn1$(){
      new Date()[TO_PRIMITIVE](x$);
    }
    function fn2$(){
      toPrimitive.call(y$, 'string');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Date#toString', function(assert){
    assert.isFunction(Date.prototype.toString);
    assert.arity(Date.prototype.toString, 0);
    assert.name(Date.prototype.toString, 'toString');
    assert.looksNative(Date.prototype.toString);
    assert.nonEnumerable(Date.prototype, 'toString');
    assert.same(String(new Date(NaN)), 'Invalid Date');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Function#bind', function(assert){
    var obj, fn, inst, F, date;
    assert.isFunction(Function.prototype.bind);
    assert.arity(Function.prototype.bind, 1);
    assert.name(Function.prototype.bind, 'bind');
    assert.looksNative(Function.prototype.bind);
    assert.nonEnumerable(Function.prototype, 'bind');
    obj = {
      a: 42
    };
    assert.ok(42 === function(){
      return this.a;
    }.bind(obj)());
    assert.ok(void 8 === new (function(){}.bind(obj))().a);
    fn = function(a, b){
      this.a = a;
      this.b = b;
    };
    inst = new (fn.bind(null, 1))(2);
    assert.ok(inst instanceof fn);
    assert.strictEqual(inst.a, 1);
    assert.strictEqual(inst.b, 2);
    assert.ok(42 === function(it){
      return it;
    }.bind(null, 42)());
    fn = RegExp.prototype.test.bind(/a/);
    assert.ok(fn('a'));
    F = Date.bind(null, 2015);
    date = new F(6);
    assert.ok(date instanceof Date);
    assert.strictEqual(date.getFullYear(), 2015);
    assert.strictEqual(date.getMonth(), 6);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Function#@@hasInstance', function(assert){
    assert.ok(Symbol.hasInstance in Function.prototype);
    assert.nonEnumerable(Function.prototype, Symbol.hasInstance);
    assert.ok(Function[Symbol.hasInstance](function(){}));
    assert.ok(!Function[Symbol.hasInstance]({}));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  if (DESCRIPTORS) {
    module = QUnit.module, test = QUnit.test;
    module('ES6');
    test('Function#name', function(assert){
      var fn;
      assert.ok('name' in Function.prototype);
      assert.nonEnumerable(Function.prototype, 'name');
      assert.same((function(){
        function foo(it){
          return it;
        }
        return foo;
      }()).name, 'foo');
      assert.same(function(){}.name, '');
      if (Object.freeze) {
        assert.same(Object.freeze(function(){}).name, '');
      }
      fn = function(){};
      fn.toString = function(){
        throw 42;
      };
      assert.ok((function(){
        try {
          fn.name;
          return true;
        } catch (e$) {}
      }()));
      fn = Object(function(){});
      fn.toString = function(){
        return '';
      };
      assert.same(fn.name, '');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, same, getOwnPropertyDescriptor, freeze;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  same = function(a, b){
    if (a === b) {
      return a !== 0 || 1 / a === 1 / b;
    } else {
      return a != a && b != b;
    }
  };
  getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, freeze = Object.freeze;
  test('Map', function(assert){
    var x$, done, iter, a, o, key, C;
    assert.isFunction(Map);
    assert.arity(Map, 0);
    assert.name(Map, 'Map');
    assert.looksNative(Map);
    assert.ok('clear' in Map.prototype, 'clear in Map.prototype');
    assert.ok('delete' in Map.prototype, 'delete in Map.prototype');
    assert.ok('get' in Map.prototype, 'get in Map.prototype');
    assert.ok('has' in Map.prototype, 'has in Map.prototype');
    assert.ok('set' in Map.prototype, 'set in Map.prototype');
    assert.ok(new Map instanceof Map, 'new Map instanceof Map');
    assert.strictEqual(new Map(createIterable([[1, 1], [2, 2], [3, 3]])).size, 3, 'Init from iterable');
    assert.strictEqual((x$ = new Map(), x$.set(freeze({}), 1), x$.set(2, 3), x$).size, 2, 'Support frozen objects');
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      new Map(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    a = [];
    done = false;
    a[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
      done = true;
      return [][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call(this);
    };
    new Map(a);
    assert.ok(done);
    o = {};
    new Map().set(o, 1);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(Object.keys(o), []);
    }
    assert.arrayEqual(Object.getOwnPropertyNames(o), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(o), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(Map);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof Map, 'correct subclassing with native classes #2');
      assert.same(new C().set(1, 2).get(1), 2, 'correct subclassing with native classes #3');
    }
  });
  test('Map#clear', function(assert){
    var M, x$, y$, f;
    assert.isFunction(Map.prototype.clear);
    assert.arity(Map.prototype.clear, 0);
    assert.name(Map.prototype.clear, 'clear');
    assert.looksNative(Map.prototype.clear);
    assert.nonEnumerable(Map.prototype, 'clear');
    M = new Map;
    M.clear();
    assert.strictEqual(M.size, 0);
    x$ = M = new Map();
    x$.set(1, 2);
    x$.set(2, 3);
    x$.set(1, 4);
    M.clear();
    assert.strictEqual(M.size, 0);
    assert.ok(!M.has(1));
    assert.ok(!M.has(2));
    y$ = M = new Map();
    y$.set(1, 2);
    y$.set(f = freeze({}), 3);
    M.clear();
    assert.strictEqual(M.size, 0, 'Support frozen objects');
    assert.ok(!M.has(1));
    assert.ok(!M.has(f));
  });
  test('Map#delete', function(assert){
    var a, x$, M, f;
    assert.isFunction(Map.prototype['delete']);
    assert.arity(Map.prototype['delete'], 1);
    NATIVE && assert.name(Map.prototype['delete'], 'delete');
    assert.looksNative(Map.prototype['delete']);
    assert.nonEnumerable(Map.prototype, 'delete');
    a = [];
    x$ = M = new Map();
    x$.set(NaN, 1);
    x$.set(2, 1);
    x$.set(3, 1);
    x$.set(2, 5);
    x$.set(1, 4);
    x$.set(a, {});
    assert.strictEqual(M.size, 5);
    assert.ok(M['delete'](NaN));
    assert.strictEqual(M.size, 4);
    assert.ok(!M['delete'](4));
    assert.strictEqual(M.size, 4);
    M['delete']([]);
    assert.strictEqual(M.size, 4);
    M['delete'](a);
    assert.strictEqual(M.size, 3);
    M.set(freeze(f = {}), 42);
    assert.strictEqual(M.size, 4);
    M['delete'](f);
    assert.strictEqual(M.size, 3);
  });
  test('Map#forEach', function(assert){
    var r, T, count, x$, M, a, y$, map, s, z$;
    assert.isFunction(Map.prototype.forEach);
    assert.arity(Map.prototype.forEach, 1);
    assert.name(Map.prototype.forEach, 'forEach');
    assert.looksNative(Map.prototype.forEach);
    assert.nonEnumerable(Map.prototype, 'forEach');
    r = {};
    count = 0;
    x$ = M = new Map();
    x$.set(NaN, 1);
    x$.set(2, 1);
    x$.set(3, 7);
    x$.set(2, 5);
    x$.set(1, 4);
    x$.set(a = {}, 9);
    M.forEach(function(value, key){
      count++;
      r[value] = key;
    });
    assert.strictEqual(count, 5);
    assert.deepEqual(r, {
      1: NaN,
      7: 3,
      5: 2,
      4: 1,
      9: a
    });
    y$ = map = new Map();
    y$.set('0', 9);
    y$.set('1', 9);
    y$.set('2', 9);
    y$.set('3', 9);
    s = "";
    map.forEach(function(value, key){
      s += key;
      if (key === '2') {
        map['delete']('2');
        map['delete']('3');
        map['delete']('1');
        return map.set('4', 9);
      }
    });
    assert.strictEqual(s, '0124');
    z$ = map = new Map();
    z$.set('0', 1);
    s = "";
    map.forEach(function(it){
      map['delete']('0');
      if (s !== '') {
        throw '!!!';
      }
      return s += it;
    });
    assert.strictEqual(s, '1');
    assert.throws(function(){
      Map.prototype.forEach.call(new Set, function(){});
    }, 'non-generic');
  });
  test('Map#get', function(assert){
    var o, f, x$, M;
    assert.isFunction(Map.prototype.get);
    assert.name(Map.prototype.get, 'get');
    assert.arity(Map.prototype.get, 1);
    assert.looksNative(Map.prototype.get);
    assert.nonEnumerable(Map.prototype, 'get');
    o = {};
    f = freeze({});
    x$ = M = new Map();
    x$.set(NaN, 1);
    x$.set(2, 1);
    x$.set(3, 1);
    x$.set(2, 5);
    x$.set(1, 4);
    x$.set(f, 42);
    x$.set(o, o);
    assert.strictEqual(M.get(NaN), 1);
    assert.strictEqual(M.get(4), void 8);
    assert.strictEqual(M.get({}), void 8);
    assert.strictEqual(M.get(o), o);
    assert.strictEqual(M.get(f), 42);
    assert.strictEqual(M.get(2), 5);
  });
  test('Map#has', function(assert){
    var o, f, x$, M;
    assert.isFunction(Map.prototype.has);
    assert.name(Map.prototype.has, 'has');
    assert.arity(Map.prototype.has, 1);
    assert.looksNative(Map.prototype.has);
    assert.nonEnumerable(Map.prototype, 'has');
    o = {};
    f = freeze({});
    x$ = M = new Map();
    x$.set(NaN, 1);
    x$.set(2, 1);
    x$.set(3, 1);
    x$.set(2, 5);
    x$.set(1, 4);
    x$.set(f, 42);
    x$.set(o, o);
    assert.ok(M.has(NaN));
    assert.ok(M.has(o));
    assert.ok(M.has(2));
    assert.ok(M.has(f));
    assert.ok(!M.has(4));
    assert.ok(!M.has({}));
  });
  test('Map#set', function(assert){
    var o, x$, M, chain, y$, f;
    assert.isFunction(Map.prototype.set);
    assert.name(Map.prototype.set, 'set');
    assert.arity(Map.prototype.set, 2);
    assert.looksNative(Map.prototype.set);
    assert.nonEnumerable(Map.prototype, 'set');
    o = {};
    x$ = M = new Map();
    x$.set(NaN, 1);
    x$.set(2, 1);
    x$.set(3, 1);
    x$.set(2, 5);
    x$.set(1, 4);
    x$.set(o, o);
    assert.ok(M.size === 5);
    chain = M.set(7, 2);
    assert.strictEqual(chain, M);
    M.set(7, 2);
    assert.strictEqual(M.size, 6);
    assert.strictEqual(M.get(7), 2);
    assert.strictEqual(M.get(NaN), 1);
    M.set(NaN, 42);
    assert.strictEqual(M.size, 6);
    assert.strictEqual(M.get(NaN), 42);
    M.set({}, 11);
    assert.strictEqual(M.size, 7);
    assert.strictEqual(M.get(o), o);
    M.set(o, 27);
    assert.strictEqual(M.size, 7);
    assert.strictEqual(M.get(o), 27);
    assert.strictEqual((y$ = new Map(), y$.set(NaN, 2), y$.set(NaN, 3), y$.set(NaN, 4), y$).size, 1);
    M = new Map().set(freeze(f = {}), 42);
    assert.strictEqual(M.get(f), 42);
  });
  test('Map#size', function(assert){
    var size, x$, sizeDesc;
    assert.nonEnumerable(Map.prototype, 'size');
    size = (x$ = new Map(), x$.set(2, 1), x$).size;
    assert.strictEqual(typeof size, 'number', 'size is number');
    assert.strictEqual(size, 1, 'size is correct');
    if (DESCRIPTORS) {
      sizeDesc = getOwnPropertyDescriptor(Map.prototype, 'size');
      assert.ok(sizeDesc && sizeDesc.get, 'size is getter');
      assert.ok(sizeDesc && !sizeDesc.set, 'size isnt setter');
      assert.throws(function(){
        return Map.prototype.size;
      }, TypeError);
    }
  });
  test('Map & -0', function(assert){
    var map, x$, y$;
    map = new Map;
    map.set(-0, 1);
    assert.strictEqual(map.size, 1);
    assert.ok(map.has(0));
    assert.ok(map.has(-0));
    assert.strictEqual(map.get(0), 1);
    assert.strictEqual(map.get(-0), 1);
    map.forEach(function(val, key){
      return assert.ok(!same(key, -0));
    });
    map['delete'](-0);
    assert.strictEqual(map.size, 0);
    x$ = map = new Map();
    x$.set(-0, 1);
    map.forEach(function(val, key){
      return assert.ok(!same(key, -0));
    });
    y$ = map = new Map();
    y$.set(4, 4);
    y$.set(3, 3);
    y$.set(2, 2);
    y$.set(1, 1);
    y$.set(0, 0);
    assert.ok(map.has(-0));
  });
  test('Map#@@toStringTag', function(assert){
    assert.strictEqual(Map.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Map', 'Map::@@toStringTag is `Map`');
  });
  test('Map Iterator', function(assert){
    var x$, map, keys, iterator;
    x$ = map = new Map();
    x$.set('a', 1);
    x$.set('b', 2);
    x$.set('c', 3);
    x$.set('d', 4);
    keys = [];
    iterator = map.keys();
    assert.isIterator(iterator);
    assert.isIterable(iterator);
    assert.nonEnumerable(iterator, 'next');
    assert.nonEnumerable(iterator, typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8);
    keys.push(iterator.next().value);
    assert.ok(map['delete']('a'));
    assert.ok(map['delete']('b'));
    assert.ok(map['delete']('c'));
    map.set('e');
    keys.push(iterator.next().value);
    keys.push(iterator.next().value);
    assert.ok(iterator.next().done);
    map.set('f');
    assert.ok(iterator.next().done);
    assert.deepEqual(keys, ['a', 'd', 'e']);
  });
  test('Map#keys', function(assert){
    var iter, x$;
    assert.isFunction(Map.prototype.keys);
    assert.name(Map.prototype.keys, 'keys');
    assert.arity(Map.prototype.keys, 0);
    assert.looksNative(Map.prototype.keys);
    assert.nonEnumerable(Map.prototype, 'keys');
    iter = (x$ = new Map(), x$.set('a', 'q'), x$.set('s', 'w'), x$.set('d', 'e'), x$).keys();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: 'a',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 's',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'd',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Map#values', function(assert){
    var iter, x$;
    assert.isFunction(Map.prototype.values);
    assert.name(Map.prototype.values, 'values');
    assert.arity(Map.prototype.values, 0);
    assert.looksNative(Map.prototype.values);
    assert.nonEnumerable(Map.prototype, 'values');
    iter = (x$ = new Map(), x$.set('a', 'q'), x$.set('s', 'w'), x$.set('d', 'e'), x$).values();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Map#entries', function(assert){
    var iter, x$;
    assert.isFunction(Map.prototype.entries);
    assert.name(Map.prototype.entries, 'entries');
    assert.arity(Map.prototype.entries, 0);
    assert.looksNative(Map.prototype.entries);
    assert.nonEnumerable(Map.prototype, 'entries');
    iter = (x$ = new Map(), x$.set('a', 'q'), x$.set('s', 'w'), x$.set('d', 'e'), x$).entries();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: ['a', 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['s', 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['d', 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Map#@@iterator', function(assert){
    var iter, x$;
    assert.isIterable(Map.prototype);
    assert.name(Map.prototype.entries, 'entries');
    assert.arity(Map.prototype.entries, 0);
    assert.looksNative(Map.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]);
    assert.strictEqual(Map.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], Map.prototype.entries);
    assert.nonEnumerable(Map.prototype, typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8);
    iter = (x$ = new Map(), x$.set('a', 'q'), x$.set('s', 'w'), x$.set('d', 'e'), x$)[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Map Iterator');
    assert.deepEqual(iter.next(), {
      value: ['a', 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['s', 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['d', 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.acosh', function(assert){
    var acosh;
    acosh = Math.acosh;
    assert.isFunction(acosh);
    assert.name(acosh, 'acosh');
    assert.arity(acosh, 1);
    assert.looksNative(acosh);
    assert.nonEnumerable(Math, 'acosh');
    assert.same(acosh(NaN), NaN);
    assert.same(acosh(0.5), NaN);
    assert.same(acosh(-1), NaN);
    assert.same(acosh(-1e300), NaN);
    assert.same(acosh(1), 0);
    assert.strictEqual(acosh(Infinity), Infinity);
    assert.epsilon(acosh(1234), 7.811163220849231);
    assert.epsilon(acosh(8.88), 2.8737631531629235);
    assert.epsilon(acosh(1e+160), 369.10676205960726);
    assert.epsilon(acosh(Number.MAX_VALUE), 710.475860073944);
    assert.epsilon(acosh(1 + Number.EPSILON), 2.1073424255447017e-8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.asinh', function(assert){
    var asinh;
    asinh = Math.asinh;
    assert.isFunction(asinh);
    assert.name(asinh, 'asinh');
    assert.arity(asinh, 1);
    assert.looksNative(asinh);
    assert.nonEnumerable(Math, 'asinh');
    assert.same(asinh(NaN), NaN);
    assert.same(asinh(0), 0);
    assert.same(asinh(-0), -0);
    assert.strictEqual(asinh(Infinity), Infinity);
    assert.strictEqual(asinh(-Infinity), -Infinity);
    assert.epsilon(asinh(1234), 7.811163549201245);
    assert.epsilon(asinh(9.99), 2.997227420191335);
    assert.epsilon(asinh(1e150), 346.0809111296668);
    assert.epsilon(asinh(1e7), 16.811242831518268);
    assert.epsilon(asinh(-1e7), -16.811242831518268);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.atanh', function(assert){
    var atanh;
    atanh = Math.atanh;
    assert.isFunction(atanh);
    assert.name(atanh, 'atanh');
    assert.arity(atanh, 1);
    assert.looksNative(atanh);
    assert.nonEnumerable(Math, 'atanh');
    assert.same(atanh(NaN), NaN);
    assert.same(atanh(-2), NaN);
    assert.same(atanh(-1.5), NaN);
    assert.same(atanh(2), NaN);
    assert.same(atanh(1.5), NaN);
    assert.strictEqual(atanh(-1), -Infinity);
    assert.strictEqual(atanh(1), Infinity);
    assert.same(atanh(0), 0);
    assert.same(atanh(-0), -0);
    assert.same(atanh(-1e300), NaN);
    assert.same(atanh(1e300), NaN);
    assert.epsilon(atanh(0.5), 0.5493061443340549);
    assert.epsilon(atanh(-0.5), -0.5493061443340549);
    assert.epsilon(atanh(0.444), 0.47720201260109457);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.cbrt', function(assert){
    var cbrt;
    cbrt = Math.cbrt;
    assert.isFunction(cbrt);
    assert.name(cbrt, 'cbrt');
    assert.arity(cbrt, 1);
    assert.looksNative(cbrt);
    assert.nonEnumerable(Math, 'cbrt');
    assert.same(cbrt(NaN), NaN);
    assert.same(cbrt(0), 0);
    assert.same(cbrt(-0), -0);
    assert.strictEqual(cbrt(Infinity), Infinity);
    assert.strictEqual(cbrt(-Infinity), -Infinity);
    assert.strictEqual(cbrt(-8), -2);
    assert.strictEqual(cbrt(8), 2);
    assert.epsilon(cbrt(-1000), -10);
    assert.epsilon(cbrt(1000), 10);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.clz32', function(assert){
    var clz32;
    clz32 = Math.clz32;
    assert.isFunction(clz32);
    assert.name(clz32, 'clz32');
    assert.arity(clz32, 1);
    assert.looksNative(clz32);
    assert.nonEnumerable(Math, 'clz32');
    assert.strictEqual(clz32(0), 32);
    assert.strictEqual(clz32(1), 31);
    assert.same(clz32(-1), 0);
    assert.strictEqual(clz32(0.6), 32);
    assert.same(clz32(Math.pow(2, 32) - 1), 0);
    return assert.strictEqual(clz32(Math.pow(2, 32)), 32);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.cosh', function(assert){
    var cosh;
    cosh = Math.cosh;
    assert.isFunction(cosh);
    assert.name(cosh, 'cosh');
    assert.arity(cosh, 1);
    assert.looksNative(cosh);
    assert.nonEnumerable(Math, 'cosh');
    assert.same(cosh(NaN), NaN);
    assert.strictEqual(cosh(0), 1);
    assert.strictEqual(cosh(-0), 1);
    assert.strictEqual(cosh(Infinity), Infinity);
    assert.strictEqual(cosh(-Infinity), Infinity);
    assert.epsilon(cosh(12), 81377.39571257407, 3e-11);
    assert.epsilon(cosh(22), 1792456423.065795780980053377, 1e-5);
    assert.epsilon(cosh(-10), 11013.23292010332313972137);
    assert.epsilon(cosh(-23), 4872401723.1244513000, 1e-5);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.expm1', function(assert){
    var expm1;
    expm1 = Math.expm1;
    assert.isFunction(expm1);
    assert.name(expm1, 'expm1');
    assert.arity(expm1, 1);
    assert.looksNative(expm1);
    assert.nonEnumerable(Math, 'expm1');
    assert.same(expm1(NaN), NaN);
    assert.same(expm1(0), 0);
    assert.same(expm1(-0), -0);
    assert.strictEqual(expm1(Infinity), Infinity);
    assert.strictEqual(expm1(-Infinity), -1);
    assert.epsilon(expm1(10), 22025.465794806718, assert.epsilon(expm1(-10), -0.9999546000702375));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.fround', function(assert){
    var fround, maxFloat32, minFloat32;
    fround = Math.fround;
    assert.isFunction(fround);
    assert.name(fround, 'fround');
    assert.arity(fround, 1);
    assert.looksNative(fround);
    assert.nonEnumerable(Math, 'fround');
    assert.same(fround(void 8), NaN);
    assert.same(fround(NaN), NaN);
    assert.same(fround(0), 0);
    assert.same(fround(-0), -0);
    assert.same(fround(Number.MIN_VALUE), 0);
    assert.same(fround(-Number.MIN_VALUE), -0);
    assert.strictEqual(fround(Infinity), Infinity);
    assert.strictEqual(fround(-Infinity), -Infinity);
    assert.strictEqual(fround(1.7976931348623157e+308), Infinity);
    assert.strictEqual(fround(-1.7976931348623157e+308), -Infinity);
    assert.strictEqual(fround(3.4028235677973366e+38), Infinity);
    assert.strictEqual(fround(3), 3);
    assert.strictEqual(fround(-3), -3);
    maxFloat32 = 3.4028234663852886e+38;
    minFloat32 = 1.401298464324817e-45;
    assert.strictEqual(fround(maxFloat32), maxFloat32);
    assert.strictEqual(fround(-maxFloat32), -maxFloat32);
    assert.strictEqual(fround(maxFloat32 + Math.pow(2, Math.pow(2, 8 - 1) - 1 - 23 - 2)), maxFloat32);
    assert.strictEqual(fround(minFloat32), minFloat32);
    assert.strictEqual(fround(-minFloat32), -minFloat32);
    assert.same(fround(minFloat32 / 2), 0);
    assert.same(fround(-minFloat32 / 2), -0);
    assert.strictEqual(fround(minFloat32 / 2 + Math.pow(2, -202)), minFloat32);
    assert.strictEqual(fround(-minFloat32 / 2 - Math.pow(2, -202)), -minFloat32);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.hypot', function(assert){
    var hypot, sqrt;
    hypot = Math.hypot, sqrt = Math.sqrt;
    assert.isFunction(hypot);
    assert.name(hypot, 'hypot');
    assert.arity(hypot, 2);
    assert.looksNative(hypot);
    assert.nonEnumerable(Math, 'hypot');
    assert.strictEqual(hypot(), 0);
    assert.strictEqual(hypot(1), 1);
    assert.same(hypot('', 0), 0);
    assert.same(hypot(0, ''), 0);
    assert.strictEqual(hypot(Infinity, 0), Infinity);
    assert.strictEqual(hypot(-Infinity, 0), Infinity);
    assert.strictEqual(hypot(0, Infinity), Infinity);
    assert.strictEqual(hypot(0, -Infinity), Infinity);
    assert.strictEqual(hypot(Infinity, NaN), Infinity);
    assert.strictEqual(hypot(NaN, -Infinity), Infinity);
    assert.same(hypot(NaN, 0), NaN);
    assert.same(hypot(0, NaN), NaN);
    assert.same(hypot(0, -0), 0);
    assert.same(hypot(0, 0), 0);
    assert.same(hypot(-0, -0), 0);
    assert.same(hypot(-0, 0), 0);
    assert.strictEqual(hypot(0, 1), 1);
    assert.strictEqual(hypot(0, -1), 1);
    assert.strictEqual(hypot(-0, 1), 1);
    assert.strictEqual(hypot(-0, -1), 1);
    assert.same(hypot(0), 0);
    assert.strictEqual(hypot(1), 1);
    assert.strictEqual(hypot(2), 2);
    assert.strictEqual(hypot(0, 0, 1), 1);
    assert.strictEqual(hypot(0, 1, 0), 1);
    assert.strictEqual(hypot(1, 0, 0), 1);
    assert.strictEqual(hypot(2, 3, 4), sqrt(2 * 2 + 3 * 3 + 4 * 4));
    assert.strictEqual(hypot(2, 3, 4, 5), sqrt(2 * 2 + 3 * 3 + 4 * 4 + 5 * 5));
    assert.epsilon(hypot(66, 66), 93.33809511662427);
    assert.epsilon(hypot(0.1, 100), 100.0000499999875);
    assert.strictEqual(hypot(1e+300, 1e+300), 1.4142135623730952e+300);
    assert.strictEqual(Math.floor(hypot(1e-300, 1e-300) * 1e308), 141421356);
    assert.strictEqual(hypot(1e+300, 1e+300, 2, 3), 1.4142135623730952e+300);
    assert.strictEqual(hypot(-3, 4), 5);
    assert.strictEqual(hypot(3, -4), 5);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.imul', function(assert){
    var imul;
    imul = Math.imul;
    assert.isFunction(imul);
    assert.name(imul, 'imul');
    assert.arity(imul, 2);
    assert.looksNative(imul);
    assert.nonEnumerable(Math, 'imul');
    assert.same(imul(0, 0), 0);
    assert.strictEqual(imul(123, 456), 56088);
    assert.strictEqual(imul(-123, 456), -56088);
    assert.strictEqual(imul(123, -456), -56088);
    assert.strictEqual(imul(19088743, 4275878552), 602016552);
    assert.same(imul(false, 7), 0);
    assert.same(imul(7, false), 0);
    assert.same(imul(false, false), 0);
    assert.strictEqual(imul(true, 7), 7);
    assert.strictEqual(imul(7, true), 7);
    assert.strictEqual(imul(true, true), 1);
    assert.same(imul(void 8, 7), 0);
    assert.same(imul(7, void 8), 0);
    assert.same(imul(void 8, void 8), 0);
    assert.same(imul('str', 7), 0);
    assert.same(imul(7, 'str'), 0);
    assert.same(imul({}, 7), 0);
    assert.same(imul(7, {}), 0);
    assert.same(imul([], 7), 0);
    assert.same(imul(7, []), 0);
    assert.strictEqual(imul(0xffffffff, 5), -5);
    assert.strictEqual(imul(0xfffffffe, 5), -10);
    assert.strictEqual(imul(2, 4), 8);
    assert.strictEqual(imul(-1, 8), -8);
    assert.strictEqual(imul(-2, -2), 4);
    assert.same(imul(-0, 7), 0);
    assert.same(imul(7, -0), 0);
    assert.same(imul(0.1, 7), 0);
    assert.same(imul(7, 0.1), 0);
    assert.same(imul(0.9, 7), 0);
    assert.same(imul(7, 0.9), 0);
    assert.strictEqual(imul(1.1, 7), 7);
    assert.strictEqual(imul(7, 1.1), 7);
    assert.strictEqual(imul(1.9, 7), 7);
    assert.strictEqual(imul(7, 1.9), 7);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.log10', function(assert){
    var log10;
    log10 = Math.log10;
    assert.isFunction(log10);
    assert.name(log10, 'log10');
    assert.arity(log10, 1);
    assert.looksNative(log10);
    assert.nonEnumerable(Math, 'log10');
    assert.same(log10(''), log10(0));
    assert.same(log10(NaN), NaN);
    assert.same(log10(-1), NaN);
    assert.same(log10(0), -Infinity);
    assert.same(log10(-0), -Infinity);
    assert.same(log10(1), 0);
    assert.same(log10(Infinity), Infinity);
    assert.epsilon(log10(0.1), -1);
    assert.epsilon(log10(0.5), -0.3010299956639812);
    assert.epsilon(log10(1.5), 0.17609125905568124);
    assert.epsilon(log10(5), 0.6989700043360189);
    assert.epsilon(log10(50), 1.6989700043360187);
    assert.epsilon(log10(1000), 3);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.log1p', function(assert){
    var log1p;
    log1p = Math.log1p;
    assert.isFunction(log1p);
    assert.name(log1p, 'log1p');
    assert.arity(log1p, 1);
    assert.looksNative(log1p);
    assert.nonEnumerable(Math, 'log1p');
    assert.same(log1p(''), log1p(0));
    assert.same(log1p(NaN), NaN);
    assert.same(log1p(-2), NaN);
    assert.same(log1p(-1), -Infinity);
    assert.same(log1p(0), 0);
    assert.same(log1p(-0), -0);
    assert.same(log1p(Infinity), Infinity);
    assert.epsilon(log1p(5), 1.791759469228055);
    assert.epsilon(log1p(50), 3.9318256327243257);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.log2', function(assert){
    var log2;
    log2 = Math.log2;
    assert.isFunction(log2);
    assert.name(log2, 'log2');
    assert.arity(log2, 1);
    assert.looksNative(log2);
    assert.nonEnumerable(Math, 'log2');
    assert.same(log2(''), log2(0));
    assert.same(log2(NaN), NaN);
    assert.same(log2(-1), NaN);
    assert.same(log2(0), -Infinity);
    assert.same(log2(-0), -Infinity);
    assert.same(log2(1), 0);
    assert.same(log2(Infinity), Infinity);
    assert.same(log2(0.5), -1);
    assert.same(log2(32), 5);
    assert.epsilon(log2(5), 2.321928094887362);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.sign', function(assert){
    var sign;
    sign = Math.sign;
    assert.isFunction(sign);
    assert.name(sign, 'sign');
    assert.arity(sign, 1);
    assert.looksNative(sign);
    assert.nonEnumerable(Math, 'sign');
    assert.same(sign(NaN), NaN);
    assert.same(sign(), NaN);
    assert.same(sign(-0), -0);
    assert.same(sign(0), 0);
    assert.strictEqual(sign(Infinity), 1);
    assert.strictEqual(sign(-Infinity), -1);
    assert.strictEqual(sign(13510798882111488), 1);
    assert.strictEqual(sign(-13510798882111488), -1);
    assert.strictEqual(sign(42.5), 1);
    assert.strictEqual(sign(-42.5), -1);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.sinh', function(assert){
    var sinh;
    sinh = Math.sinh;
    assert.isFunction(sinh);
    assert.name(sinh, 'sinh');
    assert.arity(sinh, 1);
    assert.looksNative(sinh);
    assert.nonEnumerable(Math, 'sinh');
    assert.same(sinh(NaN), NaN);
    assert.same(sinh(0), 0);
    assert.same(sinh(-0), -0);
    assert.strictEqual(sinh(Infinity), Infinity);
    assert.strictEqual(sinh(-Infinity), -Infinity);
    assert.epsilon(sinh(-5), -74.20321057778875);
    assert.epsilon(sinh(2), 3.6268604078470186);
    assert.strictEqual(sinh(-2e-17), -2e-17);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.tanh', function(assert){
    var tanh;
    tanh = Math.tanh;
    assert.isFunction(tanh);
    assert.name(tanh, 'tanh');
    assert.arity(tanh, 1);
    assert.looksNative(tanh);
    assert.nonEnumerable(Math, 'tanh');
    assert.same(tanh(NaN), NaN);
    assert.same(tanh(0), 0);
    assert.same(tanh(-0), -0);
    assert.strictEqual(tanh(Infinity), 1);
    assert.strictEqual(tanh(90), 1);
    assert.epsilon(tanh(10), 0.9999999958776927);
    NATIVE && assert.strictEqual(tanh(710), 1);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.trunc', function(assert){
    var trunc;
    trunc = Math.trunc;
    assert.isFunction(trunc);
    assert.name(trunc, 'trunc');
    assert.arity(trunc, 1);
    assert.looksNative(trunc);
    assert.nonEnumerable(Math, 'trunc');
    assert.same(trunc(NaN), NaN, 'NaN -> NaN');
    assert.same(trunc(-0), -0, '-0 -> -0');
    assert.same(trunc(0), 0, '0 -> 0');
    assert.same(trunc(Infinity), Infinity, 'Infinity -> Infinity');
    assert.same(trunc(-Infinity), -Infinity, '-Infinity -> -Infinity');
    assert.same(trunc(null), 0, 'null -> 0');
    assert.same(trunc({}), NaN, '{} -> NaN');
    assert.strictEqual(trunc([]), 0, '[] -> 0');
    assert.strictEqual(trunc(1.01), 1, '1.01 -> 0');
    assert.strictEqual(trunc(1.99), 1, '1.99 -> 0');
    assert.strictEqual(trunc(-1), -1, '-1 -> -1');
    assert.strictEqual(trunc(-1.99), -1, '-1.99 -> -1');
    assert.strictEqual(trunc(-555.555), -555, '-555.555 -> -555');
    assert.strictEqual(trunc(0x20000000000001), 0x20000000000001, '0x20000000000001 -> 0x20000000000001');
    assert.strictEqual(trunc(-0x20000000000001), -0x20000000000001, '-0x20000000000001 -> -0x20000000000001');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, ws, $check, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  ws = ' \t\x0b\f\xa0\ufeff\n\r\u2028\u2029\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000';
  $check = function(assert){
    return function(a, b){
      var x;
      assert.same(Number(a), b, "Number " + typeof a + " " + a + " -> " + b);
      x = new Number(a);
      assert.ok(x === Object(x), "new Number " + typeof a + " " + a + " is object");
      assert.strictEqual(toString$.call(x).slice(8, -1), 'Number', "classof new Number " + typeof a + " " + a + " is Number");
      assert.same(x.valueOf(), b, "new Number(" + typeof a + " " + a + ").valueOf() -> " + b);
    };
  };
  test('Number constructor: regression', function(assert){
    var check, i$, x$, ref$, len$, i, n, C;
    check = $check(assert);
    assert.isFunction(Number);
    assert.arity(Number, 1);
    assert.name(Number, 'Number');
    assert.looksNative(Number);
    assert.same(Number.prototype.constructor, Number);
    assert.same(1 .constructor, Number);
    for (i$ = 0, len$ = (ref$ = ['MAX_VALUE', 'MIN_VALUE', 'NaN', 'NEGATIVE_INFINITY', 'POSITIVE_INFINITY']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(x$ in Number, "Number." + x$);
      assert.nonEnumerable(Number, x$);
    }
    assert.same(Number(), 0);
    assert.same(new Number().valueOf(), 0);
    check(42, 42);
    check(42.42, 42.42);
    check(new Number(42), 42);
    check(new Number(42.42), 42.42);
    check('42', 42);
    check('42.42', 42.42);
    check('0x42', 66);
    check('0X42', 66);
    check('0xzzz', NaN);
    check('0x1g', NaN);
    check('+0x1', NaN);
    check('-0x1', NaN);
    check('+0X1', NaN);
    check('-0X1', NaN);
    check(new String('42'), 42);
    check(new String('42.42'), 42.42);
    check(new String('0x42'), 66);
    check(null, 0);
    check(void 8, NaN);
    check(false, 0);
    check(true, 1);
    check(new Boolean(false), 0);
    check(new Boolean(true), 1);
    check({}, NaN);
    check({
      valueOf: '1.1'
    }, NaN);
    check({
      valueOf: '1.1',
      toString: function(){
        return '2.2';
      }
    }, 2.2);
    check({
      valueOf: function(){
        return '1.1';
      }
    }, 1.1);
    check({
      valueOf: function(){
        return '1.1';
      },
      toString: function(){
        return '2.2';
      }
    }, 1.1);
    check({
      valueOf: function(){
        return '-0x1a2b3c';
      }
    }, NaN);
    check({
      toString: function(){
        return '-0x1a2b3c';
      }
    }, NaN);
    check({
      valueOf: function(){
        return 42;
      }
    }, 42);
    check({
      valueOf: function(){
        return '42';
      }
    }, 42);
    check({
      valueOf: function(){
        return null;
      }
    }, 0);
    check({
      toString: function(){
        return 42;
      }
    }, 42);
    check({
      toString: function(){
        return '42';
      }
    }, 42);
    check({
      valueOf: function(){
        return 1;
      },
      toString: function(){
        return 2;
      }
    }, 1);
    check({
      valueOf: 1,
      toString: function(){
        return 2;
      }
    }, 2);
    i = 1;
    assert.strictEqual(Number({
      valueOf: function(){
        return ++i;
      }
    }), 2, 'Number call valueOf only once #1');
    assert.strictEqual(i, 2, 'Number call valueOf only once #2');
    i = 1;
    assert.strictEqual(Number({
      toString: function(){
        return ++i;
      }
    }), 2, 'Number call toString only once #1');
    assert.strictEqual(i, 2, 'Number call toString only once #2');
    i = 1;
    assert.strictEqual(new Number({
      valueOf: function(){
        return ++i;
      }
    }).valueOf(), 2, 'new Number call valueOf only once #1');
    assert.strictEqual(i, 2, 'new Number call valueOf only once #2');
    i = 1;
    assert.strictEqual(new Number({
      toString: function(){
        return ++i;
      }
    }).valueOf(), 2, 'new Number call toString only once #1');
    assert.strictEqual(i, 2, 'new Number call toString only once #2');
    assert.throws(function(){
      return Number(Object.create(null));
    }, TypeError, 'Number assert.throws on object w/o valueOf and toString');
    assert.throws(function(){
      return Number({
        valueOf: 1,
        toString: 2
      });
    }, TypeError, 'Number assert.throws on object then valueOf and toString are not functions');
    assert.throws(function(){
      return new Number(Object.create(null));
    }, TypeError, 'new Number assert.throws on object w/o valueOf and toString');
    assert.throws(function(){
      return new Number({
        valueOf: 1,
        toString: 2
      });
    }, TypeError, 'new Number assert.throws on object then valueOf and toString are not functions');
    n = new Number(42);
    assert.strictEqual(typeof n.constructor(n), 'number');
    check(ws + "42", 42);
    check("42" + ws, 42);
    check(ws + "42" + ws, 42);
    check(ws + "0x42", 66);
    check("0x42" + ws, 66);
    check(ws + "0x42" + ws, 66);
    check(ws + "0X42", 66);
    check("0X42" + ws, 66);
    check(ws + "0X42" + ws, 66);
    if (nativeSubclass) {
      C = nativeSubclass(Number);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof Number, 'correct subclassing with native classes #2');
      assert.same(new C(1).toFixed(2), '1.00', 'correct subclassing with native classes #3');
    }
  });
  test('Number constructor: binary', function(assert){
    var check;
    check = $check(assert);
    check('0b1', 1);
    check('0B1', 1);
    check('0b12', NaN);
    check('0b234', NaN);
    check('0b1!', NaN);
    check('+0b1', NaN);
    check('-0b1', NaN);
    check(' 0b1', 1);
    check('0b1\n', 1);
    check('\n 0b1\n ', 1);
    check(' 0B1', 1);
    check('0B1\n', 1);
    check('\n 0B1\n ', 1);
    check({
      valueOf: function(){
        return '0b11';
      }
    }, 3);
    check({
      toString: function(){
        return '0b111';
      }
    }, 7);
    check({
      valueOf: function(){
        return '0b101010';
      }
    }, 42);
    check({
      toString: function(){
        return '0b101010';
      }
    }, 42);
    check(ws + "0b11", 3);
    check("0b11" + ws, 3);
    check(ws + "0b11" + ws, 3);
    check(ws + "0B11", 3);
    check("0B11" + ws, 3);
    check(ws + "0B11" + ws, 3);
  });
  test('Number constructor: octal', function(assert){
    var check;
    check = $check(assert);
    check('0o7', 7);
    check('0O7', 7);
    check('0o18', NaN);
    check('0o89a', NaN);
    check('0o1!', NaN);
    check('+0o1', NaN);
    check('-0o1', NaN);
    check(' 0o1', 1);
    check('0o1\n', 1);
    check('\n 0o1\n ', 1);
    check(' 0O1', 1);
    check('0O1\n', 1);
    check('\n 0O1\n ', 1);
    check({
      valueOf: function(){
        return '0o77';
      }
    }, 63);
    check({
      toString: function(){
        return '0o777';
      }
    }, 511);
    check({
      valueOf: function(){
        return '0o12345';
      }
    }, 5349);
    check({
      toString: function(){
        return '0o12345';
      }
    }, 5349);
    check(ws + "0o11", 9);
    check("0o11" + ws, 9);
    check(ws + "0o11" + ws, 9);
    check(ws + "0O11", 9);
    check("0O11" + ws, 9);
    check(ws + "0O11" + ws, 9);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.EPSILON', function(assert){
    var EPSILON;
    EPSILON = Number.EPSILON;
    assert.ok('EPSILON' in Number, 'EPSILON in Number');
    assert.nonEnumerable(Number, 'EPSILON');
    assert.strictEqual(EPSILON, Math.pow(2, -52), 'Is 2^-52');
    assert.ok(1 !== 1 + EPSILON, '1 isnt 1 + EPSILON');
    assert.strictEqual(1, 1 + EPSILON / 2, '1 is 1 + EPSILON / 2');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isFinite', function(assert){
    var isFinite, create, i$, x$, ref$, len$, y$, e;
    isFinite = Number.isFinite;
    create = Object.create;
    assert.isFunction(isFinite);
    assert.name(isFinite, 'isFinite');
    assert.arity(isFinite, 1);
    assert.looksNative(isFinite);
    assert.nonEnumerable(Number, 'isFinite');
    for (i$ = 0, len$ = (ref$ = [1, 0.1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(isFinite(x$), "isFinite " + typeof x$ + " " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [NaN, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.ok(!isFinite(y$), "not isFinite " + typeof y$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(y$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isInteger', function(assert){
    var isInteger, create, i$, x$, ref$, len$, y$, e;
    isInteger = Number.isInteger;
    create = Object.create;
    assert.isFunction(isInteger);
    assert.name(isInteger, 'isInteger');
    assert.arity(isInteger, 1);
    assert.looksNative(isInteger);
    assert.nonEnumerable(Number, 'isInteger');
    for (i$ = 0, len$ = (ref$ = [1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(isInteger(x$), "isInteger " + typeof x$ + " " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [NaN, 0.1, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.ok(!isInteger(y$), "not isInteger " + typeof y$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(y$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isNaN', function(assert){
    var isNaN, create, i$, x$, ref$, len$, e;
    isNaN = Number.isNaN;
    create = Object.create;
    assert.isFunction(isNaN);
    assert.name(isNaN, 'isNaN');
    assert.arity(isNaN, 1);
    assert.looksNative(isNaN);
    assert.nonEnumerable(Number, 'isNaN');
    assert.ok(isNaN(NaN), 'Number.isNaN NaN');
    for (i$ = 0, len$ = (ref$ = [1, 0.1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(!isNaN(x$), "not Number.isNaN " + typeof x$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(x$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.isSafeInteger', function(assert){
    var isSafeInteger, create, i$, x$, ref$, len$, y$, e;
    isSafeInteger = Number.isSafeInteger;
    create = Object.create;
    assert.isFunction(isSafeInteger);
    assert.name(isSafeInteger, 'isSafeInteger');
    assert.arity(isSafeInteger, 1);
    assert.looksNative(isSafeInteger);
    assert.nonEnumerable(Number, 'isSafeInteger');
    for (i$ = 0, len$ = (ref$ = [1, -1, Math.pow(2, 16), Math.pow(2, 16) - 1, Math.pow(2, 31), Math.pow(2, 31) - 1, Math.pow(2, 32), Math.pow(2, 32) - 1, -0, 9007199254740991, -9007199254740991]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(isSafeInteger(x$), "isSafeInteger " + typeof x$ + " " + x$);
    }
    for (i$ = 0, len$ = (ref$ = [9007199254740992, -9007199254740992, NaN, 0.1, Infinity, 'NaN', '5', false, new Number(NaN), new Number(Infinity), new Number(5), new Number(0.1), void 8, null, {}, fn$, create(null)]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.ok(!isSafeInteger(y$), "not isSafeInteger " + typeof y$ + " " + (fn1$()));
    }
    function fn$(){}
    function fn1$(){
      try {
        return String(y$);
      } catch (e$) {
        e = e$;
        return 'Object.create(null)';
      }
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.MAX_SAFE_INTEGER', function(assert){
    assert.ok('MAX_SAFE_INTEGER' in Number);
    assert.nonEnumerable(Number, 'MAX_SAFE_INTEGER');
    assert.strictEqual(Number.MAX_SAFE_INTEGER, Math.pow(2, 53) - 1, 'Is 2^53 - 1');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.MIN_SAFE_INTEGER', function(assert){
    assert.ok('MIN_SAFE_INTEGER' in Number);
    assert.nonEnumerable(Number, 'MIN_SAFE_INTEGER');
    assert.strictEqual(Number.MIN_SAFE_INTEGER, -Math.pow(2, 53) + 1, 'Is -2^53 + 1');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.parseFloat', function(assert){
    var parseFloat, ws;
    parseFloat = Number.parseFloat;
    assert.isFunction(parseFloat);
    assert.name(parseFloat, 'parseFloat');
    assert.arity(parseFloat, 1);
    assert.looksNative(parseFloat);
    assert.nonEnumerable(Number, 'parseFloat');
    assert.same(parseFloat, global.parseFloat);
    assert.same(parseFloat('0'), 0);
    assert.same(parseFloat(' 0'), 0);
    assert.same(parseFloat('+0'), 0);
    assert.same(parseFloat(' +0'), 0);
    assert.same(parseFloat('-0'), -0);
    assert.same(parseFloat(' -0'), -0);
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseFloat(ws + '+0'), 0);
    assert.same(parseFloat(ws + '-0'), -0);
    assert.same(parseFloat(null), NaN);
    assert.same(parseFloat(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number.parseInt', function(assert){
    var parseInt, i$, r, x$, ref$, len$, ws, fakeZero;
    parseInt = Number.parseInt;
    assert.isFunction(parseInt);
    assert.name(parseInt, 'parseInt');
    assert.arity(parseInt, 2);
    assert.looksNative(parseInt);
    assert.nonEnumerable(Number, 'parseInt');
    assert.same(parseInt, global.parseInt);
    for (i$ = 2; i$ <= 36; ++i$) {
      r = i$;
      assert.same(parseInt('10', r), r, "radix " + r);
    }
    for (i$ = 0, len$ = (ref$ = ['01', '08', '10', '42']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.same(parseInt(x$), parseInt(x$, 10), "default radix is 10: " + x$);
    }
    assert.same(parseInt('0x16'), parseInt('0x16', 16), "default radix is 16: 0x16");
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseInt('  0x16'), parseInt('0x16', 16), 'ignores leading whitespace #1');
    assert.same(parseInt('  42'), parseInt('42', 10), 'ignores leading whitespace #2');
    assert.same(parseInt('  08'), parseInt('08', 10), 'ignores leading whitespace #3');
    assert.same(parseInt(ws + '08'), parseInt('08', 10), 'ignores leading whitespace #4');
    assert.same(parseInt(ws + '0x16'), parseInt('0x16', 16), 'ignores leading whitespace #5');
    fakeZero = {
      valueOf: function(){
        return 0;
      }
    };
    assert.same(parseInt('08', fakeZero), parseInt('08', 10), 'valueOf #1');
    assert.same(parseInt('0x16', fakeZero), parseInt('0x16', 16), 'valueOf #2');
    assert.same(parseInt('-0xF'), -15, 'signed hex #1');
    assert.same(parseInt('-0xF', 16), -15, 'signed hex #2');
    assert.same(parseInt('+0xF'), 15, 'signed hex #3');
    assert.same(parseInt('+0xF', 16), 15, 'signed hex #4');
    assert.same(parseInt('10', -4294967294), 2, 'radix uses ToUint32');
    assert.same(parseInt(null), NaN);
    assert.same(parseInt(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number#toFixed', function(assert){
    var toFixed;
    toFixed = Number.prototype.toFixed;
    assert.isFunction(toFixed);
    assert.name(toFixed, 'toFixed');
    assert.arity(toFixed, 1);
    assert.looksNative(toFixed);
    assert.nonEnumerable(Number.prototype, 'toFixed');
    assert.same(0.00008.toFixed(3), '0.000');
    assert.same(0.9.toFixed(0), '1');
    assert.same(1.255.toFixed(2), '1.25');
    assert.same(1843654265.0774949.toFixed(5), '1843654265.07749');
    assert.same(1000000000000000128 .toFixed(0), '1000000000000000128');
    assert.same(toFixed.call(1), '1');
    assert.same(toFixed.call(1, 0), '1');
    assert.same(toFixed.call(1, 1), '1.0');
    assert.same(toFixed.call(1, 1.1), '1.0');
    assert.same(toFixed.call(1, 0.9), '1');
    assert.same(toFixed.call(1, '0'), '1');
    assert.same(toFixed.call(1, '1'), '1.0');
    assert.same(toFixed.call(1, '1.1'), '1.0');
    assert.same(toFixed.call(1, '0.9'), '1');
    assert.same(toFixed.call(1, NaN), '1');
    assert.same(toFixed.call(1, 'some string'), '1');
    assert.same((function(){
      try {
        return toFixed.call(1, -0.1);
      } catch (e$) {}
    }()), '1');
    assert.same(new Number(1).toFixed(), '1');
    assert.same(new Number(1).toFixed(0), '1');
    assert.same(new Number(1).toFixed(1), '1.0');
    assert.same(new Number(1).toFixed(1.1), '1.0');
    assert.same(new Number(1).toFixed(0.9), '1');
    assert.same(new Number(1).toFixed('0'), '1');
    assert.same(new Number(1).toFixed('1'), '1.0');
    assert.same(new Number(1).toFixed('1.1'), '1.0');
    assert.same(new Number(1).toFixed('0.9'), '1');
    assert.same(new Number(1).toFixed(NaN), '1');
    assert.same(new Number(1).toFixed('some string'), '1');
    assert.same((function(){
      try {
        return new Number(1).toFixed(-0.1);
      } catch (e$) {}
    }()), '1');
    assert.same(NaN.toFixed(), 'NaN');
    assert.same(NaN.toFixed(0), 'NaN');
    assert.same(NaN.toFixed(1), 'NaN');
    assert.same(NaN.toFixed(1.1), 'NaN');
    assert.same(NaN.toFixed(0.9), 'NaN');
    assert.same(NaN.toFixed('0'), 'NaN');
    assert.same(NaN.toFixed('1'), 'NaN');
    assert.same(NaN.toFixed('1.1'), 'NaN');
    assert.same(NaN.toFixed('0.9'), 'NaN');
    assert.same(NaN.toFixed(NaN), 'NaN');
    assert.same(NaN.toFixed('some string'), 'NaN');
    assert.same((function(){
      try {
        return NaN.toFixed(-0.1);
      } catch (e$) {}
    }()), 'NaN');
    assert.same(new Number(1e21).toFixed(), String(1e21));
    assert.same(new Number(1e21).toFixed(0), String(1e21));
    assert.same(new Number(1e21).toFixed(1), String(1e21));
    assert.same(new Number(1e21).toFixed(1.1), String(1e21));
    assert.same(new Number(1e21).toFixed(0.9), String(1e21));
    assert.same(new Number(1e21).toFixed('0'), String(1e21));
    assert.same(new Number(1e21).toFixed('1'), String(1e21));
    assert.same(new Number(1e21).toFixed('1.1'), String(1e21));
    assert.same(new Number(1e21).toFixed('0.9'), String(1e21));
    assert.same(new Number(1e21).toFixed(NaN), String(1e21));
    assert.same(new Number(1e21).toFixed('some string'), String(1e21));
    assert.same((function(){
      try {
        return new Number(1e21).toFixed(-0.1);
      } catch (e$) {}
    }()), String(1e21));
    assert.throws(function(){
      1.0.toFixed(-101);
    }, RangeError, 'If f < 0 or f > 20, throw a RangeError exception.');
    assert.throws(function(){
      1.0.toFixed(101);
    }, RangeError, 'If f < 0 or f > 20, throw a RangeError exception.');
    assert.throws(function(){
      NaN.toFixed(Infinity);
    }, RangeError, 'If f < 0 or f > 20, throw a RangeError exception.');
    assert.throws(function(){
      toFixed.call({}, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed.call('123', 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed.call(false, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed.call(null, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toFixed.call(void 8, 1);
    }, TypeError, '? thisNumberValue(this value)');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Number#toPrecision', function(assert){
    var toPrecision;
    toPrecision = Number.prototype.toPrecision;
    assert.isFunction(toPrecision);
    assert.name(toPrecision, 'toPrecision');
    assert.arity(toPrecision, 1);
    assert.looksNative(toPrecision);
    assert.nonEnumerable(Number.prototype, 'toPrecision');
    assert.same(0.00008.toPrecision(3), '0.0000800', '0.00008.toPrecision(3)');
    assert.same(1.255.toPrecision(2), '1.3', '1.255.toPrecision(2)');
    assert.same(1843654265.0774949.toPrecision(13), '1843654265.077', '1843654265.0774949.toPrecision(13)');
    assert.same(NaN.toPrecision(1), 'NaN', 'If x is NaN, return the String "NaN".');
    assert.same(123.456.toPrecision(), '123.456', 'If precision is undefined, return ! ToString(x).');
    assert.same(123.456.toPrecision(void 8), '123.456', 'If precision is undefined, return ! ToString(x).');
    assert.throws(function(){
      0.9.toPrecision(0);
    }, RangeError, 'If p < 1 or p > 21, throw a RangeError exception.');
    assert.throws(function(){
      0.9.toPrecision(101);
    }, RangeError, 'If p < 1 or p > 21, throw a RangeError exception.');
    assert.throws(function(){
      toPrecision.call({}, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision.call('123', 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision.call(false, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision.call(null, 1);
    }, TypeError, '? thisNumberValue(this value)');
    assert.throws(function(){
      toPrecision.call(void 8, 1);
    }, TypeError, '? thisNumberValue(this value)');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.assign', function(assert){
    var assign, keys, defineProperty, foo, str, c, d, D, ref$, O, string, i$, x$, len$;
    assign = Object.assign, keys = Object.keys, defineProperty = Object.defineProperty;
    assert.isFunction(assign);
    assert.arity(assign, 2);
    assert.name(assign, 'assign');
    assert.looksNative(assign);
    assert.nonEnumerable(Object, 'assign');
    foo = {
      q: 1
    };
    assert.strictEqual(foo, assign(foo, {
      bar: 2
    }), 'assign return target');
    assert.strictEqual(foo.bar, 2, 'assign define properties');
    assert.deepEqual(assign({}, {
      q: 1
    }, {
      w: 2
    }), {
      q: 1,
      w: 2
    });
    assert.deepEqual(assign({}, 'qwe'), {
      0: 'q',
      1: 'w',
      2: 'e'
    });
    assert.throws(function(){
      return assign(null, {
        q: 1
      });
    }, TypeError);
    assert.throws(function(){
      return assign(void 8, {
        q: 1
      });
    }, TypeError);
    str = assign('qwe', {
      q: 1
    });
    assert.strictEqual(typeof str, 'object');
    assert.strictEqual(String(str), 'qwe');
    assert.strictEqual(str.q, 1);
    assert.same(assign({}, {
      valueOf: 42
    }).valueOf, 42, 'IE enum keys bug');
    if (DESCRIPTORS) {
      foo = {
        baz: 1
      };
      assign(foo, defineProperty({}, 'bar', {
        get: function(){
          return this.baz + 1;
        }
      }));
      assert.ok(foo.bar === void 8, "assign don't copy descriptors");
      c = Symbol('c');
      d = Symbol('d');
      D = (ref$ = {
        a: 'a'
      }, ref$[c] = 'c', ref$);
      defineProperty(D, 'b', {
        value: 'b'
      });
      defineProperty(D, d, {
        value: 'd'
      });
      O = assign({}, D);
      assert.strictEqual(O.a, 'a', 'a');
      assert.strictEqual(O.b, void 8, 'b');
      assert.strictEqual(O[c], 'c', 'c');
      assert.strictEqual(O[d], void 8, 'd');
      try {
        assert.strictEqual(Function('return Object.assign({b: 1}, {get a(){delete this.b;},b: 2})')().b, 1);
      } catch (e$) {}
      try {
        assert.strictEqual(Function('return Object.assign({b: 1}, {get a(){Object.defineProperty(this, "b", {value:4,enumerable:false});},b: 2})')().b, 1);
      } catch (e$) {}
    }
    string = 'abcdefghijklmnopqrst';
    O = {};
    for (i$ = 0, len$ = (ref$ = string.split('')).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      O[x$] = x$;
    }
    assert.strictEqual(keys(assign({}, O)).join(''), string);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.create', function(assert){
    var create, getPrototypeOf, getOwnPropertyNames, isObject, isPrototype, getPropertyNames, obj, fn;
    create = Object.create, getPrototypeOf = Object.getPrototypeOf, getOwnPropertyNames = Object.getOwnPropertyNames;
    isObject = function(it){
      return it === Object(it);
    };
    isPrototype = function(a, b){
      return {}.isPrototypeOf.call(a, b);
    };
    getPropertyNames = function(object){
      var result, i$, x$, ref$, len$;
      result = getOwnPropertyNames(object);
      while (object = getPrototypeOf(object)) {
        for (i$ = 0, len$ = (ref$ = getOwnPropertyNames(object)).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          in$(x$, result) || result.push(x$);
        }
      }
      return result;
    };
    assert.isFunction(create);
    assert.arity(create, 2);
    assert.name(create, 'create');
    assert.looksNative(create);
    assert.nonEnumerable(Object, 'create');
    assert.ok(isPrototype(obj = {
      q: 1
    }, create(obj)));
    assert.ok(create(obj).q === 1);
    fn = function(){
      return this.a = 1;
    };
    assert.ok(create(new fn) instanceof fn);
    assert.ok(fn.prototype === getPrototypeOf(getPrototypeOf(create(new fn))));
    assert.ok(create(new fn).a === 1);
    assert.ok(create({}, {
      a: {
        value: 42
      }
    }).a === 42);
    assert.ok(isObject(obj = create(null, {
      w: {
        value: 2
      }
    })));
    assert.ok(!('toString' in obj));
    assert.ok(obj.w === 2);
    assert.deepEqual(getPropertyNames(create(null)), []);
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.defineProperties', function(assert){
    var defineProperties, rez, src;
    defineProperties = Object.defineProperties;
    assert.isFunction(defineProperties);
    assert.arity(defineProperties, 2);
    assert.name(defineProperties, 'defineProperties');
    assert.looksNative(defineProperties);
    assert.nonEnumerable(Object, 'defineProperties');
    assert.ok((rez = defineProperties(src = {}, {
      q: {
        value: 42
      },
      w: {
        value: 33
      }
    })) === src);
    return assert.ok(rez.q === 42) && rez.w === 33;
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.defineProperty', function(assert){
    var defineProperty, create, rez, src;
    defineProperty = Object.defineProperty, create = Object.create;
    assert.isFunction(defineProperty);
    assert.arity(defineProperty, 3);
    assert.name(defineProperty, 'defineProperty');
    assert.looksNative(defineProperty);
    assert.nonEnumerable(Object, 'defineProperty');
    assert.ok((rez = defineProperty(src = {}, 'q', {
      value: 42
    })) === src);
    assert.ok(rez.q === 42);
    assert.throws(function(){
      defineProperty(42, 1, {});
    });
    assert.throws(function(){
      defineProperty({}, create(null), {});
    });
    return assert.throws(function(){
      defineProperty({}, 1, 1);
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.freeze', function(assert){
    var freeze, isFrozen, keys, getOwnPropertyNames, i$, ref$, len$, value, key;
    freeze = Object.freeze, isFrozen = Object.isFrozen, keys = Object.keys, getOwnPropertyNames = Object.getOwnPropertyNames;
    assert.isFunction(freeze);
    assert.arity(freeze, 1);
    assert.name(freeze, 'freeze');
    assert.looksNative(freeze);
    assert.nonEnumerable(Object, 'freeze');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8, {}]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(freeze(value), value, "returns target on " + toString$.call(value).slice(8, -1));
    }
    if (NATIVE) {
      assert.ok(isFrozen(freeze({})));
    }
    assert.arrayEqual((function(){
      var results$ = [];
      for (key in freeze({})) {
        results$.push(key);
      }
      return results$;
    }()), []);
    assert.arrayEqual(keys(freeze({})), []);
    assert.arrayEqual(getOwnPropertyNames(freeze({})), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(freeze({})), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(freeze({})), []);
    function fn$(){
      try {
        freeze(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.getOwnPropertyDescriptor', function(assert){
    var getOwnPropertyDescriptor, i$, ref$, len$, value;
    getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    assert.isFunction(getOwnPropertyDescriptor);
    assert.arity(getOwnPropertyDescriptor, 2);
    assert.name(getOwnPropertyDescriptor, 'getOwnPropertyDescriptor');
    assert.looksNative(getOwnPropertyDescriptor);
    assert.nonEnumerable(Object, 'getOwnPropertyDescriptor');
    assert.deepEqual(getOwnPropertyDescriptor({
      q: 42
    }, 'q'), {
      writable: true,
      enumerable: true,
      configurable: true,
      value: 42
    });
    assert.ok(getOwnPropertyDescriptor({}, 'toString') === void 8);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    function fn$(){
      try {
        getOwnPropertyDescriptor(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      getOwnPropertyDescriptor(value);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.getOwnPropertyNames', function(assert){
    var getOwnPropertyNames, fn1, fn2, names, i$, ref$, len$, value, iframe, w;
    getOwnPropertyNames = Object.getOwnPropertyNames, getOwnPropertyNames = Object.getOwnPropertyNames;
    assert.isFunction(getOwnPropertyNames);
    assert.arity(getOwnPropertyNames, 1);
    assert.name(getOwnPropertyNames, 'getOwnPropertyNames');
    assert.looksNative(getOwnPropertyNames);
    assert.nonEnumerable(Object, 'getOwnPropertyNames');
    fn1 = function(w){
      this.w = w != null ? w : 2;
    };
    fn2 = function(toString){
      this.toString = toString != null ? toString : 2;
    };
    fn1.prototype.q = fn2.prototype.q = 1;
    names = getOwnPropertyNames([1, 2, 3]);
    assert.strictEqual(names.length, 4);
    assert.ok(in$('0', names));
    assert.ok(in$('1', names));
    assert.ok(in$('2', names));
    assert.ok(in$('length', names));
    assert.deepEqual(getOwnPropertyNames(new fn1(1)), ['w']);
    assert.deepEqual(getOwnPropertyNames(new fn2(1)), ['toString']);
    assert.ok(in$('toString', getOwnPropertyNames(Array.prototype)));
    assert.ok(in$('toString', getOwnPropertyNames(Object.prototype)));
    assert.ok(in$('constructor', getOwnPropertyNames(Object.prototype)));
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    if (typeof document != 'undefined' && document !== null) {
      assert.ok((function(){
        try {
          iframe = document.createElement('iframe');
          iframe.src = 'http://example.com';
          document.documentElement.appendChild(iframe);
          w = iframe.contentWindow;
          document.documentElement.removeChild(iframe);
          return getOwnPropertyNames(w);
        } catch (e$) {}
      }()), 'IE11 bug with iframe and window');
    }
    function fn$(){
      try {
        getOwnPropertyNames(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      getOwnPropertyNames(value);
    }
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.getPrototypeOf', function(assert){
    var create, getPrototypeOf, fn, obj, foo, bar, i$, ref$, len$, value;
    create = Object.create, getPrototypeOf = Object.getPrototypeOf;
    assert.isFunction(getPrototypeOf);
    assert.arity(getPrototypeOf, 1);
    assert.name(getPrototypeOf, 'getPrototypeOf');
    assert.looksNative(getPrototypeOf);
    assert.nonEnumerable(Object, 'getPrototypeOf');
    assert.ok(getPrototypeOf({}) === Object.prototype);
    assert.ok(getPrototypeOf([]) === Array.prototype);
    assert.ok(getPrototypeOf(new (fn = (function(){
      fn.displayName = 'fn';
      var prototype = fn.prototype, constructor = fn;
      function fn(){}
      return fn;
    }()))) === fn.prototype);
    assert.ok(getPrototypeOf(create(obj = {
      q: 1
    })) === obj);
    assert.ok(getPrototypeOf(create(null)) === null);
    assert.ok(getPrototypeOf(getPrototypeOf({})) === null);
    foo = function(){};
    foo.prototype.foo = 'foo';
    bar = function(){};
    bar.prototype = create(foo.prototype);
    bar.prototype.constructor = bar;
    assert.strictEqual(getPrototypeOf(bar.prototype).foo, 'foo');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    assert.strictEqual(getPrototypeOf('foo'), String.prototype);
    function fn$(){
      try {
        getPrototypeOf(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      getPrototypeOf(value);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.isExtensible', function(assert){
    var preventExtensions, isExtensible, i$, ref$, len$, value;
    preventExtensions = Object.preventExtensions, isExtensible = Object.isExtensible;
    assert.isFunction(isExtensible);
    assert.arity(isExtensible, 1);
    assert.name(isExtensible, 'isExtensible');
    assert.nonEnumerable(Object, 'isExtensible');
    assert.looksNative(isExtensible);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(isExtensible(value), false, "returns true on " + toString$.call(value).slice(8, -1));
    }
    assert.same(isExtensible({}), true);
    if (NATIVE) {
      assert.ok(!isExtensible(preventExtensions({})));
    }
    function fn$(){
      try {
        isExtensible(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.isFrozen', function(assert){
    var freeze, isFrozen, i$, ref$, len$, value;
    freeze = Object.freeze, isFrozen = Object.isFrozen;
    assert.isFunction(isFrozen);
    assert.arity(isFrozen, 1);
    assert.name(isFrozen, 'isFrozen');
    assert.looksNative(isFrozen);
    assert.nonEnumerable(Object, 'isFrozen');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(isFrozen(value), true, "returns true on " + toString$.call(value).slice(8, -1));
    }
    assert.same(isFrozen({}), false);
    if (NATIVE) {
      assert.ok(isFrozen(freeze({})));
    }
    function fn$(){
      try {
        isFrozen(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.isSealed', function(assert){
    var seal, isSealed, i$, ref$, len$, value;
    seal = Object.seal, isSealed = Object.isSealed;
    assert.isFunction(isSealed);
    assert.arity(isSealed, 1);
    assert.name(isSealed, 'isSealed');
    assert.looksNative(isSealed);
    assert.nonEnumerable(Object, 'isSealed');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(isSealed(value), true, "returns true on " + toString$.call(value).slice(8, -1));
    }
    assert.same(isSealed({}), false);
    if (NATIVE) {
      assert.ok(isSealed(seal({})));
    }
    function fn$(){
      try {
        isSealed(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.is', function(assert){
    var same;
    same = Object.is;
    assert.isFunction(same);
    assert.arity(same, 2);
    assert.name(same, 'is');
    assert.looksNative(same);
    assert.nonEnumerable(Object, 'is');
    assert.ok(same(1, 1), '1 is 1');
    assert.ok(same(NaN, NaN), '1 is 1');
    assert.ok(!same(0, -0), '0 isnt -0');
    return assert.ok(!same({}, {}), '{} isnt {}');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.keys', function(assert){
    var keys, fn1, fn2, i$, ref$, len$, value;
    keys = Object.keys;
    assert.isFunction(keys);
    assert.arity(keys, 1);
    assert.name(keys, 'keys');
    assert.looksNative(keys);
    assert.nonEnumerable(Object, 'keys');
    fn1 = function(w){
      this.w = w != null ? w : 2;
    };
    fn2 = function(toString){
      this.toString = toString != null ? toString : 2;
    };
    fn1.prototype.q = fn2.prototype.q = 1;
    assert.deepEqual(keys([1, 2, 3]), ['0', '1', '2']);
    assert.deepEqual(keys(new fn1(1)), ['w']);
    assert.deepEqual(keys(new fn2(1)), ['toString']);
    assert.ok(!in$('push', keys(Array.prototype)));
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
    }
    for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.throws(fn1$, TypeError, "throws on " + value);
    }
    function fn$(){
      try {
        keys(value);
        return true;
      } catch (e$) {}
    }
    function fn1$(){
      keys(value);
    }
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.preventExtensions', function(assert){
    var preventExtensions, isExtensible, keys, getOwnPropertyNames, i$, ref$, len$, value, key;
    preventExtensions = Object.preventExtensions, isExtensible = Object.isExtensible, keys = Object.keys, getOwnPropertyNames = Object.getOwnPropertyNames;
    assert.isFunction(preventExtensions);
    assert.arity(preventExtensions, 1);
    assert.name(preventExtensions, 'preventExtensions');
    assert.looksNative(preventExtensions);
    assert.nonEnumerable(Object, 'preventExtensions');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8, {}]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(preventExtensions(value), value, "returns target on " + toString$.call(value).slice(8, -1));
    }
    if (NATIVE) {
      assert.ok(isExtensible(preventExtensions({})));
    }
    assert.arrayEqual((function(){
      var results$ = [];
      for (key in preventExtensions({})) {
        results$.push(key);
      }
      return results$;
    }()), []);
    assert.arrayEqual(keys(preventExtensions({})), []);
    assert.arrayEqual(getOwnPropertyNames(preventExtensions({})), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(preventExtensions({})), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(preventExtensions({})), []);
    function fn$(){
      try {
        preventExtensions(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object.seal', function(assert){
    var seal, isSealed, keys, getOwnPropertyNames, i$, ref$, len$, value, key;
    seal = Object.seal, isSealed = Object.isSealed, keys = Object.keys, getOwnPropertyNames = Object.getOwnPropertyNames;
    assert.isFunction(seal);
    assert.arity(seal, 1);
    assert.name(seal, 'seal');
    assert.looksNative(seal);
    assert.nonEnumerable(Object, 'seal');
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false, null, void 8, {}]).length; i$ < len$; ++i$) {
      value = ref$[i$];
      assert.ok((fn$()), "accept " + toString$.call(value).slice(8, -1));
      assert.same(seal(value), value, "returns target on " + toString$.call(value).slice(8, -1));
    }
    if (NATIVE) {
      assert.ok(isSealed(seal({})));
    }
    assert.arrayEqual((function(){
      var results$ = [];
      for (key in seal({})) {
        results$.push(key);
      }
      return results$;
    }()), []);
    assert.arrayEqual(keys(seal({})), []);
    assert.arrayEqual(getOwnPropertyNames(seal({})), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(seal({})), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(seal({})), []);
    function fn$(){
      try {
        seal(value);
        return true;
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  if (PROTO) {
    module = QUnit.module, test = QUnit.test;
    module('ES6');
    test('Object.setPrototypeOf', function(assert){
      var setPrototypeOf, tmp;
      setPrototypeOf = Object.setPrototypeOf;
      assert.isFunction(setPrototypeOf);
      assert.arity(setPrototypeOf, 2);
      assert.name(setPrototypeOf, 'setPrototypeOf');
      assert.looksNative(setPrototypeOf);
      assert.nonEnumerable(Object, 'setPrototypeOf');
      assert.ok('apply' in setPrototypeOf({}, Function.prototype), 'Parent properties in target');
      assert.strictEqual(setPrototypeOf({
        a: 2
      }, {
        b: function(){
          return Math.pow(this.a, 2);
        }
      }).b(), 4, 'Child and parent properties in target');
      assert.strictEqual(setPrototypeOf(tmp = {}, {
        a: 1
      }), tmp, 'setPrototypeOf return target');
      return assert.ok(!('toString' in setPrototypeOf({}, null)), 'Can set null as prototype');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Object#toString', function(assert){
    var toString, i$, x$, ref$, len$, Constructor, Class;
    assert.arity(Object.prototype.toString, 0);
    assert.name(Object.prototype.toString, 'toString');
    assert.looksNative(Object.prototype.toString);
    assert.nonEnumerable(Object.prototype, 'toString');
    toString = Object.prototype.toString;
    if (STRICT) {
      assert.strictEqual(toString.call(null), '[object Null]', 'null -> `Null`');
      assert.strictEqual(toString.call(void 8), '[object Undefined]', 'undefined -> `Undefined`');
    }
    assert.strictEqual(toString.call(true), '[object Boolean]', 'bool -> `Boolean`');
    assert.strictEqual(toString.call('string'), '[object String]', 'string -> `String`');
    assert.strictEqual(toString.call(7), '[object Number]', 'number -> `Number`');
    (typeof Symbol != 'undefined' && Symbol !== null) && assert.strictEqual(toString.call(Symbol()), '[object Symbol]', 'symbol -> `Symbol`');
    assert.strictEqual(toString.call(new Boolean(false)), '[object Boolean]', 'new Boolean -> `Boolean`');
    assert.strictEqual(toString.call(new String('')), '[object String]', 'new String -> `String`');
    assert.strictEqual(toString.call(new Number(7)), '[object Number]', 'new Number -> `Number`');
    assert.strictEqual('' + {}, '[object Object]', '{} -> `Object`');
    assert.strictEqual(toString.call([]), '[object Array]', ' [] -> `Array`');
    assert.strictEqual(toString.call(function(){}), '[object Function]', 'function -> `Function`');
    assert.strictEqual(toString.call(/./), '[object RegExp]', 'regexp -> `RegExp`');
    assert.strictEqual(toString.call(TypeError()), '[object Error]', 'new TypeError -> `Error`');
    assert.strictEqual(toString.call(function(){
      return arguments;
    }()), '[object Arguments]', 'arguments -> `Arguments`');
    for (i$ = 0, len$ = (ref$ = ['Int8Array', 'Uint8Array', 'Uint8ClampedArray', 'Int16Array', 'Uint16Array', 'Int32Array', 'Uint32Array', 'Float32Array', 'Float64Array', 'ArrayBuffer']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Constructor = global[x$];
      if (Constructor) {
        assert.strictEqual(toString.call(new Constructor(1)), "[object " + x$ + "]", "new " + x$ + " -> `" + x$ + "`");
      }
    }
    if (NATIVE && (typeof DataView != 'undefined' && DataView !== null)) {
      assert.strictEqual('' + new DataView(new ArrayBuffer(1)), '[object DataView]', 'new DataView -> `DataView`');
    }
    if (typeof Set != 'undefined' && Set !== null) {
      assert.strictEqual('' + new Set, '[object Set]', 'set -> `Set`');
    }
    if (typeof Map != 'undefined' && Map !== null) {
      assert.strictEqual('' + new Map, '[object Map]', 'map -> `Map`');
    }
    if (typeof WeakSet != 'undefined' && WeakSet !== null) {
      assert.strictEqual('' + new WeakSet, '[object WeakSet]', 'weakset -> `WeakSet`');
    }
    if (typeof WeakMap != 'undefined' && WeakMap !== null) {
      assert.strictEqual('' + new WeakMap, '[object WeakMap]', 'weakmap -> `WeakMap`');
    }
    if (typeof Promise != 'undefined' && Promise !== null) {
      assert.strictEqual('' + new Promise(function(){}), '[object Promise]', 'promise -> `Promise`');
    }
    if (''[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]) {
      assert.strictEqual('' + ''[Symbol.iterator](), '[object String Iterator]', 'String Iterator -> `String Iterator`');
    }
    if ([].entries) {
      assert.strictEqual('' + [].entries(), '[object Array Iterator]', 'Array Iterator -> `Array Iterator`');
    }
    if ((typeof Set != 'undefined' && Set !== null) && Set.entries) {
      assert.strictEqual('' + new Set().entries(), '[object Set Iterator]', 'Set Iterator -> `Set Iterator`');
    }
    if ((typeof Map != 'undefined' && Map !== null) && Map.entries) {
      assert.strictEqual('' + new Map().entries(), '[object Map Iterator]', 'Map Iterator -> `Map Iterator`');
    }
    assert.strictEqual('' + Math, '[object Math]', 'Math -> `Math`');
    if (typeof JSON != 'undefined' && JSON !== null) {
      assert.strictEqual(toString.call(JSON), '[object JSON]', 'JSON -> `JSON`');
    }
    Class = (function(){
      Class.displayName = 'Class';
      var prototype = Class.prototype, constructor = Class;
      Class.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8] = 'Class';
      function Class(){}
      return Class;
    }());
    return assert.strictEqual('' + new Class, '[object Class]', 'user class instance -> [Symbol.toStringTag]');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('parseFloat', function(assert){
    var ws;
    assert.isFunction(parseFloat);
    assert.name(parseFloat, 'parseFloat');
    assert.arity(parseFloat, 1);
    assert.looksNative(parseFloat);
    assert.same(parseFloat('0'), 0);
    assert.same(parseFloat(' 0'), 0);
    assert.same(parseFloat('+0'), 0);
    assert.same(parseFloat(' +0'), 0);
    assert.same(parseFloat('-0'), -0);
    assert.same(parseFloat(' -0'), -0);
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseFloat(ws + '+0'), 0);
    assert.same(parseFloat(ws + '-0'), -0);
    assert.same(parseFloat(null), NaN);
    assert.same(parseFloat(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('parseInt', function(assert){
    var i$, r, x$, ref$, len$, ws, fakeZero;
    assert.isFunction(parseInt);
    assert.name(parseInt, 'parseInt');
    assert.arity(parseInt, 2);
    assert.looksNative(parseInt);
    for (i$ = 2; i$ <= 36; ++i$) {
      r = i$;
      assert.same(parseInt('10', r), r, "radix " + r);
    }
    for (i$ = 0, len$ = (ref$ = ['01', '08', '10', '42']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.same(parseInt(x$), parseInt(x$, 10), "default radix is 10: " + x$);
    }
    assert.same(parseInt('0x16'), parseInt('0x16', 16), "default radix is 16: 0x16");
    ws = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
    assert.same(parseInt('  0x16'), parseInt('0x16', 16), 'ignores leading whitespace #1');
    assert.same(parseInt('  42'), parseInt('42', 10), 'ignores leading whitespace #2');
    assert.same(parseInt('  08'), parseInt('08', 10), 'ignores leading whitespace #3');
    assert.same(parseInt(ws + '08'), parseInt('08', 10), 'ignores leading whitespace #4');
    assert.same(parseInt(ws + '0x16'), parseInt('0x16', 16), 'ignores leading whitespace #5');
    fakeZero = {
      valueOf: function(){
        return 0;
      }
    };
    assert.same(parseInt('08', fakeZero), parseInt('08', 10), 'valueOf #1');
    assert.same(parseInt('0x16', fakeZero), parseInt('0x16', 16), 'valueOf #2');
    assert.same(parseInt('-0xF'), -15, 'signed hex #1');
    assert.same(parseInt('-0xF', 16), -15, 'signed hex #2');
    assert.same(parseInt('+0xF'), 15, 'signed hex #3');
    assert.same(parseInt('+0xF', 16), 15, 'signed hex #4');
    assert.same(parseInt('10', -4294967294), 2, 'radix uses ToUint32');
    assert.same(parseInt(null), NaN);
    assert.same(parseInt(void 8), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  'use strict';
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Promise', function(assert){
    assert.isFunction(Promise);
    assert.arity(Promise, 1);
    assert.name(Promise, 'Promise');
    assert.looksNative(Promise);
    assert.throws(function(){
      Promise();
    }, 'throws w/o `new`');
    new Promise(function(resolve, reject){
      assert.isFunction(Promise, 'resolver is function');
      assert.isFunction(Promise, 'rejector is function');
      assert.same(this, function(){
        return this;
      }(), 'correct executor context');
    });
  });
  if (DESCRIPTORS) {
    test('Promise operations order', function(assert){
      var expected, async, result, resolve, p, resolve2, p2;
      assert.expect(1);
      expected = 'DEHAFGBC';
      async = assert.async();
      result = '';
      p = new Promise(function(r){
        resolve = r;
      });
      resolve({
        then: function(){
          result += 'A';
          throw Error();
        }
      });
      p['catch'](function(){
        result += 'B';
      });
      p['catch'](function(){
        result += 'C';
        assert.same(result, expected);
        async();
      });
      p2 = new Promise(function(r){
        resolve2 = r;
      });
      resolve2(Object.defineProperty({}, 'then', {
        get: function(){
          result += 'D';
          throw Error();
        }
      }));
      result += 'E';
      p2['catch'](function(){
        result += 'F';
      });
      p2['catch'](function(){
        result += 'G';
      });
      result += 'H';
      setTimeout(function(){
        if (~result.indexOf('C')) {
          assert.same(result, expected);
        }
      }, 1e3);
    });
  }
  test('Promise#then', function(assert){
    var promise, FakePromise1, FakePromise2;
    assert.isFunction(Promise.prototype.then);
    NATIVE && assert.arity(Promise.prototype.then, 2);
    assert.name(Promise.prototype.then, 'then');
    assert.looksNative(Promise.prototype.then);
    assert.nonEnumerable(Promise.prototype, 'then');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise.then(function(){}) instanceof FakePromise2, 'subclassing, @@species pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise.then(function(){}) instanceof Promise, 'subclassing, incorrect `this` pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = function(){};
    assert.throws(function(){
      promise.then(function(){});
    }, 'NewPromiseCapability validations, #1');
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = function(it){
      it(null, function(){});
    };
    assert.throws(function(){
      promise.then(function(){});
    }, 'NewPromiseCapability validations, #2');
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = function(it){
      it(function(){}, null);
    };
    assert.throws(function(){
      promise.then(function(){});
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise#catch', function(assert){
    var promise, FakePromise1, FakePromise2;
    assert.isFunction(Promise.prototype['catch']);
    NATIVE && assert.arity(Promise.prototype['catch'], 1);
    NATIVE && assert.name(Promise.prototype['catch'], 'catch');
    assert.looksNative(Promise.prototype['catch']);
    assert.nonEnumerable(Promise.prototype, 'catch');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise['catch'](function(){}) instanceof FakePromise2, 'subclassing, @@species pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(promise['catch'](function(){}) instanceof Promise, 'subclassing, incorrect `this` pattern');
    promise = new Promise(function(it){
      it(42);
    });
    promise.constructor = FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = function(){};
    assert.throws(function(){
      promise['catch'](function(){});
    }, 'NewPromiseCapability validations, #1');
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = function(it){
      it(null, function(){});
    };
    assert.throws(function(){
      promise['catch'](function(){});
    }, 'NewPromiseCapability validations, #2');
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = function(it){
      it(function(){}, null);
    };
    assert.throws(function(){
      promise['catch'](function(){});
    }, 'NewPromiseCapability validations, #3');
    assert.same(Promise.prototype['catch'].call({
      then: function(x, y){
        return y;
      }
    }, 42), 42, 'calling `.then`');
  });
  test('Promise#@@toStringTag', function(assert){
    assert.ok(Promise.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8] === 'Promise', 'Promise::@@toStringTag is `Promise`');
  });
  test('Promise.all', function(assert){
    var all, iter, a, done, resolve, FakePromise1, FakePromise2, FakePromise3;
    all = Promise.all;
    assert.isFunction(all);
    assert.arity(all, 1);
    assert.name(all, 'all');
    assert.looksNative(all);
    assert.nonEnumerable(Promise, 'all');
    iter = createIterable([1, 2, 3]);
    Promise.all(iter)['catch'](function(){});
    assert.ok(iter.received, 'works with iterables: iterator received');
    assert.ok(iter.called, 'works with iterables: next called');
    a = [];
    done = false;
    a[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
      done = true;
      return [][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call(this);
    };
    Promise.all(a);
    assert.ok(done);
    assert.throws(function(){
      all.call(null, [])['catch'](function(){});
    }, TypeError, 'throws without context');
    done = false;
    resolve = Promise.resolve;
    try {
      Promise.resolve = function(){
        throw 42;
      };
      Promise.all(createIterable([1, 2, 3], {
        'return': function(){
          done = true;
        }
      }))['catch'](function(){});
    } catch (e$) {}
    Promise.resolve = resolve;
    assert.ok(done, 'iteration closing');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1.resolve = FakePromise2.resolve = bind$(Promise, 'resolve');
    assert.ok(all.call(FakePromise1, [1, 2, 3]) instanceof FakePromise1, 'subclassing, `this` pattern');
    FakePromise1 = function(){};
    FakePromise2 = function(it){
      it(null, function(){});
    };
    FakePromise3 = function(it){
      it(function(){}, null);
    };
    FakePromise1.resolve = FakePromise2.resolve = FakePromise3.resolve = bind$(Promise, 'resolve');
    assert.throws(function(){
      all.call(FakePromise1, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      all.call(FakePromise2, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      all.call(FakePromise3, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise.race', function(assert){
    var race, iter, a, done, resolve, FakePromise1, FakePromise2, FakePromise3;
    race = Promise.race;
    assert.isFunction(race);
    assert.arity(race, 1);
    assert.name(race, 'race');
    assert.looksNative(race);
    assert.nonEnumerable(Promise, 'race');
    iter = createIterable([1, 2, 3]);
    Promise.race(iter)['catch'](function(){});
    assert.ok(iter.received, 'works with iterables: iterator received');
    assert.ok(iter.called, 'works with iterables: next called');
    a = [];
    done = false;
    a[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
      done = true;
      return [][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call(this);
    };
    Promise.race(a);
    assert.ok(done);
    assert.throws(function(){
      race.call(null, [])['catch'](function(){});
    }, TypeError, 'throws without context');
    done = false;
    resolve = Promise.resolve;
    try {
      Promise.resolve = function(){
        throw 42;
      };
      Promise.race(createIterable([1, 2, 3], {
        'return': function(){
          done = true;
        }
      }))['catch'](function(){});
    } catch (e$) {}
    Promise.resolve = resolve;
    assert.ok(done, 'iteration closing');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1.resolve = FakePromise2.resolve = bind$(Promise, 'resolve');
    assert.ok(race.call(FakePromise1, [1, 2, 3]) instanceof FakePromise1, 'subclassing, `this` pattern');
    FakePromise1 = function(){};
    FakePromise2 = function(it){
      it(null, function(){});
    };
    FakePromise3 = function(it){
      it(function(){}, null);
    };
    FakePromise1.resolve = FakePromise2.resolve = FakePromise3.resolve = bind$(Promise, 'resolve');
    assert.throws(function(){
      race.call(FakePromise1, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      race.call(FakePromise2, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      race.call(FakePromise3, [1, 2, 3]);
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise.resolve', function(assert){
    var resolve, FakePromise1, FakePromise2;
    resolve = Promise.resolve;
    assert.isFunction(resolve);
    NATIVE && assert.arity(resolve, 1);
    assert.name(resolve, 'resolve');
    assert.looksNative(resolve);
    assert.nonEnumerable(Promise, 'resolve');
    assert.throws(function(){
      resolve.call(null, 1)['catch'](function(){});
    }, TypeError, 'throws without context');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(resolve.call(FakePromise1, 42) instanceof FakePromise1, 'subclassing, `this` pattern');
    assert.throws(function(){
      resolve.call(function(){}, 42);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      resolve.call(function(it){
        it(null, function(){});
      }, 42);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      resolve.call(function(it){
        it(function(){}, null);
      }, 42);
    }, 'NewPromiseCapability validations, #3');
  });
  test('Promise.reject', function(assert){
    var reject, FakePromise1, FakePromise2;
    reject = Promise.reject;
    assert.isFunction(reject);
    NATIVE && assert.arity(reject, 1);
    assert.name(reject, 'reject');
    assert.looksNative(reject);
    assert.nonEnumerable(Promise, 'reject');
    assert.throws(function(){
      reject.call(null, 1)['catch'](function(){});
    }, TypeError, 'throws without context');
    FakePromise1 = function(it){
      it(function(){}, function(){});
    };
    FakePromise1[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8] = FakePromise2 = function(it){
      it(function(){}, function(){});
    };
    assert.ok(reject.call(FakePromise1, 42) instanceof FakePromise1, 'subclassing, `this` pattern');
    assert.throws(function(){
      reject.call(function(){}, 42);
    }, 'NewPromiseCapability validations, #1');
    assert.throws(function(){
      reject.call(function(it){
        it(null, function(){});
      }, 42);
    }, 'NewPromiseCapability validations, #2');
    assert.throws(function(){
      reject.call(function(it){
        it(function(){}, null);
      }, 42);
    }, 'NewPromiseCapability validations, #3');
  });
  if (PROTO) {
    test('Promise subclassing', function(assert){
      var SubPromise, p1, p2, p3;
      SubPromise = function(it){
        var self;
        self = new Promise(it);
        Object.setPrototypeOf(self, SubPromise.prototype);
        self.mine = 'subclass';
        return self;
      };
      Object.setPrototypeOf(SubPromise, Promise);
      SubPromise.prototype = Object.create(Promise.prototype);
      SubPromise.prototype.constructor = SubPromise;
      p1 = SubPromise.resolve(5);
      assert.strictEqual(p1.mine, 'subclass');
      p1 = p1.then(function(it){
        return assert.strictEqual(it, 5);
      });
      assert.strictEqual(p1.mine, 'subclass');
      p2 = new SubPromise(function(it){
        return it(6);
      });
      assert.strictEqual(p2.mine, 'subclass');
      p2 = p2.then(function(it){
        return assert.strictEqual(it, 6);
      });
      assert.strictEqual(p2.mine, 'subclass');
      p3 = SubPromise.all([p1, p2]);
      assert.strictEqual(p3.mine, 'subclass');
      assert.ok(p3 instanceof Promise);
      assert.ok(p3 instanceof SubPromise);
      p3.then(assert.async(), function(it){
        return assert.ok(it, false);
      });
    });
  }
  QUnit.skip('Unhandled rejection tracking', function(assert){
    var done, start, onunhandledrejection, onrejectionhandled, $promise;
    done = false;
    start = assert.async();
    if (typeof process != 'undefined' && process !== null) {
      assert.expect(3);
      process.on('unhandledRejection', onunhandledrejection = function(reason, promise){
        process.removeListener('unhandledRejection', onunhandledrejection);
        assert.same(promise, $promise, 'unhandledRejection, promise');
        assert.same(reason, 42, 'unhandledRejection, reason');
        $promise['catch'](function(){});
      });
      process.on('rejectionHandled', onrejectionhandled = function(promise){
        process.removeListener('rejectionHandled', onrejectionhandled);
        assert.same(promise, $promise, 'rejectionHandled, promise');
        done || start();
        done = true;
      });
    } else {
      assert.expect(4);
      global.onunhandledrejection = function(it){
        assert.same(it.promise, $promise, 'onunhandledrejection, promise');
        assert.same(it.reason, 42, 'onunhandledrejection, reason');
        setTimeout(function(){
          $promise['catch'](function(){});
        }, 1);
        global.onunhandledrejection = null;
      };
      global.onrejectionhandled = function(it){
        assert.same(it.promise, $promise, 'onrejectionhandled, promise');
        assert.same(it.reason, 42, 'onrejectionhandled, reason');
        global.onrejectionhandled = null;
        done || start();
        done = true;
      };
    }
    Promise.reject(43)['catch'](function(){});
    $promise = Promise.reject(42);
    setTimeout(function(){
      done || start();
      done = true;
    }, 3e3);
  });
  function bind$(obj, key, target){
    return function(){ return (target || obj)[key].apply(obj, arguments) };
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.apply', function(assert){
    var apply, C;
    apply = Reflect.apply;
    assert.isFunction(apply);
    assert.arity(apply, 3);
    assert.name(apply, 'apply');
    assert.looksNative(apply);
    assert.nonEnumerable(Reflect, 'apply');
    assert.strictEqual(apply(Array.prototype.push, [1, 2], [3, 4, 5]), 5);
    C = function(a, b, c){
      return a + b + c;
    };
    C.apply = 42;
    assert.strictEqual(apply(C, null, ['foo', 'bar', 'baz']), 'foobarbaz', 'works with redefined apply');
    assert.throws(function(){
      apply(42, null, []);
    }, TypeError, 'throws on primitive as first argument');
    assert.throws(function(){
      apply(function(){}, null);
    }, TypeError, 'throws without third argument');
    assert.throws(function(){
      apply(function(){}, null, '123');
    }, TypeError, 'throws on primitive as third argument');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, getPrototypeOf;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  getPrototypeOf = Object.getPrototypeOf;
  test('Reflect.construct', function(assert){
    var construct, C, inst, f, e;
    construct = Reflect.construct;
    assert.isFunction(construct);
    assert.arity(construct, 2);
    assert.name(construct, 'construct');
    assert.looksNative(construct);
    assert.nonEnumerable(Reflect, 'construct');
    C = function(a, b, c){
      return this.qux = a + b + c;
    };
    assert.strictEqual(construct(C, ['foo', 'bar', 'baz']).qux, 'foobarbaz', 'basic');
    C.apply = 42;
    assert.strictEqual(construct(C, ['foo', 'bar', 'baz']).qux, 'foobarbaz', 'works with redefined apply');
    inst = construct(function(){
      this.x = 42;
    }, [], Array);
    assert.strictEqual(inst.x, 42, 'constructor with newTarget');
    assert.ok(inst instanceof Array, 'prototype with newTarget');
    assert.throws(function(){
      construct(42, []);
    }, TypeError, 'throws on primitive');
    f = function(){};
    f.prototype = 42;
    assert.ok((function(){
      try {
        return getPrototypeOf(construct(f, [])) === Object.prototype;
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    assert.same(typeof (function(){
      try {
        return construct(Date, []).getTime();
      } catch (e$) {}
    }()), 'number', 'works with native constructors with 2 arguments');
    assert.throws(function(){
      construct(function(){});
    }, 'throws when the second argument is not an object');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, getOwnPropertyDescriptor;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
  test('Reflect.defineProperty', function(assert){
    var defineProperty, create, O;
    defineProperty = Reflect.defineProperty;
    create = Reflect.create;
    assert.isFunction(defineProperty);
    assert.arity(defineProperty, 3);
    assert.name(defineProperty, 'defineProperty');
    assert.looksNative(defineProperty);
    assert.nonEnumerable(Reflect, 'defineProperty');
    O = {};
    assert.strictEqual(defineProperty(O, 'foo', {
      value: 123
    }), true);
    assert.strictEqual(O.foo, 123);
    if (DESCRIPTORS) {
      O = {};
      defineProperty(O, 'foo', {
        value: 123,
        enumerable: true
      });
      assert.deepEqual(getOwnPropertyDescriptor(O, 'foo'), {
        value: 123,
        enumerable: true,
        configurable: false,
        writable: false
      });
      assert.strictEqual(defineProperty(O, 'foo', {
        value: 42
      }), false);
    }
    assert.throws(function(){
      defineProperty(42, 'foo', {
        value: 42
      });
    }, TypeError, 'throws on primitive');
    assert.throws(function(){
      defineProperty(42, 1, {});
    });
    assert.throws(function(){
      defineProperty({}, create(null), {});
    });
    assert.throws(function(){
      defineProperty({}, 1, 1);
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty;
  test('Reflect.deleteProperty', function(assert){
    var deleteProperty, O;
    deleteProperty = Reflect.deleteProperty;
    assert.isFunction(deleteProperty);
    assert.arity(deleteProperty, 2);
    assert.name(deleteProperty, 'deleteProperty');
    assert.looksNative(deleteProperty);
    assert.nonEnumerable(Reflect, 'deleteProperty');
    O = {
      bar: 456
    };
    assert.strictEqual(deleteProperty(O, 'bar'), true);
    assert.ok(!in$('bar', O));
    if (DESCRIPTORS) {
      assert.strictEqual(deleteProperty(defineProperty({}, 'foo', {
        value: 42
      }), 'foo'), false);
    }
    return assert.throws(function(){
      return deleteProperty(42, 'foo');
    }, TypeError, 'throws on primitive');
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, from;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty;
  from = Array.from;
  test('Reflect.enumerate', function(assert){
    var enumerate, iterator, obj, i, ref$;
    enumerate = Reflect.enumerate;
    iterator = Symbol.iterator;
    assert.isFunction(enumerate);
    assert.arity(enumerate, 1);
    assert.name(enumerate, 'enumerate');
    assert.looksNative(enumerate);
    assert.nonEnumerable(Reflect, 'enumerate');
    obj = {
      foo: 1,
      bar: 2
    };
    i = enumerate(obj);
    assert.isIterable(i);
    assert.deepEqual(from(i), ['foo', 'bar'], 'bisic');
    obj = {
      q: 1,
      w: 2,
      e: 3
    };
    i = enumerate(obj);
    delete obj.w;
    assert.deepEqual(from(i), ['q', 'e'], 'ignore holes');
    obj = (ref$ = clone$({
      q: 1,
      w: 2,
      e: 3
    }), ref$.a = 4, ref$.s = 5, ref$.d = 6, ref$);
    assert.deepEqual(from(enumerate(obj)).sort(), ['a', 'd', 'e', 'q', 's', 'w'], 'works with prototype');
    return assert.throws(function(){
      return enumerate(42);
    }, TypeError, 'throws on primitive');
  });
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.getOwnPropertyDescriptor', function(assert){
    var getOwnPropertyDescriptor, obj, desc;
    getOwnPropertyDescriptor = Reflect.getOwnPropertyDescriptor;
    assert.isFunction(getOwnPropertyDescriptor);
    assert.arity(getOwnPropertyDescriptor, 2);
    assert.name(getOwnPropertyDescriptor, 'getOwnPropertyDescriptor');
    assert.looksNative(getOwnPropertyDescriptor);
    assert.nonEnumerable(Reflect, 'getOwnPropertyDescriptor');
    obj = {
      baz: 789
    };
    desc = getOwnPropertyDescriptor(obj, 'baz');
    assert.strictEqual(desc.value, 789);
    return assert.throws(function(){
      return getOwnPropertyDescriptor(42, 'constructor');
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.getPrototypeOf', function(assert){
    var getPrototypeOf;
    getPrototypeOf = Reflect.getPrototypeOf;
    assert.isFunction(getPrototypeOf);
    assert.arity(getPrototypeOf, 1);
    assert.name(getPrototypeOf, 'getPrototypeOf');
    assert.looksNative(getPrototypeOf);
    assert.nonEnumerable(Reflect, 'getPrototypeOf');
    assert.strictEqual(getPrototypeOf([]), Array.prototype);
    return assert.throws(function(){
      return getPrototypeOf(42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, create;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty, create = Object.create;
  test('Reflect.get', function(assert){
    var get, target, receiver;
    get = Reflect.get;
    assert.isFunction(get);
    NATIVE && assert.arity(get, 2);
    assert.name(get, 'get');
    assert.looksNative(get);
    assert.nonEnumerable(Reflect, 'get');
    assert.strictEqual(get({
      qux: 987
    }, 'qux'), 987);
    if (DESCRIPTORS) {
      target = create(defineProperty({
        z: 3
      }, 'w', {
        get: function(){
          return this;
        }
      }), {
        x: {
          value: 1
        },
        y: {
          get: function(){
            return this;
          }
        }
      });
      receiver = {};
      assert.strictEqual(get(target, 'x', receiver), 1, 'get x');
      assert.strictEqual(get(target, 'y', receiver), receiver, 'get y');
      assert.strictEqual(get(target, 'z', receiver), 3, 'get z');
      assert.strictEqual(get(target, 'w', receiver), receiver, 'get w');
      assert.strictEqual(get(target, 'u', receiver), void 8, 'get u');
    }
    return assert.throws(function(){
      return get(42, 'constructor');
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Reflect.has', function(assert){
    var has, O;
    has = Reflect.has;
    assert.isFunction(has);
    assert.arity(has, 2);
    assert.name(has, 'has');
    assert.looksNative(has);
    assert.nonEnumerable(Reflect, 'has');
    O = {
      qux: 987
    };
    assert.strictEqual(has(O, 'qux'), true);
    assert.strictEqual(has(O, 'qwe'), false);
    assert.strictEqual(has(O, 'toString'), true);
    return assert.throws(function(){
      return has(42, 'constructor');
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, preventExtensions;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty, preventExtensions = Object.preventExtensions;
  test('Reflect.isExtensible', function(assert){
    var isExtensible;
    isExtensible = Reflect.isExtensible;
    assert.isFunction(isExtensible);
    assert.arity(isExtensible, 1);
    assert.name(isExtensible, 'isExtensible');
    assert.looksNative(isExtensible);
    assert.nonEnumerable(Reflect, 'isExtensible');
    assert.ok(isExtensible({}));
    if (DESCRIPTORS) {
      assert.ok(!isExtensible(preventExtensions({})));
    }
    return assert.throws(function(){
      return isExtensible(42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty;
  test('Reflect.ownKeys', function(assert){
    var ownKeys, sym, O1, keys, O2;
    ownKeys = Reflect.ownKeys;
    sym = Symbol('c');
    assert.isFunction(ownKeys);
    assert.arity(ownKeys, 1);
    assert.name(ownKeys, 'ownKeys');
    assert.looksNative(ownKeys);
    assert.nonEnumerable(Reflect, 'ownKeys');
    O1 = {
      a: 1
    };
    defineProperty(O1, 'b', {
      value: 2
    });
    O1[sym] = 3;
    keys = ownKeys(O1);
    assert.strictEqual(keys.length, 3, 'ownKeys return all own keys');
    assert.ok(in$('a', keys), 'ownKeys return all own keys: simple');
    assert.ok(in$('b', keys), 'ownKeys return all own keys: hidden');
    assert.strictEqual(O1[keys[2]], 3, 'ownKeys return all own keys: symbol');
    O2 = clone$(O1);
    keys = ownKeys(O2);
    assert.strictEqual(keys.length, 0, 'ownKeys return only own keys');
    return assert.throws(function(){
      return ownKeys(42);
    }, TypeError, 'throws on primitive');
  });
  function in$(x, xs){
    var i = -1, l = xs.length >>> 0;
    while (++i < l) if (x === xs[i]) return true;
    return false;
  }
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, isExtensible;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty, isExtensible = Object.isExtensible;
  test('Reflect.preventExtensions', function(assert){
    var preventExtensions, obj;
    preventExtensions = Reflect.preventExtensions;
    assert.isFunction(preventExtensions);
    assert.arity(preventExtensions, 1);
    assert.name(preventExtensions, 'preventExtensions');
    assert.looksNative(preventExtensions);
    assert.nonEnumerable(Reflect, 'preventExtensions');
    obj = {};
    assert.ok(preventExtensions(obj), true);
    if (DESCRIPTORS) {
      assert.ok(!isExtensible(obj));
    }
    return assert.throws(function(){
      return preventExtensions(42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  if (PROTO) {
    module = QUnit.module, test = QUnit.test;
    module('ES6');
    test('Reflect.setPrototypeOf', function(assert){
      var setPrototypeOf, obj, o;
      setPrototypeOf = Reflect.setPrototypeOf;
      assert.isFunction(setPrototypeOf);
      NATIVE && assert.arity(setPrototypeOf, 2);
      assert.name(setPrototypeOf, 'setPrototypeOf');
      assert.looksNative(setPrototypeOf);
      assert.nonEnumerable(Reflect, 'setPrototypeOf');
      obj = {};
      assert.ok(setPrototypeOf(obj, Array.prototype), true);
      assert.ok(obj instanceof Array);
      assert.throws(function(){
        return setPrototypeOf({}, 42);
      }, TypeError);
      assert.throws(function(){
        return setPrototypeOf(42, {});
      }, TypeError, 'throws on primitive');
      return assert.ok(setPrototypeOf(o = {}, o) === false, 'false on recursive __proto__');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, getOwnPropertyDescriptor, create;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, create = Object.create;
  test('Reflect.set', function(assert){
    var set, obj, target, receiver, out;
    set = Reflect.set;
    assert.isFunction(set);
    NATIVE && assert.arity(set, 3);
    assert.name(set, 'set');
    assert.looksNative(set);
    assert.nonEnumerable(Reflect, 'set');
    obj = {};
    assert.ok(set(obj, 'quux', 654), true);
    assert.strictEqual(obj.quux, 654);
    target = {};
    receiver = {};
    set(target, 'foo', 1, receiver);
    assert.strictEqual(target.foo, void 8, 'target.foo === undefined');
    assert.strictEqual(receiver.foo, 1, 'receiver.foo === 1');
    if (DESCRIPTORS) {
      defineProperty(receiver, 'bar', {
        value: 0,
        writable: true,
        enumerable: false,
        configurable: true
      });
      set(target, 'bar', 1, receiver);
      assert.strictEqual(receiver.bar, 1, 'receiver.bar === 1');
      assert.strictEqual(getOwnPropertyDescriptor(receiver, 'bar').enumerable, false, 'enumerability not overridden');
      target = create(defineProperty({
        z: 3
      }, 'w', {
        set: function(){
          out = this;
        }
      }), {
        x: {
          value: 1,
          writable: true,
          configurable: true
        },
        y: {
          set: function(){
            out = this;
          }
        },
        c: {
          value: 1,
          writable: false,
          configurable: false
        }
      });
      assert.strictEqual(set(target, 'x', 2, target), true, 'set x');
      assert.strictEqual(target.x, 2, 'set x');
      out = null;
      assert.strictEqual(set(target, 'y', 2, target), true, 'set y');
      assert.strictEqual(out, target, 'set y');
      assert.strictEqual(set(target, 'z', 4, target), true);
      assert.strictEqual(target.z, 4, 'set z');
      out = null;
      assert.strictEqual(set(target, 'w', 1, target), true, 'set w');
      assert.strictEqual(out, target, 'set w');
      assert.strictEqual(set(target, 'u', 0, target), true, 'set u');
      assert.strictEqual(target.u, 0, 'set u');
      assert.strictEqual(set(target, 'c', 2, target), false, 'set c');
      assert.strictEqual(target.c, 1, 'set c');
    }
    return assert.throws(function(){
      return set(42, 'q', 42);
    }, TypeError, 'throws on primitive');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  if (DESCRIPTORS) {
    test('RegExp constructor', function(assert){
      var re, O, result, i$, len$, index, val, C;
      assert.isFunction(RegExp);
      assert.arity(RegExp, 2);
      assert.name(RegExp, 'RegExp');
      assert.looksNative(RegExp);
      assert.strictEqual(toString$.call(RegExp()).slice(8, -1), 'RegExp');
      assert.strictEqual(toString$.call(new RegExp()).slice(8, -1), 'RegExp');
      re = /a/g;
      assert.notStrictEqual(re, new RegExp(re), 'new RegExp(re) isnt re');
      assert.strictEqual(re, RegExp(re), 'RegExp(re) is re');
      re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = false;
      assert.notStrictEqual(re, RegExp(re), 'RegExp(re) isnt re, changed Symbol.match');
      O = {};
      assert.notStrictEqual(O, RegExp(O), 'RegExp(O) isnt O');
      O[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = true;
      O.constructor = RegExp;
      assert.strictEqual(O, RegExp(O), 'RegExp(O) is O, changed Symbol.match');
      assert.strictEqual(String(re), '/a/g', 'b is /a/g');
      assert.strictEqual(String(new RegExp(/a/g, 'mi')), '/a/im', 'Allows a regex with flags');
      assert.ok(new RegExp(/a/g, 'im') instanceof RegExp, 'Works with instanceof');
      assert.strictEqual(new RegExp(/a/g, 'im').constructor, RegExp, 'Has the right constructor');
      /(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)/.exec('abcdefghijklmnopq');
      result = true;
      for (i$ = 0, len$ = 'bcdefghij'.length; i$ < len$; ++i$) {
        index = i$;
        val = 'bcdefghij'[i$];
        if (RegExp["$" + (index + 1)] !== val) {
          result = false;
        }
      }
      assert.ok(result, "Updates RegExp globals");
      if (nativeSubclass) {
        C = nativeSubclass(RegExp);
        assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
        assert.ok(new C instanceof RegExp, 'correct subclassing with native classes #2');
        assert.ok(new C('^abc$').test('abc'), 'correct subclassing with native classes #3');
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  QUnit.test('RegExp#exec lastIndex updating', function(assert){
    var re;
    re = /b/;
    assert.strictEqual(re.lastIndex, 0, '.lastIndex starts at 0 for non-global regexps');
    re.exec('abc');
    assert.strictEqual(re.lastIndex, 0, '.lastIndex isn\'t updated for non-global regexps');
    re = /b/g;
    assert.strictEqual(re.lastIndex, 0, '.lastIndex starts at 0 for global regexps');
    re.exec('abc');
    assert.strictEqual(re.lastIndex, 2, '.lastIndex is updated for global regexps');
    re = /b*/;
    re.exec('a');
    assert.strictEqual(re.lastIndex, 0, '.lastIndex isn\'t updated for non-global regexps if the match is empty');
    re = /b*/g;
    re.exec('a');
    assert.strictEqual(re.lastIndex, 0, '.lastIndex isn\'t updated for global regexps if the match is empty');
  });
  QUnit.test('RegExp#exec capturing groups', function(assert){
    assert.deepEqual(/(a?)/.exec('x'), ['', ''], '/(a?)/.exec("x") returns ["", ""]');
    assert.deepEqual(/(a)?/.exec('x'), ['', void 8], '/(a)?/.exec("x") returns ["", undefined]');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  if (DESCRIPTORS) {
    test('RegExp#flags', function(assert){
      assert.nonEnumerable(RegExp.prototype, 'flags');
      assert.strictEqual(/./g.flags, 'g', '/./g.flags is "g"');
      assert.strictEqual(/./.flags, '', '/./.flags is ""');
      assert.strictEqual(RegExp('.', 'gim').flags, 'gim', 'RegExp(".", "gim").flags is "gim"');
      assert.strictEqual(RegExp('.').flags, '', 'RegExp(".").flags is ""');
      assert.strictEqual(/./gim.flags, 'gim', '/./gim.flags is "gim"');
      assert.strictEqual(/./gmi.flags, 'gim', '/./gmi.flags is "gim"');
      assert.strictEqual(/./mig.flags, 'gim', '/./mig.flags is "gim"');
      return assert.strictEqual(/./mgi.flags, 'gim', '/./mgi.flags is "gim"');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, run;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  run = function(assert){
    var instance, matched, expected, obj, str, x, e, reg, string, matches, i$, len$, i, re, num;
    assert.isFunction(''.match);
    assert.arity(''.match, 1);
    assert.name(''.match, 'match');
    assert.looksNative(''.match);
    assert.nonEnumerable(String.prototype, 'match');
    instance = Object(true);
    instance.match = String.prototype.match;
    assert.strictEqual(instance.match(true)[0], 'true', 'S15.5.4.10_A1_T1');
    instance = Object(false);
    instance.match = String.prototype.match;
    assert.strictEqual(instance.match(function(){
      return false;
    }())[0], 'false', 'S15.5.4.10_A1_T2');
    matched = ''.match();
    expected = RegExp().exec('');
    assert.strictEqual(matched.length, expected.length, 'S15.5.4.10_A1_T4 #1');
    assert.strictEqual(matched.index, expected.index, 'S15.5.4.10_A1_T4 #2');
    assert.strictEqual(matched.input, expected.input, 'S15.5.4.10_A1_T4 #3');
    assert.strictEqual('gnulluna'.match(null)[0], 'null', 'S15.5.4.10_A1_T5');
    matched = Object('undefined').match(x);
    expected = RegExp(x).exec('undefined');
    assert.strictEqual(matched.length, expected.length, 'S15.5.4.10_A1_T6 #1');
    assert.strictEqual(matched.index, expected.index, 'S15.5.4.10_A1_T6 #2');
    assert.strictEqual(matched.input, expected.input, 'S15.5.4.10_A1_T6 #3');
    matched = String('undefined').match(undefined);
    expected = RegExp(undefined).exec('undefined');
    assert.strictEqual(matched.length, expected.length, 'S15.5.4.10_A1_T7 #1');
    assert.strictEqual(matched.index, expected.index, 'S15.5.4.10_A1_T7 #2');
    assert.strictEqual(matched.input, expected.input, 'S15.5.4.10_A1_T7 #3');
    obj = {
      toString: function(){}
    };
    matched = String(obj).match(void 8);
    expected = RegExp(void 8).exec('undefined');
    assert.strictEqual(matched.length, expected.length, 'S15.5.4.10_A1_T8 #1');
    assert.strictEqual(matched.index, expected.index, 'S15.5.4.10_A1_T8 #2');
    assert.strictEqual(matched.input, expected.input, 'S15.5.4.10_A1_T8 #3');
    obj = {
      toString: function(){
        return '\u0041B';
      }
    };
    str = 'ABB\u0041BABAB';
    assert.strictEqual(str.match(obj)[0], 'AB', 'S15.5.4.10_A1_T10');
    obj = {
      toString: function(){
        throw 'intostr';
      }
    };
    str = 'ABB\u0041BABAB';
    try {
      x = str.match(obj);
      assert.ok(false, 'S15.5.4.10_A1_T11 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.strictEqual(e, 'intostr', 'S15.5.4.10_A1_T11 #1.1: Exception === "intostr". Actual: ' + e);
    }
    obj = {
      toString: function(){
        return {};
      },
      valueOf: function(){
        throw 'intostr';
      }
    };
    str = 'ABB\u0041BABAB';
    try {
      x = str.match(obj);
      assert.ok(false, 'S15.5.4.10_A1_T12 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.strictEqual(e, 'intostr', 'S15.5.4.10_A1_T12 #1.1: Exception === "intostr". Actual: ' + e);
    }
    obj = {
      toString: function(){
        return {};
      },
      valueOf: function(){
        return 1;
      }
    };
    assert.strictEqual('ABB\u0041B\u0031ABAB\u0031BBAA'.match(obj)[0], '1', 'S15.5.4.10_A1_T13 #1');
    assert.strictEqual('ABB\u0041B\u0031ABAB\u0031BBAA'.match(obj).length, 1, 'S15.5.4.10_A1_T13 #2');
    reg = RegExp('77');
    assert.strictEqual('ABB\u0041BABAB\u0037\u0037BBAA'.match(reg)[0], '77', 'S15.5.4.10_A1_T14');
    string = '1234567890';
    assert.strictEqual(string.match(3)[0], '3', 'S15.5.4.10_A2_T1 #1');
    assert.strictEqual(string.match(3).length, 1, 'S15.5.4.10_A2_T1 #2');
    assert.strictEqual(string.match(3).index, 2, 'S15.5.4.10_A2_T1 #3');
    assert.strictEqual(string.match(3).input, string, 'S15.5.4.10_A2_T1 #4');
    matches = ['34', '34', '34'];
    string = '343443444';
    assert.strictEqual(string.match(/34/g).length, 3, 'S15.5.4.10_A2_T2 #1');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(/34/g)[i], matches[i], "S15.5.4.10_A2_T2 #2");
    }
    matches = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0'];
    string = '123456abcde7890';
    assert.strictEqual(string.match(/\d{1}/g).length, 10, 'S15.5.4.10_A2_T3 #1');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(/\d{1}/g)[i], matches[i], "S15.5.4.10_A2_T3 #2");
    }
    matches = ['12', '34', '56', '78', '90'];
    string = '123456abcde7890';
    assert.strictEqual(string.match(/\d{2}/g).length, 5, 'S15.5.4.10_A2_T4 #1');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(/\d{2}/g)[i], matches[i], "S15.5.4.10_A2_T4 #2");
    }
    matches = ['ab', 'cd'];
    string = '123456abcde7890';
    assert.strictEqual(string.match(/\D{2}/g).length, 2, 'S15.5.4.10_A2_T5 #1');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(/\D{2}/g)[i], matches[i], "S15.5.4.10_A2_T5 #2");
    }
    string = "Boston, Mass. 02134";
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/)[0], '02134', 'S15.5.4.10_A2_T6 #1');
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/)[1], '02134', 'S15.5.4.10_A2_T6 #2');
    NATIVE && assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/)[2], void 8, 'S15.5.4.10_A2_T6 #3');
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/).length, 3, 'S15.5.4.10_A2_T6 #4');
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/).index, 14, 'S15.5.4.10_A2_T6 #5');
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/).input, string, 'S15.5.4.10_A2_T6 #6');
    string = "Boston, Mass. 02134";
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/g).length, 1, 'S15.5.4.10_A2_T7 #1');
    assert.strictEqual(string.match(/([\d]{5})([-\ ]?[\d]{4})?$/g)[0], '02134', 'S15.5.4.10_A2_T7 #2');
    matches = ['02134', '02134', 'undefined'];
    string = "Boston, MA 02134";
    re = /([\d]{5})([-\ ]?[\d]{4})?$/;
    re.lastIndex = 0;
    assert.strictEqual(string.match(re).length, 3, 'S15.5.4.10_A2_T8 #1');
    assert.strictEqual(string.match(re).index, string.lastIndexOf('0'), 'S15.5.4.10_A2_T8 #2');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(re)[i], matches[i], "S15.5.4.10_A2_T8 #3");
    }
    string = "Boston, MA 02134";
    matches = ['02134', '02134', void 8];
    re = /([\d]{5})([-\ ]?[\d]{4})?$/;
    re.lastIndex = string.length;
    assert.strictEqual(string.match(re).length, 3, 'S15.5.4.10_A2_T9 #1');
    assert.strictEqual(string.match(re).index, string.lastIndexOf('0'), 'S15.5.4.10_A2_T9 #2');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(re)[i], matches[i], "S15.5.4.10_A2_T9 #3");
    }
    string = "Boston, MA 02134";
    matches = ['02134', '02134', void 8];
    re = /([\d]{5})([-\ ]?[\d]{4})?$/;
    re.lastIndex = string.lastIndexOf('0');
    assert.strictEqual(string.match(re).length, 3, 'S15.5.4.10_A2_T10 #1');
    assert.strictEqual(string.match(re).index, string.lastIndexOf('0'), 'S15.5.4.10_A2_T10 #2');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(re)[i], matches[i], "S15.5.4.10_A2_T10 #3");
    }
    string = "Boston, MA 02134";
    matches = ['02134', '02134', void 8];
    re = /([\d]{5})([-\ ]?[\d]{4})?$/;
    re.lastIndex = string.lastIndexOf('0') + 1;
    assert.strictEqual(string.match(re).length, 3, 'S15.5.4.10_A2_T11 #1');
    assert.strictEqual(string.match(re).index, string.lastIndexOf('0'), 'S15.5.4.10_A2_T11 #2');
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      assert.strictEqual(string.match(re)[i], matches[i], "S15.5.4.10_A2_T11 #3");
    }
    string = "Boston, MA 02134";
    re = /([\d]{5})([-\ ]?[\d]{4})?$/g;
    assert.strictEqual(string.match(re).length, 1, 'S15.5.4.10_A2_T12 #1');
    assert.strictEqual(string.match(re)[0], '02134', 'S15.5.4.10_A2_T12 #2');
    re = /([\d]{5})([-\ ]?[\d]{4})?$/g;
    re.lastIndex = 0;
    string = "Boston, MA 02134";
    assert.strictEqual(string.match(re).length, 1, 'S15.5.4.10_A2_T13 #1');
    assert.strictEqual(string.match(re)[0], '02134', 'S15.5.4.10_A2_T13 #2');
    string = "Boston, MA 02134";
    re = /([\d]{5})([-\ ]?[\d]{4})?$/g;
    re.lastIndex = string.length;
    assert.strictEqual(string.match(re).length, 1, 'S15.5.4.10_A2_T14 #1');
    assert.strictEqual(string.match(re)[0], '02134', 'S15.5.4.10_A2_T14 #2');
    string = "Boston, MA 02134";
    re = /([\d]{5})([-\ ]?[\d]{4})?$/g;
    re.lastIndex = string.lastIndexOf('0');
    assert.strictEqual(string.match(re).length, 1, 'S15.5.4.10_A2_T15 #1');
    assert.strictEqual(string.match(re)[0], '02134', 'S15.5.4.10_A2_T15 #2');
    string = "Boston, MA 02134";
    re = /([\d]{5})([-\ ]?[\d]{4})?$/g;
    re.lastIndex = string.lastIndexOf('0') + 1;
    assert.strictEqual(string.match(re).length, 1, 'S15.5.4.10_A2_T16 #1');
    assert.strictEqual(string.match(re)[0], '02134', 'S15.5.4.10_A2_T16 #2');
    re = /0./;
    num = 10203040506070809000;
    assert.strictEqual(''.match.call(num, re)[0], '02', 'S15.5.4.10_A2_T17 #1');
    assert.strictEqual(''.match.call(num, re).length, 1, 'S15.5.4.10_A2_T17 #2');
    assert.strictEqual(''.match.call(num, re).index, 1, 'S15.5.4.10_A2_T17 #3');
    assert.strictEqual(''.match.call(num, re).input, String(num), 'S15.5.4.10_A2_T17 #4');
    re = /0./;
    re.lastIndex = 0;
    num = 10203040506070809000;
    assert.strictEqual(''.match.call(num, re)[0], '02', 'S15.5.4.10_A2_T18 #1');
    assert.strictEqual(''.match.call(num, re).length, 1, 'S15.5.4.10_A2_T18 #2');
    assert.strictEqual(''.match.call(num, re).index, 1, 'S15.5.4.10_A2_T18 #3');
    return assert.strictEqual(''.match.call(num, re).input, String(num), 'S15.5.4.10_A2_T18 #4');
  };
  test('String#match regression', run);
  test('RegExp#@@match appearance', function(assert){
    var match$$;
    match$$ = /./[Symbol.match];
    assert.isFunction(match$$);
    assert.arity(match$$, 1);
    assert.nonEnumerable(RegExp.prototype, Symbol.match);
  });
  test('RegExp#@@match basic behavior', function(assert){
    var string, matches, i$, len$, i, results$ = [];
    assert.isFunction(/./[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8]);
    assert.arity(/./[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8], 1);
    string = "Boston, MA 02134";
    matches = ['02134', '02134', void 8];
    assert.strictEqual(/([\d]{5})([-\ ]?[\d]{4})?$/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8](string).length, 3);
    assert.strictEqual(/([\d]{5})([-\ ]?[\d]{4})?$/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8](string).index, string.lastIndexOf('0'));
    for (i$ = 0, len$ = matches.length; i$ < len$; ++i$) {
      i = matches[i$];
      results$.push(assert.strictEqual(/([\d]{5})([-\ ]?[\d]{4})?$/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8](string)[i], matches[i]));
    }
    return results$;
  });
  test('String#match delegates to @@match', function(assert){
    'use strict';
    var str, num, O, ref$, re;
    str = STRICT
      ? 'qwe'
      : Object('qwe');
    num = STRICT
      ? 123
      : Object(123);
    O = (ref$ = {}, ref$[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = function(it){
      return {
        value: it
      };
    }, ref$);
    assert.strictEqual(str.match(O).value, str);
    assert.strictEqual(''.match.call(num, O).value, num);
    re = /./;
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = function(it){
      return {
        value: it
      };
    };
    assert.strictEqual(str.match(re).value, str);
    return assert.strictEqual(''.match.call(num, re).value, num);
  });
  test('RegExp#@@match delegates to exec', function(assert){
    var execCalled, exec, re;
    exec = function(){
      execCalled = true;
      return /./.exec.apply(this, arguments);
    };
    execCalled = false;
    re = /[ac]/;
    re.exec = exec;
    assert.deepEqual(re[Symbol.match]('abc'), ['a']);
    assert.ok(execCalled);
    re = /a/;
    re.exec = 3;
    assert.deepEqual(re[Symbol.match]('abc'), ['a']);
    re = /a/;
    re.exec = function(){
      return 3;
    };
    assert.throws(function(){
      return re[Symbol.match]('abc');
    });
  });
  test('RegExp#@@match implementation', patchRegExp$exec(run));
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, run;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  run = function(assert){
    var instance, e;
    assert.isFunction(''.replace);
    assert.arity(''.replace, 2);
    assert.name(''.replace, 'replace');
    assert.looksNative(''.replace);
    assert.nonEnumerable(String.prototype, 'replace');
    instance = Object(true);
    instance.replace = String.prototype.replace;
    assert.strictEqual(instance.replace(true, 1), '1', 'S15.5.4.11_A1_T1');
    instance = Object(false);
    instance.replace = String.prototype.replace;
    assert.strictEqual(instance.replace(false, void 8), 'undefined', 'S15.5.4.11_A1_T2');
    assert.strictEqual('gnulluna'.replace(null, function(a1, a2, a3){
      return a2 + '';
    }), 'g1una', 'S15.5.4.11_A1_T4');
    assert.strictEqual('gnulluna'.replace(null, function(){}), 'gundefineduna', 'S15.5.4.11_A1_T5');
    assert.strictEqual(Object('undefined').replace(void 8, function(){
      return arguments[1] + 42;
    }), '42', 'S15.5.4.11_A1_T6');
    assert.strictEqual('undefined'.replace('e', void 8), 'undundefinedfined', 'S15.5.4.11_A1_T7');
    assert.strictEqual(String({
      toString: function(){}
    }).replace(/e/g, void 8), 'undundefinedfinundefinedd', 'S15.5.4.11_A1_T8');
    assert.strictEqual(new String({
      valueOf: function(){},
      toString: void 8
    }).replace(function(){}(), function(a1, a2, a3){
      return a1 + a2 + a3;
    }), 'undefined0undefined', 'S15.5.4.11_A1_T9');
    assert.strictEqual('ABB\u0041BABAB'.replace({
      toString: function(){
        return '\u0041B';
      }
    }, function(){}), 'undefinedBABABAB', 'S15.5.4.11_A1_T10');
    if (NATIVE) {
      try {
        'ABB\u0041BABAB'.replace({
          toString: function(){
            throw 'insearchValue';
          }
        }, {
          toString: function(){
            throw 'inreplaceValue';
          }
        });
        assert.ok(false, 'S15.5.4.11_A1_T11 #1 lead to throwing exception');
      } catch (e$) {
        e = e$;
        assert.strictEqual(e, 'insearchValue', 'S15.5.4.11_A1_T11 #2');
      }
      try {
        Object('ABB\u0041BABAB').replace({
          toString: function(){
            return {};
          },
          valueOf: function(){
            throw 'insearchValue';
          }
        }, {
          toString: function(){
            throw 'inreplaceValue';
          }
        });
        assert.ok(false, 'S15.5.4.11_A1_T12 #1 lead to throwing exception');
      } catch (e$) {
        e = e$;
        assert.strictEqual(e, 'insearchValue', 'S15.5.4.11_A1_T12 #2');
      }
    }
    try {
      'ABB\u0041BABAB\u0031BBAA'.replace({
        toString: function(){
          return {};
        },
        valueOf: function(){
          throw 'insearchValue';
        }
      }, {
        toString: function(){
          return 1;
        }
      });
      assert.ok(false, 'S15.5.4.11_A1_T13 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.strictEqual(e, 'insearchValue', 'S15.5.4.11_A1_T13 #2');
    }
    assert.strictEqual('ABB\u0041BABAB\u0037\u0037BBAA'.replace(new RegExp('77'), 1), 'ABBABABAB\u0031BBAA', 'S15.5.4.11_A1_T14');
    instance = Object(1100.00777001);
    instance.replace = String.prototype.replace;
    try {
      instance.replace({
        toString: function(){
          return /77/;
        }
      }, 1);
      assert.ok(false, 'S15.5.4.11_A1_T15 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.ok(e instanceof TypeError, 'S15.5.4.11_A1_T15 #2');
    }
    instance = Object(1100.00777001);
    instance.replace = String.prototype.replace;
    try {
      instance.replace(/77/, {
        toString: function(){
          return function(a1, a2, a3){
            return a2 + 'z';
          };
        }
      });
      assert.ok(false, 'S15.5.4.11_A1_T16 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.ok(e instanceof TypeError, 'S15.5.4.11_A1_T16 #2');
    }
    assert.strictEqual('asdf'.replace(RegExp('', 'g'), '1'), '1a1s1d1f1', 'S15.5.4.11_A1_T17');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/g, 'sch'), 'She sells seaschells by the seaschore.', 'S15.5.4.11_A2_T1');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/g, '$$sch'), 'She sells sea$schells by the sea$schore.', 'S15.5.4.11_A2_T2');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/g, '$&sch'), 'She sells seashschells by the seashschore.', 'S15.5.4.11_A2_T3');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/g, '$`sch'), 'She sells seaShe sells seaschells by the seaShe sells seashells by the seaschore.', 'S15.5.4.11_A2_T4');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/g, "$'sch"), 'She sells seaells by the seashore.schells by the seaore.schore.', 'S15.5.4.11_A2_T5');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/, 'sch'), 'She sells seaschells by the seashore.', 'S15.5.4.11_A2_T6');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/, '$$sch'), 'She sells sea$schells by the seashore.', 'S15.5.4.11_A2_T7');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/, '$&sch'), 'She sells seashschells by the seashore.', 'S15.5.4.11_A2_T8');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/, '$`sch'), 'She sells seaShe sells seaschells by the seashore.', 'S15.5.4.11_A2_T9');
    assert.strictEqual('She sells seashells by the seashore.'.replace(/sh/, "$'sch"), 'She sells seaells by the seashore.schells by the seashore.', 'S15.5.4.11_A2_T10');
    assert.strictEqual('uid=31'.replace(/(uid=)(\d+)/, '$1115'), 'uid=115', 'S15.5.4.11_A3_T1');
    assert.strictEqual('uid=31'.replace(/(uid=)(\d+)/, '$11A15'), 'uid=1A15', 'S15.5.4.11_A3_T3');
    assert.strictEqual('abc12 def34'.replace(/([a-z]+)([0-9]+)/, function(){
      return arguments[2] + arguments[1];
    }), '12abc def34', 'S15.5.4.11_A4_T1');
    assert.strictEqual('aaaaaaaaaa,aaaaaaaaaaaaaaa'.replace(/^(a+)\1*,\1+$/, '$1'), 'aaaaa', 'S15.5.4.11_A5_T1');
    assert.strictEqual('{price} Retail'.replace(/{price}/g, '$25.00'), '$25.00 Retail');
    return assert.strictEqual('a'.replace(/(.)/, '$0'), '$0');
  };
  test('String#replace regression', run);
  test('RegExp#@@replace appearance', function(assert){
    var replace;
    replace = /./[Symbol.replace];
    assert.isFunction(replace);
    assert.arity(replace, 2);
    assert.nonEnumerable(RegExp.prototype, Symbol.replace);
  });
  test('RegExp#@@replace basic behavior', function(assert){
    return assert.strictEqual(/([a-z]+)([0-9]+)/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.replace : void 8]('abc12 def34', function(){
      return arguments[2] + arguments[1];
    }), '12abc def34');
  });
  test('String.replace delegates to @@replace', function(assert){
    'use strict';
    var str, num, O, ref$, re;
    str = STRICT
      ? 'qwe'
      : Object('qwe');
    num = STRICT
      ? 123
      : Object(123);
    O = (ref$ = {}, ref$[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.replace : void 8] = function(a, b){
      return {
        a: a,
        b: b
      };
    }, ref$);
    assert.strictEqual(str.replace(O, 42).a, str);
    assert.strictEqual(str.replace(O, 42).b, 42);
    assert.strictEqual(''.replace.call(num, O, 42).a, num);
    assert.strictEqual(''.replace.call(num, O, 42).b, 42);
    re = /./;
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.replace : void 8] = function(a, b){
      return {
        a: a,
        b: b
      };
    };
    assert.strictEqual(str.replace(re, 42).a, str);
    assert.strictEqual(str.replace(re, 42).b, 42);
    assert.strictEqual(''.replace.call(num, re, 42).a, num);
    return assert.strictEqual(''.replace.call(num, re, 42).b, 42);
  });
  test('RegExp#@@replace delegates to exec', function(assert){
    var execCalled, exec, re;
    exec = function(){
      execCalled = true;
      return /./.exec.apply(this, arguments);
    };
    execCalled = false;
    re = /[ac]/;
    re.exec = exec;
    assert.deepEqual(re[Symbol.replace]('abc', 'f'), 'fbc');
    assert.ok(execCalled);
    assert.strictEqual(re.lastIndex, 0);
    execCalled = false;
    re = /[ac]/g;
    re.exec = exec;
    assert.deepEqual(re[Symbol.replace]('abc', 'f'), 'fbf');
    assert.ok(execCalled);
    assert.strictEqual(re.lastIndex, 0);
    re = /a/;
    re.exec = 3;
    assert.deepEqual(re[Symbol.replace]('abc', 'f'), 'fbc');
    re = /a/;
    re.exec = function(){
      return 3;
    };
    assert.throws(function(){
      return re[Symbol.replace]('abc', 'f');
    });
  });
  test('RegExp#@@replace correctly handles substitutions', function(assert){
    var re, args;
    re = /./;
    re.exec = function(){
      var result;
      result = ['23', '7'];
      result.groups = {
        '!!!': '7'
      };
      result.index = 1;
      return result;
    };
    assert.strictEqual('1234'.replace(re, '$1'), '174');
    assert.strictEqual('1234'.replace(re, '$<!!!>'), '174');
    assert.strictEqual('1234'.replace(re, '$`'), '114');
    assert.strictEqual('1234'.replace(re, '$\''), '144');
    assert.strictEqual('1234'.replace(re, '$$'), '1$4');
    assert.strictEqual('1234'.replace(re, '$&'), '1234');
    assert.strictEqual('1234'.replace(re, '$x'), '1$x4');
    assert.strictEqual('1234'.replace(re, function(){
      var _len, _args, _key;
      _len = arguments.length;
      _args = new Array(_len);
      _key = 0;
      while (_key < _len) {
        _args[_key] = arguments[_key];
        _key++;
      }
      args = _args;
      return 'x';
    }), '1x4');
    assert.deepEqual(args, [
      '23', '7', 1, '1234', {
        '!!!': '7'
      }
    ]);
  });
  test('RegExp#@@replace implementation', patchRegExp$exec(run));
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, run;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  run = function(assert){
    var instance, e, aString;
    assert.isFunction(''.search);
    assert.arity(''.search, 1);
    assert.name(''.search, 'search');
    assert.looksNative(''.search);
    assert.nonEnumerable(String.prototype, 'search');
    instance = Object(true);
    instance.search = String.prototype.search;
    assert.strictEqual(instance.search(true), 0, 'S15.5.4.12_A1_T1');
    instance = Object(false);
    instance.search = String.prototype.search;
    assert.strictEqual(instance.search(false), 0, 'S15.5.4.12_A1_T2');
    assert.strictEqual(''.search(), 0, 'S15.5.4.12_A1_T4 #1');
    assert.strictEqual('--undefined--'.search(), 0, 'S15.5.4.12_A1_T4 #2');
    assert.strictEqual('gnulluna'.search(null), 1, 'S15.5.4.12_A1_T5');
    assert.strictEqual(Object('undefined').search(void 8), 0, 'S15.5.4.12_A1_T6');
    assert.strictEqual('undefined'.search(void 8), 0, 'S15.5.4.12_A1_T7');
    assert.strictEqual(String({
      toString: function(){}
    }).search(void 8), 0, 'S15.5.4.12_A1_T8');
    assert.strictEqual('ssABB\u0041BABAB'.search({
      toString: function(){
        return '\u0041B';
      }
    }), 2, 'S15.5.4.12_A1_T10');
    try {
      'ABB\u0041BABAB'.search({
        toString: function(){
          throw 'intostr';
        }
      });
      assert.ok(false, 'S15.5.4.12_A1_T11 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.strictEqual(e, 'intostr', 'S15.5.4.12_A1_T11 #2');
    }
    try {
      Object('ABB\u0041BABAB').search({
        toString: function(){
          return {};
        },
        valueOf: function(){
          throw 'intostr';
        }
      });
      assert.ok(false, 'S15.5.4.12_A1_T12 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.strictEqual(e, 'intostr', 'S15.5.4.12_A1_T12 #2');
    }
    assert.strictEqual('ABB\u0041B\u0031ABAB\u0031BBAA'.search({
      toString: function(){
        return {};
      },
      valueOf: function(){
        return 1;
      }
    }), 5, 'S15.5.4.12_A1_T13');
    assert.strictEqual('ABB\u0041BABAB\u0037\u0037BBAA'.search(RegExp('77')), 9, 'S15.5.4.12_A1_T14');
    assert.strictEqual(Object('test string').search('string'), 5, 'S15.5.4.12_A2_T1');
    assert.strictEqual(Object('test string').search('String'), -1, 'S15.5.4.12_A2_T2');
    assert.strictEqual(Object('test string').search(/String/i), 5, 'S15.5.4.12_A2_T3');
    assert.strictEqual(Object('test string').search(/Four/), -1, 'S15.5.4.12_A2_T4');
    assert.strictEqual(Object('one two three four five').search(/four/), 14, 'S15.5.4.12_A2_T5');
    assert.strictEqual(Object('test string').search('notexist'), -1, 'S15.5.4.12_A2_T6');
    assert.strictEqual(Object('test string probe').search('string pro'), 5, 'S15.5.4.12_A2_T7');
    aString = Object('power of the power of the power of the power of the power of the power of the great sword');
    assert.strictEqual(aString.search(/the/), aString.search(/the/g), 'S15.5.4.12_A3_T1');
    aString = Object('power \u006F\u0066 the power of the power \u006F\u0066 the power of the power \u006F\u0066 the power of the great sword');
    return assert.strictEqual(aString.search(/of/), aString.search(/of/g), 'S15.5.4.12_A3_T2');
  };
  test('String#search regression', run);
  test('RegExp#@@search appearance', function(assert){
    var search;
    search = /./[Symbol.search];
    assert.isFunction(search);
    assert.arity(search, 1);
    assert.nonEnumerable(RegExp.prototype, Symbol.search);
  });
  test('RegExp#@@search basic behavior', function(assert){
    assert.isFunction(/./[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.search : void 8]);
    assert.arity(/./[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.search : void 8], 1);
    assert.strictEqual(/four/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.search : void 8]('one two three four five'), 14);
    return assert.strictEqual(/Four/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.search : void 8]('one two three four five'), -1);
  });
  test('String#search delegates to @@search', function(assert){
    'use strict';
    var str, num, O, ref$, re;
    str = STRICT
      ? 'qwe'
      : Object('qwe');
    num = STRICT
      ? 123
      : Object(123);
    O = (ref$ = {}, ref$[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.search : void 8] = function(it){
      return {
        value: it
      };
    }, ref$);
    assert.strictEqual(str.search(O).value, str);
    assert.strictEqual(''.search.call(num, O).value, num);
    re = /./;
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.search : void 8] = function(it){
      return {
        value: it
      };
    };
    assert.strictEqual(str.search(re).value, str);
    return assert.strictEqual(''.search.call(num, re).value, num);
  });
  test('RegExp#@@search delegates to exec', function(assert){
    var execCalled, re;
    execCalled = false;
    re = /b/;
    re.lastIndex = 7;
    re.exec = function(){
      execCalled = true;
      return /./.exec.apply(this, arguments);
    };
    assert.deepEqual(re[Symbol.search]('abc'), 1);
    assert.ok(execCalled);
    assert.strictEqual(re.lastIndex, 7);
    re = /b/;
    re.exec = 3;
    assert.deepEqual(re[Symbol.search]('abc'), 1);
    re = /b/;
    re.exec = function(){
      return 3;
    };
    assert.throws(function(){
      re[Symbol.search]('abc');
    });
  });
  test('RegExp#@@search implementation', patchRegExp$exec(run));
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, run;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  run = function(assert){
    var instance, split, e, F, string, i$, to$, i, expected, results$ = [];
    assert.isFunction(''.split);
    assert.arity(''.split, 2);
    assert.name(''.split, 'split');
    assert.looksNative(''.split);
    assert.nonEnumerable(String.prototype, 'split');
    assert.arrayEqual('ab'.split(), ['ab'], 'If "separator" is undefined must return Array with one String - "this" string');
    assert.arrayEqual('ab'.split(void 8), ['ab'], 'If "separator" is undefined must return Array with one String - "this" string');
    assert.arrayEqual('ab'.split(void 8, 0), [], 'If "separator" is undefined and "limit" set to 0 must return Array[]');
    assert.arrayEqual(''.split(), [''], "''.split() results in ['']");
    assert.arrayEqual(''.split(/./), [''], "''.split(/./) results in ['']");
    assert.arrayEqual(''.split(/.?/), [], "''.split(/.?/) results in []");
    assert.arrayEqual(''.split(/.??/), [], "''.split(/.??/) results in []");
    assert.arrayEqual('ab'.split(/a*/), ['', 'b'], "'ab'.split(/a*/) results in ['', 'b']");
    assert.arrayEqual('ab'.split(/a*?/), ['a', 'b'], "'ab'.split(/a*?/) results in ['a', 'b']");
    assert.arrayEqual('ab'.split(/(?:ab)/), ['', ''], "'ab'.split(/(?:ab)/) results in ['', '']");
    assert.arrayEqual('ab'.split(/(?:ab)*/), ['', ''], "'ab'.split(/(?:ab)*/) results in ['', '']");
    assert.arrayEqual('ab'.split(/(?:ab)*?/), ['a', 'b'], "'ab'.split(/(?:ab)*?/) results in ['a', 'b']");
    assert.arrayEqual('test'.split(''), ['t', 'e', 's', 't'], "'test'.split('') results in ['t', 'e', 's', 't']");
    assert.arrayEqual('test'.split(), ['test'], "'test'.split() results in ['test']");
    assert.arrayEqual('111'.split(1), ['', '', '', ''], "'111'.split(1) results in ['', '', '', '']");
    assert.arrayEqual('test'.split(/(?:)/, 2), ['t', 'e'], "'test'.split(/(?:)/, 2) results in ['t', 'e']");
    assert.arrayEqual('test'.split(/(?:)/, -1), ['t', 'e', 's', 't'], "'test'.split(/(?:)/, -1) results in ['t', 'e', 's', 't']");
    assert.arrayEqual('test'.split(/(?:)/, void 8), ['t', 'e', 's', 't'], "'test'.split(/(?:)/, undefined) results in ['t', 'e', 's', 't']");
    assert.arrayEqual('test'.split(/(?:)/, null), [], "'test'.split(/(?:)/, null) results in []");
    assert.arrayEqual('test'.split(/(?:)/, NaN), [], "'test'.split(/(?:)/, NaN) results in []");
    assert.arrayEqual('test'.split(/(?:)/, true), ['t'], "'test'.split(/(?:)/, true) results in ['t']");
    assert.arrayEqual('test'.split(/(?:)/, '2'), ['t', 'e'], "'test'.split(/(?:)/, '2') results in ['t', 'e']");
    assert.arrayEqual('test'.split(/(?:)/, 'two'), [], "'test'.split(/(?:)/, 'two') results in []");
    assert.arrayEqual('a'.split(/-/), ['a'], "'a'.split(/-/) results in ['a']");
    assert.arrayEqual('a'.split(/-?/), ['a'], "'a'.split(/-?/) results in ['a']");
    assert.arrayEqual('a'.split(/-??/), ['a'], "'a'.split(/-??/) results in ['a']");
    assert.arrayEqual('a'.split(/a/), ['', ''], "'a'.split(/a/) results in ['', '']");
    assert.arrayEqual('a'.split(/a?/), ['', ''], "'a'.split(/a?/) results in ['', '']");
    assert.arrayEqual('a'.split(/a??/), ['a'], "'a'.split(/a??/) results in ['a']");
    assert.arrayEqual('ab'.split(/-/), ['ab'], "'ab'.split(/-/) results in ['ab']");
    assert.arrayEqual('ab'.split(/-?/), ['a', 'b'], "'ab'.split(/-?/) results in ['a', 'b']");
    assert.arrayEqual('ab'.split(/-??/), ['a', 'b'], "'ab'.split(/-??/) results in ['a', 'b']");
    assert.arrayEqual('a-b'.split(/-/), ['a', 'b'], "'a-b'.split(/-/) results in ['a', 'b']");
    assert.arrayEqual('a-b'.split(/-?/), ['a', 'b'], "'a-b'.split(/-?/) results in ['a', 'b']");
    assert.arrayEqual('a-b'.split(/-??/), ['a', '-', 'b'], "'a-b'.split(/-??/) results in ['a', '-', 'b']");
    assert.arrayEqual('a--b'.split(/-/), ['a', '', 'b'], "'a--b'.split(/-/) results in ['a', '', 'b']");
    assert.arrayEqual('a--b'.split(/-?/), ['a', '', 'b'], "'a--b'.split(/-?/) results in ['a', '', 'b']");
    assert.arrayEqual('a--b'.split(/-??/), ['a', '-', '-', 'b'], "'a--b'.split(/-??/) results in ['a', '-', '-', 'b']");
    assert.arrayEqual(''.split(/()()/), [], "''.split(/()()/) results in []");
    assert.arrayEqual('.'.split(/()()/), ['.'], "'.'.split(/()()/) results in ['.']");
    assert.arrayEqual('.'.split(/(.?)(.?)/), ['', '.', '', ''], "'.'.split(/(.?)(.?)/) results in ['', '.', '', '']");
    assert.arrayEqual('.'.split(/(.??)(.??)/), ['.'], "'.'.split(/(.??)(.??)/) results in ['.']");
    assert.arrayEqual('.'.split(/(.)?(.)?/), ['', '.', void 8, ''], "'.'.split(/(.)?(.)?/) results in ['', '.', undefined, '']");
    assert.arrayEqual('A<B>bold</B>and<CODE>coded</CODE>'.split(/<(\/)?([^<>]+)>/), ['A', void 8, 'B', 'bold', '/', 'B', 'and', void 8, 'CODE', 'coded', '/', 'CODE', ''], "'A<B>bold</B>and<CODE>coded</CODE>'.split(/<(\\/)?([^<>]+)>/) results in ['A', undefined, 'B', 'bold', '/', 'B', 'and', undefined, 'CODE', 'coded', '/', 'CODE', '']");
    assert.arrayEqual('tesst'.split(/(s)*/), ['t', void 8, 'e', 's', 't'], "'tesst'.split(/(s)*/) results in ['t', undefined, 'e', 's', 't']");
    assert.arrayEqual('tesst'.split(/(s)*?/), ['t', void 8, 'e', void 8, 's', void 8, 's', void 8, 't'], "'tesst'.split(/(s)*?/) results in ['t', undefined, 'e', undefined, 's', undefined, 's', undefined, 't']");
    assert.arrayEqual('tesst'.split(/(s*)/), ['t', '', 'e', 'ss', 't'], "'tesst'.split(/(s*)/) results in ['t', '', 'e', 'ss', 't']");
    assert.arrayEqual('tesst'.split(/(s*?)/), ['t', '', 'e', '', 's', '', 's', '', 't'], "'tesst'.split(/(s*?)/) results in ['t', '', 'e', '', 's', '', 's', '', 't']");
    assert.arrayEqual('tesst'.split(/(?:s)*/), ['t', 'e', 't'], "'tesst'.split(/(?:s)*/) results in ['t', 'e', 't']");
    assert.arrayEqual('tesst'.split(/(?=s+)/), ['te', 's', 'st'], "'tesst'.split(/(?=s+)/) results in ['te', 's', 'st']");
    assert.arrayEqual('test'.split('t'), ['', 'es', ''], "'test'.split('t') results in ['', 'es', '']");
    assert.arrayEqual('test'.split('es'), ['t', 't'], "'test'.split('es') results in ['t', 't']");
    assert.arrayEqual('test'.split(/t/), ['', 'es', ''], "'test'.split(/t/) results in ['', 'es', '']");
    assert.arrayEqual('test'.split(/es/), ['t', 't'], "'test'.split(/es/) results in ['t', 't']");
    assert.arrayEqual('test'.split(/(t)/), ['', 't', 'es', 't', ''], "'test'.split(/(t)/) results in ['', 't', 'es', 't', '']");
    assert.arrayEqual('test'.split(/(es)/), ['t', 'es', 't'], "'test'.split(/(es)/) results in ['t', 'es', 't']");
    assert.arrayEqual('test'.split(/(t)(e)(s)(t)/), ['', 't', 'e', 's', 't', ''], "'test'.split(/(t)(e)(s)(t)/) results in ['', 't', 'e', 's', 't', '']");
    assert.arrayEqual('.'.split(/(((.((.??)))))/), ['', '.', '.', '.', '', '', ''], "'.'.split(/(((.((.??)))))/) results in ['', '.', '.', '.', '', '', '']");
    assert.arrayEqual('.'.split(/(((((.??)))))/), ['.'], "'.'.split(/(((((.??)))))/) results in ['.']");
    assert.arrayEqual('a b c d'.split(/ /, -(Math.pow(2, 32) - 1)), ['a'], "'a b c d'.split(/ /, -(Math.pow(2, 32) - 1)) results in ['a']");
    assert.arrayEqual('a b c d'.split(/ /, Math.pow(2, 32) + 1), ['a'], "'a b c d'.split(/ /, Math.pow(2, 32) + 1) results in ['a']");
    assert.arrayEqual('a b c d'.split(/ /, Infinity), [], "'a b c d'.split(/ /, Infinity) results in []");
    instance = Object(true);
    instance.split = String.prototype.split;
    split = instance.split(true, false);
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T1 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T1 #2');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A1_T1 #3');
    instance = Object(false);
    instance.split = String.prototype.split;
    split = instance.split(false, 0, null);
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T2 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T2 #2');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A1_T2 #3');
    split = ''.split();
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T4 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T4 #2');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T4 #3');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A1_T4 #4');
    split = 'gnulluna'.split(null);
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T5 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T5 #2');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A1_T5 #3');
    assert.strictEqual(split[0], 'g', 'S15.5.4.14_A1_T5 #4');
    assert.strictEqual(split[1], 'una', 'S15.5.4.14_A1_T5 #5');
    if (NATIVE) {
      split = Object('1undefined').split(void 8);
      assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T6 #1');
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T6 #2');
      assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T6 #3');
      assert.strictEqual(split[0], '1undefined', 'S15.5.4.14_A1_T6 #4');
      split = 'undefinedd'.split(void 8);
      assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T7 #1');
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T7 #2');
      assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T7 #3');
      assert.strictEqual(split[0], 'undefinedd', 'S15.5.4.14_A1_T7 #4');
      split = String({
        toString: function(){}
      }).split(void 8);
      assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T8 #1');
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T8 #2');
      assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T8 #3');
      assert.strictEqual(split[0], 'undefined', 'S15.5.4.14_A1_T8 #4');
    }
    split = new String({
      valueOf: function(){},
      toString: void 8
    }).split(function(){});
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T9 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T9 #2');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T9 #3');
    assert.strictEqual(split[0], 'undefined', 'S15.5.4.14_A1_T9 #4');
    split = 'ABB\u0041BABAB'.split({
      toString: function(){
        return '\u0042B';
      }
    }, {
      valueOf: function(){
        return true;
      }
    });
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T10 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T10 #2');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T10 #3');
    assert.strictEqual(split[0], 'A', 'S15.5.4.14_A1_T10 #4');
    try {
      'ABB\u0041BABAB'.split({
        toString: function(){
          return '\u0041B';
        }
      }, {
        valueOf: (function(){
          throw 'intointeger';
        }())
      });
      assert.ok(false, 'S15.5.4.14_A1_T11 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.strictEqual(e, 'intointeger', 'S15.5.4.14_A1_T11 #2');
    }
    if (NATIVE) {
      try {
        new String('ABB\u0041BABAB').split({
          toString: function(){
            return '\u0041B';
          }
        }, {
          valueOf: function(){
            return {};
          },
          toString: function(){
            throw 'intointeger';
          }
        });
        assert.ok(false, 'S15.5.4.14_A1_T12 #1 lead to throwing exception');
      } catch (e$) {
        e = e$;
        assert.strictEqual(e, 'intointeger', 'S15.5.4.14_A1_T12 #2');
      }
    }
    split = 'ABB\u0041BABAB\u0042cc^^\u0042Bvv%%B\u0042xxx'.split({
      toString: function(){
        return '\u0042\u0042';
      }
    }, {
      valueOf: function(){
        return {};
      },
      toString: function(){
        return '2';
      }
    });
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T13 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T13 #2');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A1_T13 #3');
    assert.strictEqual(split[0], 'A', 'S15.5.4.14_A1_T13 #4');
    assert.strictEqual(split[1], 'ABABA', 'S15.5.4.14_A1_T13 #5');
    if (NATIVE) {
      try {
        instance = Object(10001.10001);
        instance.split = String.prototype.split;
        instance.split({
          toString: function(){
            throw 'intostr';
          }
        }, {
          valueOf: function(){
            throw 'intoint';
          }
        });
        assert.ok(false, 'S15.5.4.14_A1_T14 #1 lead to throwing exception');
      } catch (e$) {
        e = e$;
        assert.strictEqual(e, 'intoint', 'S15.5.4.14_A1_T14 #2');
      }
      try {
        F = (function(){
          F.displayName = 'F';
          var prototype = F.prototype, constructor = F;
          prototype.costructor = function(value){
            this.value = value;
          };
          prototype.valueOf = function(){
            return '' + this.value;
          };
          prototype.toString = function(){
            return new Number;
          };
          prototype.split = String.prototype.split;
          function F(){}
          return F;
        }());
        new F().split({
          toString: function(){
            return {};
          },
          valueOf: function(){
            throw 'intostr';
          }
        }, {
          valueOf: function(){
            throw 'intoint';
          }
        });
        assert.ok(false, 'S15.5.4.14_A1_T15 #1 lead to throwing exception');
      } catch (e$) {
        e = e$;
        assert.strictEqual(e, 'intoint', 'S15.5.4.14_A1_T15 #2');
      }
    }
    try {
      String.prototype.split.call(6776767677.006771122677555, {
        toString: function(){
          return /\u0037\u0037/g;
        }
      });
      assert.ok(false, 'S15.5.4.14_A1_T16 #1 lead to throwing exception');
    } catch (e$) {
      e = e$;
      assert.ok(e instanceof TypeError, 'S15.5.4.14_A1_T16 #2');
    }
    split = String.prototype.split.call(6776767677.006771122677555, /\u0037\u0037/g);
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T17 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T17 #2');
    assert.strictEqual(split.length, 4, 'S15.5.4.14_A1_T17 #3');
    assert.strictEqual(split[0], '6', 'S15.5.4.14_A1_T17 #4');
    assert.strictEqual(split[1], '67676', 'S15.5.4.14_A1_T17 #5');
    assert.strictEqual(split[2], '.006', 'S15.5.4.14_A1_T17 #6');
    assert.strictEqual(split[3], '1', 'S15.5.4.14_A1_T17 #7');
    split = String.prototype.split.call(6776767677.006771122677555, /00/, 1);
    assert.strictEqual(typeof split, 'object', 'S15.5.4.14_A1_T18 #1');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A1_T18 #2');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A1_T18 #3');
    assert.strictEqual(split[0], '6776767677.', 'S15.5.4.14_A1_T18 #4');
    split = Object('one,two,three,four,five').split(',');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T1 #1');
    assert.strictEqual(split.length, 5, 'S15.5.4.14_A2_T1 #2');
    assert.strictEqual(split[0], 'one', 'S15.5.4.14_A2_T1 #3');
    assert.strictEqual(split[1], 'two', 'S15.5.4.14_A2_T1 #4');
    assert.strictEqual(split[2], 'three', 'S15.5.4.14_A2_T1 #5');
    assert.strictEqual(split[3], 'four', 'S15.5.4.14_A2_T1 #6');
    assert.strictEqual(split[4], 'five', 'S15.5.4.14_A2_T1 #7');
    split = Object('one two three four five').split(' ');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T2 #1');
    assert.strictEqual(split.length, 5, 'S15.5.4.14_A2_T2 #2');
    assert.strictEqual(split[0], 'one', 'S15.5.4.14_A2_T2 #3');
    assert.strictEqual(split[1], 'two', 'S15.5.4.14_A2_T2 #4');
    assert.strictEqual(split[2], 'three', 'S15.5.4.14_A2_T2 #5');
    assert.strictEqual(split[3], 'four', 'S15.5.4.14_A2_T2 #6');
    assert.strictEqual(split[4], 'five', 'S15.5.4.14_A2_T2 #7');
    split = Object('one two three four five').split(RegExp(' '), 2);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T3 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T3 #2');
    assert.strictEqual(split[0], 'one', 'S15.5.4.14_A2_T3 #3');
    assert.strictEqual(split[1], 'two', 'S15.5.4.14_A2_T3 #4');
    split = Object('one two three').split('');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T4 #1');
    assert.strictEqual(split.length, 'one two three'.length, 'S15.5.4.14_A2_T4 #2');
    assert.strictEqual(split[0], 'o', 'S15.5.4.14_A2_T4 #3');
    assert.strictEqual(split[1], 'n', 'S15.5.4.14_A2_T4 #4');
    assert.strictEqual(split[11], 'e', 'S15.5.4.14_A2_T4 #5');
    assert.strictEqual(split[12], 'e', 'S15.5.4.14_A2_T4 #6');
    split = Object('one-1,two-2,four-4').split(/,/);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T5 #1');
    assert.strictEqual(split.length, 3, 'S15.5.4.14_A2_T5 #2');
    assert.strictEqual(split[0], 'one-1', 'S15.5.4.14_A2_T5 #3');
    assert.strictEqual(split[1], 'two-2', 'S15.5.4.14_A2_T5 #4');
    assert.strictEqual(split[2], 'four-4', 'S15.5.4.14_A2_T5 #5');
    string = Object('one-1 two-2 three-3');
    split = string.split('');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T6 #1');
    assert.strictEqual(split.length, string.length, 'S15.5.4.14_A2_T6 #2');
    for (i$ = 0, to$ = split.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(split[i], string.charAt(i), "S15.5.4.14_A2_T6 #" + (i + 3));
    }
    if (NATIVE) {
      string = 'thisundefinedisundefinedaundefinedstringundefinedobject';
      split = string.split(void 8);
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T7 #1');
      assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T7 #2');
      assert.strictEqual(split[0], string, 'S15.5.4.14_A2_T7 #3');
    }
    string = 'thisnullisnullanullstringnullobject';
    expected = ['this', 'is', 'a', 'string', 'object'];
    split = string.split(null);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T8 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T8 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T8 #" + (i + 3));
    }
    string = 'thistrueistrueatruestringtrueobject';
    expected = ['this', 'is', 'a', 'string', 'object'];
    split = string.split(true);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T9 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T9 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T9 #" + (i + 3));
    }
    string = 'this123is123a123string123object';
    expected = ['this', 'is', 'a', 'string', 'object'];
    split = string.split(123);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T10 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T10 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T10 #" + (i + 3));
    }
    split = Object('one-1,two-2,four-4').split(':');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T11 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T11 #2');
    assert.strictEqual(split[0], 'one-1,two-2,four-4', 'S15.5.4.14_A2_T11 #3');
    split = Object('one-1 two-2 four-4').split('r-42');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T12 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T12 #2');
    assert.strictEqual(split[0], 'one-1 two-2 four-4', 'S15.5.4.14_A2_T12 #3');
    split = Object('one-1 two-2 four-4').split('-4');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T13 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T13 #2');
    assert.strictEqual(split[0], 'one-1 two-2 four', 'S15.5.4.14_A2_T13 #3');
    assert.strictEqual(split[1], '', 'S15.5.4.14_A2_T13 #4');
    split = Object('one-1 two-2 four-4').split('on');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T14 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T14 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A2_T14 #3');
    assert.strictEqual(split[1], 'e-1 two-2 four-4', 'S15.5.4.14_A2_T14 #4');
    split = new String().split('');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T15 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A2_T15 #2');
    assert.strictEqual(split[0], void 8, 'S15.5.4.14_A2_T15 #3');
    split = new String().split(' ');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T16 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T16 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A2_T16 #3');
    split = Object(' ').split('');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T18 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T18 #2');
    assert.strictEqual(split[0], ' ', 'S15.5.4.14_A2_T18 #3');
    split = Object(' ').split(' ');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T19 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T19 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A2_T19 #3');
    assert.strictEqual(split[1], '', 'S15.5.4.14_A2_T19 #4');
    split = ''.split('x');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T19 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T19 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A2_T19 #3');
    string = Object('one-1 two-2 three-3');
    split = string.split(new RegExp);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T20 #1');
    assert.strictEqual(split.length, string.length, 'S15.5.4.14_A2_T20 #2');
    for (i$ = 0, to$ = split.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(split[i], string.charAt(i), "S15.5.4.14_A2_T20 #" + (i + 3));
    }
    split = Object('hello').split('ll');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T21 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T21 #2');
    assert.strictEqual(split[0], 'he', 'S15.5.4.14_A2_T21 #3');
    assert.strictEqual(split[1], 'o', 'S15.5.4.14_A2_T21 #4');
    split = Object('hello').split('l');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T22 #1');
    assert.strictEqual(split.length, 3, 'S15.5.4.14_A2_T22 #2');
    assert.strictEqual(split[0], 'he', 'S15.5.4.14_A2_T22 #3');
    assert.strictEqual(split[1], '', 'S15.5.4.14_A2_T22 #4');
    assert.strictEqual(split[2], 'o', 'S15.5.4.14_A2_T22 #5');
    split = Object('hello').split('x');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T23 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T23 #2');
    assert.strictEqual(split[0], 'hello', 'S15.5.4.14_A2_T23 #3');
    split = Object('hello').split('h');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T24 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T24 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A2_T24 #3');
    assert.strictEqual(split[1], 'ello', 'S15.5.4.14_A2_T24 #4');
    split = Object('hello').split('o');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T25 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T25 #2');
    assert.strictEqual(split[0], 'hell', 'S15.5.4.14_A2_T25 #3');
    assert.strictEqual(split[1], '', 'S15.5.4.14_A2_T25 #4');
    split = Object('hello').split('hello');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T26 #1');
    assert.strictEqual(split.length, 2, 'S15.5.4.14_A2_T26 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A2_T26 #3');
    assert.strictEqual(split[1], '', 'S15.5.4.14_A2_T26 #4');
    split = Object('hello').split(void 8);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T27 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T27 #2');
    assert.strictEqual(split[0], 'hello', 'S15.5.4.14_A2_T27 #3');
    split = Object('hello').split('hellothere');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T28 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T28 #2');
    assert.strictEqual(split[0], 'hello', 'S15.5.4.14_A2_T28 #3');
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1);
    expected = ['', '00', '', '', '', '22', '33', '44', '60'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T29 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T29 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T29 #" + (i + 3));
    }
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, 1);
    expected = [''];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T30 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T30 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T30 #" + (i + 3));
    }
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, 2);
    expected = ['', '00'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T31 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T31 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T31 #" + (i + 3));
    }
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, 0);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T32 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A2_T32 #2');
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, 100);
    expected = ['', '00', '', '', '', '22', '33', '44', '60'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T33 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T33 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T33 #" + (i + 3));
    }
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, void 8);
    expected = ['', '00', '', '', '', '22', '33', '44', '60'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T34 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T34 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T34 #" + (i + 3));
    }
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, Math.pow(2, 32) - 1);
    expected = ['', '00', '', '', '', '22', '33', '44', '60'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T35 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T35 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T35 #" + (i + 3));
    }
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, 'boo');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T36 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A2_T36 #2');
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, -Math.pow(2, 32) + 1);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T37 #1');
    assert.arrayEqual(split, [''], 'S15.5.4.14_A2_T37 #2');
    instance = Object(100111122133144155);
    instance.split = String.prototype.split;
    split = instance.split(1, NaN);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T38 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A2_T38 #2');
    instance = Object('hello').split('l', 0);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T39 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A2_T39 #2');
    split = Object('hello').split('l', 1);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T40 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A2_T40 #2');
    assert.strictEqual(split[0], 'he', 'S15.5.4.14_A2_T40 #3');
    split = Object('hello').split('l', 2);
    expected = ['he', ''];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T41 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T41 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T41 #" + (i + 3));
    }
    split = Object('hello').split('l', 3);
    expected = ['he', '', 'o'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T42 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T42 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T42 #" + (i + 3));
    }
    split = Object('hello').split('l', 4);
    expected = ['he', '', 'o'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A2_T43 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A2_T43 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A2_T43 #" + (i + 3));
    }
    split = Object('one,two,three,four,five').split();
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T1 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T1 #2');
    assert.strictEqual(split[0], 'one,two,three,four,five', 'S15.5.4.14_A3_T1 #3');
    split = String.prototype.split.call({});
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T2 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T2 #2');
    assert.strictEqual(split[0], '[object Object]', 'S15.5.4.14_A3_T2 #3');
    split = String.prototype.split.call({
      toString: function(){
        return 'function(){}';
      }
    });
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T3 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T3 #2');
    assert.strictEqual(split[0], 'function(){}', 'S15.5.4.14_A3_T3 #3');
    split = String.prototype.split.call(Object(NaN));
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T4 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T4 #2');
    assert.strictEqual(split[0], 'NaN', 'S15.5.4.14_A3_T4 #3');
    split = String.prototype.split.call(Object(-1234567890));
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T5 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T5 #2');
    assert.strictEqual(split[0], '-1234567890', 'S15.5.4.14_A3_T5 #3');
    instance = Object(-1e21);
    split = String.prototype.split.call(instance);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T6 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T6 #2');
    assert.strictEqual(split[0], instance.toString(), 'S15.5.4.14_A3_T6 #3');
    split = String.prototype.split.call(Math);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T7 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T7 #2');
    assert.strictEqual(split[0], '[object Math]', 'S15.5.4.14_A3_T7 #3');
    split = String.prototype.split.call([1, 2, 3, 4, 5]);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T8 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T8 #2');
    assert.strictEqual(split[0], '1,2,3,4,5', 'S15.5.4.14_A3_T8 #3');
    split = String.prototype.split.call(Object(false));
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T9 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T9 #2');
    assert.strictEqual(split[0], 'false', 'S15.5.4.14_A3_T9 #3');
    split = String.prototype.split.call(new String);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T10 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T10 #2');
    assert.strictEqual(split[0], '', 'S15.5.4.14_A3_T10 #3');
    split = String.prototype.split.call(Object(' '));
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A3_T11 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A3_T11 #2');
    assert.strictEqual(split[0], ' ', 'S15.5.4.14_A3_T11 #3');
    if (NATIVE) {
      split = Object('hello').split(/l/);
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T1 #1');
      assert.strictEqual(split.length, 3, 'S15.5.4.14_A4_T1 #2');
      assert.strictEqual(split[0], 'he', 'S15.5.4.14_A4_T1 #3');
      assert.strictEqual(split[1], '', 'S15.5.4.14_A4_T1 #4');
      assert.strictEqual(split[2], 'o', 'S15.5.4.14_A4_T1 #5');
    }
    split = Object('hello').split(/l/, 0);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T2 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A4_T2 #2');
    split = Object('hello').split(/l/, 1);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T3 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A4_T3 #2');
    assert.strictEqual(split[0], 'he', 'S15.5.4.14_A4_T3 #3');
    if (NATIVE) {
      split = Object('hello').split(/l/, 2);
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T4 #1');
      assert.strictEqual(split.length, 2, 'S15.5.4.14_A4_T4 #2');
      assert.strictEqual(split[0], 'he', 'S15.5.4.14_A4_T4 #3');
      assert.strictEqual(split[1], '', 'S15.5.4.14_A4_T4 #4');
      split = Object('hello').split(/l/, 3);
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T5 #1');
      assert.strictEqual(split.length, 3, 'S15.5.4.14_A4_T5 #2');
      assert.strictEqual(split[0], 'he', 'S15.5.4.14_A4_T5 #3');
      assert.strictEqual(split[1], '', 'S15.5.4.14_A4_T5 #4');
      assert.strictEqual(split[2], 'o', 'S15.5.4.14_A4_T5 #5');
      split = Object('hello').split(/l/, 4);
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T6 #1');
      assert.strictEqual(split.length, 3, 'S15.5.4.14_A4_T6 #2');
      assert.strictEqual(split[0], 'he', 'S15.5.4.14_A4_T6 #3');
      assert.strictEqual(split[1], '', 'S15.5.4.14_A4_T6 #4');
      assert.strictEqual(split[2], 'o', 'S15.5.4.14_A4_T6 #5');
      split = Object('hello').split(/l/, void 8);
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T7 #1');
      assert.strictEqual(split.length, 3, 'S15.5.4.14_A4_T7 #2');
      assert.strictEqual(split[0], 'he', 'S15.5.4.14_A4_T7 #3');
      assert.strictEqual(split[1], '', 'S15.5.4.14_A4_T7 #4');
      assert.strictEqual(split[2], 'o', 'S15.5.4.14_A4_T7 #5');
    }
    split = Object('hello').split(/l/, 'hi');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T8 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A4_T8 #2');
    split = Object('hello').split(new RegExp);
    expected = ['h', 'e', 'l', 'l', 'o'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T10 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T10 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T10 #" + (i + 3));
    }
    split = Object('hello').split(new RegExp(), 0);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T11 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A4_T11 #2');
    split = Object('hello').split(new RegExp(), 1);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T12 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A4_T12 #2');
    assert.strictEqual(split[0], 'h', 'S15.5.4.14_A4_T12 #3');
    split = Object('hello').split(new RegExp(), 2);
    expected = ['h', 'e'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T13 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T13 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T13 #" + (i + 3));
    }
    split = Object('hello').split(new RegExp(), 3);
    expected = ['h', 'e', 'l'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T14 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T14 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T14 #" + (i + 3));
    }
    split = Object('hello').split(new RegExp(), 4);
    expected = ['h', 'e', 'l', 'l'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T15 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T15 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T15 #" + (i + 3));
    }
    split = Object('hello').split(new RegExp(), void 8);
    expected = ['h', 'e', 'l', 'l', 'o'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T16 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T16 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T16 #" + (i + 3));
    }
    split = Object('hello').split(new RegExp(), 'hi');
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T18 #1');
    assert.strictEqual(split.length, 0, 'S15.5.4.14_A4_T18 #2');
    split = Object('a b c de f').split(/\s/);
    expected = ['a', 'b', 'c', 'de', 'f'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T19 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T19 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T19 #" + (i + 3));
    }
    split = Object('a b c de f').split(/\s/, 3);
    expected = ['a', 'b', 'c'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T20 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T20 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T20 #" + (i + 3));
    }
    split = Object('a b c de f').split(/X/);
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T21 #1');
    assert.strictEqual(split.length, 1, 'S15.5.4.14_A4_T21 #2');
    assert.strictEqual(split[0], 'a b c de f', "S15.5.4.14_A4_T21 #3");
    split = Object('dfe23iu 34 =+65--').split(/\d+/);
    expected = ['dfe', 'iu ', ' =+', '--'];
    assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T22 #1');
    assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T22 #2');
    for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
      i = i$;
      assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T22 #" + (i + 3));
    }
    if (NATIVE) {
      split = Object('abc').split(/[a-z]/);
      expected = ['', '', '', ''];
      assert.strictEqual(split.constructor, Array, 'S15.5.4.14_A4_T24 #1');
      assert.strictEqual(split.length, expected.length, 'S15.5.4.14_A4_T24 #2');
      for (i$ = 0, to$ = expected.length; i$ < to$; ++i$) {
        i = i$;
        results$.push(assert.strictEqual(expected[i], split[i], "S15.5.4.14_A4_T24 #" + (i + 3)));
      }
      return results$;
    }
  };
  test('String#split regression', run);
  test('RegExp#@@split appearance', function(assert){
    var split;
    split = /./[Symbol.split];
    assert.isFunction(split);
    assert.arity(split, 2);
    assert.nonEnumerable(RegExp.prototype, Symbol.split);
  });
  test('RegExp#@@split basic behavior', function(assert){
    assert.isFunction(/./[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8]);
    assert.arity(/./[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8], 2);
    assert.strictEqual(/\s/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8]('a b c de f').length, 5);
    assert.strictEqual(/\s/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8]('a b c de f', void 8).length, 5);
    assert.strictEqual(/\s/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8]('a b c de f', 1).length, 1);
    return assert.strictEqual(/\s/[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8]('a b c de f', 10).length, 5);
  });
  test('String#split delegates to @@split', function(assert){
    'use strict';
    var str, num, O, ref$, re;
    str = STRICT
      ? 'qwe'
      : Object('qwe');
    num = STRICT
      ? 123
      : Object(123);
    O = (ref$ = {}, ref$[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8] = function(a, b){
      return {
        a: a,
        b: b
      };
    }, ref$);
    assert.strictEqual(str.split(O, 42).a, str);
    assert.strictEqual(str.split(O, 42).b, 42);
    assert.strictEqual(''.split.call(num, O, 42).a, num);
    assert.strictEqual(''.split.call(num, O, 42).b, 42);
    re = /./;
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.split : void 8] = function(a, b){
      return {
        a: a,
        b: b
      };
    };
    assert.strictEqual(str.split(re, 42).a, str);
    assert.strictEqual(str.split(re, 42).b, 42);
    assert.strictEqual(''.split.call(num, re, 42).a, num);
    return assert.strictEqual(''.split.call(num, re, 42).b, 42);
  });
  test('RegExp#@@split delegates to exec', function(assert){
    var execCalled, speciesCalled, execSpeciesCalled, re, ref$;
    execCalled = false;
    speciesCalled = false;
    execSpeciesCalled = false;
    re = /[24]/;
    re.exec = function(){
      execCalled = true;
      return /./.exec.apply(this, arguments);
    };
    re.constructor = (ref$ = {}, ref$[Symbol.species] = function(source, flags){
      var re2;
      re2 = new RegExp(source, flags);
      speciesCalled = true;
      re2.exec = function(){
        execSpeciesCalled = true;
        return /./.exec.apply(this, arguments);
      };
      return re2;
    }, ref$);
    assert.deepEqual(re[Symbol.split]('123451234'), ['1', '3', '51', '3', '']);
    assert.ok(!execCalled);
    assert.ok(speciesCalled);
    assert.ok(execSpeciesCalled);
    re.constructor = (ref$ = {}, ref$[Symbol.species] = function(source, flags){
      var re2;
      re2 = new RegExp(source, flags);
      re2.exec = 3;
      return re2;
    }, ref$);
    assert.deepEqual(re[Symbol.split]('123451234'), ['1', '3', '51', '3', '']);
    re.constructor = (ref$ = {}, ref$[Symbol.species] = function(source, flags){
      var re2;
      re2 = new RegExp(source, flags);
      re2.exec = function(){
        return 3;
      };
      return re2;
    }, ref$);
    assert.throws(function(){
      re[Symbol.split]('123451234');
    });
  });
  test('RegExp#@@split implementation', patchRegExp$exec(run));
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('RegExp#toString', function(assert){
    var toString;
    toString = /./.toString;
    assert.isFunction(toString);
    assert.arity(toString, 0);
    assert.name(toString, 'toString');
    assert.looksNative(toString);
    assert.nonEnumerable(RegExp.prototype, 'toString');
    assert.same(String(/pattern/), '/pattern/');
    assert.same(String(/pattern/i), '/pattern/i');
    assert.same(String(/pattern/mi), '/pattern/im');
    assert.same(String(/pattern/im), '/pattern/im');
    assert.same(String(/pattern/mgi), '/pattern/gim');
    assert.same(String(new RegExp('pattern')), '/pattern/');
    assert.same(String(new RegExp('pattern', 'i')), '/pattern/i');
    assert.same(String(new RegExp('pattern', 'mi')), '/pattern/im');
    assert.same(String(new RegExp('pattern', 'im')), '/pattern/im');
    assert.same(String(new RegExp('pattern', 'mgi')), '/pattern/gim');
    assert.same(toString.call({
      source: 'foo',
      flags: 'bar'
    }), '/foo/bar');
    assert.same(toString.call({}), '/undefined/undefined');
    if (STRICT) {
      assert.throws(function(){
        toString.call(7);
      });
      assert.throws(function(){
        toString.call('a');
      });
      assert.throws(function(){
        toString.call(false);
      });
      assert.throws(function(){
        toString.call(null);
      });
      assert.throws(function(){
        toString.call(void 8);
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, same, getOwnPropertyDescriptor, freeze;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  same = function(a, b){
    if (a === b) {
      return a !== 0 || 1 / a === 1 / b;
    } else {
      return a != a && b != b;
    }
  };
  getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, freeze = Object.freeze;
  test('Set', function(assert){
    var x$, y$, S, r, z$, z1$, done, iter, _add, a, o, key, C;
    assert.isFunction(Set);
    assert.name(Set, 'Set');
    assert.arity(Set, 0);
    assert.looksNative(Set);
    assert.ok('add' in Set.prototype, 'add in Set.prototype');
    assert.ok('clear' in Set.prototype, 'clear in Set.prototype');
    assert.ok('delete' in Set.prototype, 'delete in Set.prototype');
    assert.ok('has' in Set.prototype, 'has in Set.prototype');
    assert.ok(new Set instanceof Set, 'new Set instanceof Set');
    assert.strictEqual(new Set(createIterable([1, 2, 3])).size, 3, 'Init from iterable');
    assert.strictEqual((x$ = new Set(), x$.add(freeze({})), x$.add(1), x$).size, 2, 'Support frozen objects');
    y$ = S = new Set();
    y$.add(1);
    y$.add(2);
    y$.add(3);
    y$.add(2);
    y$.add(1);
    assert.strictEqual(S.size, 3);
    r = [];
    S.forEach(function(v){
      r.push(v);
    });
    assert.deepEqual(r, [1, 2, 3]);
    assert.strictEqual((z$ = new Set(), z$.add(NaN), z$.add(NaN), z$.add(NaN), z$).size, 1);
    if (Array.from) {
      assert.deepEqual(Array.from((z1$ = new Set([3, 4]), z1$.add(2), z1$.add(1), z1$)), [3, 4, 2, 1]);
    }
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    _add = Set.prototype.add;
    Set.prototype.add = function(){
      throw 42;
    };
    try {
      new Set(iter);
    } catch (e$) {}
    Set.prototype.add = _add;
    assert.ok(done, '.return #throw');
    a = [];
    done = false;
    a[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
      done = true;
      return [][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call(this);
    };
    new Set(a);
    assert.ok(done);
    o = {};
    new Set().add(o);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(Object.keys(o), []);
    }
    assert.arrayEqual(Object.getOwnPropertyNames(o), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(o), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(Set);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof Set, 'correct subclassing with native classes #2');
      assert.ok(new C().add(2).has(2), 'correct subclassing with native classes #3');
    }
  });
  test('Set#add', function(assert){
    var a, x$, S, chain, y$, f;
    assert.isFunction(Set.prototype.add);
    assert.name(Set.prototype.add, 'add');
    assert.arity(Set.prototype.add, 1);
    assert.looksNative(Set.prototype.add);
    assert.nonEnumerable(Set.prototype, 'add');
    a = [];
    x$ = S = new Set();
    x$.add(NaN);
    x$.add(2);
    x$.add(3);
    x$.add(2);
    x$.add(1);
    x$.add(a);
    assert.strictEqual(S.size, 5);
    chain = S.add(NaN);
    assert.strictEqual(chain, S);
    assert.strictEqual(S.size, 5);
    S.add(2);
    assert.strictEqual(S.size, 5);
    S.add(a);
    assert.strictEqual(S.size, 5);
    S.add([]);
    assert.strictEqual(S.size, 6);
    S.add(4);
    assert.strictEqual(S.size, 7);
    y$ = S = new Set();
    y$.add(freeze(f = {}));
    assert.ok(S.has(f));
  });
  test('Set#clear', function(assert){
    var S, x$, y$, f;
    assert.isFunction(Set.prototype.clear);
    assert.name(Set.prototype.clear, 'clear');
    assert.arity(Set.prototype.clear, 0);
    assert.looksNative(Set.prototype.clear);
    assert.nonEnumerable(Set.prototype, 'clear');
    S = new Set;
    S.clear();
    assert.strictEqual(S.size, 0);
    x$ = S = new Set();
    x$.add(1);
    x$.add(2);
    x$.add(3);
    x$.add(2);
    x$.add(1);
    S.clear();
    assert.strictEqual(S.size, 0);
    assert.ok(!S.has(1));
    assert.ok(!S.has(2));
    assert.ok(!S.has(3));
    y$ = S = new Set();
    y$.add(1);
    y$.add(f = freeze({}));
    S.clear();
    assert.strictEqual(S.size, 0, 'Support frozen objects');
    assert.ok(!S.has(1));
    assert.ok(!S.has(f));
  });
  test('Set#delete', function(assert){
    var a, x$, S, f;
    assert.isFunction(Set.prototype['delete']);
    NATIVE && assert.name(Set.prototype['delete'], 'delete');
    assert.arity(Set.prototype['delete'], 1);
    assert.looksNative(Set.prototype['delete']);
    assert.nonEnumerable(Set.prototype, 'delete');
    a = [];
    x$ = S = new Set();
    x$.add(NaN);
    x$.add(2);
    x$.add(3);
    x$.add(2);
    x$.add(1);
    x$.add(a);
    assert.strictEqual(S.size, 5);
    assert.strictEqual(S['delete'](NaN), true);
    assert.strictEqual(S.size, 4);
    assert.strictEqual(S['delete'](4), false);
    assert.strictEqual(S.size, 4);
    S['delete']([]);
    assert.strictEqual(S.size, 4);
    S['delete'](a);
    assert.strictEqual(S.size, 3);
    S.add(freeze(f = {}));
    assert.strictEqual(S.size, 4);
    S['delete'](f);
    assert.strictEqual(S.size, 3);
  });
  test('Set#forEach', function(assert){
    var r, count, x$, S, y$, set, s, z$;
    assert.isFunction(Set.prototype.forEach);
    assert.name(Set.prototype.forEach, 'forEach');
    assert.arity(Set.prototype.forEach, 1);
    assert.looksNative(Set.prototype.forEach);
    assert.nonEnumerable(Set.prototype, 'forEach');
    r = [];
    count = 0;
    x$ = S = new Set();
    x$.add(1);
    x$.add(2);
    x$.add(3);
    x$.add(2);
    x$.add(1);
    S.forEach(function(value){
      count++;
      r.push(value);
    });
    assert.strictEqual(count, 3);
    assert.deepEqual(r, [1, 2, 3]);
    y$ = set = new Set();
    y$.add('0');
    y$.add('1');
    y$.add('2');
    y$.add('3');
    s = "";
    set.forEach(function(it){
      s += it;
      if (it === '2') {
        set['delete']('2');
        set['delete']('3');
        set['delete']('1');
        return set.add('4');
      }
    });
    assert.strictEqual(s, '0124');
    z$ = set = new Set();
    z$.add('0');
    s = "";
    set.forEach(function(it){
      set['delete']('0');
      if (s !== '') {
        throw '!!!';
      }
      return s += it;
    });
    assert.strictEqual(s, '0');
    assert.throws(function(){
      Set.prototype.forEach.call(new Map, function(){});
    }, 'non-generic');
  });
  test('Set#has', function(assert){
    var a, f, x$, S;
    assert.isFunction(Set.prototype.has);
    assert.name(Set.prototype.has, 'has');
    assert.arity(Set.prototype.has, 1);
    assert.looksNative(Set.prototype.has);
    assert.nonEnumerable(Set.prototype, 'has');
    a = [];
    f = freeze({});
    x$ = S = new Set();
    x$.add(NaN);
    x$.add(2);
    x$.add(3);
    x$.add(2);
    x$.add(1);
    x$.add(f);
    x$.add(a);
    assert.ok(S.has(NaN));
    assert.ok(S.has(a));
    assert.ok(S.has(f));
    assert.ok(S.has(2));
    assert.ok(!S.has(4));
    assert.ok(!S.has([]));
  });
  test('Set#size', function(assert){
    var size, x$, sizeDesc;
    assert.nonEnumerable(Set.prototype, 'size');
    size = (x$ = new Set(), x$.add(1), x$).size;
    assert.strictEqual(typeof size, 'number', 'size is number');
    assert.strictEqual(size, 1, 'size is correct');
    if (DESCRIPTORS) {
      sizeDesc = getOwnPropertyDescriptor(Set.prototype, 'size');
      assert.ok(sizeDesc && sizeDesc.get, 'size is getter');
      assert.ok(sizeDesc && !sizeDesc.set, 'size isnt setter');
      assert.throws(function(){
        return Set.prototype.size;
      }, TypeError);
    }
  });
  test('Set & -0', function(assert){
    var set, x$, y$;
    set = new Set;
    set.add(-0);
    assert.strictEqual(set.size, 1);
    assert.ok(set.has(0));
    assert.ok(set.has(-0));
    set.forEach(function(it){
      return assert.ok(!same(it, -0));
    });
    set['delete'](-0);
    assert.strictEqual(set.size, 0);
    x$ = set = new Set();
    x$.add(-0);
    set.forEach(function(key){
      return assert.ok(!same(key, -0));
    });
    y$ = set = new Set();
    y$.add(4);
    y$.add(3);
    y$.add(2);
    y$.add(1);
    y$.add(0);
    assert.ok(set.has(-0));
  });
  test('Set#@@toStringTag', function(assert){
    assert.strictEqual(Set.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Set', 'Set::@@toStringTag is `Set`');
  });
  test('Set Iterator', function(assert){
    var x$, set, keys, iterator;
    x$ = set = new Set();
    x$.add('a');
    x$.add('b');
    x$.add('c');
    x$.add('d');
    keys = [];
    iterator = set.keys();
    keys.push(iterator.next().value);
    assert.ok(set['delete']('a'));
    assert.ok(set['delete']('b'));
    assert.ok(set['delete']('c'));
    set.add('e');
    keys.push(iterator.next().value);
    keys.push(iterator.next().value);
    assert.ok(iterator.next().done);
    set.add('f');
    assert.ok(iterator.next().done);
    assert.deepEqual(keys, ['a', 'd', 'e']);
  });
  test('Set#keys', function(assert){
    var iter, x$;
    assert.ok(typeof Set.prototype.keys === 'function', 'is function');
    assert.name(Set.prototype.keys, 'values');
    assert.arity(Set.prototype.keys, 0);
    assert.looksNative(Set.prototype.keys);
    assert.strictEqual(Set.prototype.keys, Set.prototype.values);
    assert.nonEnumerable(Set.prototype, 'keys');
    iter = (x$ = new Set(), x$.add('q'), x$.add('w'), x$.add('e'), x$).keys();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Set#values', function(assert){
    var iter, x$;
    assert.ok(typeof Set.prototype.values === 'function', 'is function');
    assert.name(Set.prototype.values, 'values');
    assert.arity(Set.prototype.values, 0);
    assert.looksNative(Set.prototype.values);
    assert.nonEnumerable(Set.prototype, 'values');
    iter = (x$ = new Set(), x$.add('q'), x$.add('w'), x$.add('e'), x$).values();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Set#entries', function(assert){
    var iter, x$;
    assert.ok(typeof Set.prototype.entries === 'function', 'is function');
    assert.name(Set.prototype.entries, 'entries');
    assert.arity(Set.prototype.entries, 0);
    assert.looksNative(Set.prototype.entries);
    assert.nonEnumerable(Set.prototype, 'entries');
    iter = (x$ = new Set(), x$.add('q'), x$.add('w'), x$.add('e'), x$).entries();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: ['q', 'q'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['w', 'w'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: ['e', 'e'],
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
  test('Set#@@iterator', function(assert){
    var iter, x$;
    assert.isIterable(Set.prototype);
    assert.name(Set.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], 'values');
    assert.arity(Set.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], 0);
    assert.looksNative(Set.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]);
    assert.strictEqual(Set.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], Set.prototype.values);
    assert.nonEnumerable(Set.prototype, 'values');
    iter = (x$ = new Set(), x$.add('q'), x$.add('w'), x$.add('e'), x$)[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Set Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#anchor', function(assert){
    assert.isFunction(String.prototype.anchor);
    assert.arity(String.prototype.anchor, 1);
    assert.name(String.prototype.anchor, 'anchor');
    assert.looksNative(String.prototype.anchor);
    assert.nonEnumerable(String.prototype, 'anchor');
    assert.same('a'.anchor('b'), '<a name="b">a</a>', 'lower case');
    assert.same('a'.anchor('"'), '<a name="&quot;">a</a>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#big', function(assert){
    assert.isFunction(String.prototype.big);
    assert.arity(String.prototype.big, 0);
    assert.name(String.prototype.big, 'big');
    assert.looksNative(String.prototype.big);
    assert.nonEnumerable(String.prototype, 'big');
    assert.same('a'.big(), '<big>a</big>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#blink', function(assert){
    assert.isFunction(String.prototype.blink);
    assert.arity(String.prototype.blink, 0);
    assert.name(String.prototype.blink, 'blink');
    assert.looksNative(String.prototype.blink);
    assert.nonEnumerable(String.prototype, 'blink');
    assert.same('a'.blink(), '<blink>a</blink>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#bold', function(assert){
    assert.isFunction(String.prototype.bold);
    assert.arity(String.prototype.bold, 0);
    assert.name(String.prototype.bold, 'bold');
    assert.looksNative(String.prototype.bold);
    assert.nonEnumerable(String.prototype, 'bold');
    assert.same('a'.bold(), '<b>a</b>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#codePointAt', function(assert){
    assert.isFunction(String.prototype.codePointAt);
    assert.arity(String.prototype.codePointAt, 1);
    assert.name(String.prototype.codePointAt, 'codePointAt');
    assert.looksNative(String.prototype.codePointAt);
    assert.nonEnumerable(String.prototype, 'codePointAt');
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(''), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt('_'), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(-Infinity), void 8);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(-1), void 8);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(-0), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(0), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(3), 0x1D306);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(4), 0xDF06);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(5), 0x64);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(42), void 8);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(Infinity), void 8);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(Infinity), void 8);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(NaN), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(false), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(null), 0x61);
    assert.strictEqual('abc\uD834\uDF06def'.codePointAt(void 8), 0x61);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(''), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt('1'), 0xDF06);
    assert.strictEqual('\uD834\uDF06def'.codePointAt('_'), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(-1), void 8);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(-0), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(0), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(1), 0xDF06);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(42), void 8);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(false), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(null), 0x1D306);
    assert.strictEqual('\uD834\uDF06def'.codePointAt(void 8), 0x1D306);
    assert.strictEqual('\uD834abc'.codePointAt(''), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt('_'), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(-1), void 8);
    assert.strictEqual('\uD834abc'.codePointAt(-0), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(0), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(false), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(NaN), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(null), 0xD834);
    assert.strictEqual('\uD834abc'.codePointAt(void 8), 0xD834);
    assert.strictEqual('\uDF06abc'.codePointAt(''), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt('_'), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(-1), void 8);
    assert.strictEqual('\uDF06abc'.codePointAt(-0), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(0), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(false), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(NaN), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(null), 0xDF06);
    assert.strictEqual('\uDF06abc'.codePointAt(void 8), 0xDF06);
    if (STRICT) {
      assert.throws(function(){
        String.prototype.codePointAt.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.codePointAt.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#endsWith', function(assert){
    var re, e, O;
    assert.isFunction(String.prototype.endsWith);
    assert.arity(String.prototype.endsWith, 1);
    assert.name(String.prototype.endsWith, 'endsWith');
    assert.looksNative(String.prototype.endsWith);
    assert.nonEnumerable(String.prototype, 'endsWith');
    assert.ok('undefined'.endsWith());
    assert.ok(!'undefined'.endsWith(null));
    assert.ok('abc'.endsWith(''));
    assert.ok('abc'.endsWith('c'));
    assert.ok('abc'.endsWith('bc'));
    assert.ok(!'abc'.endsWith('ab'));
    assert.ok('abc'.endsWith('', NaN));
    assert.ok(!'abc'.endsWith('c', -1));
    assert.ok('abc'.endsWith('a', 1));
    assert.ok('abc'.endsWith('c', Infinity));
    assert.ok('abc'.endsWith('a', true));
    assert.ok(!'abc'.endsWith('c', 'x'));
    assert.ok(!'abc'.endsWith('a', 'x'));
    if (STRICT) {
      assert.throws(function(){
        String.prototype.endsWith.call(null, '.');
      }, TypeError);
      assert.throws(function(){
        String.prototype.endsWith.call(void 8, '.');
      }, TypeError);
    }
    re = /./;
    assert.throws(function(){
      '/./'.endsWith(re);
    }, TypeError);
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = false;
    assert.ok((function(){
      try {
        return '/./'.endsWith(re);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O = {};
    assert.ok((function(){
      try {
        return '[object Object]'.endsWith(O);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = true;
    assert.throws(function(){
      '[object Object]'.endsWith(O);
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#fixed', function(assert){
    assert.isFunction(String.prototype.fixed);
    assert.arity(String.prototype.fixed, 0);
    assert.name(String.prototype.fixed, 'fixed');
    assert.looksNative(String.prototype.fixed);
    assert.nonEnumerable(String.prototype, 'fixed');
    assert.same('a'.fixed(), '<tt>a</tt>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#fontcolor', function(assert){
    assert.isFunction(String.prototype.fontcolor);
    assert.arity(String.prototype.fontcolor, 1);
    assert.name(String.prototype.fontcolor, 'fontcolor');
    assert.looksNative(String.prototype.fontcolor);
    assert.nonEnumerable(String.prototype, 'fontcolor');
    assert.same('a'.fontcolor('b'), '<font color="b">a</font>', 'lower case');
    assert.same('a'.fontcolor('"'), '<font color="&quot;">a</font>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#fontsize', function(assert){
    assert.isFunction(String.prototype.fontsize);
    assert.arity(String.prototype.fontsize, 1);
    assert.name(String.prototype.fontsize, 'fontsize');
    assert.looksNative(String.prototype.fontsize);
    assert.nonEnumerable(String.prototype, 'fontsize');
    assert.same('a'.fontsize('b'), '<font size="b">a</font>', 'lower case');
    assert.same('a'.fontsize('"'), '<font size="&quot;">a</font>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String.fromCodePoint', function(assert){
    var fromCodePoint, tmp, counter, result;
    fromCodePoint = String.fromCodePoint;
    assert.isFunction(fromCodePoint);
    assert.arity(fromCodePoint, 1);
    assert.name(fromCodePoint, 'fromCodePoint');
    assert.looksNative(fromCodePoint);
    assert.nonEnumerable(String, 'fromCodePoint');
    assert.strictEqual(fromCodePoint(''), '\0');
    assert.strictEqual(fromCodePoint(), '');
    assert.strictEqual(fromCodePoint(-0), '\0');
    assert.strictEqual(fromCodePoint(0), '\0');
    assert.strictEqual(fromCodePoint(0x1D306), '\uD834\uDF06');
    assert.strictEqual(fromCodePoint(0x1D306, 0x61, 0x1D307), '\uD834\uDF06a\uD834\uDF07');
    assert.strictEqual(fromCodePoint(0x61, 0x62, 0x1D307), 'ab\uD834\uDF07');
    assert.strictEqual(fromCodePoint(false), '\0');
    assert.strictEqual(fromCodePoint(null), '\0');
    assert.throws(function(){
      fromCodePoint('_');
    }, RangeError);
    assert.throws(function(){
      fromCodePoint('+Infinity');
    }, RangeError);
    assert.throws(function(){
      fromCodePoint('-Infinity');
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(-1);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(0x10FFFF + 1);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(3.14);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(3e-2);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(-Infinity);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(Infinity);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(NaN);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(void 8);
    }, RangeError);
    assert.throws(function(){
      fromCodePoint({});
    }, RangeError);
    assert.throws(function(){
      fromCodePoint(/./);
    }, RangeError);
    tmp = 0x60;
    assert.strictEqual(fromCodePoint({
      valueOf: function(){
        return ++tmp;
      }
    }), 'a');
    assert.strictEqual(tmp, 0x61);
    counter = Math.pow(2, 15) * 3 / 2;
    result = [];
    while (--counter >= 0) {
      result.push(0);
    }
    fromCodePoint.apply(null, result);
    counter = Math.pow(2, 15) * 3 / 2;
    result = [];
    while (--counter >= 0) {
      result.push(0xFFFF + 1);
    }
    fromCodePoint.apply(null, result);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#includes', function(assert){
    var re, e, O;
    assert.isFunction(String.prototype.includes);
    assert.arity(String.prototype.includes, 1);
    assert.name(String.prototype.includes, 'includes');
    assert.looksNative(String.prototype.includes);
    assert.nonEnumerable(String.prototype, 'includes');
    assert.ok(!'abc'.includes());
    assert.ok('aundefinedb'.includes());
    assert.ok('abcd'.includes('b', 1));
    assert.ok(!'abcd'.includes('b', 2));
    if (STRICT) {
      assert.throws(function(){
        String.prototype.includes.call(null, '.');
      }, TypeError);
      assert.throws(function(){
        String.prototype.includes.call(void 8, '.');
      }, TypeError);
    }
    re = /./;
    assert.throws(function(){
      '/./'.includes(re);
    }, TypeError);
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = false;
    assert.ok((function(){
      try {
        return '/./'.includes(re);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O = {};
    assert.ok((function(){
      try {
        return '[object Object]'.includes(O);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = true;
    assert.throws(function(){
      '[object Object]'.includes(O);
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#italics', function(assert){
    assert.isFunction(String.prototype.italics);
    assert.arity(String.prototype.italics, 0);
    assert.name(String.prototype.italics, 'italics');
    assert.looksNative(String.prototype.italics);
    assert.nonEnumerable(String.prototype, 'italics');
    assert.same('a'.italics(), '<i>a</i>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#@@iterator', function(assert){
    var iter;
    assert.isIterable(String.prototype);
    iter = 'qwe'[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'String Iterator');
    assert.deepEqual(iter.next(), {
      value: 'q',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'w',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: 'e',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
    assert.strictEqual(Array.from('𠮷𠮷𠮷').length, 3);
    iter = '𠮷𠮷𠮷'[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
    assert.deepEqual(iter.next(), {
      value: '𠮷',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: '𠮷',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: '𠮷',
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: void 8,
      done: true
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#link', function(assert){
    assert.isFunction(String.prototype.link);
    assert.arity(String.prototype.link, 1);
    assert.name(String.prototype.link, 'link');
    assert.looksNative(String.prototype.link);
    assert.nonEnumerable(String.prototype, 'link');
    assert.same('a'.link('b'), '<a href="b">a</a>', 'lower case');
    assert.same('a'.link('"'), '<a href="&quot;">a</a>', 'escape quotes');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String.raw', function(assert){
    var raw;
    raw = String.raw;
    assert.isFunction(raw);
    assert.arity(raw, 1);
    assert.name(raw, 'raw');
    assert.looksNative(raw);
    assert.nonEnumerable(String, 'raw');
    assert.strictEqual(raw({
      raw: ['Hi\\n', '!']
    }, 'Bob'), 'Hi\\nBob!', 'raw is array');
    assert.strictEqual(raw({
      raw: 'test'
    }, 0, 1, 2), 't0e1s2t', 'raw is string');
    assert.strictEqual(raw({
      raw: 'test'
    }, 0), 't0est', 'lacks substituting');
    assert.throws(function(){
      raw({});
    }, TypeError);
    assert.throws(function(){
      raw({
        raw: null
      });
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#repeat', function(assert){
    assert.isFunction(String.prototype.repeat);
    assert.arity(String.prototype.repeat, 1);
    assert.name(String.prototype.repeat, 'repeat');
    assert.looksNative(String.prototype.repeat);
    assert.nonEnumerable(String.prototype, 'repeat');
    assert.strictEqual('qwe'.repeat(3), 'qweqweqwe');
    assert.strictEqual('qwe'.repeat(2.5), 'qweqwe');
    assert.throws(function(){
      'qwe'.repeat(-1);
    }, RangeError);
    assert.throws(function(){
      'qwe'.repeat(Infinity);
    }, RangeError);
    if (STRICT) {
      assert.throws(function(){
        String.prototype.repeat.call(null, 1);
      }, TypeError);
      assert.throws(function(){
        String.prototype.repeat.call(void 8, 1);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#small', function(assert){
    assert.isFunction(String.prototype.small);
    assert.arity(String.prototype.small, 0);
    assert.name(String.prototype.small, 'small');
    assert.looksNative(String.prototype.small);
    assert.nonEnumerable(String.prototype, 'small');
    assert.same('a'.small(), '<small>a</small>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#startsWith', function(assert){
    var re, e, O;
    assert.isFunction(String.prototype.startsWith);
    assert.arity(String.prototype.startsWith, 1);
    assert.name(String.prototype.startsWith, 'startsWith');
    assert.looksNative(String.prototype.startsWith);
    assert.nonEnumerable(String.prototype, 'startsWith');
    assert.ok('undefined'.startsWith());
    assert.ok(!'undefined'.startsWith(null));
    assert.ok('abc'.startsWith(''));
    assert.ok('abc'.startsWith('a'));
    assert.ok('abc'.startsWith('ab'));
    assert.ok(!'abc'.startsWith('bc'));
    assert.ok('abc'.startsWith('', NaN));
    assert.ok('abc'.startsWith('a', -1));
    assert.ok(!'abc'.startsWith('a', 1));
    assert.ok(!'abc'.startsWith('a', Infinity));
    assert.ok('abc'.startsWith('b', true));
    assert.ok('abc'.startsWith('a', 'x'));
    if (STRICT) {
      assert.throws(function(){
        String.prototype.startsWith.call(null, '.');
      }, TypeError);
      assert.throws(function(){
        String.prototype.startsWith.call(void 8, '.');
      }, TypeError);
    }
    re = /./;
    assert.throws(function(){
      '/./'.startsWith(re);
    }, TypeError);
    re[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = false;
    assert.ok((function(){
      try {
        return '/./'.startsWith(re);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O = {};
    assert.ok((function(){
      try {
        return '[object Object]'.startsWith(O);
      } catch (e$) {
        e = e$;
        return false;
      }
    }()));
    O[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.match : void 8] = true;
    assert.throws(function(){
      '[object Object]'.startsWith(O);
    }, TypeError);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#strike', function(assert){
    assert.isFunction(String.prototype.strike);
    assert.arity(String.prototype.strike, 0);
    assert.name(String.prototype.strike, 'strike');
    assert.looksNative(String.prototype.strike);
    assert.nonEnumerable(String.prototype, 'strike');
    assert.same('a'.strike(), '<strike>a</strike>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#sub', function(assert){
    assert.isFunction(String.prototype.sub);
    assert.arity(String.prototype.sub, 0);
    assert.name(String.prototype.sub, 'sub');
    assert.looksNative(String.prototype.sub);
    assert.nonEnumerable(String.prototype, 'sub');
    assert.same('a'.sub(), '<sub>a</sub>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#sup', function(assert){
    assert.isFunction(String.prototype.sup);
    assert.arity(String.prototype.sup, 0);
    assert.name(String.prototype.sup, 'sup');
    assert.looksNative(String.prototype.sup);
    assert.nonEnumerable(String.prototype, 'sup');
    assert.same('a'.sup(), '<sup>a</sup>', 'lower case');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('String#trim', function(assert){
    assert.isFunction(''.trim);
    assert.arity(String.prototype.trim, 0);
    assert.name(String.prototype.trim, 'trim');
    assert.looksNative(String.prototype.trim);
    assert.nonEnumerable(String.prototype, 'trim');
    assert.strictEqual(' \n  q w e \n  '.trim(), 'q w e', 'removes whitespaces at left & right side of string');
    assert.strictEqual('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'.trim(), '', 'removes all whitespaces');
    assert.strictEqual('\u200b\u0085'.trim(), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        String.prototype.trim.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.trim.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, defineProperty, getOwnPropertyDescriptor, create, i$, ref$, len$, $key;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  defineProperty = Object.defineProperty, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, create = Object.create;
  test('Symbol', function(assert){
    var s1, s2, O, count, i;
    assert.isFunction(Symbol);
    NATIVE && assert.strictEqual(Symbol.length, 0, 'arity is 0');
    assert.name(Symbol, 'Symbol');
    assert.looksNative(Symbol);
    s1 = Symbol('foo');
    s2 = Symbol('foo');
    assert.ok(s1 !== s2, 'Symbol("foo") !== Symbol("foo")');
    O = {};
    O[s1] = 42;
    assert.ok(O[s1] === 42, 'Symbol() work as key');
    assert.ok(O[s2] !== 42, 'Various symbols from one description are various keys');
    if (DESCRIPTORS) {
      count = 0;
      for (i in O) {
        count++;
      }
      assert.ok(count === 0, 'object[Symbol()] is not enumerable');
    }
  });
  test('Well-known Symbols', function(assert){
    var i$, x$, ref$, len$, desc;
    for (i$ = 0, len$ = (ref$ = ['hasInstance', 'isConcatSpreadable', 'iterator', 'match', 'replace', 'search', 'species', 'split', 'toPrimitive', 'toStringTag', 'unscopables']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(x$ in Symbol, "Symbol." + x$ + " available");
      assert.nonEnumerable(Symbol, x$);
      assert.ok(Object(Symbol[x$]) instanceof Symbol, "Symbol." + x$ + " is symbol");
      if (DESCRIPTORS) {
        desc = getOwnPropertyDescriptor(Symbol, x$);
        assert.ok(!desc.enumerble, 'non-enumerable');
        assert.ok(!desc.writable, 'non-writable');
        assert.ok(!desc.configurable, 'non-configurable');
      }
    }
  });
  test('Global symbol registry', function(assert){
    var symbol;
    assert.isFunction(Symbol['for'], 'Symbol.for is function');
    assert.nonEnumerable(Symbol, 'for');
    assert.strictEqual(Symbol['for'].length, 1, 'Symbol.for arity is 1');
    NATIVE && assert.strictEqual(Symbol['for'].name, 'for', 'Symbol.for.name is "for"');
    assert.ok(/native code/.test(Symbol['for']), 'Symbol.for looks like native');
    assert.isFunction(Symbol.keyFor, 'Symbol.keyFor is function');
    assert.nonEnumerable(Symbol, 'keyFor');
    assert.strictEqual(Symbol.keyFor.length, 1, 'Symbol.keyFor arity is 1');
    assert.strictEqual(Symbol.keyFor.name, 'keyFor', 'Symbol.keyFor.name is "keyFor"');
    assert.ok(/native code/.test(Symbol.keyFor), 'Symbol.keyFor looks like native');
    symbol = Symbol['for']('foo');
    assert.strictEqual(Symbol['for']('foo'), symbol);
    assert.strictEqual(Symbol.keyFor(symbol), 'foo');
    assert.throws(function(){
      Symbol.keyFor('foo');
    }, 'throws on non-symbol');
  });
  test('Symbol#@@toPrimitive', function(assert){
    var S;
    assert.isFunction(Symbol.prototype[Symbol.toPrimitive]);
    S = Symbol();
    assert.same(S, S[Symbol.toPrimitive](), 'works');
  });
  test('Symbol#@@toStringTag', function(assert){
    assert.ok(Symbol.prototype[Symbol.toStringTag] === 'Symbol', 'Symbol::@@toStringTag is `Symbol`');
  });
  test('Object.getOwnPropertySymbols', function(assert){
    var getOwnPropertySymbols, getOwnPropertyNames, obj, foo, ref$, i$, x$, len$;
    getOwnPropertySymbols = Object.getOwnPropertySymbols, getOwnPropertyNames = Object.getOwnPropertyNames;
    assert.isFunction(getOwnPropertySymbols);
    assert.nonEnumerable(Object, 'getOwnPropertySymbols');
    assert.strictEqual(getOwnPropertySymbols.length, 1, 'arity is 1');
    assert.name(getOwnPropertySymbols, 'getOwnPropertySymbols');
    assert.looksNative(getOwnPropertySymbols);
    obj = {
      q: 1,
      w: 2,
      e: 3
    };
    obj[Symbol()] = 42;
    obj[Symbol()] = 43;
    assert.deepEqual(getOwnPropertyNames(obj).sort(), ['e', 'q', 'w']);
    assert.strictEqual(getOwnPropertySymbols(obj).length, 2);
    foo = (ref$ = clone$(obj), ref$.a = 1, ref$.s = 2, ref$.d = 3, ref$);
    foo[Symbol()] = 44;
    assert.deepEqual(getOwnPropertyNames(foo).sort(), ['a', 'd', 's']);
    assert.strictEqual(getOwnPropertySymbols(foo).length, 1);
    assert.strictEqual(getOwnPropertySymbols(Object.prototype).length, 0);
    for (i$ = 0, len$ = (ref$ = [42, 'foo', false]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      assert.ok(getOwnPropertySymbols(x$), "accept " + typeof x$);
    }
  });
  if (typeof JSON != 'undefined' && JSON !== null) {
    test('Symbols & JSON.stringify', function(assert){
      var ref$;
      assert.strictEqual(JSON.stringify([1, Symbol('foo'), false, Symbol('bar'), {}]), '[1,null,false,null,{}]', 'array value');
      assert.strictEqual(JSON.stringify({
        foo: Symbol('foo')
      }), '{}', 'object value');
      if (DESCRIPTORS) {
        assert.strictEqual(JSON.stringify((ref$ = {}, ref$[Symbol('foo')] = 1, ref$.bar = 2, ref$)), '{"bar":2}', 'object key');
      }
      assert.strictEqual(JSON.stringify(Symbol('foo')), void 8, 'symbol value');
      if (typeof Symbol() === 'symbol') {
        assert.strictEqual(JSON.stringify(Object(Symbol('foo'))), '{}', 'boxed symbol');
      }
    });
  }
  if (DESCRIPTORS) {
    test('Symbols & descriptors', function(assert){
      var create, defineProperty, getOwnPropertyDescriptor, keys, getOwnPropertyNames, getOwnPropertySymbols, d, e, f, i, j, proto, ref$, O, desc;
      create = Object.create, defineProperty = Object.defineProperty, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, keys = Object.keys, getOwnPropertyNames = Object.getOwnPropertyNames, getOwnPropertySymbols = Object.getOwnPropertySymbols;
      d = Symbol('d');
      e = Symbol('e');
      f = Symbol('f');
      i = Symbol('i');
      j = Symbol('j');
      proto = (ref$ = {
        g: 'g'
      }, ref$[i] = 'i', ref$);
      defineProperty(proto, 'h', {
        value: 'h'
      });
      defineProperty(proto, 'j', {
        value: 'j'
      });
      O = create(proto);
      O.a = 'a';
      O[d] = 'd';
      defineProperty(O, 'b', {
        value: 'b'
      });
      defineProperty(O, 'c', {
        value: 'c',
        enumerable: true
      });
      defineProperty(O, e, {
        configurable: true,
        writable: true,
        value: 'e'
      });
      desc = {
        value: 'f',
        enumerable: true
      };
      defineProperty(O, f, desc);
      assert.strictEqual(desc.enumerable, true, 'defineProperty not changes descriptor object');
      assert.deepEqual(getOwnPropertyDescriptor(O, 'a'), {
        configurable: true,
        writable: true,
        enumerable: true,
        value: 'a'
      }, 'getOwnPropertyDescriptor a');
      assert.deepEqual(getOwnPropertyDescriptor(O, 'b'), {
        configurable: false,
        writable: false,
        enumerable: false,
        value: 'b'
      }, 'getOwnPropertyDescriptor b');
      assert.deepEqual(getOwnPropertyDescriptor(O, 'c'), {
        configurable: false,
        writable: false,
        enumerable: true,
        value: 'c'
      }, 'getOwnPropertyDescriptor c');
      assert.deepEqual(getOwnPropertyDescriptor(O, d), {
        configurable: true,
        writable: true,
        enumerable: true,
        value: 'd'
      }, 'getOwnPropertyDescriptor d');
      assert.deepEqual(getOwnPropertyDescriptor(O, e), {
        configurable: true,
        writable: true,
        enumerable: false,
        value: 'e'
      }, 'getOwnPropertyDescriptor e');
      assert.deepEqual(getOwnPropertyDescriptor(O, f), {
        configurable: false,
        writable: false,
        enumerable: true,
        value: 'f'
      }, 'getOwnPropertyDescriptor f');
      assert.strictEqual(getOwnPropertyDescriptor(O, 'g'), void 8, 'getOwnPropertyDescriptor g');
      assert.strictEqual(getOwnPropertyDescriptor(O, 'h'), void 8, 'getOwnPropertyDescriptor h');
      assert.strictEqual(getOwnPropertyDescriptor(O, i), void 8, 'getOwnPropertyDescriptor i');
      assert.strictEqual(getOwnPropertyDescriptor(O, j), void 8, 'getOwnPropertyDescriptor j');
      assert.strictEqual(getOwnPropertyDescriptor(O, 'k'), void 8, 'getOwnPropertyDescriptor k');
      assert.strictEqual(getOwnPropertyDescriptor(Object.prototype, 'toString').enumerable, false, 'getOwnPropertyDescriptor on Object.prototype');
      assert.strictEqual(getOwnPropertyDescriptor(Object.prototype, d), void 8, 'getOwnPropertyDescriptor on Object.prototype missed symbol');
      assert.strictEqual(O.propertyIsEnumerable('a'), true, 'propertyIsEnumerable a');
      assert.strictEqual(O.propertyIsEnumerable('b'), false, 'propertyIsEnumerable b');
      assert.strictEqual(O.propertyIsEnumerable('c'), true, 'propertyIsEnumerable c');
      assert.strictEqual(O.propertyIsEnumerable(d), true, 'propertyIsEnumerable d');
      assert.strictEqual(O.propertyIsEnumerable(e), false, 'propertyIsEnumerable e');
      assert.strictEqual(O.propertyIsEnumerable(f), true, 'propertyIsEnumerable f');
      assert.strictEqual(O.propertyIsEnumerable('g'), false, 'propertyIsEnumerable g');
      assert.strictEqual(O.propertyIsEnumerable('h'), false, 'propertyIsEnumerable h');
      assert.strictEqual(O.propertyIsEnumerable(i), false, 'propertyIsEnumerable i');
      assert.strictEqual(O.propertyIsEnumerable(j), false, 'propertyIsEnumerable j');
      assert.strictEqual(O.propertyIsEnumerable('k'), false, 'propertyIsEnumerable k');
      assert.strictEqual(Object.prototype.propertyIsEnumerable('toString'), false, 'propertyIsEnumerable on Object.prototype');
      assert.strictEqual(Object.prototype.propertyIsEnumerable(d), false, 'propertyIsEnumerable on Object.prototype missed symbol');
      assert.strictEqual(keys(O).length, 2, 'Object.keys');
      assert.strictEqual(getOwnPropertyNames(O).length, 3, 'Object.getOwnPropertyNames');
      assert.strictEqual(getOwnPropertySymbols(O).length, 3, 'Object.getOwnPropertySymbols');
      ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.strictEqual(Reflect.ownKeys(O).length, 6, 'Reflect.ownKeys');
      delete O[e];
      O[e] = 'e';
      assert.deepEqual(getOwnPropertyDescriptor(O, e), {
        configurable: true,
        writable: true,
        enumerable: true,
        value: 'e'
      }, 'redefined non-enum key');
    });
    test('Symbols & Object.defineProperties', function(assert){
      var defineProperty, defineProperties, c, d, D, ref$, O;
      defineProperty = Object.defineProperty, defineProperties = Object.defineProperties;
      c = Symbol('c');
      d = Symbol('d');
      D = (ref$ = {
        a: {
          value: 'a'
        }
      }, ref$[c] = {
        value: 'c'
      }, ref$);
      defineProperty(D, 'b', {
        value: {
          value: 'b'
        }
      });
      defineProperty(D, d, {
        value: {
          value: 'd'
        }
      });
      O = defineProperties({}, D);
      assert.strictEqual(O.a, 'a', 'a');
      assert.strictEqual(O.b, void 8, 'b');
      assert.strictEqual(O[c], 'c', 'c');
      assert.strictEqual(O[d], void 8, 'd');
    });
    test('Symbols & Object.create', function(assert){
      var defineProperty, create, c, d, D, ref$, O;
      defineProperty = Object.defineProperty, create = Object.create;
      c = Symbol('c');
      d = Symbol('d');
      D = (ref$ = {
        a: {
          value: 'a'
        }
      }, ref$[c] = {
        value: 'c'
      }, ref$);
      defineProperty(D, 'b', {
        value: {
          value: 'b'
        }
      });
      defineProperty(D, d, {
        value: {
          value: 'd'
        }
      });
      O = create(null, D);
      assert.strictEqual(O.a, 'a', 'a');
      assert.strictEqual(O.b, void 8, 'b');
      assert.strictEqual(O[c], 'c', 'c');
      assert.strictEqual(O[d], void 8, 'd');
    });
    for (i$ = 0, len$ = (ref$ = ['Array', 'RegExp', 'Map', 'Set', 'Promise']).length; i$ < len$; ++i$) {
      $key = ref$[i$];
      (fn$.call(this, $key));
    }
  }
  function clone$(it){
    function fun(){} fun.prototype = it;
    return new fun;
  }
  function fn$(key){
    test(key + "@@species", function(assert){
      var C;
      assert.strictEqual(global[key][Symbol.species], global[key], key + "@@species === " + key);
      C = Object.create(global[key]);
      assert.strictEqual(C[Symbol.species], C, key + " sub");
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('ArrayBuffer', function(assert){
    var b, this$ = this;
    assert.same(ArrayBuffer, Object(ArrayBuffer), 'is object');
    assert.arity(ArrayBuffer, 1);
    assert.name(ArrayBuffer, 'ArrayBuffer');
    NATIVE && assert.looksNative(ArrayBuffer);
    b = new ArrayBuffer(123);
    assert.same(b.byteLength, 123, 'length');
    assert.throws(function(){
      new ArrayBuffer(-1);
    }, RangeError, 'negative length');
    assert.ok((function(){
      try {
        return new ArrayBuffer(0.5);
      } catch (e$) {}
    }()), 'fractional length');
    assert.ok((function(){
      try {
        return new ArrayBuffer();
      } catch (e$) {}
    }()), 'missed length');
    DESCRIPTORS && assert.same(ArrayBuffer[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8], ArrayBuffer, '@@species');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('ArrayBuffer.isView', function(assert){
    var isView, i$, x$, ref$, len$, y$;
    isView = ArrayBuffer.isView;
    assert.isFunction(isView);
    assert.arity(isView, 1);
    assert.name(isView, 'isView');
    assert.looksNative(isView);
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      if (global[x$]) {
        assert.same(isView(new global[x$]([1])), true, x$ + " - true");
      }
    }
    assert.same(isView(new DataView(new ArrayBuffer(1))), true, "DataView - true");
    assert.same(isView(new ArrayBuffer(1)), false, "ArrayBuffer - false");
    for (i$ = 0, len$ = (ref$ = [void 8, null, false, true, 0, 1, '', 'qwe', {}, [], fn$]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.same(isView(y$), false, y$ + " - false");
    }
    function fn$(){}
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('ArrayBuffer#slice', function(assert){
    var buffer;
    assert.isFunction(ArrayBuffer.prototype.slice);
    assert.arity(ArrayBuffer.prototype.slice, 2);
    assert.name(ArrayBuffer.prototype.slice, 'slice');
    assert.looksNative(ArrayBuffer.prototype.slice);
    buffer = arrayToBuffer([1, 2, 3, 4, 5]);
    assert.ok(buffer instanceof ArrayBuffer, 'correct buffer');
    assert.ok(buffer.slice() !== buffer, 'returns new buffer');
    assert.ok(buffer.slice() instanceof ArrayBuffer, 'correct instance');
    assert.arrayEqual(bufferToArray(buffer.slice()), [1, 2, 3, 4, 5]);
    assert.arrayEqual(bufferToArray(buffer.slice(1, 3)), [2, 3]);
    assert.arrayEqual(bufferToArray(buffer.slice(1, void 8)), [2, 3, 4, 5]);
    assert.arrayEqual(bufferToArray(buffer.slice(1, -1)), [2, 3, 4]);
    assert.arrayEqual(bufferToArray(buffer.slice(-2, -1)), [4]);
    assert.arrayEqual(bufferToArray(buffer.slice(-2, -3)), []);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, keys, getOwnPropertyDescriptor, defineProperty, $name, ref$, $bytes;
  module = QUnit.module, test = QUnit.test;
  keys = Object.keys, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, defineProperty = Object.defineProperty;
  module('ES6');
  if (DESCRIPTORS) {
    for ($name in ref$ = {
      Float32Array: 4,
      Float64Array: 8,
      Int8Array: 1,
      Int16Array: 2,
      Int32Array: 4,
      Uint8Array: 1,
      Uint16Array: 2,
      Uint32Array: 4,
      Uint8ClampedArray: 1
    }) {
      $bytes = ref$[$name];
      (fn$.call(this, $name, $bytes));
    }
  }
  function import$(obj, src){
    var own = {}.hasOwnProperty;
    for (var key in src) if (own.call(src, key)) obj[key] = src[key];
    return obj;
  }
  function fn$(name, bytes){
    var Typed;
    Typed = global[name];
    test(name + " constructor", function(assert){
      var a, e, b;
      assert.isFunction(Typed);
      assert.arity(Typed, 3);
      assert.name(Typed, name);
      NATIVE && assert.looksNative(Typed);
      assert.same(Typed.BYTES_PER_ELEMENT, bytes, name + ".BYTES_PER_ELEMENT");
      a = new Typed(4);
      assert.same(a.BYTES_PER_ELEMENT, bytes, '#BYTES_PER_ELEMENT');
      assert.same(a.byteOffset, 0, name + '#byteOffset, passed number');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed number');
      assert.arrayEqual(a, [0, 0, 0, 0], 'correct values, passed number');
      try {
        a = new Typed('0x4');
        assert.same(a.byteOffset, 0, '#byteOffset, passed string');
        assert.same(a.byteLength, 4 * bytes, '#byteLength, passed string');
        assert.arrayEqual(a, [0, 0, 0, 0], 'correct values, passed string');
      } catch (e$) {
        e = e$;
        assert.same(e, [0, 0, 0, 0], 'passed string');
      }
      try {
        a = new Typed(true);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 1 * bytes, '#byteLength, passed boolean');
        assert.arrayEqual(a, [0], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [0], 'passed boolean');
      }
      try {
        a = new Typed();
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(void 8);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(-0);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(NaN);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 0, '#byteLength, passed boolean');
        assert.arrayEqual(a, [], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed boolean');
      }
      try {
        a = new Typed(1.5);
        assert.same(a.byteOffset, 0, '#byteOffset, passed boolean');
        assert.same(a.byteLength, 1 * bytes, '#byteLength, passed boolean');
        assert.arrayEqual(a, [0], 'correct values, passed boolean');
      } catch (e$) {
        e = e$;
        assert.same(e, [0], 'passed boolean');
      }
      NATIVE && assert.throws(function(){
        new Typed(-1);
      }, RangeError, 'throws on -1');
      try {
        a = new Typed(null);
        assert.same(a.byteOffset, 0, '#byteOffset, passed null');
        assert.same(a.byteLength, 0, '#byteLength, passed null');
        assert.arrayEqual(a, [], 'correct values, passed null');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed null');
      }
      a = new Typed([1, 2, 3, 4]);
      assert.same(a.byteOffset, 0, '#byteOffset, passed array');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed array');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed array');
      a = new Typed({
        0: 1,
        1: 2,
        2: 3,
        3: 4,
        length: 4
      });
      assert.same(a.byteOffset, 0, '#byteOffset, passed array-like');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed array-like');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed array-like');
      try {
        a = new Typed({});
        assert.same(a.byteOffset, 0, '#byteOffset, passed empty object (also array-like case)');
        assert.same(a.byteLength, 0, '#byteLength, passed empty object (also array-like case)');
        assert.arrayEqual(a, [], 'correct values, passed empty object (also array-like case)');
      } catch (e$) {
        e = e$;
        assert.same(e, [], 'passed empty object (also array-like case)');
      }
      try {
        a = new Typed(createIterable([1, 2, 3, 4]));
        assert.same(a.byteOffset, 0, '#byteOffset, passed iterable');
        assert.same(a.byteLength, 4 * bytes, '#byteLength, passed iterable');
        assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed iterable');
      } catch (e$) {
        e = e$;
        assert.same(e, [1, 2, 3, 4], 'passed iterable');
      }
      a = new Typed(new Typed([1, 2, 3, 4]));
      assert.same(a.byteOffset, 0, '#byteOffset, passed typed array');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed typed array');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed typed array');
      b = new Typed([1, 2, 3, 4]);
      b[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
        return createIterable([4, 3, 2, 1])[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
      };
      a = new Typed(b);
      assert.same(a.byteOffset, 0, '#byteOffset, passed typed array with custom iterator');
      assert.same(a.byteLength, 4 * bytes, '#byteLength, passed typed array with custom iterator');
      assert.arrayEqual(a, [1, 2, 3, 4], 'correct values, passed typed array with custom iterator');
      a = new Typed(new ArrayBuffer(8));
      assert.same(a.byteOffset, 0, '#byteOffset, passed buffer');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer');
      a = new Typed(new ArrayBuffer(16), 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer and byteOffset');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer and byteOffset');
      a = new Typed(new ArrayBuffer(24), 8, 8 / bytes);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and length');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and length');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer, byteOffset and length');
      a = new Typed(new ArrayBuffer(8), void 8);
      assert.same(a.byteOffset, 0, '#byteOffset, passed buffer and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer and undefined');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer and undefined');
      a = new Typed(new ArrayBuffer(16), 8, void 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and undefined');
      assert.same(a.length, 8 / bytes, 'correct length, passed buffer, byteOffset and undefined');
      a = new Typed(new ArrayBuffer(8), 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset with buffer length');
      assert.same(a.byteLength, 0, '#byteLength, passed buffer and byteOffset with buffer length');
      assert.arrayEqual(a, [], 'correct values, passed buffer and byteOffset with buffer length');
      assert.throws(function(){
        new Typed(new ArrayBuffer(8), -1);
      }, RangeError, 'If offset < 0, throw a RangeError exception');
      if (bytes !== 1) {
        assert.throws(function(){
          new Typed(new ArrayBuffer(8), 3);
        }, RangeError, 'If offset modulo elementSize ≠ 0, throw a RangeError exception');
      }
      if (NATIVE) {
        if (bytes !== 1) {
          assert.throws(function(){
            new Typed(new ArrayBuffer(9));
          }, RangeError, 'If bufferByteLength modulo elementSize ≠ 0, throw a RangeError exception');
        }
        assert.throws(function(){
          new Typed(new ArrayBuffer(8), 16);
        }, RangeError, 'If newByteLength < 0, throw a RangeError exception');
        assert.throws(function(){
          new Typed(new ArrayBuffer(24), 8, 24);
        }, RangeError, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
      } else {
        assert.throws(function(){
          new Typed(new ArrayBuffer(8), 16);
        }, 'If newByteLength < 0, throw a RangeError exception');
        assert.throws(function(){
          new Typed(new ArrayBuffer(24), 8, 24);
        }, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
      }
      assert.throws(function(){
        Typed(1);
      }, TypeError, 'throws without `new`');
      assert.same(Typed[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.species : void 8], Typed, '@@species');
      assert.ok((function(){
        try {
          return Typed.toString();
        } catch (e$) {}
      }()));
    });
    test(name + " descriptors", function(assert){
      var typed, desc, base, key, e;
      typed = new Typed(2);
      desc = getOwnPropertyDescriptor(typed, 0);
      base = NATIVE
        ? {
          writable: true,
          enumerable: true,
          configurable: false
        }
        : {
          writable: desc.writable,
          enumerable: true,
          configurable: desc.configurable
        };
      NATIVE && assert.arrayEqual((function(){
        var results$ = [];
        for (key in typed) {
          results$.push(key);
        }
        return results$;
      }()), ['0', '1'], 'for-in');
      NATIVE && assert.arrayEqual(keys(typed), ['0', '1'], 'Object.keys');
      assert.deepEqual(getOwnPropertyDescriptor(typed, 0), import$({
        value: 0
      }, base), 'Object.getOwnPropertyDescriptor');
      if (NATIVE) {
        defineProperty(typed, 0, {
          value: 1,
          writable: true,
          enumerable: true,
          configurable: false
        });
        typed[0] = typed[1] = 2.5;
        assert.deepEqual(getOwnPropertyDescriptor(typed, 0), import$({
          value: typed[1]
        }, base), 'Object.defineProperty, valid descriptor #1');
        defineProperty(typed, 0, {
          value: 1
        });
        typed[0] = typed[1] = 3.5;
        assert.deepEqual(getOwnPropertyDescriptor(typed, 0), import$({
          value: typed[1]
        }, base), 'Object.defineProperty, valid descriptor #2');
      }
      NATIVE && (function(){
        try {
          defineProperty(typed, 0, {
            value: 2,
            writable: false,
            enumerable: true,
            configurable: false
          });
          return assert.ok(false, 'Object.defineProperty, invalid descriptor #1');
        } catch (e$) {
          e = e$;
          return assert.ok(true, 'Object.defineProperty, invalid descriptor #1');
        }
      }());
      NATIVE && (function(){
        try {
          defineProperty(typed, 0, {
            value: 2,
            writable: true,
            enumerable: false,
            configurable: false
          });
          return assert.ok(false, 'Object.defineProperty, invalid descriptor #2');
        } catch (e$) {
          e = e$;
          return assert.ok(true, 'Object.defineProperty, invalid descriptor #2');
        }
      }());
      NATIVE && (function(){
        try {
          defineProperty(typed, 0, {
            get: function(){
              return 2;
            }
          });
          return assert.ok(false, 'Object.defineProperty, invalid descriptor #3');
        } catch (e$) {
          e = e$;
          return assert.ok(true, 'Object.defineProperty, invalid descriptor #3');
        }
      }());
      try {
        defineProperty(typed, 0, {
          value: 2,
          get: function(){
            return 2;
          }
        });
        assert.ok(false, 'Object.defineProperty, invalid descriptor #4');
      } catch (e$) {
        e = e$;
        assert.ok(true, 'Object.defineProperty, invalid descriptor #4');
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Float32 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    NAME = 'Float32';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0]], [-0, -0, [0, 0, 0, 128]], [1, 1, [0, 0, 128, 63]], [-1, -1, [0, 0, 128, 191]], [1.1, 1.100000023841858, [205, 204, 140, 63]], [-1.1, -1.100000023841858, [205, 204, 140, 191]], [1.9, 1.899999976158142, [51, 51, 243, 63]], [-1.9, -1.899999976158142, [51, 51, 243, 191]], [127, 127, [0, 0, 254, 66]], [-127, -127, [0, 0, 254, 194]], [128, 128, [0, 0, 0, 67]], [-128, -128, [0, 0, 0, 195]], [255, 255, [0, 0, 127, 67]], [-255, -255, [0, 0, 127, 195]], [255.1, 255.10000610351562, [154, 25, 127, 67]], [255.9, 255.89999389648438, [102, 230, 127, 67]], [256, 256, [0, 0, 128, 67]], [32767, 32767, [0, 254, 255, 70]], [-32767, -32767, [0, 254, 255, 198]], [32768, 32768, [0, 0, 0, 71]], [-32768, -32768, [0, 0, 0, 199]], [65535, 65535, [0, 255, 127, 71]], [65536, 65536, [0, 0, 128, 71]], [65537, 65537, [128, 0, 128, 71]], [65536.54321, 65536.546875, [70, 0, 128, 71]], [-65536.54321, -65536.546875, [70, 0, 128, 199]], [2147483647, 2147483648, [0, 0, 0, 79]], [-2147483647, -2147483648, [0, 0, 0, 207]], [2147483648, 2147483648, [0, 0, 0, 79]], [-2147483648, -2147483648, [0, 0, 0, 207]], [2147483649, 2147483648, [0, 0, 0, 79]], [-2147483649, -2147483648, [0, 0, 0, 207]], [4294967295, 4294967296, [0, 0, 128, 79]], [4294967296, 4294967296, [0, 0, 128, 79]], [4294967297, 4294967296, [0, 0, 128, 79]], [9007199254740991, 9007199254740992, [0, 0, 0, 90]], [-9007199254740991, -9007199254740992, [0, 0, 0, 218]], [9007199254740992, 9007199254740992, [0, 0, 0, 90]], [-9007199254740992, -9007199254740992, [0, 0, 0, 218]], [9007199254740994, 9007199254740992, [0, 0, 0, 90]], [-9007199254740994, -9007199254740992, [0, 0, 0, 218]], [Infinity, Infinity, [0, 0, 128, 127]], [-Infinity, -Infinity, [0, 0, 128, 255]], [1.7976931348623157e+308, Infinity, [0, 0, 128, 127]], [-1.7976931348623157e+308, -Infinity, [0, 0, 128, 255]], [5e-324, 0, [0, 0, 0, 0]], [-5e-324, -0, [0, 0, 0, 128]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
    typed[0] = NaN;
    assert.same(typed[0], NaN, "NaN -> NaN");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Float64 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    NAME = 'Float64';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0, 0, 0, 0, 0]], [-0, -0, [0, 0, 0, 0, 0, 0, 0, 128]], [1, 1, [0, 0, 0, 0, 0, 0, 240, 63]], [-1, -1, [0, 0, 0, 0, 0, 0, 240, 191]], [1.1, 1.1, [154, 153, 153, 153, 153, 153, 241, 63]], [-1.1, -1.1, [154, 153, 153, 153, 153, 153, 241, 191]], [1.9, 1.9, [102, 102, 102, 102, 102, 102, 254, 63]], [-1.9, -1.9, [102, 102, 102, 102, 102, 102, 254, 191]], [127, 127, [0, 0, 0, 0, 0, 192, 95, 64]], [-127, -127, [0, 0, 0, 0, 0, 192, 95, 192]], [128, 128, [0, 0, 0, 0, 0, 0, 96, 64]], [-128, -128, [0, 0, 0, 0, 0, 0, 96, 192]], [255, 255, [0, 0, 0, 0, 0, 224, 111, 64]], [-255, -255, [0, 0, 0, 0, 0, 224, 111, 192]], [255.1, 255.1, [51, 51, 51, 51, 51, 227, 111, 64]], [255.9, 255.9, [205, 204, 204, 204, 204, 252, 111, 64]], [256, 256, [0, 0, 0, 0, 0, 0, 112, 64]], [32767, 32767, [0, 0, 0, 0, 192, 255, 223, 64]], [-32767, -32767, [0, 0, 0, 0, 192, 255, 223, 192]], [32768, 32768, [0, 0, 0, 0, 0, 0, 224, 64]], [-32768, -32768, [0, 0, 0, 0, 0, 0, 224, 192]], [65535, 65535, [0, 0, 0, 0, 224, 255, 239, 64]], [65536, 65536, [0, 0, 0, 0, 0, 0, 240, 64]], [65537, 65537, [0, 0, 0, 0, 16, 0, 240, 64]], [65536.54321, 65536.54321, [14, 248, 252, 176, 8, 0, 240, 64]], [-65536.54321, -65536.54321, [14, 248, 252, 176, 8, 0, 240, 192]], [2147483647, 2147483647, [0, 0, 192, 255, 255, 255, 223, 65]], [-2147483647, -2147483647, [0, 0, 192, 255, 255, 255, 223, 193]], [2147483648, 2147483648, [0, 0, 0, 0, 0, 0, 224, 65]], [-2147483648, -2147483648, [0, 0, 0, 0, 0, 0, 224, 193]], [2147483649, 2147483649, [0, 0, 32, 0, 0, 0, 224, 65]], [-2147483649, -2147483649, [0, 0, 32, 0, 0, 0, 224, 193]], [4294967295, 4294967295, [0, 0, 224, 255, 255, 255, 239, 65]], [4294967296, 4294967296, [0, 0, 0, 0, 0, 0, 240, 65]], [4294967297, 4294967297, [0, 0, 16, 0, 0, 0, 240, 65]], [9007199254740991, 9007199254740991, [255, 255, 255, 255, 255, 255, 63, 67]], [-9007199254740991, -9007199254740991, [255, 255, 255, 255, 255, 255, 63, 195]], [9007199254740992, 9007199254740992, [0, 0, 0, 0, 0, 0, 64, 67]], [-9007199254740992, -9007199254740992, [0, 0, 0, 0, 0, 0, 64, 195]], [9007199254740994, 9007199254740994, [1, 0, 0, 0, 0, 0, 64, 67]], [-9007199254740994, -9007199254740994, [1, 0, 0, 0, 0, 0, 64, 195]], [Infinity, Infinity, [0, 0, 0, 0, 0, 0, 240, 127]], [-Infinity, -Infinity, [0, 0, 0, 0, 0, 0, 240, 255]], [-1.7976931348623157e+308, -1.7976931348623157e+308, [255, 255, 255, 255, 255, 255, 239, 255]], [1.7976931348623157e+308, 1.7976931348623157e+308, [255, 255, 255, 255, 255, 255, 239, 127]], [5e-324, 5e-324, [1, 0, 0, 0, 0, 0, 0, 0]], [-5e-324, -5e-324, [1, 0, 0, 0, 0, 0, 0, 128]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
    typed[0] = NaN;
    assert.same(typed[0], NaN, "NaN -> NaN");
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Int16 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    NAME = 'Int16';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0]], [-0, 0, [0, 0]], [1, 1, [1, 0]], [-1, -1, [255, 255]], [1.1, 1, [1, 0]], [-1.1, -1, [255, 255]], [1.9, 1, [1, 0]], [-1.9, -1, [255, 255]], [127, 127, [127, 0]], [-127, -127, [129, 255]], [128, 128, [128, 0]], [-128, -128, [128, 255]], [255, 255, [255, 0]], [-255, -255, [1, 255]], [255.1, 255, [255, 0]], [255.9, 255, [255, 0]], [256, 256, [0, 1]], [32767, 32767, [255, 127]], [-32767, -32767, [1, 128]], [32768, -32768, [0, 128]], [-32768, -32768, [0, 128]], [65535, -1, [255, 255]], [65536, 0, [0, 0]], [65537, 1, [1, 0]], [65536.54321, 0, [0, 0]], [-65536.54321, 0, [0, 0]], [2147483647, -1, [255, 255]], [-2147483647, 1, [1, 0]], [2147483648, 0, [0, 0]], [-2147483648, 0, [0, 0]], [4294967296, 0, [0, 0]], [9007199254740992, 0, [0, 0]], [-9007199254740992, 0, [0, 0]], [Infinity, 0, [0, 0]], [-Infinity, 0, [0, 0]], [-1.7976931348623157e+308, 0, [0, 0]], [1.7976931348623157e+308, 0, [0, 0]], [5e-324, 0, [0, 0]], [-5e-324, 0, [0, 0]], [NaN, 0, [0, 0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1, 0]], [-2147483649, -1, [255, 255]], [4294967295, -1, [255, 255]], [4294967297, 1, [1, 0]], [9007199254740991, -1, [255, 255]], [-9007199254740991, 1, [1, 0]], [9007199254740994, 2, [2, 0]], [-9007199254740994, -2, [254, 255]]]);
    }
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Int32 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    NAME = 'Int32';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0]], [-0, 0, [0, 0, 0, 0]], [1, 1, [1, 0, 0, 0]], [-1, -1, [255, 255, 255, 255]], [1.1, 1, [1, 0, 0, 0]], [-1.1, -1, [255, 255, 255, 255]], [1.9, 1, [1, 0, 0, 0]], [-1.9, -1, [255, 255, 255, 255]], [127, 127, [127, 0, 0, 0]], [-127, -127, [129, 255, 255, 255]], [128, 128, [128, 0, 0, 0]], [-128, -128, [128, 255, 255, 255]], [255, 255, [255, 0, 0, 0]], [-255, -255, [1, 255, 255, 255]], [255.1, 255, [255, 0, 0, 0]], [255.9, 255, [255, 0, 0, 0]], [256, 256, [0, 1, 0, 0]], [32767, 32767, [255, 127, 0, 0]], [-32767, -32767, [1, 128, 255, 255]], [32768, 32768, [0, 128, 0, 0]], [-32768, -32768, [0, 128, 255, 255]], [65535, 65535, [255, 255, 0, 0]], [65536, 65536, [0, 0, 1, 0]], [65537, 65537, [1, 0, 1, 0]], [65536.54321, 65536, [0, 0, 1, 0]], [-65536.54321, -65536, [0, 0, 255, 255]], [2147483647, 2147483647, [255, 255, 255, 127]], [-2147483647, -2147483647, [1, 0, 0, 128]], [2147483648, -2147483648, [0, 0, 0, 128]], [-2147483648, -2147483648, [0, 0, 0, 128]], [2147483649, -2147483647, [1, 0, 0, 128]], [-2147483649, 2147483647, [255, 255, 255, 127]], [4294967295, -1, [255, 255, 255, 255]], [4294967296, 0, [0, 0, 0, 0]], [4294967297, 1, [1, 0, 0, 0]], [9007199254740991, -1, [255, 255, 255, 255]], [-9007199254740991, 1, [1, 0, 0, 0]], [9007199254740992, 0, [0, 0, 0, 0]], [-9007199254740992, 0, [0, 0, 0, 0]], [9007199254740994, 2, [2, 0, 0, 0]], [-9007199254740994, -2, [254, 255, 255, 255]], [Infinity, 0, [0, 0, 0, 0]], [-Infinity, 0, [0, 0, 0, 0]], [-1.7976931348623157e+308, 0, [0, 0, 0, 0]], [1.7976931348623157e+308, 0, [0, 0, 0, 0]], [5e-324, 0, [0, 0, 0, 0]], [-5e-324, 0, [0, 0, 0, 0]], [NaN, 0, [0, 0, 0, 0]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Int8 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little;
    NAME = 'Int8';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0]], [-0, 0, [0]], [1, 1, [1]], [-1, -1, [255]], [1.1, 1, [1]], [-1.1, -1, [255]], [1.9, 1, [1]], [-1.9, -1, [255]], [127, 127, [127]], [-127, -127, [129]], [128, -128, [128]], [-128, -128, [128]], [255, -1, [255]], [-255, 1, [1]], [255.1, -1, [255]], [255.9, -1, [255]], [256, 0, [0]], [32767, -1, [255]], [-32767, 1, [1]], [32768, 0, [0]], [-32768, 0, [0]], [65535, -1, [255]], [65536, 0, [0]], [65537, 1, [1]], [65536.54321, 0, [0]], [-65536.54321, 0, [0]], [2147483647, -1, [255]], [-2147483647, 1, [1]], [2147483648, 0, [0]], [-2147483648, 0, [0]], [4294967296, 0, [0]], [9007199254740992, 0, [0]], [-9007199254740992, 0, [0]], [Infinity, 0, [0]], [-Infinity, 0, [0]], [-1.7976931348623157e+308, 0, [0]], [1.7976931348623157e+308, 0, [0]], [5e-324, 0, [0]], [-5e-324, 0, [0]], [NaN, 0, [0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1]], [-2147483649, -1, [255]], [4294967295, -1, [255]], [4294967297, 1, [1]], [9007199254740991, -1, [255]], [-9007199254740991, 1, [1]], [9007199254740994, 2, [2]], [-9007199254740994, -2, [254]]]);
    }
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, little, ARRAY + " " + z(value) + " -> [" + little + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ") -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0), conversion, "view{" + little + "}." + GET + "(0) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint16 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    NAME = 'Uint16';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0]], [-0, 0, [0, 0]], [1, 1, [1, 0]], [-1, 65535, [255, 255]], [1.1, 1, [1, 0]], [-1.1, 65535, [255, 255]], [1.9, 1, [1, 0]], [-1.9, 65535, [255, 255]], [127, 127, [127, 0]], [-127, 65409, [129, 255]], [128, 128, [128, 0]], [-128, 65408, [128, 255]], [255, 255, [255, 0]], [-255, 65281, [1, 255]], [255.1, 255, [255, 0]], [255.9, 255, [255, 0]], [256, 256, [0, 1]], [32767, 32767, [255, 127]], [-32767, 32769, [1, 128]], [32768, 32768, [0, 128]], [-32768, 32768, [0, 128]], [65535, 65535, [255, 255]], [65536, 0, [0, 0]], [65537, 1, [1, 0]], [65536.54321, 0, [0, 0]], [-65536.54321, 0, [0, 0]], [2147483647, 65535, [255, 255]], [-2147483647, 1, [1, 0]], [2147483648, 0, [0, 0]], [-2147483648, 0, [0, 0]], [4294967296, 0, [0, 0]], [9007199254740992, 0, [0, 0]], [-9007199254740992, 0, [0, 0]], [Infinity, 0, [0, 0]], [-Infinity, 0, [0, 0]], [-1.7976931348623157e+308, 0, [0, 0]], [1.7976931348623157e+308, 0, [0, 0]], [5e-324, 0, [0, 0]], [-5e-324, 0, [0, 0]], [NaN, 0, [0, 0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1, 0]], [-2147483649, 65535, [255, 255]], [4294967295, 65535, [255, 255]], [4294967297, 1, [1, 0]], [9007199254740991, 65535, [255, 255]], [-9007199254740991, 1, [1, 0]], [9007199254740994, 2, [2, 0]], [-9007199254740994, 65534, [254, 255]]]);
    }
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint32 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, uint8, view, viewFrom, z, i$, len$, ref$, value, conversion, little, big, rep;
    NAME = 'Uint32';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0, 0, 0, 0]], [-0, 0, [0, 0, 0, 0]], [1, 1, [1, 0, 0, 0]], [-1, 4294967295, [255, 255, 255, 255]], [1.1, 1, [1, 0, 0, 0]], [-1.1, 4294967295, [255, 255, 255, 255]], [1.9, 1, [1, 0, 0, 0]], [-1.9, 4294967295, [255, 255, 255, 255]], [127, 127, [127, 0, 0, 0]], [-127, 4294967169, [129, 255, 255, 255]], [128, 128, [128, 0, 0, 0]], [-128, 4294967168, [128, 255, 255, 255]], [255, 255, [255, 0, 0, 0]], [-255, 4294967041, [1, 255, 255, 255]], [255.1, 255, [255, 0, 0, 0]], [255.9, 255, [255, 0, 0, 0]], [256, 256, [0, 1, 0, 0]], [32767, 32767, [255, 127, 0, 0]], [-32767, 4294934529, [1, 128, 255, 255]], [32768, 32768, [0, 128, 0, 0]], [-32768, 4294934528, [0, 128, 255, 255]], [65535, 65535, [255, 255, 0, 0]], [65536, 65536, [0, 0, 1, 0]], [65537, 65537, [1, 0, 1, 0]], [65536.54321, 65536, [0, 0, 1, 0]], [-65536.54321, 4294901760, [0, 0, 255, 255]], [2147483647, 2147483647, [255, 255, 255, 127]], [-2147483647, 2147483649, [1, 0, 0, 128]], [2147483648, 2147483648, [0, 0, 0, 128]], [-2147483648, 2147483648, [0, 0, 0, 128]], [2147483649, 2147483649, [1, 0, 0, 128]], [-2147483649, 2147483647, [255, 255, 255, 127]], [4294967295, 4294967295, [255, 255, 255, 255]], [4294967296, 0, [0, 0, 0, 0]], [4294967297, 1, [1, 0, 0, 0]], [9007199254740991, 4294967295, [255, 255, 255, 255]], [-9007199254740991, 1, [1, 0, 0, 0]], [9007199254740992, 0, [0, 0, 0, 0]], [-9007199254740992, 0, [0, 0, 0, 0]], [9007199254740994, 2, [2, 0, 0, 0]], [-9007199254740994, 4294967294, [254, 255, 255, 255]], [Infinity, 0, [0, 0, 0, 0]], [-Infinity, 0, [0, 0, 0, 0]], [-1.7976931348623157e+308, 0, [0, 0, 0, 0]], [1.7976931348623157e+308, 0, [0, 0, 0, 0]], [5e-324, 0, [0, 0, 0, 0]], [-5e-324, 0, [0, 0, 0, 0]], [NaN, 0, [0, 0, 0, 0]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      big = little.slice().reverse();
      rep = LITTLE_ENDIAN ? little : big;
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, rep, ARRAY + " " + z(value) + " -> [" + rep + "]");
      view[SET](0, value);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ") -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0), conversion, "view{" + big + "}." + GET + "(0) -> " + z(conversion));
      view[SET](0, value, false);
      assert.arrayEqual(uint8, big, "view." + SET + "(0, " + z(value) + ", false) -> [" + big + "]");
      assert.same(viewFrom(big)[GET](0, false), conversion, "view{" + big + "}." + GET + "(0, false) -> " + z(conversion));
      view[SET](0, value, true);
      assert.arrayEqual(uint8, little, "view." + SET + "(0, " + z(value) + ", true) -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0, true), conversion, "view{" + little + "}." + GET + "(0, true) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint8Clamped conversions', function(assert){
    var NAME, ARRAY, Typed, data, typed, uint8, z, i$, len$, ref$, value, conversion, little;
    NAME = 'Uint8Clamped';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    data = [[0, 0, [0]], [-0, 0, [0]], [1, 1, [1]], [-1, 0, [0]], [1.1, 1, [1]], [-1.1, 0, [0]], [1.9, 2, [2]], [-1.9, 0, [0]], [127, 127, [127]], [-127, 0, [0]], [128, 128, [128]], [-128, 0, [0]], [255, 255, [255]], [-255, 0, [0]], [255.1, 255, [255]], [255.9, 255, [255]], [256, 255, [255]], [32767, 255, [255]], [-32767, 0, [0]], [32768, 255, [255]], [-32768, 0, [0]], [65535, 255, [255]], [65536, 255, [255]], [65537, 255, [255]], [65536.54321, 255, [255]], [-65536.54321, 0, [0]], [2147483647, 255, [255]], [-2147483647, 0, [0]], [2147483648, 255, [255]], [-2147483648, 0, [0]], [2147483649, 255, [255]], [-2147483649, 0, [0]], [4294967295, 255, [255]], [4294967296, 255, [255]], [4294967297, 255, [255]], [9007199254740991, 255, [255]], [-9007199254740991, 0, [0]], [9007199254740992, 255, [255]], [-9007199254740992, 0, [0]], [9007199254740994, 255, [255]], [-9007199254740994, 0, [0]], [Infinity, 255, [255]], [-Infinity, 0, [0]], [-1.7976931348623157e+308, 0, [0]], [1.7976931348623157e+308, 255, [255]], [5e-324, 0, [0]], [-5e-324, 0, [0]], [NaN, 0, [0]]];
    typed = new Typed(1);
    uint8 = new Uint8Array(typed.buffer);
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      typed[0] = value;
      assert.same(typed[0], conversion, z(value) + " -> " + z(conversion));
      assert.arrayEqual(uint8, little, z(value) + " -> [" + little + "]");
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('Uint8 conversions', function(assert){
    var NAME, ARRAY, Typed, SET, GET, data, typed, view, viewFrom, z, i$, len$, ref$, value, conversion, little;
    NAME = 'Uint8';
    ARRAY = NAME + 'Array';
    Typed = global[ARRAY];
    SET = 'set' + NAME;
    GET = 'get' + NAME;
    data = [[0, 0, [0]], [-0, 0, [0]], [1, 1, [1]], [-1, 255, [255]], [1.1, 1, [1]], [-1.1, 255, [255]], [1.9, 1, [1]], [-1.9, 255, [255]], [127, 127, [127]], [-127, 129, [129]], [128, 128, [128]], [-128, 128, [128]], [255, 255, [255]], [-255, 1, [1]], [255.1, 255, [255]], [255.9, 255, [255]], [256, 0, [0]], [32767, 255, [255]], [-32767, 1, [1]], [32768, 0, [0]], [-32768, 0, [0]], [65535, 255, [255]], [65536, 0, [0]], [65537, 1, [1]], [65536.54321, 0, [0]], [-65536.54321, 0, [0]], [2147483647, 255, [255]], [-2147483647, 1, [1]], [2147483648, 0, [0]], [-2147483648, 0, [0]], [4294967296, 0, [0]], [9007199254740992, 0, [0]], [-9007199254740992, 0, [0]], [Infinity, 0, [0]], [-Infinity, 0, [0]], [-1.7976931348623157e+308, 0, [0]], [1.7976931348623157e+308, 0, [0]], [5e-324, 0, [0]], [-5e-324, 0, [0]], [NaN, 0, [0]]];
    if (NATIVE || !/Android [2-4]/.test(typeof navigator != 'undefined' && navigator !== null ? navigator.userAgent : void 8)) {
      data = data.concat([[2147483649, 1, [1]], [-2147483649, 255, [255]], [4294967295, 255, [255]], [4294967297, 1, [1]], [9007199254740991, 255, [255]], [-9007199254740991, 1, [1]], [9007199254740994, 2, [2]], [-9007199254740994, 254, [254]]]);
    }
    typed = new Typed(1);
    view = new DataView(typed.buffer);
    viewFrom = function(it){
      return new DataView(new Uint8Array(it).buffer);
    };
    z = function(it){
      if (it === 0 && 1 / it === -Infinity) {
        return '-0';
      } else {
        return it;
      }
    };
    for (i$ = 0, len$ = data.length; i$ < len$; ++i$) {
      ref$ = data[i$], value = ref$[0], conversion = ref$[1], little = ref$[2];
      typed[0] = value;
      assert.same(typed[0], conversion, ARRAY + " " + z(value) + " -> " + z(conversion));
      assert.arrayEqual(typed, little, ARRAY + " " + z(value) + " -> [" + little + "]");
      view[SET](0, value);
      assert.arrayEqual(typed, little, "view." + SET + "(0, " + z(value) + ") -> [" + little + "]");
      assert.same(viewFrom(little)[GET](0), conversion, "view{" + little + "}." + GET + "(0) -> " + z(conversion));
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, i$, x$, ref$, len$, y$;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('DataView', function(assert){
    var a, d;
    assert.same(DataView, Object(DataView), 'is object');
    NATIVE && assert.arity(DataView, 3);
    NATIVE && assert.name(DataView, 'DataView');
    NATIVE && assert.looksNative(DataView);
    a = new DataView(new ArrayBuffer(8));
    assert.same(a.byteOffset, 0, '#byteOffset, passed buffer');
    assert.same(a.byteLength, 8, '#byteLength, passed buffer');
    a = new DataView(new ArrayBuffer(16), 8);
    assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset');
    assert.same(a.byteLength, 8, '#byteLength, passed buffer and byteOffset');
    a = new DataView(new ArrayBuffer(24), 8, 8);
    assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and length');
    assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and length');
    if (NATIVE) {
      a = new DataView(new ArrayBuffer(8), void 8);
      assert.same(a.byteOffset, 0, '#byteOffset, passed buffer and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer and undefined');
    }
    if (NATIVE) {
      a = new DataView(new ArrayBuffer(16), 8, void 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer, byteOffset and undefined');
      assert.same(a.byteLength, 8, '#byteLength, passed buffer, byteOffset and undefined');
    }
    if (NATIVE) {
      a = new DataView(new ArrayBuffer(8), 8);
      assert.same(a.byteOffset, 8, '#byteOffset, passed buffer and byteOffset with buffer length');
      assert.same(a.byteLength, 0, '#byteLength, passed buffer and byteOffset with buffer length');
    }
    if (NATIVE) {
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), -1);
      }, RangeError, 'If offset < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), 16);
      }, RangeError, 'If newByteLength < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(24), 8, 24);
      }, RangeError, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
    } else {
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), -1);
      }, 'If offset < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(8), 16);
      }, 'If newByteLength < 0, throw a RangeError exception');
      assert.throws(function(){
        new DataView(new ArrayBuffer(24), 8, 24);
      }, 'If offset+newByteLength > bufferByteLength, throw a RangeError exception');
    }
    if (NATIVE) {
      assert.throws(function(){
        DataView(new ArrayBuffer(8));
      }, TypeError, 'throws without `new`');
    } else {
      assert.throws(function(){
        DataView(new ArrayBuffer(8));
      }, 'throws without `new`');
    }
    d = new DataView(new ArrayBuffer(8));
    d.setUint32(0, 0x12345678);
    assert.same(d.getUint32(0), 0x12345678, 'big endian/big endian');
    d.setUint32(0, 0x12345678, true);
    assert.same(d.getUint32(0, true), 0x12345678, 'little endian/little endian');
    d.setUint32(0, 0x12345678, true);
    assert.same(d.getUint32(0), 0x78563412, 'little endian/big endian');
    d.setUint32(0, 0x12345678);
    assert.same(d.getUint32(0, true), 0x78563412, 'big endian/little endian');
    assert.throws(function(){
      return new DataView({});
    }, 'non-ArrayBuffer argument');
    assert.ok(function(){
      var e;
      try {
        new DataView('foo');
      } catch (e$) {
        e = e$;
        return e;
      }
    }, 'non-ArrayBuffer argument');
  });
  DESCRIPTORS && test('DataView accessors', function(assert){
    var u, d, i$, ref$, len$, i, x;
    u = new Uint8Array(8);
    d = new DataView(u.buffer);
    assert.arrayEqual(u, [0, 0, 0, 0, 0, 0, 0, 0]);
    d.setUint8(0, 255);
    assert.arrayEqual(u, [0xff, 0, 0, 0, 0, 0, 0, 0]);
    d.setInt8(1, -1);
    assert.arrayEqual(u, [0xff, 0xff, 0, 0, 0, 0, 0, 0]);
    d.setUint16(2, 0x1234);
    assert.arrayEqual(u, [0xff, 0xff, 0x12, 0x34, 0, 0, 0, 0]);
    d.setInt16(4, -1);
    assert.arrayEqual(u, [0xff, 0xff, 0x12, 0x34, 0xff, 0xff, 0, 0]);
    d.setUint32(1, 0x12345678);
    assert.arrayEqual(u, [0xff, 0x12, 0x34, 0x56, 0x78, 0xff, 0, 0]);
    d.setInt32(4, -2023406815);
    assert.arrayEqual(u, [0xff, 0x12, 0x34, 0x56, 0x87, 0x65, 0x43, 0x21]);
    d.setFloat32(2, 1.2e+38);
    assert.arrayEqual(u, [0xff, 0x12, 0x7e, 0xb4, 0x8e, 0x52, 0x43, 0x21]);
    d.setFloat64(0, -1.2345678e+301);
    assert.arrayEqual(u, [0xfe, 0x72, 0x6f, 0x51, 0x5f, 0x61, 0x77, 0xe5]);
    for (i$ = 0, len$ = (ref$ = [0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87]).length; i$ < len$; ++i$) {
      i = i$;
      x = ref$[i$];
      u[i] = x;
    }
    assert.same(d.getUint8(0), 128);
    assert.same(d.getInt8(1), -127);
    assert.same(d.getUint16(2), 33411);
    assert.same(d.getInt16(3), -31868);
    assert.same(d.getUint32(4), 2223343239);
    assert.same(d.getInt32(2), -2105310075);
    assert.same(d.getFloat32(2), -1.932478247535851e-37);
    assert.same(d.getFloat64(0), -3.116851295377095e-306);
  });
  DESCRIPTORS && test('DataView endian', function(assert){
    var rawbuf, d;
    rawbuf = new Uint8Array([0, 1, 2, 3, 4, 5, 6, 7]).buffer;
    d = new DataView(rawbuf);
    assert.same(d.byteLength, 8, 'buffer');
    assert.same(d.byteOffset, 0, 'buffer');
    assert.throws(function(){
      d.getUint8(-2);
    });
    assert.throws(function(){
      d.getUint8(8);
    }, 'bounds for buffer');
    assert.throws(function(){
      d.setUint8(-2, 0);
    }, 'bounds for buffer');
    assert.throws(function(){
      d.setUint8(8, 0);
    }, 'bounds for buffer');
    d = new DataView(rawbuf, 2);
    assert.same(d.byteLength, 6, 'buffer, byteOffset');
    assert.same(d.byteOffset, 2, 'buffer, byteOffset');
    assert.same(d.getUint8(5), 7, 'buffer, byteOffset');
    assert.throws(function(){
      d.getUint8(-2);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      d.getUint8(6);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      d.setUint8(-2, 0);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      d.setUint8(6, 0);
    }, 'bounds for buffer, byteOffset');
    assert.throws(function(){
      new DataView(rawbuf, -1);
    }, 'invalid byteOffset');
    assert.throws(function(){
      new DataView(rawbuf, 9);
    }, 'invalid byteOffset');
    d = new DataView(rawbuf, 2, 4);
    assert.same(d.byteLength, 4, 'buffer, byteOffset, length');
    assert.same(d.byteOffset, 2, 'buffer, byteOffset, length');
    assert.same(d.getUint8(3), 5, 'buffer, byteOffset, length');
    assert.throws(function(){
      d.getUint8(-2);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      d.getUint8(4);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      d.setUint8(-2, 0);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      d.setUint8(4, 0);
    }, 'bounds for buffer, byteOffset, length');
    assert.throws(function(){
      new DataView(rawbuf, 0, 9);
    }, 'invalid byteOffset+length');
    assert.throws(function(){
      new DataView(rawbuf, 8, 1);
    }, 'invalid byteOffset+length');
    assert.throws(function(){
      new DataView(rawbuf, 9, -1);
    }, 'invalid byteOffset+length');
  });
  for (i$ = 0, len$ = (ref$ = ['getUint8', 'getInt8', 'getUint16', 'getInt16', 'getUint32', 'getInt32', 'getFloat32', 'getFloat64']).length; i$ < len$; ++i$) {
    x$ = ref$[i$];
    (fn$.call(this, x$));
  }
  for (i$ = 0, len$ = (ref$ = ['setUint8', 'setInt8', 'setUint16', 'setInt16', 'setUint32', 'setInt32', 'setFloat32', 'setFloat64']).length; i$ < len$; ++i$) {
    y$ = ref$[i$];
    (fn1$.call(this, y$));
  }
  function fn$(name){
    test('DataView#' + name, function(assert){
      assert.isFunction(DataView.prototype[name]);
      NATIVE && assert.arity(DataView.prototype[name], 1);
      assert.name(DataView.prototype[name], name);
      assert.looksNative(DataView.prototype[name]);
      assert.same(new DataView(new ArrayBuffer(8))[name](0), 0, 'returns element');
    });
  }
  function fn1$(name){
    test('DataView#' + name, function(assert){
      assert.isFunction(DataView.prototype[name]);
      NATIVE && assert.arity(DataView.prototype[name], 2);
      assert.name(DataView.prototype[name], name);
      assert.looksNative(DataView.prototype[name]);
      assert.same(new DataView(new ArrayBuffer(8))[name](0, 0), void 8, 'void');
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.copyWithin', function(assert){
    var global, i$, x$, ref$, len$, Typed, a;
    global = Function('return this')();
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.copyWithin, x$ + "::copyWithin is function");
      assert.arity(Typed.prototype.copyWithin, 2, x$ + "::copyWithin arity is 2");
      assert.name(Typed.prototype.copyWithin, 'copyWithin', x$ + "::copyWithin name is 'copyWithin'");
      assert.looksNative(Typed.prototype.copyWithin, x$ + "::copyWithin looks native");
      assert.strictEqual(a = new Typed(5).copyWithin(0), a, 'return this');
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(0, 3), [4, 5, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(1, 3), [1, 4, 5, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(1, 2), [1, 3, 4, 5, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(2, 2), [1, 2, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(0, 3, 4), [4, 2, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(1, 3, 4), [1, 4, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(1, 2, 4), [1, 3, 4, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(0, -2), [4, 5, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(0, -2, -1), [4, 2, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(-4, -3, -2), [1, 3, 3, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(-4, -3, -1), [1, 3, 4, 4, 5]);
      assert.arrayEqual(new Typed([1, 2, 3, 4, 5]).copyWithin(-4, -3), [1, 3, 4, 5, 5]);
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.fill.call([0], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.every', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, v, k, arr;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.every, x$ + "::every is function");
      assert.arity(Typed.prototype.every, 1, x$ + "::every arity is 1");
      assert.name(Typed.prototype.every, 'every', x$ + "::every name is 'every'");
      assert.looksNative(Typed.prototype.every, x$ + "::every looks native");
      (a = new Typed([1])).every(fn$, ctx = {});
      assert.ok(new Typed([1, 2, 3]).every(fn1$));
      assert.ok(new Typed([1, 2, 3]).every((fn2$)));
      assert.ok(!new Typed([1, 2, 3]).every((fn3$)));
      assert.ok(!new Typed([1, 2, 3]).every(fn4$));
      assert.ok(new Typed([1, 2, 3]).every(fn5$, 1));
      v = '';
      k = '';
      new Typed([1, 2, 3]).every(fn6$);
      assert.same(v, '123');
      assert.same(k, '012');
      assert.ok((arr = new Typed([1, 2, 3])).every(fn7$));
      assert.throws(fn8$, "isn't generic");
    }
    function fn$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }
    function fn1$(it){
      return typeof it === 'number';
    }
    function fn2$(it){
      return it < 4;
    }
    function fn3$(it){
      return it < 3;
    }
    function fn4$(it){
      return typeof it === 'string';
    }
    function fn5$(){
      return +this === 1;
    }
    function fn6$(a, b){
      v += a;
      k += b;
      return true;
    }
    function fn7$(){
      return arguments[2] === arr;
    }
    function fn8$(){
      Typed.prototype.every.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.fill', function(assert){
    var i$, x$, ref$, len$, Typed, a;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.fill, x$ + "::fill is function");
      assert.arity(Typed.prototype.fill, 1, x$ + "::fill arity is 1");
      assert.name(Typed.prototype.fill, 'fill', x$ + "::fill name is 'fill'");
      assert.looksNative(Typed.prototype.fill, x$ + "::fill looks native");
      assert.strictEqual(a = new Typed(5).fill(5), a, 'return this');
      assert.arrayEqual(new Typed(5).fill(5), [5, 5, 5, 5, 5], 'basic');
      assert.arrayEqual(new Typed(5).fill(5, 1), [0, 5, 5, 5, 5], 'start index');
      assert.arrayEqual(new Typed(5).fill(5, 1, 4), [0, 5, 5, 5, 0], 'end index');
      assert.arrayEqual(new Typed(5).fill(5, 6, 1), [0, 0, 0, 0, 0], 'start > end');
      assert.arrayEqual(new Typed(5).fill(5, -3, 4), [0, 0, 5, 5, 0], 'negative start index');
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.fill.call([0], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.filter', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, instance, v, k;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.filter, x$ + "::filter is function");
      assert.arity(Typed.prototype.filter, 1, x$ + "::filter arity is 1");
      assert.name(Typed.prototype.filter, 'filter', x$ + "::filter name is 'filter'");
      assert.looksNative(Typed.prototype.filter, x$ + "::filter looks native");
      (a = new Typed([1])).filter(fn$, ctx = {});
      instance = new Typed([1, 2, 3, 4, 5, 6, 7, 8, 9]).filter((fn1$));
      assert.ok(instance instanceof Typed, 'correct instance');
      assert.arrayEqual(instance, [1, 3, 5, 7, 9], 'works');
      v = '';
      k = '';
      new Typed([1, 2, 3]).filter(fn2$);
      assert.same(v, '123');
      assert.same(k, '012');
      assert.throws(fn3$, "isn't generic");
    }
    function fn$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }
    function fn1$(it){
      return it % 2;
    }
    function fn2$(a, b){
      v += a;
      k += b;
    }
    function fn3$(){
      Typed.prototype.filter.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.findIndex', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, v, k, results$ = [];
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.findIndex, x$ + "::findIndex is function");
      assert.arity(Typed.prototype.findIndex, 1, x$ + "::findIndex arity is 1");
      assert.name(Typed.prototype.findIndex, 'findIndex', x$ + "::findIndex name is 'findIndex'");
      assert.looksNative(Typed.prototype.findIndex, x$ + "::findIndex looks native");
      (a = new Typed([1])).findIndex(fn$, ctx = {});
      assert.same(new Typed([1, 2, 3]).findIndex(fn1$), 1);
      assert.same(new Typed([1, 2, 3]).findIndex((fn2$)), -1);
      v = '';
      k = '';
      new Typed([1, 2, 3]).findIndex(fn3$);
      assert.same(v, '123');
      assert.same(k, '012');
      results$.push(assert.throws(fn4$, "isn't generic"));
    }
    return results$;
    function fn$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }
    function fn1$(it){
      return !(it % 2);
    }
    function fn2$(it){
      return it === 4;
    }
    function fn3$(a, b){
      v += a;
      k += b;
    }
    function fn4$(){
      Typed.prototype.findIndex.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.find', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, v, k;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.find, x$ + "::find is function");
      assert.arity(Typed.prototype.find, 1, x$ + "::find arity is 1");
      assert.name(Typed.prototype.find, 'find', x$ + "::find name is 'find'");
      assert.looksNative(Typed.prototype.find, x$ + "::find looks native");
      (a = new Typed([1])).find(fn$, ctx = {});
      assert.same(new Typed([1, 2, 3]).find(fn1$), 2);
      assert.same(new Typed([1, 2, 3]).find((fn2$)), void 8);
      v = '';
      k = '';
      new Typed([1, 2, 3]).find(fn3$);
      assert.same(v, '123');
      assert.same(k, '012');
      assert.throws(fn4$, "isn't generic");
    }
    function fn$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }
    function fn1$(it){
      return !(it % 2);
    }
    function fn2$(it){
      return it === 4;
    }
    function fn3$(a, b){
      v += a;
      k += b;
    }
    function fn4$(){
      Typed.prototype.find.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.forEach', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, v, k;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.forEach, x$ + "::forEach is function");
      assert.arity(Typed.prototype.forEach, 1, x$ + "::forEach arity is 1");
      assert.name(Typed.prototype.forEach, 'forEach', x$ + "::forEach name is 'forEach'");
      assert.looksNative(Typed.prototype.forEach, x$ + "::forEach looks native");
      assert.same(new Typed([1]).forEach(fn$), void 8, 'void');
      (a = new Typed([1])).forEach(fn1$, ctx = {});
      v = '';
      k = '';
      new Typed([1, 2, 3]).forEach(fn2$);
      assert.same(v, '123');
      assert.same(k, '012');
      assert.throws(fn3$, "isn't generic");
    }
    function fn$(){}
    function fn1$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      assert.same(this, ctx, 'correct callback context');
    }
    function fn2$(a, b){
      v += a;
      k += b;
    }
    function fn3$(){
      Typed.prototype.forEach.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArray%.from', function(assert){
    var i$, x$, ref$, len$, Typed, inst, O;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.from, x$ + ".from is function");
      assert.arity(Typed.from, 1, x$ + ".from arity is 1");
      assert.name(Typed.from, 'from', x$ + ".from name is 'from'");
      assert.looksNative(Typed.from, x$ + ".from looks native");
      inst = Typed.from([1, 2, 3]);
      assert.ok(inst instanceof Typed, 'correct instance with array');
      assert.arrayEqual(inst, [1, 2, 3], 'correct elements with array');
      inst = Typed.from({
        0: 1,
        1: 2,
        2: 3,
        length: 3
      });
      assert.ok(inst instanceof Typed, 'correct instance with array-like');
      assert.arrayEqual(inst, [1, 2, 3], 'correct elements with array-like');
      inst = Typed.from(createIterable([1, 2, 3]));
      assert.ok(inst instanceof Typed, 'correct instance with iterable');
      assert.arrayEqual(inst, [1, 2, 3], 'correct elements with iterable');
      assert.arrayEqual(Typed.from([1, 2, 3], fn$), [1, 4, 9], 'accept callback');
      Typed.from([1], fn1$, O = {});
      assert.throws(fn2$, "isn't generic #1");
      if (NATIVE) {
        assert.throws(fn3$, "isn't generic #2");
        assert.ok((fn4$()), 'uses ToLength');
      }
    }
    function fn$(it){
      return it * it;
    }
    function fn1$(a, b){
      assert.same(arguments.length, 2, 'correct number of callback arguments');
      assert.same(a, 1, 'correct value in callback');
      assert.same(b, 0, 'correct index in callback');
      return assert.same(this, O, 'correct callback context');
    }
    function fn2$(){
      Typed.from.call(void 8, []);
    }
    function fn3$(){
      Typed.from.call(Array, []);
    }
    function fn4$(){
      try {
        return Typed.from({
          length: -1,
          0: 1
        }, function(){
          throw 42;
        });
      } catch (e$) {}
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.indexOf', function(assert){
    var i$, x$, ref$, len$, Typed;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.indexOf, x$ + "::indexOf is function");
      assert.arity(Typed.prototype.indexOf, 1, x$ + "::indexOf arity is 1");
      assert.name(Typed.prototype.indexOf, 'indexOf', x$ + "::indexOf name is 'indexOf'");
      assert.looksNative(Typed.prototype.indexOf, x$ + "::indexOf looks native");
      assert.same(new Typed([1, 1, 1]).indexOf(1), 0);
      assert.same(new Typed([1, 2, 3]).indexOf(1, 1), -1);
      assert.same(new Typed([1, 2, 3]).indexOf(2, 1), 1);
      assert.same(new Typed([1, 2, 3]).indexOf(2, -1), -1);
      assert.same(new Typed([1, 2, 3]).indexOf(2, -2), 1);
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.indexOf.call([1, 2], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, arrays;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  arrays = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray'];
  DESCRIPTORS && test('%TypedArrayPrototype%.keys', function(assert){
    var i$, x$, ref$, len$, Typed, iter;
    for (i$ = 0, len$ = (ref$ = arrays).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.keys, x$ + "::keys is function");
      assert.arity(Typed.prototype.keys, 0, x$ + "::keys arity is 0");
      assert.name(Typed.prototype.keys, 'keys', x$ + "::keys name is 'keys'");
      assert.looksNative(Typed.prototype.keys, x$ + "::keys looks native");
      iter = new Typed([1, 2, 3]).keys();
      assert.isIterator(iter);
      assert.isIterable(iter);
      assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
      assert.deepEqual(iter.next(), {
        value: 0,
        done: false
      }, 'step 1');
      assert.deepEqual(iter.next(), {
        value: 1,
        done: false
      }, 'step 2');
      assert.deepEqual(iter.next(), {
        value: 2,
        done: false
      }, 'step 3');
      assert.deepEqual(iter.next(), {
        value: void 8,
        done: true
      }, 'done');
      NATIVE && assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.keys.call([1, 2]);
    }
  });
  DESCRIPTORS && test('%TypedArrayPrototype%.values', function(assert){
    var i$, x$, ref$, len$, Typed, iter;
    for (i$ = 0, len$ = (ref$ = arrays).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.values, x$ + "::values is function");
      assert.arity(Typed.prototype.values, 0, x$ + "::values arity is 0");
      assert.name(Typed.prototype.values, 'values', x$ + "::values name is 'values'");
      assert.looksNative(Typed.prototype.values, x$ + "::values looks native");
      iter = new Typed([1, 2, 3]).values();
      assert.isIterator(iter);
      assert.isIterable(iter);
      assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
      assert.deepEqual(iter.next(), {
        value: 1,
        done: false
      }, 'step 1');
      assert.deepEqual(iter.next(), {
        value: 2,
        done: false
      }, 'step 2');
      assert.deepEqual(iter.next(), {
        value: 3,
        done: false
      }, 'step 3');
      assert.deepEqual(iter.next(), {
        value: void 8,
        done: true
      }, 'done');
      NATIVE && assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.values.call([1, 2]);
    }
  });
  DESCRIPTORS && test('%TypedArrayPrototype%.entries', function(assert){
    var i$, x$, ref$, len$, Typed, iter;
    for (i$ = 0, len$ = (ref$ = arrays).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.entries, x$ + "::entries is function");
      assert.arity(Typed.prototype.entries, 0, x$ + "::entries arity is 0");
      assert.name(Typed.prototype.entries, 'entries', x$ + "::entries name is 'entries'");
      assert.looksNative(Typed.prototype.entries, x$ + "::entries looks native");
      iter = new Typed([1, 2, 3]).entries();
      assert.isIterator(iter);
      assert.isIterable(iter);
      assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
      assert.deepEqual(iter.next(), {
        value: [0, 1],
        done: false
      }, 'step 1');
      assert.deepEqual(iter.next(), {
        value: [1, 2],
        done: false
      }, 'step 2');
      assert.deepEqual(iter.next(), {
        value: [2, 3],
        done: false
      }, 'step 3');
      assert.deepEqual(iter.next(), {
        value: void 8,
        done: true
      }, 'done');
      NATIVE && assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.entries.call([1, 2]);
    }
  });
  DESCRIPTORS && test('%TypedArrayPrototype%.@@iterator', function(assert){
    var i$, x$, ref$, len$, Typed, iter;
    for (i$ = 0, len$ = (ref$ = arrays).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isIterable(Typed.prototype, x$ + " is itrable");
      assert.arity(Typed.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], 0, x$ + "::@@iterator arity is 0");
      assert.name(Typed.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], 'values', x$ + "::@@iterator name is 'values'");
      assert.looksNative(Typed.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], x$ + "::@@iterator looks native");
      assert.strictEqual(Typed.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], Typed.prototype.values);
      iter = new Typed([1, 2, 3])[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8]();
      assert.isIterator(iter);
      assert.isIterable(iter);
      assert.strictEqual(iter[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'Array Iterator');
      assert.deepEqual(iter.next(), {
        value: 1,
        done: false
      }, 'step 1');
      assert.deepEqual(iter.next(), {
        value: 2,
        done: false
      }, 'step 2');
      assert.deepEqual(iter.next(), {
        value: 3,
        done: false
      }, 'step 3');
      assert.deepEqual(iter.next(), {
        value: void 8,
        done: true
      }, 'done');
      NATIVE && assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call([1, 2]);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.join', function(assert){
    var i$, x$, ref$, len$, Typed;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.join, x$ + "::join is function");
      assert.arity(Typed.prototype.join, 1, x$ + "::join arity is 1");
      assert.name(Typed.prototype.join, 'join', x$ + "::join name is 'join'");
      assert.looksNative(Typed.prototype.join, x$ + "::join looks native");
      assert.same(new Typed([1, 2, 3]).join('|'), '1|2|3', 'works #1');
      assert.same(new Typed([1, 2, 3]).join(), '1,2,3', 'works #2');
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.join.call([1, 2, 3]);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.lastIndexOf', function(assert){
    var i$, x$, ref$, len$, Typed;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.lastIndexOf, x$ + "::lastIndexOf is function");
      assert.arity(Typed.prototype.lastIndexOf, 1, x$ + "::lastIndexOf arity is 1");
      assert.name(Typed.prototype.lastIndexOf, 'lastIndexOf', x$ + "::lastIndexOf name is 'lastIndexOf'");
      assert.looksNative(Typed.prototype.lastIndexOf, x$ + "::lastIndexOf looks native");
      assert.same(new Typed([1, 1, 1]).lastIndexOf(1), 2);
      assert.same(new Typed([1, 2, 3]).lastIndexOf(3, 1), -1);
      assert.same(new Typed([1, 2, 3]).lastIndexOf(2, 1), 1);
      assert.same(new Typed([1, 2, 3]).lastIndexOf(2, -3), -1);
      assert.same(new Typed([1, 2, 3]).lastIndexOf(2, -2), 1);
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.lastIndexOf.call([1, 2], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.map', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, instance, v, k;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.map, x$ + "::map is function");
      assert.arity(Typed.prototype.map, 1, x$ + "::map arity is 1");
      assert.name(Typed.prototype.map, 'map', x$ + "::map name is 'map'");
      assert.looksNative(Typed.prototype.map, x$ + "::map looks native");
      (a = new Typed([1])).map(fn$, ctx = {});
      instance = new Typed([1, 2, 3, 4, 5]).map((fn1$));
      assert.ok(instance instanceof Typed, 'correct instance');
      assert.arrayEqual(instance, [2, 4, 6, 8, 10], 'works');
      v = '';
      k = '';
      new Typed([1, 2, 3]).map(fn2$);
      assert.same(v, '123');
      assert.same(k, '012');
      assert.throws(fn3$, "isn't generic");
    }
    function fn$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      return assert.same(this, ctx, 'correct callback context');
    }
    function fn1$(it){
      return it * 2;
    }
    function fn2$(a, b){
      v += a;
      k += b;
    }
    function fn3$(){
      Typed.prototype.map.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArray%.of', function(assert){
    var i$, x$, ref$, len$, Typed, inst;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.of, x$ + ".of is function");
      assert.arity(Typed.of, 0, x$ + ".of arity is 0");
      assert.name(Typed.of, 'of', x$ + ".of name is 'of'");
      assert.looksNative(Typed.of, x$ + ".of looks native");
      inst = Typed.of();
      assert.ok(inst instanceof Typed, 'correct instance with 0 arguments');
      assert.arrayEqual(inst, [], 'correct elements with 0 arguments');
      inst = Typed.of(1);
      assert.ok(inst instanceof Typed, 'correct instance with 1 argument');
      assert.arrayEqual(inst, [1], 'correct elements with 1 argument');
      inst = Typed.of(1, 2, 3);
      assert.ok(inst instanceof Typed, 'correct instance with several arguments');
      assert.arrayEqual(inst, [1, 2, 3], 'correct elements with several arguments');
      assert.throws(fn$, "isn't generic #1");
      NATIVE && assert.throws(fn1$, "isn't generic #2");
    }
    function fn$(){
      Typed.of.call(void 8, 1);
    }
    function fn1$(){
      Typed.of.call(Array, 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.reduceRight', function(assert){
    var i$, x$, ref$, len$, Typed, a, accumulator, v, k, fn1$ = curry$(function(x$, y$){
      return x$ + y$;
    }), fn3$ = curry$(function(x$, y$){
      return x$ + y$;
    });
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.reduceRight, x$ + "::reduceRight is function");
      assert.arity(Typed.prototype.reduceRight, 1, x$ + "::reduceRight arity is 1");
      assert.name(Typed.prototype.reduceRight, 'reduceRight', x$ + "::reduceRight name is 'reduceRight'");
      assert.looksNative(Typed.prototype.reduceRight, x$ + "::reduceRight looks native");
      (a = new Typed([1])).reduceRight(fn$, accumulator = {});
      assert.same(new Typed([1, 2, 3]).reduceRight(fn1$, 1), 7, 'works with initial accumulator');
      (a = new Typed([1, 2])).reduceRight(fn2$);
      assert.same(new Typed([1, 2, 3]).reduceRight(fn3$), 6, 'works without initial accumulator');
      v = '';
      k = '';
      new Typed([1, 2, 3]).reduceRight(fn4$, 0);
      assert.same(v, '321', 'correct order #1');
      assert.same(k, '210', 'correct order #2');
      assert.throws(fn5$, "isn't generic");
    }
    function fn$(memo, val, key, that){
      assert.same(arguments.length, 4, 'correct number of callback arguments');
      assert.same(memo, accumulator, 'correct callback accumulator');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      return assert.same(that, a, 'correct link to array in callback');
    }
    function fn2$(memo, val, key, that){
      assert.same(memo, 2, 'correct default accumulator');
      assert.same(val, 1, 'correct start value without initial accumulator');
      return assert.same(key, 0, 'correct start index without initial accumulator');
    }
    function fn4$(memo, a, b){
      v += a;
      k += b;
    }
    function fn5$(){
      Typed.prototype.reduceRight.call([0], function(){
        return true;
      });
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.reduce', function(assert){
    var i$, x$, ref$, len$, Typed, a, accumulator, v, k, fn1$ = curry$(function(x$, y$){
      return x$ + y$;
    }), fn3$ = curry$(function(x$, y$){
      return x$ + y$;
    });
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.reduce, x$ + "::reduce is function");
      assert.arity(Typed.prototype.reduce, 1, x$ + "::reduce arity is 1");
      assert.name(Typed.prototype.reduce, 'reduce', x$ + "::reduce name is 'reduce'");
      assert.looksNative(Typed.prototype.reduce, x$ + "::reduce looks native");
      (a = new Typed([1])).reduce(fn$, accumulator = {});
      assert.same(new Typed([1, 2, 3]).reduce(fn1$, 1), 7, 'works with initial accumulator');
      (a = new Typed([1, 2])).reduce(fn2$);
      assert.same(new Typed([1, 2, 3]).reduce(fn3$), 6, 'works without initial accumulator');
      v = '';
      k = '';
      new Typed([1, 2, 3]).reduce(fn4$, 0);
      assert.same(v, '123', 'correct order #1');
      assert.same(k, '012', 'correct order #2');
      assert.throws(fn5$, "isn't generic");
    }
    function fn$(memo, val, key, that){
      assert.same(arguments.length, 4, 'correct number of callback arguments');
      assert.same(memo, accumulator, 'correct callback accumulator');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      return assert.same(that, a, 'correct link to array in callback');
    }
    function fn2$(memo, val, key, that){
      assert.same(memo, 1, 'correct default accumulator');
      assert.same(val, 2, 'correct start value without initial accumulator');
      return assert.same(key, 1, 'correct start index without initial accumulator');
    }
    function fn4$(memo, a, b){
      v += a;
      k += b;
    }
    function fn5$(){
      Typed.prototype.reduce.call([0], function(){
        return true;
      });
    }
  });
  function curry$(f, bound){
    var context,
    _curry = function(args) {
      return f.length > 1 ? function(){
        var params = args ? args.concat() : [];
        context = bound ? context || this : this;
        return params.push.apply(params, arguments) <
            f.length && arguments.length ?
          _curry.call(context, params) : f.apply(context, params);
      } : f;
    };
    return _curry();
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.reverse', function(assert){
    var i$, x$, ref$, len$, Typed, a;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.reverse, x$ + "::reverse is function");
      assert.arity(Typed.prototype.reverse, 0, x$ + "::reverse arity is 0");
      assert.name(Typed.prototype.reverse, 'reverse', x$ + "::reverse name is 'reverse'");
      assert.looksNative(Typed.prototype.reverse, x$ + "::reverse looks native");
      assert.same((a = new Typed([1, 2])).reverse(), a, 'return this');
      assert.arrayEqual(new Typed([1, 2, 3, 4]).reverse(), [4, 3, 2, 1], 'works #1');
      assert.arrayEqual(new Typed([1, 2, 3]).reverse(), [3, 2, 1], 'works #2');
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.reverse.call([1, 2]);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.set', function(assert){
    var i$, x$, ref$, len$, Typed, a, b, y$;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.set, x$ + "::set is function");
      NATIVE && assert.arity(Typed.prototype.set, 1, x$ + "::set arity is 1");
      assert.name(Typed.prototype.set, 'set', x$ + "::set name is 'subarray'");
      assert.looksNative(Typed.prototype.set, x$ + "::set looks native");
      assert.same(new Typed(1).set([1]), void 8, 'void');
      a = new Typed([1, 2, 3, 4, 5]);
      b = new Typed(5);
      b.set(a);
      assert.arrayEqual(b, [1, 2, 3, 4, 5]);
      assert.throws(fn$);
      assert.throws(fn1$);
      b.set(new Typed([99, 98]), 2);
      assert.arrayEqual(b, [1, 2, 99, 98, 5]);
      b.set(new Typed([99, 98, 97]), 2);
      assert.arrayEqual(b, [1, 2, 99, 98, 97]);
      assert.throws(fn2$);
      assert.throws(fn3$);
      assert.arrayEqual((y$ = new Typed(2), y$.set({
        length: 2,
        0: 1,
        1: 2
      }), y$), [1, 2]);
      assert.throws(fn4$, "isn't generic");
    }
    function fn$(){
      b.set(a, 1);
    }
    function fn1$(){
      b.set(a, -1);
    }
    function fn2$(){
      b.set(new Typed([99, 98, 97, 96]), 2);
    }
    function fn3$(){
      b.set([101, 102, 103, 104], 4);
    }
    function fn4$(){
      Typed.prototype.set.call([1, 2, 3], [1]);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.slice', function(assert){
    var i$, x$, ref$, len$, Typed, arr;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.slice, x$ + "::slice is function");
      NATIVE && assert.arity(Typed.prototype.slice, 2, x$ + "::slice arity is 2");
      assert.name(Typed.prototype.slice, 'slice', x$ + "::slice name is 'subarray'");
      assert.looksNative(Typed.prototype.slice, x$ + "::slice looks native");
      arr = new Typed([1, 2, 3, 4, 5]);
      assert.ok(arr.slice() !== arr, 'returns new array');
      assert.ok(arr.slice() instanceof Typed, 'correct instance');
      assert.ok(arr.slice().buffer !== arr.buffer, 'with new buffer');
      assert.arrayEqual(arr.slice(), arr);
      assert.arrayEqual(arr.slice(1, 3), [2, 3]);
      assert.arrayEqual(arr.slice(1, void 8), [2, 3, 4, 5]);
      assert.arrayEqual(arr.slice(1, -1), [2, 3, 4]);
      assert.arrayEqual(arr.slice(-2, -1), [4]);
      assert.arrayEqual(arr.slice(-2, -3), []);
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.slice.call([1, 2, 3], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.some', function(assert){
    var i$, x$, ref$, len$, Typed, a, ctx, v, k, arr;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.some, x$ + "::some is function");
      assert.arity(Typed.prototype.some, 1, x$ + "::some arity is 1");
      assert.name(Typed.prototype.some, 'some', x$ + "::some name is 'some'");
      assert.looksNative(Typed.prototype.some, x$ + "::some looks native");
      (a = new Typed([1])).some(fn$, ctx = {});
      assert.ok(new Typed([1, 2, 3]).some(fn1$));
      assert.ok(new Typed([1, 2, 3]).some((fn2$)));
      assert.ok(!new Typed([1, 2, 3]).some((fn3$)));
      assert.ok(!new Typed([1, 2, 3]).some(fn4$));
      v = '';
      k = '';
      new Typed([1, 2, 3]).some(fn5$);
      assert.same(v, '123');
      assert.same(k, '012');
      assert.ok((arr = new Typed([1, 2, 3])).some(fn6$));
      assert.throws(fn7$, "isn't generic");
    }
    function fn$(val, key, that){
      assert.same(arguments.length, 3, 'correct number of callback arguments');
      assert.same(val, 1, 'correct value in callback');
      assert.same(key, 0, 'correct index in callback');
      assert.same(that, a, 'correct link to array in callback');
      return assert.same(this, ctx, 'correct callback context');
    }
    function fn1$(it){
      return typeof it === 'number';
    }
    function fn2$(it){
      return it < 3;
    }
    function fn3$(it){
      return it < 0;
    }
    function fn4$(it){
      return typeof it === 'string';
    }
    function fn5$(a, b){
      v += a;
      k += b;
    }
    function fn6$(){
      return arguments[2] === arr;
    }
    function fn7$(){
      Typed.prototype.some.call([0], function(){
        return true;
      });
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.subarray', function(assert){
    var i$, x$, ref$, len$, Typed, a, b;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.subarray, x$ + "::subarray is function");
      NATIVE && assert.arity(Typed.prototype.subarray, 2, x$ + "::subarray arity is 2");
      assert.name(Typed.prototype.subarray, 'subarray', x$ + "::subarray name is 'subarray'");
      assert.looksNative(Typed.prototype.subarray, x$ + "::subarray looks native");
      a = new Typed([1, 2, 3, 4, 5]);
      b = a.subarray(3);
      assert.ok(a !== b, 'creates new array');
      assert.ok(b instanceof Typed, "instance " + x$);
      assert.same(a.buffer, b.buffer, 'with the same buffer');
      assert.arrayEqual(b, [4, 5]);
      assert.arrayEqual(a.subarray(1, 3), [2, 3]);
      assert.arrayEqual(a.subarray(-3), [3, 4, 5]);
      assert.arrayEqual(a.subarray(-3, -1), [3, 4]);
      assert.arrayEqual(a.subarray(3, 2), []);
      assert.arrayEqual(a.subarray(-2, -3), []);
      assert.arrayEqual(a.subarray(4, 1), []);
      assert.arrayEqual(a.subarray(-1, -4), []);
      assert.arrayEqual(a.subarray(1).subarray(1), [3, 4, 5]);
      assert.arrayEqual(a.subarray(1, 4).subarray(1, 2), [3]);
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.subarray.call([1, 2, 3], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.toLocaleString', function(assert){
    var i$, x$, ref$, len$, Typed;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.toLocaleString, x$ + "::toLocaleString is function");
      assert.arity(Typed.prototype.toLocaleString, 0, x$ + "::toLocaleString arity is 0");
      assert.name(Typed.prototype.toLocaleString, 'toLocaleString', x$ + "::toLocaleString name is 'toLocaleString'");
      assert.looksNative(Typed.prototype.toLocaleString, x$ + "::toLocaleString looks native");
      assert.same(new Typed([1, 2, 3]).toLocaleString(), [1, 2, 3].toLocaleString(), 'works');
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.toLocaleString.call([1, 2, 3]);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  DESCRIPTORS && test('%TypedArrayPrototype%.toString', function(assert){
    var i$, x$, ref$, len$, Typed;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.toString, x$ + "::toString is function");
      assert.arity(Typed.prototype.toString, 0, x$ + "::toString arity is 0");
      assert.name(Typed.prototype.toString, 'toString', x$ + "::toString name is 'toString'");
      assert.looksNative(Typed.prototype.toString, x$ + "::toString looks native");
      assert.same(new Typed([1, 2, 3]).toString(), '1,2,3', 'works');
      assert.same(Typed.prototype.toString.call([1, 2, 3]), '1,2,3', "generic");
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, freeze;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  freeze = Object.freeze;
  test('WeakMap', function(assert){
    var a, x$, f, M, done, iter, o, key, C, O;
    assert.isFunction(WeakMap);
    assert.name(WeakMap, 'WeakMap');
    assert.arity(WeakMap, 0);
    assert.looksNative(WeakMap);
    assert.ok('delete' in WeakMap.prototype, 'delete in WeakMap.prototype');
    assert.ok('get' in WeakMap.prototype, 'get in WeakMap.prototype');
    assert.ok('has' in WeakMap.prototype, 'has in WeakMap.prototype');
    assert.ok('set' in WeakMap.prototype, 'set in WeakMap.prototype');
    assert.ok(new WeakMap instanceof WeakMap, 'new WeakMap instanceof WeakMap');
    assert.strictEqual(new WeakMap(createIterable([[a = {}, 42]])).get(a), 42, 'Init from iterable');
    assert.strictEqual((x$ = new WeakMap(), x$.set(f = freeze({}), 42), x$).get(f), 42, 'Support frozen objects');
    M = new WeakMap;
    M.set(freeze(f = {}), 42);
    assert.strictEqual(M.has(f), true);
    assert.strictEqual(M.get(f), 42);
    M['delete'](f);
    assert.strictEqual(M.has(f), false);
    assert.strictEqual(M.get(f), void 8);
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      new WeakMap(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    assert.ok(!('clear' in WeakMap.prototype), 'should not contains `.clear` method');
    a = [];
    done = false;
    a[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
      done = true;
      return [][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call(this);
    };
    new WeakMap(a);
    assert.ok(done);
    o = {};
    new WeakMap().set(o, 1);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(Object.keys(o), []);
    }
    assert.arrayEqual(Object.getOwnPropertyNames(o), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(o), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(WeakMap);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof WeakMap, 'correct subclassing with native classes #2');
      assert.same(new C().set(O = {}, 2).get(O), 2, 'correct subclassing with native classes #3');
    }
  });
  test('WeakMap#delete', function(assert){
    var x$, M, a, b;
    assert.isFunction(WeakMap.prototype['delete']);
    NATIVE && assert.name(WeakMap.prototype['delete'], 'delete');
    NATIVE && assert.arity(WeakMap.prototype['delete'], 1);
    assert.looksNative(WeakMap.prototype['delete']);
    assert.nonEnumerable(WeakMap.prototype, 'delete');
    x$ = M = new WeakMap();
    x$.set(a = {}, 42);
    x$.set(b = {}, 21);
    assert.ok(M.has(a) && M.has(b), 'WeakMap has values before .delete()');
    M['delete'](a);
    assert.ok(!M.has(a) && M.has(b), 'WeakMap hasn`t value after .delete()');
    assert.ok((function(){
      try {
        return !M['delete'](1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakMap#get', function(assert){
    var M, a;
    assert.isFunction(WeakMap.prototype.get);
    assert.name(WeakMap.prototype.get, 'get');
    NATIVE && assert.arity(WeakMap.prototype.get, 1);
    assert.looksNative(WeakMap.prototype.get);
    assert.nonEnumerable(WeakMap.prototype, 'get');
    M = new WeakMap();
    assert.strictEqual(M.get({}), void 8, 'WeakMap .get() before .set() return undefined');
    M.set(a = {}, 42);
    assert.strictEqual(M.get(a), 42, 'WeakMap .get() return value');
    M['delete'](a);
    assert.strictEqual(M.get(a), void 8, 'WeakMap .get() after .delete() return undefined');
    assert.ok((function(){
      try {
        return void 8 === M.get(1);
      } catch (e$) {}
    }()), 'return undefined on primitive');
  });
  test('WeakMap#has', function(assert){
    var M, a;
    assert.isFunction(WeakMap.prototype.has);
    assert.name(WeakMap.prototype.has, 'has');
    NATIVE && assert.arity(WeakMap.prototype.has, 1);
    assert.looksNative(WeakMap.prototype.has);
    assert.nonEnumerable(WeakMap.prototype, 'has');
    M = new WeakMap();
    assert.ok(!M.has({}), 'WeakMap .has() before .set() return false');
    M.set(a = {}, 42);
    assert.ok(M.has(a), 'WeakMap .has() return true');
    M['delete'](a);
    assert.ok(!M.has(a), 'WeakMap .has() after .delete() return false');
    assert.ok((function(){
      try {
        return !M.has(1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakMap#set', function(assert){
    var x$, a, e, wmap;
    assert.isFunction(WeakMap.prototype.set);
    assert.name(WeakMap.prototype.set, 'set');
    assert.arity(WeakMap.prototype.set, 2);
    assert.looksNative(WeakMap.prototype.set);
    assert.nonEnumerable(WeakMap.prototype, 'set');
    assert.same((x$ = new WeakMap(), x$.set(a = {}, 42), x$).get(a), 42, 'works with object as keys');
    assert.ok((function(){
      try {
        new WeakMap().set(42, 42);
        return false;
      } catch (e$) {
        e = e$;
        return true;
      }
    }()), 'throws with primitive keys');
    wmap = new WeakMap();
    assert.same(wmap.set({}, 1), wmap, 'return this');
  });
  test('WeakMap#@@toStringTag', function(assert){
    assert.strictEqual(WeakMap.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'WeakMap', 'WeakMap::@@toStringTag is `WeakMap`');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, freeze;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  freeze = Object.freeze;
  test('WeakSet', function(assert){
    var a, x$, f, S, done, iter, o, key, C, O;
    assert.isFunction(WeakSet);
    assert.name(WeakSet, 'WeakSet');
    assert.arity(WeakSet, 0);
    assert.looksNative(WeakSet);
    assert.ok('add' in WeakSet.prototype, 'add in WeakSet.prototype');
    assert.ok('delete' in WeakSet.prototype, 'delete in WeakSet.prototype');
    assert.ok('has' in WeakSet.prototype, 'has in WeakSet.prototype');
    assert.ok(new WeakSet instanceof WeakSet, 'new WeakSet instanceof WeakSet');
    assert.ok(new WeakSet(createIterable([a = {}])).has(a), 'Init from iterable');
    assert.ok((x$ = new WeakSet(), x$.add(freeze(f = {})), x$).has(f), 'Support frozen objects');
    S = new WeakSet;
    S.add(freeze(f = {}));
    assert.strictEqual(S.has(f), true);
    S['delete'](f);
    assert.strictEqual(S.has(f), false);
    done = false;
    iter = createIterable([null, 1, 2], {
      'return': function(){
        return done = true;
      }
    });
    try {
      new WeakSet(iter);
    } catch (e$) {}
    assert.ok(done, '.return #throw');
    assert.ok(!('clear' in WeakSet.prototype), 'should not contains `.clear` method');
    a = [];
    done = false;
    a[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8] = function(){
      done = true;
      return [][typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8].call(this);
    };
    new WeakSet(a);
    assert.ok(done);
    o = {};
    new WeakSet().add(o);
    if (DESCRIPTORS) {
      assert.arrayEqual((function(){
        var results$ = [];
        for (key in o) {
          results$.push(key);
        }
        return results$;
      }()), []);
      assert.arrayEqual(Object.keys(o), []);
    }
    assert.arrayEqual(Object.getOwnPropertyNames(o), []);
    ((typeof Object != 'undefined' && Object !== null) && Object.getOwnPropertySymbols) && assert.arrayEqual(Object.getOwnPropertySymbols(o), []);
    ((typeof Reflect != 'undefined' && Reflect !== null) && Reflect.ownKeys) && assert.arrayEqual(Reflect.ownKeys(o), []);
    if (nativeSubclass) {
      C = nativeSubclass(WeakSet);
      assert.ok(new C instanceof C, 'correct subclassing with native classes #1');
      assert.ok(new C instanceof WeakSet, 'correct subclassing with native classes #2');
      assert.ok(new C().add(O = {}).has(O), 'correct subclassing with native classes #3');
    }
  });
  test('WeakSet#add', function(assert){
    var a, e, wset;
    assert.isFunction(WeakSet.prototype.add);
    assert.name(WeakSet.prototype.add, 'add');
    assert.arity(WeakSet.prototype.add, 1);
    assert.looksNative(WeakSet.prototype.add);
    assert.nonEnumerable(WeakSet.prototype, 'add');
    assert.ok(new WeakSet().add(a = {}), 'works with object as keys');
    assert.ok((function(){
      try {
        new WeakSet().add(42);
        return false;
      } catch (e$) {
        e = e$;
        return true;
      }
    }()), 'throws with primitive keys');
    wset = new WeakSet();
    assert.same(wset.add({}), wset, 'return this');
  });
  test('WeakSet#delete', function(assert){
    var x$, S, a, b;
    assert.isFunction(WeakSet.prototype['delete']);
    NATIVE && assert.arity(WeakSet.prototype['delete'], 1);
    assert.looksNative(WeakSet.prototype['delete']);
    assert.nonEnumerable(WeakSet.prototype, 'delete');
    x$ = S = new WeakSet();
    x$.add(a = {});
    x$.add(b = {});
    assert.ok(S.has(a) && S.has(b), 'WeakSet has values before .delete()');
    S['delete'](a);
    assert.ok(!S.has(a) && S.has(b), 'WeakSet hasn`t value after .delete()');
    assert.ok((function(){
      try {
        return !S['delete'](1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakSet#has', function(assert){
    var M, a;
    assert.isFunction(WeakSet.prototype.has);
    assert.name(WeakSet.prototype.has, 'has');
    assert.arity(WeakSet.prototype.has, 1);
    assert.looksNative(WeakSet.prototype.has);
    assert.nonEnumerable(WeakSet.prototype, 'has');
    M = new WeakSet();
    assert.ok(!M.has({}), 'WeakSet has`nt value');
    M.add(a = {});
    assert.ok(M.has(a), 'WeakSet has value after .add()');
    M['delete'](a);
    assert.ok(!M.has(a), 'WeakSet has`nt value after .delete()');
    assert.ok((function(){
      try {
        return !M.has(1);
      } catch (e$) {}
    }()), 'return false on primitive');
  });
  test('WeakSet::@@toStringTag', function(assert){
    assert.strictEqual(WeakSet.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], 'WeakSet', 'WeakSet::@@toStringTag is `WeakSet`');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Array#flatMap', function(assert){
    var element, index, context, target, array, $context;
    assert.isFunction(Array.prototype.flatMap);
    assert.name(Array.prototype.flatMap, 'flatMap');
    assert.arity(Array.prototype.flatMap, 1);
    assert.looksNative(Array.prototype.flatMap);
    assert.nonEnumerable(Array.prototype, 'flatMap');
    assert.deepEqual([].flatMap(function(it){
      return it;
    }), []);
    assert.deepEqual([1, 2, 3].flatMap(function(it){
      return it;
    }), [1, 2, 3]);
    assert.deepEqual([1, 2, 3].flatMap(function(it){
      return [it, it];
    }), [1, 1, 2, 2, 3, 3]);
    assert.deepEqual([1, 2, 3].flatMap(function(it){
      return [[it], [it]];
    }), [[1], [1], [2], [2], [3], [3]]);
    assert.deepEqual([1, [2, 3]].flatMap(function(){
      return 1;
    }), [1, 1]);
    element = void 8;
    index = void 8;
    context = void 8;
    target = void 8;
    array = [1];
    array.flatMap(function($element, $index, $target){
      element = $element;
      index = $index;
      target = $target;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, 1);
    assert.same(index, 0);
    assert.same(target, array);
    assert.same(context, $context);
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.flatMap.call(null, function(it){
          return it;
        });
      }, TypeError);
      assert.throws(function(){
        Array.prototype.flatMap.call(void 8, function(it){
          return it;
        });
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return false === Array.prototype.flatMap.call(Object.defineProperty({
            length: -1
          }, 0, {
            get: function(){
              throw Error();
            }
          }), function(it){
            return it;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
    assert.ok('flatMap' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Array#flatten', function(assert){
    var arr;
    assert.isFunction(Array.prototype.flatten);
    assert.name(Array.prototype.flatten, 'flatten');
    assert.arity(Array.prototype.flatten, 0);
    assert.looksNative(Array.prototype.flatten);
    assert.nonEnumerable(Array.prototype, 'flatten');
    assert.deepEqual([].flatten(), []);
    arr = [1, [2, 3], [4, [5, 6]]];
    assert.deepEqual(arr.flatten(0), arr);
    assert.deepEqual(arr.flatten(1), [1, 2, 3, 4, [5, 6]]);
    assert.deepEqual(arr.flatten(), [1, 2, 3, 4, [5, 6]]);
    assert.deepEqual(arr.flatten(2), [1, 2, 3, 4, 5, 6]);
    assert.deepEqual(arr.flatten(3), [1, 2, 3, 4, 5, 6]);
    assert.deepEqual(arr.flatten(-1), arr);
    assert.deepEqual(arr.flatten(Infinity), [1, 2, 3, 4, 5, 6]);
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.flatten.call(null, function(it){
          return it;
        });
      }, TypeError);
      assert.throws(function(){
        Array.prototype.flatten.call(void 8, function(it){
          return it;
        });
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return false === Array.prototype.flatten.call(Object.defineProperty({
            length: -1
          }, 0, {
            get: function(){
              throw Error();
            }
          }), function(it){
            return it;
          });
        } catch (e$) {}
      }()), 'uses ToLength');
    }
    assert.ok('flatten' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Array#includes', function(assert){
    var arr, o;
    assert.isFunction(Array.prototype.includes);
    assert.name(Array.prototype.includes, 'includes');
    assert.arity(Array.prototype.includes, 1);
    assert.looksNative(Array.prototype.includes);
    assert.nonEnumerable(Array.prototype, 'includes');
    arr = [1, 2, 3, -0, o = {}];
    assert.ok(arr.includes(1));
    assert.ok(arr.includes(-0));
    assert.ok(arr.includes(0));
    assert.ok(arr.includes(o));
    assert.ok(!arr.includes(4));
    assert.ok(!arr.includes(-0.5));
    assert.ok(!arr.includes({}));
    assert.ok(Array(1).includes(void 8));
    assert.ok([NaN].includes(NaN));
    if (STRICT) {
      assert.throws(function(){
        Array.prototype.includes.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        Array.prototype.includes.call(void 8, 0);
      }, TypeError);
    }
    if (NATIVE && DESCRIPTORS) {
      assert.ok((function(){
        try {
          return false === Array.prototype.includes.call(Object.defineProperty({
            length: -1
          }, 0, {
            get: function(){
              throw Error();
            }
          }), 1);
        } catch (e$) {}
      }()), 'uses ToLength');
    }
    assert.ok('includes' in Array.prototype[Symbol.unscopables], 'In Array#@@unscopables');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('asap', function(assert){
    var async, done, after;
    assert.expect(5);
    assert.isFunction(asap);
    assert.arity(asap, 1);
    assert.name(asap, 'asap');
    assert.looksNative(asap);
    async = assert.async();
    done = false;
    asap(function(){
      if (!done) {
        done = true;
        assert.ok(after, 'works');
        async();
      }
    });
    setTimeout(function(){
      if (!done) {
        done = true;
        assert.ok(false, 'fails');
        async();
      }
    }, 3e3);
    return after = true;
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Error.isError', function(assert){
    var isError;
    isError = Error.isError;
    assert.isFunction(isError);
    assert.arity(isError, 1);
    assert.name(isError, 'isError');
    assert.looksNative(isError);
    assert.nonEnumerable(Error, 'isError');
    assert.same(isError(new TypeError), true);
    assert.same(isError({}), false);
    assert.same(isError(null), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('global', function(assert){
    assert.same(global, Object(global), 'is object');
    assert.same(global.Math, Math, 'contains globals');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Map.from', function(assert){
    var from, element, index, context, $$element, $context, arg, F;
    from = Map.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.name(from, 'from');
    assert.looksNative(from);
    assert.nonEnumerable(Map, 'from');
    assert.ok(Map.from() instanceof Map);
    assert.deepEqual(Array.from(Map.from([])), []);
    assert.deepEqual(Array.from(Map.from([[1, 2]])), [[1, 2]]);
    assert.deepEqual(Array.from(Map.from([[1, 2], [2, 3], [1, 4]])), [[1, 4], [2, 3]]);
    assert.deepEqual(Array.from(Map.from(createIterable([[1, 2], [2, 3], [1, 4]]))), [[1, 4], [2, 3]]);
    element = void 8;
    index = void 8;
    context = void 8;
    Map.from([$$element = [1, 2]], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, $$element);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from([1, 2]);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Map.of', function(assert){
    var $of, arg, F;
    $of = Map.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    assert.name($of, 'of');
    assert.looksNative($of);
    assert.nonEnumerable(Map, 'of');
    assert.ok(Map.of() instanceof Map);
    assert.deepEqual(Array.from(Map.of([1, 2])), [[1, 2]]);
    assert.deepEqual(Array.from(Map.of([1, 2], [2, 3], [1, 4])), [[1, 4], [2, 3]]);
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Map#toJSON', function(assert){
    assert.isFunction(Map.prototype.toJSON);
    assert.name(Map.prototype.toJSON, 'toJSON');
    assert.arity(Map.prototype.toJSON, 0);
    assert.looksNative(Map.prototype.toJSON);
    assert.nonEnumerable(Map.prototype, 'toJSON');
    if (typeof JSON != 'undefined' && JSON !== null) {
      assert.strictEqual(JSON.stringify(new Map([['a', 'b'], ['c', 'd']])), '[["a","b"],["c","d"]]', 'Works');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.clamp', function(assert){
    var clamp;
    clamp = Math.clamp;
    assert.isFunction(clamp);
    assert.name(clamp, 'clamp');
    assert.arity(clamp, 3);
    assert.looksNative(clamp);
    assert.nonEnumerable(Math, 'clamp');
    assert.same(clamp(2, 4, 6), 4);
    assert.same(clamp(4, 2, 6), 4);
    assert.same(clamp(6, 2, 4), 4);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.DEG_PER_RAD', function(assert){
    var DEG_PER_RAD;
    DEG_PER_RAD = Math.DEG_PER_RAD;
    assert.ok('DEG_PER_RAD' in Math, 'DEG_PER_RAD in Math');
    assert.nonEnumerable(Math, 'DEG_PER_RAD');
    assert.strictEqual(DEG_PER_RAD, Math.PI / 180, 'Is Math.PI / 180');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.degrees', function(assert){
    var degrees;
    degrees = Math.degrees;
    assert.isFunction(degrees);
    assert.name(degrees, 'degrees');
    assert.arity(degrees, 1);
    assert.looksNative(degrees);
    assert.nonEnumerable(Math, 'degrees');
    assert.same(degrees(0), 0);
    assert.same(degrees(Math.PI / 2), 90);
    assert.same(degrees(Math.PI), 180);
    assert.same(degrees(3 * Math.PI / 2), 270);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.fscale', function(assert){
    var fscale, fround, PI;
    fscale = Math.fscale, fround = Math.fround, PI = Math.PI;
    assert.isFunction(fscale);
    assert.name(fscale, 'fscale');
    assert.arity(fscale, 5);
    assert.looksNative(fscale);
    assert.nonEnumerable(Math, 'fscale');
    assert.same(fscale(3, 1, 2, 1, 2), 3);
    assert.same(fscale(0, 3, 5, 8, 10), 5);
    assert.same(fscale(1, 1, 1, 1, 1), NaN);
    assert.same(fscale(-1, -1, -1, -1, -1), NaN);
    assert.strictEqual(fscale(3, 1, 2, 1, PI), fround((3 - 1) * (PI - 1) / (2 - 1) + 1));
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.iaddh', function(assert){
    var iaddh;
    iaddh = Math.iaddh;
    assert.isFunction(iaddh);
    assert.name(iaddh, 'iaddh');
    assert.arity(iaddh, 4);
    assert.looksNative(iaddh);
    assert.nonEnumerable(Math, 'iaddh');
    assert.same(iaddh(0, 2, 1, 0), 2);
    assert.same(iaddh(0, 4, 1, 1), 5);
    assert.same(iaddh(2, 4, 1, 1), 5);
    assert.same(iaddh(0xffffffff, 4, 1, 1), 6);
    assert.same(iaddh(1, 4, 0xffffffff, 1), 6);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.imulh', function(assert){
    var imulh;
    imulh = Math.imulh;
    assert.isFunction(imulh);
    assert.name(imulh, 'imulh');
    assert.arity(imulh, 2);
    assert.looksNative(imulh);
    assert.nonEnumerable(Math, 'imulh');
    assert.same(imulh(0xffffffff, 7), -1);
    assert.same(imulh(0xfffffff, 77), 4);
    assert.same(imulh(1, 7), 0);
    assert.same(imulh(-1, 7), -1);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.isubh', function(assert){
    var isubh;
    isubh = Math.isubh;
    assert.isFunction(isubh);
    assert.name(isubh, 'isubh');
    assert.arity(isubh, 4);
    assert.looksNative(isubh);
    assert.nonEnumerable(Math, 'isubh');
    assert.same(isubh(0, 2, 1, 0), 1);
    assert.same(isubh(0, 4, 1, 1), 2);
    assert.same(isubh(2, 4, 1, 1), 3);
    assert.same(isubh(0xffffffff, 4, 1, 1), 3);
    assert.same(isubh(1, 4, 0xffffffff, 1), 2);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES6');
  test('Math.RAD_PER_DEG', function(assert){
    var RAD_PER_DEG;
    RAD_PER_DEG = Math.RAD_PER_DEG;
    assert.ok('RAD_PER_DEG' in Math, 'RAD_PER_DEG in Math');
    assert.nonEnumerable(Math, 'RAD_PER_DEG');
    assert.strictEqual(RAD_PER_DEG, 180 / Math.PI, 'Is 180 / Math.PI');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.radians', function(assert){
    var radians;
    radians = Math.radians;
    assert.isFunction(radians);
    assert.name(radians, 'radians');
    assert.arity(radians, 1);
    assert.looksNative(radians);
    assert.nonEnumerable(Math, 'radians');
    assert.same(radians(0), 0);
    assert.same(radians(90), Math.PI / 2);
    assert.same(radians(180), Math.PI);
    assert.same(radians(270), 3 * Math.PI / 2);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.scale', function(assert){
    var scale;
    scale = Math.scale;
    assert.isFunction(scale);
    assert.name(scale, 'scale');
    assert.arity(scale, 5);
    assert.looksNative(scale);
    assert.nonEnumerable(Math, 'scale');
    assert.same(scale(3, 1, 2, 1, 2), 3);
    assert.same(scale(0, 3, 5, 8, 10), 5);
    assert.same(scale(1, 1, 1, 1, 1), NaN);
    assert.same(scale(-1, -1, -1, -1, -1), NaN);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.signbit', function(assert){
    var signbit;
    signbit = Math.signbit;
    assert.isFunction(signbit);
    assert.name(signbit, 'signbit');
    assert.arity(signbit, 1);
    assert.looksNative(signbit);
    assert.nonEnumerable(Math, 'signbit');
    assert.same(signbit(NaN), NaN);
    assert.same(signbit(), NaN);
    assert.same(signbit(-0), false);
    assert.same(signbit(0), true);
    assert.strictEqual(signbit(Infinity), true);
    assert.strictEqual(signbit(-Infinity), false);
    assert.strictEqual(signbit(13510798882111488), true);
    assert.strictEqual(signbit(-13510798882111488), false);
    assert.strictEqual(signbit(42.5), true);
    assert.strictEqual(signbit(-42.5), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Math.umulh', function(assert){
    var umulh;
    umulh = Math.umulh;
    assert.isFunction(umulh);
    assert.name(umulh, 'umulh');
    assert.arity(umulh, 2);
    assert.looksNative(umulh);
    assert.nonEnumerable(Math, 'umulh');
    assert.same(umulh(0xffffffff, 7), 6);
    assert.same(umulh(0xfffffff, 77), 4);
    assert.same(umulh(1, 7), 0);
    assert.same(umulh(-1, 7), 6);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__defineGetter__', function(assert){
      var __defineGetter__, O, i$, x$, ref$, len$;
      __defineGetter__ = Object.prototype.__defineGetter__;
      assert.isFunction(__defineGetter__);
      assert.arity(__defineGetter__, 2);
      assert.name(__defineGetter__, '__defineGetter__');
      assert.looksNative(__defineGetter__);
      assert.nonEnumerable(Object.prototype, '__defineGetter__');
      O = {};
      assert.same(O.__defineGetter__('key', function(){
        return 42;
      }), void 8, 'void');
      assert.same(O.key, 42, 'works');
      O.__defineSetter__('key', function(){
        this.foo = 43;
      });
      O.key = 44;
      assert.ok(O.key === 42 && O.foo === 43, 'works with setter');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __defineGetter__.call(x$, 1, function(){});
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__defineSetter__', function(assert){
      var __defineSetter__, O, i$, x$, ref$, len$;
      __defineSetter__ = Object.prototype.__defineSetter__;
      assert.isFunction(__defineSetter__);
      assert.arity(__defineSetter__, 2);
      assert.name(__defineSetter__, '__defineSetter__');
      assert.looksNative(__defineSetter__);
      assert.nonEnumerable(Object.prototype, '__defineSetter__');
      O = {};
      assert.same(O.__defineSetter__('key', function(){
        this.foo = 43;
      }), void 8, 'void');
      O.key = 44;
      assert.same(O.foo, 43, 'works');
      O = {};
      O.__defineSetter__('key', function(){
        this.foo = 43;
      });
      O.__defineGetter__('key', function(){
        return 42;
      });
      O.key = 44;
      assert.ok(O.key === 42 && O.foo === 43, 'works with getter');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __defineSetter__.call(x$, 1, function(){});
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Object.entries', function(assert){
    var entries, create, assign;
    entries = Object.entries, create = Object.create, assign = Object.assign;
    assert.isFunction(entries);
    assert.arity(entries, 1);
    assert.name(entries, 'entries');
    assert.looksNative(entries);
    assert.nonEnumerable(Object, 'entries');
    assert.deepEqual(entries({
      q: 1,
      w: 2,
      e: 3
    }), [['q', 1], ['w', 2], ['e', 3]]);
    assert.deepEqual(entries(new String('qwe')), [['0', 'q'], ['1', 'w'], ['2', 'e']]);
    assert.deepEqual(entries(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    })), [['a', 4], ['s', 5], ['d', 6]]);
    assert.deepEqual(entries({
      valueOf: 42
    }), [['valueOf', 42]], 'IE enum keys bug');
    try {
      assert.deepEqual(Function('return Object.entries({a: 1, get b(){delete this.c;return 2},c: 3})')(), [['a', 1], ['b', 2]]);
    } catch (e$) {}
    try {
      assert.deepEqual(Function('return Object.entries({a: 1, get b(){Object.defineProperty(this, "c", {value:4,enumerable:false});return 2},c: 3})')(), [['a', 1], ['b', 2]]);
    } catch (e$) {}
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, create;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  create = Object.create;
  test('Object.getOwnPropertyDescriptors', function(assert){
    var getOwnPropertyDescriptors, O, s, descs;
    getOwnPropertyDescriptors = Object.getOwnPropertyDescriptors;
    assert.isFunction(getOwnPropertyDescriptors);
    assert.arity(getOwnPropertyDescriptors, 1);
    assert.name(getOwnPropertyDescriptors, 'getOwnPropertyDescriptors');
    assert.looksNative(getOwnPropertyDescriptors);
    assert.nonEnumerable(Object, 'getOwnPropertyDescriptors');
    O = create({
      q: 1
    }, {
      e: {
        value: 3
      }
    });
    O.w = 2;
    s = Symbol('s');
    O[s] = 4;
    descs = getOwnPropertyDescriptors(O);
    assert.strictEqual(descs.q, void 8);
    assert.deepEqual(descs.w, {
      enumerable: true,
      configurable: true,
      writable: true,
      value: 2
    });
    if (DESCRIPTORS) {
      assert.deepEqual(descs.e, {
        enumerable: false,
        configurable: false,
        writable: false,
        value: 3
      });
    } else {
      assert.deepEqual(descs.e, {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 3
      });
    }
    assert.strictEqual(descs[s].value, 4);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__lookupGetter__', function(assert){
      var __lookupGetter__, create, O, F, i$, x$, ref$, len$;
      __lookupGetter__ = Object.prototype.__lookupGetter__;
      create = Object.create;
      assert.isFunction(__lookupGetter__);
      assert.arity(__lookupGetter__, 1);
      assert.name(__lookupGetter__, '__lookupGetter__');
      assert.looksNative(__lookupGetter__);
      assert.nonEnumerable(Object.prototype, '__lookupGetter__');
      assert.same({}.__lookupGetter__('key'), void 8, 'empty object');
      assert.same({
        key: 42
      }.__lookupGetter__('key'), void 8, 'data descriptor');
      O = {};
      F = function(){};
      O.__defineGetter__('key', F);
      assert.same(O.__lookupGetter__('key'), F, 'own getter');
      assert.same(create(O).__lookupGetter__('key'), F, 'proto getter');
      assert.same(create(O).__lookupGetter__('foo'), void 8, 'empty proto');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __lookupGetter__.call(x$, 1);
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  if (DESCRIPTORS) {
    test('Object#__lookupSetter__', function(assert){
      var __lookupSetter__, create, O, F, i$, x$, ref$, len$;
      __lookupSetter__ = Object.prototype.__lookupSetter__;
      create = Object.create;
      assert.isFunction(__lookupSetter__);
      assert.arity(__lookupSetter__, 1);
      assert.name(__lookupSetter__, '__lookupSetter__');
      assert.looksNative(__lookupSetter__);
      assert.nonEnumerable(Object.prototype, '__lookupSetter__');
      assert.same({}.__lookupSetter__('key'), void 8, 'empty object');
      assert.same({
        key: 42
      }.__lookupSetter__('key'), void 8, 'data descriptor');
      O = {};
      F = function(){};
      O.__defineSetter__('key', F);
      assert.same(O.__lookupSetter__('key'), F, 'own setter');
      assert.same(create(O).__lookupSetter__('key'), F, 'proto setter');
      assert.same(create(O).__lookupSetter__('foo'), void 8, 'empty proto');
      if (STRICT) {
        for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
          x$ = ref$[i$];
          assert.throws(fn$, TypeError, "Throws on " + x$ + " as `this`");
        }
      }
      function fn$(){
        __lookupSetter__.call(x$, 1);
      }
    });
  }
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Object.values', function(assert){
    var values, create, assign;
    values = Object.values, create = Object.create, assign = Object.assign;
    assert.isFunction(values);
    assert.arity(values, 1);
    assert.name(values, 'values');
    assert.looksNative(values);
    assert.nonEnumerable(Object, 'values');
    assert.deepEqual(values({
      q: 1,
      w: 2,
      e: 3
    }), [1, 2, 3]);
    assert.deepEqual(values(new String('qwe')), ['q', 'w', 'e']);
    assert.deepEqual(values(assign(create({
      q: 1,
      w: 2,
      e: 3
    }), {
      a: 4,
      s: 5,
      d: 6
    })), [4, 5, 6]);
    assert.deepEqual(values({
      valueOf: 42
    }), [42], 'IE enum keys bug');
    try {
      assert.deepEqual(Function('return Object.values({a: 1, get b(){delete this.c;return 2},c: 3})')(), [1, 2]);
    } catch (e$) {}
    try {
      assert.deepEqual(Function('return Object.values({a: 1, get b(){Object.defineProperty(this, "c", {value:4,enumerable:false});return 2},c: 3})')(), [1, 2]);
    } catch (e$) {}
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  'use strict';
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Observable', function(assert){
    var obsevable;
    assert.isFunction(Observable);
    assert.arity(Observable, 1);
    assert.name(Observable, 'Observable');
    assert.looksNative(Observable);
    assert.throws(function(){
      Observable(function(){});
    }, 'throws w/o `new`');
    obsevable = new Observable(function(subscriptionObserver){
      var next, error, complete;
      assert.same(typeof subscriptionObserver, 'object', 'Subscription observer is object');
      assert.same(subscriptionObserver.constructor, Object);
      next = subscriptionObserver.next, error = subscriptionObserver.error, complete = subscriptionObserver.complete;
      assert.isFunction(next);
      assert.isFunction(error);
      assert.isFunction(complete);
      assert.name(next, 'next');
      assert.name(error, 'error');
      assert.name(complete, 'complete');
      assert.arity(next, 1);
      assert.arity(error, 1);
      assert.arity(complete, 1);
      assert.looksNative(next);
      assert.looksNative(error);
      assert.looksNative(complete);
      if (STRICT) {
        assert.same(this, function(){
          return this;
        }(), 'correct executor context');
      }
    });
    obsevable.subscribe({});
    assert.ok(obsevable instanceof Observable);
  });
  test('Observable#subscribe', function(assert){
    var subscription;
    assert.isFunction(Observable.prototype.subscribe);
    assert.arity(Observable.prototype.subscribe, 1);
    assert.name(Observable.prototype.subscribe, 'subscribe');
    assert.looksNative(Observable.prototype.subscribe);
    subscription = new Observable(function(){}).subscribe({});
    assert.same(typeof subscription, 'object', 'Subscription is object');
    assert.same(subscription.constructor, Object);
    assert.isFunction(subscription.unsubscribe);
    assert.arity(subscription.unsubscribe, 0);
    assert.name(subscription.unsubscribe, 'unsubscribe');
    assert.looksNative(subscription.unsubscribe);
  });
  test('Observable#forEach', function(assert){
    assert.isFunction(Observable.prototype.forEach);
    assert.arity(Observable.prototype.forEach, 1);
    assert.name(Observable.prototype.forEach, 'forEach');
    assert.looksNative(Observable.prototype.forEach);
    assert.ok(new Observable(function(){}).forEach(function(){}) instanceof Promise, 'returns Promise');
  });
  test('Observable#constructor', function(assert){
    assert.same(Observable.prototype.constructor, Observable);
  });
  test('Observable#@@observable', function(assert){
    var observable;
    assert.isFunction(Observable.prototype[Symbol.observable]);
    observable = new Observable(function(){});
    assert.same(observable[Symbol.observable](), observable);
  });
  test('Observable.of', function(assert){
    assert.isFunction(Observable.of);
    assert.arity(Observable.of, 0);
    assert.name(Observable.of, 'of');
    assert.looksNative(Observable.of);
  });
  test('Observable.from', function(assert){
    assert.isFunction(Observable.from);
    assert.arity(Observable.from, 1);
    assert.name(Observable.from, 'from');
    assert.looksNative(Observable.from);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Promise#finally', function(assert){
    assert.isFunction(Promise.prototype['finally']);
    assert.arity(Promise.prototype['finally'], 1);
    assert.looksNative(Promise.prototype['finally']);
    assert.nonEnumerable(Promise.prototype, 'finally');
    assert.ok(Promise.resolve(42)['finally'](function(){}) instanceof Promise, 'returns a promise');
  });
  test('Promise#finally, resolved', function(assert){
    var async, called, arg;
    assert.expect(3);
    async = assert.async();
    called = 0;
    arg = void 8;
    Promise.resolve(42)['finally'](function(it){
      called++;
      arg = it;
    }).then(function(it){
      assert.same(it, 42, 'resolved with a correct value');
      assert.same(called, 1, 'onFinally function called one time');
      assert.same(arg, void 8, 'onFinally function called with a correct argument');
      async();
    });
  });
  test('Promise#finally, rejected', function(assert){
    var async, called, arg;
    assert.expect(2);
    async = assert.async();
    called = 0;
    arg = void 8;
    Promise.reject(42)['finally'](function(it){
      called++;
      arg = it;
    })['catch'](function(){
      assert.same(called, 1, 'onFinally function called one time');
      assert.same(arg, void 8, 'onFinally function called with a correct argument');
      async();
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Promise.try', function(assert){
    assert.isFunction(Promise['try']);
    assert.arity(Promise['try'], 1);
    assert.looksNative(Promise['try']);
    assert.nonEnumerable(Promise, 'try');
    assert.ok(Promise['try'](function(){
      return 42;
    }) instanceof Promise, 'returns a promise');
  });
  test('Promise.try, resolved', function(assert){
    var async;
    assert.expect(1);
    async = assert.async();
    Promise['try'](function(){
      return 42;
    }).then(function(it){
      assert.same(it, 42, 'resolved with a correct value');
      async();
    });
  });
  test('Promise.try, rejected', function(assert){
    var async;
    assert.expect(1);
    async = assert.async();
    Promise['try'](function(){
      throw 42;
    })['catch'](function(){
      assert.ok(true, 'rejected as expected');
      async();
    });
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.defineMetadata', function(assert){
    var defineMetadata;
    defineMetadata = Reflect.defineMetadata;
    assert.isFunction(defineMetadata);
    assert.arity(defineMetadata, 4);
    assert.name(defineMetadata, 'defineMetadata');
    assert.looksNative(defineMetadata);
    assert.nonEnumerable(Reflect, 'defineMetadata');
    assert.throws(function(){
      defineMetadata('key', 'value', void 8, void 8);
    }, TypeError);
    assert.same(defineMetadata('key', 'value', {}, void 8), void 8);
    assert.same(defineMetadata('key', 'value', {}, 'name'), void 8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.deleteMetadata', function(assert){
    var defineMetadata, hasOwnMetadata, deleteMetadata, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, hasOwnMetadata = Reflect.hasOwnMetadata, deleteMetadata = Reflect.deleteMetadata;
    create = Object.create;
    assert.isFunction(deleteMetadata);
    assert.arity(deleteMetadata, 2);
    assert.name(deleteMetadata, 'deleteMetadata');
    assert.looksNative(deleteMetadata);
    assert.nonEnumerable(Reflect, 'deleteMetadata');
    assert.throws(function(){
      deleteMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(deleteMetadata('key', {}, void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(deleteMetadata('key', obj, void 8), true);
    prototype = {};
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(deleteMetadata('key', create(prototype), void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    deleteMetadata('key', obj, void 8);
    assert.same(hasOwnMetadata("key", obj, undefined), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getMetadataKeys', function(assert){
    var defineMetadata, getMetadataKeys, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, getMetadataKeys = Reflect.getMetadataKeys;
    create = Object.create;
    assert.isFunction(getMetadataKeys);
    assert.arity(getMetadataKeys, 1);
    assert.name(getMetadataKeys, 'getMetadataKeys');
    assert.looksNative(getMetadataKeys);
    assert.nonEnumerable(Reflect, 'getMetadataKeys');
    assert.throws(function(){
      getMetadataKeys(void 8, void 8);
    }, TypeError);
    assert.deepEqual(getMetadataKeys({}, void 8), []);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key']);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key0', 'key1']);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    defineMetadata('key0', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, void 8);
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getMetadataKeys(obj, void 8), ['key0', 'key1', 'key2']);
    obj = {};
    assert.deepEqual(getMetadataKeys({}, 'name'), []);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key']);
    obj = {};
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    defineMetadata('key0', 'value', obj, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, 'name');
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    assert.deepEqual(getMetadataKeys(obj, 'name'), ['key0', 'key1', 'key2']);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getMetadata', function(assert){
    var defineMetadata, getMetadata, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, getMetadata = Reflect.getMetadata;
    create = Object.create;
    assert.isFunction(getMetadata);
    assert.arity(getMetadata, 2);
    assert.name(getMetadata, 'getMetadata');
    assert.looksNative(getMetadata);
    assert.nonEnumerable(Reflect, 'getMetadata');
    assert.throws(function(){
      getMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(getMetadata('key', {}, void 8), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(getMetadata('key', obj, void 8), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(getMetadata('key', obj, void 8), 'value');
    assert.same(getMetadata('key', {}, 'name'), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(getMetadata('key', obj, 'name'), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(getMetadata('key', obj, 'name'), 'value');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getOwnMetadata', function(assert){
    var defineMetadata, getOwnMetadata, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, getOwnMetadata = Reflect.getOwnMetadata;
    create = Object.create;
    assert.isFunction(getOwnMetadata);
    assert.arity(getOwnMetadata, 2);
    assert.name(getOwnMetadata, 'getOwnMetadata');
    assert.looksNative(getOwnMetadata);
    assert.nonEnumerable(Reflect, 'getOwnMetadata');
    assert.throws(function(){
      getOwnMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(getOwnMetadata('key', {}, void 8), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(getOwnMetadata('key', obj, void 8), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(getOwnMetadata('key', obj, void 8), void 8);
    assert.same(getOwnMetadata('key', {}, 'name'), void 8);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(getOwnMetadata('key', obj, 'name'), 'value');
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(getOwnMetadata('key', obj, 'name'), void 8);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.getOwnMetadataKeys', function(assert){
    var defineMetadata, getOwnMetadataKeys, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, getOwnMetadataKeys = Reflect.getOwnMetadataKeys;
    create = Object.create;
    assert.isFunction(getOwnMetadataKeys);
    assert.arity(getOwnMetadataKeys, 1);
    assert.name(getOwnMetadataKeys, 'getOwnMetadataKeys');
    assert.looksNative(getOwnMetadataKeys);
    assert.nonEnumerable(Reflect, 'getOwnMetadataKeys');
    assert.throws(function(){
      getOwnMetadataKeys(void 8, void 8);
    }, TypeError);
    assert.deepEqual(getOwnMetadataKeys({}, void 8), []);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), []);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key0', 'key1']);
    obj = {};
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    defineMetadata('key0', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, void 8);
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, void 8);
    defineMetadata('key1', 'value', obj, void 8);
    assert.deepEqual(getOwnMetadataKeys(obj, void 8), ['key0', 'key1']);
    obj = {};
    assert.deepEqual(getOwnMetadataKeys({}, 'name'), []);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), ['key']);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), []);
    obj = {};
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    defineMetadata('key0', 'value', obj, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), ['key0', 'key1']);
    prototype = {};
    defineMetadata('key2', 'value', prototype, 'name');
    obj = create(prototype);
    defineMetadata('key0', 'value', obj, 'name');
    defineMetadata('key1', 'value', obj, 'name');
    assert.deepEqual(getOwnMetadataKeys(obj, 'name'), ['key0', 'key1']);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.hasMetadata', function(assert){
    var defineMetadata, hasMetadata, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, hasMetadata = Reflect.hasMetadata;
    create = Object.create;
    assert.isFunction(hasMetadata);
    assert.arity(hasMetadata, 2);
    assert.name(hasMetadata, 'hasMetadata');
    assert.looksNative(hasMetadata);
    assert.nonEnumerable(Reflect, 'hasMetadata');
    assert.throws(function(){
      hasMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(hasMetadata('key', {}, void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(hasMetadata('key', obj, void 8), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(hasMetadata('key', obj, void 8), true);
    assert.same(hasMetadata('key', {}, 'name'), false);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(hasMetadata('key', obj, 'name'), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(hasMetadata('key', obj, 'name'), true);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.hasOwnMetadata', function(assert){
    var defineMetadata, hasOwnMetadata, create, obj, prototype;
    defineMetadata = Reflect.defineMetadata, hasOwnMetadata = Reflect.hasOwnMetadata;
    create = Object.create;
    assert.isFunction(hasOwnMetadata);
    assert.arity(hasOwnMetadata, 2);
    assert.name(hasOwnMetadata, 'hasOwnMetadata');
    assert.looksNative(hasOwnMetadata);
    assert.nonEnumerable(Reflect, 'hasOwnMetadata');
    assert.throws(function(){
      hasOwnMetadata('key', void 8, void 8);
    }, TypeError);
    assert.same(hasOwnMetadata('key', {}, void 8), false);
    obj = {};
    defineMetadata('key', 'value', obj, void 8);
    assert.same(hasOwnMetadata('key', obj, void 8), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, void 8);
    assert.same(hasOwnMetadata('key', obj, void 8), false);
    assert.same(hasOwnMetadata('key', {}, 'name'), false);
    obj = {};
    defineMetadata('key', 'value', obj, 'name');
    assert.same(hasOwnMetadata('key', obj, 'name'), true);
    prototype = {};
    obj = create(prototype);
    defineMetadata('key', 'value', prototype, 'name');
    assert.same(hasOwnMetadata('key', obj, 'name'), false);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Reflect.metadata', function(assert){
    var metadata, hasOwnMetadata, decorator, target;
    metadata = Reflect.metadata, hasOwnMetadata = Reflect.hasOwnMetadata;
    assert.isFunction(metadata);
    assert.arity(metadata, 2);
    assert.name(metadata, 'metadata');
    assert.looksNative(metadata);
    assert.nonEnumerable(Reflect, 'metadata');
    assert.isFunction(metadata('key', 'value'));
    decorator = metadata('key', 'value');
    assert.throws(function(){
      decorator(void 8, 'name');
    }, TypeError);
    assert.throws(function(){
      decorator({}, void 8);
    }, TypeError);
    target = function(){};
    decorator(target);
    assert.same(hasOwnMetadata('key', target, void 8), true);
    target = {};
    decorator(target, 'name');
    assert.same(hasOwnMetadata('key', target, 'name'), true);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Set.from', function(assert){
    var from, element, index, context, $context, arg, F;
    from = Set.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.name(from, 'from');
    assert.looksNative(from);
    assert.nonEnumerable(Set, 'from');
    assert.ok(Set.from() instanceof Set);
    assert.deepEqual(Array.from(Set.from([])), []);
    assert.deepEqual(Array.from(Set.from([1])), [1]);
    assert.deepEqual(Array.from(Set.from([1, 2, 3, 2, 1])), [1, 2, 3]);
    assert.deepEqual(Array.from(Set.from(createIterable([1, 2, 3, 2, 1]))), [1, 2, 3]);
    element = void 8;
    index = void 8;
    context = void 8;
    Set.from([1], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, 1);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Set.of', function(assert){
    var $of, arg, F;
    $of = Set.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    assert.name($of, 'of');
    assert.looksNative($of);
    assert.nonEnumerable(Set, 'of');
    assert.ok(Set.of() instanceof Set);
    assert.deepEqual(Array.from(Set.of(1)), [1]);
    assert.deepEqual(Array.from(Set.of(1, 2, 3, 2, 1)), [1, 2, 3]);
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Set#toJSON', function(assert){
    assert.isFunction(Set.prototype.toJSON);
    assert.name(Set.prototype.toJSON, 'toJSON');
    assert.arity(Set.prototype.toJSON, 0);
    assert.looksNative(Set.prototype.toJSON);
    assert.nonEnumerable(Set.prototype, 'toJSON');
    if (typeof JSON != 'undefined' && JSON !== null) {
      assert.strictEqual(JSON.stringify(new Set([1, 2, 3, 2, 1])), '[1,2,3]', 'Works');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#at', function(assert){
    var at;
    assert.isFunction(String.prototype.at);
    assert.arity(String.prototype.at, 1);
    assert.name(String.prototype.at, 'at');
    assert.looksNative(String.prototype.at);
    assert.nonEnumerable(String.prototype, 'at');
    assert.strictEqual('abc\uD834\uDF06def'.at(-Infinity), '');
    assert.strictEqual('abc\uD834\uDF06def'.at(-1), '');
    assert.strictEqual('abc\uD834\uDF06def'.at(-0), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(+0), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(1), 'b');
    assert.strictEqual('abc\uD834\uDF06def'.at(3), '\uD834\uDF06');
    assert.strictEqual('abc\uD834\uDF06def'.at(4), '\uDF06');
    assert.strictEqual('abc\uD834\uDF06def'.at(5), 'd');
    assert.strictEqual('abc\uD834\uDF06def'.at(42), '');
    assert.strictEqual('abc\uD834\uDF06def'.at(Infinity), '');
    assert.strictEqual('abc\uD834\uDF06def'.at(null), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(void 8), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(false), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(NaN), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(''), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at('_'), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at('1'), 'b');
    assert.strictEqual('abc\uD834\uDF06def'.at([]), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at({}), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(-0.9), 'a');
    assert.strictEqual('abc\uD834\uDF06def'.at(1.9), 'b');
    assert.strictEqual('abc\uD834\uDF06def'.at(7.9), 'f');
    assert.strictEqual('abc\uD834\uDF06def'.at(Math.pow(2, 32)), '');
    assert.strictEqual('\uD834\uDF06def'.at(-Infinity), '');
    assert.strictEqual('\uD834\uDF06def'.at(-1), '');
    assert.strictEqual('\uD834\uDF06def'.at(-0), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(0), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(1), '\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(2), 'd');
    assert.strictEqual('\uD834\uDF06def'.at(3), 'e');
    assert.strictEqual('\uD834\uDF06def'.at(4), 'f');
    assert.strictEqual('\uD834\uDF06def'.at(42), '');
    assert.strictEqual('\uD834\uDF06def'.at(Infinity), '');
    assert.strictEqual('\uD834\uDF06def'.at(null), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(void 8), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(false), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(NaN), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at(''), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at('_'), '\uD834\uDF06');
    assert.strictEqual('\uD834\uDF06def'.at('1'), '\uDF06');
    assert.strictEqual('\uD834abc'.at(-Infinity), '');
    assert.strictEqual('\uD834abc'.at(-1), '');
    assert.strictEqual('\uD834abc'.at(-0), '\uD834');
    assert.strictEqual('\uD834abc'.at(0), '\uD834');
    assert.strictEqual('\uD834abc'.at(1), 'a');
    assert.strictEqual('\uD834abc'.at(42), '');
    assert.strictEqual('\uD834abc'.at(Infinity), '');
    assert.strictEqual('\uD834abc'.at(null), '\uD834');
    assert.strictEqual('\uD834abc'.at(void 8), '\uD834');
    assert.strictEqual('\uD834abc'.at(), '\uD834');
    assert.strictEqual('\uD834abc'.at(false), '\uD834');
    assert.strictEqual('\uD834abc'.at(NaN), '\uD834');
    assert.strictEqual('\uD834abc'.at(''), '\uD834');
    assert.strictEqual('\uD834abc'.at('_'), '\uD834');
    assert.strictEqual('\uD834abc'.at('1'), 'a');
    assert.strictEqual('\uDF06abc'.at(-Infinity), '');
    assert.strictEqual('\uDF06abc'.at(-1), '');
    assert.strictEqual('\uDF06abc'.at(-0), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(0), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(1), 'a');
    assert.strictEqual('\uDF06abc'.at(42), '');
    assert.strictEqual('\uDF06abc'.at(Infinity), '');
    assert.strictEqual('\uDF06abc'.at(null), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(void 8), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(false), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(NaN), '\uDF06');
    assert.strictEqual('\uDF06abc'.at(''), '\uDF06');
    assert.strictEqual('\uDF06abc'.at('_'), '\uDF06');
    assert.strictEqual('\uDF06abc'.at('1'), 'a');
    at = String.prototype.at;
    assert.strictEqual(at.call(42, 0), '4');
    assert.strictEqual(at.call(42, 1), '2');
    assert.strictEqual(at.call({
      toString: function(){
        return 'abc';
      }
    }, 2), 'c');
    if (STRICT) {
      assert.throws(function(){
        String.prototype.at.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.at.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#matchAll', function(assert){
    var matchAll, assign, i$, x$, ref$, len$, iter, y$, z$;
    matchAll = String.prototype.matchAll;
    assign = Object.assign;
    assert.isFunction(matchAll);
    assert.arity(matchAll, 1);
    assert.name(matchAll, 'matchAll');
    assert.looksNative(matchAll);
    assert.nonEnumerable(String.prototype, 'matchAll');
    for (i$ = 0, len$ = (ref$ = [
      'aabc', {
        toString: fn$
      }
    ]).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      iter = matchAll.call(x$, /[ac]/);
      assert.isIterator(iter);
      assert.isIterable(iter);
      assert.deepEqual(iter.next(), {
        value: assign(['a'], {
          input: 'aabc',
          index: 0
        }),
        done: false
      });
      assert.deepEqual(iter.next(), {
        value: assign(['a'], {
          input: 'aabc',
          index: 1
        }),
        done: false
      });
      assert.deepEqual(iter.next(), {
        value: assign(['c'], {
          input: 'aabc',
          index: 3
        }),
        done: false
      });
      assert.deepEqual(iter.next(), {
        value: null,
        done: true
      });
    }
    iter = '1111a2b3cccc'.matchAll(/(\d)(\D)/);
    assert.isIterator(iter);
    assert.isIterable(iter);
    assert.deepEqual(iter.next(), {
      value: assign(['1a', '1', 'a'], {
        input: '1111a2b3cccc',
        index: 3
      }),
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: assign(['2b', '2', 'b'], {
        input: '1111a2b3cccc',
        index: 5
      }),
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: assign(['3c', '3', 'c'], {
        input: '1111a2b3cccc',
        index: 7
      }),
      done: false
    });
    assert.deepEqual(iter.next(), {
      value: null,
      done: true
    });
    for (i$ = 0, len$ = (ref$ = [null, void 8, 'qwe', NaN, 42, new Date(), {}, []]).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      assert.throws(fn1$, TypeError, "Throws on " + y$ + " as first arguments");
    }
    if (STRICT) {
      for (i$ = 0, len$ = (ref$ = [null, void 8]).length; i$ < len$; ++i$) {
        z$ = ref$[i$];
        assert.throws(fn2$, TypeError, "Throws on " + z$ + " as `this`");
      }
    }
    function fn$(){
      return 'aabc';
    }
    function fn1$(){
      ''.matchAll(y$);
    }
    function fn2$(){
      matchAll.call(z$, /./);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#padEnd', function(assert){
    assert.isFunction(String.prototype.padEnd);
    assert.arity(String.prototype.padEnd, 1);
    assert.name(String.prototype.padEnd, 'padEnd');
    assert.looksNative(String.prototype.padEnd);
    assert.nonEnumerable(String.prototype, 'padEnd');
    assert.strictEqual('abc'.padEnd(5), 'abc  ');
    assert.strictEqual('abc'.padEnd(4, 'de'), 'abcd');
    assert.strictEqual('abc'.padEnd(), 'abc');
    assert.strictEqual('abc'.padEnd(5, '_'), 'abc__');
    assert.strictEqual(''.padEnd(0), '');
    assert.strictEqual('foo'.padEnd(1), 'foo');
    assert.strictEqual('foo'.padEnd(5, ''), 'foo');
    if (STRICT) {
      assert.throws(function(){
        String.prototype.padEnd.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.padEnd.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#padStart', function(assert){
    assert.isFunction(String.prototype.padStart);
    assert.arity(String.prototype.padStart, 1);
    assert.name(String.prototype.padStart, 'padStart');
    assert.looksNative(String.prototype.padStart);
    assert.nonEnumerable(String.prototype, 'padStart');
    assert.strictEqual('abc'.padStart(5), '  abc');
    assert.strictEqual('abc'.padStart(4, 'de'), 'dabc');
    assert.strictEqual('abc'.padStart(), 'abc');
    assert.strictEqual('abc'.padStart(5, '_'), '__abc');
    assert.strictEqual(''.padStart(0), '');
    assert.strictEqual('foo'.padStart(1), 'foo');
    assert.strictEqual('foo'.padStart(5, ''), 'foo');
    if (STRICT) {
      assert.throws(function(){
        String.prototype.padStart.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.padStart.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#trimLeft', function(assert){
    assert.isFunction(''.trimLeft);
    assert.arity(String.prototype.trimLeft, 0);
    assert.name(String.prototype.trimLeft, 'trimLeft');
    assert.looksNative(String.prototype.trimLeft);
    assert.nonEnumerable(String.prototype, 'trimLeft');
    assert.strictEqual(' \n  q w e \n  '.trimLeft(), 'q w e \n  ', 'removes whitespaces at left side of string');
    assert.strictEqual('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'.trimLeft(), '', 'removes all whitespaces');
    assert.strictEqual('\u200b\u0085'.trimLeft(), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        String.prototype.trimLeft.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.trimLeft.call(void 8, 0);
      }, TypeError);
    }
  });
  test('String#trimStart', function(assert){
    assert.isFunction(''.trimStart);
    assert.arity(String.prototype.trimStart, 0);
    assert.name(String.prototype.trimStart, 'trimLeft');
    assert.looksNative(String.prototype.trimStart);
    assert.nonEnumerable(String.prototype, 'trimStart');
    assert.same(String.prototype.trimStart, String.prototype.trimLeft, 'same #trimLeft');
    assert.strictEqual(' \n  q w e \n  '.trimStart(), 'q w e \n  ', 'removes whitespaces at left side of string');
    assert.strictEqual('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'.trimStart(), '', 'removes all whitespaces');
    assert.strictEqual('\u200b\u0085'.trimStart(), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        String.prototype.trimStart.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.trimStart.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('String#trimRight', function(assert){
    assert.isFunction(''.trimRight);
    assert.arity(String.prototype.trimRight, 0);
    assert.name(String.prototype.trimRight, 'trimRight');
    assert.looksNative(String.prototype.trimRight);
    assert.nonEnumerable(String.prototype, 'trimRight');
    assert.strictEqual(' \n  q w e \n  '.trimRight(), ' \n  q w e', 'removes whitespaces at right side of string');
    assert.strictEqual('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'.trimRight(), '', 'removes all whitespaces');
    assert.strictEqual('\u200b\u0085'.trimRight(), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        String.prototype.trimRight.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.trimRight.call(void 8, 0);
      }, TypeError);
    }
  });
  test('String#trimEnd', function(assert){
    assert.isFunction(''.trimEnd);
    assert.arity(String.prototype.trimEnd, 0);
    assert.name(String.prototype.trimEnd, 'trimRight');
    assert.looksNative(String.prototype.trimEnd);
    assert.nonEnumerable(String.prototype, 'trimEnd');
    assert.same(String.prototype.trimEnd, String.prototype.trimRight, 'same #trimRight');
    assert.strictEqual(' \n  q w e \n  '.trimEnd(), ' \n  q w e', 'removes whitespaces at right side of string');
    assert.strictEqual('\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF'.trimEnd(), '', 'removes all whitespaces');
    assert.strictEqual('\u200b\u0085'.trimEnd(), '\u200b\u0085', "shouldn't remove this symbols");
    if (STRICT) {
      assert.throws(function(){
        String.prototype.trimEnd.call(null, 0);
      }, TypeError);
      assert.throws(function(){
        String.prototype.trimEnd.call(void 8, 0);
      }, TypeError);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Symbol.asyncIterator', function(assert){
    var desc;
    assert.ok('asyncIterator' in Symbol, "Symbol.asyncIterator available");
    assert.nonEnumerable(Symbol, 'asyncIterator');
    assert.ok(Object(Symbol.asyncIterator) instanceof Symbol, "Symbol.asyncIterator is symbol");
    if (DESCRIPTORS) {
      desc = Object.getOwnPropertyDescriptor(Symbol, 'asyncIterator');
      assert.ok(!desc.enumerble, 'non-enumerable');
      assert.ok(!desc.writable, 'non-writable');
      assert.ok(!desc.configurable, 'non-configurable');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('Symbol.observable', function(assert){
    var desc;
    assert.ok('observable' in Symbol, "Symbol.observable available");
    assert.nonEnumerable(Symbol, 'observable');
    assert.ok(Object(Symbol.observable) instanceof Symbol, "Symbol.observable is symbol");
    if (DESCRIPTORS) {
      desc = Object.getOwnPropertyDescriptor(Symbol, 'observable');
      assert.ok(!desc.enumerble, 'non-enumerable');
      assert.ok(!desc.writable, 'non-writable');
      assert.ok(!desc.configurable, 'non-configurable');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('System.global', function(assert){
    var global;
    global = typeof System != 'undefined' && System !== null ? System.global : void 8;
    assert.nonEnumerable(System, 'global');
    assert.same(global, Object(global), 'is object');
    assert.same(global.Math, Math, 'contains globals');
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, this$ = this;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  DESCRIPTORS && test('%TypedArrayPrototype%.includes', function(assert){
    var i$, x$, ref$, len$, Typed;
    for (i$ = 0, len$ = (ref$ = ['Float32Array', 'Float64Array', 'Int8Array', 'Int16Array', 'Int32Array', 'Uint8Array', 'Uint16Array', 'Uint32Array', 'Uint8ClampedArray']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Typed = global[x$];
      assert.isFunction(Typed.prototype.includes, x$ + "::includes is function");
      assert.arity(Typed.prototype.includes, 1, x$ + "::includes arity is 1");
      assert.name(Typed.prototype.includes, 'includes', x$ + "::includes name is 'includes'");
      assert.looksNative(Typed.prototype.includes, x$ + "::includes looks native");
      assert.same(new Typed([1, 1, 1]).includes(1), true);
      assert.same(new Typed([1, 1, 1]).includes(2), false);
      assert.same(new Typed([1, 2, 3]).includes(1, 1), false);
      assert.same(new Typed([1, 2, 3]).includes(2, 1), true);
      assert.same(new Typed([1, 2, 3]).includes(2, -1), false);
      assert.same(new Typed([1, 2, 3]).includes(2, -2), true);
      assert.throws(fn$, "isn't generic");
    }
    function fn$(){
      Typed.prototype.includes.call([1, 2], 1);
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakMap.from', function(assert){
    var from, $1, element, index, context, $$element, $context, arg, F;
    from = WeakMap.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.name(from, 'from');
    assert.looksNative(from);
    assert.nonEnumerable(WeakMap, 'from');
    assert.ok(WeakMap.from() instanceof WeakMap);
    $1 = [];
    assert.same(WeakMap.from([[$1, 2]]).get($1), 2);
    assert.same(WeakMap.from(createIterable([[$1, 2]])).get($1), 2);
    element = void 8;
    index = void 8;
    context = void 8;
    WeakSet.from([$$element = [{}, 1]], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, $$element);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from([{}, 1]);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakMap.of', function(assert){
    var $of, $1, arg, F;
    $of = WeakMap.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    assert.name($of, 'of');
    assert.looksNative($of);
    assert.nonEnumerable(WeakMap, 'of');
    $1 = [];
    assert.ok(WeakMap.of() instanceof WeakMap);
    assert.same(WeakMap.of([$1, 2]).get($1), 2);
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakSet.from', function(assert){
    var from, $1, element, index, context, $$element, $context, arg, F;
    from = WeakSet.from;
    assert.isFunction(from);
    assert.arity(from, 1);
    assert.name(from, 'from');
    assert.looksNative(from);
    assert.nonEnumerable(WeakSet, 'from');
    assert.ok(WeakSet.from() instanceof WeakSet);
    $1 = [];
    assert.ok(WeakSet.from([$1]).has($1));
    assert.ok(WeakSet.from(createIterable([$1])).has($1));
    element = void 8;
    index = void 8;
    context = void 8;
    WeakSet.from([$$element = {}], function($element, $index){
      element = $element;
      index = $index;
      context = this;
      return element;
    }, $context = {});
    assert.same(element, $$element);
    assert.same(index, 0);
    assert.same(context, $context);
    assert.throws(function(){
      from({});
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    from.call(F, createIterable([1, 2, 3]), function(it){
      return Math.pow(it, 2);
    });
    assert.deepEqual(arg, [1, 4, 9]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('ES7');
  test('WeakSet.of', function(assert){
    var $of, $1, arg, F;
    $of = WeakSet.of;
    assert.isFunction($of);
    assert.arity($of, 0);
    assert.name($of, 'of');
    assert.looksNative($of);
    assert.nonEnumerable(WeakSet, 'of');
    $1 = [];
    assert.ok(WeakSet.of() instanceof WeakSet);
    assert.ok(WeakSet.of($1).has($1));
    assert.throws(function(){
      $of(1);
    });
    arg = void 8;
    F = function(it){
      return arg = it;
    };
    $of.call(F, 1, 2, 3);
    assert.deepEqual(arg, [1, 2, 3]);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test;
  module = QUnit.module, test = QUnit.test;
  module('Web');
  test('Iterable DOM collections', function(assert){
    var absent, i$, x$, ref$, len$, Collection, y$;
    absent = true;
    for (i$ = 0, len$ = (ref$ = ['NodeList', 'DOMTokenList', 'MediaList', 'StyleSheetList', 'CSSRuleList']).length; i$ < len$; ++i$) {
      x$ = ref$[i$];
      Collection = global[x$];
      if (Collection) {
        assert.same(Collection.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], x$, x$ + "::@@toStringTag is '" + x$ + "'");
        assert.isFunction(Collection.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], x$ + "::@@iterator is function");
        assert.isFunction(Collection.prototype.values, x$ + "::@@values is function");
        assert.isFunction(Collection.prototype.keys, x$ + "::@@keys is function");
        assert.isFunction(Collection.prototype.entries, x$ + "::@@entries is function");
        absent = false;
      }
    }
    for (i$ = 0, len$ = (ref$ = ['CSSStyleDeclaration', 'CSSValueList', 'ClientRectList', 'DOMRectList', 'DOMStringList', 'DataTransferItemList', 'FileList', 'HTMLAllCollection', 'HTMLCollection', 'HTMLFormElement', 'HTMLSelectElement', 'MimeTypeArray', 'NamedNodeMap', 'PaintRequestList', 'Plugin', 'PluginArray', 'SVGLengthList', 'SVGNumberList', 'SVGPathSegList', 'SVGPointList', 'SVGStringList', 'SVGTransformList', 'SourceBufferList', 'TextTrackCueList', 'TextTrackList', 'TouchList']).length; i$ < len$; ++i$) {
      y$ = ref$[i$];
      Collection = global[y$];
      if (Collection) {
        assert.same(Collection.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.toStringTag : void 8], y$, y$ + "::@@toStringTag is '" + y$ + "'");
        assert.isFunction(Collection.prototype[typeof Symbol != 'undefined' && Symbol !== null ? Symbol.iterator : void 8], y$ + "::@@iterator is function");
        absent = false;
      }
    }
    if ((typeof NodeList != 'undefined' && NodeList !== null) && ((typeof document != 'undefined' && document !== null) && document.querySelectorAll) && document.querySelectorAll('div') instanceof NodeList) {
      assert.isFunction(document.querySelectorAll('div')[Symbol.iterator], 'works with document.querySelectorAll');
    }
    if (absent) {
      return assert.ok(true, 'DOM collections are absent');
    }
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, isFunction, timeLimitedPromise, toString$ = {}.toString;
  module = QUnit.module, test = QUnit.test;
  module('Web');
  isFunction = function(it){
    return toString$.call(it).slice(8, -1) === 'Function';
  };
  timeLimitedPromise = function(time, fn){
    return Promise.race([
      new Promise(fn), new Promise(function(res, rej){
        setTimeout(rej, time);
      })
    ]);
  };
  test('setImmediate / clearImmediate', function(assert){
    var def;
    assert.expect(10);
    assert.ok(isFunction(setImmediate), 'setImmediate is function');
    assert.ok(isFunction(clearImmediate), 'clearImmediate is function');
    assert.ok(/native code/.test(setImmediate), 'setImmediate looks like native');
    assert.ok(/native code/.test(clearImmediate), 'clearImmediate looks like native');
    assert.strictEqual(setImmediate.name, 'setImmediate', 'setImmediate.name is "setImmediate"');
    assert.strictEqual(clearImmediate.name, 'clearImmediate', 'clearImmediate.name is "clearImmediate"');
    timeLimitedPromise(1e3, function(res){
      setImmediate(function(){
        def = 'a';
        res();
      });
    }).then(function(){
      assert.ok(true, 'setImmediate works');
    })['catch'](function(){
      assert.ok(false, 'setImmediate works');
    }).then(assert.async());
    assert.strictEqual(def, void 8, 'setImmediate is async');
    timeLimitedPromise(1e3, function(res){
      return setImmediate(function(a, b){
        return res(a + b);
      }, 'a', 'b');
    }).then(function(it){
      assert.strictEqual(it, 'ab', 'setImmediate works with additional args');
    })['catch'](function(){
      assert.ok(false, 'setImmediate works with additional args');
    }).then(assert.async());
    return timeLimitedPromise(50, function(res){
      return clearImmediate(setImmediate(res));
    }).then(function(){
      assert.ok(false, 'clearImmediate works');
    })['catch'](function(){
      assert.ok(true, 'clearImmediate works');
    }).then(assert.async());
  });
  (function(it){
    if (typeof window != 'undefined' && window !== null) {
      window.onload = it;
    } else {
      it();
    }
  })(function(){
    setTimeout(function(){
      var x, now, inc;
      x = 0;
      now = Date.now();
      (inc = function(){
        setImmediate(function(){
          x = x + 1;
          if (Date.now() - now < 5e3) {
            inc();
          } else {
            if (typeof console != 'undefined' && console !== null) {
              console.log("setImmediate: " + x / 5 + " per second");
            }
          }
        });
      })();
    }, 5e3);
  });
}).call(this);

// Generated by LiveScript 1.4.0
(function(){
  var module, test, timeLimitedPromise, global;
  module = QUnit.module, test = QUnit.test;
  module('Web');
  timeLimitedPromise = function(time, fn){
    return Promise.race([
      new Promise(fn), new Promise(function(res, rej){
        setTimeout(rej, time);
      })
    ]);
  };
  global = Function('return this')();
  test('setTimeout / clearTimeout', function(assert){
    assert.expect(2);
    timeLimitedPromise(1e3, function(res){
      global.setTimeout(function(a, b){
        res(a + b);
      }, 10, 'a', 'b');
    }).then(function(it){
      assert.strictEqual(it, 'ab', 'setTimeout works with additional args');
    })['catch'](function(){
      assert.ok(false, 'setTimeout works with additional args');
    }).then(assert.async());
    timeLimitedPromise(50, function(res){
      clearTimeout(setTimeout(res, 10));
    }).then(function(){
      assert.ok(false, 'clearImmediate works with wraped setTimeout');
    })['catch'](function(){
      assert.ok(true, 'clearImmediate works with wraped setTimeout');
    }).then(assert.async());
  });
  test('setInterval / clearInterval', function(assert){
    var i;
    assert.expect(1);
    i = 0;
    timeLimitedPromise(1e4, function(res, rej){
      var interval;
      interval = global.setInterval(function(a, b){
        if (a + b !== 'ab' || i > 2) {
          rej({
            a: a,
            b: b,
            i: i
          });
        }
        if (i++ === 2) {
          global.clearInterval(interval);
          return global.setTimeout(res, 30);
        }
      }, 5, 'a', 'b');
    }).then(function(){
      assert.ok(true, 'setInterval & clearInterval works with additional args');
    })['catch'](function(arg$){
      var ref$, a, b, i;
      ref$ = arg$ != null
        ? arg$
        : {}, a = ref$.a, b = ref$.b, i = ref$.i;
      assert.ok(false, "setInterval & clearInterval works with additional args: " + a + ", " + b + ", times: " + i);
    }).then(assert.async());
  });
}).call(this);
