/* $Id: DocSum.cpp 416593 2013-10-29 18:09:10Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'esummary.dtd'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objtools/eutils/esummary/DocSum.hpp>

// generated classes

BEGIN_esummary_SCOPE // namespace esummary::

// destructor
CDocSum::~CDocSum(void)
{
}

const string& CDocSum::FindValue(const string& key) const
{
    const TItem& items = GetItem();
    ITERATE(TItem, it, items) {
        const CItem& item = **it;
        if (item.GetName() == key) {
            return item.GetValue();
        }
    }
    return kEmptyStr;
}


const CItem* CDocSum::FindItem(const string& key) const
{
    const TItem& items = GetItem();
    ITERATE(TItem, it, items) {
        const CItem& item = **it;
        if (item.GetName() == key) {
            return &item;
        }
    }
    return NULL;
}


END_esummary_SCOPE // namespace esummary::

/* Original file checksum: lines: 53, chars: 1687, CRC32: 2b393a75 */
