/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
package ui;

import gestionnaires.Afficheur;
/**
 * Classe d'affichage des messages des Gestionnaires d'erreur en mode console
 * @author bruno
 *
 */
public class AfficheurConsole implements Afficheur
{
	/**
	 * Implémentation de gestionnaires.Afficheur#afficheMessage(java.lang.String)
	 * <p>Affiche les message sur la sortie d'erreur de la console (System.err)</p>
	 * @see gestionnaires.Afficheur#afficheMessage(java.lang.String)
	 */
	public void afficheMessage(String message)
	{
		System.err.println(message);	
	}

}
