/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

// Servlet-related
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * This class shows how a Servlet can be written to handle Xml-Rpc
 * requests.  Copy this source code into your own project and register
 * handlers.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class ServletTest
	extends HttpServlet
	implements XmlRpcHandler
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 972350369680613449L;
	XmlRpcServer server;
	
	/**
	 * Use this method to register handlers with the XmlRpcServer.
	 */
	public void init(ServletConfig config)
		throws ServletException
	{
		server = new XmlRpcServerImpl();
		server.addHandler("test", this);
		super.init(config);
	}

	public static ParamIterator makeLongParamIterator(final int until) {
		return new ParamIterator() {
			int times = 0;
			public Object next() 
			{
				times++;
				if (times % 2 == 0)
					return " AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA ";
				else
					return new Integer(1);
			}
			public boolean hasNext() {
				return times < until;
			}
			public int getIteratorType() {
				return PARAMS_ITERATOR;
			}
			public void close() {
			}
		};
	}

	/** 
	 * This method adds numbers together, then returns a list of more
	 * numbers to add, as an example.
	 */
	public ParamIterator execute(String method, ParamIterator params) 
		throws XmlRpcException
	{
		int total = 0;
		int last = 0;
		Integer i;
		Vector v = new Vector();
		while (params.hasNext()) {
			Object o = params.next();
			if (o instanceof Integer) {
				i = (Integer)o;
				last = i.intValue();
				total += i.intValue();
			} 
		}
		v.add("Total of Integers was:  " + total);
		return makeLongParamIterator(last);
	}

	/** This method shows the server is available. */
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) 
		throws ServletException, IOException
	{
		PrintWriter writer = resp.getWriter();
		writer.println("XmlRpcServer " + server);
	}

	/** This method calls the Xml-Rpc server. */
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) 
		throws ServletException, IOException
	{
		/*
		Enumeration enum = req.getHeaderNames();
		while (enum.hasMoreElements()) {
			String s = (String)enum.nextElement();
			System.out.println(s + ": " + req.getHeader(s));
		}
		*/
		try {
			server.accept(req.getReader(), resp.getWriter());
		} catch (XmlRpcException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
