/*
 * Copyright (c) 2009-2020, Peter Abeles. All Rights Reserved.
 *
 * This file is part of Efficient Java Matrix Library (EJML).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ejml.equation;

/**
 * Instance of a variable created at compile time.  This base class only specifies the type of variable which it is.
 *
 * @author Peter Abeles
 */
public class Variable {
    public VariableType type;

    protected Variable( VariableType type ) {
        this.type = type;
    }

    public VariableType getType() {
        return type;
    }

    @Override
    public String toString() {
        return "VAR_" + type;
    }
}
