/***************************************************************************
                          vec2d.h  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VEC2D_H
#define VEC2D_H
#include <gtk/gtk.h>
#include <math.h>

class Point2D;

/**
  *@author Brian Ashe & Jacques Fortier
  */

class Vec2D {
public: 
	double   dx, dy;

	Vec2D(){
		dx = dy = 0;
	}

	Vec2D (double dx, double dy);
	Vec2D (const Point2D &p1, const Point2D &p2);
	Vec2D (const Vec2D &v);
	double mag ();
	Vec2D addVec (const Vec2D vec);
	Vec2D subVec (const Vec2D vec);
	Vec2D unitVec ();
	Vec2D mulVec (double scale);
	double dotProd (Vec2D vec2);
	Vec2D setVec (double dx, double dy);
	Vec2D setVec (const Vec2D &vec);
	Vec2D copy ();
	~Vec2D();
};

#endif
