---
title: Staticcheck 2020.2 release notes
linkTitle: "2020.2 (v0.1.0)"
weight: -5
---

## Performance improvements {#performance-improvements}

The primary focus of this release is a major improvement in performance, significantly reducing memory usage while also reducing runtimes.

<table class="table">
    <caption>Uncached, GOMAXPROCS=1</caption>
    <thead>
      <tr>
        <th>Package</th>
        <th>2020.1.6</th>
        <th>2020.2</th>
        <th>Delta</th>
        <th>Stats</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>2.41s ±19% </td>
        <td>2.00s ±14% </td>
        <td>-17.08%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
     <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>276s ± 1% </td>
        <td>219s ± 1% </td>
        <td>-20.62%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>6.18s ± 1% </td>
        <td>5.61s ± 5% </td>
        <td>-9.21%</td>
        <td>p=0.000, n=8+10</td>
      </tr>
      <tr>
        <td>std </td>
        <td>49.5s ± 1% </td>
        <td>42.5s ± 1% </td>
        <td>-14.04%</td>
        <td>p=0.000, n=9+10</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>2.49s ± 9% </td>
        <td>2.19s ±12% </td>
        <td>-12.08%</td>
        <td>p=0.001, n=10+10</td>
      </tr>
    </tbody>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>167MB ±26% </td>
        <td>146MB ±19% </td>
        <td>-12.62%</td>
        <td>p=0.043, n=10+10</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>2.14GB ± 1% </td>
        <td>0.45GB ±13% </td>
        <td>-79.09%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>216MB ± 6% </td>
        <td>166MB ±18% </td>
        <td>-23.11%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>std </td>
        <td>972MB ± 3% </td>
        <td>284MB ± 9% </td>
        <td>-70.82%</td>
        <td>p=0.000, n=8+10</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>155MB ±21% </td>
        <td>139MB ±29% </td>
        <td>~</td>
        <td>p=0.063, n=10+10</td>
      </tr>
    </tbody>
</table>

<table class="table">
    <caption>Cached, GOMAXPROCS=1</caption>
    <thead>
      <tr>
        <th>Package</th>
        <th>2020.1.6</th>
        <th>2020.2</th>
        <th>Delta</th>
        <th>Stats</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>160ms ± 0% </td>
        <td>107ms ± 7% </td>
        <td>-33.13%</td>
        <td>p=0.000, n=8+10</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>12.7s ± 1% </td>
        <td>6.9s ± 1% </td>
        <td>-45.26%</td>
        <td>p=0.000, n=9+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>370ms ± 0% </td>
        <td>230ms ± 0% </td>
        <td>-37.84%</td>
        <td>p=0.000, n=8+8</td>
      </tr>
      <tr>
        <td>std </td>
        <td>2.52s ± 1% </td>
        <td>1.31s ± 1% </td>
        <td>-48.13%</td>
        <td>p=0.000, n=10+9</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>164ms ± 4% </td>
        <td>110ms ± 0% </td>
        <td>-32.93%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
    </tbody>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>38.6MB ± 4% </td>
        <td>20.8MB ± 1% </td>
        <td>-45.96%</td>
        <td>p=0.000, n=9+10</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>863MB ± 4% </td>
        <td>283MB ± 2% </td>
        <td>-67.28%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>70.5MB ± 5% </td>
        <td>25.8MB ± 2% </td>
        <td>-63.48%</td>
        <td>p=0.000, n=10+9</td>
      </tr>
      <tr>
        <td>std </td>
        <td>243MB ±16% </td>
        <td>73MB ± 8% </td>
        <td>-70.00%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>37.2MB ± 2% </td>
        <td>21.3MB ± 1% </td>
        <td>-42.76%</td>
        <td>p=0.000, n=9+10</td>
      </tr>
    </tbody>
</table>

<table class="table">
    <caption>Uncached, GOMAXPROCS=32</caption>
    <thead>
      <tr>
        <th>Package</th>
        <th>2020.1.6</th>
        <th>2020.2</th>
        <th>Delta</th>
        <th>Stats</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>1.19s ±21% </td>
        <td>1.06s ±12% </td>
        <td>~</td>
        <td>p=0.115, n=10+8</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>27.0s ± 2% </td>
        <td>22.4s ± 2% </td>
        <td>-16.96%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>2.24s ±11% </td>
        <td>2.23s ±10% </td>
        <td>~</td>
        <td>p=0.870, n=10+10</td>
      </tr>
      <tr>
        <td>std </td>
        <td>7.14s ± 5% </td>
        <td>5.10s ± 9% </td>
        <td>-28.56%</td>
        <td>p=0.000, n=10+9</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>1.24s ±26% </td>
        <td>1.18s ±21% </td>
        <td>~</td>
        <td>p=0.753, n=10+10</td>
      </tr>
    </tbody>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>143MB ± 7% </td>
        <td>141MB ± 6% </td>
        <td>~</td>
        <td>p=0.515, n=8+10</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>5.77GB ± 6% </td>
        <td>2.76GB ± 4% </td>
        <td>-52.25%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>284MB ±10% </td>
        <td>226MB ±14% </td>
        <td>-20.38%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>std </td>
        <td>1.74GB ±10% </td>
        <td>1.15GB ±14% </td>
        <td>-34.11%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>148MB ±18% </td>
        <td>144MB ±16% </td>
        <td>~</td>
        <td>p=0.579, n=10+10</td>
      </tr>
    </tbody>
</table>


<table class="table">
    <caption>Cached, GOMAXPROCS=32</caption>
    <thead>
      <tr>
        <th>Package</th>
        <th>2020.1.6</th>
        <th>2020.2</th>
        <th>Delta</th>
        <th>Stats</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>96.0ms ± 6% </td>
        <td>80.0ms ± 0% </td>
        <td>-16.67%</td>
        <td>p=0.000, n=10+9</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>4.64s ± 1% </td>
        <td>3.88s ± 0% </td>
        <td>-16.22%</td>
        <td>p=0.000, n=9+8</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>216ms ± 3% </td>
        <td>167ms ± 4% </td>
        <td>-22.69%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>std </td>
        <td>1.09s ± 2% </td>
        <td>0.96s ± 2% </td>
        <td>-12.20%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>100ms ± 0% </td>
        <td>87ms ± 8% </td>
        <td>-13.00%</td>
        <td>p=0.000, n=9+10</td>
      </tr>
    </tbody>
    <tbody>
      <tr>
        <td>image/color </td>
        <td>46.4MB ± 3% </td>
        <td>24.1MB ± 5% </td>
        <td>-48.08%</td>
        <td>p=0.000, n=8+10</td>
      </tr>
      <tr>
        <td>k8s.io/kubernetes/pkg/... </td>
        <td>1.38GB ± 9% </td>
        <td>0.27GB ± 1% </td>
        <td>-80.29%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>net/http </td>
        <td>80.7MB ±12% </td>
        <td>31.4MB ± 2% </td>
        <td>-61.16%</td>
        <td>p=0.000, n=10+8</td>
      </tr>
      <tr>
        <td>std </td>
        <td>363MB ±12% </td>
        <td>75MB ± 7% </td>
        <td>-79.30%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
      <tr>
        <td>strconv </td>
        <td>48.5MB ± 6% </td>
        <td>24.4MB ± 3% </td>
        <td>-49.72%</td>
        <td>p=0.000, n=10+10</td>
      </tr>
    </tbody>
</table>


See commit [5cfc85b70e7b778eb76fd7338e538d7c9af21e4e](https://github.com/dominikh/go-tools/commit/5cfc85b70e7b778eb76fd7338e538d7c9af21e4e)
for details on how these improvements have been achieved.

Furthermore, Staticcheck 2020.2 will skip very large packages (currently packages that are 50 MiB or larger),
under the assumption that these packages contain bundled assets and aren't worth analyzing.
This might further reduce Staticcheck's memory usage in your projects.

## Changes to the detection of unused code {#unused}

### Removal of whole-program mode and changes to the handling of exported identifiers {#unused-whole-program}

The [aforementioned performance improvements](#performance-improvements) necessitate some changes to the _U1000_ check (also known as _unused_).

The most visible change is the removal of the _whole program_ mode.
This mode, which analyzed an entire program and reported unused code even if it is exported,
did not work well with the kind of caching that we use in Staticcheck.
Even in previous versions, it didn't always work correctly and may have caused flaky results,
depending on the state of the cache and the order of `staticcheck` invocations.

The whole-program mode may be revived in the future as a standalone tool,
with the understanding that this mode of operation is inherently more expensive than `staticcheck`.
In the meantime, if you depend on this functionality and can tolerate its bugs, you should continue using Staticcheck 2020.1.

As part of improving the correctness of U1000, changes were made to the normal mode as well.
In particular, **all** exported package-level identifiers will be considered used from now on,
even if these identifiers are declared in `package main` or tests, even if they are otherwise unused.
Exported identifiers in `package main` can be used in ways invisible to us, for example via the `plugin` build mode.
For tests, we would run into the same kind of issues as we did with the whole program mode.

### Improvements {#unused-improvements}

The `//lint:ignore` directive now works more intelligently with the U1000 check.
In previous versions, the directive would only suppress the output of a diagnostic. For example, for the following example

```go
package pkg

//lint:ignore U1000 This is fine.
func fn1() { fn2() }

func fn2() {}
```

Staticcheck would emit the following output:

```text
foo.go:6:6: func fn2 is unused (U1000)
```

as it would only suppress the diagnostic for `fn1`.

Beginning with this release, the directive instead actively marks the identifier as used,
which means that any transitively used code will also be considered used, and no diagnostic will be reported for `fn2`.
Similarly, the `//lint:file-ignore` directive will consider everything in a file used, which may transitively mark code in other files used, too.

## UI improvements {#ui-improvements}

We've made some minor improvements to the output and behavior of the `staticcheck` command:

- the command now prints instructions on how to look up documentation for checks
- output of the `-explain` flag includes a link to the online documentation
- a warning is emitted when a package pattern matches no packages
- unmatched ignore directives cause `staticcheck` to exit with a non-zero status code

## Changes to versioning scheme {#versioning-improvements}

Staticcheck releases have two version numbers: one meant for human consumption and one meant for consumption by machines, via Go modules.
For example, the previous release was both `2020.1.6` (for humans) and `v0.0.1-2020.1.6` (for machines).

In previous releases, we've tried to include the human version in the machine version, by using the `v0.0.1-<human version>` scheme.
However, this scheme had various drawbacks.
For this and future releases we've switched to a more standard scheme for machine versions: `v0.<minor>.<patch>`.
Minor will increase by one for every feature release of Staticcheck,
and patch will increase by one for every bugfix release of Staticcheck,
resetting to zero on feature releases.

For example, this release is both `2020.2` and `v0.1.0`.
A hypothetical `2020.2.1` would be `v0.1.1`, and `2021.1` will be `v0.2.0`.
This new versioning scheme fixes various issues when trying to use Staticcheck as a Go module.
It will also allow us to make true pre-releases in the future.

Documentation on the website, as well as the output of `staticcheck -version`, will include both version numbers, to make it easier to associate the two.

For detailed information on how we arrived at this decision, see the discussion on [issue 777]({{< issueref 777 >}}).

## Checks {#checks}
### New checks {#checks-new}

The following new checks have been added:

- {{< check "SA4023" >}} flags impossible comparisons of interface values with untyped nils
- {{< check "SA5012" >}} flags function calls with slice arguments that aren't the right length
- {{< check "SA9006" >}} flags dubious bit shifts of fixed size integers

### Changed checks {#checks-changed}

Several checks have been improved:

- {{< check "S1030"  >}} no longer recommends replacing `m[string(buf.Bytes())]` with `m[buf.String()]`, as the former gets optimized by the compiler
- {{< check "S1008"  >}} no longer incorrectly suggests that the negation of `>=` is `<=`
- {{< check "S1029"  >}} and {{ check "SA6003" }} now also check custom types with underlying type `string`
- {{< check "SA1019" >}} now recognizes deprecation notices that aren't in the last paragraph of a comment
- {{< check "SA1019" >}} now emits more precise diagnostics for deprecated code in the standard library
- {{< check "SA4006" >}} no longer flags assignments where the value is a typed nil
- {{< check "SA5011" >}} is now able to detect more functions that never return, thus reducing the number of false positives
- {{< check "SA9004" >}} no longer assumes that constants belong to the same group when they have different types
- Automatic fixes for {{< check "SA9004" >}} inside gopls no longer incorrectly duplicate comments
- {{< check "ST1003" >}} no longer complains about ALL_CAPS in variable names that don't contain any letters
- Incorrect position information in various checks have been fixed
- Crashes in various checks have been fixed

## Staticcheck 2020.2.1 release notes {#2020.2.1}

This release eliminates some false negatives as well as false positives, makes the `staticcheck` command less noisy and fixes a potential security issue.

- {{< check "SA4020" >}} no longer claims that `case nil` is an unreachable case in a type switch.
- {{< check "S1025"  >}} no longer marks uses of `Printf` as unnecessary when the printed types implement the `fmt.Formatter` interface.
- Various checks may now detect bugs in conditional code that were previously missed. This was a regression introduced in Staticcheck 2020.1.
- The `staticcheck` command no longer reminds the user of the `-explain` flag every time problems are found. This was deemed too noisy.
- We've updated our dependency on `golang.org/x/tools` to guard against arbitrary code execution on Windows.
  Note that to be fully safe, you will also have to update your installation of Go.
  See the [Command PATH security in Go](https://blog.golang.org/path-security) article by the Go authors for more information on this potential vulnerability.

## Staticcheck 2020.2.2 release notes {#2020.2.2}

This release fixes a rare crash in Staticcheck, reduces the number of false positives, and adds support for Go 1.16's `io/fs.FileMode` type.

- {{< check "SA9002" >}} now supports the new `io/fs.FileMode` type in addition to `os.FileMode`.
- Various checks no longer crash when analyzing nested function calls involving multiple return values.
- {{< check "SA1006" >}} no longer flags `Printf` calls of the form `Printf(fn())` when `fn` has multiple return values.
- Staticcheck now understands the effects of `github.com/golang/glog` on a function's control flow.

## Staticcheck 2020.2.3 release notes {#2020.2.3}

This release fixes a false positive in U1000. See [issue 942]({{< issueref 942 >}}) for an example.

## Staticcheck 2020.2.4 release notes {#2020.2.4}

This release fixes the following issues:

- A false positive in {{< check "S1017" >}} when the `len` function has been shadowed
- A bug in Staticcheck's intermediate representation
  that would lead to nonsensical reports claiming that a value isn't being used
  when it is definitely being used
  (see issues [949]({{< issueref 949 >}}) and [981]({{< issueref 981 >}}) for more information)
- A rare crash (see issue [972]({{< issueref 972 >}}) for more information)
