package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GlobalClient is the webSite Management Client
type GlobalClient struct {
	BaseClient
}

// NewGlobalClient creates an instance of the GlobalClient client.
func NewGlobalClient(subscriptionID string) GlobalClient {
	return NewGlobalClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGlobalClientWithBaseURI creates an instance of the GlobalClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewGlobalClientWithBaseURI(baseURI string, subscriptionID string) GlobalClient {
	return GlobalClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetDeletedWebApp description for Get deleted app for a subscription.
// Parameters:
// deletedSiteID - the numeric ID of the deleted app, e.g. 12345
func (client GlobalClient) GetDeletedWebApp(ctx context.Context, deletedSiteID string) (result DeletedSite, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetDeletedWebApp")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDeletedWebAppPreparer(ctx, deletedSiteID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetDeletedWebApp", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeletedWebAppSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetDeletedWebApp", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeletedWebAppResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetDeletedWebApp", resp, "Failure responding to request")
		return
	}

	return
}

// GetDeletedWebAppPreparer prepares the GetDeletedWebApp request.
func (client GlobalClient) GetDeletedWebAppPreparer(ctx context.Context, deletedSiteID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deletedSiteId":  autorest.Encode("path", deletedSiteID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeletedWebAppSender sends the GetDeletedWebApp request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetDeletedWebAppSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeletedWebAppResponder handles the response to the GetDeletedWebApp request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetDeletedWebAppResponder(resp *http.Response) (result DeletedSite, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeletedWebAppSnapshots description for Get all deleted apps for a subscription.
// Parameters:
// deletedSiteID - the numeric ID of the deleted app, e.g. 12345
func (client GlobalClient) GetDeletedWebAppSnapshots(ctx context.Context, deletedSiteID string) (result ListSnapshot, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetDeletedWebAppSnapshots")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDeletedWebAppSnapshotsPreparer(ctx, deletedSiteID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetDeletedWebAppSnapshots", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeletedWebAppSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetDeletedWebAppSnapshots", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeletedWebAppSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetDeletedWebAppSnapshots", resp, "Failure responding to request")
		return
	}

	return
}

// GetDeletedWebAppSnapshotsPreparer prepares the GetDeletedWebAppSnapshots request.
func (client GlobalClient) GetDeletedWebAppSnapshotsPreparer(ctx context.Context, deletedSiteID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deletedSiteId":  autorest.Encode("path", deletedSiteID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeletedWebAppSnapshotsSender sends the GetDeletedWebAppSnapshots request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetDeletedWebAppSnapshotsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeletedWebAppSnapshotsResponder handles the response to the GetDeletedWebAppSnapshots request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetDeletedWebAppSnapshotsResponder(resp *http.Response) (result ListSnapshot, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSubscriptionOperationWithAsyncResponse description for Gets an operation in a subscription and given region
// Parameters:
// location - location name
// operationID - operation Id
func (client GlobalClient) GetSubscriptionOperationWithAsyncResponse(ctx context.Context, location string, operationID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalClient.GetSubscriptionOperationWithAsyncResponse")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSubscriptionOperationWithAsyncResponsePreparer(ctx, location, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionOperationWithAsyncResponse", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSubscriptionOperationWithAsyncResponseSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionOperationWithAsyncResponse", resp, "Failure sending request")
		return
	}

	result, err = client.GetSubscriptionOperationWithAsyncResponseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.GlobalClient", "GetSubscriptionOperationWithAsyncResponse", resp, "Failure responding to request")
		return
	}

	return
}

// GetSubscriptionOperationWithAsyncResponsePreparer prepares the GetSubscriptionOperationWithAsyncResponse request.
func (client GlobalClient) GetSubscriptionOperationWithAsyncResponsePreparer(ctx context.Context, location string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"operationId":    autorest.Encode("path", operationID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/operations/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSubscriptionOperationWithAsyncResponseSender sends the GetSubscriptionOperationWithAsyncResponse request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalClient) GetSubscriptionOperationWithAsyncResponseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSubscriptionOperationWithAsyncResponseResponder handles the response to the GetSubscriptionOperationWithAsyncResponse request. The method always
// closes the http.Response Body.
func (client GlobalClient) GetSubscriptionOperationWithAsyncResponseResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
