package features

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2021-07-01/features"

// AuthorizationProfile authorization Profile
type AuthorizationProfile struct {
	// RequestedTime - READ-ONLY; The requested time
	RequestedTime *date.Time `json:"requestedTime,omitempty"`
	// Requester - READ-ONLY; The requester
	Requester *string `json:"requester,omitempty"`
	// RequesterObjectID - READ-ONLY; The requester object id
	RequesterObjectID *string `json:"requesterObjectId,omitempty"`
	// ApprovedTime - READ-ONLY; The approved time
	ApprovedTime *date.Time `json:"approvedTime,omitempty"`
	// Approver - READ-ONLY; The approver
	Approver *string `json:"approver,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationProfile.
func (ap AuthorizationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDefinition error definition.
type ErrorDefinition struct {
	// Code - READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty"`
	// Details - Internal error details.
	Details *[]ErrorDefinition `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDefinition.
func (ed ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ed.Details != nil {
		objectMap["details"] = ed.Details
	}
	return json.Marshal(objectMap)
}

// ErrorResponse error response indicates that the service is not able to process the incoming request.
type ErrorResponse struct {
	// Error - The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// Operation microsoft.Features operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Features
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Microsoft.Features operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Microsoft.Features operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationsListResult list of previewed features.
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of features.
	Value *[]Result `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListResultIterator provides access to a complete listing of Result values.
type OperationsListResultIterator struct {
	i    int
	page OperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListResultIterator) Response() OperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListResultIterator) Value() Result {
	if !iter.page.NotDone() {
		return Result{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListResultIterator type.
func NewOperationsListResultIterator(page OperationsListResultPage) OperationsListResultIterator {
	return OperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationsListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationsListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationsListResult) operationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationsListResultPage contains a page of Result values.
type OperationsListResultPage struct {
	fn  func(context.Context, OperationsListResult) (OperationsListResult, error)
	olr OperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListResultPage) Response() OperationsListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListResultPage) Values() []Result {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationsListResultPage type.
func NewOperationsListResultPage(cur OperationsListResult, getNextPage func(context.Context, OperationsListResult) (OperationsListResult, error)) OperationsListResultPage {
	return OperationsListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Properties information about feature.
type Properties struct {
	// State - The registration state of the feature for the subscription.
	State *string `json:"state,omitempty"`
}

// ProxyResource an Azure proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Azure resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Result previewed feature information.
type Result struct {
	autorest.Response `json:"-"`
	// Name - The name of the feature.
	Name *string `json:"name,omitempty"`
	// Properties - Properties of the previewed feature.
	Properties *Properties `json:"properties,omitempty"`
	// ID - The resource ID of the feature.
	ID *string `json:"id,omitempty"`
	// Type - The resource type of the feature.
	Type *string `json:"type,omitempty"`
}

// SubscriptionFeatureRegistration subscription feature registration details
type SubscriptionFeatureRegistration struct {
	autorest.Response `json:"-"`
	Properties        *SubscriptionFeatureRegistrationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionFeatureRegistration.
func (sfr SubscriptionFeatureRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfr.Properties != nil {
		objectMap["properties"] = sfr.Properties
	}
	return json.Marshal(objectMap)
}

// SubscriptionFeatureRegistrationList the list of subscription feature registrations.
type SubscriptionFeatureRegistrationList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of subscription feature registrations list.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of subscription feature registrations.
	Value *[]SubscriptionFeatureRegistration `json:"value,omitempty"`
}

// SubscriptionFeatureRegistrationListIterator provides access to a complete listing of
// SubscriptionFeatureRegistration values.
type SubscriptionFeatureRegistrationListIterator struct {
	i    int
	page SubscriptionFeatureRegistrationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionFeatureRegistrationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionFeatureRegistrationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionFeatureRegistrationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionFeatureRegistrationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionFeatureRegistrationListIterator) Response() SubscriptionFeatureRegistrationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionFeatureRegistrationListIterator) Value() SubscriptionFeatureRegistration {
	if !iter.page.NotDone() {
		return SubscriptionFeatureRegistration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionFeatureRegistrationListIterator type.
func NewSubscriptionFeatureRegistrationListIterator(page SubscriptionFeatureRegistrationListPage) SubscriptionFeatureRegistrationListIterator {
	return SubscriptionFeatureRegistrationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sfrl SubscriptionFeatureRegistrationList) IsEmpty() bool {
	return sfrl.Value == nil || len(*sfrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sfrl SubscriptionFeatureRegistrationList) hasNextLink() bool {
	return sfrl.NextLink != nil && len(*sfrl.NextLink) != 0
}

// subscriptionFeatureRegistrationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sfrl SubscriptionFeatureRegistrationList) subscriptionFeatureRegistrationListPreparer(ctx context.Context) (*http.Request, error) {
	if !sfrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sfrl.NextLink)))
}

// SubscriptionFeatureRegistrationListPage contains a page of SubscriptionFeatureRegistration values.
type SubscriptionFeatureRegistrationListPage struct {
	fn   func(context.Context, SubscriptionFeatureRegistrationList) (SubscriptionFeatureRegistrationList, error)
	sfrl SubscriptionFeatureRegistrationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionFeatureRegistrationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionFeatureRegistrationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sfrl)
		if err != nil {
			return err
		}
		page.sfrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionFeatureRegistrationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionFeatureRegistrationListPage) NotDone() bool {
	return !page.sfrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionFeatureRegistrationListPage) Response() SubscriptionFeatureRegistrationList {
	return page.sfrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionFeatureRegistrationListPage) Values() []SubscriptionFeatureRegistration {
	if page.sfrl.IsEmpty() {
		return nil
	}
	return *page.sfrl.Value
}

// Creates a new instance of the SubscriptionFeatureRegistrationListPage type.
func NewSubscriptionFeatureRegistrationListPage(cur SubscriptionFeatureRegistrationList, getNextPage func(context.Context, SubscriptionFeatureRegistrationList) (SubscriptionFeatureRegistrationList, error)) SubscriptionFeatureRegistrationListPage {
	return SubscriptionFeatureRegistrationListPage{
		fn:   getNextPage,
		sfrl: cur,
	}
}

// SubscriptionFeatureRegistrationProperties ...
type SubscriptionFeatureRegistrationProperties struct {
	// TenantID - READ-ONLY; The tenantId.
	TenantID *string `json:"tenantId,omitempty"`
	// SubscriptionID - READ-ONLY; The subscriptionId.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// FeatureName - READ-ONLY; The featureName.
	FeatureName *string `json:"featureName,omitempty"`
	// DisplayName - READ-ONLY; The featureDisplayName.
	DisplayName *string `json:"displayName,omitempty"`
	// ProviderNamespace - READ-ONLY; The providerNamespace.
	ProviderNamespace *string `json:"providerNamespace,omitempty"`
	// State - The state. Possible values include: 'SubscriptionFeatureRegistrationStateNotSpecified', 'SubscriptionFeatureRegistrationStateNotRegistered', 'SubscriptionFeatureRegistrationStatePending', 'SubscriptionFeatureRegistrationStateRegistering', 'SubscriptionFeatureRegistrationStateRegistered', 'SubscriptionFeatureRegistrationStateUnregistering', 'SubscriptionFeatureRegistrationStateUnregistered'
	State                SubscriptionFeatureRegistrationState `json:"state,omitempty"`
	AuthorizationProfile *AuthorizationProfile                `json:"authorizationProfile,omitempty"`
	// Metadata - Key-value pairs for meta data.
	Metadata map[string]*string `json:"metadata"`
	// ReleaseDate - READ-ONLY; The feature release date.
	ReleaseDate *date.Time `json:"releaseDate,omitempty"`
	// RegistrationDate - READ-ONLY; The feature registration date.
	RegistrationDate *date.Time `json:"registrationDate,omitempty"`
	// DocumentationLink - READ-ONLY; The feature documentation link.
	DocumentationLink *string `json:"documentationLink,omitempty"`
	// ApprovalType - READ-ONLY; The feature approval type. Possible values include: 'SubscriptionFeatureRegistrationApprovalTypeNotSpecified', 'SubscriptionFeatureRegistrationApprovalTypeApprovalRequired', 'SubscriptionFeatureRegistrationApprovalTypeAutoApproval'
	ApprovalType SubscriptionFeatureRegistrationApprovalType `json:"approvalType,omitempty"`
	// ShouldFeatureDisplayInPortal - Indicates whether feature should be displayed in Portal.
	ShouldFeatureDisplayInPortal *bool `json:"shouldFeatureDisplayInPortal,omitempty"`
	// Description - The feature description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionFeatureRegistrationProperties.
func (sfr SubscriptionFeatureRegistrationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfr.State != "" {
		objectMap["state"] = sfr.State
	}
	if sfr.AuthorizationProfile != nil {
		objectMap["authorizationProfile"] = sfr.AuthorizationProfile
	}
	if sfr.Metadata != nil {
		objectMap["metadata"] = sfr.Metadata
	}
	if sfr.ShouldFeatureDisplayInPortal != nil {
		objectMap["shouldFeatureDisplayInPortal"] = sfr.ShouldFeatureDisplayInPortal
	}
	if sfr.Description != nil {
		objectMap["description"] = sfr.Description
	}
	return json.Marshal(objectMap)
}
