package recoveryservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthType enumerates the values for auth type.
type AuthType string

const (
	// AuthTypeAAD ...
	AuthTypeAAD AuthType = "AAD"
	// AuthTypeAccessControlService ...
	AuthTypeAccessControlService AuthType = "AccessControlService"
	// AuthTypeACS ...
	AuthTypeACS AuthType = "ACS"
	// AuthTypeAzureActiveDirectory ...
	AuthTypeAzureActiveDirectory AuthType = "AzureActiveDirectory"
	// AuthTypeInvalid ...
	AuthTypeInvalid AuthType = "Invalid"
)

// PossibleAuthTypeValues returns an array of possible values for the AuthType const type.
func PossibleAuthTypeValues() []AuthType {
	return []AuthType{AuthTypeAAD, AuthTypeAccessControlService, AuthTypeACS, AuthTypeAzureActiveDirectory, AuthTypeInvalid}
}

// AuthTypeBasicResourceCertificateDetails enumerates the values for auth type basic resource certificate
// details.
type AuthTypeBasicResourceCertificateDetails string

const (
	// AuthTypeBasicResourceCertificateDetailsAuthTypeAccessControlService ...
	AuthTypeBasicResourceCertificateDetailsAuthTypeAccessControlService AuthTypeBasicResourceCertificateDetails = "AccessControlService"
	// AuthTypeBasicResourceCertificateDetailsAuthTypeAzureActiveDirectory ...
	AuthTypeBasicResourceCertificateDetailsAuthTypeAzureActiveDirectory AuthTypeBasicResourceCertificateDetails = "AzureActiveDirectory"
	// AuthTypeBasicResourceCertificateDetailsAuthTypeResourceCertificateDetails ...
	AuthTypeBasicResourceCertificateDetailsAuthTypeResourceCertificateDetails AuthTypeBasicResourceCertificateDetails = "ResourceCertificateDetails"
)

// PossibleAuthTypeBasicResourceCertificateDetailsValues returns an array of possible values for the AuthTypeBasicResourceCertificateDetails const type.
func PossibleAuthTypeBasicResourceCertificateDetailsValues() []AuthTypeBasicResourceCertificateDetails {
	return []AuthTypeBasicResourceCertificateDetails{AuthTypeBasicResourceCertificateDetailsAuthTypeAccessControlService, AuthTypeBasicResourceCertificateDetailsAuthTypeAzureActiveDirectory, AuthTypeBasicResourceCertificateDetailsAuthTypeResourceCertificateDetails}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// InfrastructureEncryptionState enumerates the values for infrastructure encryption state.
type InfrastructureEncryptionState string

const (
	// InfrastructureEncryptionStateDisabled ...
	InfrastructureEncryptionStateDisabled InfrastructureEncryptionState = "Disabled"
	// InfrastructureEncryptionStateEnabled ...
	InfrastructureEncryptionStateEnabled InfrastructureEncryptionState = "Enabled"
)

// PossibleInfrastructureEncryptionStateValues returns an array of possible values for the InfrastructureEncryptionState const type.
func PossibleInfrastructureEncryptionStateValues() []InfrastructureEncryptionState {
	return []InfrastructureEncryptionState{InfrastructureEncryptionStateDisabled, InfrastructureEncryptionStateEnabled}
}

// PrivateEndpointConnectionStatus enumerates the values for private endpoint connection status.
type PrivateEndpointConnectionStatus string

const (
	// PrivateEndpointConnectionStatusApproved ...
	PrivateEndpointConnectionStatusApproved PrivateEndpointConnectionStatus = "Approved"
	// PrivateEndpointConnectionStatusDisconnected ...
	PrivateEndpointConnectionStatusDisconnected PrivateEndpointConnectionStatus = "Disconnected"
	// PrivateEndpointConnectionStatusPending ...
	PrivateEndpointConnectionStatusPending PrivateEndpointConnectionStatus = "Pending"
	// PrivateEndpointConnectionStatusRejected ...
	PrivateEndpointConnectionStatusRejected PrivateEndpointConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointConnectionStatusValues returns an array of possible values for the PrivateEndpointConnectionStatus const type.
func PossiblePrivateEndpointConnectionStatusValues() []PrivateEndpointConnectionStatus {
	return []PrivateEndpointConnectionStatus{PrivateEndpointConnectionStatusApproved, PrivateEndpointConnectionStatusDisconnected, PrivateEndpointConnectionStatusPending, PrivateEndpointConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStatePending ...
	ProvisioningStatePending ProvisioningState = "Pending"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStatePending, ProvisioningStateSucceeded}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// ResourceMoveState enumerates the values for resource move state.
type ResourceMoveState string

const (
	// ResourceMoveStateCommitFailed ...
	ResourceMoveStateCommitFailed ResourceMoveState = "CommitFailed"
	// ResourceMoveStateCommitTimedout ...
	ResourceMoveStateCommitTimedout ResourceMoveState = "CommitTimedout"
	// ResourceMoveStateCriticalFailure ...
	ResourceMoveStateCriticalFailure ResourceMoveState = "CriticalFailure"
	// ResourceMoveStateFailure ...
	ResourceMoveStateFailure ResourceMoveState = "Failure"
	// ResourceMoveStateInProgress ...
	ResourceMoveStateInProgress ResourceMoveState = "InProgress"
	// ResourceMoveStateMoveSucceeded ...
	ResourceMoveStateMoveSucceeded ResourceMoveState = "MoveSucceeded"
	// ResourceMoveStatePartialSuccess ...
	ResourceMoveStatePartialSuccess ResourceMoveState = "PartialSuccess"
	// ResourceMoveStatePrepareFailed ...
	ResourceMoveStatePrepareFailed ResourceMoveState = "PrepareFailed"
	// ResourceMoveStatePrepareTimedout ...
	ResourceMoveStatePrepareTimedout ResourceMoveState = "PrepareTimedout"
	// ResourceMoveStateUnknown ...
	ResourceMoveStateUnknown ResourceMoveState = "Unknown"
)

// PossibleResourceMoveStateValues returns an array of possible values for the ResourceMoveState const type.
func PossibleResourceMoveStateValues() []ResourceMoveState {
	return []ResourceMoveState{ResourceMoveStateCommitFailed, ResourceMoveStateCommitTimedout, ResourceMoveStateCriticalFailure, ResourceMoveStateFailure, ResourceMoveStateInProgress, ResourceMoveStateMoveSucceeded, ResourceMoveStatePartialSuccess, ResourceMoveStatePrepareFailed, ResourceMoveStatePrepareTimedout, ResourceMoveStateUnknown}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameRS0 ...
	SkuNameRS0 SkuName = "RS0"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameRS0, SkuNameStandard}
}

// TriggerType enumerates the values for trigger type.
type TriggerType string

const (
	// TriggerTypeForcedUpgrade ...
	TriggerTypeForcedUpgrade TriggerType = "ForcedUpgrade"
	// TriggerTypeUserTriggered ...
	TriggerTypeUserTriggered TriggerType = "UserTriggered"
)

// PossibleTriggerTypeValues returns an array of possible values for the TriggerType const type.
func PossibleTriggerTypeValues() []TriggerType {
	return []TriggerType{TriggerTypeForcedUpgrade, TriggerTypeUserTriggered}
}

// UsagesUnit enumerates the values for usages unit.
type UsagesUnit string

const (
	// UsagesUnitBytes ...
	UsagesUnitBytes UsagesUnit = "Bytes"
	// UsagesUnitBytesPerSecond ...
	UsagesUnitBytesPerSecond UsagesUnit = "BytesPerSecond"
	// UsagesUnitCount ...
	UsagesUnitCount UsagesUnit = "Count"
	// UsagesUnitCountPerSecond ...
	UsagesUnitCountPerSecond UsagesUnit = "CountPerSecond"
	// UsagesUnitPercent ...
	UsagesUnitPercent UsagesUnit = "Percent"
	// UsagesUnitSeconds ...
	UsagesUnitSeconds UsagesUnit = "Seconds"
)

// PossibleUsagesUnitValues returns an array of possible values for the UsagesUnit const type.
func PossibleUsagesUnitValues() []UsagesUnit {
	return []UsagesUnit{UsagesUnitBytes, UsagesUnitBytesPerSecond, UsagesUnitCount, UsagesUnitCountPerSecond, UsagesUnitPercent, UsagesUnitSeconds}
}

// VaultPrivateEndpointState enumerates the values for vault private endpoint state.
type VaultPrivateEndpointState string

const (
	// VaultPrivateEndpointStateEnabled ...
	VaultPrivateEndpointStateEnabled VaultPrivateEndpointState = "Enabled"
	// VaultPrivateEndpointStateNone ...
	VaultPrivateEndpointStateNone VaultPrivateEndpointState = "None"
)

// PossibleVaultPrivateEndpointStateValues returns an array of possible values for the VaultPrivateEndpointState const type.
func PossibleVaultPrivateEndpointStateValues() []VaultPrivateEndpointState {
	return []VaultPrivateEndpointState{VaultPrivateEndpointStateEnabled, VaultPrivateEndpointStateNone}
}

// VaultUpgradeState enumerates the values for vault upgrade state.
type VaultUpgradeState string

const (
	// VaultUpgradeStateFailed ...
	VaultUpgradeStateFailed VaultUpgradeState = "Failed"
	// VaultUpgradeStateInProgress ...
	VaultUpgradeStateInProgress VaultUpgradeState = "InProgress"
	// VaultUpgradeStateUnknown ...
	VaultUpgradeStateUnknown VaultUpgradeState = "Unknown"
	// VaultUpgradeStateUpgraded ...
	VaultUpgradeStateUpgraded VaultUpgradeState = "Upgraded"
)

// PossibleVaultUpgradeStateValues returns an array of possible values for the VaultUpgradeState const type.
func PossibleVaultUpgradeStateValues() []VaultUpgradeState {
	return []VaultUpgradeState{VaultUpgradeStateFailed, VaultUpgradeStateInProgress, VaultUpgradeStateUnknown, VaultUpgradeStateUpgraded}
}
