package operationalinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/operationalinsights/mgmt/2022-02-01-preview/operationalinsights"

// AssociatedWorkspace the list of Log Analytics workspaces associated with the cluster.
type AssociatedWorkspace struct {
	// WorkspaceID - READ-ONLY; The id of the assigned workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceName - READ-ONLY; The name id the assigned workspace.
	WorkspaceName *string `json:"workspaceName,omitempty"`
	// ResourceID - READ-ONLY; The ResourceId id the assigned workspace.
	ResourceID *string `json:"resourceId,omitempty"`
	// AssociateDate - READ-ONLY; The time of workspace association.
	AssociateDate *string `json:"associateDate,omitempty"`
}

// MarshalJSON is the custom marshaler for AssociatedWorkspace.
func (aw AssociatedWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AvailableServiceTier service Tier details.
type AvailableServiceTier struct {
	// ServiceTier - READ-ONLY; The name of the Service Tier. Possible values include: 'SkuNameEnumFree', 'SkuNameEnumStandard', 'SkuNameEnumPremium', 'SkuNameEnumPerNode', 'SkuNameEnumPerGB2018', 'SkuNameEnumStandalone', 'SkuNameEnumCapacityReservation'
	ServiceTier SkuNameEnum `json:"serviceTier,omitempty"`
	// Enabled - READ-ONLY; True if the Service Tier is enabled for the workspace.
	Enabled *bool `json:"enabled,omitempty"`
	// MinimumRetention - READ-ONLY; The minimum retention for the Service Tier, in days.
	MinimumRetention *int64 `json:"minimumRetention,omitempty"`
	// MaximumRetention - READ-ONLY; The maximum retention for the Service Tier, in days.
	MaximumRetention *int64 `json:"maximumRetention,omitempty"`
	// DefaultRetention - READ-ONLY; The default retention for the Service Tier, in days.
	DefaultRetention *int64 `json:"defaultRetention,omitempty"`
	// CapacityReservationLevel - READ-ONLY; The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier.
	CapacityReservationLevel *int64 `json:"capacityReservationLevel,omitempty"`
	// LastSkuUpdate - READ-ONLY; Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier.
	LastSkuUpdate *string `json:"lastSkuUpdate,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableServiceTier.
func (astVar AvailableServiceTier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureResourceProperties an Azure resource QueryPack-Query object
type AzureResourceProperties struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceProperties.
func (arp AzureResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CapacityReservationProperties the Capacity Reservation properties.
type CapacityReservationProperties struct {
	// LastSkuUpdate - READ-ONLY; The last time Sku was updated.
	LastSkuUpdate *string `json:"lastSkuUpdate,omitempty"`
	// MinCapacity - READ-ONLY; Minimum CapacityReservation value in GB.
	MinCapacity *int64 `json:"minCapacity,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityReservationProperties.
func (crp CapacityReservationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Cluster the top level Log Analytics cluster resource container.
type Cluster struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Sku - The sku properties.
	Sku *ClusterSku `json:"sku,omitempty"`
	// ClusterProperties - Log Analytics cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Identity != nil {
		objectMap["identity"] = c.Identity
	}
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				c.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ClusterSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterListResult the list clusters operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of recommendations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - A list of Log Analytics clusters.
	Value *[]Cluster `json:"value,omitempty"`
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ClusterListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(cur ClusterListResult, getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ClusterPatch the top level Log Analytics cluster resource container.
type ClusterPatch struct {
	// ClusterPatchProperties - Log Analytics cluster properties.
	*ClusterPatchProperties `json:"properties,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Sku - The sku properties.
	Sku *ClusterSku `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterPatch.
func (cp ClusterPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ClusterPatchProperties != nil {
		objectMap["properties"] = cp.ClusterPatchProperties
	}
	if cp.Identity != nil {
		objectMap["identity"] = cp.Identity
	}
	if cp.Sku != nil {
		objectMap["sku"] = cp.Sku
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterPatch struct.
func (cp *ClusterPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterPatchProperties ClusterPatchProperties
				err = json.Unmarshal(*v, &clusterPatchProperties)
				if err != nil {
					return err
				}
				cp.ClusterPatchProperties = &clusterPatchProperties
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cp.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku ClusterSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cp.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		}
	}

	return nil
}

// ClusterPatchProperties log Analytics cluster patch properties.
type ClusterPatchProperties struct {
	// KeyVaultProperties - The associated key properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// BillingType - The cluster's billing type. Possible values include: 'BillingTypeCluster', 'BillingTypeWorkspaces'
	BillingType BillingType `json:"billingType,omitempty"`
}

// ClusterProperties cluster properties.
type ClusterProperties struct {
	// ClusterID - READ-ONLY; The ID associated with the cluster.
	ClusterID *string `json:"clusterId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the cluster. Possible values include: 'Creating', 'Succeeded', 'Failed', 'Canceled', 'Deleting', 'ProvisioningAccount', 'Updating'
	ProvisioningState ClusterEntityStatus `json:"provisioningState,omitempty"`
	// IsDoubleEncryptionEnabled - Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'
	IsDoubleEncryptionEnabled *bool `json:"isDoubleEncryptionEnabled,omitempty"`
	// IsAvailabilityZonesEnabled - Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones.
	IsAvailabilityZonesEnabled *bool `json:"isAvailabilityZonesEnabled,omitempty"`
	// BillingType - The cluster's billing type. Possible values include: 'BillingTypeCluster', 'BillingTypeWorkspaces'
	BillingType BillingType `json:"billingType,omitempty"`
	// KeyVaultProperties - The associated key properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// LastModifiedDate - READ-ONLY; The last time the cluster was updated.
	LastModifiedDate *string `json:"lastModifiedDate,omitempty"`
	// CreatedDate - READ-ONLY; The cluster creation time
	CreatedDate *string `json:"createdDate,omitempty"`
	// AssociatedWorkspaces - The list of Log Analytics workspaces associated with the cluster
	AssociatedWorkspaces *[]AssociatedWorkspace `json:"associatedWorkspaces,omitempty"`
	// CapacityReservationProperties - Additional properties for capacity reservation
	CapacityReservationProperties *CapacityReservationProperties `json:"capacityReservationProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.IsDoubleEncryptionEnabled != nil {
		objectMap["isDoubleEncryptionEnabled"] = cp.IsDoubleEncryptionEnabled
	}
	if cp.IsAvailabilityZonesEnabled != nil {
		objectMap["isAvailabilityZonesEnabled"] = cp.IsAvailabilityZonesEnabled
	}
	if cp.BillingType != "" {
		objectMap["billingType"] = cp.BillingType
	}
	if cp.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = cp.KeyVaultProperties
	}
	if cp.AssociatedWorkspaces != nil {
		objectMap["associatedWorkspaces"] = cp.AssociatedWorkspaces
	}
	if cp.CapacityReservationProperties != nil {
		objectMap["capacityReservationProperties"] = cp.CapacityReservationProperties
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClusterSku the cluster sku definition.
type ClusterSku struct {
	// Capacity - The capacity value
	Capacity *int64 `json:"capacity,omitempty"`
	// Name - The name of the SKU. Possible values include: 'CapacityReservation'
	Name ClusterSkuNameEnum `json:"name,omitempty"`
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Column table column.
type Column struct {
	// Name - Column name.
	Name *string `json:"name,omitempty"`
	// Type - Column data type. Possible values include: 'ColumnTypeEnumString', 'ColumnTypeEnumInt', 'ColumnTypeEnumLong', 'ColumnTypeEnumReal', 'ColumnTypeEnumBoolean', 'ColumnTypeEnumDateTime', 'ColumnTypeEnumGUID', 'ColumnTypeEnumDynamic'
	Type ColumnTypeEnum `json:"type,omitempty"`
	// DataTypeHint - Column data type logical hint. Possible values include: 'URI', 'GUID', 'ArmPath', 'IP'
	DataTypeHint ColumnDataTypeHintEnum `json:"dataTypeHint,omitempty"`
	// DisplayName - Column display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Column description.
	Description *string `json:"description,omitempty"`
	// IsDefaultDisplay - READ-ONLY; Is displayed by default.
	IsDefaultDisplay *bool `json:"isDefaultDisplay,omitempty"`
	// IsHidden - READ-ONLY; Is column hidden.
	IsHidden *bool `json:"isHidden,omitempty"`
}

// MarshalJSON is the custom marshaler for Column.
func (c Column) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != "" {
		objectMap["type"] = c.Type
	}
	if c.DataTypeHint != "" {
		objectMap["dataTypeHint"] = c.DataTypeHint
	}
	if c.DisplayName != nil {
		objectMap["displayName"] = c.DisplayName
	}
	if c.Description != nil {
		objectMap["description"] = c.Description
	}
	return json.Marshal(objectMap)
}

// CoreSummary the core summary of a search.
type CoreSummary struct {
	// Status - The status of a core summary.
	Status *string `json:"status,omitempty"`
	// NumberOfDocuments - The number of documents of a core summary.
	NumberOfDocuments *int64 `json:"numberOfDocuments,omitempty"`
}

// DataExport the top level data export resource container.
type DataExport struct {
	autorest.Response `json:"-"`
	// DataExportProperties - data export properties.
	*DataExportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataExport.
func (de DataExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if de.DataExportProperties != nil {
		objectMap["properties"] = de.DataExportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataExport struct.
func (de *DataExport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataExportProperties DataExportProperties
				err = json.Unmarshal(*v, &dataExportProperties)
				if err != nil {
					return err
				}
				de.DataExportProperties = &dataExportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				de.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				de.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				de.Type = &typeVar
			}
		}
	}

	return nil
}

// DataExportListResult result of the request to list data exports.
type DataExportListResult struct {
	autorest.Response `json:"-"`
	// Value - List of data export instances within a workspace..
	Value *[]DataExport `json:"value,omitempty"`
}

// DataExportProperties data Export properties.
type DataExportProperties struct {
	// DataExportID - The data export rule ID.
	DataExportID *string `json:"dataExportId,omitempty"`
	// TableNames - An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
	TableNames *[]string `json:"tableNames,omitempty"`
	// Destination - destination properties.
	*Destination `json:"destination,omitempty"`
	// Enable - Active when enabled.
	Enable *bool `json:"enable,omitempty"`
	// CreatedDate - The latest data export rule modification time.
	CreatedDate *string `json:"createdDate,omitempty"`
	// LastModifiedDate - Date and time when the export was last modified.
	LastModifiedDate *string `json:"lastModifiedDate,omitempty"`
}

// MarshalJSON is the custom marshaler for DataExportProperties.
func (dep DataExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dep.DataExportID != nil {
		objectMap["dataExportId"] = dep.DataExportID
	}
	if dep.TableNames != nil {
		objectMap["tableNames"] = dep.TableNames
	}
	if dep.Destination != nil {
		objectMap["destination"] = dep.Destination
	}
	if dep.Enable != nil {
		objectMap["enable"] = dep.Enable
	}
	if dep.CreatedDate != nil {
		objectMap["createdDate"] = dep.CreatedDate
	}
	if dep.LastModifiedDate != nil {
		objectMap["lastModifiedDate"] = dep.LastModifiedDate
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataExportProperties struct.
func (dep *DataExportProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataExportId":
			if v != nil {
				var dataExportID string
				err = json.Unmarshal(*v, &dataExportID)
				if err != nil {
					return err
				}
				dep.DataExportID = &dataExportID
			}
		case "tableNames":
			if v != nil {
				var tableNames []string
				err = json.Unmarshal(*v, &tableNames)
				if err != nil {
					return err
				}
				dep.TableNames = &tableNames
			}
		case "destination":
			if v != nil {
				var destination Destination
				err = json.Unmarshal(*v, &destination)
				if err != nil {
					return err
				}
				dep.Destination = &destination
			}
		case "enable":
			if v != nil {
				var enable bool
				err = json.Unmarshal(*v, &enable)
				if err != nil {
					return err
				}
				dep.Enable = &enable
			}
		case "createdDate":
			if v != nil {
				var createdDate string
				err = json.Unmarshal(*v, &createdDate)
				if err != nil {
					return err
				}
				dep.CreatedDate = &createdDate
			}
		case "lastModifiedDate":
			if v != nil {
				var lastModifiedDate string
				err = json.Unmarshal(*v, &lastModifiedDate)
				if err != nil {
					return err
				}
				dep.LastModifiedDate = &lastModifiedDate
			}
		}
	}

	return nil
}

// DataSource datasources under OMS Workspace.
type DataSource struct {
	autorest.Response `json:"-"`
	// Properties - The data source properties in raw json format, each kind of data source have it's own schema.
	Properties interface{} `json:"properties,omitempty"`
	// Etag - The ETag of the data source.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'WindowsEvent', 'WindowsPerformanceCounter', 'IISLogs', 'LinuxSyslog', 'LinuxSyslogCollection', 'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'CustomLog', 'CustomLogCollection', 'AzureAuditLog', 'AzureActivityLog', 'GenericDataSource', 'ChangeTrackingCustomPath', 'ChangeTrackingPath', 'ChangeTrackingServices', 'ChangeTrackingDataTypeConfiguration', 'ChangeTrackingDefaultRegistry', 'ChangeTrackingRegistry', 'ChangeTrackingLinuxPath', 'LinuxChangeTrackingPath', 'ChangeTrackingContentLocation', 'WindowsTelemetry', 'Office365', 'SecurityWindowsBaselineConfiguration', 'SecurityCenterSecurityWindowsBaselineConfiguration', 'SecurityEventCollectionConfiguration', 'SecurityInsightsSecurityEventCollectionConfiguration', 'ImportComputerGroup', 'NetworkMonitoring', 'Itsm', 'DNSAnalytics', 'ApplicationInsights', 'SQLDataClassification'
	Kind DataSourceKind `json:"kind,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataSource.
func (ds DataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.Properties != nil {
		objectMap["properties"] = ds.Properties
	}
	if ds.Etag != nil {
		objectMap["etag"] = ds.Etag
	}
	if ds.Kind != "" {
		objectMap["kind"] = ds.Kind
	}
	if ds.Tags != nil {
		objectMap["tags"] = ds.Tags
	}
	return json.Marshal(objectMap)
}

// DataSourceFilter dataSource filter. Right now, only filter by kind is supported.
type DataSourceFilter struct {
	// Kind - Possible values include: 'WindowsEvent', 'WindowsPerformanceCounter', 'IISLogs', 'LinuxSyslog', 'LinuxSyslogCollection', 'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'CustomLog', 'CustomLogCollection', 'AzureAuditLog', 'AzureActivityLog', 'GenericDataSource', 'ChangeTrackingCustomPath', 'ChangeTrackingPath', 'ChangeTrackingServices', 'ChangeTrackingDataTypeConfiguration', 'ChangeTrackingDefaultRegistry', 'ChangeTrackingRegistry', 'ChangeTrackingLinuxPath', 'LinuxChangeTrackingPath', 'ChangeTrackingContentLocation', 'WindowsTelemetry', 'Office365', 'SecurityWindowsBaselineConfiguration', 'SecurityCenterSecurityWindowsBaselineConfiguration', 'SecurityEventCollectionConfiguration', 'SecurityInsightsSecurityEventCollectionConfiguration', 'ImportComputerGroup', 'NetworkMonitoring', 'Itsm', 'DNSAnalytics', 'ApplicationInsights', 'SQLDataClassification'
	Kind DataSourceKind `json:"kind,omitempty"`
}

// DataSourceListResult the list data source by workspace operation response.
type DataSourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of datasources.
	Value *[]DataSource `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of datasources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataSourceListResultIterator provides access to a complete listing of DataSource values.
type DataSourceListResultIterator struct {
	i    int
	page DataSourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataSourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataSourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataSourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataSourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataSourceListResultIterator) Response() DataSourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataSourceListResultIterator) Value() DataSource {
	if !iter.page.NotDone() {
		return DataSource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataSourceListResultIterator type.
func NewDataSourceListResultIterator(page DataSourceListResultPage) DataSourceListResultIterator {
	return DataSourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DataSourceListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dslr DataSourceListResult) hasNextLink() bool {
	return dslr.NextLink != nil && len(*dslr.NextLink) != 0
}

// dataSourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DataSourceListResult) dataSourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DataSourceListResultPage contains a page of DataSource values.
type DataSourceListResultPage struct {
	fn   func(context.Context, DataSourceListResult) (DataSourceListResult, error)
	dslr DataSourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataSourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataSourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dslr)
		if err != nil {
			return err
		}
		page.dslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataSourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataSourceListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataSourceListResultPage) Response() DataSourceListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataSourceListResultPage) Values() []DataSource {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Creates a new instance of the DataSourceListResultPage type.
func NewDataSourceListResultPage(cur DataSourceListResult, getNextPage func(context.Context, DataSourceListResult) (DataSourceListResult, error)) DataSourceListResultPage {
	return DataSourceListResultPage{
		fn:   getNextPage,
		dslr: cur,
	}
}

// Destination destination properties.
type Destination struct {
	// ResourceID - The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
	ResourceID *string `json:"resourceId,omitempty"`
	// Type - READ-ONLY; The type of the destination resource. Possible values include: 'TypeStorageAccount', 'TypeEventHub'
	Type Type `json:"type,omitempty"`
	// DestinationMetaData - destination meta data.
	*DestinationMetaData `json:"metaData,omitempty"`
}

// MarshalJSON is the custom marshaler for Destination.
func (d Destination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.ResourceID != nil {
		objectMap["resourceId"] = d.ResourceID
	}
	if d.DestinationMetaData != nil {
		objectMap["metaData"] = d.DestinationMetaData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Destination struct.
func (d *Destination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "resourceId":
			if v != nil {
				var resourceID string
				err = json.Unmarshal(*v, &resourceID)
				if err != nil {
					return err
				}
				d.ResourceID = &resourceID
			}
		case "type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = typeVar
			}
		case "metaData":
			if v != nil {
				var destinationMetaData DestinationMetaData
				err = json.Unmarshal(*v, &destinationMetaData)
				if err != nil {
					return err
				}
				d.DestinationMetaData = &destinationMetaData
			}
		}
	}

	return nil
}

// DestinationMetaData destination meta data.
type DestinationMetaData struct {
	// EventHubName - Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
	EventHubName *string `json:"eventHubName,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Type of managed service identity. Possible values include: 'SystemAssigned', 'UserAssigned', 'None'
	Type IdentityTypeForCluster `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IntelligencePack intelligence Pack containing a string name and boolean indicating if it's enabled.
type IntelligencePack struct {
	// Name - The name of the intelligence pack.
	Name *string `json:"name,omitempty"`
	// Enabled - The enabled boolean for the intelligence pack.
	Enabled *bool `json:"enabled,omitempty"`
	// DisplayName - The display name of the intelligence pack.
	DisplayName *string `json:"displayName,omitempty"`
}

// KeyVaultProperties the key vault properties.
type KeyVaultProperties struct {
	// KeyVaultURI - The Key Vault uri which holds they key associated with the Log Analytics cluster.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyName - The name of the key associated with the Log Analytics cluster.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The version of the key associated with the Log Analytics cluster.
	KeyVersion *string `json:"keyVersion,omitempty"`
	// KeyRsaSize - Selected key minimum required size.
	KeyRsaSize *int32 `json:"keyRsaSize,omitempty"`
}

// LinkedService the top level Linked service resource container.
type LinkedService struct {
	autorest.Response `json:"-"`
	// LinkedServiceProperties - The properties of the linked service.
	*LinkedServiceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedService.
func (ls LinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ls.LinkedServiceProperties != nil {
		objectMap["properties"] = ls.LinkedServiceProperties
	}
	if ls.Tags != nil {
		objectMap["tags"] = ls.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LinkedService struct.
func (ls *LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedServiceProperties LinkedServiceProperties
				err = json.Unmarshal(*v, &linkedServiceProperties)
				if err != nil {
					return err
				}
				ls.LinkedServiceProperties = &linkedServiceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ls.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ls.Type = &typeVar
			}
		}
	}

	return nil
}

// LinkedServiceListResult the list linked service operation response.
type LinkedServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of linked service instances
	Value *[]LinkedService `json:"value,omitempty"`
}

// LinkedServiceProperties linked service properties.
type LinkedServiceProperties struct {
	// ResourceID - The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access
	ResourceID *string `json:"resourceId,omitempty"`
	// WriteAccessResourceID - The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access
	WriteAccessResourceID *string `json:"writeAccessResourceId,omitempty"`
	// ProvisioningState - The provisioning state of the linked service. Possible values include: 'LinkedServiceEntityStatusSucceeded', 'LinkedServiceEntityStatusDeleting', 'LinkedServiceEntityStatusProvisioningAccount', 'LinkedServiceEntityStatusUpdating'
	ProvisioningState LinkedServiceEntityStatus `json:"provisioningState,omitempty"`
}

// LinkedServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LinkedServicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LinkedServicesClient) (LinkedService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LinkedServicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LinkedServicesCreateOrUpdateFuture.Result.
func (future *LinkedServicesCreateOrUpdateFuture) result(client LinkedServicesClient) (ls LinkedService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.LinkedServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ls.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.LinkedServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ls.Response.Response, err = future.GetResult(sender); err == nil && ls.Response.Response.StatusCode != http.StatusNoContent {
		ls, err = client.CreateOrUpdateResponder(ls.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.LinkedServicesCreateOrUpdateFuture", "Result", ls.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LinkedServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LinkedServicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LinkedServicesClient) (LinkedService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LinkedServicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LinkedServicesDeleteFuture.Result.
func (future *LinkedServicesDeleteFuture) result(client LinkedServicesClient) (ls LinkedService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.LinkedServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ls.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.LinkedServicesDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ls.Response.Response, err = future.GetResult(sender); err == nil && ls.Response.Response.StatusCode != http.StatusNoContent {
		ls, err = client.DeleteResponder(ls.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.LinkedServicesDeleteFuture", "Result", ls.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LinkedStorageAccountsListResult the list linked storage accounts service operation response.
type LinkedStorageAccountsListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of linked storage accounts instances.
	Value *[]LinkedStorageAccountsResource `json:"value,omitempty"`
}

// LinkedStorageAccountsProperties linked storage accounts properties.
type LinkedStorageAccountsProperties struct {
	// DataSourceType - READ-ONLY; Linked storage accounts type. Possible values include: 'CustomLogs', 'AzureWatson', 'Query', 'Ingestion', 'Alerts'
	DataSourceType DataSourceType `json:"dataSourceType,omitempty"`
	// StorageAccountIds - Linked storage accounts resources ids.
	StorageAccountIds *[]string `json:"storageAccountIds,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedStorageAccountsProperties.
func (lsap LinkedStorageAccountsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lsap.StorageAccountIds != nil {
		objectMap["storageAccountIds"] = lsap.StorageAccountIds
	}
	return json.Marshal(objectMap)
}

// LinkedStorageAccountsResource linked storage accounts top level resource container.
type LinkedStorageAccountsResource struct {
	autorest.Response `json:"-"`
	// LinkedStorageAccountsProperties - Linked storage accounts properties.
	*LinkedStorageAccountsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedStorageAccountsResource.
func (lsar LinkedStorageAccountsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lsar.LinkedStorageAccountsProperties != nil {
		objectMap["properties"] = lsar.LinkedStorageAccountsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LinkedStorageAccountsResource struct.
func (lsar *LinkedStorageAccountsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedStorageAccountsProperties LinkedStorageAccountsProperties
				err = json.Unmarshal(*v, &linkedStorageAccountsProperties)
				if err != nil {
					return err
				}
				lsar.LinkedStorageAccountsProperties = &linkedStorageAccountsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lsar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lsar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lsar.Type = &typeVar
			}
		}
	}

	return nil
}

// ListAvailableServiceTier ...
type ListAvailableServiceTier struct {
	autorest.Response `json:"-"`
	Value             *[]AvailableServiceTier `json:"value,omitempty"`
}

// ListIntelligencePack ...
type ListIntelligencePack struct {
	autorest.Response `json:"-"`
	Value             *[]IntelligencePack `json:"value,omitempty"`
}

// LogAnalyticsQueryPack an Log Analytics QueryPack definition.
type LogAnalyticsQueryPack struct {
	autorest.Response `json:"-"`
	// LogAnalyticsQueryPackProperties - Properties that define a Log Analytics QueryPack resource.
	*LogAnalyticsQueryPackProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsQueryPack.
func (laqp LogAnalyticsQueryPack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if laqp.LogAnalyticsQueryPackProperties != nil {
		objectMap["properties"] = laqp.LogAnalyticsQueryPackProperties
	}
	if laqp.Location != nil {
		objectMap["location"] = laqp.Location
	}
	if laqp.Tags != nil {
		objectMap["tags"] = laqp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogAnalyticsQueryPack struct.
func (laqp *LogAnalyticsQueryPack) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logAnalyticsQueryPackProperties LogAnalyticsQueryPackProperties
				err = json.Unmarshal(*v, &logAnalyticsQueryPackProperties)
				if err != nil {
					return err
				}
				laqp.LogAnalyticsQueryPackProperties = &logAnalyticsQueryPackProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				laqp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				laqp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				laqp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				laqp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				laqp.Tags = tags
			}
		}
	}

	return nil
}

// LogAnalyticsQueryPackListResult describes the list of Log Analytics QueryPack resources.
type LogAnalyticsQueryPackListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Log Analytics QueryPack definitions.
	Value *[]LogAnalyticsQueryPack `json:"value,omitempty"`
	// NextLink - The URI to get the next set of Log Analytics QueryPack definitions if too many QueryPacks where returned in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogAnalyticsQueryPackListResultIterator provides access to a complete listing of LogAnalyticsQueryPack
// values.
type LogAnalyticsQueryPackListResultIterator struct {
	i    int
	page LogAnalyticsQueryPackListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogAnalyticsQueryPackListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsQueryPackListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogAnalyticsQueryPackListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogAnalyticsQueryPackListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogAnalyticsQueryPackListResultIterator) Response() LogAnalyticsQueryPackListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogAnalyticsQueryPackListResultIterator) Value() LogAnalyticsQueryPack {
	if !iter.page.NotDone() {
		return LogAnalyticsQueryPack{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogAnalyticsQueryPackListResultIterator type.
func NewLogAnalyticsQueryPackListResultIterator(page LogAnalyticsQueryPackListResultPage) LogAnalyticsQueryPackListResultIterator {
	return LogAnalyticsQueryPackListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (laqplr LogAnalyticsQueryPackListResult) IsEmpty() bool {
	return laqplr.Value == nil || len(*laqplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (laqplr LogAnalyticsQueryPackListResult) hasNextLink() bool {
	return laqplr.NextLink != nil && len(*laqplr.NextLink) != 0
}

// logAnalyticsQueryPackListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (laqplr LogAnalyticsQueryPackListResult) logAnalyticsQueryPackListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !laqplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(laqplr.NextLink)))
}

// LogAnalyticsQueryPackListResultPage contains a page of LogAnalyticsQueryPack values.
type LogAnalyticsQueryPackListResultPage struct {
	fn     func(context.Context, LogAnalyticsQueryPackListResult) (LogAnalyticsQueryPackListResult, error)
	laqplr LogAnalyticsQueryPackListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogAnalyticsQueryPackListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsQueryPackListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.laqplr)
		if err != nil {
			return err
		}
		page.laqplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogAnalyticsQueryPackListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogAnalyticsQueryPackListResultPage) NotDone() bool {
	return !page.laqplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogAnalyticsQueryPackListResultPage) Response() LogAnalyticsQueryPackListResult {
	return page.laqplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogAnalyticsQueryPackListResultPage) Values() []LogAnalyticsQueryPack {
	if page.laqplr.IsEmpty() {
		return nil
	}
	return *page.laqplr.Value
}

// Creates a new instance of the LogAnalyticsQueryPackListResultPage type.
func NewLogAnalyticsQueryPackListResultPage(cur LogAnalyticsQueryPackListResult, getNextPage func(context.Context, LogAnalyticsQueryPackListResult) (LogAnalyticsQueryPackListResult, error)) LogAnalyticsQueryPackListResultPage {
	return LogAnalyticsQueryPackListResultPage{
		fn:     getNextPage,
		laqplr: cur,
	}
}

// LogAnalyticsQueryPackProperties properties that define a Log Analytics QueryPack resource.
type LogAnalyticsQueryPackProperties struct {
	// QueryPackID - READ-ONLY; The unique ID of your application. This field cannot be changed.
	QueryPackID *string `json:"queryPackId,omitempty"`
	// TimeCreated - READ-ONLY; Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// TimeModified - READ-ONLY; Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
	TimeModified *date.Time `json:"timeModified,omitempty"`
	// ProvisioningState - READ-ONLY; Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsQueryPackProperties.
func (laqpp LogAnalyticsQueryPackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LogAnalyticsQueryPackQuery a Log Analytics QueryPack-Query definition.
type LogAnalyticsQueryPackQuery struct {
	autorest.Response `json:"-"`
	// LogAnalyticsQueryPackQueryProperties - Properties that define an Log Analytics QueryPack-Query resource.
	*LogAnalyticsQueryPackQueryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsQueryPackQuery.
func (laqpq LogAnalyticsQueryPackQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if laqpq.LogAnalyticsQueryPackQueryProperties != nil {
		objectMap["properties"] = laqpq.LogAnalyticsQueryPackQueryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogAnalyticsQueryPackQuery struct.
func (laqpq *LogAnalyticsQueryPackQuery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logAnalyticsQueryPackQueryProperties LogAnalyticsQueryPackQueryProperties
				err = json.Unmarshal(*v, &logAnalyticsQueryPackQueryProperties)
				if err != nil {
					return err
				}
				laqpq.LogAnalyticsQueryPackQueryProperties = &logAnalyticsQueryPackQueryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				laqpq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				laqpq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				laqpq.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				laqpq.SystemData = &systemData
			}
		}
	}

	return nil
}

// LogAnalyticsQueryPackQueryListResult describes the list of Log Analytics QueryPack-Query resources.
type LogAnalyticsQueryPackQueryListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Log Analytics QueryPack Query definitions.
	Value *[]LogAnalyticsQueryPackQuery `json:"value,omitempty"`
	// NextLink - The URI to get the next set of Log Analytics QueryPack definitions if too many QueryPack-Queries where returned in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogAnalyticsQueryPackQueryListResultIterator provides access to a complete listing of
// LogAnalyticsQueryPackQuery values.
type LogAnalyticsQueryPackQueryListResultIterator struct {
	i    int
	page LogAnalyticsQueryPackQueryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogAnalyticsQueryPackQueryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsQueryPackQueryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogAnalyticsQueryPackQueryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogAnalyticsQueryPackQueryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogAnalyticsQueryPackQueryListResultIterator) Response() LogAnalyticsQueryPackQueryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogAnalyticsQueryPackQueryListResultIterator) Value() LogAnalyticsQueryPackQuery {
	if !iter.page.NotDone() {
		return LogAnalyticsQueryPackQuery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogAnalyticsQueryPackQueryListResultIterator type.
func NewLogAnalyticsQueryPackQueryListResultIterator(page LogAnalyticsQueryPackQueryListResultPage) LogAnalyticsQueryPackQueryListResultIterator {
	return LogAnalyticsQueryPackQueryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (laqpqlr LogAnalyticsQueryPackQueryListResult) IsEmpty() bool {
	return laqpqlr.Value == nil || len(*laqpqlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (laqpqlr LogAnalyticsQueryPackQueryListResult) hasNextLink() bool {
	return laqpqlr.NextLink != nil && len(*laqpqlr.NextLink) != 0
}

// logAnalyticsQueryPackQueryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (laqpqlr LogAnalyticsQueryPackQueryListResult) logAnalyticsQueryPackQueryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !laqpqlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(laqpqlr.NextLink)))
}

// LogAnalyticsQueryPackQueryListResultPage contains a page of LogAnalyticsQueryPackQuery values.
type LogAnalyticsQueryPackQueryListResultPage struct {
	fn      func(context.Context, LogAnalyticsQueryPackQueryListResult) (LogAnalyticsQueryPackQueryListResult, error)
	laqpqlr LogAnalyticsQueryPackQueryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogAnalyticsQueryPackQueryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsQueryPackQueryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.laqpqlr)
		if err != nil {
			return err
		}
		page.laqpqlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogAnalyticsQueryPackQueryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogAnalyticsQueryPackQueryListResultPage) NotDone() bool {
	return !page.laqpqlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogAnalyticsQueryPackQueryListResultPage) Response() LogAnalyticsQueryPackQueryListResult {
	return page.laqpqlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogAnalyticsQueryPackQueryListResultPage) Values() []LogAnalyticsQueryPackQuery {
	if page.laqpqlr.IsEmpty() {
		return nil
	}
	return *page.laqpqlr.Value
}

// Creates a new instance of the LogAnalyticsQueryPackQueryListResultPage type.
func NewLogAnalyticsQueryPackQueryListResultPage(cur LogAnalyticsQueryPackQueryListResult, getNextPage func(context.Context, LogAnalyticsQueryPackQueryListResult) (LogAnalyticsQueryPackQueryListResult, error)) LogAnalyticsQueryPackQueryListResultPage {
	return LogAnalyticsQueryPackQueryListResultPage{
		fn:      getNextPage,
		laqpqlr: cur,
	}
}

// LogAnalyticsQueryPackQueryProperties properties that define an Log Analytics QueryPack-Query resource.
type LogAnalyticsQueryPackQueryProperties struct {
	// ID - READ-ONLY; The unique ID of your application. This field cannot be changed.
	ID *string `json:"id,omitempty"`
	// DisplayName - Unique display name for your query within the Query Pack.
	DisplayName *string `json:"displayName,omitempty"`
	// TimeCreated - READ-ONLY; Creation Date for the Log Analytics Query, in ISO 8601 format.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// TimeModified - READ-ONLY; Last modified date of the Log Analytics Query, in ISO 8601 format.
	TimeModified *date.Time `json:"timeModified,omitempty"`
	// Author - READ-ONLY; Object Id of user creating the query.
	Author *string `json:"author,omitempty"`
	// Description - Description of the query.
	Description *string `json:"description,omitempty"`
	// Body - Body of the query.
	Body *string `json:"body,omitempty"`
	// Related - The related metadata items for the function.
	Related *LogAnalyticsQueryPackQueryPropertiesRelated `json:"related,omitempty"`
	// Tags - Tags associated with the query.
	Tags map[string][]string `json:"tags"`
	// Properties - Additional properties that can be set for the query.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsQueryPackQueryProperties.
func (laqpqp LogAnalyticsQueryPackQueryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if laqpqp.DisplayName != nil {
		objectMap["displayName"] = laqpqp.DisplayName
	}
	if laqpqp.Description != nil {
		objectMap["description"] = laqpqp.Description
	}
	if laqpqp.Body != nil {
		objectMap["body"] = laqpqp.Body
	}
	if laqpqp.Related != nil {
		objectMap["related"] = laqpqp.Related
	}
	if laqpqp.Tags != nil {
		objectMap["tags"] = laqpqp.Tags
	}
	if laqpqp.Properties != nil {
		objectMap["properties"] = laqpqp.Properties
	}
	return json.Marshal(objectMap)
}

// LogAnalyticsQueryPackQueryPropertiesRelated the related metadata items for the function.
type LogAnalyticsQueryPackQueryPropertiesRelated struct {
	// Categories - The related categories for the function.
	Categories *[]string `json:"categories,omitempty"`
	// ResourceTypes - The related resource types for the function.
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Solutions - The related Log Analytics solutions for the function.
	Solutions *[]string `json:"solutions,omitempty"`
}

// LogAnalyticsQueryPackQuerySearchProperties properties that define an Log Analytics QueryPack-Query
// search properties.
type LogAnalyticsQueryPackQuerySearchProperties struct {
	// Related - The related metadata items for the function.
	Related *LogAnalyticsQueryPackQuerySearchPropertiesRelated `json:"related,omitempty"`
	// Tags - Tags associated with the query.
	Tags map[string][]string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsQueryPackQuerySearchProperties.
func (laqpqsp LogAnalyticsQueryPackQuerySearchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if laqpqsp.Related != nil {
		objectMap["related"] = laqpqsp.Related
	}
	if laqpqsp.Tags != nil {
		objectMap["tags"] = laqpqsp.Tags
	}
	return json.Marshal(objectMap)
}

// LogAnalyticsQueryPackQuerySearchPropertiesRelated the related metadata items for the function.
type LogAnalyticsQueryPackQuerySearchPropertiesRelated struct {
	// Categories - The related categories for the function.
	Categories *[]string `json:"categories,omitempty"`
	// ResourceTypes - The related resource types for the function.
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Solutions - The related Log Analytics solutions for the function.
	Solutions *[]string `json:"solutions,omitempty"`
}

// ManagementGroup a management group that is connected to a workspace
type ManagementGroup struct {
	// ManagementGroupProperties - The properties of the management group.
	*ManagementGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementGroup.
func (mg ManagementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mg.ManagementGroupProperties != nil {
		objectMap["properties"] = mg.ManagementGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroup struct.
func (mg *ManagementGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementGroupProperties ManagementGroupProperties
				err = json.Unmarshal(*v, &managementGroupProperties)
				if err != nil {
					return err
				}
				mg.ManagementGroupProperties = &managementGroupProperties
			}
		}
	}

	return nil
}

// ManagementGroupProperties management group properties.
type ManagementGroupProperties struct {
	// ServerCount - The number of servers connected to the management group.
	ServerCount *int32 `json:"serverCount,omitempty"`
	// IsGateway - Gets or sets a value indicating whether the management group is a gateway.
	IsGateway *bool `json:"isGateway,omitempty"`
	// Name - The name of the management group.
	Name *string `json:"name,omitempty"`
	// ID - The unique ID of the management group.
	ID *string `json:"id,omitempty"`
	// Created - The datetime that the management group was created.
	Created *date.Time `json:"created,omitempty"`
	// DataReceived - The last datetime that the management group received data.
	DataReceived *date.Time `json:"dataReceived,omitempty"`
	// Version - The version of System Center that is managing the management group.
	Version *string `json:"version,omitempty"`
	// Sku - The SKU of System Center that is managing the management group.
	Sku *string `json:"sku,omitempty"`
}

// MetricName the name of a metric.
type MetricName struct {
	// Value - The system name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Operation supported operation of OperationalInsights resource provider.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft OperationsManagement.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list solution operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of solution operations supported by the OperationsManagement resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.Value != nil {
		objectMap["value"] = olr.Value
	}
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationStatus the status of operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - The operation Id.
	ID *string `json:"id,omitempty"`
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// StartTime - The start time of the operation.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The end time of the operation.
	EndTime *string `json:"endTime,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Error - The error detail of the operation if any.
	Error *ErrorResponse `json:"error,omitempty"`
}

// PrivateLinkScopedResource the private link scope resource reference.
type PrivateLinkScopedResource struct {
	// ResourceID - The full resource Id of the private link scope resource.
	ResourceID *string `json:"resourceId,omitempty"`
	// ScopeID - The private link scope unique Identifier.
	ScopeID *string `json:"scopeId,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryPacksResource an azure resource object
type QueryPacksResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for QueryPacksResource.
func (qpr QueryPacksResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qpr.Location != nil {
		objectMap["location"] = qpr.Location
	}
	if qpr.Tags != nil {
		objectMap["tags"] = qpr.Tags
	}
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RestoredLogs restore parameters.
type RestoredLogs struct {
	// StartRestoreTime - The timestamp to start the restore from (UTC).
	StartRestoreTime *date.Time `json:"startRestoreTime,omitempty"`
	// EndRestoreTime - The timestamp to end the restore by (UTC).
	EndRestoreTime *date.Time `json:"endRestoreTime,omitempty"`
	// SourceTable - The table to restore data from.
	SourceTable *string `json:"sourceTable,omitempty"`
}

// ResultStatistics search job execution statistics.
type ResultStatistics struct {
	// Progress - READ-ONLY; Search job completion percentage.
	Progress *float64 `json:"progress,omitempty"`
	// IngestedRecords - READ-ONLY; The number of rows that were returned by the search job.
	IngestedRecords *int32 `json:"ingestedRecords,omitempty"`
}

// MarshalJSON is the custom marshaler for ResultStatistics.
func (rs ResultStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SavedSearch value object for saved search results.
type SavedSearch struct {
	autorest.Response `json:"-"`
	// Etag - The ETag of the saved search. To override an existing saved search, use "*" or specify the current Etag
	Etag *string `json:"etag,omitempty"`
	// SavedSearchProperties - The properties of the saved search.
	*SavedSearchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SavedSearch.
func (ss SavedSearch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.Etag != nil {
		objectMap["etag"] = ss.Etag
	}
	if ss.SavedSearchProperties != nil {
		objectMap["properties"] = ss.SavedSearchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SavedSearch struct.
func (ss *SavedSearch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ss.Etag = &etag
			}
		case "properties":
			if v != nil {
				var savedSearchProperties SavedSearchProperties
				err = json.Unmarshal(*v, &savedSearchProperties)
				if err != nil {
					return err
				}
				ss.SavedSearchProperties = &savedSearchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SavedSearchesListResult the saved search list operation response.
type SavedSearchesListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of result values.
	Value *[]SavedSearch `json:"value,omitempty"`
}

// SavedSearchProperties value object for saved search results.
type SavedSearchProperties struct {
	// Category - The category of the saved search. This helps the user to find a saved search faster.
	Category *string `json:"category,omitempty"`
	// DisplayName - Saved search display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Query - The query expression for the saved search.
	Query *string `json:"query,omitempty"`
	// FunctionAlias - The function alias if query serves as a function.
	FunctionAlias *string `json:"functionAlias,omitempty"`
	// FunctionParameters - The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
	FunctionParameters *string `json:"functionParameters,omitempty"`
	// Version - The version number of the query language. The current version is 2 and is the default.
	Version *int64 `json:"version,omitempty"`
	// Tags - The tags attached to the saved search.
	Tags *[]Tag `json:"tags,omitempty"`
}

// Schema table's schema.
type Schema struct {
	// Name - Table name.
	Name *string `json:"name,omitempty"`
	// DisplayName - Table display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Table description.
	Description *string `json:"description,omitempty"`
	// Columns - A list of table custom columns.
	Columns *[]Column `json:"columns,omitempty"`
	// StandardColumns - READ-ONLY; A list of table standard columns.
	StandardColumns *[]Column `json:"standardColumns,omitempty"`
	// Categories - READ-ONLY; Table category.
	Categories *[]string `json:"categories,omitempty"`
	// Labels - READ-ONLY; Table labels.
	Labels *[]string `json:"labels,omitempty"`
	// Source - READ-ONLY; Table's creator. Possible values include: 'Microsoft', 'Customer'
	Source SourceEnum `json:"source,omitempty"`
	// TableType - READ-ONLY; Table's creator. Possible values include: 'TableTypeEnumMicrosoft', 'TableTypeEnumCustomLog', 'TableTypeEnumRestoredLogs', 'TableTypeEnumSearchResults'
	TableType TableTypeEnum `json:"tableType,omitempty"`
	// TableSubType - READ-ONLY; The subtype describes what APIs can be used to interact with the table, and what features are available against it. Possible values include: 'Any', 'Classic', 'DataCollectionRuleBased'
	TableSubType TableSubTypeEnum `json:"tableSubType,omitempty"`
	// Solutions - READ-ONLY; List of solutions the table is affiliated with
	Solutions *[]string `json:"solutions,omitempty"`
	// SearchResults - READ-ONLY; Parameters of the search job that initiated this table.
	SearchResults *SearchResults `json:"searchResults,omitempty"`
	// RestoredLogs - READ-ONLY; Parameters of the restore operation that initiated this table.
	RestoredLogs *RestoredLogs `json:"restoredLogs,omitempty"`
}

// MarshalJSON is the custom marshaler for Schema.
func (s Schema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.DisplayName != nil {
		objectMap["displayName"] = s.DisplayName
	}
	if s.Description != nil {
		objectMap["description"] = s.Description
	}
	if s.Columns != nil {
		objectMap["columns"] = s.Columns
	}
	return json.Marshal(objectMap)
}

// SearchGetSchemaResponse the get schema operation response.
type SearchGetSchemaResponse struct {
	autorest.Response `json:"-"`
	// Metadata - The metadata from search results.
	Metadata *SearchMetadata `json:"metadata,omitempty"`
	// Value - The array of result values.
	Value *[]SearchSchemaValue `json:"value,omitempty"`
}

// SearchMetadata metadata for search results.
type SearchMetadata struct {
	// SearchID - The request id of the search.
	SearchID *string `json:"requestId,omitempty"`
	// ResultType - The search result type.
	ResultType *string `json:"resultType,omitempty"`
	// Total - The total number of search results.
	Total *int64 `json:"total,omitempty"`
	// Top - The number of top search results.
	Top *int64 `json:"top,omitempty"`
	// ID - The id of the search results request.
	ID *string `json:"id,omitempty"`
	// CoreSummaries - The core summaries.
	CoreSummaries *[]CoreSummary `json:"coreSummaries,omitempty"`
	// Status - The status of the search results.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time for the search.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdated - The time of last update.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// ETag - The ETag of the search results.
	ETag *string `json:"eTag,omitempty"`
	// Sort - How the results are sorted.
	Sort *[]SearchSort `json:"sort,omitempty"`
	// RequestTime - The request time.
	RequestTime *int64 `json:"requestTime,omitempty"`
	// AggregatedValueField - The aggregated value field.
	AggregatedValueField *string `json:"aggregatedValueField,omitempty"`
	// AggregatedGroupingFields - The aggregated grouping fields.
	AggregatedGroupingFields *string `json:"aggregatedGroupingFields,omitempty"`
	// Sum - The sum of all aggregates returned in the result set.
	Sum *int64 `json:"sum,omitempty"`
	// Max - The max of all aggregates returned in the result set.
	Max *int64 `json:"max,omitempty"`
	// Schema - The schema.
	Schema *SearchMetadataSchema `json:"schema,omitempty"`
}

// SearchMetadataSchema schema metadata for search.
type SearchMetadataSchema struct {
	// Name - The name of the metadata schema.
	Name *string `json:"name,omitempty"`
	// Version - The version of the metadata schema.
	Version *int32 `json:"version,omitempty"`
}

// SearchResults parameters of the search job that initiated this table.
type SearchResults struct {
	// Query - Search job query.
	Query *string `json:"query,omitempty"`
	// Description - Search job Description.
	Description *string `json:"description,omitempty"`
	// Limit - Limit the search job to return up to specified number of rows.
	Limit *int32 `json:"limit,omitempty"`
	// StartSearchTime - The timestamp to start the search from (UTC)
	StartSearchTime *date.Time `json:"startSearchTime,omitempty"`
	// EndSearchTime - The timestamp to end the search by (UTC)
	EndSearchTime *date.Time `json:"endSearchTime,omitempty"`
	// SourceTable - READ-ONLY; The table used in the search job.
	SourceTable *string `json:"sourceTable,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchResults.
func (sr SearchResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Query != nil {
		objectMap["query"] = sr.Query
	}
	if sr.Description != nil {
		objectMap["description"] = sr.Description
	}
	if sr.Limit != nil {
		objectMap["limit"] = sr.Limit
	}
	if sr.StartSearchTime != nil {
		objectMap["startSearchTime"] = sr.StartSearchTime
	}
	if sr.EndSearchTime != nil {
		objectMap["endSearchTime"] = sr.EndSearchTime
	}
	return json.Marshal(objectMap)
}

// SearchSchemaValue value object for schema results.
type SearchSchemaValue struct {
	// Name - The name of the schema.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the schema.
	DisplayName *string `json:"displayName,omitempty"`
	// Type - The type.
	Type *string `json:"type,omitempty"`
	// Indexed - The boolean that indicates the field is searchable as free text.
	Indexed *bool `json:"indexed,omitempty"`
	// Stored - The boolean that indicates whether or not the field is stored.
	Stored *bool `json:"stored,omitempty"`
	// Facet - The boolean that indicates whether or not the field is a facet.
	Facet *bool `json:"facet,omitempty"`
	// OwnerType - The array of workflows containing the field.
	OwnerType *[]string `json:"ownerType,omitempty"`
}

// SearchSort the sort parameters for search.
type SearchSort struct {
	// Name - The name of the field the search query is sorted on.
	Name *string `json:"name,omitempty"`
	// Order - The sort order of the search. Possible values include: 'Asc', 'Desc'
	Order SearchSortEnum `json:"order,omitempty"`
}

// SharedKeys the shared keys for a workspace.
type SharedKeys struct {
	autorest.Response `json:"-"`
	// PrimarySharedKey - The primary shared key of a workspace.
	PrimarySharedKey *string `json:"primarySharedKey,omitempty"`
	// SecondarySharedKey - The secondary shared key of a workspace.
	SecondarySharedKey *string `json:"secondarySharedKey,omitempty"`
}

// StorageAccount describes a storage account connection.
type StorageAccount struct {
	// ID - The Azure Resource Manager ID of the storage account resource.
	ID *string `json:"id,omitempty"`
	// Key - The storage account key.
	Key *string `json:"key,omitempty"`
}

// StorageInsight the top level storage insight resource container.
type StorageInsight struct {
	autorest.Response `json:"-"`
	// StorageInsightProperties - Storage insight properties.
	*StorageInsightProperties `json:"properties,omitempty"`
	// ETag - The ETag of the storage insight.
	ETag *string `json:"eTag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageInsight.
func (si StorageInsight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.StorageInsightProperties != nil {
		objectMap["properties"] = si.StorageInsightProperties
	}
	if si.ETag != nil {
		objectMap["eTag"] = si.ETag
	}
	if si.Tags != nil {
		objectMap["tags"] = si.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageInsight struct.
func (si *StorageInsight) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageInsightProperties StorageInsightProperties
				err = json.Unmarshal(*v, &storageInsightProperties)
				if err != nil {
					return err
				}
				si.StorageInsightProperties = &storageInsightProperties
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				si.ETag = &eTag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				si.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				si.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				si.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				si.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageInsightListResult the list storage insights operation response.
type StorageInsightListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of storage insight items.
	Value *[]StorageInsight `json:"value,omitempty"`
	// OdataNextLink - The link (url) to the next page of results.
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// StorageInsightListResultIterator provides access to a complete listing of StorageInsight values.
type StorageInsightListResultIterator struct {
	i    int
	page StorageInsightListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageInsightListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageInsightListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageInsightListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageInsightListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageInsightListResultIterator) Response() StorageInsightListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageInsightListResultIterator) Value() StorageInsight {
	if !iter.page.NotDone() {
		return StorageInsight{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageInsightListResultIterator type.
func NewStorageInsightListResultIterator(page StorageInsightListResultPage) StorageInsightListResultIterator {
	return StorageInsightListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (silr StorageInsightListResult) IsEmpty() bool {
	return silr.Value == nil || len(*silr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (silr StorageInsightListResult) hasNextLink() bool {
	return silr.OdataNextLink != nil && len(*silr.OdataNextLink) != 0
}

// storageInsightListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (silr StorageInsightListResult) storageInsightListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !silr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(silr.OdataNextLink)))
}

// StorageInsightListResultPage contains a page of StorageInsight values.
type StorageInsightListResultPage struct {
	fn   func(context.Context, StorageInsightListResult) (StorageInsightListResult, error)
	silr StorageInsightListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageInsightListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageInsightListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.silr)
		if err != nil {
			return err
		}
		page.silr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageInsightListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageInsightListResultPage) NotDone() bool {
	return !page.silr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageInsightListResultPage) Response() StorageInsightListResult {
	return page.silr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageInsightListResultPage) Values() []StorageInsight {
	if page.silr.IsEmpty() {
		return nil
	}
	return *page.silr.Value
}

// Creates a new instance of the StorageInsightListResultPage type.
func NewStorageInsightListResultPage(cur StorageInsightListResult, getNextPage func(context.Context, StorageInsightListResult) (StorageInsightListResult, error)) StorageInsightListResultPage {
	return StorageInsightListResultPage{
		fn:   getNextPage,
		silr: cur,
	}
}

// StorageInsightProperties storage insight properties.
type StorageInsightProperties struct {
	// Containers - The names of the blob containers that the workspace should read
	Containers *[]string `json:"containers,omitempty"`
	// Tables - The names of the Azure tables that the workspace should read
	Tables *[]string `json:"tables,omitempty"`
	// StorageAccount - The storage account connection details
	StorageAccount *StorageAccount `json:"storageAccount,omitempty"`
	// Status - READ-ONLY; The status of the storage insight
	Status *StorageInsightStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageInsightProperties.
func (sip StorageInsightProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sip.Containers != nil {
		objectMap["containers"] = sip.Containers
	}
	if sip.Tables != nil {
		objectMap["tables"] = sip.Tables
	}
	if sip.StorageAccount != nil {
		objectMap["storageAccount"] = sip.StorageAccount
	}
	return json.Marshal(objectMap)
}

// StorageInsightStatus the status of the storage insight.
type StorageInsightStatus struct {
	// State - The state of the storage insight connection to the workspace. Possible values include: 'OK', 'ERROR'
	State StorageInsightState `json:"state,omitempty"`
	// Description - Description of the state of the storage insight.
	Description *string `json:"description,omitempty"`
}

// SystemData read only system data
type SystemData struct {
	// CreatedBy - An identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	CreatedByType IdentityType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC)
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - An identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	LastModifiedByType IdentityType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// SystemDataModel metadata pertaining to creation and last modification of the resource.
type SystemDataModel struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// Table workspace data table definition.
type Table struct {
	autorest.Response `json:"-"`
	// TableProperties - Table's properties.
	*TableProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemDataModel `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Table.
func (t Table) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TableProperties != nil {
		objectMap["properties"] = t.TableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Table struct.
func (t *Table) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableProperties TableProperties
				err = json.Unmarshal(*v, &tableProperties)
				if err != nil {
					return err
				}
				t.TableProperties = &tableProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemDataModel
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				t.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TableProperties table properties.
type TableProperties struct {
	// RetentionInDays - The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// TotalRetentionInDays - The table total retention in days, between 4 and 2555. Setting this property to -1 will default to table retention.
	TotalRetentionInDays *int32 `json:"totalRetentionInDays,omitempty"`
	// ArchiveRetentionInDays - READ-ONLY; The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays)
	ArchiveRetentionInDays *int32 `json:"archiveRetentionInDays,omitempty"`
	// SearchResults - Parameters of the search job that initiated this table.
	SearchResults *SearchResults `json:"searchResults,omitempty"`
	// RestoredLogs - Parameters of the restore operation that initiated this table.
	RestoredLogs *RestoredLogs `json:"restoredLogs,omitempty"`
	// ResultStatistics - Search job execution statistics.
	ResultStatistics *ResultStatistics `json:"resultStatistics,omitempty"`
	// Plan - Instruct the system how to handle and charge the logs ingested to this table. Possible values include: 'Basic', 'Analytics'
	Plan TablePlanEnum `json:"plan,omitempty"`
	// LastPlanModifiedDate - READ-ONLY; The timestamp that table plan was last modified (UTC).
	LastPlanModifiedDate *string `json:"lastPlanModifiedDate,omitempty"`
	// Schema - Table schema.
	Schema *Schema `json:"schema,omitempty"`
	// ProvisioningState - READ-ONLY; Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded. Possible values include: 'ProvisioningStateEnumUpdating', 'ProvisioningStateEnumInProgress', 'ProvisioningStateEnumSucceeded'
	ProvisioningState ProvisioningStateEnum `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for TableProperties.
func (tp TableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.RetentionInDays != nil {
		objectMap["retentionInDays"] = tp.RetentionInDays
	}
	if tp.TotalRetentionInDays != nil {
		objectMap["totalRetentionInDays"] = tp.TotalRetentionInDays
	}
	if tp.SearchResults != nil {
		objectMap["searchResults"] = tp.SearchResults
	}
	if tp.RestoredLogs != nil {
		objectMap["restoredLogs"] = tp.RestoredLogs
	}
	if tp.ResultStatistics != nil {
		objectMap["resultStatistics"] = tp.ResultStatistics
	}
	if tp.Plan != "" {
		objectMap["plan"] = tp.Plan
	}
	if tp.Schema != nil {
		objectMap["schema"] = tp.Schema
	}
	return json.Marshal(objectMap)
}

// TablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TablesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TablesClient) (Table, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TablesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TablesCreateOrUpdateFuture.Result.
func (future *TablesCreateOrUpdateFuture) result(client TablesClient) (t Table, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.TablesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		t.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.TablesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateOrUpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.TablesCreateOrUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TablesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TablesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TablesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TablesDeleteFuture.Result.
func (future *TablesDeleteFuture) result(client TablesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.TablesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.TablesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TablesListResult the list tables operation response.
type TablesListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of data tables.
	Value *[]Table `json:"value,omitempty"`
}

// TablesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TablesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TablesClient) (Table, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TablesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TablesUpdateFuture.Result.
func (future *TablesUpdateFuture) result(client TablesClient) (t Table, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.TablesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		t.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.TablesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.TablesUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Tag a tag of a saved search.
type Tag struct {
	// Name - The tag name.
	Name *string `json:"name,omitempty"`
	// Value - The tag value.
	Value *string `json:"value,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// QueryPack instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UsageMetric a metric describing the usage of a resource.
type UsageMetric struct {
	// Name - The name of the metric.
	Name *MetricName `json:"name,omitempty"`
	// Unit - The units used for the metric.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - The quota limit for the metric.
	Limit *float64 `json:"limit,omitempty"`
	// NextResetTime - The time that the metric's value will reset.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// QuotaPeriod - The quota period that determines the length of time between value resets.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
}

// UserIdentityProperties user assigned identity properties.
type UserIdentityProperties struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserIdentityProperties.
func (uip UserIdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Workspace the top level Workspace resource container.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - Workspace properties.
	*WorkspaceProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemDataModel `json:"systemData,omitempty"`
	// ETag - The ETag of the workspace.
	ETag *string `json:"eTag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.ETag != nil {
		objectMap["eTag"] = w.ETag
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemDataModel
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				w.ETag = &eTag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceCapping the daily volume cap for ingestion.
type WorkspaceCapping struct {
	// DailyQuotaGb - The workspace daily quota for ingestion.
	DailyQuotaGb *float64 `json:"dailyQuotaGb,omitempty"`
	// QuotaNextResetTime - READ-ONLY; The time when the quota will be rest.
	QuotaNextResetTime *string `json:"quotaNextResetTime,omitempty"`
	// DataIngestionStatus - READ-ONLY; The status of data ingestion for this workspace. Possible values include: 'RespectQuota', 'ForceOn', 'ForceOff', 'OverQuota', 'SubscriptionSuspended', 'ApproachingQuota'
	DataIngestionStatus DataIngestionStatus `json:"dataIngestionStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceCapping.
func (wc WorkspaceCapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.DailyQuotaGb != nil {
		objectMap["dailyQuotaGb"] = wc.DailyQuotaGb
	}
	return json.Marshal(objectMap)
}

// WorkspaceFeatures workspace features.
type WorkspaceFeatures struct {
	// EnableDataExport - Flag that indicate if data should be exported.
	EnableDataExport *bool `json:"enableDataExport,omitempty"`
	// ImmediatePurgeDataOn30Days - Flag that describes if we want to remove the data after 30 days.
	ImmediatePurgeDataOn30Days *bool `json:"immediatePurgeDataOn30Days,omitempty"`
	// EnableLogAccessUsingOnlyResourcePermissions - Flag that indicate which permission to use - resource or workspace or both.
	EnableLogAccessUsingOnlyResourcePermissions *bool `json:"enableLogAccessUsingOnlyResourcePermissions,omitempty"`
	// ClusterResourceID - Dedicated LA cluster resourceId that is linked to the workspaces.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`
	// DisableLocalAuth - Disable Non-AAD based Auth.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
}

// WorkspaceListManagementGroupsResult the list workspace management groups operation response.
type WorkspaceListManagementGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of management groups attached to the workspace.
	Value *[]ManagementGroup `json:"value,omitempty"`
}

// WorkspaceListResult the list workspaces operation response.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workspaces.
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspaceListUsagesResult the list workspace usages operation response.
type WorkspaceListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of usage metrics for a workspace.
	Value *[]UsageMetric `json:"value,omitempty"`
}

// WorkspacePatch the top level Workspace resource container.
type WorkspacePatch struct {
	// WorkspaceProperties - Workspace properties.
	*WorkspaceProperties `json:"properties,omitempty"`
	// Tags - Resource tags. Optional.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatch.
func (wp WorkspacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.WorkspaceProperties != nil {
		objectMap["properties"] = wp.WorkspaceProperties
	}
	if wp.Tags != nil {
		objectMap["tags"] = wp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspacePatch struct.
func (wp *WorkspacePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				wp.WorkspaceProperties = &workspaceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wp.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wp.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceProperties workspace properties.
type WorkspaceProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the workspace. Possible values include: 'WorkspaceEntityStatusCreating', 'WorkspaceEntityStatusSucceeded', 'WorkspaceEntityStatusFailed', 'WorkspaceEntityStatusCanceled', 'WorkspaceEntityStatusDeleting', 'WorkspaceEntityStatusProvisioningAccount', 'WorkspaceEntityStatusUpdating'
	ProvisioningState WorkspaceEntityStatus `json:"provisioningState,omitempty"`
	// CustomerID - READ-ONLY; This is a read-only property. Represents the ID associated with the workspace.
	CustomerID *string `json:"customerId,omitempty"`
	// Sku - The SKU of the workspace.
	Sku *WorkspaceSku `json:"sku,omitempty"`
	// RetentionInDays - The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// WorkspaceCapping - The daily volume cap for ingestion.
	WorkspaceCapping *WorkspaceCapping `json:"workspaceCapping,omitempty"`
	// CreatedDate - READ-ONLY; Workspace creation date.
	CreatedDate *string `json:"createdDate,omitempty"`
	// ModifiedDate - READ-ONLY; Workspace modification date.
	ModifiedDate *string `json:"modifiedDate,omitempty"`
	// PublicNetworkAccessForIngestion - The network access type for accessing Log Analytics ingestion. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccessForIngestion PublicNetworkAccessType `json:"publicNetworkAccessForIngestion,omitempty"`
	// PublicNetworkAccessForQuery - The network access type for accessing Log Analytics query. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccessForQuery PublicNetworkAccessType `json:"publicNetworkAccessForQuery,omitempty"`
	// ForceCmkForQuery - Indicates whether customer managed storage is mandatory for query management.
	ForceCmkForQuery *bool `json:"forceCmkForQuery,omitempty"`
	// PrivateLinkScopedResources - READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources *[]PrivateLinkScopedResource `json:"privateLinkScopedResources,omitempty"`
	// Features - Workspace features.
	Features *WorkspaceFeatures `json:"features,omitempty"`
	// DefaultDataCollectionRuleResourceID - The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
	DefaultDataCollectionRuleResourceID *string `json:"defaultDataCollectionRuleResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Sku != nil {
		objectMap["sku"] = wp.Sku
	}
	if wp.RetentionInDays != nil {
		objectMap["retentionInDays"] = wp.RetentionInDays
	}
	if wp.WorkspaceCapping != nil {
		objectMap["workspaceCapping"] = wp.WorkspaceCapping
	}
	if wp.PublicNetworkAccessForIngestion != "" {
		objectMap["publicNetworkAccessForIngestion"] = wp.PublicNetworkAccessForIngestion
	}
	if wp.PublicNetworkAccessForQuery != "" {
		objectMap["publicNetworkAccessForQuery"] = wp.PublicNetworkAccessForQuery
	}
	if wp.ForceCmkForQuery != nil {
		objectMap["forceCmkForQuery"] = wp.ForceCmkForQuery
	}
	if wp.Features != nil {
		objectMap["features"] = wp.Features
	}
	if wp.DefaultDataCollectionRuleResourceID != nil {
		objectMap["defaultDataCollectionRuleResourceId"] = wp.DefaultDataCollectionRuleResourceID
	}
	return json.Marshal(objectMap)
}

// WorkspacePurgeBody describes the body of a purge request for an App Insights Workspace
type WorkspacePurgeBody struct {
	// Table - Table from which to purge data.
	Table *string `json:"table,omitempty"`
	// Filters - The set of columns and filters (queries) to run over them to purge the resulting data.
	Filters *[]WorkspacePurgeBodyFilters `json:"filters,omitempty"`
}

// WorkspacePurgeBodyFilters user-defined filters to return data which will be purged from the table.
type WorkspacePurgeBodyFilters struct {
	// Column - The column of the table over which the given query should run
	Column *string `json:"column,omitempty"`
	// Operator - A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would in a KQL query.
	Operator *string `json:"operator,omitempty"`
	// Value - the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >= '2017-09-01') or array of values.
	Value interface{} `json:"value,omitempty"`
	// Key - When filtering over custom dimensions, this key will be used as the name of the custom dimension.
	Key *string `json:"key,omitempty"`
}

// WorkspacePurgeResponse response containing operationId for a specific purge action.
type WorkspacePurgeResponse struct {
	autorest.Response `json:"-"`
	// OperationID - Id to use when querying for status for a particular purge operation.
	OperationID *string `json:"operationId,omitempty"`
}

// WorkspacePurgeStatusResponse response containing status for a specific purge operation.
type WorkspacePurgeStatusResponse struct {
	autorest.Response `json:"-"`
	// Status - Status of the operation represented by the requested Id. Possible values include: 'Pending', 'Completed'
	Status PurgeState `json:"status,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesCreateOrUpdateFuture.Result.
func (future *WorkspacesCreateOrUpdateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDeleteFuture.Result.
func (future *WorkspacesDeleteFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("operationalinsights.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceSku the SKU (tier) of a workspace.
type WorkspaceSku struct {
	// Name - The name of the SKU. Possible values include: 'WorkspaceSkuNameEnumFree', 'WorkspaceSkuNameEnumStandard', 'WorkspaceSkuNameEnumPremium', 'WorkspaceSkuNameEnumPerNode', 'WorkspaceSkuNameEnumPerGB2018', 'WorkspaceSkuNameEnumStandalone', 'WorkspaceSkuNameEnumCapacityReservation', 'WorkspaceSkuNameEnumLACluster'
	Name WorkspaceSkuNameEnum `json:"name,omitempty"`
	// CapacityReservationLevel - The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
	CapacityReservationLevel *int32 `json:"capacityReservationLevel,omitempty"`
	// LastSkuUpdate - READ-ONLY; The last time when the sku was updated.
	LastSkuUpdate *string `json:"lastSkuUpdate,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSku.
func (ws WorkspaceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.Name != "" {
		objectMap["name"] = ws.Name
	}
	if ws.CapacityReservationLevel != nil {
		objectMap["capacityReservationLevel"] = ws.CapacityReservationLevel
	}
	return json.Marshal(objectMap)
}
