package metrics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DefinitionsClient is the monitor Management Client
type DefinitionsClient struct {
	BaseClient
}

// NewDefinitionsClient creates an instance of the DefinitionsClient client.
func NewDefinitionsClient(subscriptionID string) DefinitionsClient {
	return NewDefinitionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDefinitionsClientWithBaseURI creates an instance of the DefinitionsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) DefinitionsClient {
	return DefinitionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List lists the metric definitions for the resource.
// Parameters:
// resourceURI - the identifier of the resource.
// metricnamespace - metric namespace where the metrics you want reside.
func (client DefinitionsClient) List(ctx context.Context, resourceURI string, metricnamespace string) (result DefinitionCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DefinitionsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, resourceURI, metricnamespace)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.DefinitionsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.DefinitionsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.DefinitionsClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client DefinitionsClient) ListPreparer(ctx context.Context, resourceURI string, metricnamespace string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceUri": resourceURI,
	}

	const APIVersion = "2021-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(metricnamespace) > 0 {
		queryParameters["metricnamespace"] = autorest.Encode("query", metricnamespace)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceUri}/providers/Microsoft.Insights/metricDefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client DefinitionsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client DefinitionsClient) ListResponder(resp *http.Response) (result DefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAtSubscriptionScope lists the metric definitions for the subscription.
// Parameters:
// region - the region where the metrics you want reside.
// metricnamespace - metric namespace where the metrics you want reside.
func (client DefinitionsClient) ListAtSubscriptionScope(ctx context.Context, region string, metricnamespace string) (result SubscriptionScopeMetricDefinitionCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DefinitionsClient.ListAtSubscriptionScope")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("metrics.DefinitionsClient", "ListAtSubscriptionScope", err.Error())
	}

	req, err := client.ListAtSubscriptionScopePreparer(ctx, region, metricnamespace)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.DefinitionsClient", "ListAtSubscriptionScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAtSubscriptionScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.DefinitionsClient", "ListAtSubscriptionScope", resp, "Failure sending request")
		return
	}

	result, err = client.ListAtSubscriptionScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.DefinitionsClient", "ListAtSubscriptionScope", resp, "Failure responding to request")
		return
	}

	return
}

// ListAtSubscriptionScopePreparer prepares the ListAtSubscriptionScope request.
func (client DefinitionsClient) ListAtSubscriptionScopePreparer(ctx context.Context, region string, metricnamespace string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"region":      autorest.Encode("query", region),
	}
	if len(metricnamespace) > 0 {
		queryParameters["metricnamespace"] = autorest.Encode("query", metricnamespace)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metricDefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAtSubscriptionScopeSender sends the ListAtSubscriptionScope request. The method will close the
// http.Response Body if it receives an error.
func (client DefinitionsClient) ListAtSubscriptionScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAtSubscriptionScopeResponder handles the response to the ListAtSubscriptionScope request. The method always
// closes the http.Response Body.
func (client DefinitionsClient) ListAtSubscriptionScopeResponder(resp *http.Response) (result SubscriptionScopeMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
