package filesystemapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/datalake/store/2015-10-01-preview/filesystem"
	"github.com/Azure/go-autorest/autorest"
	"io"
)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Append(ctx context.Context, accountName string, directFilePath string, streamContents io.ReadCloser, offset *int64) (result autorest.Response, err error)
	CheckAccess(ctx context.Context, accountName string, pathParameter string, fsaction string) (result autorest.Response, err error)
	Concat(ctx context.Context, accountName string, destinationPath string, sources []string) (result autorest.Response, err error)
	ConcurrentAppend(ctx context.Context, accountName string, filePath string, streamContents io.ReadCloser, appendMode filesystem.AppendModeType) (result autorest.Response, err error)
	Create(ctx context.Context, accountName string, directFilePath string, streamContents io.ReadCloser, overwrite *bool) (result autorest.Response, err error)
	Delete(ctx context.Context, accountName string, filePath string, recursive *bool) (result filesystem.FileOperationResult, err error)
	Flush(ctx context.Context, accountName string, flushFilePath string) (result autorest.Response, err error)
	GetACLStatus(ctx context.Context, accountName string, ACLFilePath string) (result filesystem.ACLStatusResult, err error)
	GetContentSummary(ctx context.Context, accountName string, getContentSummaryFilePath string) (result filesystem.ContentSummaryResult, err error)
	GetFileStatus(ctx context.Context, accountName string, getFilePath string) (result filesystem.FileStatusResult, err error)
	ListFileStatus(ctx context.Context, accountName string, listFilePath string, listSize *int32, listAfter string, listBefore string) (result filesystem.FileStatusesResult, err error)
	Mkdirs(ctx context.Context, accountName string, pathParameter string) (result filesystem.FileOperationResult, err error)
	ModifyACLEntries(ctx context.Context, accountName string, modifyACLFilePath string, aclspec string) (result autorest.Response, err error)
	MsConcat(ctx context.Context, accountName string, msConcatDestinationPath string, streamContents io.ReadCloser, deleteSourceDirectory *bool) (result autorest.Response, err error)
	Open(ctx context.Context, accountName string, directFilePath string, length *int64, offset *int64) (result filesystem.ReadCloser, err error)
	RemoveACL(ctx context.Context, accountName string, ACLFilePath string) (result autorest.Response, err error)
	RemoveACLEntries(ctx context.Context, accountName string, removeACLFilePath string, aclspec string) (result autorest.Response, err error)
	RemoveDefaultACL(ctx context.Context, accountName string, defaultACLFilePath string) (result autorest.Response, err error)
	Rename(ctx context.Context, accountName string, renameFilePath string, destination string) (result filesystem.FileOperationResult, err error)
	SetACL(ctx context.Context, accountName string, setACLFilePath string, aclspec string) (result autorest.Response, err error)
	SetFileExpiry(ctx context.Context, accountName string, filePath string, expiryOption filesystem.ExpiryOptionType, expireTime *int64) (result autorest.Response, err error)
	SetOwner(ctx context.Context, accountName string, setOwnerFilePath string, owner string, group string) (result autorest.Response, err error)
	SetPermission(ctx context.Context, accountName string, setPermissionFilePath string, permission string) (result autorest.Response, err error)
}

var _ ClientAPI = (*filesystem.Client)(nil)
