package dtl

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PolicySetsClient is the the DevTest Labs Client.
type PolicySetsClient struct {
	BaseClient
}

// NewPolicySetsClient creates an instance of the PolicySetsClient client.
func NewPolicySetsClient(subscriptionID string) PolicySetsClient {
	return NewPolicySetsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPolicySetsClientWithBaseURI creates an instance of the PolicySetsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewPolicySetsClientWithBaseURI(baseURI string, subscriptionID string) PolicySetsClient {
	return PolicySetsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// EvaluatePolicies evaluates lab policy.
// Parameters:
// resourceGroupName - the name of the resource group.
// labName - the name of the lab.
// name - the name of the policy set.
// evaluatePoliciesRequest - request body for evaluating a policy set.
func (client PolicySetsClient) EvaluatePolicies(ctx context.Context, resourceGroupName string, labName string, name string, evaluatePoliciesRequest EvaluatePoliciesRequest) (result EvaluatePoliciesResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicySetsClient.EvaluatePolicies")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.EvaluatePoliciesPreparer(ctx, resourceGroupName, labName, name, evaluatePoliciesRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.PolicySetsClient", "EvaluatePolicies", nil, "Failure preparing request")
		return
	}

	resp, err := client.EvaluatePoliciesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dtl.PolicySetsClient", "EvaluatePolicies", resp, "Failure sending request")
		return
	}

	result, err = client.EvaluatePoliciesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.PolicySetsClient", "EvaluatePolicies", resp, "Failure responding to request")
		return
	}

	return
}

// EvaluatePoliciesPreparer prepares the EvaluatePolicies request.
func (client PolicySetsClient) EvaluatePoliciesPreparer(ctx context.Context, resourceGroupName string, labName string, name string, evaluatePoliciesRequest EvaluatePoliciesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{name}/evaluatePolicies", pathParameters),
		autorest.WithJSON(evaluatePoliciesRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// EvaluatePoliciesSender sends the EvaluatePolicies request. The method will close the
// http.Response Body if it receives an error.
func (client PolicySetsClient) EvaluatePoliciesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// EvaluatePoliciesResponder handles the response to the EvaluatePolicies request. The method always
// closes the http.Response Body.
func (client PolicySetsClient) EvaluatePoliciesResponder(resp *http.Response) (result EvaluatePoliciesResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
