package costmanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ForecastClient is the client for the Forecast methods of the Costmanagement service.
type ForecastClient struct {
	BaseClient
}

// NewForecastClient creates an instance of the ForecastClient client.
func NewForecastClient(subscriptionID string) ForecastClient {
	return NewForecastClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewForecastClientWithBaseURI creates an instance of the ForecastClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewForecastClientWithBaseURI(baseURI string, subscriptionID string) ForecastClient {
	return ForecastClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ExternalCloudProviderUsage lists the forecast charges for external cloud provider type defined.
// Parameters:
// externalCloudProviderType - the external cloud provider type associated with dimension/query operations.
// This includes 'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated
// account.
// externalCloudProviderID - this can be '{externalSubscriptionId}' for linked account or
// '{externalBillingAccountId}' for consolidated account used with dimension/query operations.
// parameters - parameters supplied to the CreateOrUpdate Forecast Config operation.
// filter - may be used to filter forecasts by properties/usageDate (Utc time), properties/chargeType or
// properties/grain. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support
// 'ne', 'or', or 'not'.
func (client ForecastClient) ExternalCloudProviderUsage(ctx context.Context, externalCloudProviderType ExternalCloudProviderType, externalCloudProviderID string, parameters ForecastDefinition, filter string) (result QueryResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ForecastClient.ExternalCloudProviderUsage")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TimePeriod", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.TimePeriod.From", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.TimePeriod.To", Name: validation.Null, Rule: true, Chain: nil},
				}},
				{Target: "parameters.Dataset", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "parameters.Dataset.Grouping", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.Dataset.Grouping", Name: validation.MaxItems, Rule: 2, Chain: nil}}},
						{Target: "parameters.Dataset.Filter", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.And", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.And", Name: validation.MinItems, Rule: 2, Chain: nil}}},
								{Target: "parameters.Dataset.Filter.Or", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Or", Name: validation.MinItems, Rule: 2, Chain: nil}}},
								{Target: "parameters.Dataset.Filter.Dimensions", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Dimensions.Name", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Dimensions.Operator", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Dimensions.Values", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Dimensions.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
									}},
								{Target: "parameters.Dataset.Filter.Tags", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Tags.Name", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Tags.Operator", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Tags.Values", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Tags.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
									}},
							}},
					}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ForecastClient", "ExternalCloudProviderUsage", err.Error())
	}

	req, err := client.ExternalCloudProviderUsagePreparer(ctx, externalCloudProviderType, externalCloudProviderID, parameters, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ForecastClient", "ExternalCloudProviderUsage", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExternalCloudProviderUsageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ForecastClient", "ExternalCloudProviderUsage", resp, "Failure sending request")
		return
	}

	result, err = client.ExternalCloudProviderUsageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ForecastClient", "ExternalCloudProviderUsage", resp, "Failure responding to request")
		return
	}

	return
}

// ExternalCloudProviderUsagePreparer prepares the ExternalCloudProviderUsage request.
func (client ForecastClient) ExternalCloudProviderUsagePreparer(ctx context.Context, externalCloudProviderType ExternalCloudProviderType, externalCloudProviderID string, parameters ForecastDefinition, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"externalCloudProviderId":   autorest.Encode("path", externalCloudProviderID),
		"externalCloudProviderType": autorest.Encode("path", externalCloudProviderType),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/forecast", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExternalCloudProviderUsageSender sends the ExternalCloudProviderUsage request. The method will close the
// http.Response Body if it receives an error.
func (client ForecastClient) ExternalCloudProviderUsageSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ExternalCloudProviderUsageResponder handles the response to the ExternalCloudProviderUsage request. The method always
// closes the http.Response Body.
func (client ForecastClient) ExternalCloudProviderUsageResponder(resp *http.Response) (result QueryResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Usage lists the forecast charges for scope defined.
// Parameters:
// scope - the scope associated with forecast operations. This includes '/subscriptions/{subscriptionId}/' for
// subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
// scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
// '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department
// scope,
// '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
// for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for
// Management Group scope,
// '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for
// billingProfile scope,
// '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
// for invoiceSection scope, and
// '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
// partners.
// parameters - parameters supplied to the CreateOrUpdate Forecast Config operation.
// filter - may be used to filter forecasts by properties/usageDate (Utc time), properties/chargeType or
// properties/grain. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support
// 'ne', 'or', or 'not'.
func (client ForecastClient) Usage(ctx context.Context, scope string, parameters ForecastDefinition, filter string) (result QueryResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ForecastClient.Usage")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TimePeriod", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.TimePeriod.From", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.TimePeriod.To", Name: validation.Null, Rule: true, Chain: nil},
				}},
				{Target: "parameters.Dataset", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "parameters.Dataset.Grouping", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.Dataset.Grouping", Name: validation.MaxItems, Rule: 2, Chain: nil}}},
						{Target: "parameters.Dataset.Filter", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.And", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.And", Name: validation.MinItems, Rule: 2, Chain: nil}}},
								{Target: "parameters.Dataset.Filter.Or", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Or", Name: validation.MinItems, Rule: 2, Chain: nil}}},
								{Target: "parameters.Dataset.Filter.Dimensions", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Dimensions.Name", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Dimensions.Operator", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Dimensions.Values", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Dimensions.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
									}},
								{Target: "parameters.Dataset.Filter.Tags", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Tags.Name", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Tags.Operator", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.Dataset.Filter.Tags.Values", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "parameters.Dataset.Filter.Tags.Values", Name: validation.MinItems, Rule: 1, Chain: nil}}},
									}},
							}},
					}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ForecastClient", "Usage", err.Error())
	}

	req, err := client.UsagePreparer(ctx, scope, parameters, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ForecastClient", "Usage", nil, "Failure preparing request")
		return
	}

	resp, err := client.UsageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ForecastClient", "Usage", resp, "Failure sending request")
		return
	}

	result, err = client.UsageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ForecastClient", "Usage", resp, "Failure responding to request")
		return
	}

	return
}

// UsagePreparer prepares the Usage request.
func (client ForecastClient) UsagePreparer(ctx context.Context, scope string, parameters ForecastDefinition, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.CostManagement/forecast", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UsageSender sends the Usage request. The method will close the
// http.Response Body if it receives an error.
func (client ForecastClient) UsageSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UsageResponder handles the response to the Usage request. The method always
// closes the http.Response Body.
func (client ForecastClient) UsageResponder(resp *http.Response) (result QueryResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
