package batch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// LocationClient is the batch Client
type LocationClient struct {
	BaseClient
}

// NewLocationClient creates an instance of the LocationClient client.
func NewLocationClient(subscriptionID string) LocationClient {
	return NewLocationClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLocationClientWithBaseURI creates an instance of the LocationClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewLocationClientWithBaseURI(baseURI string, subscriptionID string) LocationClient {
	return LocationClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailability checks whether the Batch account name is available in the specified region.
// Parameters:
// locationName - the desired region for the name check.
// parameters - properties needed to check the availability of a name.
func (client LocationClient) CheckNameAvailability(ctx context.Context, locationName string, parameters CheckNameAvailabilityParameters) (result CheckNameAvailabilityResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationClient.CheckNameAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.Type", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("batch.LocationClient", "CheckNameAvailability", err.Error())
	}

	req, err := client.CheckNameAvailabilityPreparer(ctx, locationName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "CheckNameAvailability", resp, "Failure responding to request")
		return
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client LocationClient) CheckNameAvailabilityPreparer(ctx context.Context, locationName string, parameters CheckNameAvailabilityParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/checkNameAvailability", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client LocationClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client LocationClient) CheckNameAvailabilityResponder(resp *http.Response) (result CheckNameAvailabilityResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetQuotas gets the Batch service quotas for the specified subscription at the given location.
// Parameters:
// locationName - the region for which to retrieve Batch service quotas.
func (client LocationClient) GetQuotas(ctx context.Context, locationName string) (result LocationQuota, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationClient.GetQuotas")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetQuotasPreparer(ctx, locationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "GetQuotas", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetQuotasSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "GetQuotas", resp, "Failure sending request")
		return
	}

	result, err = client.GetQuotasResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "GetQuotas", resp, "Failure responding to request")
		return
	}

	return
}

// GetQuotasPreparer prepares the GetQuotas request.
func (client LocationClient) GetQuotasPreparer(ctx context.Context, locationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetQuotasSender sends the GetQuotas request. The method will close the
// http.Response Body if it receives an error.
func (client LocationClient) GetQuotasSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetQuotasResponder handles the response to the GetQuotas request. The method always
// closes the http.Response Body.
func (client LocationClient) GetQuotasResponder(resp *http.Response) (result LocationQuota, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSupportedCloudServiceSkus gets the list of Batch supported Cloud Service VM sizes available at the given
// location.
// Parameters:
// locationName - the region for which to retrieve Batch service supported SKUs.
// maxresults - the maximum number of items to return in the response.
// filter - oData filter expression. Valid properties for filtering are "familyName".
func (client LocationClient) ListSupportedCloudServiceSkus(ctx context.Context, locationName string, maxresults *int32, filter string) (result SupportedSkusResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationClient.ListSupportedCloudServiceSkus")
		defer func() {
			sc := -1
			if result.ssr.Response.Response != nil {
				sc = result.ssr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSupportedCloudServiceSkusNextResults
	req, err := client.ListSupportedCloudServiceSkusPreparer(ctx, locationName, maxresults, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "ListSupportedCloudServiceSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedCloudServiceSkusSender(req)
	if err != nil {
		result.ssr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "ListSupportedCloudServiceSkus", resp, "Failure sending request")
		return
	}

	result.ssr, err = client.ListSupportedCloudServiceSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "ListSupportedCloudServiceSkus", resp, "Failure responding to request")
		return
	}
	if result.ssr.hasNextLink() && result.ssr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSupportedCloudServiceSkusPreparer prepares the ListSupportedCloudServiceSkus request.
func (client LocationClient) ListSupportedCloudServiceSkusPreparer(ctx context.Context, locationName string, maxresults *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if maxresults != nil {
		queryParameters["maxresults"] = autorest.Encode("query", *maxresults)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/cloudServiceSkus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedCloudServiceSkusSender sends the ListSupportedCloudServiceSkus request. The method will close the
// http.Response Body if it receives an error.
func (client LocationClient) ListSupportedCloudServiceSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSupportedCloudServiceSkusResponder handles the response to the ListSupportedCloudServiceSkus request. The method always
// closes the http.Response Body.
func (client LocationClient) ListSupportedCloudServiceSkusResponder(resp *http.Response) (result SupportedSkusResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSupportedCloudServiceSkusNextResults retrieves the next set of results, if any.
func (client LocationClient) listSupportedCloudServiceSkusNextResults(ctx context.Context, lastResults SupportedSkusResult) (result SupportedSkusResult, err error) {
	req, err := lastResults.supportedSkusResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batch.LocationClient", "listSupportedCloudServiceSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSupportedCloudServiceSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batch.LocationClient", "listSupportedCloudServiceSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSupportedCloudServiceSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "listSupportedCloudServiceSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSupportedCloudServiceSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client LocationClient) ListSupportedCloudServiceSkusComplete(ctx context.Context, locationName string, maxresults *int32, filter string) (result SupportedSkusResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationClient.ListSupportedCloudServiceSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSupportedCloudServiceSkus(ctx, locationName, maxresults, filter)
	return
}

// ListSupportedVirtualMachineSkus gets the list of Batch supported Virtual Machine VM sizes available at the given
// location.
// Parameters:
// locationName - the region for which to retrieve Batch service supported SKUs.
// maxresults - the maximum number of items to return in the response.
// filter - oData filter expression. Valid properties for filtering are "familyName".
func (client LocationClient) ListSupportedVirtualMachineSkus(ctx context.Context, locationName string, maxresults *int32, filter string) (result SupportedSkusResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationClient.ListSupportedVirtualMachineSkus")
		defer func() {
			sc := -1
			if result.ssr.Response.Response != nil {
				sc = result.ssr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSupportedVirtualMachineSkusNextResults
	req, err := client.ListSupportedVirtualMachineSkusPreparer(ctx, locationName, maxresults, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "ListSupportedVirtualMachineSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedVirtualMachineSkusSender(req)
	if err != nil {
		result.ssr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "ListSupportedVirtualMachineSkus", resp, "Failure sending request")
		return
	}

	result.ssr, err = client.ListSupportedVirtualMachineSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "ListSupportedVirtualMachineSkus", resp, "Failure responding to request")
		return
	}
	if result.ssr.hasNextLink() && result.ssr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSupportedVirtualMachineSkusPreparer prepares the ListSupportedVirtualMachineSkus request.
func (client LocationClient) ListSupportedVirtualMachineSkusPreparer(ctx context.Context, locationName string, maxresults *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if maxresults != nil {
		queryParameters["maxresults"] = autorest.Encode("query", *maxresults)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/virtualMachineSkus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedVirtualMachineSkusSender sends the ListSupportedVirtualMachineSkus request. The method will close the
// http.Response Body if it receives an error.
func (client LocationClient) ListSupportedVirtualMachineSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSupportedVirtualMachineSkusResponder handles the response to the ListSupportedVirtualMachineSkus request. The method always
// closes the http.Response Body.
func (client LocationClient) ListSupportedVirtualMachineSkusResponder(resp *http.Response) (result SupportedSkusResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSupportedVirtualMachineSkusNextResults retrieves the next set of results, if any.
func (client LocationClient) listSupportedVirtualMachineSkusNextResults(ctx context.Context, lastResults SupportedSkusResult) (result SupportedSkusResult, err error) {
	req, err := lastResults.supportedSkusResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batch.LocationClient", "listSupportedVirtualMachineSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSupportedVirtualMachineSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batch.LocationClient", "listSupportedVirtualMachineSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSupportedVirtualMachineSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "listSupportedVirtualMachineSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSupportedVirtualMachineSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client LocationClient) ListSupportedVirtualMachineSkusComplete(ctx context.Context, locationName string, maxresults *int32, filter string) (result SupportedSkusResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationClient.ListSupportedVirtualMachineSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSupportedVirtualMachineSkus(ctx, locationName, maxresults, filter)
	return
}
