package azureadexternalidentities

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/azureadexternalidentities/mgmt/2021-04-01/azureadexternalidentities"

// AvailableOperations available operations of the service
type AvailableOperations struct {
	autorest.Response `json:"-"`
	// Value - Collection of available operation details
	Value *[]OperationDetail `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// B2CResourceSKU SKU properties of the Azure AD B2C tenant. Learn more about Azure AD B2C billing at
// [aka.ms/b2cBilling](https://aka.ms/b2cBilling).
type B2CResourceSKU struct {
	// Name - The name of the SKU for the tenant. Possible values include: 'B2CResourceSKUNameStandard', 'B2CResourceSKUNamePremiumP1', 'B2CResourceSKUNamePremiumP2'
	Name B2CResourceSKUName `json:"name,omitempty"`
	// Tier - The tier of the tenant. Possible values include: 'B2CResourceSKUTierA0'
	Tier B2CResourceSKUTier `json:"tier,omitempty"`
}

// B2CTenantResource ...
type B2CTenantResource struct {
	autorest.Response `json:"-"`
	// Type - READ-ONLY; The type of the B2C tenant resource. Possible values include: 'TypeValueMicrosoftAzureActiveDirectoryb2cDirectories'
	Type TypeValue       `json:"type,omitempty"`
	Sku  *B2CResourceSKU `json:"sku,omitempty"`
	// B2CTenantResourceProperties - The Azure AD B2C tenant resource properties
	*B2CTenantResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; An identifier that represents the Azure AD B2C tenant resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the Azure AD B2C tenant resource.
	Name *string `json:"name,omitempty"`
	// Location - The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
	Location *string `json:"location,omitempty"`
	// Tags - Resource Tags
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for B2CTenantResource.
func (btr B2CTenantResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if btr.Sku != nil {
		objectMap["sku"] = btr.Sku
	}
	if btr.B2CTenantResourceProperties != nil {
		objectMap["properties"] = btr.B2CTenantResourceProperties
	}
	if btr.Location != nil {
		objectMap["location"] = btr.Location
	}
	if btr.Tags != nil {
		objectMap["tags"] = btr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for B2CTenantResource struct.
func (btr *B2CTenantResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "type":
			if v != nil {
				var typeVar TypeValue
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				btr.Type = typeVar
			}
		case "sku":
			if v != nil {
				var sku B2CResourceSKU
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				btr.Sku = &sku
			}
		case "properties":
			if v != nil {
				var b2CTenantResourceProperties B2CTenantResourceProperties
				err = json.Unmarshal(*v, &b2CTenantResourceProperties)
				if err != nil {
					return err
				}
				btr.B2CTenantResourceProperties = &b2CTenantResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				btr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				btr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				btr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				btr.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				btr.SystemData = &systemData
			}
		}
	}

	return nil
}

// B2CTenantResourceList the collection of Azure AD B2C tenant resources
type B2CTenantResourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Azure AD B2C tenant resources
	Value *[]B2CTenantResource `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for B2CTenantResourceList.
func (btrl B2CTenantResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// B2CTenantResourceProperties properties of the Azure AD B2C tenant Azure resource.
type B2CTenantResourceProperties struct {
	// BillingConfig - The billing configuration for the tenant.
	BillingConfig *B2CTenantResourcePropertiesBillingConfig `json:"billingConfig,omitempty"`
	// TenantID - An identifier of the Azure AD B2C tenant.
	TenantID *string `json:"tenantId,omitempty"`
}

// B2CTenantResourcePropertiesBillingConfig the billing configuration for the tenant.
type B2CTenantResourcePropertiesBillingConfig struct {
	// BillingType - The type of billing. Will be MAU for all new customers. If 'Auths', it can be updated to 'MAU'. Cannot be changed if value is 'MAU'. Learn more about Azure AD B2C billing at [aka.ms/b2cBilling](https://aka.ms/b2cbilling). Possible values include: 'BillingTypeMAU', 'BillingTypeAuths'
	BillingType BillingType `json:"billingType,omitempty"`
	// EffectiveStartDateUtc - READ-ONLY; The data from which the billing type took effect
	EffectiveStartDateUtc *string `json:"effectiveStartDateUtc,omitempty"`
}

// MarshalJSON is the custom marshaler for B2CTenantResourcePropertiesBillingConfig.
func (btrpC B2CTenantResourcePropertiesBillingConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if btrpC.BillingType != "" {
		objectMap["billingType"] = btrpC.BillingType
	}
	return json.Marshal(objectMap)
}

// B2CTenantsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type B2CTenantsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(B2CTenantsClient) (B2CTenantResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *B2CTenantsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for B2CTenantsCreateFuture.Result.
func (future *B2CTenantsCreateFuture) result(client B2CTenantsClient) (btr B2CTenantResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azureadexternalidentities.B2CTenantsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		btr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azureadexternalidentities.B2CTenantsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if btr.Response.Response, err = future.GetResult(sender); err == nil && btr.Response.Response.StatusCode != http.StatusNoContent {
		btr, err = client.CreateResponder(btr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "azureadexternalidentities.B2CTenantsCreateFuture", "Result", btr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// B2CTenantsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type B2CTenantsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(B2CTenantsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *B2CTenantsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for B2CTenantsDeleteFuture.Result.
func (future *B2CTenantsDeleteFuture) result(client B2CTenantsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azureadexternalidentities.B2CTenantsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azureadexternalidentities.B2CTenantsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// B2CTenantUpdateRequest the request body to update the Azure AD B2C tenant resource.
type B2CTenantUpdateRequest struct {
	Sku *B2CResourceSKU `json:"sku,omitempty"`
	// B2CTenantResourceProperties - The Azure AD B2C tenant resource properties.
	*B2CTenantResourceProperties `json:"properties,omitempty"`
	// Tags - Resource Tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for B2CTenantUpdateRequest.
func (btur B2CTenantUpdateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if btur.Sku != nil {
		objectMap["sku"] = btur.Sku
	}
	if btur.B2CTenantResourceProperties != nil {
		objectMap["properties"] = btur.B2CTenantResourceProperties
	}
	if btur.Tags != nil {
		objectMap["tags"] = btur.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for B2CTenantUpdateRequest struct.
func (btur *B2CTenantUpdateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku B2CResourceSKU
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				btur.Sku = &sku
			}
		case "properties":
			if v != nil {
				var b2CTenantResourceProperties B2CTenantResourceProperties
				err = json.Unmarshal(*v, &b2CTenantResourceProperties)
				if err != nil {
					return err
				}
				btur.B2CTenantResourceProperties = &b2CTenantResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				btur.Tags = tags
			}
		}
	}

	return nil
}

// CheckNameAvailabilityRequestBody the information required to check the availability of the name for the
// tenant.
type CheckNameAvailabilityRequestBody struct {
	// Name - The domain name to check for availability.
	Name        *string `json:"name,omitempty"`
	CountryCode *string `json:"countryCode,omitempty"`
}

// CloudError an error response for a resource management request.
type CloudError struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// CreateTenantProperties these properties are used to create the Azure AD B2C tenant. These properties are
// not part of the Azure resource.
type CreateTenantProperties struct {
	// DisplayName - The display name of the Azure AD B2C tenant.
	DisplayName *string `json:"displayName,omitempty"`
	CountryCode *string `json:"countryCode,omitempty"`
}

// CreateTenantRequestBody the information needed to create the Azure AD B2C tenant and corresponding Azure
// resource, which is used for billing purposes.
type CreateTenantRequestBody struct {
	// Location - The location in which the resource is hosted and data resides. Can be one of 'United States', 'Europe', 'Asia Pacific', or 'Australia'. Refer to [this documentation](https://aka.ms/B2CDataResidency) for more information.
	Location                           *string `json:"location,omitempty"`
	*CreateTenantRequestBodyProperties `json:"properties,omitempty"`
	Sku                                *B2CResourceSKU `json:"sku,omitempty"`
	// Tags - Resource Tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CreateTenantRequestBody.
func (ctrb CreateTenantRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctrb.Location != nil {
		objectMap["location"] = ctrb.Location
	}
	if ctrb.CreateTenantRequestBodyProperties != nil {
		objectMap["properties"] = ctrb.CreateTenantRequestBodyProperties
	}
	if ctrb.Sku != nil {
		objectMap["sku"] = ctrb.Sku
	}
	if ctrb.Tags != nil {
		objectMap["tags"] = ctrb.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateTenantRequestBody struct.
func (ctrb *CreateTenantRequestBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ctrb.Location = &location
			}
		case "properties":
			if v != nil {
				var createTenantRequestBodyProperties CreateTenantRequestBodyProperties
				err = json.Unmarshal(*v, &createTenantRequestBodyProperties)
				if err != nil {
					return err
				}
				ctrb.CreateTenantRequestBodyProperties = &createTenantRequestBodyProperties
			}
		case "sku":
			if v != nil {
				var sku B2CResourceSKU
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ctrb.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ctrb.Tags = tags
			}
		}
	}

	return nil
}

// CreateTenantRequestBodyProperties ...
type CreateTenantRequestBodyProperties struct {
	*CreateTenantProperties `json:"createTenantProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateTenantRequestBodyProperties.
func (ctrb CreateTenantRequestBodyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctrb.CreateTenantProperties != nil {
		objectMap["createTenantProperties"] = ctrb.CreateTenantProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateTenantRequestBodyProperties struct.
func (ctrb *CreateTenantRequestBodyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "createTenantProperties":
			if v != nil {
				var createTenantProperties CreateTenantProperties
				err = json.Unmarshal(*v, &createTenantProperties)
				if err != nil {
					return err
				}
				ctrb.CreateTenantProperties = &createTenantProperties
			}
		}
	}

	return nil
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GuestUsagesResource guest Usages Resource
type GuestUsagesResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; An identifier that represents the Guest Usages resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the Guest Usages resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the Guest Usages resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the Guest Usages resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags"`
	// GuestUsagesResourceProperties - The Guest Usages Resource Properties
	*GuestUsagesResourceProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GuestUsagesResource.
func (gur GuestUsagesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gur.Location != nil {
		objectMap["location"] = gur.Location
	}
	if gur.Tags != nil {
		objectMap["tags"] = gur.Tags
	}
	if gur.GuestUsagesResourceProperties != nil {
		objectMap["properties"] = gur.GuestUsagesResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GuestUsagesResource struct.
func (gur *GuestUsagesResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gur.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gur.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gur.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gur.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gur.Tags = tags
			}
		case "properties":
			if v != nil {
				var guestUsagesResourceProperties GuestUsagesResourceProperties
				err = json.Unmarshal(*v, &guestUsagesResourceProperties)
				if err != nil {
					return err
				}
				gur.GuestUsagesResourceProperties = &guestUsagesResourceProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				gur.SystemData = &systemData
			}
		}
	}

	return nil
}

// GuestUsagesResourceList the collection of guest usages resources
type GuestUsagesResourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of guest usages resources
	Value *[]GuestUsagesResource `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for GuestUsagesResourceList.
func (gurl GuestUsagesResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GuestUsagesResourcePatch guest Usages Resource for Patch
type GuestUsagesResourcePatch struct {
	// Tags - Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GuestUsagesResourcePatch.
func (gurp GuestUsagesResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gurp.Tags != nil {
		objectMap["tags"] = gurp.Tags
	}
	return json.Marshal(objectMap)
}

// GuestUsagesResourceProperties guest Usages Resource Properties
type GuestUsagesResourceProperties struct {
	// TenantID - An identifier for the tenant for which the resource is being created
	TenantID *string `json:"tenantId,omitempty"`
}

// NameAvailabilityResponse response of the CheckNameAvailability operation.
type NameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Message - Description of the reason if name is not available.
	Message *string `json:"message,omitempty"`
	// NameAvailable - True if the name is available and can be used to create a new tenant. Otherwise false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Possible values include: 'NameAvailabilityReasonTypeAlreadyExists', 'NameAvailabilityReasonTypeInvalid'
	Reason NameAvailabilityReasonType `json:"reason,omitempty"`
}

// OperationDetail operation detail payload
type OperationDetail struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay operation display payload
type OperationDisplay struct {
	// Provider - Resource provider of the operation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource of the operation
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}
