//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package datamigration

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/datamigration/mgmt/2021-10-30-preview/datamigration"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeActiveDirectoryIntegrated AuthenticationType = original.AuthenticationTypeActiveDirectoryIntegrated
	AuthenticationTypeActiveDirectoryPassword   AuthenticationType = original.AuthenticationTypeActiveDirectoryPassword
	AuthenticationTypeNone                      AuthenticationType = original.AuthenticationTypeNone
	AuthenticationTypeSQLAuthentication         AuthenticationType = original.AuthenticationTypeSQLAuthentication
	AuthenticationTypeWindowsAuthentication     AuthenticationType = original.AuthenticationTypeWindowsAuthentication
)

type BackupFileStatus = original.BackupFileStatus

const (
	BackupFileStatusArrived   BackupFileStatus = original.BackupFileStatusArrived
	BackupFileStatusCancelled BackupFileStatus = original.BackupFileStatusCancelled
	BackupFileStatusQueued    BackupFileStatus = original.BackupFileStatusQueued
	BackupFileStatusRestored  BackupFileStatus = original.BackupFileStatusRestored
	BackupFileStatusRestoring BackupFileStatus = original.BackupFileStatusRestoring
	BackupFileStatusUploaded  BackupFileStatus = original.BackupFileStatusUploaded
	BackupFileStatusUploading BackupFileStatus = original.BackupFileStatusUploading
)

type BackupMode = original.BackupMode

const (
	BackupModeCreateBackup   BackupMode = original.BackupModeCreateBackup
	BackupModeExistingBackup BackupMode = original.BackupModeExistingBackup
)

type BackupType = original.BackupType

const (
	BackupTypeDatabase             BackupType = original.BackupTypeDatabase
	BackupTypeDifferentialDatabase BackupType = original.BackupTypeDifferentialDatabase
	BackupTypeDifferentialFile     BackupType = original.BackupTypeDifferentialFile
	BackupTypeDifferentialPartial  BackupType = original.BackupTypeDifferentialPartial
	BackupTypeFile                 BackupType = original.BackupTypeFile
	BackupTypePartial              BackupType = original.BackupTypePartial
	BackupTypeTransactionLog       BackupType = original.BackupTypeTransactionLog
)

type CommandState = original.CommandState

const (
	CommandStateAccepted  CommandState = original.CommandStateAccepted
	CommandStateFailed    CommandState = original.CommandStateFailed
	CommandStateRunning   CommandState = original.CommandStateRunning
	CommandStateSucceeded CommandState = original.CommandStateSucceeded
	CommandStateUnknown   CommandState = original.CommandStateUnknown
)

type CommandType = original.CommandType

const (
	CommandTypeCancel                               CommandType = original.CommandTypeCancel
	CommandTypeCommandProperties                    CommandType = original.CommandTypeCommandProperties
	CommandTypeFinish                               CommandType = original.CommandTypeFinish
	CommandTypeMigrateSQLServerAzureDbSQLMiComplete CommandType = original.CommandTypeMigrateSQLServerAzureDbSQLMiComplete
	CommandTypeMigrateSyncCompleteDatabase          CommandType = original.CommandTypeMigrateSyncCompleteDatabase
	CommandTypeRestart                              CommandType = original.CommandTypeRestart
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DatabaseCompatLevel = original.DatabaseCompatLevel

const (
	DatabaseCompatLevelCompatLevel100 DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel100
	DatabaseCompatLevelCompatLevel110 DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel110
	DatabaseCompatLevelCompatLevel120 DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel120
	DatabaseCompatLevelCompatLevel130 DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel130
	DatabaseCompatLevelCompatLevel140 DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel140
	DatabaseCompatLevelCompatLevel80  DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel80
	DatabaseCompatLevelCompatLevel90  DatabaseCompatLevel = original.DatabaseCompatLevelCompatLevel90
)

type DatabaseFileType = original.DatabaseFileType

const (
	DatabaseFileTypeFilestream   DatabaseFileType = original.DatabaseFileTypeFilestream
	DatabaseFileTypeFulltext     DatabaseFileType = original.DatabaseFileTypeFulltext
	DatabaseFileTypeLog          DatabaseFileType = original.DatabaseFileTypeLog
	DatabaseFileTypeNotSupported DatabaseFileType = original.DatabaseFileTypeNotSupported
	DatabaseFileTypeRows         DatabaseFileType = original.DatabaseFileTypeRows
)

type DatabaseMigrationStage = original.DatabaseMigrationStage

const (
	DatabaseMigrationStageBackup     DatabaseMigrationStage = original.DatabaseMigrationStageBackup
	DatabaseMigrationStageCompleted  DatabaseMigrationStage = original.DatabaseMigrationStageCompleted
	DatabaseMigrationStageFileCopy   DatabaseMigrationStage = original.DatabaseMigrationStageFileCopy
	DatabaseMigrationStageInitialize DatabaseMigrationStage = original.DatabaseMigrationStageInitialize
	DatabaseMigrationStageNone       DatabaseMigrationStage = original.DatabaseMigrationStageNone
	DatabaseMigrationStageRestore    DatabaseMigrationStage = original.DatabaseMigrationStageRestore
)

type DatabaseMigrationState = original.DatabaseMigrationState

const (
	DatabaseMigrationStateCANCELLED             DatabaseMigrationState = original.DatabaseMigrationStateCANCELLED
	DatabaseMigrationStateCOMPLETED             DatabaseMigrationState = original.DatabaseMigrationStateCOMPLETED
	DatabaseMigrationStateCUTOVERSTART          DatabaseMigrationState = original.DatabaseMigrationStateCUTOVERSTART
	DatabaseMigrationStateFAILED                DatabaseMigrationState = original.DatabaseMigrationStateFAILED
	DatabaseMigrationStateFULLBACKUPUPLOADSTART DatabaseMigrationState = original.DatabaseMigrationStateFULLBACKUPUPLOADSTART
	DatabaseMigrationStateINITIAL               DatabaseMigrationState = original.DatabaseMigrationStateINITIAL
	DatabaseMigrationStateLOGSHIPPINGSTART      DatabaseMigrationState = original.DatabaseMigrationStateLOGSHIPPINGSTART
	DatabaseMigrationStatePOSTCUTOVERCOMPLETE   DatabaseMigrationState = original.DatabaseMigrationStatePOSTCUTOVERCOMPLETE
	DatabaseMigrationStateUNDEFINED             DatabaseMigrationState = original.DatabaseMigrationStateUNDEFINED
	DatabaseMigrationStateUPLOADLOGFILESSTART   DatabaseMigrationState = original.DatabaseMigrationStateUPLOADLOGFILESSTART
)

type DatabaseState = original.DatabaseState

const (
	DatabaseStateCopying          DatabaseState = original.DatabaseStateCopying
	DatabaseStateEmergency        DatabaseState = original.DatabaseStateEmergency
	DatabaseStateOffline          DatabaseState = original.DatabaseStateOffline
	DatabaseStateOfflineSecondary DatabaseState = original.DatabaseStateOfflineSecondary
	DatabaseStateOnline           DatabaseState = original.DatabaseStateOnline
	DatabaseStateRecovering       DatabaseState = original.DatabaseStateRecovering
	DatabaseStateRecoveryPending  DatabaseState = original.DatabaseStateRecoveryPending
	DatabaseStateRestoring        DatabaseState = original.DatabaseStateRestoring
	DatabaseStateSuspect          DatabaseState = original.DatabaseStateSuspect
)

type ErrorType = original.ErrorType

const (
	ErrorTypeDefault ErrorType = original.ErrorTypeDefault
	ErrorTypeError   ErrorType = original.ErrorTypeError
	ErrorTypeWarning ErrorType = original.ErrorTypeWarning
)

type Kind = original.Kind

const (
	KindDatabaseMigrationProperties Kind = original.KindDatabaseMigrationProperties
	KindSQLMi                       Kind = original.KindSQLMi
	KindSQLVM                       Kind = original.KindSQLVM
)

type LoginMigrationStage = original.LoginMigrationStage

const (
	LoginMigrationStageAssignRoleMembership       LoginMigrationStage = original.LoginMigrationStageAssignRoleMembership
	LoginMigrationStageAssignRoleOwnership        LoginMigrationStage = original.LoginMigrationStageAssignRoleOwnership
	LoginMigrationStageCompleted                  LoginMigrationStage = original.LoginMigrationStageCompleted
	LoginMigrationStageEstablishObjectPermissions LoginMigrationStage = original.LoginMigrationStageEstablishObjectPermissions
	LoginMigrationStageEstablishServerPermissions LoginMigrationStage = original.LoginMigrationStageEstablishServerPermissions
	LoginMigrationStageEstablishUserMapping       LoginMigrationStage = original.LoginMigrationStageEstablishUserMapping
	LoginMigrationStageInitialize                 LoginMigrationStage = original.LoginMigrationStageInitialize
	LoginMigrationStageLoginMigration             LoginMigrationStage = original.LoginMigrationStageLoginMigration
	LoginMigrationStageNone                       LoginMigrationStage = original.LoginMigrationStageNone
)

type LoginType = original.LoginType

const (
	LoginTypeAsymmetricKey LoginType = original.LoginTypeAsymmetricKey
	LoginTypeCertificate   LoginType = original.LoginTypeCertificate
	LoginTypeExternalGroup LoginType = original.LoginTypeExternalGroup
	LoginTypeExternalUser  LoginType = original.LoginTypeExternalUser
	LoginTypeSQLLogin      LoginType = original.LoginTypeSQLLogin
	LoginTypeWindowsGroup  LoginType = original.LoginTypeWindowsGroup
	LoginTypeWindowsUser   LoginType = original.LoginTypeWindowsUser
)

type MigrationState = original.MigrationState

const (
	MigrationStateCompleted  MigrationState = original.MigrationStateCompleted
	MigrationStateFailed     MigrationState = original.MigrationStateFailed
	MigrationStateInProgress MigrationState = original.MigrationStateInProgress
	MigrationStateNone       MigrationState = original.MigrationStateNone
	MigrationStateSkipped    MigrationState = original.MigrationStateSkipped
	MigrationStateStopped    MigrationState = original.MigrationStateStopped
	MigrationStateWarning    MigrationState = original.MigrationStateWarning
)

type MigrationStatus = original.MigrationStatus

const (
	MigrationStatusCompleted               MigrationStatus = original.MigrationStatusCompleted
	MigrationStatusCompletedWithWarnings   MigrationStatus = original.MigrationStatusCompletedWithWarnings
	MigrationStatusConfigured              MigrationStatus = original.MigrationStatusConfigured
	MigrationStatusConnecting              MigrationStatus = original.MigrationStatusConnecting
	MigrationStatusDefault                 MigrationStatus = original.MigrationStatusDefault
	MigrationStatusError                   MigrationStatus = original.MigrationStatusError
	MigrationStatusRunning                 MigrationStatus = original.MigrationStatusRunning
	MigrationStatusSelectLogins            MigrationStatus = original.MigrationStatusSelectLogins
	MigrationStatusSourceAndTargetSelected MigrationStatus = original.MigrationStatusSourceAndTargetSelected
	MigrationStatusStopped                 MigrationStatus = original.MigrationStatusStopped
)

type MongoDbClusterType = original.MongoDbClusterType

const (
	MongoDbClusterTypeBlobContainer MongoDbClusterType = original.MongoDbClusterTypeBlobContainer
	MongoDbClusterTypeCosmosDb      MongoDbClusterType = original.MongoDbClusterTypeCosmosDb
	MongoDbClusterTypeMongoDb       MongoDbClusterType = original.MongoDbClusterTypeMongoDb
)

type MongoDbErrorType = original.MongoDbErrorType

const (
	MongoDbErrorTypeError           MongoDbErrorType = original.MongoDbErrorTypeError
	MongoDbErrorTypeValidationError MongoDbErrorType = original.MongoDbErrorTypeValidationError
	MongoDbErrorTypeWarning         MongoDbErrorType = original.MongoDbErrorTypeWarning
)

type MongoDbMigrationState = original.MongoDbMigrationState

const (
	MongoDbMigrationStateCanceled        MongoDbMigrationState = original.MongoDbMigrationStateCanceled
	MongoDbMigrationStateComplete        MongoDbMigrationState = original.MongoDbMigrationStateComplete
	MongoDbMigrationStateCopying         MongoDbMigrationState = original.MongoDbMigrationStateCopying
	MongoDbMigrationStateFailed          MongoDbMigrationState = original.MongoDbMigrationStateFailed
	MongoDbMigrationStateFinalizing      MongoDbMigrationState = original.MongoDbMigrationStateFinalizing
	MongoDbMigrationStateInitializing    MongoDbMigrationState = original.MongoDbMigrationStateInitializing
	MongoDbMigrationStateInitialReplay   MongoDbMigrationState = original.MongoDbMigrationStateInitialReplay
	MongoDbMigrationStateNotStarted      MongoDbMigrationState = original.MongoDbMigrationStateNotStarted
	MongoDbMigrationStateReplaying       MongoDbMigrationState = original.MongoDbMigrationStateReplaying
	MongoDbMigrationStateRestarting      MongoDbMigrationState = original.MongoDbMigrationStateRestarting
	MongoDbMigrationStateValidatingInput MongoDbMigrationState = original.MongoDbMigrationStateValidatingInput
)

type MongoDbReplication = original.MongoDbReplication

const (
	MongoDbReplicationContinuous MongoDbReplication = original.MongoDbReplicationContinuous
	MongoDbReplicationDisabled   MongoDbReplication = original.MongoDbReplicationDisabled
	MongoDbReplicationOneTime    MongoDbReplication = original.MongoDbReplicationOneTime
)

type MongoDbShardKeyOrder = original.MongoDbShardKeyOrder

const (
	MongoDbShardKeyOrderForward MongoDbShardKeyOrder = original.MongoDbShardKeyOrderForward
	MongoDbShardKeyOrderHashed  MongoDbShardKeyOrder = original.MongoDbShardKeyOrderHashed
	MongoDbShardKeyOrderReverse MongoDbShardKeyOrder = original.MongoDbShardKeyOrderReverse
)

type MySQLTargetPlatformType = original.MySQLTargetPlatformType

const (
	MySQLTargetPlatformTypeAzureDbForMySQL MySQLTargetPlatformType = original.MySQLTargetPlatformTypeAzureDbForMySQL
	MySQLTargetPlatformTypeSQLServer       MySQLTargetPlatformType = original.MySQLTargetPlatformTypeSQLServer
)

type NameCheckFailureReason = original.NameCheckFailureReason

const (
	NameCheckFailureReasonAlreadyExists NameCheckFailureReason = original.NameCheckFailureReasonAlreadyExists
	NameCheckFailureReasonInvalid       NameCheckFailureReason = original.NameCheckFailureReasonInvalid
)

type ObjectType = original.ObjectType

const (
	ObjectTypeFunction         ObjectType = original.ObjectTypeFunction
	ObjectTypeStoredProcedures ObjectType = original.ObjectTypeStoredProcedures
	ObjectTypeTable            ObjectType = original.ObjectTypeTable
	ObjectTypeUser             ObjectType = original.ObjectTypeUser
	ObjectTypeView             ObjectType = original.ObjectTypeView
)

type OperationOrigin = original.OperationOrigin

const (
	OperationOriginSystem OperationOrigin = original.OperationOriginSystem
	OperationOriginUser   OperationOrigin = original.OperationOriginUser
)

type ProjectProvisioningState = original.ProjectProvisioningState

const (
	ProjectProvisioningStateDeleting  ProjectProvisioningState = original.ProjectProvisioningStateDeleting
	ProjectProvisioningStateSucceeded ProjectProvisioningState = original.ProjectProvisioningStateSucceeded
)

type ProjectSourcePlatform = original.ProjectSourcePlatform

const (
	ProjectSourcePlatformMongoDb    ProjectSourcePlatform = original.ProjectSourcePlatformMongoDb
	ProjectSourcePlatformMySQL      ProjectSourcePlatform = original.ProjectSourcePlatformMySQL
	ProjectSourcePlatformPostgreSQL ProjectSourcePlatform = original.ProjectSourcePlatformPostgreSQL
	ProjectSourcePlatformSQL        ProjectSourcePlatform = original.ProjectSourcePlatformSQL
	ProjectSourcePlatformUnknown    ProjectSourcePlatform = original.ProjectSourcePlatformUnknown
)

type ProjectTargetPlatform = original.ProjectTargetPlatform

const (
	ProjectTargetPlatformAzureDbForMySQL      ProjectTargetPlatform = original.ProjectTargetPlatformAzureDbForMySQL
	ProjectTargetPlatformAzureDbForPostgreSQL ProjectTargetPlatform = original.ProjectTargetPlatformAzureDbForPostgreSQL
	ProjectTargetPlatformMongoDb              ProjectTargetPlatform = original.ProjectTargetPlatformMongoDb
	ProjectTargetPlatformSQLDB                ProjectTargetPlatform = original.ProjectTargetPlatformSQLDB
	ProjectTargetPlatformSQLMI                ProjectTargetPlatform = original.ProjectTargetPlatformSQLMI
	ProjectTargetPlatformUnknown              ProjectTargetPlatform = original.ProjectTargetPlatformUnknown
)

type ReplicateMigrationState = original.ReplicateMigrationState

const (
	ReplicateMigrationStateACTIONREQUIRED ReplicateMigrationState = original.ReplicateMigrationStateACTIONREQUIRED
	ReplicateMigrationStateCOMPLETE       ReplicateMigrationState = original.ReplicateMigrationStateCOMPLETE
	ReplicateMigrationStateFAILED         ReplicateMigrationState = original.ReplicateMigrationStateFAILED
	ReplicateMigrationStatePENDING        ReplicateMigrationState = original.ReplicateMigrationStatePENDING
	ReplicateMigrationStateUNDEFINED      ReplicateMigrationState = original.ReplicateMigrationStateUNDEFINED
	ReplicateMigrationStateVALIDATING     ReplicateMigrationState = original.ReplicateMigrationStateVALIDATING
)

type ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleType

const (
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeAutomatic
	ResourceSkuCapacityScaleTypeManual    ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeManual
	ResourceSkuCapacityScaleTypeNone      ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeNone
)

type ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCode

const (
	ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription
	ResourceSkuRestrictionsReasonCodeQuotaID                     ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCodeQuotaID
)

type ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsType

const (
	ResourceSkuRestrictionsTypeLocation ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsTypeLocation
)

type ResultCode = original.ResultCode

const (
	ResultCodeCompleted                  ResultCode = original.ResultCodeCompleted
	ResultCodeFatalError                 ResultCode = original.ResultCodeFatalError
	ResultCodeInitial                    ResultCode = original.ResultCodeInitial
	ResultCodeObjectNotExistsInSource    ResultCode = original.ResultCodeObjectNotExistsInSource
	ResultCodeObjectNotExistsInTarget    ResultCode = original.ResultCodeObjectNotExistsInTarget
	ResultCodeTargetObjectIsInaccessible ResultCode = original.ResultCodeTargetObjectIsInaccessible
)

type ResultType = original.ResultType

const (
	ResultTypeMigrateSsisTaskOutput  ResultType = original.ResultTypeMigrateSsisTaskOutput
	ResultTypeMigrationLevelOutput   ResultType = original.ResultTypeMigrationLevelOutput
	ResultTypeSsisProjectLevelOutput ResultType = original.ResultTypeSsisProjectLevelOutput
)

type ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutput

const (
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput                ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput                ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput                   ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput                    ResultTypeBasicConnectToSourceSQLServerTaskOutput = original.ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput
)

type ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput

const (
	ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeDatabaseLevelOutput                          ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeErrorOutput                                  ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeMigrateMySQLAzureDbForMySQLOfflineTaskOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeMigrateMySQLAzureDbForMySQLOfflineTaskOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeMigrationLevelOutput                         ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeTableLevelOutput                             ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput

const (
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput                  ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput                       ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput                               ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput                      ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput                          ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput

const (
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput                     ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput                          ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput                                  ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput                         ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput                             ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput

const (
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput                            ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput                                 ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput                                         ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput                                ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput                                    ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput            ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput                 ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput                         ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput                ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput                    ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput             ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput                     ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput            ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput                ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput                 ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput                         ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput                ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput
)

type ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutput

const (
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput             ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput             ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput                     ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput                ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput            ResultTypeBasicMigrateSQLServerSQLMITaskOutput = original.ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput
)

type ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput

const (
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput                   ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput                           ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput                  ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput                     ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = original.ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput
)

type ResultTypeBasicMongoDbProgress = original.ResultTypeBasicMongoDbProgress

const (
	ResultTypeBasicMongoDbProgressResultTypeCollection      ResultTypeBasicMongoDbProgress = original.ResultTypeBasicMongoDbProgressResultTypeCollection
	ResultTypeBasicMongoDbProgressResultTypeDatabase        ResultTypeBasicMongoDbProgress = original.ResultTypeBasicMongoDbProgressResultTypeDatabase
	ResultTypeBasicMongoDbProgressResultTypeMigration       ResultTypeBasicMongoDbProgress = original.ResultTypeBasicMongoDbProgressResultTypeMigration
	ResultTypeBasicMongoDbProgressResultTypeMongoDbProgress ResultTypeBasicMongoDbProgress = original.ResultTypeBasicMongoDbProgressResultTypeMongoDbProgress
)

type SQLSourcePlatform = original.SQLSourcePlatform

const (
	SQLSourcePlatformSQLOnPrem SQLSourcePlatform = original.SQLSourcePlatformSQLOnPrem
)

type ScenarioSource = original.ScenarioSource

const (
	ScenarioSourceAccess        ScenarioSource = original.ScenarioSourceAccess
	ScenarioSourceDB2           ScenarioSource = original.ScenarioSourceDB2
	ScenarioSourceMongoDB       ScenarioSource = original.ScenarioSourceMongoDB
	ScenarioSourceMySQL         ScenarioSource = original.ScenarioSourceMySQL
	ScenarioSourceMySQLRDS      ScenarioSource = original.ScenarioSourceMySQLRDS
	ScenarioSourceOracle        ScenarioSource = original.ScenarioSourceOracle
	ScenarioSourcePostgreSQL    ScenarioSource = original.ScenarioSourcePostgreSQL
	ScenarioSourcePostgreSQLRDS ScenarioSource = original.ScenarioSourcePostgreSQLRDS
	ScenarioSourceSQL           ScenarioSource = original.ScenarioSourceSQL
	ScenarioSourceSQLRDS        ScenarioSource = original.ScenarioSourceSQLRDS
	ScenarioSourceSybase        ScenarioSource = original.ScenarioSourceSybase
)

type ScenarioTarget = original.ScenarioTarget

const (
	ScenarioTargetAzureDBForMySQL       ScenarioTarget = original.ScenarioTargetAzureDBForMySQL
	ScenarioTargetAzureDBForPostgresSQL ScenarioTarget = original.ScenarioTargetAzureDBForPostgresSQL
	ScenarioTargetMongoDB               ScenarioTarget = original.ScenarioTargetMongoDB
	ScenarioTargetSQLDB                 ScenarioTarget = original.ScenarioTargetSQLDB
	ScenarioTargetSQLDW                 ScenarioTarget = original.ScenarioTargetSQLDW
	ScenarioTargetSQLMI                 ScenarioTarget = original.ScenarioTargetSQLMI
	ScenarioTargetSQLServer             ScenarioTarget = original.ScenarioTargetSQLServer
)

type SchemaMigrationOption = original.SchemaMigrationOption

const (
	SchemaMigrationOptionExtractFromSource SchemaMigrationOption = original.SchemaMigrationOptionExtractFromSource
	SchemaMigrationOptionNone              SchemaMigrationOption = original.SchemaMigrationOptionNone
	SchemaMigrationOptionUseStorageFile    SchemaMigrationOption = original.SchemaMigrationOptionUseStorageFile
)

type SchemaMigrationStage = original.SchemaMigrationStage

const (
	SchemaMigrationStageCollectingObjects     SchemaMigrationStage = original.SchemaMigrationStageCollectingObjects
	SchemaMigrationStageCompleted             SchemaMigrationStage = original.SchemaMigrationStageCompleted
	SchemaMigrationStageCompletedWithWarnings SchemaMigrationStage = original.SchemaMigrationStageCompletedWithWarnings
	SchemaMigrationStageDeployingSchema       SchemaMigrationStage = original.SchemaMigrationStageDeployingSchema
	SchemaMigrationStageDownloadingScript     SchemaMigrationStage = original.SchemaMigrationStageDownloadingScript
	SchemaMigrationStageFailed                SchemaMigrationStage = original.SchemaMigrationStageFailed
	SchemaMigrationStageGeneratingScript      SchemaMigrationStage = original.SchemaMigrationStageGeneratingScript
	SchemaMigrationStageNotStarted            SchemaMigrationStage = original.SchemaMigrationStageNotStarted
	SchemaMigrationStageUploadingScript       SchemaMigrationStage = original.SchemaMigrationStageUploadingScript
	SchemaMigrationStageValidatingInputs      SchemaMigrationStage = original.SchemaMigrationStageValidatingInputs
)

type ServerLevelPermissionsGroup = original.ServerLevelPermissionsGroup

const (
	ServerLevelPermissionsGroupDefault                             ServerLevelPermissionsGroup = original.ServerLevelPermissionsGroupDefault
	ServerLevelPermissionsGroupMigrationFromMySQLToAzureDBForMySQL ServerLevelPermissionsGroup = original.ServerLevelPermissionsGroupMigrationFromMySQLToAzureDBForMySQL
	ServerLevelPermissionsGroupMigrationFromSQLServerToAzureDB     ServerLevelPermissionsGroup = original.ServerLevelPermissionsGroupMigrationFromSQLServerToAzureDB
	ServerLevelPermissionsGroupMigrationFromSQLServerToAzureMI     ServerLevelPermissionsGroup = original.ServerLevelPermissionsGroupMigrationFromSQLServerToAzureMI
)

type ServiceProvisioningState = original.ServiceProvisioningState

const (
	ServiceProvisioningStateAccepted      ServiceProvisioningState = original.ServiceProvisioningStateAccepted
	ServiceProvisioningStateDeleting      ServiceProvisioningState = original.ServiceProvisioningStateDeleting
	ServiceProvisioningStateDeploying     ServiceProvisioningState = original.ServiceProvisioningStateDeploying
	ServiceProvisioningStateFailed        ServiceProvisioningState = original.ServiceProvisioningStateFailed
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = original.ServiceProvisioningStateFailedToStart
	ServiceProvisioningStateFailedToStop  ServiceProvisioningState = original.ServiceProvisioningStateFailedToStop
	ServiceProvisioningStateStarting      ServiceProvisioningState = original.ServiceProvisioningStateStarting
	ServiceProvisioningStateStopped       ServiceProvisioningState = original.ServiceProvisioningStateStopped
	ServiceProvisioningStateStopping      ServiceProvisioningState = original.ServiceProvisioningStateStopping
	ServiceProvisioningStateSucceeded     ServiceProvisioningState = original.ServiceProvisioningStateSucceeded
)

type ServiceScalability = original.ServiceScalability

const (
	ServiceScalabilityAutomatic ServiceScalability = original.ServiceScalabilityAutomatic
	ServiceScalabilityManual    ServiceScalability = original.ServiceScalabilityManual
	ServiceScalabilityNone      ServiceScalability = original.ServiceScalabilityNone
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityMessage Severity = original.SeverityMessage
	SeverityWarning Severity = original.SeverityWarning
)

type SsisMigrationOverwriteOption = original.SsisMigrationOverwriteOption

const (
	SsisMigrationOverwriteOptionIgnore    SsisMigrationOverwriteOption = original.SsisMigrationOverwriteOptionIgnore
	SsisMigrationOverwriteOptionOverwrite SsisMigrationOverwriteOption = original.SsisMigrationOverwriteOptionOverwrite
)

type SsisMigrationStage = original.SsisMigrationStage

const (
	SsisMigrationStageCompleted  SsisMigrationStage = original.SsisMigrationStageCompleted
	SsisMigrationStageInitialize SsisMigrationStage = original.SsisMigrationStageInitialize
	SsisMigrationStageInProgress SsisMigrationStage = original.SsisMigrationStageInProgress
	SsisMigrationStageNone       SsisMigrationStage = original.SsisMigrationStageNone
)

type SsisStoreType = original.SsisStoreType

const (
	SsisStoreTypeSsisCatalog SsisStoreType = original.SsisStoreTypeSsisCatalog
)

type SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingState

const (
	SyncDatabaseMigrationReportingStateBACKUPCOMPLETED    SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateBACKUPCOMPLETED
	SyncDatabaseMigrationReportingStateBACKUPINPROGRESS   SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateBACKUPINPROGRESS
	SyncDatabaseMigrationReportingStateCANCELLED          SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCANCELLED
	SyncDatabaseMigrationReportingStateCANCELLING         SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCANCELLING
	SyncDatabaseMigrationReportingStateCOMPLETE           SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCOMPLETE
	SyncDatabaseMigrationReportingStateCOMPLETING         SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCOMPLETING
	SyncDatabaseMigrationReportingStateCONFIGURING        SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateCONFIGURING
	SyncDatabaseMigrationReportingStateFAILED             SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateFAILED
	SyncDatabaseMigrationReportingStateINITIALIAZING      SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateINITIALIAZING
	SyncDatabaseMigrationReportingStateREADYTOCOMPLETE    SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateREADYTOCOMPLETE
	SyncDatabaseMigrationReportingStateRESTORECOMPLETED   SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateRESTORECOMPLETED
	SyncDatabaseMigrationReportingStateRESTOREINPROGRESS  SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateRESTOREINPROGRESS
	SyncDatabaseMigrationReportingStateRUNNING            SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateRUNNING
	SyncDatabaseMigrationReportingStateSTARTING           SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateSTARTING
	SyncDatabaseMigrationReportingStateUNDEFINED          SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateUNDEFINED
	SyncDatabaseMigrationReportingStateVALIDATING         SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateVALIDATING
	SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE
	SyncDatabaseMigrationReportingStateVALIDATIONFAILED   SyncDatabaseMigrationReportingState = original.SyncDatabaseMigrationReportingStateVALIDATIONFAILED
)

type SyncTableMigrationState = original.SyncTableMigrationState

const (
	SyncTableMigrationStateBEFORELOAD SyncTableMigrationState = original.SyncTableMigrationStateBEFORELOAD
	SyncTableMigrationStateCANCELED   SyncTableMigrationState = original.SyncTableMigrationStateCANCELED
	SyncTableMigrationStateCOMPLETED  SyncTableMigrationState = original.SyncTableMigrationStateCOMPLETED
	SyncTableMigrationStateERROR      SyncTableMigrationState = original.SyncTableMigrationStateERROR
	SyncTableMigrationStateFAILED     SyncTableMigrationState = original.SyncTableMigrationStateFAILED
	SyncTableMigrationStateFULLLOAD   SyncTableMigrationState = original.SyncTableMigrationStateFULLLOAD
)

type TaskState = original.TaskState

const (
	TaskStateCanceled              TaskState = original.TaskStateCanceled
	TaskStateFailed                TaskState = original.TaskStateFailed
	TaskStateFailedInputValidation TaskState = original.TaskStateFailedInputValidation
	TaskStateFaulted               TaskState = original.TaskStateFaulted
	TaskStateQueued                TaskState = original.TaskStateQueued
	TaskStateRunning               TaskState = original.TaskStateRunning
	TaskStateSucceeded             TaskState = original.TaskStateSucceeded
	TaskStateUnknown               TaskState = original.TaskStateUnknown
)

type TaskType = original.TaskType

const (
	TaskTypeConnectMongoDb                                     TaskType = original.TaskTypeConnectMongoDb
	TaskTypeConnectToSourceMySQL                               TaskType = original.TaskTypeConnectToSourceMySQL
	TaskTypeConnectToSourceOracleSync                          TaskType = original.TaskTypeConnectToSourceOracleSync
	TaskTypeConnectToSourcePostgreSQLSync                      TaskType = original.TaskTypeConnectToSourcePostgreSQLSync
	TaskTypeConnectToSourceSQLServer                           TaskType = original.TaskTypeConnectToSourceSQLServer
	TaskTypeConnectToSourceSQLServerSync                       TaskType = original.TaskTypeConnectToSourceSQLServerSync
	TaskTypeConnectToTargetAzureDbForMySQL                     TaskType = original.TaskTypeConnectToTargetAzureDbForMySQL
	TaskTypeConnectToTargetAzureDbForPostgreSQLSync            TaskType = original.TaskTypeConnectToTargetAzureDbForPostgreSQLSync
	TaskTypeConnectToTargetAzureSQLDbMI                        TaskType = original.TaskTypeConnectToTargetAzureSQLDbMI
	TaskTypeConnectToTargetAzureSQLDbMISyncLRS                 TaskType = original.TaskTypeConnectToTargetAzureSQLDbMISyncLRS
	TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync      TaskType = original.TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync
	TaskTypeConnectToTargetSQLDb                               TaskType = original.TaskTypeConnectToTargetSQLDb
	TaskTypeConnectToTargetSQLDbSync                           TaskType = original.TaskTypeConnectToTargetSQLDbSync
	TaskTypeGetTDECertificatesSQL                              TaskType = original.TaskTypeGetTDECertificatesSQL
	TaskTypeGetUserTablesAzureSQLDbSync                        TaskType = original.TaskTypeGetUserTablesAzureSQLDbSync
	TaskTypeGetUserTablesMySQL                                 TaskType = original.TaskTypeGetUserTablesMySQL
	TaskTypeGetUserTablesOracle                                TaskType = original.TaskTypeGetUserTablesOracle
	TaskTypeGetUserTablesPostgreSQL                            TaskType = original.TaskTypeGetUserTablesPostgreSQL
	TaskTypeGetUserTablesSQL                                   TaskType = original.TaskTypeGetUserTablesSQL
	TaskTypeMigrateMongoDb                                     TaskType = original.TaskTypeMigrateMongoDb
	TaskTypeMigrateMySQLAzureDbForMySQL                        TaskType = original.TaskTypeMigrateMySQLAzureDbForMySQL
	TaskTypeMigrateMySQLAzureDbForMySQLSync                    TaskType = original.TaskTypeMigrateMySQLAzureDbForMySQLSync
	TaskTypeMigrateOracleAzureDbForPostgreSQLSync              TaskType = original.TaskTypeMigrateOracleAzureDbForPostgreSQLSync
	TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSyncV2        TaskType = original.TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSyncV2
	TaskTypeMigrateSchemaSQLServerSQLDb                        TaskType = original.TaskTypeMigrateSchemaSQLServerSQLDb
	TaskTypeMigrateSQLServerAzureSQLDbMI                       TaskType = original.TaskTypeMigrateSQLServerAzureSQLDbMI
	TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS                TaskType = original.TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS
	TaskTypeMigrateSQLServerAzureSQLDbSync                     TaskType = original.TaskTypeMigrateSQLServerAzureSQLDbSync
	TaskTypeMigrateSQLServerSQLDb                              TaskType = original.TaskTypeMigrateSQLServerSQLDb
	TaskTypeMigrateSsis                                        TaskType = original.TaskTypeMigrateSsis
	TaskTypeProjectTaskProperties                              TaskType = original.TaskTypeProjectTaskProperties
	TaskTypeServiceCheckOCI                                    TaskType = original.TaskTypeServiceCheckOCI
	TaskTypeServiceInstallOCI                                  TaskType = original.TaskTypeServiceInstallOCI
	TaskTypeServiceUploadOCI                                   TaskType = original.TaskTypeServiceUploadOCI
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI        TaskType = original.TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS TaskType = original.TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS
	TaskTypeValidateMigrationInputSQLServerSQLDbSync           TaskType = original.TaskTypeValidateMigrationInputSQLServerSQLDbSync
	TaskTypeValidateMongoDb                                    TaskType = original.TaskTypeValidateMongoDb
	TaskTypeValidateOracleAzureDbPostgreSQLSync                TaskType = original.TaskTypeValidateOracleAzureDbPostgreSQLSync
)

type Type = original.Type

const (
	TypeConnectionInfo           Type = original.TypeConnectionInfo
	TypeMiSQLConnectionInfo      Type = original.TypeMiSQLConnectionInfo
	TypeMongoDbConnectionInfo    Type = original.TypeMongoDbConnectionInfo
	TypeMySQLConnectionInfo      Type = original.TypeMySQLConnectionInfo
	TypeOracleConnectionInfo     Type = original.TypeOracleConnectionInfo
	TypePostgreSQLConnectionInfo Type = original.TypePostgreSQLConnectionInfo
	TypeSQLConnectionInfo        Type = original.TypeSQLConnectionInfo
)

type UpdateActionType = original.UpdateActionType

const (
	UpdateActionTypeAddedOnTarget   UpdateActionType = original.UpdateActionTypeAddedOnTarget
	UpdateActionTypeChangedOnTarget UpdateActionType = original.UpdateActionTypeChangedOnTarget
	UpdateActionTypeDeletedOnTarget UpdateActionType = original.UpdateActionTypeDeletedOnTarget
)

type ValidationStatus = original.ValidationStatus

const (
	ValidationStatusCompleted           ValidationStatus = original.ValidationStatusCompleted
	ValidationStatusCompletedWithIssues ValidationStatus = original.ValidationStatusCompletedWithIssues
	ValidationStatusDefault             ValidationStatus = original.ValidationStatusDefault
	ValidationStatusFailed              ValidationStatus = original.ValidationStatusFailed
	ValidationStatusInitialized         ValidationStatus = original.ValidationStatusInitialized
	ValidationStatusInProgress          ValidationStatus = original.ValidationStatusInProgress
	ValidationStatusNotStarted          ValidationStatus = original.ValidationStatusNotStarted
	ValidationStatusStopped             ValidationStatus = original.ValidationStatusStopped
)

type APIError = original.APIError
type AuthenticationKeys = original.AuthenticationKeys
type AvailableServiceSku = original.AvailableServiceSku
type AvailableServiceSkuCapacity = original.AvailableServiceSkuCapacity
type AvailableServiceSkuSku = original.AvailableServiceSkuSku
type AzureActiveDirectoryApp = original.AzureActiveDirectoryApp
type AzureBlob = original.AzureBlob
type BackupConfiguration = original.BackupConfiguration
type BackupFileInfo = original.BackupFileInfo
type BackupSetInfo = original.BackupSetInfo
type BaseClient = original.BaseClient
type BasicCommandProperties = original.BasicCommandProperties
type BasicConnectToSourceSQLServerTaskOutput = original.BasicConnectToSourceSQLServerTaskOutput
type BasicConnectionInfo = original.BasicConnectionInfo
type BasicDatabaseMigrationProperties = original.BasicDatabaseMigrationProperties
type BasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.BasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput
type BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = original.BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput
type BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput
type BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
type BasicMigrateSQLServerSQLDbSyncTaskOutput = original.BasicMigrateSQLServerSQLDbSyncTaskOutput
type BasicMigrateSQLServerSQLDbTaskOutput = original.BasicMigrateSQLServerSQLDbTaskOutput
type BasicMigrateSQLServerSQLMISyncTaskOutput = original.BasicMigrateSQLServerSQLMISyncTaskOutput
type BasicMigrateSQLServerSQLMITaskOutput = original.BasicMigrateSQLServerSQLMITaskOutput
type BasicMigrateSchemaSQLServerSQLDbTaskOutput = original.BasicMigrateSchemaSQLServerSQLDbTaskOutput
type BasicMigrateSsisTaskOutput = original.BasicMigrateSsisTaskOutput
type BasicMongoDbProgress = original.BasicMongoDbProgress
type BasicProjectTaskProperties = original.BasicProjectTaskProperties
type BlobShare = original.BlobShare
type CheckOCIDriverTaskInput = original.CheckOCIDriverTaskInput
type CheckOCIDriverTaskOutput = original.CheckOCIDriverTaskOutput
type CheckOCIDriverTaskProperties = original.CheckOCIDriverTaskProperties
type CommandProperties = original.CommandProperties
type CommandPropertiesModel = original.CommandPropertiesModel
type ConnectToMongoDbTaskProperties = original.ConnectToMongoDbTaskProperties
type ConnectToSourceMySQLTaskInput = original.ConnectToSourceMySQLTaskInput
type ConnectToSourceMySQLTaskProperties = original.ConnectToSourceMySQLTaskProperties
type ConnectToSourceNonSQLTaskOutput = original.ConnectToSourceNonSQLTaskOutput
type ConnectToSourceOracleSyncTaskInput = original.ConnectToSourceOracleSyncTaskInput
type ConnectToSourceOracleSyncTaskOutput = original.ConnectToSourceOracleSyncTaskOutput
type ConnectToSourceOracleSyncTaskProperties = original.ConnectToSourceOracleSyncTaskProperties
type ConnectToSourcePostgreSQLSyncTaskInput = original.ConnectToSourcePostgreSQLSyncTaskInput
type ConnectToSourcePostgreSQLSyncTaskOutput = original.ConnectToSourcePostgreSQLSyncTaskOutput
type ConnectToSourcePostgreSQLSyncTaskProperties = original.ConnectToSourcePostgreSQLSyncTaskProperties
type ConnectToSourceSQLServerSyncTaskProperties = original.ConnectToSourceSQLServerSyncTaskProperties
type ConnectToSourceSQLServerTaskInput = original.ConnectToSourceSQLServerTaskInput
type ConnectToSourceSQLServerTaskOutput = original.ConnectToSourceSQLServerTaskOutput
type ConnectToSourceSQLServerTaskOutputAgentJobLevel = original.ConnectToSourceSQLServerTaskOutputAgentJobLevel
type ConnectToSourceSQLServerTaskOutputDatabaseLevel = original.ConnectToSourceSQLServerTaskOutputDatabaseLevel
type ConnectToSourceSQLServerTaskOutputLoginLevel = original.ConnectToSourceSQLServerTaskOutputLoginLevel
type ConnectToSourceSQLServerTaskOutputTaskLevel = original.ConnectToSourceSQLServerTaskOutputTaskLevel
type ConnectToSourceSQLServerTaskProperties = original.ConnectToSourceSQLServerTaskProperties
type ConnectToTargetAzureDbForMySQLTaskInput = original.ConnectToTargetAzureDbForMySQLTaskInput
type ConnectToTargetAzureDbForMySQLTaskOutput = original.ConnectToTargetAzureDbForMySQLTaskOutput
type ConnectToTargetAzureDbForMySQLTaskProperties = original.ConnectToTargetAzureDbForMySQLTaskProperties
type ConnectToTargetAzureDbForPostgreSQLSyncTaskInput = original.ConnectToTargetAzureDbForPostgreSQLSyncTaskInput
type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput = original.ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput
type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties = original.ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput = original.ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput = original.ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem = original.ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties = original.ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties
type ConnectToTargetSQLDbTaskInput = original.ConnectToTargetSQLDbTaskInput
type ConnectToTargetSQLDbTaskOutput = original.ConnectToTargetSQLDbTaskOutput
type ConnectToTargetSQLDbTaskProperties = original.ConnectToTargetSQLDbTaskProperties
type ConnectToTargetSQLMISyncTaskInput = original.ConnectToTargetSQLMISyncTaskInput
type ConnectToTargetSQLMISyncTaskOutput = original.ConnectToTargetSQLMISyncTaskOutput
type ConnectToTargetSQLMISyncTaskProperties = original.ConnectToTargetSQLMISyncTaskProperties
type ConnectToTargetSQLMITaskInput = original.ConnectToTargetSQLMITaskInput
type ConnectToTargetSQLMITaskOutput = original.ConnectToTargetSQLMITaskOutput
type ConnectToTargetSQLMITaskProperties = original.ConnectToTargetSQLMITaskProperties
type ConnectToTargetSQLSQLDbSyncTaskInput = original.ConnectToTargetSQLSQLDbSyncTaskInput
type ConnectToTargetSQLSQLDbSyncTaskProperties = original.ConnectToTargetSQLSQLDbSyncTaskProperties
type ConnectionInfo = original.ConnectionInfo
type DataIntegrityValidationResult = original.DataIntegrityValidationResult
type DataItemMigrationSummaryResult = original.DataItemMigrationSummaryResult
type Database = original.Database
type DatabaseBackupInfo = original.DatabaseBackupInfo
type DatabaseFileInfo = original.DatabaseFileInfo
type DatabaseFileInput = original.DatabaseFileInput
type DatabaseInfo = original.DatabaseInfo
type DatabaseMigration = original.DatabaseMigration
type DatabaseMigrationListResult = original.DatabaseMigrationListResult
type DatabaseMigrationListResultIterator = original.DatabaseMigrationListResultIterator
type DatabaseMigrationListResultPage = original.DatabaseMigrationListResultPage
type DatabaseMigrationProperties = original.DatabaseMigrationProperties
type DatabaseMigrationPropertiesSQLMi = original.DatabaseMigrationPropertiesSQLMi
type DatabaseMigrationPropertiesSQLVM = original.DatabaseMigrationPropertiesSQLVM
type DatabaseMigrationSQLMi = original.DatabaseMigrationSQLMi
type DatabaseMigrationSQLVM = original.DatabaseMigrationSQLVM
type DatabaseMigrationsSQLMiCancelFuture = original.DatabaseMigrationsSQLMiCancelFuture
type DatabaseMigrationsSQLMiClient = original.DatabaseMigrationsSQLMiClient
type DatabaseMigrationsSQLMiCreateOrUpdateFuture = original.DatabaseMigrationsSQLMiCreateOrUpdateFuture
type DatabaseMigrationsSQLMiCutoverFuture = original.DatabaseMigrationsSQLMiCutoverFuture
type DatabaseMigrationsSQLVMCancelFuture = original.DatabaseMigrationsSQLVMCancelFuture
type DatabaseMigrationsSQLVMClient = original.DatabaseMigrationsSQLVMClient
type DatabaseMigrationsSQLVMCreateOrUpdateFuture = original.DatabaseMigrationsSQLVMCreateOrUpdateFuture
type DatabaseMigrationsSQLVMCutoverFuture = original.DatabaseMigrationsSQLVMCutoverFuture
type DatabaseObjectName = original.DatabaseObjectName
type DatabaseSummaryResult = original.DatabaseSummaryResult
type DatabaseTable = original.DatabaseTable
type DeleteNode = original.DeleteNode
type Error = original.Error
type ErrorInfo = original.ErrorInfo
type ExecutionStatistics = original.ExecutionStatistics
type FileList = original.FileList
type FileListIterator = original.FileListIterator
type FileListPage = original.FileListPage
type FileShare = original.FileShare
type FileStorageInfo = original.FileStorageInfo
type FilesClient = original.FilesClient
type GetProjectDetailsNonSQLTaskInput = original.GetProjectDetailsNonSQLTaskInput
type GetTdeCertificatesSQLTaskInput = original.GetTdeCertificatesSQLTaskInput
type GetTdeCertificatesSQLTaskOutput = original.GetTdeCertificatesSQLTaskOutput
type GetTdeCertificatesSQLTaskProperties = original.GetTdeCertificatesSQLTaskProperties
type GetUserTablesMySQLTaskInput = original.GetUserTablesMySQLTaskInput
type GetUserTablesMySQLTaskOutput = original.GetUserTablesMySQLTaskOutput
type GetUserTablesMySQLTaskProperties = original.GetUserTablesMySQLTaskProperties
type GetUserTablesOracleTaskInput = original.GetUserTablesOracleTaskInput
type GetUserTablesOracleTaskOutput = original.GetUserTablesOracleTaskOutput
type GetUserTablesOracleTaskProperties = original.GetUserTablesOracleTaskProperties
type GetUserTablesPostgreSQLTaskInput = original.GetUserTablesPostgreSQLTaskInput
type GetUserTablesPostgreSQLTaskOutput = original.GetUserTablesPostgreSQLTaskOutput
type GetUserTablesPostgreSQLTaskProperties = original.GetUserTablesPostgreSQLTaskProperties
type GetUserTablesSQLSyncTaskInput = original.GetUserTablesSQLSyncTaskInput
type GetUserTablesSQLSyncTaskOutput = original.GetUserTablesSQLSyncTaskOutput
type GetUserTablesSQLSyncTaskProperties = original.GetUserTablesSQLSyncTaskProperties
type GetUserTablesSQLTaskInput = original.GetUserTablesSQLTaskInput
type GetUserTablesSQLTaskOutput = original.GetUserTablesSQLTaskOutput
type GetUserTablesSQLTaskProperties = original.GetUserTablesSQLTaskProperties
type InstallOCIDriverTaskInput = original.InstallOCIDriverTaskInput
type InstallOCIDriverTaskOutput = original.InstallOCIDriverTaskOutput
type InstallOCIDriverTaskProperties = original.InstallOCIDriverTaskProperties
type IntegrationRuntimeMonitoringData = original.IntegrationRuntimeMonitoringData
type MiSQLConnectionInfo = original.MiSQLConnectionInfo
type MigrateMISyncCompleteCommandInput = original.MigrateMISyncCompleteCommandInput
type MigrateMISyncCompleteCommandOutput = original.MigrateMISyncCompleteCommandOutput
type MigrateMISyncCompleteCommandProperties = original.MigrateMISyncCompleteCommandProperties
type MigrateMongoDbTaskProperties = original.MigrateMongoDbTaskProperties
type MigrateMySQLAzureDbForMySQLOfflineDatabaseInput = original.MigrateMySQLAzureDbForMySQLOfflineDatabaseInput
type MigrateMySQLAzureDbForMySQLOfflineTaskInput = original.MigrateMySQLAzureDbForMySQLOfflineTaskInput
type MigrateMySQLAzureDbForMySQLOfflineTaskOutput = original.MigrateMySQLAzureDbForMySQLOfflineTaskOutput
type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel = original.MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel
type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError = original.MigrateMySQLAzureDbForMySQLOfflineTaskOutputError
type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel = original.MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel
type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel = original.MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel
type MigrateMySQLAzureDbForMySQLOfflineTaskProperties = original.MigrateMySQLAzureDbForMySQLOfflineTaskProperties
type MigrateMySQLAzureDbForMySQLSyncDatabaseInput = original.MigrateMySQLAzureDbForMySQLSyncDatabaseInput
type MigrateMySQLAzureDbForMySQLSyncTaskInput = original.MigrateMySQLAzureDbForMySQLSyncTaskInput
type MigrateMySQLAzureDbForMySQLSyncTaskOutput = original.MigrateMySQLAzureDbForMySQLSyncTaskOutput
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel
type MigrateMySQLAzureDbForMySQLSyncTaskOutputError = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputError
type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel
type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel = original.MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel
type MigrateMySQLAzureDbForMySQLSyncTaskProperties = original.MigrateMySQLAzureDbForMySQLSyncTaskProperties
type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties = original.MigrateOracleAzureDbForPostgreSQLSyncTaskProperties
type MigrateOracleAzureDbPostgreSQLSyncDatabaseInput = original.MigrateOracleAzureDbPostgreSQLSyncDatabaseInput
type MigrateOracleAzureDbPostgreSQLSyncTaskInput = original.MigrateOracleAzureDbPostgreSQLSyncTaskInput
type MigrateOracleAzureDbPostgreSQLSyncTaskOutput = original.MigrateOracleAzureDbPostgreSQLSyncTaskOutput
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError = original.MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel = original.MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError = original.MigrateOracleAzureDbPostgreSQLSyncTaskOutputError
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel = original.MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel = original.MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties = original.MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties
type MigrateSQLServerSQLDbDatabaseInput = original.MigrateSQLServerSQLDbDatabaseInput
type MigrateSQLServerSQLDbSyncDatabaseInput = original.MigrateSQLServerSQLDbSyncDatabaseInput
type MigrateSQLServerSQLDbSyncTaskInput = original.MigrateSQLServerSQLDbSyncTaskInput
type MigrateSQLServerSQLDbSyncTaskOutput = original.MigrateSQLServerSQLDbSyncTaskOutput
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError = original.MigrateSQLServerSQLDbSyncTaskOutputDatabaseError
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel = original.MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel
type MigrateSQLServerSQLDbSyncTaskOutputError = original.MigrateSQLServerSQLDbSyncTaskOutputError
type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel = original.MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel
type MigrateSQLServerSQLDbSyncTaskOutputTableLevel = original.MigrateSQLServerSQLDbSyncTaskOutputTableLevel
type MigrateSQLServerSQLDbSyncTaskProperties = original.MigrateSQLServerSQLDbSyncTaskProperties
type MigrateSQLServerSQLDbTaskInput = original.MigrateSQLServerSQLDbTaskInput
type MigrateSQLServerSQLDbTaskOutput = original.MigrateSQLServerSQLDbTaskOutput
type MigrateSQLServerSQLDbTaskOutputDatabaseLevel = original.MigrateSQLServerSQLDbTaskOutputDatabaseLevel
type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult = original.MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult
type MigrateSQLServerSQLDbTaskOutputError = original.MigrateSQLServerSQLDbTaskOutputError
type MigrateSQLServerSQLDbTaskOutputMigrationLevel = original.MigrateSQLServerSQLDbTaskOutputMigrationLevel
type MigrateSQLServerSQLDbTaskOutputTableLevel = original.MigrateSQLServerSQLDbTaskOutputTableLevel
type MigrateSQLServerSQLDbTaskOutputValidationResult = original.MigrateSQLServerSQLDbTaskOutputValidationResult
type MigrateSQLServerSQLDbTaskProperties = original.MigrateSQLServerSQLDbTaskProperties
type MigrateSQLServerSQLMIDatabaseInput = original.MigrateSQLServerSQLMIDatabaseInput
type MigrateSQLServerSQLMISyncTaskInput = original.MigrateSQLServerSQLMISyncTaskInput
type MigrateSQLServerSQLMISyncTaskOutput = original.MigrateSQLServerSQLMISyncTaskOutput
type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel = original.MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel
type MigrateSQLServerSQLMISyncTaskOutputError = original.MigrateSQLServerSQLMISyncTaskOutputError
type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel = original.MigrateSQLServerSQLMISyncTaskOutputMigrationLevel
type MigrateSQLServerSQLMISyncTaskProperties = original.MigrateSQLServerSQLMISyncTaskProperties
type MigrateSQLServerSQLMITaskInput = original.MigrateSQLServerSQLMITaskInput
type MigrateSQLServerSQLMITaskOutput = original.MigrateSQLServerSQLMITaskOutput
type MigrateSQLServerSQLMITaskOutputAgentJobLevel = original.MigrateSQLServerSQLMITaskOutputAgentJobLevel
type MigrateSQLServerSQLMITaskOutputDatabaseLevel = original.MigrateSQLServerSQLMITaskOutputDatabaseLevel
type MigrateSQLServerSQLMITaskOutputError = original.MigrateSQLServerSQLMITaskOutputError
type MigrateSQLServerSQLMITaskOutputLoginLevel = original.MigrateSQLServerSQLMITaskOutputLoginLevel
type MigrateSQLServerSQLMITaskOutputMigrationLevel = original.MigrateSQLServerSQLMITaskOutputMigrationLevel
type MigrateSQLServerSQLMITaskProperties = original.MigrateSQLServerSQLMITaskProperties
type MigrateSQLServerSQLServerDatabaseInput = original.MigrateSQLServerSQLServerDatabaseInput
type MigrateSchemaSQLServerSQLDbDatabaseInput = original.MigrateSchemaSQLServerSQLDbDatabaseInput
type MigrateSchemaSQLServerSQLDbTaskInput = original.MigrateSchemaSQLServerSQLDbTaskInput
type MigrateSchemaSQLServerSQLDbTaskOutput = original.MigrateSchemaSQLServerSQLDbTaskOutput
type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel = original.MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel
type MigrateSchemaSQLServerSQLDbTaskOutputError = original.MigrateSchemaSQLServerSQLDbTaskOutputError
type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel = original.MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel
type MigrateSchemaSQLServerSQLDbTaskProperties = original.MigrateSchemaSQLServerSQLDbTaskProperties
type MigrateSchemaSQLTaskOutputError = original.MigrateSchemaSQLTaskOutputError
type MigrateSsisTaskInput = original.MigrateSsisTaskInput
type MigrateSsisTaskOutput = original.MigrateSsisTaskOutput
type MigrateSsisTaskOutputMigrationLevel = original.MigrateSsisTaskOutputMigrationLevel
type MigrateSsisTaskOutputProjectLevel = original.MigrateSsisTaskOutputProjectLevel
type MigrateSsisTaskProperties = original.MigrateSsisTaskProperties
type MigrateSyncCompleteCommandInput = original.MigrateSyncCompleteCommandInput
type MigrateSyncCompleteCommandOutput = original.MigrateSyncCompleteCommandOutput
type MigrateSyncCompleteCommandProperties = original.MigrateSyncCompleteCommandProperties
type MigrationEligibilityInfo = original.MigrationEligibilityInfo
type MigrationOperationInput = original.MigrationOperationInput
type MigrationReportResult = original.MigrationReportResult
type MigrationStatusDetails = original.MigrationStatusDetails
type MigrationTableMetadata = original.MigrationTableMetadata
type MigrationValidationDatabaseLevelResult = original.MigrationValidationDatabaseLevelResult
type MigrationValidationDatabaseSummaryResult = original.MigrationValidationDatabaseSummaryResult
type MigrationValidationOptions = original.MigrationValidationOptions
type MigrationValidationResult = original.MigrationValidationResult
type MongoDbCancelCommand = original.MongoDbCancelCommand
type MongoDbClusterInfo = original.MongoDbClusterInfo
type MongoDbCollectionInfo = original.MongoDbCollectionInfo
type MongoDbCollectionProgress = original.MongoDbCollectionProgress
type MongoDbCollectionSettings = original.MongoDbCollectionSettings
type MongoDbCommandInput = original.MongoDbCommandInput
type MongoDbConnectionInfo = original.MongoDbConnectionInfo
type MongoDbDatabaseInfo = original.MongoDbDatabaseInfo
type MongoDbDatabaseProgress = original.MongoDbDatabaseProgress
type MongoDbDatabaseSettings = original.MongoDbDatabaseSettings
type MongoDbError = original.MongoDbError
type MongoDbFinishCommand = original.MongoDbFinishCommand
type MongoDbFinishCommandInput = original.MongoDbFinishCommandInput
type MongoDbMigrationProgress = original.MongoDbMigrationProgress
type MongoDbMigrationSettings = original.MongoDbMigrationSettings
type MongoDbObjectInfo = original.MongoDbObjectInfo
type MongoDbProgress = original.MongoDbProgress
type MongoDbRestartCommand = original.MongoDbRestartCommand
type MongoDbShardKeyField = original.MongoDbShardKeyField
type MongoDbShardKeyInfo = original.MongoDbShardKeyInfo
type MongoDbShardKeySetting = original.MongoDbShardKeySetting
type MongoDbThrottlingSettings = original.MongoDbThrottlingSettings
type MySQLConnectionInfo = original.MySQLConnectionInfo
type NameAvailabilityRequest = original.NameAvailabilityRequest
type NameAvailabilityResponse = original.NameAvailabilityResponse
type NodeMonitoringData = original.NodeMonitoringData
type NonSQLDataMigrationTable = original.NonSQLDataMigrationTable
type NonSQLDataMigrationTableResult = original.NonSQLDataMigrationTableResult
type NonSQLMigrationTaskInput = original.NonSQLMigrationTaskInput
type NonSQLMigrationTaskOutput = original.NonSQLMigrationTaskOutput
type ODataError = original.ODataError
type OfflineConfiguration = original.OfflineConfiguration
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type OperationsDefinition = original.OperationsDefinition
type OperationsDisplayDefinition = original.OperationsDisplayDefinition
type OracleConnectionInfo = original.OracleConnectionInfo
type OracleOCIDriverInfo = original.OracleOCIDriverInfo
type OrphanedUserInfo = original.OrphanedUserInfo
type PostgreSQLConnectionInfo = original.PostgreSQLConnectionInfo
type Project = original.Project
type ProjectFile = original.ProjectFile
type ProjectFileProperties = original.ProjectFileProperties
type ProjectList = original.ProjectList
type ProjectListIterator = original.ProjectListIterator
type ProjectListPage = original.ProjectListPage
type ProjectMetadata = original.ProjectMetadata
type ProjectProperties = original.ProjectProperties
type ProjectTask = original.ProjectTask
type ProjectTaskProperties = original.ProjectTaskProperties
type ProjectsClient = original.ProjectsClient
type ProxyResource = original.ProxyResource
type QueryAnalysisValidationResult = original.QueryAnalysisValidationResult
type QueryExecutionResult = original.QueryExecutionResult
type Quota = original.Quota
type QuotaList = original.QuotaList
type QuotaListIterator = original.QuotaListIterator
type QuotaListPage = original.QuotaListPage
type QuotaName = original.QuotaName
type RegenAuthKeys = original.RegenAuthKeys
type ReportableException = original.ReportableException
type Resource = original.Resource
type ResourceSku = original.ResourceSku
type ResourceSkuCapabilities = original.ResourceSkuCapabilities
type ResourceSkuCapacity = original.ResourceSkuCapacity
type ResourceSkuCosts = original.ResourceSkuCosts
type ResourceSkuRestrictions = original.ResourceSkuRestrictions
type ResourceSkusClient = original.ResourceSkusClient
type ResourceSkusResult = original.ResourceSkusResult
type ResourceSkusResultIterator = original.ResourceSkusResultIterator
type ResourceSkusResultPage = original.ResourceSkusResultPage
type SQLBackupFileInfo = original.SQLBackupFileInfo
type SQLBackupSetInfo = original.SQLBackupSetInfo
type SQLConnectionInfo = original.SQLConnectionInfo
type SQLConnectionInformation = original.SQLConnectionInformation
type SQLFileShare = original.SQLFileShare
type SQLMigrationListResult = original.SQLMigrationListResult
type SQLMigrationListResultIterator = original.SQLMigrationListResultIterator
type SQLMigrationListResultPage = original.SQLMigrationListResultPage
type SQLMigrationService = original.SQLMigrationService
type SQLMigrationServiceProperties = original.SQLMigrationServiceProperties
type SQLMigrationServiceUpdate = original.SQLMigrationServiceUpdate
type SQLMigrationServicesClient = original.SQLMigrationServicesClient
type SQLMigrationServicesCreateOrUpdateFuture = original.SQLMigrationServicesCreateOrUpdateFuture
type SQLMigrationServicesDeleteFuture = original.SQLMigrationServicesDeleteFuture
type SQLMigrationServicesUpdateFuture = original.SQLMigrationServicesUpdateFuture
type SQLMigrationTaskInput = original.SQLMigrationTaskInput
type SQLServerSQLMISyncTaskInput = original.SQLServerSQLMISyncTaskInput
type SchemaComparisonValidationResult = original.SchemaComparisonValidationResult
type SchemaComparisonValidationResultType = original.SchemaComparisonValidationResultType
type SchemaMigrationSetting = original.SchemaMigrationSetting
type SelectedCertificateInput = original.SelectedCertificateInput
type ServerProperties = original.ServerProperties
type Service = original.Service
type ServiceList = original.ServiceList
type ServiceListIterator = original.ServiceListIterator
type ServiceListPage = original.ServiceListPage
type ServiceOperation = original.ServiceOperation
type ServiceOperationDisplay = original.ServiceOperationDisplay
type ServiceOperationList = original.ServiceOperationList
type ServiceProperties = original.ServiceProperties
type ServiceSku = original.ServiceSku
type ServiceSkuList = original.ServiceSkuList
type ServiceSkuListIterator = original.ServiceSkuListIterator
type ServiceSkuListPage = original.ServiceSkuListPage
type ServiceStatusResponse = original.ServiceStatusResponse
type ServiceTasksClient = original.ServiceTasksClient
type ServicesClient = original.ServicesClient
type ServicesCreateOrUpdateFuture = original.ServicesCreateOrUpdateFuture
type ServicesDeleteFuture = original.ServicesDeleteFuture
type ServicesStartFuture = original.ServicesStartFuture
type ServicesStopFuture = original.ServicesStopFuture
type ServicesUpdateFuture = original.ServicesUpdateFuture
type SourceLocation = original.SourceLocation
type SsisMigrationInfo = original.SsisMigrationInfo
type StartMigrationScenarioServerRoleResult = original.StartMigrationScenarioServerRoleResult
type SyncMigrationDatabaseErrorEvent = original.SyncMigrationDatabaseErrorEvent
type SystemData = original.SystemData
type TargetLocation = original.TargetLocation
type TaskList = original.TaskList
type TaskListIterator = original.TaskListIterator
type TaskListPage = original.TaskListPage
type TasksClient = original.TasksClient
type TrackedResource = original.TrackedResource
type UploadOCIDriverTaskInput = original.UploadOCIDriverTaskInput
type UploadOCIDriverTaskOutput = original.UploadOCIDriverTaskOutput
type UploadOCIDriverTaskProperties = original.UploadOCIDriverTaskProperties
type UsagesClient = original.UsagesClient
type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties = original.ValidateMigrationInputSQLServerSQLDbSyncTaskProperties
type ValidateMigrationInputSQLServerSQLMISyncTaskInput = original.ValidateMigrationInputSQLServerSQLMISyncTaskInput
type ValidateMigrationInputSQLServerSQLMISyncTaskOutput = original.ValidateMigrationInputSQLServerSQLMISyncTaskOutput
type ValidateMigrationInputSQLServerSQLMISyncTaskProperties = original.ValidateMigrationInputSQLServerSQLMISyncTaskProperties
type ValidateMigrationInputSQLServerSQLMITaskInput = original.ValidateMigrationInputSQLServerSQLMITaskInput
type ValidateMigrationInputSQLServerSQLMITaskOutput = original.ValidateMigrationInputSQLServerSQLMITaskOutput
type ValidateMigrationInputSQLServerSQLMITaskProperties = original.ValidateMigrationInputSQLServerSQLMITaskProperties
type ValidateMongoDbTaskProperties = original.ValidateMongoDbTaskProperties
type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties = original.ValidateOracleAzureDbForPostgreSQLSyncTaskProperties
type ValidateOracleAzureDbPostgreSQLSyncTaskOutput = original.ValidateOracleAzureDbPostgreSQLSyncTaskOutput
type ValidateSyncMigrationInputSQLServerTaskInput = original.ValidateSyncMigrationInputSQLServerTaskInput
type ValidateSyncMigrationInputSQLServerTaskOutput = original.ValidateSyncMigrationInputSQLServerTaskOutput
type ValidationError = original.ValidationError
type WaitStatistics = original.WaitStatistics

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewDatabaseMigrationListResultIterator(page DatabaseMigrationListResultPage) DatabaseMigrationListResultIterator {
	return original.NewDatabaseMigrationListResultIterator(page)
}
func NewDatabaseMigrationListResultPage(cur DatabaseMigrationListResult, getNextPage func(context.Context, DatabaseMigrationListResult) (DatabaseMigrationListResult, error)) DatabaseMigrationListResultPage {
	return original.NewDatabaseMigrationListResultPage(cur, getNextPage)
}
func NewDatabaseMigrationsSQLMiClient(subscriptionID string) DatabaseMigrationsSQLMiClient {
	return original.NewDatabaseMigrationsSQLMiClient(subscriptionID)
}
func NewDatabaseMigrationsSQLMiClientWithBaseURI(baseURI string, subscriptionID string) DatabaseMigrationsSQLMiClient {
	return original.NewDatabaseMigrationsSQLMiClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseMigrationsSQLVMClient(subscriptionID string) DatabaseMigrationsSQLVMClient {
	return original.NewDatabaseMigrationsSQLVMClient(subscriptionID)
}
func NewDatabaseMigrationsSQLVMClientWithBaseURI(baseURI string, subscriptionID string) DatabaseMigrationsSQLVMClient {
	return original.NewDatabaseMigrationsSQLVMClientWithBaseURI(baseURI, subscriptionID)
}
func NewFileListIterator(page FileListPage) FileListIterator {
	return original.NewFileListIterator(page)
}
func NewFileListPage(cur FileList, getNextPage func(context.Context, FileList) (FileList, error)) FileListPage {
	return original.NewFileListPage(cur, getNextPage)
}
func NewFilesClient(subscriptionID string) FilesClient {
	return original.NewFilesClient(subscriptionID)
}
func NewFilesClientWithBaseURI(baseURI string, subscriptionID string) FilesClient {
	return original.NewFilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProjectListIterator(page ProjectListPage) ProjectListIterator {
	return original.NewProjectListIterator(page)
}
func NewProjectListPage(cur ProjectList, getNextPage func(context.Context, ProjectList) (ProjectList, error)) ProjectListPage {
	return original.NewProjectListPage(cur, getNextPage)
}
func NewProjectsClient(subscriptionID string) ProjectsClient {
	return original.NewProjectsClient(subscriptionID)
}
func NewProjectsClientWithBaseURI(baseURI string, subscriptionID string) ProjectsClient {
	return original.NewProjectsClientWithBaseURI(baseURI, subscriptionID)
}
func NewQuotaListIterator(page QuotaListPage) QuotaListIterator {
	return original.NewQuotaListIterator(page)
}
func NewQuotaListPage(cur QuotaList, getNextPage func(context.Context, QuotaList) (QuotaList, error)) QuotaListPage {
	return original.NewQuotaListPage(cur, getNextPage)
}
func NewResourceSkusClient(subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClient(subscriptionID)
}
func NewResourceSkusClientWithBaseURI(baseURI string, subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return original.NewResourceSkusResultIterator(page)
}
func NewResourceSkusResultPage(cur ResourceSkusResult, getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return original.NewResourceSkusResultPage(cur, getNextPage)
}
func NewSQLMigrationListResultIterator(page SQLMigrationListResultPage) SQLMigrationListResultIterator {
	return original.NewSQLMigrationListResultIterator(page)
}
func NewSQLMigrationListResultPage(cur SQLMigrationListResult, getNextPage func(context.Context, SQLMigrationListResult) (SQLMigrationListResult, error)) SQLMigrationListResultPage {
	return original.NewSQLMigrationListResultPage(cur, getNextPage)
}
func NewSQLMigrationServicesClient(subscriptionID string) SQLMigrationServicesClient {
	return original.NewSQLMigrationServicesClient(subscriptionID)
}
func NewSQLMigrationServicesClientWithBaseURI(baseURI string, subscriptionID string) SQLMigrationServicesClient {
	return original.NewSQLMigrationServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceListIterator(page ServiceListPage) ServiceListIterator {
	return original.NewServiceListIterator(page)
}
func NewServiceListPage(cur ServiceList, getNextPage func(context.Context, ServiceList) (ServiceList, error)) ServiceListPage {
	return original.NewServiceListPage(cur, getNextPage)
}
func NewServiceSkuListIterator(page ServiceSkuListPage) ServiceSkuListIterator {
	return original.NewServiceSkuListIterator(page)
}
func NewServiceSkuListPage(cur ServiceSkuList, getNextPage func(context.Context, ServiceSkuList) (ServiceSkuList, error)) ServiceSkuListPage {
	return original.NewServiceSkuListPage(cur, getNextPage)
}
func NewServiceTasksClient(subscriptionID string) ServiceTasksClient {
	return original.NewServiceTasksClient(subscriptionID)
}
func NewServiceTasksClientWithBaseURI(baseURI string, subscriptionID string) ServiceTasksClient {
	return original.NewServiceTasksClientWithBaseURI(baseURI, subscriptionID)
}
func NewServicesClient(subscriptionID string) ServicesClient {
	return original.NewServicesClient(subscriptionID)
}
func NewServicesClientWithBaseURI(baseURI string, subscriptionID string) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return original.NewTaskListIterator(page)
}
func NewTaskListPage(cur TaskList, getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return original.NewTaskListPage(cur, getNextPage)
}
func NewTasksClient(subscriptionID string) TasksClient {
	return original.NewTasksClient(subscriptionID)
}
func NewTasksClientWithBaseURI(baseURI string, subscriptionID string) TasksClient {
	return original.NewTasksClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleBackupFileStatusValues() []BackupFileStatus {
	return original.PossibleBackupFileStatusValues()
}
func PossibleBackupModeValues() []BackupMode {
	return original.PossibleBackupModeValues()
}
func PossibleBackupTypeValues() []BackupType {
	return original.PossibleBackupTypeValues()
}
func PossibleCommandStateValues() []CommandState {
	return original.PossibleCommandStateValues()
}
func PossibleCommandTypeValues() []CommandType {
	return original.PossibleCommandTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return original.PossibleDatabaseCompatLevelValues()
}
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return original.PossibleDatabaseFileTypeValues()
}
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return original.PossibleDatabaseMigrationStageValues()
}
func PossibleDatabaseMigrationStateValues() []DatabaseMigrationState {
	return original.PossibleDatabaseMigrationStateValues()
}
func PossibleDatabaseStateValues() []DatabaseState {
	return original.PossibleDatabaseStateValues()
}
func PossibleErrorTypeValues() []ErrorType {
	return original.PossibleErrorTypeValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleLoginMigrationStageValues() []LoginMigrationStage {
	return original.PossibleLoginMigrationStageValues()
}
func PossibleLoginTypeValues() []LoginType {
	return original.PossibleLoginTypeValues()
}
func PossibleMigrationStateValues() []MigrationState {
	return original.PossibleMigrationStateValues()
}
func PossibleMigrationStatusValues() []MigrationStatus {
	return original.PossibleMigrationStatusValues()
}
func PossibleMongoDbClusterTypeValues() []MongoDbClusterType {
	return original.PossibleMongoDbClusterTypeValues()
}
func PossibleMongoDbErrorTypeValues() []MongoDbErrorType {
	return original.PossibleMongoDbErrorTypeValues()
}
func PossibleMongoDbMigrationStateValues() []MongoDbMigrationState {
	return original.PossibleMongoDbMigrationStateValues()
}
func PossibleMongoDbReplicationValues() []MongoDbReplication {
	return original.PossibleMongoDbReplicationValues()
}
func PossibleMongoDbShardKeyOrderValues() []MongoDbShardKeyOrder {
	return original.PossibleMongoDbShardKeyOrderValues()
}
func PossibleMySQLTargetPlatformTypeValues() []MySQLTargetPlatformType {
	return original.PossibleMySQLTargetPlatformTypeValues()
}
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return original.PossibleNameCheckFailureReasonValues()
}
func PossibleObjectTypeValues() []ObjectType {
	return original.PossibleObjectTypeValues()
}
func PossibleOperationOriginValues() []OperationOrigin {
	return original.PossibleOperationOriginValues()
}
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return original.PossibleProjectProvisioningStateValues()
}
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return original.PossibleProjectSourcePlatformValues()
}
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return original.PossibleProjectTargetPlatformValues()
}
func PossibleReplicateMigrationStateValues() []ReplicateMigrationState {
	return original.PossibleReplicateMigrationStateValues()
}
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return original.PossibleResourceSkuCapacityScaleTypeValues()
}
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return original.PossibleResourceSkuRestrictionsReasonCodeValues()
}
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return original.PossibleResourceSkuRestrictionsTypeValues()
}
func PossibleResultCodeValues() []ResultCode {
	return original.PossibleResultCodeValues()
}
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return original.PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues()
}
func PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputValues() []ResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return original.PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLOfflineTaskOutputValues()
}
func PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues() []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputValues() []ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputValues()
}
func PossibleResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputValues() []ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return original.PossibleResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues()
}
func PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMITaskOutput {
	return original.PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues()
}
func PossibleResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput {
	return original.PossibleResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputValues()
}
func PossibleResultTypeBasicMongoDbProgressValues() []ResultTypeBasicMongoDbProgress {
	return original.PossibleResultTypeBasicMongoDbProgressValues()
}
func PossibleResultTypeValues() []ResultType {
	return original.PossibleResultTypeValues()
}
func PossibleSQLSourcePlatformValues() []SQLSourcePlatform {
	return original.PossibleSQLSourcePlatformValues()
}
func PossibleScenarioSourceValues() []ScenarioSource {
	return original.PossibleScenarioSourceValues()
}
func PossibleScenarioTargetValues() []ScenarioTarget {
	return original.PossibleScenarioTargetValues()
}
func PossibleSchemaMigrationOptionValues() []SchemaMigrationOption {
	return original.PossibleSchemaMigrationOptionValues()
}
func PossibleSchemaMigrationStageValues() []SchemaMigrationStage {
	return original.PossibleSchemaMigrationStageValues()
}
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return original.PossibleServerLevelPermissionsGroupValues()
}
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return original.PossibleServiceProvisioningStateValues()
}
func PossibleServiceScalabilityValues() []ServiceScalability {
	return original.PossibleServiceScalabilityValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSsisMigrationOverwriteOptionValues() []SsisMigrationOverwriteOption {
	return original.PossibleSsisMigrationOverwriteOptionValues()
}
func PossibleSsisMigrationStageValues() []SsisMigrationStage {
	return original.PossibleSsisMigrationStageValues()
}
func PossibleSsisStoreTypeValues() []SsisStoreType {
	return original.PossibleSsisStoreTypeValues()
}
func PossibleSyncDatabaseMigrationReportingStateValues() []SyncDatabaseMigrationReportingState {
	return original.PossibleSyncDatabaseMigrationReportingStateValues()
}
func PossibleSyncTableMigrationStateValues() []SyncTableMigrationState {
	return original.PossibleSyncTableMigrationStateValues()
}
func PossibleTaskStateValues() []TaskState {
	return original.PossibleTaskStateValues()
}
func PossibleTaskTypeValues() []TaskType {
	return original.PossibleTaskTypeValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return original.PossibleUpdateActionTypeValues()
}
func PossibleValidationStatusValues() []ValidationStatus {
	return original.PossibleValidationStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
