//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package scheduledqueryrules

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/monitor/mgmt/2021-08-01/scheduledqueryrules"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ConditionOperator = original.ConditionOperator

const (
	ConditionOperatorEquals             ConditionOperator = original.ConditionOperatorEquals
	ConditionOperatorGreaterThan        ConditionOperator = original.ConditionOperatorGreaterThan
	ConditionOperatorGreaterThanOrEqual ConditionOperator = original.ConditionOperatorGreaterThanOrEqual
	ConditionOperatorLessThan           ConditionOperator = original.ConditionOperatorLessThan
	ConditionOperatorLessThanOrEqual    ConditionOperator = original.ConditionOperatorLessThanOrEqual
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DimensionOperator = original.DimensionOperator

const (
	DimensionOperatorExclude DimensionOperator = original.DimensionOperatorExclude
	DimensionOperatorInclude DimensionOperator = original.DimensionOperatorInclude
)

type Kind = original.Kind

const (
	KindLogAlert    Kind = original.KindLogAlert
	KindLogToMetric Kind = original.KindLogToMetric
)

type TimeAggregation = original.TimeAggregation

const (
	TimeAggregationAverage TimeAggregation = original.TimeAggregationAverage
	TimeAggregationCount   TimeAggregation = original.TimeAggregationCount
	TimeAggregationMaximum TimeAggregation = original.TimeAggregationMaximum
	TimeAggregationMinimum TimeAggregation = original.TimeAggregationMinimum
	TimeAggregationTotal   TimeAggregation = original.TimeAggregationTotal
)

type Actions = original.Actions
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type Client = original.Client
type Condition = original.Condition
type ConditionFailingPeriods = original.ConditionFailingPeriods
type Criteria = original.Criteria
type Dimension = original.Dimension
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorContract = original.ErrorContract
type ErrorResponse = original.ErrorResponse
type Properties = original.Properties
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ResourceCollection = original.ResourceCollection
type ResourceCollectionIterator = original.ResourceCollectionIterator
type ResourceCollectionPage = original.ResourceCollectionPage
type ResourcePatch = original.ResourcePatch
type ResourceType = original.ResourceType
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewClient(subscriptionID string) Client {
	return original.NewClient(subscriptionID)
}
func NewClientWithBaseURI(baseURI string, subscriptionID string) Client {
	return original.NewClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceCollectionIterator(page ResourceCollectionPage) ResourceCollectionIterator {
	return original.NewResourceCollectionIterator(page)
}
func NewResourceCollectionPage(cur ResourceCollection, getNextPage func(context.Context, ResourceCollection) (ResourceCollection, error)) ResourceCollectionPage {
	return original.NewResourceCollectionPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleConditionOperatorValues() []ConditionOperator {
	return original.PossibleConditionOperatorValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDimensionOperatorValues() []DimensionOperator {
	return original.PossibleDimensionOperatorValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleTimeAggregationValues() []TimeAggregation {
	return original.PossibleTimeAggregationValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
