// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opensearchservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInboundConnection = "AcceptInboundConnection"

// AcceptInboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInboundConnection for more information on using the AcceptInboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInboundConnectionRequest method.
//    req, resp := client.AcceptInboundConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AcceptInboundConnection
func (c *OpenSearchService) AcceptInboundConnectionRequest(input *AcceptInboundConnectionInput) (req *request.Request, output *AcceptInboundConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptInboundConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/accept",
	}

	if input == nil {
		input = &AcceptInboundConnectionInput{}
	}

	output = &AcceptInboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptInboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the remote domain owner to accept an inbound cross-cluster connection
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AcceptInboundConnection for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AcceptInboundConnection
func (c *OpenSearchService) AcceptInboundConnection(input *AcceptInboundConnectionInput) (*AcceptInboundConnectionOutput, error) {
	req, out := c.AcceptInboundConnectionRequest(input)
	return out, req.Send()
}

// AcceptInboundConnectionWithContext is the same as AcceptInboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AcceptInboundConnectionWithContext(ctx aws.Context, input *AcceptInboundConnectionInput, opts ...request.Option) (*AcceptInboundConnectionOutput, error) {
	req, out := c.AcceptInboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AddTags
func (c *OpenSearchService) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/tags",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon OpenSearch Service.
//
// Attaches tags to an existing domain. Tags are a set of case-sensitive key
// value pairs. An domain can have up to 10 tags. See Tagging Amazon OpenSearch
// Service domains (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging)
// for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AddTags for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AddTags
func (c *OpenSearchService) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePackage = "AssociatePackage"

// AssociatePackageRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePackage for more information on using the AssociatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociatePackageRequest method.
//    req, resp := client.AssociatePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AssociatePackage
func (c *OpenSearchService) AssociatePackageRequest(input *AssociatePackageInput) (req *request.Request, output *AssociatePackageOutput) {
	op := &request.Operation{
		Name:       opAssociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/associate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &AssociatePackageInput{}
	}

	output = &AssociatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePackage API operation for Amazon OpenSearch Service.
//
// Associates a package with an Amazon OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation AssociatePackage for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ConflictException
//   An error occurred because the client attempts to remove a resource that is
//   currently in use. Returns HTTP status code 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/AssociatePackage
func (c *OpenSearchService) AssociatePackage(input *AssociatePackageInput) (*AssociatePackageOutput, error) {
	req, out := c.AssociatePackageRequest(input)
	return out, req.Send()
}

// AssociatePackageWithContext is the same as AssociatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) AssociatePackageWithContext(ctx aws.Context, input *AssociatePackageInput, opts ...request.Option) (*AssociatePackageOutput, error) {
	req, out := c.AssociatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelServiceSoftwareUpdate = "CancelServiceSoftwareUpdate"

// CancelServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the CancelServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelServiceSoftwareUpdate for more information on using the CancelServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelServiceSoftwareUpdateRequest method.
//    req, resp := client.CancelServiceSoftwareUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CancelServiceSoftwareUpdate
func (c *OpenSearchService) CancelServiceSoftwareUpdateRequest(input *CancelServiceSoftwareUpdateInput) (req *request.Request, output *CancelServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opCancelServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel",
	}

	if input == nil {
		input = &CancelServiceSoftwareUpdateInput{}
	}

	output = &CancelServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelServiceSoftwareUpdate API operation for Amazon OpenSearch Service.
//
// Cancels a scheduled service software update for an Amazon OpenSearch Service
// domain. You can only perform this operation before the AutomatedUpdateDate
// and when the UpdateStatus is in the PENDING_UPDATE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CancelServiceSoftwareUpdate for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CancelServiceSoftwareUpdate
func (c *OpenSearchService) CancelServiceSoftwareUpdate(input *CancelServiceSoftwareUpdateInput) (*CancelServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// CancelServiceSoftwareUpdateWithContext is the same as CancelServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See CancelServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CancelServiceSoftwareUpdateWithContext(ctx aws.Context, input *CancelServiceSoftwareUpdateInput, opts ...request.Option) (*CancelServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateDomain
func (c *OpenSearchService) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon OpenSearch Service.
//
// Creates a new Amazon OpenSearch Service domain. For more information, see
// Creating and managing Amazon OpenSearch Service domains (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html)
// in the Amazon OpenSearch Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * InvalidTypeException
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ResourceAlreadyExistsException
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateDomain
func (c *OpenSearchService) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOutboundConnection = "CreateOutboundConnection"

// CreateOutboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateOutboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOutboundConnection for more information on using the CreateOutboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOutboundConnectionRequest method.
//    req, resp := client.CreateOutboundConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateOutboundConnection
func (c *OpenSearchService) CreateOutboundConnectionRequest(input *CreateOutboundConnectionInput) (req *request.Request, output *CreateOutboundConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateOutboundConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/cc/outboundConnection",
	}

	if input == nil {
		input = &CreateOutboundConnectionInput{}
	}

	output = &CreateOutboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOutboundConnection API operation for Amazon OpenSearch Service.
//
// Creates a new cross-cluster connection from a local OpenSearch domain to
// a remote OpenSearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreateOutboundConnection for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceAlreadyExistsException
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreateOutboundConnection
func (c *OpenSearchService) CreateOutboundConnection(input *CreateOutboundConnectionInput) (*CreateOutboundConnectionOutput, error) {
	req, out := c.CreateOutboundConnectionRequest(input)
	return out, req.Send()
}

// CreateOutboundConnectionWithContext is the same as CreateOutboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOutboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreateOutboundConnectionWithContext(ctx aws.Context, input *CreateOutboundConnectionInput, opts ...request.Option) (*CreateOutboundConnectionOutput, error) {
	req, out := c.CreateOutboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackage = "CreatePackage"

// CreatePackageRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackage for more information on using the CreatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePackageRequest method.
//    req, resp := client.CreatePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreatePackage
func (c *OpenSearchService) CreatePackageRequest(input *CreatePackageInput) (req *request.Request, output *CreatePackageOutput) {
	op := &request.Operation{
		Name:       opCreatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages",
	}

	if input == nil {
		input = &CreatePackageInput{}
	}

	output = &CreatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackage API operation for Amazon OpenSearch Service.
//
// Create a package for use with Amazon OpenSearch Service domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation CreatePackage for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * InvalidTypeException
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ResourceAlreadyExistsException
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/CreatePackage
func (c *OpenSearchService) CreatePackage(input *CreatePackageInput) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	return out, req.Send()
}

// CreatePackageWithContext is the same as CreatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) CreatePackageWithContext(ctx aws.Context, input *CreatePackageInput, opts ...request.Option) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteDomain
func (c *OpenSearchService) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon OpenSearch Service.
//
// Permanently deletes the specified domain and all of its data. Once a domain
// is deleted, it cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteDomain
func (c *OpenSearchService) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInboundConnection = "DeleteInboundConnection"

// DeleteInboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInboundConnection for more information on using the DeleteInboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInboundConnectionRequest method.
//    req, resp := client.DeleteInboundConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteInboundConnection
func (c *OpenSearchService) DeleteInboundConnectionRequest(input *DeleteInboundConnectionInput) (req *request.Request, output *DeleteInboundConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteInboundConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteInboundConnectionInput{}
	}

	output = &DeleteInboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the remote domain owner to delete an existing inbound cross-cluster
// connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteInboundConnection for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteInboundConnection
func (c *OpenSearchService) DeleteInboundConnection(input *DeleteInboundConnectionInput) (*DeleteInboundConnectionOutput, error) {
	req, out := c.DeleteInboundConnectionRequest(input)
	return out, req.Send()
}

// DeleteInboundConnectionWithContext is the same as DeleteInboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteInboundConnectionWithContext(ctx aws.Context, input *DeleteInboundConnectionInput, opts ...request.Option) (*DeleteInboundConnectionOutput, error) {
	req, out := c.DeleteInboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOutboundConnection = "DeleteOutboundConnection"

// DeleteOutboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOutboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOutboundConnection for more information on using the DeleteOutboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOutboundConnectionRequest method.
//    req, resp := client.DeleteOutboundConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteOutboundConnection
func (c *OpenSearchService) DeleteOutboundConnectionRequest(input *DeleteOutboundConnectionInput) (req *request.Request, output *DeleteOutboundConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteOutboundConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/opensearch/cc/outboundConnection/{ConnectionId}",
	}

	if input == nil {
		input = &DeleteOutboundConnectionInput{}
	}

	output = &DeleteOutboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOutboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the local domain owner to delete an existing outbound cross-cluster
// connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeleteOutboundConnection for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeleteOutboundConnection
func (c *OpenSearchService) DeleteOutboundConnection(input *DeleteOutboundConnectionInput) (*DeleteOutboundConnectionOutput, error) {
	req, out := c.DeleteOutboundConnectionRequest(input)
	return out, req.Send()
}

// DeleteOutboundConnectionWithContext is the same as DeleteOutboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOutboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeleteOutboundConnectionWithContext(ctx aws.Context, input *DeleteOutboundConnectionInput, opts ...request.Option) (*DeleteOutboundConnectionOutput, error) {
	req, out := c.DeleteOutboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackage = "DeletePackage"

// DeletePackageRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackage for more information on using the DeletePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePackageRequest method.
//    req, resp := client.DeletePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeletePackage
func (c *OpenSearchService) DeletePackageRequest(input *DeletePackageInput) (req *request.Request, output *DeletePackageOutput) {
	op := &request.Operation{
		Name:       opDeletePackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2021-01-01/packages/{PackageID}",
	}

	if input == nil {
		input = &DeletePackageInput{}
	}

	output = &DeletePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePackage API operation for Amazon OpenSearch Service.
//
// Deletes the package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DeletePackage for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ConflictException
//   An error occurred because the client attempts to remove a resource that is
//   currently in use. Returns HTTP status code 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DeletePackage
func (c *OpenSearchService) DeletePackage(input *DeletePackageInput) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	return out, req.Send()
}

// DeletePackageWithContext is the same as DeletePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DeletePackageWithContext(ctx aws.Context, input *DeletePackageInput, opts ...request.Option) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainRequest method.
//    req, resp := client.DescribeDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomain
func (c *OpenSearchService) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon OpenSearch Service.
//
// Returns domain configuration information about the specified domain, including
// the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomain
func (c *OpenSearchService) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainAutoTunes = "DescribeDomainAutoTunes"

// DescribeDomainAutoTunesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainAutoTunes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainAutoTunes for more information on using the DescribeDomainAutoTunes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainAutoTunesRequest method.
//    req, resp := client.DescribeDomainAutoTunesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainAutoTunes
func (c *OpenSearchService) DescribeDomainAutoTunesRequest(input *DescribeDomainAutoTunesInput) (req *request.Request, output *DescribeDomainAutoTunesOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainAutoTunes,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/autoTunes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDomainAutoTunesInput{}
	}

	output = &DescribeDomainAutoTunesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainAutoTunes API operation for Amazon OpenSearch Service.
//
// Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune
// action type, description, severity, and scheduled date.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainAutoTunes for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainAutoTunes
func (c *OpenSearchService) DescribeDomainAutoTunes(input *DescribeDomainAutoTunesInput) (*DescribeDomainAutoTunesOutput, error) {
	req, out := c.DescribeDomainAutoTunesRequest(input)
	return out, req.Send()
}

// DescribeDomainAutoTunesWithContext is the same as DescribeDomainAutoTunes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainAutoTunes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainAutoTunesWithContext(ctx aws.Context, input *DescribeDomainAutoTunesInput, opts ...request.Option) (*DescribeDomainAutoTunesOutput, error) {
	req, out := c.DescribeDomainAutoTunesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDomainAutoTunesPages iterates over the pages of a DescribeDomainAutoTunes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDomainAutoTunes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDomainAutoTunes operation.
//    pageNum := 0
//    err := client.DescribeDomainAutoTunesPages(params,
//        func(page *opensearchservice.DescribeDomainAutoTunesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) DescribeDomainAutoTunesPages(input *DescribeDomainAutoTunesInput, fn func(*DescribeDomainAutoTunesOutput, bool) bool) error {
	return c.DescribeDomainAutoTunesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDomainAutoTunesPagesWithContext same as DescribeDomainAutoTunesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainAutoTunesPagesWithContext(ctx aws.Context, input *DescribeDomainAutoTunesInput, fn func(*DescribeDomainAutoTunesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDomainAutoTunesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDomainAutoTunesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDomainAutoTunesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDomainConfig = "DescribeDomainConfig"

// DescribeDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainConfig for more information on using the DescribeDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainConfigRequest method.
//    req, resp := client.DescribeDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainConfig
func (c *OpenSearchService) DescribeDomainConfigRequest(input *DescribeDomainConfigInput) (req *request.Request, output *DescribeDomainConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/config",
	}

	if input == nil {
		input = &DescribeDomainConfigInput{}
	}

	output = &DescribeDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainConfig API operation for Amazon OpenSearch Service.
//
// Provides cluster configuration information about the specified domain, such
// as the state, creation date, update version, and update date for cluster
// options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomainConfig for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomainConfig
func (c *OpenSearchService) DescribeDomainConfig(input *DescribeDomainConfigInput) (*DescribeDomainConfigOutput, error) {
	req, out := c.DescribeDomainConfigRequest(input)
	return out, req.Send()
}

// DescribeDomainConfigWithContext is the same as DescribeDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainConfigWithContext(ctx aws.Context, input *DescribeDomainConfigInput, opts ...request.Option) (*DescribeDomainConfigOutput, error) {
	req, out := c.DescribeDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomains = "DescribeDomains"

// DescribeDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomains for more information on using the DescribeDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainsRequest method.
//    req, resp := client.DescribeDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomains
func (c *OpenSearchService) DescribeDomainsRequest(input *DescribeDomainsInput) (req *request.Request, output *DescribeDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain-info",
	}

	if input == nil {
		input = &DescribeDomainsInput{}
	}

	output = &DescribeDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomains API operation for Amazon OpenSearch Service.
//
// Returns domain configuration information about the specified domains, including
// the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeDomains for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeDomains
func (c *OpenSearchService) DescribeDomains(input *DescribeDomainsInput) (*DescribeDomainsOutput, error) {
	req, out := c.DescribeDomainsRequest(input)
	return out, req.Send()
}

// DescribeDomainsWithContext is the same as DescribeDomains with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeDomainsWithContext(ctx aws.Context, input *DescribeDomainsInput, opts ...request.Option) (*DescribeDomainsOutput, error) {
	req, out := c.DescribeDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInboundConnections = "DescribeInboundConnections"

// DescribeInboundConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInboundConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInboundConnections for more information on using the DescribeInboundConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInboundConnectionsRequest method.
//    req, resp := client.DescribeInboundConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInboundConnections
func (c *OpenSearchService) DescribeInboundConnectionsRequest(input *DescribeInboundConnectionsInput) (req *request.Request, output *DescribeInboundConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeInboundConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInboundConnectionsInput{}
	}

	output = &DescribeInboundConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInboundConnections API operation for Amazon OpenSearch Service.
//
// Lists all the inbound cross-cluster connections for a remote domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeInboundConnections for usage and error information.
//
// Returned Error Types:
//   * InvalidPaginationTokenException
//   The request processing has failed because of invalid pagination token provided
//   by customer. Returns an HTTP status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInboundConnections
func (c *OpenSearchService) DescribeInboundConnections(input *DescribeInboundConnectionsInput) (*DescribeInboundConnectionsOutput, error) {
	req, out := c.DescribeInboundConnectionsRequest(input)
	return out, req.Send()
}

// DescribeInboundConnectionsWithContext is the same as DescribeInboundConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInboundConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeInboundConnectionsWithContext(ctx aws.Context, input *DescribeInboundConnectionsInput, opts ...request.Option) (*DescribeInboundConnectionsOutput, error) {
	req, out := c.DescribeInboundConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInboundConnectionsPages iterates over the pages of a DescribeInboundConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInboundConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInboundConnections operation.
//    pageNum := 0
//    err := client.DescribeInboundConnectionsPages(params,
//        func(page *opensearchservice.DescribeInboundConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) DescribeInboundConnectionsPages(input *DescribeInboundConnectionsInput, fn func(*DescribeInboundConnectionsOutput, bool) bool) error {
	return c.DescribeInboundConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInboundConnectionsPagesWithContext same as DescribeInboundConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeInboundConnectionsPagesWithContext(ctx aws.Context, input *DescribeInboundConnectionsInput, fn func(*DescribeInboundConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInboundConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInboundConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInboundConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceTypeLimits = "DescribeInstanceTypeLimits"

// DescribeInstanceTypeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceTypeLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceTypeLimits for more information on using the DescribeInstanceTypeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceTypeLimitsRequest method.
//    req, resp := client.DescribeInstanceTypeLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInstanceTypeLimits
func (c *OpenSearchService) DescribeInstanceTypeLimitsRequest(input *DescribeInstanceTypeLimitsInput) (req *request.Request, output *DescribeInstanceTypeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceTypeLimits,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/instanceTypeLimits/{EngineVersion}/{InstanceType}",
	}

	if input == nil {
		input = &DescribeInstanceTypeLimitsInput{}
	}

	output = &DescribeInstanceTypeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceTypeLimits API operation for Amazon OpenSearch Service.
//
// Describe the limits for a given instance type and OpenSearch or Elasticsearch
// version. When modifying an existing domain, specify the DomainName to see
// which limits you can modify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeInstanceTypeLimits for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * InvalidTypeException
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeInstanceTypeLimits
func (c *OpenSearchService) DescribeInstanceTypeLimits(input *DescribeInstanceTypeLimitsInput) (*DescribeInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeInstanceTypeLimitsRequest(input)
	return out, req.Send()
}

// DescribeInstanceTypeLimitsWithContext is the same as DescribeInstanceTypeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceTypeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeInstanceTypeLimitsWithContext(ctx aws.Context, input *DescribeInstanceTypeLimitsInput, opts ...request.Option) (*DescribeInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeInstanceTypeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOutboundConnections = "DescribeOutboundConnections"

// DescribeOutboundConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOutboundConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOutboundConnections for more information on using the DescribeOutboundConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOutboundConnectionsRequest method.
//    req, resp := client.DescribeOutboundConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeOutboundConnections
func (c *OpenSearchService) DescribeOutboundConnectionsRequest(input *DescribeOutboundConnectionsInput) (req *request.Request, output *DescribeOutboundConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOutboundConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/cc/outboundConnection/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOutboundConnectionsInput{}
	}

	output = &DescribeOutboundConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOutboundConnections API operation for Amazon OpenSearch Service.
//
// Lists all the outbound cross-cluster connections for a local domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeOutboundConnections for usage and error information.
//
// Returned Error Types:
//   * InvalidPaginationTokenException
//   The request processing has failed because of invalid pagination token provided
//   by customer. Returns an HTTP status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeOutboundConnections
func (c *OpenSearchService) DescribeOutboundConnections(input *DescribeOutboundConnectionsInput) (*DescribeOutboundConnectionsOutput, error) {
	req, out := c.DescribeOutboundConnectionsRequest(input)
	return out, req.Send()
}

// DescribeOutboundConnectionsWithContext is the same as DescribeOutboundConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOutboundConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeOutboundConnectionsWithContext(ctx aws.Context, input *DescribeOutboundConnectionsInput, opts ...request.Option) (*DescribeOutboundConnectionsOutput, error) {
	req, out := c.DescribeOutboundConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOutboundConnectionsPages iterates over the pages of a DescribeOutboundConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOutboundConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOutboundConnections operation.
//    pageNum := 0
//    err := client.DescribeOutboundConnectionsPages(params,
//        func(page *opensearchservice.DescribeOutboundConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) DescribeOutboundConnectionsPages(input *DescribeOutboundConnectionsInput, fn func(*DescribeOutboundConnectionsOutput, bool) bool) error {
	return c.DescribeOutboundConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOutboundConnectionsPagesWithContext same as DescribeOutboundConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeOutboundConnectionsPagesWithContext(ctx aws.Context, input *DescribeOutboundConnectionsInput, fn func(*DescribeOutboundConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOutboundConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOutboundConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOutboundConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePackages = "DescribePackages"

// DescribePackagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackages for more information on using the DescribePackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePackagesRequest method.
//    req, resp := client.DescribePackagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribePackages
func (c *OpenSearchService) DescribePackagesRequest(input *DescribePackagesInput) (req *request.Request, output *DescribePackagesOutput) {
	op := &request.Operation{
		Name:       opDescribePackages,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/describe",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePackagesInput{}
	}

	output = &DescribePackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackages API operation for Amazon OpenSearch Service.
//
// Describes all packages available to Amazon OpenSearch Service domains. Includes
// options for filtering, limiting the number of results, and pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribePackages for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribePackages
func (c *OpenSearchService) DescribePackages(input *DescribePackagesInput) (*DescribePackagesOutput, error) {
	req, out := c.DescribePackagesRequest(input)
	return out, req.Send()
}

// DescribePackagesWithContext is the same as DescribePackages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribePackagesWithContext(ctx aws.Context, input *DescribePackagesInput, opts ...request.Option) (*DescribePackagesOutput, error) {
	req, out := c.DescribePackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePackagesPages iterates over the pages of a DescribePackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePackages operation.
//    pageNum := 0
//    err := client.DescribePackagesPages(params,
//        func(page *opensearchservice.DescribePackagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) DescribePackagesPages(input *DescribePackagesInput, fn func(*DescribePackagesOutput, bool) bool) error {
	return c.DescribePackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePackagesPagesWithContext same as DescribePackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribePackagesPagesWithContext(ctx aws.Context, input *DescribePackagesInput, fn func(*DescribePackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedInstanceOfferings = "DescribeReservedInstanceOfferings"

// DescribeReservedInstanceOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstanceOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstanceOfferings for more information on using the DescribeReservedInstanceOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedInstanceOfferingsRequest method.
//    req, resp := client.DescribeReservedInstanceOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstanceOfferings
func (c *OpenSearchService) DescribeReservedInstanceOfferingsRequest(input *DescribeReservedInstanceOfferingsInput) (req *request.Request, output *DescribeReservedInstanceOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstanceOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/reservedInstanceOfferings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstanceOfferingsInput{}
	}

	output = &DescribeReservedInstanceOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstanceOfferings API operation for Amazon OpenSearch Service.
//
// Lists available reserved OpenSearch instance offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeReservedInstanceOfferings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstanceOfferings
func (c *OpenSearchService) DescribeReservedInstanceOfferings(input *DescribeReservedInstanceOfferingsInput) (*DescribeReservedInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedInstanceOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedInstanceOfferingsWithContext is the same as DescribeReservedInstanceOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstanceOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstanceOfferingsWithContext(ctx aws.Context, input *DescribeReservedInstanceOfferingsInput, opts ...request.Option) (*DescribeReservedInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedInstanceOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedInstanceOfferingsPages iterates over the pages of a DescribeReservedInstanceOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstanceOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedInstanceOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedInstanceOfferingsPages(params,
//        func(page *opensearchservice.DescribeReservedInstanceOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) DescribeReservedInstanceOfferingsPages(input *DescribeReservedInstanceOfferingsInput, fn func(*DescribeReservedInstanceOfferingsOutput, bool) bool) error {
	return c.DescribeReservedInstanceOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedInstanceOfferingsPagesWithContext same as DescribeReservedInstanceOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstanceOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedInstanceOfferingsInput, fn func(*DescribeReservedInstanceOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedInstanceOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedInstanceOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedInstanceOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedInstances = "DescribeReservedInstances"

// DescribeReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedInstances for more information on using the DescribeReservedInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedInstancesRequest method.
//    req, resp := client.DescribeReservedInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstances
func (c *OpenSearchService) DescribeReservedInstancesRequest(input *DescribeReservedInstancesInput) (req *request.Request, output *DescribeReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/reservedInstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedInstancesInput{}
	}

	output = &DescribeReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedInstances API operation for Amazon OpenSearch Service.
//
// Returns information about reserved OpenSearch instances for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DescribeReservedInstances for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DescribeReservedInstances
func (c *OpenSearchService) DescribeReservedInstances(input *DescribeReservedInstancesInput) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedInstancesWithContext is the same as DescribeReservedInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstancesWithContext(ctx aws.Context, input *DescribeReservedInstancesInput, opts ...request.Option) (*DescribeReservedInstancesOutput, error) {
	req, out := c.DescribeReservedInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedInstancesPages iterates over the pages of a DescribeReservedInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedInstances operation.
//    pageNum := 0
//    err := client.DescribeReservedInstancesPages(params,
//        func(page *opensearchservice.DescribeReservedInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) DescribeReservedInstancesPages(input *DescribeReservedInstancesInput, fn func(*DescribeReservedInstancesOutput, bool) bool) error {
	return c.DescribeReservedInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedInstancesPagesWithContext same as DescribeReservedInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DescribeReservedInstancesPagesWithContext(ctx aws.Context, input *DescribeReservedInstancesInput, fn func(*DescribeReservedInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDissociatePackage = "DissociatePackage"

// DissociatePackageRequest generates a "aws/request.Request" representing the
// client's request for the DissociatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DissociatePackage for more information on using the DissociatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DissociatePackageRequest method.
//    req, resp := client.DissociatePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DissociatePackage
func (c *OpenSearchService) DissociatePackageRequest(input *DissociatePackageInput) (req *request.Request, output *DissociatePackageOutput) {
	op := &request.Operation{
		Name:       opDissociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/dissociate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &DissociatePackageInput{}
	}

	output = &DissociatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DissociatePackage API operation for Amazon OpenSearch Service.
//
// Dissociates a package from the Amazon OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation DissociatePackage for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ConflictException
//   An error occurred because the client attempts to remove a resource that is
//   currently in use. Returns HTTP status code 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/DissociatePackage
func (c *OpenSearchService) DissociatePackage(input *DissociatePackageInput) (*DissociatePackageOutput, error) {
	req, out := c.DissociatePackageRequest(input)
	return out, req.Send()
}

// DissociatePackageWithContext is the same as DissociatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DissociatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) DissociatePackageWithContext(ctx aws.Context, input *DissociatePackageInput, opts ...request.Option) (*DissociatePackageOutput, error) {
	req, out := c.DissociatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCompatibleVersions = "GetCompatibleVersions"

// GetCompatibleVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCompatibleVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCompatibleVersions for more information on using the GetCompatibleVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCompatibleVersionsRequest method.
//    req, resp := client.GetCompatibleVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetCompatibleVersions
func (c *OpenSearchService) GetCompatibleVersionsRequest(input *GetCompatibleVersionsInput) (req *request.Request, output *GetCompatibleVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCompatibleVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/compatibleVersions",
	}

	if input == nil {
		input = &GetCompatibleVersionsInput{}
	}

	output = &GetCompatibleVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCompatibleVersions API operation for Amazon OpenSearch Service.
//
// Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch.
// You can optionally pass a DomainName to get all upgrade-compatible versions
// of OpenSearch/Elasticsearch for that specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetCompatibleVersions for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetCompatibleVersions
func (c *OpenSearchService) GetCompatibleVersions(input *GetCompatibleVersionsInput) (*GetCompatibleVersionsOutput, error) {
	req, out := c.GetCompatibleVersionsRequest(input)
	return out, req.Send()
}

// GetCompatibleVersionsWithContext is the same as GetCompatibleVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCompatibleVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetCompatibleVersionsWithContext(ctx aws.Context, input *GetCompatibleVersionsInput, opts ...request.Option) (*GetCompatibleVersionsOutput, error) {
	req, out := c.GetCompatibleVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPackageVersionHistory = "GetPackageVersionHistory"

// GetPackageVersionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetPackageVersionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPackageVersionHistory for more information on using the GetPackageVersionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPackageVersionHistoryRequest method.
//    req, resp := client.GetPackageVersionHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetPackageVersionHistory
func (c *OpenSearchService) GetPackageVersionHistoryRequest(input *GetPackageVersionHistoryInput) (req *request.Request, output *GetPackageVersionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetPackageVersionHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/packages/{PackageID}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPackageVersionHistoryInput{}
	}

	output = &GetPackageVersionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPackageVersionHistory API operation for Amazon OpenSearch Service.
//
// Returns a list of package versions, along with their creation time and commit
// message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetPackageVersionHistory for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetPackageVersionHistory
func (c *OpenSearchService) GetPackageVersionHistory(input *GetPackageVersionHistoryInput) (*GetPackageVersionHistoryOutput, error) {
	req, out := c.GetPackageVersionHistoryRequest(input)
	return out, req.Send()
}

// GetPackageVersionHistoryWithContext is the same as GetPackageVersionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetPackageVersionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetPackageVersionHistoryWithContext(ctx aws.Context, input *GetPackageVersionHistoryInput, opts ...request.Option) (*GetPackageVersionHistoryOutput, error) {
	req, out := c.GetPackageVersionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPackageVersionHistoryPages iterates over the pages of a GetPackageVersionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPackageVersionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetPackageVersionHistory operation.
//    pageNum := 0
//    err := client.GetPackageVersionHistoryPages(params,
//        func(page *opensearchservice.GetPackageVersionHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) GetPackageVersionHistoryPages(input *GetPackageVersionHistoryInput, fn func(*GetPackageVersionHistoryOutput, bool) bool) error {
	return c.GetPackageVersionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPackageVersionHistoryPagesWithContext same as GetPackageVersionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetPackageVersionHistoryPagesWithContext(ctx aws.Context, input *GetPackageVersionHistoryInput, fn func(*GetPackageVersionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPackageVersionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPackageVersionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPackageVersionHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUpgradeHistory = "GetUpgradeHistory"

// GetUpgradeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeHistory for more information on using the GetUpgradeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUpgradeHistoryRequest method.
//    req, resp := client.GetUpgradeHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeHistory
func (c *OpenSearchService) GetUpgradeHistoryRequest(input *GetUpgradeHistoryInput) (req *request.Request, output *GetUpgradeHistoryOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/upgradeDomain/{DomainName}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUpgradeHistoryInput{}
	}

	output = &GetUpgradeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeHistory API operation for Amazon OpenSearch Service.
//
// Retrieves the complete history of the last 10 upgrades performed on the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetUpgradeHistory for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeHistory
func (c *OpenSearchService) GetUpgradeHistory(input *GetUpgradeHistoryInput) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	return out, req.Send()
}

// GetUpgradeHistoryWithContext is the same as GetUpgradeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetUpgradeHistoryWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, opts ...request.Option) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUpgradeHistoryPages iterates over the pages of a GetUpgradeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUpgradeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUpgradeHistory operation.
//    pageNum := 0
//    err := client.GetUpgradeHistoryPages(params,
//        func(page *opensearchservice.GetUpgradeHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) GetUpgradeHistoryPages(input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool) error {
	return c.GetUpgradeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUpgradeHistoryPagesWithContext same as GetUpgradeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetUpgradeHistoryPagesWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUpgradeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUpgradeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUpgradeHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUpgradeStatus = "GetUpgradeStatus"

// GetUpgradeStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeStatus for more information on using the GetUpgradeStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUpgradeStatusRequest method.
//    req, resp := client.GetUpgradeStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeStatus
func (c *OpenSearchService) GetUpgradeStatusRequest(input *GetUpgradeStatusInput) (req *request.Request, output *GetUpgradeStatusOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/upgradeDomain/{DomainName}/status",
	}

	if input == nil {
		input = &GetUpgradeStatusInput{}
	}

	output = &GetUpgradeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeStatus API operation for Amazon OpenSearch Service.
//
// Retrieves the latest status of the last upgrade or upgrade eligibility check
// performed on the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation GetUpgradeStatus for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/GetUpgradeStatus
func (c *OpenSearchService) GetUpgradeStatus(input *GetUpgradeStatusInput) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	return out, req.Send()
}

// GetUpgradeStatusWithContext is the same as GetUpgradeStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) GetUpgradeStatusWithContext(ctx aws.Context, input *GetUpgradeStatusInput, opts ...request.Option) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainNames for more information on using the ListDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainNamesRequest method.
//    req, resp := client.ListDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainNames
func (c *OpenSearchService) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/domain",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	output = &ListDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainNames API operation for Amazon OpenSearch Service.
//
// Returns the names of all domains owned by the current user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainNames
func (c *OpenSearchService) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	return out, req.Send()
}

// ListDomainNamesWithContext is the same as ListDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainNamesWithContext(ctx aws.Context, input *ListDomainNamesInput, opts ...request.Option) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainsForPackage = "ListDomainsForPackage"

// ListDomainsForPackageRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainsForPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainsForPackage for more information on using the ListDomainsForPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainsForPackageRequest method.
//    req, resp := client.ListDomainsForPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainsForPackage
func (c *OpenSearchService) ListDomainsForPackageRequest(input *ListDomainsForPackageInput) (req *request.Request, output *ListDomainsForPackageOutput) {
	op := &request.Operation{
		Name:       opListDomainsForPackage,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/packages/{PackageID}/domains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsForPackageInput{}
	}

	output = &ListDomainsForPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainsForPackage API operation for Amazon OpenSearch Service.
//
// Lists all Amazon OpenSearch Service domains associated with the package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListDomainsForPackage for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListDomainsForPackage
func (c *OpenSearchService) ListDomainsForPackage(input *ListDomainsForPackageInput) (*ListDomainsForPackageOutput, error) {
	req, out := c.ListDomainsForPackageRequest(input)
	return out, req.Send()
}

// ListDomainsForPackageWithContext is the same as ListDomainsForPackage with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainsForPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainsForPackageWithContext(ctx aws.Context, input *ListDomainsForPackageInput, opts ...request.Option) (*ListDomainsForPackageOutput, error) {
	req, out := c.ListDomainsForPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsForPackagePages iterates over the pages of a ListDomainsForPackage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomainsForPackage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomainsForPackage operation.
//    pageNum := 0
//    err := client.ListDomainsForPackagePages(params,
//        func(page *opensearchservice.ListDomainsForPackageOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) ListDomainsForPackagePages(input *ListDomainsForPackageInput, fn func(*ListDomainsForPackageOutput, bool) bool) error {
	return c.ListDomainsForPackagePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsForPackagePagesWithContext same as ListDomainsForPackagePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListDomainsForPackagePagesWithContext(ctx aws.Context, input *ListDomainsForPackageInput, fn func(*ListDomainsForPackageOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsForPackageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsForPackageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsForPackageOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceTypeDetails = "ListInstanceTypeDetails"

// ListInstanceTypeDetailsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceTypeDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceTypeDetails for more information on using the ListInstanceTypeDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstanceTypeDetailsRequest method.
//    req, resp := client.ListInstanceTypeDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListInstanceTypeDetails
func (c *OpenSearchService) ListInstanceTypeDetailsRequest(input *ListInstanceTypeDetailsInput) (req *request.Request, output *ListInstanceTypeDetailsOutput) {
	op := &request.Operation{
		Name:       opListInstanceTypeDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/instanceTypeDetails/{EngineVersion}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceTypeDetailsInput{}
	}

	output = &ListInstanceTypeDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceTypeDetails API operation for Amazon OpenSearch Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListInstanceTypeDetails for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListInstanceTypeDetails
func (c *OpenSearchService) ListInstanceTypeDetails(input *ListInstanceTypeDetailsInput) (*ListInstanceTypeDetailsOutput, error) {
	req, out := c.ListInstanceTypeDetailsRequest(input)
	return out, req.Send()
}

// ListInstanceTypeDetailsWithContext is the same as ListInstanceTypeDetails with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceTypeDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListInstanceTypeDetailsWithContext(ctx aws.Context, input *ListInstanceTypeDetailsInput, opts ...request.Option) (*ListInstanceTypeDetailsOutput, error) {
	req, out := c.ListInstanceTypeDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstanceTypeDetailsPages iterates over the pages of a ListInstanceTypeDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceTypeDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstanceTypeDetails operation.
//    pageNum := 0
//    err := client.ListInstanceTypeDetailsPages(params,
//        func(page *opensearchservice.ListInstanceTypeDetailsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) ListInstanceTypeDetailsPages(input *ListInstanceTypeDetailsInput, fn func(*ListInstanceTypeDetailsOutput, bool) bool) error {
	return c.ListInstanceTypeDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstanceTypeDetailsPagesWithContext same as ListInstanceTypeDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListInstanceTypeDetailsPagesWithContext(ctx aws.Context, input *ListInstanceTypeDetailsInput, fn func(*ListInstanceTypeDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstanceTypeDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstanceTypeDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstanceTypeDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackagesForDomain = "ListPackagesForDomain"

// ListPackagesForDomainRequest generates a "aws/request.Request" representing the
// client's request for the ListPackagesForDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackagesForDomain for more information on using the ListPackagesForDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPackagesForDomainRequest method.
//    req, resp := client.ListPackagesForDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListPackagesForDomain
func (c *OpenSearchService) ListPackagesForDomainRequest(input *ListPackagesForDomainInput) (req *request.Request, output *ListPackagesForDomainOutput) {
	op := &request.Operation{
		Name:       opListPackagesForDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/domain/{DomainName}/packages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagesForDomainInput{}
	}

	output = &ListPackagesForDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackagesForDomain API operation for Amazon OpenSearch Service.
//
// Lists all packages associated with the Amazon OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListPackagesForDomain for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListPackagesForDomain
func (c *OpenSearchService) ListPackagesForDomain(input *ListPackagesForDomainInput) (*ListPackagesForDomainOutput, error) {
	req, out := c.ListPackagesForDomainRequest(input)
	return out, req.Send()
}

// ListPackagesForDomainWithContext is the same as ListPackagesForDomain with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackagesForDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListPackagesForDomainWithContext(ctx aws.Context, input *ListPackagesForDomainInput, opts ...request.Option) (*ListPackagesForDomainOutput, error) {
	req, out := c.ListPackagesForDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagesForDomainPages iterates over the pages of a ListPackagesForDomain operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackagesForDomain method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPackagesForDomain operation.
//    pageNum := 0
//    err := client.ListPackagesForDomainPages(params,
//        func(page *opensearchservice.ListPackagesForDomainOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) ListPackagesForDomainPages(input *ListPackagesForDomainInput, fn func(*ListPackagesForDomainOutput, bool) bool) error {
	return c.ListPackagesForDomainPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagesForDomainPagesWithContext same as ListPackagesForDomainPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListPackagesForDomainPagesWithContext(ctx aws.Context, input *ListPackagesForDomainInput, fn func(*ListPackagesForDomainOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagesForDomainInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagesForDomainRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagesForDomainOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListTags
func (c *OpenSearchService) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/tags/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon OpenSearch Service.
//
// Returns all tags for the given domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListTags
func (c *OpenSearchService) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVersions = "ListVersions"

// ListVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVersions for more information on using the ListVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVersionsRequest method.
//    req, resp := client.ListVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVersions
func (c *OpenSearchService) ListVersionsRequest(input *ListVersionsInput) (req *request.Request, output *ListVersionsOutput) {
	op := &request.Operation{
		Name:       opListVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2021-01-01/opensearch/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVersionsInput{}
	}

	output = &ListVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVersions API operation for Amazon OpenSearch Service.
//
// List all supported versions of OpenSearch and Elasticsearch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation ListVersions for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ListVersions
func (c *OpenSearchService) ListVersions(input *ListVersionsInput) (*ListVersionsOutput, error) {
	req, out := c.ListVersionsRequest(input)
	return out, req.Send()
}

// ListVersionsWithContext is the same as ListVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVersionsWithContext(ctx aws.Context, input *ListVersionsInput, opts ...request.Option) (*ListVersionsOutput, error) {
	req, out := c.ListVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVersionsPages iterates over the pages of a ListVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVersions operation.
//    pageNum := 0
//    err := client.ListVersionsPages(params,
//        func(page *opensearchservice.ListVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpenSearchService) ListVersionsPages(input *ListVersionsInput, fn func(*ListVersionsOutput, bool) bool) error {
	return c.ListVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVersionsPagesWithContext same as ListVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) ListVersionsPagesWithContext(ctx aws.Context, input *ListVersionsInput, fn func(*ListVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPurchaseReservedInstanceOffering = "PurchaseReservedInstanceOffering"

// PurchaseReservedInstanceOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedInstanceOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedInstanceOffering for more information on using the PurchaseReservedInstanceOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseReservedInstanceOfferingRequest method.
//    req, resp := client.PurchaseReservedInstanceOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/PurchaseReservedInstanceOffering
func (c *OpenSearchService) PurchaseReservedInstanceOfferingRequest(input *PurchaseReservedInstanceOfferingInput) (req *request.Request, output *PurchaseReservedInstanceOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedInstanceOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/purchaseReservedInstanceOffering",
	}

	if input == nil {
		input = &PurchaseReservedInstanceOfferingInput{}
	}

	output = &PurchaseReservedInstanceOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedInstanceOffering API operation for Amazon OpenSearch Service.
//
// Allows you to purchase reserved OpenSearch instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation PurchaseReservedInstanceOffering for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ResourceAlreadyExistsException
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/PurchaseReservedInstanceOffering
func (c *OpenSearchService) PurchaseReservedInstanceOffering(input *PurchaseReservedInstanceOfferingInput) (*PurchaseReservedInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedInstanceOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedInstanceOfferingWithContext is the same as PurchaseReservedInstanceOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedInstanceOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) PurchaseReservedInstanceOfferingWithContext(ctx aws.Context, input *PurchaseReservedInstanceOfferingInput, opts ...request.Option) (*PurchaseReservedInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedInstanceOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectInboundConnection = "RejectInboundConnection"

// RejectInboundConnectionRequest generates a "aws/request.Request" representing the
// client's request for the RejectInboundConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInboundConnection for more information on using the RejectInboundConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectInboundConnectionRequest method.
//    req, resp := client.RejectInboundConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RejectInboundConnection
func (c *OpenSearchService) RejectInboundConnectionRequest(input *RejectInboundConnectionInput) (req *request.Request, output *RejectInboundConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectInboundConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/reject",
	}

	if input == nil {
		input = &RejectInboundConnectionInput{}
	}

	output = &RejectInboundConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectInboundConnection API operation for Amazon OpenSearch Service.
//
// Allows the remote domain owner to reject an inbound cross-cluster connection
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation RejectInboundConnection for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RejectInboundConnection
func (c *OpenSearchService) RejectInboundConnection(input *RejectInboundConnectionInput) (*RejectInboundConnectionOutput, error) {
	req, out := c.RejectInboundConnectionRequest(input)
	return out, req.Send()
}

// RejectInboundConnectionWithContext is the same as RejectInboundConnection with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInboundConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) RejectInboundConnectionWithContext(ctx aws.Context, input *RejectInboundConnectionInput, opts ...request.Option) (*RejectInboundConnectionOutput, error) {
	req, out := c.RejectInboundConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RemoveTags
func (c *OpenSearchService) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/tags-removal",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon OpenSearch Service.
//
// Removes the specified set of tags from the given domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation RemoveTags for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/RemoveTags
func (c *OpenSearchService) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartServiceSoftwareUpdate = "StartServiceSoftwareUpdate"

// StartServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the StartServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartServiceSoftwareUpdate for more information on using the StartServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartServiceSoftwareUpdateRequest method.
//    req, resp := client.StartServiceSoftwareUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/StartServiceSoftwareUpdate
func (c *OpenSearchService) StartServiceSoftwareUpdateRequest(input *StartServiceSoftwareUpdateInput) (req *request.Request, output *StartServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opStartServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/serviceSoftwareUpdate/start",
	}

	if input == nil {
		input = &StartServiceSoftwareUpdateInput{}
	}

	output = &StartServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartServiceSoftwareUpdate API operation for Amazon OpenSearch Service.
//
// Schedules a service software update for an Amazon OpenSearch Service domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation StartServiceSoftwareUpdate for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/StartServiceSoftwareUpdate
func (c *OpenSearchService) StartServiceSoftwareUpdate(input *StartServiceSoftwareUpdateInput) (*StartServiceSoftwareUpdateOutput, error) {
	req, out := c.StartServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// StartServiceSoftwareUpdateWithContext is the same as StartServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See StartServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) StartServiceSoftwareUpdateWithContext(ctx aws.Context, input *StartServiceSoftwareUpdateInput, opts ...request.Option) (*StartServiceSoftwareUpdateOutput, error) {
	req, out := c.StartServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainConfig = "UpdateDomainConfig"

// UpdateDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainConfig for more information on using the UpdateDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainConfigRequest method.
//    req, resp := client.UpdateDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateDomainConfig
func (c *OpenSearchService) UpdateDomainConfigRequest(input *UpdateDomainConfigInput) (req *request.Request, output *UpdateDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/domain/{DomainName}/config",
	}

	if input == nil {
		input = &UpdateDomainConfigInput{}
	}

	output = &UpdateDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainConfig API operation for Amazon OpenSearch Service.
//
// Modifies the cluster configuration of the specified domain, such as setting
// the instance type and the number of instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdateDomainConfig for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * InvalidTypeException
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdateDomainConfig
func (c *OpenSearchService) UpdateDomainConfig(input *UpdateDomainConfigInput) (*UpdateDomainConfigOutput, error) {
	req, out := c.UpdateDomainConfigRequest(input)
	return out, req.Send()
}

// UpdateDomainConfigWithContext is the same as UpdateDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdateDomainConfigWithContext(ctx aws.Context, input *UpdateDomainConfigInput, opts ...request.Option) (*UpdateDomainConfigOutput, error) {
	req, out := c.UpdateDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePackage = "UpdatePackage"

// UpdatePackageRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePackage for more information on using the UpdatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePackageRequest method.
//    req, resp := client.UpdatePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdatePackage
func (c *OpenSearchService) UpdatePackageRequest(input *UpdatePackageInput) (req *request.Request, output *UpdatePackageOutput) {
	op := &request.Operation{
		Name:       opUpdatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/packages/update",
	}

	if input == nil {
		input = &UpdatePackageInput{}
	}

	output = &UpdatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePackage API operation for Amazon OpenSearch Service.
//
// Updates a package for use with Amazon OpenSearch Service domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpdatePackage for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * AccessDeniedException
//   An error occurred because user does not have permissions to access the resource.
//   Returns HTTP status code 403.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpdatePackage
func (c *OpenSearchService) UpdatePackage(input *UpdatePackageInput) (*UpdatePackageOutput, error) {
	req, out := c.UpdatePackageRequest(input)
	return out, req.Send()
}

// UpdatePackageWithContext is the same as UpdatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpdatePackageWithContext(ctx aws.Context, input *UpdatePackageInput, opts ...request.Option) (*UpdatePackageOutput, error) {
	req, out := c.UpdatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeDomain = "UpgradeDomain"

// UpgradeDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeDomain for more information on using the UpgradeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpgradeDomainRequest method.
//    req, resp := client.UpgradeDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpgradeDomain
func (c *OpenSearchService) UpgradeDomainRequest(input *UpgradeDomainInput) (req *request.Request, output *UpgradeDomainOutput) {
	op := &request.Operation{
		Name:       opUpgradeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2021-01-01/opensearch/upgradeDomain",
	}

	if input == nil {
		input = &UpgradeDomainInput{}
	}

	output = &UpgradeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpgradeDomain API operation for Amazon OpenSearch Service.
//
// Allows you to either upgrade your domain or perform an upgrade eligibility
// check to a compatible version of OpenSearch or Elasticsearch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon OpenSearch Service's
// API operation UpgradeDomain for usage and error information.
//
// Returned Error Types:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ResourceAlreadyExistsException
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/UpgradeDomain
func (c *OpenSearchService) UpgradeDomain(input *UpgradeDomainInput) (*UpgradeDomainOutput, error) {
	req, out := c.UpgradeDomainRequest(input)
	return out, req.Send()
}

// UpgradeDomainWithContext is the same as UpgradeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchService) UpgradeDomainWithContext(ctx aws.Context, input *UpgradeDomainInput, opts ...request.Option) (*UpgradeDomainOutput, error) {
	req, out := c.UpgradeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AWSDomainInformation struct {
	_ struct{} `type:"structure"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	OwnerId *string `min:"12" type:"string"`

	Region *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AWSDomainInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AWSDomainInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AWSDomainInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AWSDomainInformation"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.OwnerId != nil && len(*s.OwnerId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerId", 12))
	}
	if s.Region != nil && len(*s.Region) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AWSDomainInformation) SetDomainName(v string) *AWSDomainInformation {
	s.DomainName = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AWSDomainInformation) SetOwnerId(v string) *AWSDomainInformation {
	s.OwnerId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *AWSDomainInformation) SetRegion(v string) *AWSDomainInformation {
	s.Region = &v
	return s
}

// Container for the parameters to the AcceptInboundConnection operation.
type AcceptInboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the inbound connection you want to accept.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AcceptInboundConnectionInput) SetConnectionId(v string) *AcceptInboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// The result of an AcceptInboundConnection operation. Contains details about
// the accepted inbound connection.
type AcceptInboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The InboundConnection of the accepted inbound connection.
	Connection *InboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *AcceptInboundConnectionOutput) SetConnection(v *InboundConnection) *AcceptInboundConnectionOutput {
	s.Connection = v
	return s
}

// An error occurred because user does not have permissions to access the resource.
// Returns HTTP status code 403.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the domain. Access policies can be resource-based,
	// IP-based, or IAM-based. See Configuring access policies (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies)for
	// more information.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the domain. See OptionStatus for the
	// status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AccessPoliciesStatus) SetOptions(v string) *AccessPoliciesStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPoliciesStatus) SetStatus(v *OptionStatus) *AccessPoliciesStatus {
	s.Status = v
	return s
}

// Container for the parameters to the AddTags operation. Specifies the tags
// to attach to the domain.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN of the domain you want to add tags to.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// List of Tag to add to the domain.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *AddTagsInput) SetARN(v string) *AddTagsInput {
	s.ARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsInput) SetTagList(v []*Tag) *AddTagsInput {
	s.TagList = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// List of limits that are specific to a given InstanceType and for each of
// its InstanceRole .
type AdditionalLimit struct {
	_ struct{} `type:"structure"`

	// Additional limit is specific to a given InstanceType and for each of its
	// InstanceRole etc. Attributes and their details:
	//    * MaximumNumberOfDataNodesSupported
	//
	//    * MaximumNumberOfDataNodesWithoutMasterNode
	LimitName *string `type:"string"`

	// Value for a given AdditionalLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *AdditionalLimit) SetLimitName(v string) *AdditionalLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *AdditionalLimit) SetLimitValues(v []*string) *AdditionalLimit {
	s.LimitValues = v
	return s
}

// Status of the advanced options for the specified domain. Currently, the following
// advanced options are available:
//
//    * Option to allow references to indices in an HTTP request body. Must
//    be false when configuring access to individual sub-resources. By default,
//    the value is true. See Advanced cluster parameters for more information.
//
//    * Option to specify the percentage of heap space allocated to field data.
//    By default, this setting is unbounded.
//
// For more information, see Advanced cluster parameters (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The status of advanced options for the specified domain.
	//
	// Options is a required field
	Options map[string]*string `type:"map" required:"true"`

	// The OptionStatus for advanced options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedOptionsStatus) SetOptions(v map[string]*string) *AdvancedOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedOptionsStatus) SetStatus(v *OptionStatus) *AdvancedOptionsStatus {
	s.Status = v
	return s
}

// The advanced security configuration: whether advanced security is enabled,
// whether the internal database option is enabled.
type AdvancedSecurityOptions struct {
	_ struct{} `type:"structure"`

	// True if advanced security is enabled.
	Enabled *bool `type:"boolean"`

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool `type:"boolean"`

	// Describes the SAML application configured for a domain.
	SAMLOptions *SAMLOptionsOutput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AdvancedSecurityOptions) SetEnabled(v bool) *AdvancedSecurityOptions {
	s.Enabled = &v
	return s
}

// SetInternalUserDatabaseEnabled sets the InternalUserDatabaseEnabled field's value.
func (s *AdvancedSecurityOptions) SetInternalUserDatabaseEnabled(v bool) *AdvancedSecurityOptions {
	s.InternalUserDatabaseEnabled = &v
	return s
}

// SetSAMLOptions sets the SAMLOptions field's value.
func (s *AdvancedSecurityOptions) SetSAMLOptions(v *SAMLOptionsOutput_) *AdvancedSecurityOptions {
	s.SAMLOptions = v
	return s
}

// The advanced security configuration: whether advanced security is enabled,
// whether the internal database option is enabled, master username and password
// (if internal database is enabled), and master user ARN (if IAM is enabled).
type AdvancedSecurityOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// True if advanced security is enabled.
	Enabled *bool `type:"boolean"`

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool `type:"boolean"`

	// Credentials for the master user: username and password, ARN, or both.
	MasterUserOptions *MasterUserOptions `type:"structure"`

	// The SAML application configuration for the domain.
	SAMLOptions *SAMLOptionsInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvancedSecurityOptionsInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvancedSecurityOptionsInput_"}
	if s.MasterUserOptions != nil {
		if err := s.MasterUserOptions.Validate(); err != nil {
			invalidParams.AddNested("MasterUserOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.SAMLOptions != nil {
		if err := s.SAMLOptions.Validate(); err != nil {
			invalidParams.AddNested("SAMLOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *AdvancedSecurityOptionsInput_) SetEnabled(v bool) *AdvancedSecurityOptionsInput_ {
	s.Enabled = &v
	return s
}

// SetInternalUserDatabaseEnabled sets the InternalUserDatabaseEnabled field's value.
func (s *AdvancedSecurityOptionsInput_) SetInternalUserDatabaseEnabled(v bool) *AdvancedSecurityOptionsInput_ {
	s.InternalUserDatabaseEnabled = &v
	return s
}

// SetMasterUserOptions sets the MasterUserOptions field's value.
func (s *AdvancedSecurityOptionsInput_) SetMasterUserOptions(v *MasterUserOptions) *AdvancedSecurityOptionsInput_ {
	s.MasterUserOptions = v
	return s
}

// SetSAMLOptions sets the SAMLOptions field's value.
func (s *AdvancedSecurityOptionsInput_) SetSAMLOptions(v *SAMLOptionsInput_) *AdvancedSecurityOptionsInput_ {
	s.SAMLOptions = v
	return s
}

// The status of advanced security options for the specified domain.
type AdvancedSecurityOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Advanced security options for the specified domain.
	//
	// Options is a required field
	Options *AdvancedSecurityOptions `type:"structure" required:"true"`

	// Status of the advanced security options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedSecurityOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedSecurityOptionsStatus) SetOptions(v *AdvancedSecurityOptions) *AdvancedSecurityOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedSecurityOptionsStatus) SetStatus(v *OptionStatus) *AdvancedSecurityOptionsStatus {
	s.Status = v
	return s
}

// Container for the request parameters to the AssociatePackage operation.
type AssociatePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain to associate the package with.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Internal ID of the package to associate with a domain. Use DescribePackages
	// to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePackageInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AssociatePackageInput) SetDomainName(v string) *AssociatePackageInput {
	s.DomainName = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *AssociatePackageInput) SetPackageID(v string) *AssociatePackageInput {
	s.PackageID = &v
	return s
}

// Container for the response returned by AssociatePackage operation.
type AssociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// DomainPackageDetails
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetails sets the DomainPackageDetails field's value.
func (s *AssociatePackageOutput) SetDomainPackageDetails(v *DomainPackageDetails) *AssociatePackageOutput {
	s.DomainPackageDetails = v
	return s
}

// Specifies the Auto-Tune type and Auto-Tune action details.
type AutoTune struct {
	_ struct{} `type:"structure"`

	// Specifies details about the Auto-Tune action. See Auto-Tune for Amazon OpenSearch
	// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	AutoTuneDetails *AutoTuneDetails `type:"structure"`

	// Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.
	AutoTuneType *string `type:"string" enum:"AutoTuneType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTune) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTune) GoString() string {
	return s.String()
}

// SetAutoTuneDetails sets the AutoTuneDetails field's value.
func (s *AutoTune) SetAutoTuneDetails(v *AutoTuneDetails) *AutoTune {
	s.AutoTuneDetails = v
	return s
}

// SetAutoTuneType sets the AutoTuneType field's value.
func (s *AutoTune) SetAutoTuneType(v string) *AutoTune {
	s.AutoTuneType = &v
	return s
}

// Specifies details about the Auto-Tune action. See Auto-Tune for Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type AutoTuneDetails struct {
	_ struct{} `type:"structure"`

	// Specifies details about the scheduled Auto-Tune action. See Auto-Tune for
	// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	ScheduledAutoTuneDetails *ScheduledAutoTuneDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneDetails) GoString() string {
	return s.String()
}

// SetScheduledAutoTuneDetails sets the ScheduledAutoTuneDetails field's value.
func (s *AutoTuneDetails) SetScheduledAutoTuneDetails(v *ScheduledAutoTuneDetails) *AutoTuneDetails {
	s.ScheduledAutoTuneDetails = v
	return s
}

// Specifies the Auto-Tune maintenance schedule. See Auto-Tune for Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type AutoTuneMaintenanceSchedule struct {
	_ struct{} `type:"structure"`

	// A cron expression for a recurring maintenance schedule. See Auto-Tune for
	// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	CronExpressionForRecurrence *string `type:"string"`

	// Specifies maintenance schedule duration: duration value and duration unit.
	// See Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Duration *Duration `type:"structure"`

	// The timestamp at which the Auto-Tune maintenance schedule starts.
	StartAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneMaintenanceSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneMaintenanceSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneMaintenanceSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneMaintenanceSchedule"}
	if s.Duration != nil {
		if err := s.Duration.Validate(); err != nil {
			invalidParams.AddNested("Duration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCronExpressionForRecurrence sets the CronExpressionForRecurrence field's value.
func (s *AutoTuneMaintenanceSchedule) SetCronExpressionForRecurrence(v string) *AutoTuneMaintenanceSchedule {
	s.CronExpressionForRecurrence = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *AutoTuneMaintenanceSchedule) SetDuration(v *Duration) *AutoTuneMaintenanceSchedule {
	s.Duration = v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *AutoTuneMaintenanceSchedule) SetStartAt(v time.Time) *AutoTuneMaintenanceSchedule {
	s.StartAt = &v
	return s
}

// The Auto-Tune options: the Auto-Tune desired state for the domain, rollback
// state when disabling Auto-Tune options and list of maintenance schedules.
type AutoTuneOptions struct {
	_ struct{} `type:"structure"`

	// The Auto-Tune desired state. Valid values are ENABLED and DISABLED.
	DesiredState *string `type:"string" enum:"AutoTuneDesiredState"`

	// A list of maintenance schedules. See Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	MaintenanceSchedules []*AutoTuneMaintenanceSchedule `type:"list"`

	// The rollback state while disabling Auto-Tune for the domain. Valid values
	// are NO_ROLLBACK and DEFAULT_ROLLBACK.
	RollbackOnDisable *string `type:"string" enum:"RollbackOnDisable"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneOptions"}
	if s.MaintenanceSchedules != nil {
		for i, v := range s.MaintenanceSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MaintenanceSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *AutoTuneOptions) SetDesiredState(v string) *AutoTuneOptions {
	s.DesiredState = &v
	return s
}

// SetMaintenanceSchedules sets the MaintenanceSchedules field's value.
func (s *AutoTuneOptions) SetMaintenanceSchedules(v []*AutoTuneMaintenanceSchedule) *AutoTuneOptions {
	s.MaintenanceSchedules = v
	return s
}

// SetRollbackOnDisable sets the RollbackOnDisable field's value.
func (s *AutoTuneOptions) SetRollbackOnDisable(v string) *AutoTuneOptions {
	s.RollbackOnDisable = &v
	return s
}

// The Auto-Tune options: the Auto-Tune desired state for the domain and list
// of maintenance schedules.
type AutoTuneOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// The Auto-Tune desired state. Valid values are ENABLED and DISABLED.
	DesiredState *string `type:"string" enum:"AutoTuneDesiredState"`

	// A list of maintenance schedules. See Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	MaintenanceSchedules []*AutoTuneMaintenanceSchedule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoTuneOptionsInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoTuneOptionsInput_"}
	if s.MaintenanceSchedules != nil {
		for i, v := range s.MaintenanceSchedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MaintenanceSchedules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *AutoTuneOptionsInput_) SetDesiredState(v string) *AutoTuneOptionsInput_ {
	s.DesiredState = &v
	return s
}

// SetMaintenanceSchedules sets the MaintenanceSchedules field's value.
func (s *AutoTuneOptionsInput_) SetMaintenanceSchedules(v []*AutoTuneMaintenanceSchedule) *AutoTuneOptionsInput_ {
	s.MaintenanceSchedules = v
	return s
}

// The Auto-Tune options: the Auto-Tune desired state for the domain and list
// of maintenance schedules.
type AutoTuneOptionsOutput_ struct {
	_ struct{} `type:"structure"`

	// The error message while enabling or disabling Auto-Tune.
	ErrorMessage *string `type:"string"`

	// The AutoTuneState for the domain.
	State *string `type:"string" enum:"AutoTuneState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsOutput_) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AutoTuneOptionsOutput_) SetErrorMessage(v string) *AutoTuneOptionsOutput_ {
	s.ErrorMessage = &v
	return s
}

// SetState sets the State field's value.
func (s *AutoTuneOptionsOutput_) SetState(v string) *AutoTuneOptionsOutput_ {
	s.State = &v
	return s
}

// The Auto-Tune status for the domain.
type AutoTuneOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies Auto-Tune options for the domain.
	Options *AutoTuneOptions `type:"structure"`

	// The status of the Auto-Tune options for the domain.
	Status *AutoTuneStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AutoTuneOptionsStatus) SetOptions(v *AutoTuneOptions) *AutoTuneOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoTuneOptionsStatus) SetStatus(v *AutoTuneStatus) *AutoTuneOptionsStatus {
	s.Status = v
	return s
}

// Provides the current Auto-Tune status for the domain.
type AutoTuneStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp of the Auto-Tune options creation date.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// The error message while enabling or disabling Auto-Tune.
	ErrorMessage *string `type:"string"`

	// Indicates whether the domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// The AutoTuneState for the domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"AutoTuneState"`

	// The timestamp of when the Auto-Tune options were last updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// The latest version of the Auto-Tune options.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoTuneStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AutoTuneStatus) SetCreationDate(v time.Time) *AutoTuneStatus {
	s.CreationDate = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AutoTuneStatus) SetErrorMessage(v string) *AutoTuneStatus {
	s.ErrorMessage = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *AutoTuneStatus) SetPendingDeletion(v bool) *AutoTuneStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *AutoTuneStatus) SetState(v string) *AutoTuneStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *AutoTuneStatus) SetUpdateDate(v time.Time) *AutoTuneStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *AutoTuneStatus) SetUpdateVersion(v int64) *AutoTuneStatus {
	s.UpdateVersion = &v
	return s
}

// An error occurred while processing the request.
type BaseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseException) GoString() string {
	return s.String()
}

func newErrorBaseException(v protocol.ResponseMetadata) error {
	return &BaseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BaseException) Code() string {
	return "BaseException"
}

// Message returns the exception's message.
func (s *BaseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BaseException) OrigErr() error {
	return nil
}

func (s *BaseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BaseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BaseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for the parameters to the CancelServiceSoftwareUpdate operation.
// Specifies the name of the domain that you wish to cancel a service software
// update on.
type CancelServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to stop the latest service software
	// update on.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CancelServiceSoftwareUpdateInput) SetDomainName(v string) *CancelServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// The result of a CancelServiceSoftwareUpdate operation. Contains the status
// of the update.
type CancelServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the OpenSearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *CancelServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *CancelServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// The configuration for the domain cluster, such as the type and number of
// instances.
type ClusterConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the ColdStorageOptions config for a Domain
	ColdStorageOptions *ColdStorageOptions `type:"structure"`

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int64 `type:"integer"`

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// Dedicated master nodes in Amazon OpenSearch Service (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The instance type for a dedicated master node.
	DedicatedMasterType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// The number of instances in the specified domain cluster.
	InstanceCount *int64 `type:"integer"`

	// The instance type for an OpenSearch cluster. UltraWarm instance types are
	// not supported for data instances.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// The number of UltraWarm nodes in the cluster.
	WarmCount *int64 `type:"integer"`

	// True to enable UltraWarm storage.
	WarmEnabled *bool `type:"boolean"`

	// The instance type for the OpenSearch cluster's warm nodes.
	WarmType *string `type:"string" enum:"OpenSearchWarmPartitionInstanceType"`

	// The zone awareness configuration for a domain when zone awareness is enabled.
	ZoneAwarenessConfig *ZoneAwarenessConfig `type:"structure"`

	// A boolean value to indicate whether zone awareness is enabled. See Configuring
	// a multi-AZ domain in Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html)
	// for more information.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClusterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClusterConfig"}
	if s.ColdStorageOptions != nil {
		if err := s.ColdStorageOptions.Validate(); err != nil {
			invalidParams.AddNested("ColdStorageOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColdStorageOptions sets the ColdStorageOptions field's value.
func (s *ClusterConfig) SetColdStorageOptions(v *ColdStorageOptions) *ClusterConfig {
	s.ColdStorageOptions = v
	return s
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *ClusterConfig) SetDedicatedMasterCount(v int64) *ClusterConfig {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *ClusterConfig) SetDedicatedMasterEnabled(v bool) *ClusterConfig {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *ClusterConfig) SetDedicatedMasterType(v string) *ClusterConfig {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ClusterConfig) SetInstanceCount(v int64) *ClusterConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ClusterConfig) SetInstanceType(v string) *ClusterConfig {
	s.InstanceType = &v
	return s
}

// SetWarmCount sets the WarmCount field's value.
func (s *ClusterConfig) SetWarmCount(v int64) *ClusterConfig {
	s.WarmCount = &v
	return s
}

// SetWarmEnabled sets the WarmEnabled field's value.
func (s *ClusterConfig) SetWarmEnabled(v bool) *ClusterConfig {
	s.WarmEnabled = &v
	return s
}

// SetWarmType sets the WarmType field's value.
func (s *ClusterConfig) SetWarmType(v string) *ClusterConfig {
	s.WarmType = &v
	return s
}

// SetZoneAwarenessConfig sets the ZoneAwarenessConfig field's value.
func (s *ClusterConfig) SetZoneAwarenessConfig(v *ZoneAwarenessConfig) *ClusterConfig {
	s.ZoneAwarenessConfig = v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *ClusterConfig) SetZoneAwarenessEnabled(v bool) *ClusterConfig {
	s.ZoneAwarenessEnabled = &v
	return s
}

// The configuration status for the specified domain.
type ClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// The cluster configuration for the specified domain.
	//
	// Options is a required field
	Options *ClusterConfig `type:"structure" required:"true"`

	// The cluster configuration status for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfigStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ClusterConfigStatus) SetOptions(v *ClusterConfig) *ClusterConfigStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterConfigStatus) SetStatus(v *OptionStatus) *ClusterConfigStatus {
	s.Status = v
	return s
}

// Options to specify the Cognito user and identity pools for OpenSearch Dashboards
// authentication. For more information, see Configuring Amazon Cognito authentication
// for OpenSearch Dashboards (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
type CognitoOptions struct {
	_ struct{} `type:"structure"`

	// The option to enable Cognito for OpenSearch Dashboards authentication.
	Enabled *bool `type:"boolean"`

	// The Cognito identity pool ID for OpenSearch Dashboards authentication.
	IdentityPoolId *string `min:"1" type:"string"`

	// The role ARN that provides OpenSearch permissions for accessing Cognito resources.
	RoleArn *string `min:"20" type:"string"`

	// The Cognito user pool ID for OpenSearch Dashboards authentication.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoOptions"}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CognitoOptions) SetEnabled(v bool) *CognitoOptions {
	s.Enabled = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *CognitoOptions) SetIdentityPoolId(v string) *CognitoOptions {
	s.IdentityPoolId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CognitoOptions) SetRoleArn(v string) *CognitoOptions {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CognitoOptions) SetUserPoolId(v string) *CognitoOptions {
	s.UserPoolId = &v
	return s
}

// The status of the Cognito options for the specified domain.
type CognitoOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Cognito options for the specified domain.
	//
	// Options is a required field
	Options *CognitoOptions `type:"structure" required:"true"`

	// The status of the Cognito options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *CognitoOptionsStatus) SetOptions(v *CognitoOptions) *CognitoOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CognitoOptionsStatus) SetStatus(v *OptionStatus) *CognitoOptionsStatus {
	s.Status = v
	return s
}

// Specifies the configuration for cold storage options such as enabled
type ColdStorageOptions struct {
	_ struct{} `type:"structure"`

	// Enable cold storage option. Accepted values true or false
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColdStorageOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColdStorageOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColdStorageOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColdStorageOptions"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ColdStorageOptions) SetEnabled(v bool) *ColdStorageOptions {
	s.Enabled = &v
	return s
}

// A map from an EngineVersion to a list of compatible EngineVersion s to which
// the domain can be upgraded.
type CompatibleVersionsMap struct {
	_ struct{} `type:"structure"`

	// The current version of OpenSearch a domain is on.
	SourceVersion *string `min:"14" type:"string"`

	// List of supported OpenSearch versions.
	TargetVersions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleVersionsMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleVersionsMap) GoString() string {
	return s.String()
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CompatibleVersionsMap) SetSourceVersion(v string) *CompatibleVersionsMap {
	s.SourceVersion = &v
	return s
}

// SetTargetVersions sets the TargetVersions field's value.
func (s *CompatibleVersionsMap) SetTargetVersions(v []*string) *CompatibleVersionsMap {
	s.TargetVersions = v
	return s
}

// An error occurred because the client attempts to remove a resource that is
// currently in use. Returns HTTP status code 409.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Option to allow references to indices in an HTTP request body. Must be false
	// when configuring access to individual sub-resources. By default, the value
	// is true. See Advanced cluster parameters (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// Specifies advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptionsInput_ `type:"structure"`

	// Specifies Auto-Tune options.
	AutoTuneOptions *AutoTuneOptionsInput_ `type:"structure"`

	// Configuration options for a domain. Specifies the instance type and number
	// of instances in the domain.
	ClusterConfig *ClusterConfig `type:"structure"`

	// Options to specify the Cognito user and identity pools for OpenSearch Dashboards
	// authentication. For more information, see Configuring Amazon Cognito authentication
	// for OpenSearch Dashboards (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// Options to specify configurations that will be applied to the domain endpoint.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The name of the Amazon OpenSearch Service domain you're creating. Domain
	// names are unique across the domains owned by an account within an AWS region.
	// Domain names must start with a lowercase letter and can contain the following
	// characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Options to enable, disable, and specify the type and size of EBS storage
	// volumes.
	EBSOptions *EBSOptions `type:"structure"`

	// Options for encryption of data at rest.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine
	// version for the Amazon OpenSearch Service domain. For example, "OpenSearch_1.0"
	// or "Elasticsearch_7.9". For more information, see Creating and managing Amazon
	// OpenSearch Service domains (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
	EngineVersion *string `min:"14" type:"string"`

	// Map of LogType and LogPublishingOption, each containing options to publish
	// a given type of OpenSearch log.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Node-to-node encryption options.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Option to set time, in UTC format, of the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// A list of Tag added during domain creation.
	TagList []*Tag `type:"list"`

	// Options to specify the subnets and security groups for a VPC endpoint. For
	// more information, see Launching your Amazon OpenSearch Service domains using
	// a VPC (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.EngineVersion != nil && len(*s.EngineVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EngineVersion", 14))
	}
	if s.AdvancedSecurityOptions != nil {
		if err := s.AdvancedSecurityOptions.Validate(); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoTuneOptions != nil {
		if err := s.AutoTuneOptions.Validate(); err != nil {
			invalidParams.AddNested("AutoTuneOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ClusterConfig != nil {
		if err := s.ClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DomainEndpointOptions != nil {
		if err := s.DomainEndpointOptions.Validate(); err != nil {
			invalidParams.AddNested("DomainEndpointOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LogPublishingOptions != nil {
		for i, v := range s.LogPublishingOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogPublishingOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateDomainInput) SetAccessPolicies(v string) *CreateDomainInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *CreateDomainInput) SetAdvancedOptions(v map[string]*string) *CreateDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *CreateDomainInput) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsInput_) *CreateDomainInput {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *CreateDomainInput) SetAutoTuneOptions(v *AutoTuneOptionsInput_) *CreateDomainInput {
	s.AutoTuneOptions = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *CreateDomainInput) SetClusterConfig(v *ClusterConfig) *CreateDomainInput {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *CreateDomainInput) SetCognitoOptions(v *CognitoOptions) *CreateDomainInput {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *CreateDomainInput) SetDomainEndpointOptions(v *DomainEndpointOptions) *CreateDomainInput {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *CreateDomainInput) SetEBSOptions(v *EBSOptions) *CreateDomainInput {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *CreateDomainInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *CreateDomainInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDomainInput) SetEngineVersion(v string) *CreateDomainInput {
	s.EngineVersion = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *CreateDomainInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *CreateDomainInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *CreateDomainInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *CreateDomainInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *CreateDomainInput) SetSnapshotOptions(v *SnapshotOptions) *CreateDomainInput {
	s.SnapshotOptions = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *CreateDomainInput) SetTagList(v []*Tag) *CreateDomainInput {
	s.TagList = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *CreateDomainInput) SetVPCOptions(v *VPCOptions) *CreateDomainInput {
	s.VPCOptions = v
	return s
}

// The result of a CreateDomain operation. Contains the status of the newly
// created Amazon OpenSearch Service domain.
type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the newly created domain.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateDomainOutput) SetDomainStatus(v *DomainStatus) *CreateDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the CreateOutboundConnection operation.
type CreateOutboundConnectionInput struct {
	_ struct{} `type:"structure"`

	// The connection alias used used by the customer for this cross-cluster connection.
	//
	// ConnectionAlias is a required field
	ConnectionAlias *string `min:"2" type:"string" required:"true"`

	// The AWSDomainInformation for the local OpenSearch domain.
	//
	// LocalDomainInfo is a required field
	LocalDomainInfo *DomainInformationContainer `type:"structure" required:"true"`

	// The AWSDomainInformation for the remote OpenSearch domain.
	//
	// RemoteDomainInfo is a required field
	RemoteDomainInfo *DomainInformationContainer `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOutboundConnectionInput"}
	if s.ConnectionAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionAlias"))
	}
	if s.ConnectionAlias != nil && len(*s.ConnectionAlias) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionAlias", 2))
	}
	if s.LocalDomainInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalDomainInfo"))
	}
	if s.RemoteDomainInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainInfo"))
	}
	if s.LocalDomainInfo != nil {
		if err := s.LocalDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("LocalDomainInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.RemoteDomainInfo != nil {
		if err := s.RemoteDomainInfo.Validate(); err != nil {
			invalidParams.AddNested("RemoteDomainInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *CreateOutboundConnectionInput) SetConnectionAlias(v string) *CreateOutboundConnectionInput {
	s.ConnectionAlias = &v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *CreateOutboundConnectionInput) SetLocalDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionInput {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *CreateOutboundConnectionInput) SetRemoteDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionInput {
	s.RemoteDomainInfo = v
	return s
}

// The result of a CreateOutboundConnection request. Contains the details about
// the newly created cross-cluster connection.
type CreateOutboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection alias provided during the create connection request.
	ConnectionAlias *string `min:"2" type:"string"`

	// The unique ID for the created outbound connection, which is used for subsequent
	// operations on the connection.
	ConnectionId *string `min:"10" type:"string"`

	// The OutboundConnectionStatus for the newly created connection.
	ConnectionStatus *OutboundConnectionStatus `type:"structure"`

	// The AWSDomainInformation for the local OpenSearch domain.
	LocalDomainInfo *DomainInformationContainer `type:"structure"`

	// The AWSDomainInformation for the remote OpenSearch domain.
	RemoteDomainInfo *DomainInformationContainer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionAlias(v string) *CreateOutboundConnectionOutput {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionId(v string) *CreateOutboundConnectionOutput {
	s.ConnectionId = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *CreateOutboundConnectionOutput) SetConnectionStatus(v *OutboundConnectionStatus) *CreateOutboundConnectionOutput {
	s.ConnectionStatus = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *CreateOutboundConnectionOutput) SetLocalDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionOutput {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *CreateOutboundConnectionOutput) SetRemoteDomainInfo(v *DomainInformationContainer) *CreateOutboundConnectionOutput {
	s.RemoteDomainInfo = v
	return s
}

// Container for request parameters to the CreatePackage operation.
type CreatePackageInput struct {
	_ struct{} `type:"structure"`

	// Description of the package.
	PackageDescription *string `type:"string"`

	// Unique identifier for the package.
	//
	// PackageName is a required field
	PackageName *string `min:"3" type:"string" required:"true"`

	// The Amazon S3 location from which to import the package.
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`

	// Type of package. Currently supports only TXT-DICTIONARY.
	//
	// PackageType is a required field
	PackageType *string `type:"string" required:"true" enum:"PackageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackageInput"}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 3))
	}
	if s.PackageSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageSource"))
	}
	if s.PackageType == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageType"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *CreatePackageInput) SetPackageDescription(v string) *CreatePackageInput {
	s.PackageDescription = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *CreatePackageInput) SetPackageName(v string) *CreatePackageInput {
	s.PackageName = &v
	return s
}

// SetPackageSource sets the PackageSource field's value.
func (s *CreatePackageInput) SetPackageSource(v *PackageSource) *CreatePackageInput {
	s.PackageSource = v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *CreatePackageInput) SetPackageType(v string) *CreatePackageInput {
	s.PackageType = &v
	return s
}

// Container for the response returned by the CreatePackage operation.
type CreatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the package.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *CreatePackageOutput) SetPackageDetails(v *PackageDetails) *CreatePackageOutput {
	s.PackageDetails = v
	return s
}

// Container for the parameters to the DeleteDomain operation. Specifies the
// name of the domain you want to delete.
type DeleteDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DeleteDomain request. Contains the status of the pending
// deletion, or a "domain not found" error if the domain and all of its resources
// have been deleted.
type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domain being deleted.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DeleteDomainOutput) SetDomainStatus(v *DomainStatus) *DeleteDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DeleteInboundConnection operation.
type DeleteInboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the inbound connection to permanently delete.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteInboundConnectionInput) SetConnectionId(v string) *DeleteInboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// The result of a DeleteInboundConnection operation. Contains details about
// the deleted inbound connection.
type DeleteInboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The InboundConnection of the deleted inbound connection.
	Connection *InboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteInboundConnectionOutput) SetConnection(v *InboundConnection) *DeleteInboundConnectionOutput {
	s.Connection = v
	return s
}

// Container for the parameters to the DeleteOutboundConnection operation.
type DeleteOutboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the outbound connection you want to permanently delete.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOutboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteOutboundConnectionInput) SetConnectionId(v string) *DeleteOutboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// The result of a DeleteOutboundConnection operation. Contains details about
// the deleted outbound connection.
type DeleteOutboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The OutboundConnection of the deleted outbound connection.
	Connection *OutboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteOutboundConnectionOutput) SetConnection(v *OutboundConnection) *DeleteOutboundConnectionOutput {
	s.Connection = v
	return s
}

// Container for the request parameters to the DeletePackage operation.
type DeletePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The internal ID of the package you want to delete. Use DescribePackages to
	// find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageID sets the PackageID field's value.
func (s *DeletePackageInput) SetPackageID(v string) *DeletePackageInput {
	s.PackageID = &v
	return s
}

// Container for the response parameters to the DeletePackage operation.
type DeletePackageOutput struct {
	_ struct{} `type:"structure"`

	// PackageDetails
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *DeletePackageOutput) SetPackageDetails(v *PackageDetails) *DeletePackageOutput {
	s.PackageDetails = v
	return s
}

// Container for the parameters to the DescribeDomainAutoTunes operation.
type DescribeDomainAutoTunesInput struct {
	_ struct{} `type:"structure"`

	// The domain name for which you want Auto-Tune action details.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// NextToken is sent in case the earlier API call results contain the NextToken.
	// Used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainAutoTunesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainAutoTunesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainAutoTunesInput) SetDomainName(v string) *DescribeDomainAutoTunesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDomainAutoTunesInput) SetMaxResults(v int64) *DescribeDomainAutoTunesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainAutoTunesInput) SetNextToken(v string) *DescribeDomainAutoTunesInput {
	s.NextToken = &v
	return s
}

// The result of a DescribeDomainAutoTunes request. See Auto-Tune for Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type DescribeDomainAutoTunesOutput struct {
	_ struct{} `type:"structure"`

	// The list of setting adjustments that Auto-Tune has made to the domain. See
	// Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	AutoTunes []*AutoTune `type:"list"`

	// An identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainAutoTunesOutput) GoString() string {
	return s.String()
}

// SetAutoTunes sets the AutoTunes field's value.
func (s *DescribeDomainAutoTunesOutput) SetAutoTunes(v []*AutoTune) *DescribeDomainAutoTunesOutput {
	s.AutoTunes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainAutoTunesOutput) SetNextToken(v string) *DescribeDomainAutoTunesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeDomainConfig operation. Specifies
// the domain name for which you want configuration information.
type DescribeDomainConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The domain you want to get information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainConfigInput) SetDomainName(v string) *DescribeDomainConfigInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeDomainConfig request. Contains the configuration
// information of the requested domain.
type DescribeDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The configuration information of the domain requested in the DescribeDomainConfig
	// request.
	//
	// DomainConfig is a required field
	DomainConfig *DomainConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeDomainConfigOutput) SetDomainConfig(v *DomainConfig) *DescribeDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for the parameters to the DescribeDomain operation.
type DescribeDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain for which you want information.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainInput) SetDomainName(v string) *DescribeDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeDomain request. Contains the status of the domain
// specified in the request.
type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the domain.
	//
	// DomainStatus is a required field
	DomainStatus *DomainStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeDomainOutput) SetDomainStatus(v *DomainStatus) *DescribeDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeDomains operation. By default,
// the API returns the status of all domains.
type DescribeDomainsInput struct {
	_ struct{} `type:"structure"`

	// The domains for which you want information.
	//
	// DomainNames is a required field
	DomainNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainsInput"}
	if s.DomainNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainNames sets the DomainNames field's value.
func (s *DescribeDomainsInput) SetDomainNames(v []*string) *DescribeDomainsInput {
	s.DomainNames = v
	return s
}

// The result of a DescribeDomains request. Contains the status of the specified
// domains or all domains owned by the account.
type DescribeDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domains requested in the DescribeDomains request.
	//
	// DomainStatusList is a required field
	DomainStatusList []*DomainStatus `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainStatusList sets the DomainStatusList field's value.
func (s *DescribeDomainsOutput) SetDomainStatusList(v []*DomainStatus) *DescribeDomainsOutput {
	s.DomainStatusList = v
	return s
}

// Container for the parameters to the DescribeInboundConnections operation.
type DescribeInboundConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A list of filters used to match properties for inbound cross-cluster connections.
	// Available Filter values are:
	//    * connection-id
	//
	//    * local-domain-info.domain-name
	//
	//    * local-domain-info.owner-id
	//
	//    * local-domain-info.region
	//
	//    * remote-domain-info.domain-name
	Filters []*Filter `type:"list"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// If more results are available and NextToken is present, make the next request
	// to the same API with the received NextToken to paginate the remaining results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInboundConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInboundConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInboundConnectionsInput) SetFilters(v []*Filter) *DescribeInboundConnectionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInboundConnectionsInput) SetMaxResults(v int64) *DescribeInboundConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInboundConnectionsInput) SetNextToken(v string) *DescribeInboundConnectionsInput {
	s.NextToken = &v
	return s
}

// The result of a DescribeInboundConnections request. Contains a list of connections
// matching the filter criteria.
type DescribeInboundConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of InboundConnection matching the specified filter criteria.
	Connections []*InboundConnection `type:"list"`

	// If more results are available and NextToken is present, make the next request
	// to the same API with the received NextToken to paginate the remaining results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInboundConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeInboundConnectionsOutput) SetConnections(v []*InboundConnection) *DescribeInboundConnectionsOutput {
	s.Connections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInboundConnectionsOutput) SetNextToken(v string) *DescribeInboundConnectionsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the DescribeInstanceTypeLimits operation.
type DescribeInstanceTypeLimitsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain you want to modify. Only include this value if you're
	// querying OpenSearch Limits for an existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of OpenSearch for which Limits are needed.
	//
	// EngineVersion is a required field
	EngineVersion *string `location:"uri" locationName:"EngineVersion" min:"14" type:"string" required:"true"`

	// The instance type for an OpenSearch cluster for which OpenSearch Limits are
	// needed.
	//
	// InstanceType is a required field
	InstanceType *string `location:"uri" locationName:"InstanceType" type:"string" required:"true" enum:"OpenSearchPartitionInstanceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceTypeLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceTypeLimitsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.EngineVersion != nil && len(*s.EngineVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EngineVersion", 14))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeInstanceTypeLimitsInput) SetDomainName(v string) *DescribeInstanceTypeLimitsInput {
	s.DomainName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeInstanceTypeLimitsInput) SetEngineVersion(v string) *DescribeInstanceTypeLimitsInput {
	s.EngineVersion = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeInstanceTypeLimitsInput) SetInstanceType(v string) *DescribeInstanceTypeLimitsInput {
	s.InstanceType = &v
	return s
}

// Container for the parameters received from the DescribeInstanceTypeLimits
// operation.
type DescribeInstanceTypeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The role of a given instance and all applicable limits. The role performed
	// by a given OpenSearch instance can be one of the following:
	//    * data: If the given InstanceType is used as a data node
	//
	//    * master: If the given InstanceType is used as a master node
	//
	//    * ultra_warm: If the given InstanceType is used as a warm node
	LimitsByRole map[string]*Limits `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceTypeLimitsOutput) GoString() string {
	return s.String()
}

// SetLimitsByRole sets the LimitsByRole field's value.
func (s *DescribeInstanceTypeLimitsOutput) SetLimitsByRole(v map[string]*Limits) *DescribeInstanceTypeLimitsOutput {
	s.LimitsByRole = v
	return s
}

// Container for the parameters to the DescribeOutboundConnections operation.
type DescribeOutboundConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A list of filters used to match properties for outbound cross-cluster connections.
	// Available Filter names for this operation are:
	//    * connection-id
	//
	//    * remote-domain-info.domain-name
	//
	//    * remote-domain-info.owner-id
	//
	//    * remote-domain-info.region
	//
	//    * local-domain-info.domain-name
	Filters []*Filter `type:"list"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// NextToken is sent in case the earlier API call results contain the NextToken
	// parameter. Used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOutboundConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOutboundConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeOutboundConnectionsInput) SetFilters(v []*Filter) *DescribeOutboundConnectionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeOutboundConnectionsInput) SetMaxResults(v int64) *DescribeOutboundConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOutboundConnectionsInput) SetNextToken(v string) *DescribeOutboundConnectionsInput {
	s.NextToken = &v
	return s
}

// The result of a DescribeOutboundConnections request. Contains the list of
// connections matching the filter criteria.
type DescribeOutboundConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of OutboundConnection matching the specified filter criteria.
	Connections []*OutboundConnection `type:"list"`

	// If more results are available and NextToken is present, make the next request
	// to the same API with the received NextToken to paginate the remaining results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOutboundConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeOutboundConnectionsOutput) SetConnections(v []*OutboundConnection) *DescribeOutboundConnectionsOutput {
	s.Connections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOutboundConnectionsOutput) SetNextToken(v string) *DescribeOutboundConnectionsOutput {
	s.NextToken = &v
	return s
}

// A filter to apply to the DescribePackage response.
type DescribePackagesFilter struct {
	_ struct{} `type:"structure"`

	// Any field from PackageDetails.
	Name *string `type:"string" enum:"DescribePackagesFilterName"`

	// A list of values for the specified field.
	Value []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DescribePackagesFilter) SetName(v string) *DescribePackagesFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DescribePackagesFilter) SetValue(v []*string) *DescribePackagesFilter {
	s.Value = v
	return s
}

// Container for the request parameters to the DescribePackage operation.
type DescribePackagesInput struct {
	_ struct{} `type:"structure"`

	// Only returns packages that match the DescribePackagesFilterList values.
	Filters []*DescribePackagesFilter `type:"list"`

	// Limits results to a maximum number of packages.
	MaxResults *int64 `type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DescribePackagesInput) SetFilters(v []*DescribePackagesFilter) *DescribePackagesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePackagesInput) SetMaxResults(v int64) *DescribePackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePackagesInput) SetNextToken(v string) *DescribePackagesInput {
	s.NextToken = &v
	return s
}

// Container for the response returned by the DescribePackages operation.
type DescribePackagesOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	// List of PackageDetails objects.
	PackageDetailsList []*PackageDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePackagesOutput) SetNextToken(v string) *DescribePackagesOutput {
	s.NextToken = &v
	return s
}

// SetPackageDetailsList sets the PackageDetailsList field's value.
func (s *DescribePackagesOutput) SetPackageDetailsList(v []*PackageDetails) *DescribePackagesOutput {
	s.PackageDetailsList = v
	return s
}

// Container for parameters to DescribeReservedInstanceOfferings
type DescribeReservedInstanceOfferingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The offering identifier filter value. Use this parameter to show only the
	// available offering that matches the specified reservation identifier.
	ReservedInstanceOfferingId *string `location:"querystring" locationName:"offeringId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservedInstanceOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservedInstanceOfferingsInput"}
	if s.ReservedInstanceOfferingId != nil && len(*s.ReservedInstanceOfferingId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ReservedInstanceOfferingId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedInstanceOfferingsInput) SetMaxResults(v int64) *DescribeReservedInstanceOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstanceOfferingsInput) SetNextToken(v string) *DescribeReservedInstanceOfferingsInput {
	s.NextToken = &v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *DescribeReservedInstanceOfferingsInput) SetReservedInstanceOfferingId(v string) *DescribeReservedInstanceOfferingsInput {
	s.ReservedInstanceOfferingId = &v
	return s
}

// Container for results from DescribeReservedInstanceOfferings
type DescribeReservedInstanceOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved OpenSearch instance offerings
	ReservedInstanceOfferings []*ReservedInstanceOffering `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstanceOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstanceOfferingsOutput) SetNextToken(v string) *DescribeReservedInstanceOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetReservedInstanceOfferings sets the ReservedInstanceOfferings field's value.
func (s *DescribeReservedInstanceOfferingsOutput) SetReservedInstanceOfferings(v []*ReservedInstanceOffering) *DescribeReservedInstanceOfferingsOutput {
	s.ReservedInstanceOfferings = v
	return s
}

// Container for parameters to DescribeReservedInstances
type DescribeReservedInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The reserved instance identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reserved OpenSearch instance
	// ID.
	ReservedInstanceId *string `location:"querystring" locationName:"reservationId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservedInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservedInstancesInput"}
	if s.ReservedInstanceId != nil && len(*s.ReservedInstanceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ReservedInstanceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedInstancesInput) SetMaxResults(v int64) *DescribeReservedInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstancesInput) SetNextToken(v string) *DescribeReservedInstancesInput {
	s.NextToken = &v
	return s
}

// SetReservedInstanceId sets the ReservedInstanceId field's value.
func (s *DescribeReservedInstancesInput) SetReservedInstanceId(v string) *DescribeReservedInstancesInput {
	s.ReservedInstanceId = &v
	return s
}

// Container for results from DescribeReservedInstances
type DescribeReservedInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved OpenSearch instances.
	ReservedInstances []*ReservedInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservedInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedInstancesOutput) SetNextToken(v string) *DescribeReservedInstancesOutput {
	s.NextToken = &v
	return s
}

// SetReservedInstances sets the ReservedInstances field's value.
func (s *DescribeReservedInstancesOutput) SetReservedInstances(v []*ReservedInstance) *DescribeReservedInstancesOutput {
	s.ReservedInstances = v
	return s
}

// An error occured because the client wanted to access a not supported operation.
// Gives http status code of 409.
type DisabledOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledOperationException) GoString() string {
	return s.String()
}

func newErrorDisabledOperationException(v protocol.ResponseMetadata) error {
	return &DisabledOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DisabledOperationException) Code() string {
	return "DisabledOperationException"
}

// Message returns the exception's message.
func (s *DisabledOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DisabledOperationException) OrigErr() error {
	return nil
}

func (s *DisabledOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DisabledOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DisabledOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Container for the request parameters to the DissociatePackage operation.
type DissociatePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain to associate the package with.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// The internal ID of the package to associate with a domain. Use DescribePackages
	// to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DissociatePackageInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DissociatePackageInput) SetDomainName(v string) *DissociatePackageInput {
	s.DomainName = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *DissociatePackageInput) SetPackageID(v string) *DissociatePackageInput {
	s.PackageID = &v
	return s
}

// Container for the response returned by DissociatePackage operation.
type DissociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// DomainPackageDetails
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociatePackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetails sets the DomainPackageDetails field's value.
func (s *DissociatePackageOutput) SetDomainPackageDetails(v *DomainPackageDetails) *DissociatePackageOutput {
	s.DomainPackageDetails = v
	return s
}

// The configuration of a domain.
type DomainConfig struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// The AdvancedOptions for the domain. See Advanced options (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// Specifies AdvancedSecurityOptions for the domain.
	AdvancedSecurityOptions *AdvancedSecurityOptionsStatus `type:"structure"`

	// Specifies AutoTuneOptions for the domain.
	AutoTuneOptions *AutoTuneOptionsStatus `type:"structure"`

	// The ClusterConfig for the domain.
	ClusterConfig *ClusterConfigStatus `type:"structure"`

	// The CognitoOptions for the specified domain. For more information, see Configuring
	// Amazon Cognito authentication for OpenSearch Dashboards (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptionsStatus `type:"structure"`

	// The DomainEndpointOptions for the domain.
	DomainEndpointOptions *DomainEndpointOptionsStatus `type:"structure"`

	// The EBSOptions for the domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// The EncryptionAtRestOptions for the domain.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus `type:"structure"`

	// String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine
	// version for the OpenSearch or Elasticsearch domain.
	EngineVersion *VersionStatus `type:"structure"`

	// Log publishing options for the given domain.
	LogPublishingOptions *LogPublishingOptionsStatus `type:"structure"`

	// The NodeToNodeEncryptionOptions for the domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus `type:"structure"`

	// The SnapshotOptions for the domain.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`

	// The VPCOptions for the specified domain. For more information, see Launching
	// your Amazon OpenSearch Service domains using a VPC (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCDerivedInfoStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainConfig) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *DomainConfig) SetAccessPolicies(v *AccessPoliciesStatus) *DomainConfig {
	s.AccessPolicies = v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *DomainConfig) SetAdvancedOptions(v *AdvancedOptionsStatus) *DomainConfig {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *DomainConfig) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsStatus) *DomainConfig {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *DomainConfig) SetAutoTuneOptions(v *AutoTuneOptionsStatus) *DomainConfig {
	s.AutoTuneOptions = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *DomainConfig) SetClusterConfig(v *ClusterConfigStatus) *DomainConfig {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *DomainConfig) SetCognitoOptions(v *CognitoOptionsStatus) *DomainConfig {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *DomainConfig) SetDomainEndpointOptions(v *DomainEndpointOptionsStatus) *DomainConfig {
	s.DomainEndpointOptions = v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *DomainConfig) SetEBSOptions(v *EBSOptionsStatus) *DomainConfig {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *DomainConfig) SetEncryptionAtRestOptions(v *EncryptionAtRestOptionsStatus) *DomainConfig {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DomainConfig) SetEngineVersion(v *VersionStatus) *DomainConfig {
	s.EngineVersion = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *DomainConfig) SetLogPublishingOptions(v *LogPublishingOptionsStatus) *DomainConfig {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *DomainConfig) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptionsStatus) *DomainConfig {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *DomainConfig) SetSnapshotOptions(v *SnapshotOptionsStatus) *DomainConfig {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *DomainConfig) SetVPCOptions(v *VPCDerivedInfoStatus) *DomainConfig {
	s.VPCOptions = v
	return s
}

// Options to configure the endpoint for the domain.
type DomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// The fully qualified domain for your custom endpoint.
	CustomEndpoint *string `min:"1" type:"string"`

	// The ACM certificate ARN for your custom endpoint.
	CustomEndpointCertificateArn *string `min:"20" type:"string"`

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled *bool `type:"boolean"`

	// Whether only HTTPS endpoint should be enabled for the domain.
	EnforceHTTPS *bool `type:"boolean"`

	// Specify the TLS security policy to apply to the HTTPS endpoint of the domain.
	// Can be one of the following values:
	//    * Policy-Min-TLS-1-0-2019-07: TLS security policy which supports TLSv1.0
	//    and higher.
	//
	//    * Policy-Min-TLS-1-2-2019-07: TLS security policy which supports only
	//    TLSv1.2
	TLSSecurityPolicy *string `type:"string" enum:"TLSSecurityPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainEndpointOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainEndpointOptions"}
	if s.CustomEndpoint != nil && len(*s.CustomEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomEndpoint", 1))
	}
	if s.CustomEndpointCertificateArn != nil && len(*s.CustomEndpointCertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomEndpointCertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomEndpoint sets the CustomEndpoint field's value.
func (s *DomainEndpointOptions) SetCustomEndpoint(v string) *DomainEndpointOptions {
	s.CustomEndpoint = &v
	return s
}

// SetCustomEndpointCertificateArn sets the CustomEndpointCertificateArn field's value.
func (s *DomainEndpointOptions) SetCustomEndpointCertificateArn(v string) *DomainEndpointOptions {
	s.CustomEndpointCertificateArn = &v
	return s
}

// SetCustomEndpointEnabled sets the CustomEndpointEnabled field's value.
func (s *DomainEndpointOptions) SetCustomEndpointEnabled(v bool) *DomainEndpointOptions {
	s.CustomEndpointEnabled = &v
	return s
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *DomainEndpointOptions) SetEnforceHTTPS(v bool) *DomainEndpointOptions {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *DomainEndpointOptions) SetTLSSecurityPolicy(v string) *DomainEndpointOptions {
	s.TLSSecurityPolicy = &v
	return s
}

// The configured endpoint options for the domain and their current status.
type DomainEndpointOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Options to configure the endpoint for the domain.
	//
	// Options is a required field
	Options *DomainEndpointOptions `type:"structure" required:"true"`

	// The status of the endpoint options for the domain. See OptionStatus for the
	// status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainEndpointOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *DomainEndpointOptionsStatus) SetOptions(v *DomainEndpointOptions) *DomainEndpointOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainEndpointOptionsStatus) SetStatus(v *OptionStatus) *DomainEndpointOptionsStatus {
	s.Status = v
	return s
}

type DomainInfo struct {
	_ struct{} `type:"structure"`

	// The DomainName.
	DomainName *string `min:"3" type:"string"`

	// Specifies the EngineType of the domain.
	EngineType *string `type:"string" enum:"EngineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInfo) SetDomainName(v string) *DomainInfo {
	s.DomainName = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *DomainInfo) SetEngineType(v string) *DomainInfo {
	s.EngineType = &v
	return s
}

type DomainInformationContainer struct {
	_ struct{} `type:"structure"`

	AWSDomainInformation *AWSDomainInformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInformationContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainInformationContainer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainInformationContainer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainInformationContainer"}
	if s.AWSDomainInformation != nil {
		if err := s.AWSDomainInformation.Validate(); err != nil {
			invalidParams.AddNested("AWSDomainInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAWSDomainInformation sets the AWSDomainInformation field's value.
func (s *DomainInformationContainer) SetAWSDomainInformation(v *AWSDomainInformation) *DomainInformationContainer {
	s.AWSDomainInformation = v
	return s
}

// Information on a package associated with a domain.
type DomainPackageDetails struct {
	_ struct{} `type:"structure"`

	// The name of the domain you've associated a package with.
	DomainName *string `min:"3" type:"string"`

	// State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE,
	// DISSOCIATING, and DISSOCIATION_FAILED.
	DomainPackageStatus *string `type:"string" enum:"DomainPackageStatus"`

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails `type:"structure"`

	// The timestamp of the most recent update to the package association status.
	LastUpdated *time.Time `type:"timestamp"`

	// The internal ID of the package.
	PackageID *string `type:"string"`

	// User-specified name of the package.
	PackageName *string `min:"3" type:"string"`

	// Currently supports only TXT-DICTIONARY.
	PackageType *string `type:"string" enum:"PackageType"`

	PackageVersion *string `type:"string"`

	// The relative path on Amazon OpenSearch Service nodes, which can be used as
	// synonym_path when the package is a synonym file.
	ReferencePath *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainPackageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainPackageDetails) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainPackageDetails) SetDomainName(v string) *DomainPackageDetails {
	s.DomainName = &v
	return s
}

// SetDomainPackageStatus sets the DomainPackageStatus field's value.
func (s *DomainPackageDetails) SetDomainPackageStatus(v string) *DomainPackageDetails {
	s.DomainPackageStatus = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *DomainPackageDetails) SetErrorDetails(v *ErrorDetails) *DomainPackageDetails {
	s.ErrorDetails = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *DomainPackageDetails) SetLastUpdated(v time.Time) *DomainPackageDetails {
	s.LastUpdated = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *DomainPackageDetails) SetPackageID(v string) *DomainPackageDetails {
	s.PackageID = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DomainPackageDetails) SetPackageName(v string) *DomainPackageDetails {
	s.PackageName = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *DomainPackageDetails) SetPackageType(v string) *DomainPackageDetails {
	s.PackageType = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DomainPackageDetails) SetPackageVersion(v string) *DomainPackageDetails {
	s.PackageVersion = &v
	return s
}

// SetReferencePath sets the ReferencePath field's value.
func (s *DomainPackageDetails) SetReferencePath(v string) *DomainPackageDetails {
	s.ReferencePath = &v
	return s
}

// The current status of a domain.
type DomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a domain. See IAM identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the AWS Identity and Access Management User Guide for more information.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// The status of the AdvancedOptions.
	AdvancedOptions map[string]*string `type:"map"`

	// The current status of the domain's advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptions `type:"structure"`

	// The current status of the domain's Auto-Tune options.
	AutoTuneOptions *AutoTuneOptionsOutput_ `type:"structure"`

	// The type and number of instances in the domain.
	//
	// ClusterConfig is a required field
	ClusterConfig *ClusterConfig `type:"structure" required:"true"`

	// The CognitoOptions for the specified domain. For more information, see Configuring
	// Amazon Cognito authentication for OpenSearch Dashboards (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// The domain creation status. True if the creation of a domain is complete.
	// False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// The domain deletion status. True if a delete request has been received for
	// the domain but resource cleanup is still in progress. False if the domain
	// has not been deleted. Once domain deletion is complete, the status of the
	// domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// The current status of the domain's endpoint options.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The unique identifier for the specified domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// The name of a domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The EBSOptions for the specified domain.
	EBSOptions *EBSOptions `type:"structure"`

	// The status of the EncryptionAtRestOptions.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// The domain endpoint that you use to submit index and search requests.
	Endpoint *string `type:"string"`

	// Map containing the domain endpoints used to submit index and search requests.
	// Example key, value: 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'.
	Endpoints map[string]*string `type:"map"`

	EngineVersion *string `min:"14" type:"string"`

	// Log publishing options for the given domain.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// The status of the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// The status of the domain configuration. True if Amazon OpenSearch Service
	// is processing configuration changes. False if the configuration is active.
	Processing *bool `type:"boolean"`

	// The current status of the domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`

	// The status of the SnapshotOptions.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// The status of a domain version upgrade. True if Amazon OpenSearch Service
	// is undergoing a version upgrade. False if the configuration is active.
	UpgradeProcessing *bool `type:"boolean"`

	// The VPCOptions for the specified domain. For more information, see Launching
	// your Amazon OpenSearch Service domains using a VPC (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCDerivedInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainStatus) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DomainStatus) SetARN(v string) *DomainStatus {
	s.ARN = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *DomainStatus) SetAccessPolicies(v string) *DomainStatus {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *DomainStatus) SetAdvancedOptions(v map[string]*string) *DomainStatus {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *DomainStatus) SetAdvancedSecurityOptions(v *AdvancedSecurityOptions) *DomainStatus {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *DomainStatus) SetAutoTuneOptions(v *AutoTuneOptionsOutput_) *DomainStatus {
	s.AutoTuneOptions = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *DomainStatus) SetClusterConfig(v *ClusterConfig) *DomainStatus {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *DomainStatus) SetCognitoOptions(v *CognitoOptions) *DomainStatus {
	s.CognitoOptions = v
	return s
}

// SetCreated sets the Created field's value.
func (s *DomainStatus) SetCreated(v bool) *DomainStatus {
	s.Created = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *DomainStatus) SetDeleted(v bool) *DomainStatus {
	s.Deleted = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *DomainStatus) SetDomainEndpointOptions(v *DomainEndpointOptions) *DomainStatus {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DomainStatus) SetDomainId(v string) *DomainStatus {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainStatus) SetDomainName(v string) *DomainStatus {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *DomainStatus) SetEBSOptions(v *EBSOptions) *DomainStatus {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *DomainStatus) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *DomainStatus {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DomainStatus) SetEndpoint(v string) *DomainStatus {
	s.Endpoint = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *DomainStatus) SetEndpoints(v map[string]*string) *DomainStatus {
	s.Endpoints = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DomainStatus) SetEngineVersion(v string) *DomainStatus {
	s.EngineVersion = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *DomainStatus) SetLogPublishingOptions(v map[string]*LogPublishingOption) *DomainStatus {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *DomainStatus) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *DomainStatus {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *DomainStatus) SetProcessing(v bool) *DomainStatus {
	s.Processing = &v
	return s
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *DomainStatus) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *DomainStatus {
	s.ServiceSoftwareOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *DomainStatus) SetSnapshotOptions(v *SnapshotOptions) *DomainStatus {
	s.SnapshotOptions = v
	return s
}

// SetUpgradeProcessing sets the UpgradeProcessing field's value.
func (s *DomainStatus) SetUpgradeProcessing(v bool) *DomainStatus {
	s.UpgradeProcessing = &v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *DomainStatus) SetVPCOptions(v *VPCDerivedInfo) *DomainStatus {
	s.VPCOptions = v
	return s
}

// The maintenance schedule duration: duration value and duration unit. See
// Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type Duration struct {
	_ struct{} `type:"structure"`

	// The unit of a maintenance schedule duration. Valid value is HOURS. See Auto-Tune
	// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Unit *string `type:"string" enum:"TimeUnit"`

	// Integer to specify the value of a maintenance schedule duration. See Auto-Tune
	// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Value *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Duration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Duration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Duration"}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnit sets the Unit field's value.
func (s *Duration) SetUnit(v string) *Duration {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Duration) SetValue(v int64) *Duration {
	s.Value = &v
	return s
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Whether EBS-based storage is enabled.
	EBSEnabled *bool `type:"boolean"`

	// The IOPD for a Provisioned IOPS EBS volume (SSD).
	Iops *int64 `type:"integer"`

	// Integer to specify the size of an EBS volume.
	VolumeSize *int64 `type:"integer"`

	// The volume type for EBS-based storage.
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptions) GoString() string {
	return s.String()
}

// SetEBSEnabled sets the EBSEnabled field's value.
func (s *EBSOptions) SetEBSEnabled(v bool) *EBSOptions {
	s.EBSEnabled = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EBSOptions) SetIops(v int64) *EBSOptions {
	s.Iops = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSOptions) SetVolumeSize(v int64) *EBSOptions {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EBSOptions) SetVolumeType(v string) *EBSOptions {
	s.VolumeType = &v
	return s
}

// Status of the EBS options for the specified domain.
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The EBS options for the specified domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// The status of the EBS options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EBSOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EBSOptionsStatus) SetOptions(v *EBSOptions) *EBSOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EBSOptionsStatus) SetStatus(v *OptionStatus) *EBSOptionsStatus {
	s.Status = v
	return s
}

// Specifies encryption at rest options.
type EncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// The option to enable encryption at rest.
	Enabled *bool `type:"boolean"`

	// The KMS key ID for encryption at rest options.
	KmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRestOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRestOptions"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *EncryptionAtRestOptions) SetEnabled(v bool) *EncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EncryptionAtRestOptions) SetKmsKeyId(v string) *EncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// Status of the encryption At Rest options for the specified domain.
type EncryptionAtRestOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The Encryption At Rest options for the specified domain.
	//
	// Options is a required field
	Options *EncryptionAtRestOptions `type:"structure" required:"true"`

	// The status of the Encryption At Rest options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionAtRestOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EncryptionAtRestOptionsStatus) SetOptions(v *EncryptionAtRestOptions) *EncryptionAtRestOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EncryptionAtRestOptionsStatus) SetStatus(v *OptionStatus) *EncryptionAtRestOptionsStatus {
	s.Status = v
	return s
}

type ErrorDetails struct {
	_ struct{} `type:"structure"`

	ErrorMessage *string `type:"string"`

	ErrorType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetails) SetErrorMessage(v string) *ErrorDetails {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *ErrorDetails) SetErrorType(v string) *ErrorDetails {
	s.ErrorType = &v
	return s
}

// A filter used to limit results when describing inbound or outbound cross-cluster
// connections. Multiple values can be specified per filter. A cross-cluster
// connection must match at least one of the specified values for it to be returned
// from an operation.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `min:"1" type:"string"`

	// Contains one or more values for the filter.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Container for the request parameters to GetCompatibleVersions operation.
type GetCompatibleVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCompatibleVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCompatibleVersionsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetCompatibleVersionsInput) SetDomainName(v string) *GetCompatibleVersionsInput {
	s.DomainName = &v
	return s
}

// Container for the response returned by the GetCompatibleVersions operation.
type GetCompatibleVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of compatible OpenSearch versions returned as part of the GetCompatibleVersions
	// operation.
	CompatibleVersions []*CompatibleVersionsMap `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompatibleVersionsOutput) GoString() string {
	return s.String()
}

// SetCompatibleVersions sets the CompatibleVersions field's value.
func (s *GetCompatibleVersionsOutput) SetCompatibleVersions(v []*CompatibleVersionsMap) *GetCompatibleVersionsOutput {
	s.CompatibleVersions = v
	return s
}

// Container for the request parameters to the GetPackageVersionHistory operation.
type GetPackageVersionHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Limits results to a maximum number of package versions.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Returns an audit history of package versions.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPackageVersionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPackageVersionHistoryInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPackageVersionHistoryInput) SetMaxResults(v int64) *GetPackageVersionHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPackageVersionHistoryInput) SetNextToken(v string) *GetPackageVersionHistoryInput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *GetPackageVersionHistoryInput) SetPackageID(v string) *GetPackageVersionHistoryInput {
	s.PackageID = &v
	return s
}

// Container for response returned by GetPackageVersionHistory operation.
type GetPackageVersionHistoryOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	PackageID *string `type:"string"`

	// List of PackageVersionHistory objects.
	PackageVersionHistoryList []*PackageVersionHistory `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPackageVersionHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetPackageVersionHistoryOutput) SetNextToken(v string) *GetPackageVersionHistoryOutput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *GetPackageVersionHistoryOutput) SetPackageID(v string) *GetPackageVersionHistoryOutput {
	s.PackageID = &v
	return s
}

// SetPackageVersionHistoryList sets the PackageVersionHistoryList field's value.
func (s *GetPackageVersionHistoryOutput) SetPackageVersionHistoryList(v []*PackageVersionHistory) *GetPackageVersionHistoryOutput {
	s.PackageVersionHistoryList = v
	return s
}

// Container for the request parameters to the GetUpgradeHistory operation.
type GetUpgradeHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Set this value to limit the number of results returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accept the NextToken input to return the next page of results
	// and provide a NextToken output in the response, which you can use to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeHistoryInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeHistoryInput) SetDomainName(v string) *GetUpgradeHistoryInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUpgradeHistoryInput) SetMaxResults(v int64) *GetUpgradeHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryInput) SetNextToken(v string) *GetUpgradeHistoryInput {
	s.NextToken = &v
	return s
}

// Container for the response returned by the GetUpgradeHistory operation.
type GetUpgradeHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token that needs to be supplied to the next call to get the next
	// page of results.
	NextToken *string `type:"string"`

	// A list of UpgradeHistory objects corresponding to each upgrade or upgrade
	// eligibility check performed on a domain returned as part of the GetUpgradeHistoryResponse
	// object.
	UpgradeHistories []*UpgradeHistory `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryOutput) SetNextToken(v string) *GetUpgradeHistoryOutput {
	s.NextToken = &v
	return s
}

// SetUpgradeHistories sets the UpgradeHistories field's value.
func (s *GetUpgradeHistoryOutput) SetUpgradeHistories(v []*UpgradeHistory) *GetUpgradeHistoryOutput {
	s.UpgradeHistories = v
	return s
}

// Container for the request parameters to the GetUpgradeStatus operation.
type GetUpgradeStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeStatusInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeStatusInput) SetDomainName(v string) *GetUpgradeStatusInput {
	s.DomainName = &v
	return s
}

// Container for the response returned by the GetUpgradeStatus operation.
type GetUpgradeStatusOutput struct {
	_ struct{} `type:"structure"`

	// One of four statuses an upgrade have, returned as part of the GetUpgradeStatusResponse
	// object. The status can take one of the following values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	StepStatus *string `type:"string" enum:"UpgradeStatus"`

	// A string that briefly describes the update.
	UpgradeName *string `type:"string"`

	// One of three steps an upgrade or upgrade eligibility check goes through:
	//    * PreUpgradeCheck
	//
	//    * Snapshot
	//
	//    * Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUpgradeStatusOutput) GoString() string {
	return s.String()
}

// SetStepStatus sets the StepStatus field's value.
func (s *GetUpgradeStatusOutput) SetStepStatus(v string) *GetUpgradeStatusOutput {
	s.StepStatus = &v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeName(v string) *GetUpgradeStatusOutput {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeStep(v string) *GetUpgradeStatusOutput {
	s.UpgradeStep = &v
	return s
}

// Details of an inbound connection.
type InboundConnection struct {
	_ struct{} `type:"structure"`

	// The connection ID for the inbound cross-cluster connection.
	ConnectionId *string `min:"10" type:"string"`

	// The InboundConnectionStatus for the outbound connection.
	ConnectionStatus *InboundConnectionStatus `type:"structure"`

	// The AWSDomainInformation for the local OpenSearch domain.
	LocalDomainInfo *DomainInformationContainer `type:"structure"`

	// The AWSDomainInformation for the remote OpenSearch domain.
	RemoteDomainInfo *DomainInformationContainer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnection) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *InboundConnection) SetConnectionId(v string) *InboundConnection {
	s.ConnectionId = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *InboundConnection) SetConnectionStatus(v *InboundConnectionStatus) *InboundConnection {
	s.ConnectionStatus = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *InboundConnection) SetLocalDomainInfo(v *DomainInformationContainer) *InboundConnection {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *InboundConnection) SetRemoteDomainInfo(v *DomainInformationContainer) *InboundConnection {
	s.RemoteDomainInfo = v
	return s
}

// The connection status of an inbound cross-cluster connection.
type InboundConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Verbose information for the inbound connection status.
	Message *string `type:"string"`

	// The state code for the inbound connection. Can be one of the following:
	//
	//    * PENDING_ACCEPTANCE: Inbound connection is not yet accepted by the remote
	//    domain owner.
	//
	//    * APPROVED: Inbound connection is pending acceptance by the remote domain
	//    owner.
	//
	//    * PROVISIONING: Inbound connection provisioning is in progress.
	//
	//    * ACTIVE: Inbound connection is active and ready to use.
	//
	//    * REJECTING: Inbound connection rejection is in process.
	//
	//    * REJECTED: Inbound connection is rejected.
	//
	//    * DELETING: Inbound connection deletion is in progress.
	//
	//    * DELETED: Inbound connection is deleted and can no longer be used.
	StatusCode *string `type:"string" enum:"InboundConnectionStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InboundConnectionStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *InboundConnectionStatus) SetMessage(v string) *InboundConnectionStatus {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *InboundConnectionStatus) SetStatusCode(v string) *InboundConnectionStatus {
	s.StatusCode = &v
	return s
}

// InstanceCountLimits represents the limits on the number of instances that
// can be created in Amazon OpenSearch Service for a given InstanceType.
type InstanceCountLimits struct {
	_ struct{} `type:"structure"`

	// Maximum number of instances that can be instantiated for a given InstanceType.
	MaximumInstanceCount *int64 `type:"integer"`

	// Minimum number of instances that can be instantiated for a given InstanceType.
	MinimumInstanceCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCountLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCountLimits) GoString() string {
	return s.String()
}

// SetMaximumInstanceCount sets the MaximumInstanceCount field's value.
func (s *InstanceCountLimits) SetMaximumInstanceCount(v int64) *InstanceCountLimits {
	s.MaximumInstanceCount = &v
	return s
}

// SetMinimumInstanceCount sets the MinimumInstanceCount field's value.
func (s *InstanceCountLimits) SetMinimumInstanceCount(v int64) *InstanceCountLimits {
	s.MinimumInstanceCount = &v
	return s
}

// InstanceLimits represents the list of instance-related attributes that are
// available for a given InstanceType.
type InstanceLimits struct {
	_ struct{} `type:"structure"`

	// InstanceCountLimits represents the limits on the number of instances that
	// can be created in Amazon OpenSearch Service for a given InstanceType.
	InstanceCountLimits *InstanceCountLimits `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceLimits) GoString() string {
	return s.String()
}

// SetInstanceCountLimits sets the InstanceCountLimits field's value.
func (s *InstanceLimits) SetInstanceCountLimits(v *InstanceCountLimits) *InstanceLimits {
	s.InstanceCountLimits = v
	return s
}

type InstanceTypeDetails struct {
	_ struct{} `type:"structure"`

	AdvancedSecurityEnabled *bool `type:"boolean"`

	AppLogsEnabled *bool `type:"boolean"`

	CognitoEnabled *bool `type:"boolean"`

	EncryptionEnabled *bool `type:"boolean"`

	InstanceRole []*string `type:"list"`

	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	WarmEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceTypeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceTypeDetails) GoString() string {
	return s.String()
}

// SetAdvancedSecurityEnabled sets the AdvancedSecurityEnabled field's value.
func (s *InstanceTypeDetails) SetAdvancedSecurityEnabled(v bool) *InstanceTypeDetails {
	s.AdvancedSecurityEnabled = &v
	return s
}

// SetAppLogsEnabled sets the AppLogsEnabled field's value.
func (s *InstanceTypeDetails) SetAppLogsEnabled(v bool) *InstanceTypeDetails {
	s.AppLogsEnabled = &v
	return s
}

// SetCognitoEnabled sets the CognitoEnabled field's value.
func (s *InstanceTypeDetails) SetCognitoEnabled(v bool) *InstanceTypeDetails {
	s.CognitoEnabled = &v
	return s
}

// SetEncryptionEnabled sets the EncryptionEnabled field's value.
func (s *InstanceTypeDetails) SetEncryptionEnabled(v bool) *InstanceTypeDetails {
	s.EncryptionEnabled = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *InstanceTypeDetails) SetInstanceRole(v []*string) *InstanceTypeDetails {
	s.InstanceRole = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeDetails) SetInstanceType(v string) *InstanceTypeDetails {
	s.InstanceType = &v
	return s
}

// SetWarmEnabled sets the WarmEnabled field's value.
func (s *InstanceTypeDetails) SetWarmEnabled(v bool) *InstanceTypeDetails {
	s.WarmEnabled = &v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure (the failure is internal to the service) . Gives http status code
// of 500.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request processing has failed because of invalid pagination token provided
// by customer. Returns an HTTP status code of 400.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for trying to create or access sub-resource that is either invalid
// or not supported. Gives http status code of 409.
type InvalidTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidTypeException(v protocol.ResponseMetadata) error {
	return &InvalidTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTypeException) Code() string {
	return "InvalidTypeException"
}

// Message returns the exception's message.
func (s *InvalidTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTypeException) OrigErr() error {
	return nil
}

func (s *InvalidTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for trying to create more than allowed resources or sub-resources.
// Gives http status code of 409.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Limits for a given InstanceType and for each of its roles. Limits contains
// the following: StorageTypes , InstanceLimits , and AdditionalLimits
type Limits struct {
	_ struct{} `type:"structure"`

	// List of additional limits that are specific to a given InstanceType and for
	// each of its InstanceRole .
	AdditionalLimits []*AdditionalLimit `type:"list"`

	// InstanceLimits represents the list of instance-related attributes that are
	// available for a given InstanceType.
	InstanceLimits *InstanceLimits `type:"structure"`

	// Storage-related types and attributes that are available for a given InstanceType.
	StorageTypes []*StorageType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Limits) GoString() string {
	return s.String()
}

// SetAdditionalLimits sets the AdditionalLimits field's value.
func (s *Limits) SetAdditionalLimits(v []*AdditionalLimit) *Limits {
	s.AdditionalLimits = v
	return s
}

// SetInstanceLimits sets the InstanceLimits field's value.
func (s *Limits) SetInstanceLimits(v *InstanceLimits) *Limits {
	s.InstanceLimits = v
	return s
}

// SetStorageTypes sets the StorageTypes field's value.
func (s *Limits) SetStorageTypes(v []*StorageType) *Limits {
	s.StorageTypes = v
	return s
}

// Container for the parameters to the ListDomainNames operation.
type ListDomainNamesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional parameter to filter the output by domain engine type. Acceptable
	// values are 'Elasticsearch' and 'OpenSearch'.
	EngineType *string `location:"querystring" locationName:"engineType" type:"string" enum:"EngineType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// SetEngineType sets the EngineType field's value.
func (s *ListDomainNamesInput) SetEngineType(v string) *ListDomainNamesInput {
	s.EngineType = &v
	return s
}

// The result of a ListDomainNames operation. Contains the names of all domains
// owned by this account and their respective engine types.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// List of domain names and respective engine types.
	DomainNames []*DomainInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainNamesOutput) SetDomainNames(v []*DomainInfo) *ListDomainNamesOutput {
	s.DomainNames = v
	return s
}

// Container for the request parameters to the ListDomainsForPackage operation.
type ListDomainsForPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Limits the results to a maximum number of domains.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The package for which to list associated domains.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsForPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsForPackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageID != nil && len(*s.PackageID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsForPackageInput) SetMaxResults(v int64) *ListDomainsForPackageInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsForPackageInput) SetNextToken(v string) *ListDomainsForPackageInput {
	s.NextToken = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *ListDomainsForPackageInput) SetPackageID(v string) *ListDomainsForPackageInput {
	s.PackageID = &v
	return s
}

// Container for the response parameters to the ListDomainsForPackage operation.
type ListDomainsForPackageOutput struct {
	_ struct{} `type:"structure"`

	// List of DomainPackageDetails objects.
	DomainPackageDetailsList []*DomainPackageDetails `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsForPackageOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetailsList sets the DomainPackageDetailsList field's value.
func (s *ListDomainsForPackageOutput) SetDomainPackageDetailsList(v []*DomainPackageDetails) *ListDomainsForPackageOutput {
	s.DomainPackageDetailsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsForPackageOutput) SetNextToken(v string) *ListDomainsForPackageOutput {
	s.NextToken = &v
	return s
}

type ListInstanceTypeDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// EngineVersion is a required field
	EngineVersion *string `location:"uri" locationName:"EngineVersion" min:"14" type:"string" required:"true"`

	// Set this value to limit the number of results returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accept the NextToken input to return the next page of results
	// and provide a NextToken output in the response, which you can use to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceTypeDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceTypeDetailsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.EngineVersion != nil && len(*s.EngineVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EngineVersion", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListInstanceTypeDetailsInput) SetDomainName(v string) *ListInstanceTypeDetailsInput {
	s.DomainName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ListInstanceTypeDetailsInput) SetEngineVersion(v string) *ListInstanceTypeDetailsInput {
	s.EngineVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstanceTypeDetailsInput) SetMaxResults(v int64) *ListInstanceTypeDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstanceTypeDetailsInput) SetNextToken(v string) *ListInstanceTypeDetailsInput {
	s.NextToken = &v
	return s
}

type ListInstanceTypeDetailsOutput struct {
	_ struct{} `type:"structure"`

	InstanceTypeDetails []*InstanceTypeDetails `type:"list"`

	// Paginated APIs accept the NextToken input to return the next page of results
	// and provide a NextToken output in the response, which you can use to retrieve
	// more results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceTypeDetailsOutput) GoString() string {
	return s.String()
}

// SetInstanceTypeDetails sets the InstanceTypeDetails field's value.
func (s *ListInstanceTypeDetailsOutput) SetInstanceTypeDetails(v []*InstanceTypeDetails) *ListInstanceTypeDetailsOutput {
	s.InstanceTypeDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstanceTypeDetailsOutput) SetNextToken(v string) *ListInstanceTypeDetailsOutput {
	s.NextToken = &v
	return s
}

// Container for the request parameters to the ListPackagesForDomain operation.
type ListPackagesForDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain for which you want to list associated packages.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Limits results to a maximum number of packages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagesForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagesForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListPackagesForDomainInput) SetDomainName(v string) *ListPackagesForDomainInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagesForDomainInput) SetMaxResults(v int64) *ListPackagesForDomainInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesForDomainInput) SetNextToken(v string) *ListPackagesForDomainInput {
	s.NextToken = &v
	return s
}

// Container for the response parameters to the ListPackagesForDomain operation.
type ListPackagesForDomainOutput struct {
	_ struct{} `type:"structure"`

	// List of DomainPackageDetails objects.
	DomainPackageDetailsList []*DomainPackageDetails `type:"list"`

	// Pagination token to supply to the next call to get the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesForDomainOutput) GoString() string {
	return s.String()
}

// SetDomainPackageDetailsList sets the DomainPackageDetailsList field's value.
func (s *ListPackagesForDomainOutput) SetDomainPackageDetailsList(v []*DomainPackageDetails) *ListPackagesForDomainOutput {
	s.DomainPackageDetailsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesForDomainOutput) SetNextToken(v string) *ListPackagesForDomainOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListTags operation. Specify the ARN of
// the domain that the tags you want to view are attached to.
type ListTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specify the ARN of the domain that the tags you want to view are attached
	// to.
	//
	// ARN is a required field
	ARN *string `location:"querystring" locationName:"arn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *ListTagsInput) SetARN(v string) *ListTagsInput {
	s.ARN = &v
	return s
}

// The result of a ListTags operation. Contains tags for all requested domains.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// List of Tag for the requested domain.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

// Container for the parameters to the ListVersions operation.
// Use MaxResults to control the maximum number of results to retrieve in a
// single call.
//
// Use NextToken in response to retrieve more results. If the received response
// does not contain a NextToken, there are no more results to retrieve.
type ListVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Set this value to limit the number of results returned. Value must be greater
	// than 10 or it won't be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accept the NextToken input to return the next page of results
	// and provide a NextToken output in the response, which you can use to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVersionsInput) SetMaxResults(v int64) *ListVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVersionsInput) SetNextToken(v string) *ListVersionsInput {
	s.NextToken = &v
	return s
}

// Container for the parameters for response received from the ListVersions
// operation.
type ListVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Paginated APIs accept the NextToken input to return the next page of results
	// and provide a NextToken output in the response, which you can use to retrieve
	// more results.
	NextToken *string `type:"string"`

	// List of supported OpenSearch versions.
	Versions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVersionsOutput) SetNextToken(v string) *ListVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListVersionsOutput) SetVersions(v []*string) *ListVersionsOutput {
	s.Versions = v
	return s
}

// Log Publishing option that is set for a given domain. Attributes and their
// details:
//    * CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to publish
//    logs to.
//
//    * Enabled: Whether the log publishing for a given log type is enabled
//    or not.
type LogPublishingOption struct {
	_ struct{} `type:"structure"`

	// ARN of the Cloudwatch log group to publish logs to.
	CloudWatchLogsLogGroupArn *string `min:"20" type:"string"`

	// Whether the given log publishing option is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogPublishingOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogPublishingOption"}
	if s.CloudWatchLogsLogGroupArn != nil && len(*s.CloudWatchLogsLogGroupArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogsLogGroupArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *LogPublishingOption) SetCloudWatchLogsLogGroupArn(v string) *LogPublishingOption {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LogPublishingOption) SetEnabled(v bool) *LogPublishingOption {
	s.Enabled = &v
	return s
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The log publishing options configured for the domain.
	Options map[string]*LogPublishingOption `type:"map"`

	// The status of the log publishing options for the domain. See OptionStatus
	// for the status information that's included.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogPublishingOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *LogPublishingOptionsStatus) SetOptions(v map[string]*LogPublishingOption) *LogPublishingOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LogPublishingOptionsStatus) SetStatus(v *OptionStatus) *LogPublishingOptionsStatus {
	s.Status = v
	return s
}

// Credentials for the master user: username and password, ARN, or both.
type MasterUserOptions struct {
	_ struct{} `type:"structure"`

	// ARN for the master user (if IAM is enabled).
	MasterUserARN *string `min:"20" type:"string"`

	// The master user's username, which is stored in the Amazon OpenSearch Service
	// domain's internal database.
	//
	// MasterUserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MasterUserOptions's
	// String and GoString methods.
	MasterUserName *string `min:"1" type:"string" sensitive:"true"`

	// The master user's password, which is stored in the Amazon OpenSearch Service
	// domain's internal database.
	//
	// MasterUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MasterUserOptions's
	// String and GoString methods.
	MasterUserPassword *string `min:"8" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MasterUserOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MasterUserOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MasterUserOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MasterUserOptions"}
	if s.MasterUserARN != nil && len(*s.MasterUserARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserARN", 20))
	}
	if s.MasterUserName != nil && len(*s.MasterUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserName", 1))
	}
	if s.MasterUserPassword != nil && len(*s.MasterUserPassword) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserPassword", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMasterUserARN sets the MasterUserARN field's value.
func (s *MasterUserOptions) SetMasterUserARN(v string) *MasterUserOptions {
	s.MasterUserARN = &v
	return s
}

// SetMasterUserName sets the MasterUserName field's value.
func (s *MasterUserOptions) SetMasterUserName(v string) *MasterUserOptions {
	s.MasterUserName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *MasterUserOptions) SetMasterUserPassword(v string) *MasterUserOptions {
	s.MasterUserPassword = &v
	return s
}

// The node-to-node encryption options.
type NodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// True to enable node-to-node encryption.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *NodeToNodeEncryptionOptions) SetEnabled(v bool) *NodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Status of the node-to-node encryption options for the specified domain.
type NodeToNodeEncryptionOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The node-to-node encryption options for the specified domain.
	//
	// Options is a required field
	Options *NodeToNodeEncryptionOptions `type:"structure" required:"true"`

	// The status of the node-to-node encryption options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeToNodeEncryptionOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetOptions(v *NodeToNodeEncryptionOptions) *NodeToNodeEncryptionOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetStatus(v *OptionStatus) *NodeToNodeEncryptionOptionsStatus {
	s.Status = v
	return s
}

// Provides the current status of the entity.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the entity was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Provides the OptionState for the domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// The timestamp of the last time the entity was updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// The latest version of the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptionStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *OptionStatus) SetCreationDate(v time.Time) *OptionStatus {
	s.CreationDate = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *OptionStatus) SetPendingDeletion(v bool) *OptionStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *OptionStatus) SetState(v string) *OptionStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OptionStatus) SetUpdateDate(v time.Time) *OptionStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *OptionStatus) SetUpdateVersion(v int64) *OptionStatus {
	s.UpdateVersion = &v
	return s
}

// Specifies details about an outbound connection.
type OutboundConnection struct {
	_ struct{} `type:"structure"`

	// The connection alias for the outbound cross-cluster connection.
	ConnectionAlias *string `min:"2" type:"string"`

	// The connection ID for the outbound cross-cluster connection.
	ConnectionId *string `min:"10" type:"string"`

	// The OutboundConnectionStatus for the outbound connection.
	ConnectionStatus *OutboundConnectionStatus `type:"structure"`

	// The DomainInformation for the local OpenSearch domain.
	LocalDomainInfo *DomainInformationContainer `type:"structure"`

	// The DomainInformation for the remote OpenSearch domain.
	RemoteDomainInfo *DomainInformationContainer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnection) GoString() string {
	return s.String()
}

// SetConnectionAlias sets the ConnectionAlias field's value.
func (s *OutboundConnection) SetConnectionAlias(v string) *OutboundConnection {
	s.ConnectionAlias = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *OutboundConnection) SetConnectionId(v string) *OutboundConnection {
	s.ConnectionId = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *OutboundConnection) SetConnectionStatus(v *OutboundConnectionStatus) *OutboundConnection {
	s.ConnectionStatus = v
	return s
}

// SetLocalDomainInfo sets the LocalDomainInfo field's value.
func (s *OutboundConnection) SetLocalDomainInfo(v *DomainInformationContainer) *OutboundConnection {
	s.LocalDomainInfo = v
	return s
}

// SetRemoteDomainInfo sets the RemoteDomainInfo field's value.
func (s *OutboundConnection) SetRemoteDomainInfo(v *DomainInformationContainer) *OutboundConnection {
	s.RemoteDomainInfo = v
	return s
}

// The connection status of an outbound cross-cluster connection.
type OutboundConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Verbose information for the outbound connection status.
	Message *string `type:"string"`

	// The state code for the outbound connection. Can be one of the following:
	//
	//    * VALIDATING: The outbound connection request is being validated.
	//
	//    * VALIDATION_FAILED: Validation failed for the connection request.
	//
	//    * PENDING_ACCEPTANCE: Outbound connection request is validated and is
	//    not yet accepted by the remote domain owner.
	//
	//    * APPROVED: Outbound connection has been approved by the remote domain
	//    owner for getting provisioned.
	//
	//    * PROVISIONING: Outbound connection request is in process.
	//
	//    * ACTIVE: Outbound connection is active and ready to use.
	//
	//    * REJECTING: Outbound connection rejection by remote domain owner is in
	//    progress.
	//
	//    * REJECTED: Outbound connection request is rejected by remote domain owner.
	//
	//    * DELETING: Outbound connection deletion is in progress.
	//
	//    * DELETED: Outbound connection is deleted and can no longer be used.
	StatusCode *string `type:"string" enum:"OutboundConnectionStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutboundConnectionStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *OutboundConnectionStatus) SetMessage(v string) *OutboundConnectionStatus {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *OutboundConnectionStatus) SetStatusCode(v string) *OutboundConnectionStatus {
	s.StatusCode = &v
	return s
}

// Basic information about a package.
type PackageDetails struct {
	_ struct{} `type:"structure"`

	AvailablePackageVersion *string `type:"string"`

	// The timestamp of when the package was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails `type:"structure"`

	LastUpdatedAt *time.Time `type:"timestamp"`

	// User-specified description of the package.
	PackageDescription *string `type:"string"`

	// Internal ID of the package.
	PackageID *string `type:"string"`

	// User-specified name of the package.
	PackageName *string `min:"3" type:"string"`

	// Current state of the package. Values are COPYING, COPY_FAILED, AVAILABLE,
	// DELETING, and DELETE_FAILED.
	PackageStatus *string `type:"string" enum:"PackageStatus"`

	// Currently supports only TXT-DICTIONARY.
	PackageType *string `type:"string" enum:"PackageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageDetails) GoString() string {
	return s.String()
}

// SetAvailablePackageVersion sets the AvailablePackageVersion field's value.
func (s *PackageDetails) SetAvailablePackageVersion(v string) *PackageDetails {
	s.AvailablePackageVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PackageDetails) SetCreatedAt(v time.Time) *PackageDetails {
	s.CreatedAt = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *PackageDetails) SetErrorDetails(v *ErrorDetails) *PackageDetails {
	s.ErrorDetails = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PackageDetails) SetLastUpdatedAt(v time.Time) *PackageDetails {
	s.LastUpdatedAt = &v
	return s
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *PackageDetails) SetPackageDescription(v string) *PackageDetails {
	s.PackageDescription = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *PackageDetails) SetPackageID(v string) *PackageDetails {
	s.PackageID = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageDetails) SetPackageName(v string) *PackageDetails {
	s.PackageName = &v
	return s
}

// SetPackageStatus sets the PackageStatus field's value.
func (s *PackageDetails) SetPackageStatus(v string) *PackageDetails {
	s.PackageStatus = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *PackageDetails) SetPackageType(v string) *PackageDetails {
	s.PackageType = &v
	return s
}

// The Amazon S3 location for importing the package specified as S3BucketName
// and S3Key
type PackageSource struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket containing the package.
	S3BucketName *string `min:"3" type:"string"`

	// Key (file name) of the package.
	S3Key *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageSource"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *PackageSource) SetS3BucketName(v string) *PackageSource {
	s.S3BucketName = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *PackageSource) SetS3Key(v string) *PackageSource {
	s.S3Key = &v
	return s
}

// Details of a package version.
type PackageVersionHistory struct {
	_ struct{} `type:"structure"`

	// A message associated with the package version.
	CommitMessage *string `type:"string"`

	// The timestamp of when the package was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The package version.
	PackageVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionHistory) GoString() string {
	return s.String()
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *PackageVersionHistory) SetCommitMessage(v string) *PackageVersionHistory {
	s.CommitMessage = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PackageVersionHistory) SetCreatedAt(v time.Time) *PackageVersionHistory {
	s.CreatedAt = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PackageVersionHistory) SetPackageVersion(v string) *PackageVersionHistory {
	s.PackageVersion = &v
	return s
}

// Container for parameters to PurchaseReservedInstanceOffering
type PurchaseReservedInstanceOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of OpenSearch instances to reserve.
	InstanceCount *int64 `min:"1" type:"integer"`

	// A customer-specified identifier to track this reservation.
	//
	// ReservationName is a required field
	ReservationName *string `min:"5" type:"string" required:"true"`

	// The ID of the reserved OpenSearch instance offering to purchase.
	//
	// ReservedInstanceOfferingId is a required field
	ReservedInstanceOfferingId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedInstanceOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedInstanceOfferingInput"}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InstanceCount", 1))
	}
	if s.ReservationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationName"))
	}
	if s.ReservationName != nil && len(*s.ReservationName) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationName", 5))
	}
	if s.ReservedInstanceOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedInstanceOfferingId"))
	}
	if s.ReservedInstanceOfferingId != nil && len(*s.ReservedInstanceOfferingId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ReservedInstanceOfferingId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *PurchaseReservedInstanceOfferingInput) SetInstanceCount(v int64) *PurchaseReservedInstanceOfferingInput {
	s.InstanceCount = &v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedInstanceOfferingInput) SetReservationName(v string) *PurchaseReservedInstanceOfferingInput {
	s.ReservationName = &v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *PurchaseReservedInstanceOfferingInput) SetReservedInstanceOfferingId(v string) *PurchaseReservedInstanceOfferingInput {
	s.ReservedInstanceOfferingId = &v
	return s
}

// Represents the output of a PurchaseReservedInstanceOffering operation.
type PurchaseReservedInstanceOfferingOutput struct {
	_ struct{} `type:"structure"`

	// The customer-specified identifier used to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// Details of the reserved OpenSearch instance which was purchased.
	ReservedInstanceId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseReservedInstanceOfferingOutput) GoString() string {
	return s.String()
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedInstanceOfferingOutput) SetReservationName(v string) *PurchaseReservedInstanceOfferingOutput {
	s.ReservationName = &v
	return s
}

// SetReservedInstanceId sets the ReservedInstanceId field's value.
func (s *PurchaseReservedInstanceOfferingOutput) SetReservedInstanceId(v string) *PurchaseReservedInstanceOfferingOutput {
	s.ReservedInstanceId = &v
	return s
}

// Contains the specific price and frequency of a recurring charges for a reserved
// OpenSearch instance, or for a reserved OpenSearch instance offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Container for the parameters to the RejectInboundConnection operation.
type RejectInboundConnectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the inbound connection to reject.
	//
	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"ConnectionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInboundConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectInboundConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.ConnectionId != nil && len(*s.ConnectionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *RejectInboundConnectionInput) SetConnectionId(v string) *RejectInboundConnectionInput {
	s.ConnectionId = &v
	return s
}

// The result of a RejectInboundConnection operation. Contains details about
// the rejected inbound connection.
type RejectInboundConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The InboundConnection of the rejected inbound connection.
	Connection *InboundConnection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInboundConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *RejectInboundConnectionOutput) SetConnection(v *InboundConnection) *RejectInboundConnectionOutput {
	s.Connection = v
	return s
}

// Container for the parameters to the RemoveTags operation. Specify the ARN
// for the domain from which you want to remove the specified TagKey.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the domain from which you want to delete the specified tags.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The TagKey list you want to remove from the domain.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ARN", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RemoveTagsInput) SetARN(v string) *RemoveTagsInput {
	s.ARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Details of a reserved OpenSearch instance.
type ReservedInstance struct {
	_ struct{} `type:"structure"`

	BillingSubscriptionId *int64 `type:"long"`

	// The currency code for the reserved OpenSearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the OpenSearch instance is reserved.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will paid to purchase the specific reserved
	// OpenSearch instance offering.
	FixedPrice *float64 `type:"double"`

	// The number of OpenSearch instances that have been reserved.
	InstanceCount *int64 `type:"integer"`

	// The OpenSearch instance type offered by the reserved instance offering.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// The payment option as defined in the reserved OpenSearch instance offering.
	PaymentOption *string `type:"string" enum:"ReservedInstancePaymentOption"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The customer-specified identifier to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// The unique identifier for the reservation.
	ReservedInstanceId *string `min:"36" type:"string"`

	// The offering identifier.
	ReservedInstanceOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved OpenSearch instance.
	State *string `type:"string"`

	// The rate you are charged for each hour for the domain that is using this
	// reserved instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstance) GoString() string {
	return s.String()
}

// SetBillingSubscriptionId sets the BillingSubscriptionId field's value.
func (s *ReservedInstance) SetBillingSubscriptionId(v int64) *ReservedInstance {
	s.BillingSubscriptionId = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedInstance) SetCurrencyCode(v string) *ReservedInstance {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedInstance) SetDuration(v int64) *ReservedInstance {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedInstance) SetFixedPrice(v float64) *ReservedInstance {
	s.FixedPrice = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ReservedInstance) SetInstanceCount(v int64) *ReservedInstance {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ReservedInstance) SetInstanceType(v string) *ReservedInstance {
	s.InstanceType = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedInstance) SetPaymentOption(v string) *ReservedInstance {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedInstance) SetRecurringCharges(v []*RecurringCharge) *ReservedInstance {
	s.RecurringCharges = v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *ReservedInstance) SetReservationName(v string) *ReservedInstance {
	s.ReservationName = &v
	return s
}

// SetReservedInstanceId sets the ReservedInstanceId field's value.
func (s *ReservedInstance) SetReservedInstanceId(v string) *ReservedInstance {
	s.ReservedInstanceId = &v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *ReservedInstance) SetReservedInstanceOfferingId(v string) *ReservedInstance {
	s.ReservedInstanceOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedInstance) SetStartTime(v time.Time) *ReservedInstance {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedInstance) SetState(v string) *ReservedInstance {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedInstance) SetUsagePrice(v float64) *ReservedInstance {
	s.UsagePrice = &v
	return s
}

// Details of a reserved OpenSearch instance offering.
type ReservedInstanceOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved OpenSearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the OpenSearch
	// instance.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will pay to purchase the specific reserved OpenSearch
	// instance offering.
	FixedPrice *float64 `type:"double"`

	// The OpenSearch instance type offered by the reserved instance offering.
	InstanceType *string `type:"string" enum:"OpenSearchPartitionInstanceType"`

	// Payment option for the reserved OpenSearch instance offering
	PaymentOption *string `type:"string" enum:"ReservedInstancePaymentOption"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The OpenSearch reserved instance offering identifier.
	ReservedInstanceOfferingId *string `min:"36" type:"string"`

	// The rate you are charged for each hour the domain that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstanceOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReservedInstanceOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedInstanceOffering) SetCurrencyCode(v string) *ReservedInstanceOffering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedInstanceOffering) SetDuration(v int64) *ReservedInstanceOffering {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedInstanceOffering) SetFixedPrice(v float64) *ReservedInstanceOffering {
	s.FixedPrice = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ReservedInstanceOffering) SetInstanceType(v string) *ReservedInstanceOffering {
	s.InstanceType = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedInstanceOffering) SetPaymentOption(v string) *ReservedInstanceOffering {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedInstanceOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedInstanceOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedInstanceOfferingId sets the ReservedInstanceOfferingId field's value.
func (s *ReservedInstanceOffering) SetReservedInstanceOfferingId(v string) *ReservedInstanceOffering {
	s.ReservedInstanceOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedInstanceOffering) SetUsagePrice(v float64) *ReservedInstanceOffering {
	s.UsagePrice = &v
	return s
}

// An exception for creating a resource that already exists. Gives http status
// code of 400.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception for accessing or deleting a resource that does not exist. Gives
// http status code of 400.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The SAML identity povider's information.
type SAMLIdp struct {
	_ struct{} `type:"structure"`

	// The unique entity ID of the application in SAML identity provider.
	//
	// EntityId is a required field
	EntityId *string `min:"8" type:"string" required:"true"`

	// The metadata of the SAML application in XML format.
	//
	// MetadataContent is a required field
	MetadataContent *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLIdp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLIdp) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SAMLIdp) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SAMLIdp"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 8))
	}
	if s.MetadataContent == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataContent"))
	}
	if s.MetadataContent != nil && len(*s.MetadataContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetadataContent", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *SAMLIdp) SetEntityId(v string) *SAMLIdp {
	s.EntityId = &v
	return s
}

// SetMetadataContent sets the MetadataContent field's value.
func (s *SAMLIdp) SetMetadataContent(v string) *SAMLIdp {
	s.MetadataContent = &v
	return s
}

// The SAML application configuration for the domain.
type SAMLOptionsInput_ struct {
	_ struct{} `type:"structure"`

	// True if SAML is enabled.
	Enabled *bool `type:"boolean"`

	// The SAML Identity Provider's information.
	Idp *SAMLIdp `type:"structure"`

	// The backend role that the SAML master user is mapped to.
	MasterBackendRole *string `min:"1" type:"string"`

	// The SAML master username, which is stored in the Amazon OpenSearch Service
	// domain's internal database.
	//
	// MasterUserName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SAMLOptionsInput_'s
	// String and GoString methods.
	MasterUserName *string `min:"1" type:"string" sensitive:"true"`

	// Element of the SAML assertion to use for backend roles. Default is roles.
	RolesKey *string `type:"string"`

	// The duration, in minutes, after which a user session becomes inactive. Acceptable
	// values are between 1 and 1440, and the default value is 60.
	SessionTimeoutMinutes *int64 `type:"integer"`

	// Element of the SAML assertion to use for username. Default is NameID.
	SubjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SAMLOptionsInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SAMLOptionsInput_"}
	if s.MasterBackendRole != nil && len(*s.MasterBackendRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterBackendRole", 1))
	}
	if s.MasterUserName != nil && len(*s.MasterUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterUserName", 1))
	}
	if s.Idp != nil {
		if err := s.Idp.Validate(); err != nil {
			invalidParams.AddNested("Idp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *SAMLOptionsInput_) SetEnabled(v bool) *SAMLOptionsInput_ {
	s.Enabled = &v
	return s
}

// SetIdp sets the Idp field's value.
func (s *SAMLOptionsInput_) SetIdp(v *SAMLIdp) *SAMLOptionsInput_ {
	s.Idp = v
	return s
}

// SetMasterBackendRole sets the MasterBackendRole field's value.
func (s *SAMLOptionsInput_) SetMasterBackendRole(v string) *SAMLOptionsInput_ {
	s.MasterBackendRole = &v
	return s
}

// SetMasterUserName sets the MasterUserName field's value.
func (s *SAMLOptionsInput_) SetMasterUserName(v string) *SAMLOptionsInput_ {
	s.MasterUserName = &v
	return s
}

// SetRolesKey sets the RolesKey field's value.
func (s *SAMLOptionsInput_) SetRolesKey(v string) *SAMLOptionsInput_ {
	s.RolesKey = &v
	return s
}

// SetSessionTimeoutMinutes sets the SessionTimeoutMinutes field's value.
func (s *SAMLOptionsInput_) SetSessionTimeoutMinutes(v int64) *SAMLOptionsInput_ {
	s.SessionTimeoutMinutes = &v
	return s
}

// SetSubjectKey sets the SubjectKey field's value.
func (s *SAMLOptionsInput_) SetSubjectKey(v string) *SAMLOptionsInput_ {
	s.SubjectKey = &v
	return s
}

// Describes the SAML application configured for the domain.
type SAMLOptionsOutput_ struct {
	_ struct{} `type:"structure"`

	// True if SAML is enabled.
	Enabled *bool `type:"boolean"`

	// Describes the SAML identity provider's information.
	Idp *SAMLIdp `type:"structure"`

	// The key used for matching the SAML roles attribute.
	RolesKey *string `type:"string"`

	// The duration, in minutes, after which a user session becomes inactive.
	SessionTimeoutMinutes *int64 `type:"integer"`

	// The key used for matching the SAML subject attribute.
	SubjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SAMLOptionsOutput_) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SAMLOptionsOutput_) SetEnabled(v bool) *SAMLOptionsOutput_ {
	s.Enabled = &v
	return s
}

// SetIdp sets the Idp field's value.
func (s *SAMLOptionsOutput_) SetIdp(v *SAMLIdp) *SAMLOptionsOutput_ {
	s.Idp = v
	return s
}

// SetRolesKey sets the RolesKey field's value.
func (s *SAMLOptionsOutput_) SetRolesKey(v string) *SAMLOptionsOutput_ {
	s.RolesKey = &v
	return s
}

// SetSessionTimeoutMinutes sets the SessionTimeoutMinutes field's value.
func (s *SAMLOptionsOutput_) SetSessionTimeoutMinutes(v int64) *SAMLOptionsOutput_ {
	s.SessionTimeoutMinutes = &v
	return s
}

// SetSubjectKey sets the SubjectKey field's value.
func (s *SAMLOptionsOutput_) SetSubjectKey(v string) *SAMLOptionsOutput_ {
	s.SubjectKey = &v
	return s
}

// Specifies details about the scheduled Auto-Tune action. See Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type ScheduledAutoTuneDetails struct {
	_ struct{} `type:"structure"`

	// The Auto-Tune action description.
	Action *string `type:"string"`

	// The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
	ActionType *string `type:"string" enum:"ScheduledAutoTuneActionType"`

	// The timestamp of the Auto-Tune action scheduled for the domain.
	Date *time.Time `type:"timestamp"`

	// The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.
	Severity *string `type:"string" enum:"ScheduledAutoTuneSeverityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAutoTuneDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAutoTuneDetails) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ScheduledAutoTuneDetails) SetAction(v string) *ScheduledAutoTuneDetails {
	s.Action = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ScheduledAutoTuneDetails) SetActionType(v string) *ScheduledAutoTuneDetails {
	s.ActionType = &v
	return s
}

// SetDate sets the Date field's value.
func (s *ScheduledAutoTuneDetails) SetDate(v time.Time) *ScheduledAutoTuneDetails {
	s.Date = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ScheduledAutoTuneDetails) SetSeverity(v string) *ScheduledAutoTuneDetails {
	s.Severity = &v
	return s
}

// The current options of an domain service software options.
type ServiceSoftwareOptions struct {
	_ struct{} `type:"structure"`

	// The timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time `type:"timestamp"`

	// True if you're able to cancel your service software version update. False
	// if you can't cancel your service software update.
	Cancellable *bool `type:"boolean"`

	// The current service software version present on the domain.
	CurrentVersion *string `type:"string"`

	// The description of the UpdateStatus.
	Description *string `type:"string"`

	// The new service software version if one is available.
	NewVersion *string `type:"string"`

	// True if a service software is never automatically updated. False if a service
	// software is automatically updated after AutomatedUpdateDate.
	OptionalDeployment *bool `type:"boolean"`

	// True if you're able to update your service software version. False if you
	// can't update your service software version.
	UpdateAvailable *bool `type:"boolean"`

	// The status of your service software update. This field can take the following
	// values: ELIGIBLE, PENDING_UPDATE, IN_PROGRESS, COMPLETED, and NOT_ELIGIBLE.
	UpdateStatus *string `type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSoftwareOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSoftwareOptions) GoString() string {
	return s.String()
}

// SetAutomatedUpdateDate sets the AutomatedUpdateDate field's value.
func (s *ServiceSoftwareOptions) SetAutomatedUpdateDate(v time.Time) *ServiceSoftwareOptions {
	s.AutomatedUpdateDate = &v
	return s
}

// SetCancellable sets the Cancellable field's value.
func (s *ServiceSoftwareOptions) SetCancellable(v bool) *ServiceSoftwareOptions {
	s.Cancellable = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ServiceSoftwareOptions) SetCurrentVersion(v string) *ServiceSoftwareOptions {
	s.CurrentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSoftwareOptions) SetDescription(v string) *ServiceSoftwareOptions {
	s.Description = &v
	return s
}

// SetNewVersion sets the NewVersion field's value.
func (s *ServiceSoftwareOptions) SetNewVersion(v string) *ServiceSoftwareOptions {
	s.NewVersion = &v
	return s
}

// SetOptionalDeployment sets the OptionalDeployment field's value.
func (s *ServiceSoftwareOptions) SetOptionalDeployment(v bool) *ServiceSoftwareOptions {
	s.OptionalDeployment = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *ServiceSoftwareOptions) SetUpdateAvailable(v bool) *ServiceSoftwareOptions {
	s.UpdateAvailable = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ServiceSoftwareOptions) SetUpdateStatus(v string) *ServiceSoftwareOptions {
	s.UpdateStatus = &v
	return s
}

// The time, in UTC format, when the service takes a daily automated snapshot
// of the specified domain. Default is 0 hours.
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// The time, in UTC format, when the service takes a daily automated snapshot
	// of the specified domain. Default is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptions) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotStartHour sets the AutomatedSnapshotStartHour field's value.
func (s *SnapshotOptions) SetAutomatedSnapshotStartHour(v int64) *SnapshotOptions {
	s.AutomatedSnapshotStartHour = &v
	return s
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The daily snapshot options specified for the domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// The status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SnapshotOptionsStatus) SetOptions(v *SnapshotOptions) *SnapshotOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SnapshotOptionsStatus) SetStatus(v *OptionStatus) *SnapshotOptionsStatus {
	s.Status = v
	return s
}

// Container for the parameters to the StartServiceSoftwareUpdate operation.
// Specifies the name of the domain to schedule a service software update for.
type StartServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to update to the latest service software.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *StartServiceSoftwareUpdateInput) SetDomainName(v string) *StartServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// The result of a StartServiceSoftwareUpdate operation. Contains the status
// of the update.
type StartServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the OpenSearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *StartServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *StartServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// StorageTypes represents the list of storage-related types and their attributes
// that are available for a given InstanceType.
type StorageType struct {
	_ struct{} `type:"structure"`

	// Sub-type of the given storage type. List of available sub-storage options:
	// "instance" storageType has no storageSubType. "ebs" storageType has the following
	// valid storageSubTypes: standard gp2 io1 See VolumeType for more information
	// regarding each EBS storage option.
	StorageSubTypeName *string `type:"string"`

	// Limits that are applicable for the given storage type.
	StorageTypeLimits []*StorageTypeLimit `type:"list"`

	// Type of storage. List of available storage options: instance Built-in storage
	// available for the instance ebs Elastic block storage attached to the instance
	StorageTypeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageType) GoString() string {
	return s.String()
}

// SetStorageSubTypeName sets the StorageSubTypeName field's value.
func (s *StorageType) SetStorageSubTypeName(v string) *StorageType {
	s.StorageSubTypeName = &v
	return s
}

// SetStorageTypeLimits sets the StorageTypeLimits field's value.
func (s *StorageType) SetStorageTypeLimits(v []*StorageTypeLimit) *StorageType {
	s.StorageTypeLimits = v
	return s
}

// SetStorageTypeName sets the StorageTypeName field's value.
func (s *StorageType) SetStorageTypeName(v string) *StorageType {
	s.StorageTypeName = &v
	return s
}

// Limits that are applicable for the given storage type.
type StorageTypeLimit struct {
	_ struct{} `type:"structure"`

	// Name of storage limits that are applicable for the given storage type. If
	// StorageType is "ebs", the following storage options are applicable: MinimumVolumeSize
	// Minimum amount of volume size that is applicable for the given storage type.
	// Can be empty if not applicable. MaximumVolumeSize Maximum amount of volume
	// size that is applicable for the given storage type. Can be empty if not applicable.
	// MaximumIops Maximum amount of Iops that is applicable for given the storage
	// type. Can be empty if not applicable. MinimumIops Minimum amount of Iops
	// that is applicable for given the storage type. Can be empty if not applicable.
	LimitName *string `type:"string"`

	// Values for the StorageTypeLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageTypeLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageTypeLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *StorageTypeLimit) SetLimitName(v string) *StorageTypeLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *StorageTypeLimit) SetLimitValues(v []*string) *StorageTypeLimit {
	s.LimitValues = v
	return s
}

// A key value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The TagKey, the name of the tag. Tag keys must be unique for the domain to
	// which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The TagValue, the value assigned to the corresponding tag key. Tag values
	// can be null and don't have to be unique in a tag set. For example, you can
	// have a key value pair in a tag set of project : Trinity and cost-center :
	// Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the UpdateDomain operation. Specifies the
// type and number of instances in the domain cluster.
type UpdateDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Modifies the advanced option to allow references to indices in an HTTP request
	// body. Must be false when configuring access to individual sub-resources.
	// By default, the value is true. See Advanced options (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// Specifies advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptionsInput_ `type:"structure"`

	// Specifies Auto-Tune options.
	AutoTuneOptions *AutoTuneOptions `type:"structure"`

	// The type and number of instances to instantiate for the domain cluster.
	ClusterConfig *ClusterConfig `type:"structure"`

	// Options to specify the Cognito user and identity pools for OpenSearch Dashboards
	// authentication. For more information, see Configuring Amazon Cognito authentication
	// for OpenSearch Dashboards (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// Options to specify configuration that will be applied to the domain endpoint.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The name of the domain you're updating.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Specify the type and size of the EBS volume to use.
	EBSOptions *EBSOptions `type:"structure"`

	// Specifies encryption of data at rest options.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// Map of LogType and LogPublishingOption, each containing options to publish
	// a given type of OpenSearch log.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Specifies node-to-node encryption options.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Option to set the time, in UTC format, for the daily automated snapshot.
	// Default value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Options to specify the subnets and security groups for the VPC endpoint.
	// For more information, see Launching your Amazon OpenSearch Service domains
	// using a VPC (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.AdvancedSecurityOptions != nil {
		if err := s.AdvancedSecurityOptions.Validate(); err != nil {
			invalidParams.AddNested("AdvancedSecurityOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.AutoTuneOptions != nil {
		if err := s.AutoTuneOptions.Validate(); err != nil {
			invalidParams.AddNested("AutoTuneOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ClusterConfig != nil {
		if err := s.ClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DomainEndpointOptions != nil {
		if err := s.DomainEndpointOptions.Validate(); err != nil {
			invalidParams.AddNested("DomainEndpointOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LogPublishingOptions != nil {
		for i, v := range s.LogPublishingOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogPublishingOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *UpdateDomainConfigInput) SetAccessPolicies(v string) *UpdateDomainConfigInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpdateDomainConfigInput) SetAdvancedOptions(v map[string]*string) *UpdateDomainConfigInput {
	s.AdvancedOptions = v
	return s
}

// SetAdvancedSecurityOptions sets the AdvancedSecurityOptions field's value.
func (s *UpdateDomainConfigInput) SetAdvancedSecurityOptions(v *AdvancedSecurityOptionsInput_) *UpdateDomainConfigInput {
	s.AdvancedSecurityOptions = v
	return s
}

// SetAutoTuneOptions sets the AutoTuneOptions field's value.
func (s *UpdateDomainConfigInput) SetAutoTuneOptions(v *AutoTuneOptions) *UpdateDomainConfigInput {
	s.AutoTuneOptions = v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *UpdateDomainConfigInput) SetClusterConfig(v *ClusterConfig) *UpdateDomainConfigInput {
	s.ClusterConfig = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *UpdateDomainConfigInput) SetCognitoOptions(v *CognitoOptions) *UpdateDomainConfigInput {
	s.CognitoOptions = v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *UpdateDomainConfigInput) SetDomainEndpointOptions(v *DomainEndpointOptions) *UpdateDomainConfigInput {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainConfigInput) SetDomainName(v string) *UpdateDomainConfigInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *UpdateDomainConfigInput) SetEBSOptions(v *EBSOptions) *UpdateDomainConfigInput {
	s.EBSOptions = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *UpdateDomainConfigInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *UpdateDomainConfigInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *UpdateDomainConfigInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *UpdateDomainConfigInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *UpdateDomainConfigInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *UpdateDomainConfigInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *UpdateDomainConfigInput) SetSnapshotOptions(v *SnapshotOptions) *UpdateDomainConfigInput {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *UpdateDomainConfigInput) SetVPCOptions(v *VPCOptions) *UpdateDomainConfigInput {
	s.VPCOptions = v
	return s
}

// The result of an UpdateDomain request. Contains the status of the domain
// being updated.
type UpdateDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The status of the updated domain.
	//
	// DomainConfig is a required field
	DomainConfig *DomainConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *UpdateDomainConfigOutput) SetDomainConfig(v *DomainConfig) *UpdateDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for request parameters to the UpdatePackage operation.
type UpdatePackageInput struct {
	_ struct{} `type:"structure"`

	// A commit message for the new version which is shown as part of GetPackageVersionHistoryResponse.
	CommitMessage *string `type:"string"`

	// A new description of the package.
	PackageDescription *string `type:"string"`

	// The unique identifier for the package.
	//
	// PackageID is a required field
	PackageID *string `type:"string" required:"true"`

	// The Amazon S3 location for importing the package specified as S3BucketName
	// and S3Key
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePackageInput"}
	if s.PackageID == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageID"))
	}
	if s.PackageSource == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageSource"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *UpdatePackageInput) SetCommitMessage(v string) *UpdatePackageInput {
	s.CommitMessage = &v
	return s
}

// SetPackageDescription sets the PackageDescription field's value.
func (s *UpdatePackageInput) SetPackageDescription(v string) *UpdatePackageInput {
	s.PackageDescription = &v
	return s
}

// SetPackageID sets the PackageID field's value.
func (s *UpdatePackageInput) SetPackageID(v string) *UpdatePackageInput {
	s.PackageID = &v
	return s
}

// SetPackageSource sets the PackageSource field's value.
func (s *UpdatePackageInput) SetPackageSource(v *PackageSource) *UpdatePackageInput {
	s.PackageSource = v
	return s
}

// Container for the response returned by the UpdatePackage operation.
type UpdatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the package.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePackageOutput) GoString() string {
	return s.String()
}

// SetPackageDetails sets the PackageDetails field's value.
func (s *UpdatePackageOutput) SetPackageDetails(v *PackageDetails) *UpdatePackageOutput {
	s.PackageDetails = v
	return s
}

// Container for the request parameters to UpgradeDomain operation.
type UpgradeDomainInput struct {
	_ struct{} `type:"structure"`

	// Exposes select native OpenSearch configuration values from opensearch.yml.
	// Currently, the following advanced options are available:
	//
	//    * Option to allow references to indices in an HTTP request body. Must
	//    be false when configuring access to individual sub-resources. By default,
	//    the value is true. See Advanced cluster parameters for more information.
	//
	//    * Option to specify the percentage of heap space allocated to field data.
	//    By default, this setting is unbounded.
	//
	// For more information, see Advanced cluster parameters (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions map[string]*string `type:"map"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// When true, indicates that an upgrade eligibility check needs to be performed.
	// Does not actually perform the upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// The version of OpenSearch you intend to upgrade the domain to.
	//
	// TargetVersion is a required field
	TargetVersion *string `min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.TargetVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetVersion"))
	}
	if s.TargetVersion != nil && len(*s.TargetVersion) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("TargetVersion", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpgradeDomainInput) SetAdvancedOptions(v map[string]*string) *UpgradeDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeDomainInput) SetDomainName(v string) *UpgradeDomainInput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeDomainInput) SetPerformCheckOnly(v bool) *UpgradeDomainInput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeDomainInput) SetTargetVersion(v string) *UpgradeDomainInput {
	s.TargetVersion = &v
	return s
}

// Container for response returned by UpgradeDomain operation.
type UpgradeDomainOutput struct {
	_ struct{} `type:"structure"`

	// Exposes select native OpenSearch configuration values from opensearch.yml.
	// Currently, the following advanced options are available:
	//
	//    * Option to allow references to indices in an HTTP request body. Must
	//    be false when configuring access to individual sub-resources. By default,
	//    the value is true. See Advanced cluster parameters for more information.
	//
	//    * Option to specify the percentage of heap space allocated to field data.
	//    By default, this setting is unbounded.
	//
	// For more information, see Advanced cluster parameters (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions map[string]*string `type:"map"`

	// The name of an domain. Domain names are unique across the domains owned by
	// an account within an AWS region. Domain names start with a letter or number
	// and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	DomainName *string `min:"3" type:"string"`

	// When true, indicates that an upgrade eligibility check needs to be performed.
	// Does not actually perform the upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// The version of OpenSearch that you intend to upgrade the domain to.
	TargetVersion *string `min:"14" type:"string"`

	UpgradeId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeDomainOutput) GoString() string {
	return s.String()
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpgradeDomainOutput) SetAdvancedOptions(v map[string]*string) *UpgradeDomainOutput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeDomainOutput) SetDomainName(v string) *UpgradeDomainOutput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeDomainOutput) SetPerformCheckOnly(v bool) *UpgradeDomainOutput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeDomainOutput) SetTargetVersion(v string) *UpgradeDomainOutput {
	s.TargetVersion = &v
	return s
}

// SetUpgradeId sets the UpgradeId field's value.
func (s *UpgradeDomainOutput) SetUpgradeId(v string) *UpgradeDomainOutput {
	s.UpgradeId = &v
	return s
}

// History of the last 10 upgrades and upgrade eligibility checks.
type UpgradeHistory struct {
	_ struct{} `type:"structure"`

	// UTC timestamp at which the upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ"
	// format.
	StartTimestamp *time.Time `type:"timestamp"`

	// A list of UpgradeStepItem s representing information about each step performed
	// as part of a specific upgrade or upgrade eligibility check.
	StepsList []*UpgradeStepItem `type:"list"`

	// A string that briefly describes the upgrade.
	UpgradeName *string `type:"string"`

	// The current status of the upgrade. The status can take one of the following
	// values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeHistory) GoString() string {
	return s.String()
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *UpgradeHistory) SetStartTimestamp(v time.Time) *UpgradeHistory {
	s.StartTimestamp = &v
	return s
}

// SetStepsList sets the StepsList field's value.
func (s *UpgradeHistory) SetStepsList(v []*UpgradeStepItem) *UpgradeHistory {
	s.StepsList = v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *UpgradeHistory) SetUpgradeName(v string) *UpgradeHistory {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStatus sets the UpgradeStatus field's value.
func (s *UpgradeHistory) SetUpgradeStatus(v string) *UpgradeHistory {
	s.UpgradeStatus = &v
	return s
}

// Represents a single step of the upgrade or upgrade eligibility check workflow.
type UpgradeStepItem struct {
	_ struct{} `type:"structure"`

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []*string `type:"list"`

	// The floating point value representing the progress percentage of a particular
	// step.
	ProgressPercent *float64 `type:"double"`

	// One of three steps an upgrade or upgrade eligibility check goes through:
	//    * PreUpgradeCheck
	//
	//    * Snapshot
	//
	//    * Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`

	// The current status of the upgrade. The status can take one of the following
	// values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStepStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeStepItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpgradeStepItem) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *UpgradeStepItem) SetIssues(v []*string) *UpgradeStepItem {
	s.Issues = v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *UpgradeStepItem) SetProgressPercent(v float64) *UpgradeStepItem {
	s.ProgressPercent = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *UpgradeStepItem) SetUpgradeStep(v string) *UpgradeStepItem {
	s.UpgradeStep = &v
	return s
}

// SetUpgradeStepStatus sets the UpgradeStepStatus field's value.
func (s *UpgradeStepItem) SetUpgradeStepStatus(v string) *UpgradeStepItem {
	s.UpgradeStepStatus = &v
	return s
}

// Options to specify the subnets and security groups for the VPC endpoint.
// For more information, see Launching your Amazon OpenSearch Service domains
// using a VPC (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
type VPCDerivedInfo struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the domain. Exists only if the domain was created
	// with VPCOptions.
	AvailabilityZones []*string `type:"list"`

	// The security groups for the VPC endpoint.
	SecurityGroupIds []*string `type:"list"`

	// The subnets for the VPC endpoint.
	SubnetIds []*string `type:"list"`

	// The VPC ID for the domain. Exists only if the domain was created with VPCOptions.
	VPCId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfo) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *VPCDerivedInfo) SetAvailabilityZones(v []*string) *VPCDerivedInfo {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCDerivedInfo) SetSecurityGroupIds(v []*string) *VPCDerivedInfo {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCDerivedInfo) SetSubnetIds(v []*string) *VPCDerivedInfo {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *VPCDerivedInfo) SetVPCId(v string) *VPCDerivedInfo {
	s.VPCId = &v
	return s
}

// Status of the VPC options for the specified domain.
type VPCDerivedInfoStatus struct {
	_ struct{} `type:"structure"`

	// The VPC options for the specified domain.
	//
	// Options is a required field
	Options *VPCDerivedInfo `type:"structure" required:"true"`

	// The status of the VPC options for the specified domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfoStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCDerivedInfoStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *VPCDerivedInfoStatus) SetOptions(v *VPCDerivedInfo) *VPCDerivedInfoStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VPCDerivedInfoStatus) SetStatus(v *OptionStatus) *VPCDerivedInfoStatus {
	s.Status = v
	return s
}

// Options to specify the subnets and security groups for the VPC endpoint.
// For more information, see Launching your Amazon OpenSearch Service domains
// using a VPC (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
type VPCOptions struct {
	_ struct{} `type:"structure"`

	// The security groups for the VPC endpoint.
	SecurityGroupIds []*string `type:"list"`

	// The subnets for the VPC endpoint.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCOptions) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCOptions) SetSecurityGroupIds(v []*string) *VPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCOptions) SetSubnetIds(v []*string) *VPCOptions {
	s.SubnetIds = v
	return s
}

// An exception for missing / invalid input fields. Gives http status code of
// 400.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The status of the OpenSearch version options for the specified OpenSearch
// domain.
type VersionStatus struct {
	_ struct{} `type:"structure"`

	// The OpenSearch version for the specified OpenSearch domain.
	//
	// Options is a required field
	Options *string `min:"14" type:"string" required:"true"`

	// The status of the OpenSearch version options for the specified OpenSearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VersionStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *VersionStatus) SetOptions(v string) *VersionStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VersionStatus) SetStatus(v *OptionStatus) *VersionStatus {
	s.Status = v
	return s
}

// The zone awareness configuration for the domain cluster, such as the number
// of availability zones.
type ZoneAwarenessConfig struct {
	_ struct{} `type:"structure"`

	// An integer value to indicate the number of availability zones for a domain
	// when zone awareness is enabled. This should be equal to number of subnets
	// if VPC endpoints is enabled.
	AvailabilityZoneCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZoneAwarenessConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZoneAwarenessConfig) GoString() string {
	return s.String()
}

// SetAvailabilityZoneCount sets the AvailabilityZoneCount field's value.
func (s *ZoneAwarenessConfig) SetAvailabilityZoneCount(v int64) *ZoneAwarenessConfig {
	s.AvailabilityZoneCount = &v
	return s
}

// The Auto-Tune desired state. Valid values are ENABLED and DISABLED.
const (
	// AutoTuneDesiredStateEnabled is a AutoTuneDesiredState enum value
	AutoTuneDesiredStateEnabled = "ENABLED"

	// AutoTuneDesiredStateDisabled is a AutoTuneDesiredState enum value
	AutoTuneDesiredStateDisabled = "DISABLED"
)

// AutoTuneDesiredState_Values returns all elements of the AutoTuneDesiredState enum
func AutoTuneDesiredState_Values() []string {
	return []string{
		AutoTuneDesiredStateEnabled,
		AutoTuneDesiredStateDisabled,
	}
}

// The Auto-Tune state for the domain. For valid states see Auto-Tune for Amazon
// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
const (
	// AutoTuneStateEnabled is a AutoTuneState enum value
	AutoTuneStateEnabled = "ENABLED"

	// AutoTuneStateDisabled is a AutoTuneState enum value
	AutoTuneStateDisabled = "DISABLED"

	// AutoTuneStateEnableInProgress is a AutoTuneState enum value
	AutoTuneStateEnableInProgress = "ENABLE_IN_PROGRESS"

	// AutoTuneStateDisableInProgress is a AutoTuneState enum value
	AutoTuneStateDisableInProgress = "DISABLE_IN_PROGRESS"

	// AutoTuneStateDisabledAndRollbackScheduled is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackScheduled = "DISABLED_AND_ROLLBACK_SCHEDULED"

	// AutoTuneStateDisabledAndRollbackInProgress is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackInProgress = "DISABLED_AND_ROLLBACK_IN_PROGRESS"

	// AutoTuneStateDisabledAndRollbackComplete is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackComplete = "DISABLED_AND_ROLLBACK_COMPLETE"

	// AutoTuneStateDisabledAndRollbackError is a AutoTuneState enum value
	AutoTuneStateDisabledAndRollbackError = "DISABLED_AND_ROLLBACK_ERROR"

	// AutoTuneStateError is a AutoTuneState enum value
	AutoTuneStateError = "ERROR"
)

// AutoTuneState_Values returns all elements of the AutoTuneState enum
func AutoTuneState_Values() []string {
	return []string{
		AutoTuneStateEnabled,
		AutoTuneStateDisabled,
		AutoTuneStateEnableInProgress,
		AutoTuneStateDisableInProgress,
		AutoTuneStateDisabledAndRollbackScheduled,
		AutoTuneStateDisabledAndRollbackInProgress,
		AutoTuneStateDisabledAndRollbackComplete,
		AutoTuneStateDisabledAndRollbackError,
		AutoTuneStateError,
	}
}

// Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.
const (
	// AutoTuneTypeScheduledAction is a AutoTuneType enum value
	AutoTuneTypeScheduledAction = "SCHEDULED_ACTION"
)

// AutoTuneType_Values returns all elements of the AutoTuneType enum
func AutoTuneType_Values() []string {
	return []string{
		AutoTuneTypeScheduledAction,
	}
}

const (
	// DeploymentStatusPendingUpdate is a DeploymentStatus enum value
	DeploymentStatusPendingUpdate = "PENDING_UPDATE"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "IN_PROGRESS"

	// DeploymentStatusCompleted is a DeploymentStatus enum value
	DeploymentStatusCompleted = "COMPLETED"

	// DeploymentStatusNotEligible is a DeploymentStatus enum value
	DeploymentStatusNotEligible = "NOT_ELIGIBLE"

	// DeploymentStatusEligible is a DeploymentStatus enum value
	DeploymentStatusEligible = "ELIGIBLE"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusPendingUpdate,
		DeploymentStatusInProgress,
		DeploymentStatusCompleted,
		DeploymentStatusNotEligible,
		DeploymentStatusEligible,
	}
}

const (
	// DescribePackagesFilterNamePackageId is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageId = "PackageID"

	// DescribePackagesFilterNamePackageName is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageName = "PackageName"

	// DescribePackagesFilterNamePackageStatus is a DescribePackagesFilterName enum value
	DescribePackagesFilterNamePackageStatus = "PackageStatus"
)

// DescribePackagesFilterName_Values returns all elements of the DescribePackagesFilterName enum
func DescribePackagesFilterName_Values() []string {
	return []string{
		DescribePackagesFilterNamePackageId,
		DescribePackagesFilterNamePackageName,
		DescribePackagesFilterNamePackageStatus,
	}
}

const (
	// DomainPackageStatusAssociating is a DomainPackageStatus enum value
	DomainPackageStatusAssociating = "ASSOCIATING"

	// DomainPackageStatusAssociationFailed is a DomainPackageStatus enum value
	DomainPackageStatusAssociationFailed = "ASSOCIATION_FAILED"

	// DomainPackageStatusActive is a DomainPackageStatus enum value
	DomainPackageStatusActive = "ACTIVE"

	// DomainPackageStatusDissociating is a DomainPackageStatus enum value
	DomainPackageStatusDissociating = "DISSOCIATING"

	// DomainPackageStatusDissociationFailed is a DomainPackageStatus enum value
	DomainPackageStatusDissociationFailed = "DISSOCIATION_FAILED"
)

// DomainPackageStatus_Values returns all elements of the DomainPackageStatus enum
func DomainPackageStatus_Values() []string {
	return []string{
		DomainPackageStatusAssociating,
		DomainPackageStatusAssociationFailed,
		DomainPackageStatusActive,
		DomainPackageStatusDissociating,
		DomainPackageStatusDissociationFailed,
	}
}

const (
	// EngineTypeOpenSearch is a EngineType enum value
	EngineTypeOpenSearch = "OpenSearch"

	// EngineTypeElasticsearch is a EngineType enum value
	EngineTypeElasticsearch = "Elasticsearch"
)

// EngineType_Values returns all elements of the EngineType enum
func EngineType_Values() []string {
	return []string{
		EngineTypeOpenSearch,
		EngineTypeElasticsearch,
	}
}

const (
	// InboundConnectionStatusCodePendingAcceptance is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodePendingAcceptance = "PENDING_ACCEPTANCE"

	// InboundConnectionStatusCodeApproved is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeApproved = "APPROVED"

	// InboundConnectionStatusCodeProvisioning is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeProvisioning = "PROVISIONING"

	// InboundConnectionStatusCodeActive is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeActive = "ACTIVE"

	// InboundConnectionStatusCodeRejecting is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeRejecting = "REJECTING"

	// InboundConnectionStatusCodeRejected is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeRejected = "REJECTED"

	// InboundConnectionStatusCodeDeleting is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeDeleting = "DELETING"

	// InboundConnectionStatusCodeDeleted is a InboundConnectionStatusCode enum value
	InboundConnectionStatusCodeDeleted = "DELETED"
)

// InboundConnectionStatusCode_Values returns all elements of the InboundConnectionStatusCode enum
func InboundConnectionStatusCode_Values() []string {
	return []string{
		InboundConnectionStatusCodePendingAcceptance,
		InboundConnectionStatusCodeApproved,
		InboundConnectionStatusCodeProvisioning,
		InboundConnectionStatusCodeActive,
		InboundConnectionStatusCodeRejecting,
		InboundConnectionStatusCodeRejected,
		InboundConnectionStatusCodeDeleting,
		InboundConnectionStatusCodeDeleted,
	}
}

// Type of log file. Can be one of the following:
//    * INDEX_SLOW_LOGS: Index slow logs contain insert requests that took more
//    time than configured index query log threshold to execute.
//
//    * SEARCH_SLOW_LOGS: Search slow logs contain search queries that took
//    more time than configured search query log threshold to execute.
//
//    * ES_APPLICATION_LOGS: OpenSearch application logs contain information
//    about errors and warnings raised during the operation of the service and
//    can be useful for troubleshooting.
//
//    * AUDIT_LOGS: Audit logs contain records of user requests for access from
//    the domain.
const (
	// LogTypeIndexSlowLogs is a LogType enum value
	LogTypeIndexSlowLogs = "INDEX_SLOW_LOGS"

	// LogTypeSearchSlowLogs is a LogType enum value
	LogTypeSearchSlowLogs = "SEARCH_SLOW_LOGS"

	// LogTypeEsApplicationLogs is a LogType enum value
	LogTypeEsApplicationLogs = "ES_APPLICATION_LOGS"

	// LogTypeAuditLogs is a LogType enum value
	LogTypeAuditLogs = "AUDIT_LOGS"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeIndexSlowLogs,
		LogTypeSearchSlowLogs,
		LogTypeEsApplicationLogs,
		LogTypeAuditLogs,
	}
}

const (
	// OpenSearchPartitionInstanceTypeM3MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM3MediumSearch = "m3.medium.search"

	// OpenSearchPartitionInstanceTypeM3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM3LargeSearch = "m3.large.search"

	// OpenSearchPartitionInstanceTypeM3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM3XlargeSearch = "m3.xlarge.search"

	// OpenSearchPartitionInstanceTypeM32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM32xlargeSearch = "m3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM4LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM4LargeSearch = "m4.large.search"

	// OpenSearchPartitionInstanceTypeM4XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM4XlargeSearch = "m4.xlarge.search"

	// OpenSearchPartitionInstanceTypeM42xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM42xlargeSearch = "m4.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM44xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM44xlargeSearch = "m4.4xlarge.search"

	// OpenSearchPartitionInstanceTypeM410xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM410xlargeSearch = "m4.10xlarge.search"

	// OpenSearchPartitionInstanceTypeM5LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM5LargeSearch = "m5.large.search"

	// OpenSearchPartitionInstanceTypeM5XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM5XlargeSearch = "m5.xlarge.search"

	// OpenSearchPartitionInstanceTypeM52xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM52xlargeSearch = "m5.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM54xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM54xlargeSearch = "m5.4xlarge.search"

	// OpenSearchPartitionInstanceTypeM512xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM512xlargeSearch = "m5.12xlarge.search"

	// OpenSearchPartitionInstanceTypeM524xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM524xlargeSearch = "m5.24xlarge.search"

	// OpenSearchPartitionInstanceTypeR5LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR5LargeSearch = "r5.large.search"

	// OpenSearchPartitionInstanceTypeR5XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR5XlargeSearch = "r5.xlarge.search"

	// OpenSearchPartitionInstanceTypeR52xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR52xlargeSearch = "r5.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR54xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR54xlargeSearch = "r5.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR512xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR512xlargeSearch = "r5.12xlarge.search"

	// OpenSearchPartitionInstanceTypeR524xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR524xlargeSearch = "r5.24xlarge.search"

	// OpenSearchPartitionInstanceTypeC5LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC5LargeSearch = "c5.large.search"

	// OpenSearchPartitionInstanceTypeC5XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC5XlargeSearch = "c5.xlarge.search"

	// OpenSearchPartitionInstanceTypeC52xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC52xlargeSearch = "c5.2xlarge.search"

	// OpenSearchPartitionInstanceTypeC54xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC54xlargeSearch = "c5.4xlarge.search"

	// OpenSearchPartitionInstanceTypeC59xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC59xlargeSearch = "c5.9xlarge.search"

	// OpenSearchPartitionInstanceTypeC518xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC518xlargeSearch = "c5.18xlarge.search"

	// OpenSearchPartitionInstanceTypeT3NanoSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3NanoSearch = "t3.nano.search"

	// OpenSearchPartitionInstanceTypeT3MicroSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3MicroSearch = "t3.micro.search"

	// OpenSearchPartitionInstanceTypeT3SmallSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3SmallSearch = "t3.small.search"

	// OpenSearchPartitionInstanceTypeT3MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3MediumSearch = "t3.medium.search"

	// OpenSearchPartitionInstanceTypeT3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3LargeSearch = "t3.large.search"

	// OpenSearchPartitionInstanceTypeT3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT3XlargeSearch = "t3.xlarge.search"

	// OpenSearchPartitionInstanceTypeT32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT32xlargeSearch = "t3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeUltrawarm1MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeUltrawarm1MediumSearch = "ultrawarm1.medium.search"

	// OpenSearchPartitionInstanceTypeUltrawarm1LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeUltrawarm1LargeSearch = "ultrawarm1.large.search"

	// OpenSearchPartitionInstanceTypeUltrawarm1XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeUltrawarm1XlargeSearch = "ultrawarm1.xlarge.search"

	// OpenSearchPartitionInstanceTypeT2MicroSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT2MicroSearch = "t2.micro.search"

	// OpenSearchPartitionInstanceTypeT2SmallSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT2SmallSearch = "t2.small.search"

	// OpenSearchPartitionInstanceTypeT2MediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT2MediumSearch = "t2.medium.search"

	// OpenSearchPartitionInstanceTypeR3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR3LargeSearch = "r3.large.search"

	// OpenSearchPartitionInstanceTypeR3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR3XlargeSearch = "r3.xlarge.search"

	// OpenSearchPartitionInstanceTypeR32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR32xlargeSearch = "r3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR34xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR34xlargeSearch = "r3.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR38xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR38xlargeSearch = "r3.8xlarge.search"

	// OpenSearchPartitionInstanceTypeI2XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI2XlargeSearch = "i2.xlarge.search"

	// OpenSearchPartitionInstanceTypeI22xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI22xlargeSearch = "i2.2xlarge.search"

	// OpenSearchPartitionInstanceTypeD2XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD2XlargeSearch = "d2.xlarge.search"

	// OpenSearchPartitionInstanceTypeD22xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD22xlargeSearch = "d2.2xlarge.search"

	// OpenSearchPartitionInstanceTypeD24xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD24xlargeSearch = "d2.4xlarge.search"

	// OpenSearchPartitionInstanceTypeD28xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeD28xlargeSearch = "d2.8xlarge.search"

	// OpenSearchPartitionInstanceTypeC4LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC4LargeSearch = "c4.large.search"

	// OpenSearchPartitionInstanceTypeC4XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC4XlargeSearch = "c4.xlarge.search"

	// OpenSearchPartitionInstanceTypeC42xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC42xlargeSearch = "c4.2xlarge.search"

	// OpenSearchPartitionInstanceTypeC44xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC44xlargeSearch = "c4.4xlarge.search"

	// OpenSearchPartitionInstanceTypeC48xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC48xlargeSearch = "c4.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR4LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR4LargeSearch = "r4.large.search"

	// OpenSearchPartitionInstanceTypeR4XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR4XlargeSearch = "r4.xlarge.search"

	// OpenSearchPartitionInstanceTypeR42xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR42xlargeSearch = "r4.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR44xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR44xlargeSearch = "r4.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR48xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR48xlargeSearch = "r4.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR416xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR416xlargeSearch = "r4.16xlarge.search"

	// OpenSearchPartitionInstanceTypeI3LargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI3LargeSearch = "i3.large.search"

	// OpenSearchPartitionInstanceTypeI3XlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI3XlargeSearch = "i3.xlarge.search"

	// OpenSearchPartitionInstanceTypeI32xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI32xlargeSearch = "i3.2xlarge.search"

	// OpenSearchPartitionInstanceTypeI34xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI34xlargeSearch = "i3.4xlarge.search"

	// OpenSearchPartitionInstanceTypeI38xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI38xlargeSearch = "i3.8xlarge.search"

	// OpenSearchPartitionInstanceTypeI316xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeI316xlargeSearch = "i3.16xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gLargeSearch = "r6g.large.search"

	// OpenSearchPartitionInstanceTypeR6gXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gXlargeSearch = "r6g.xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g2xlargeSearch = "r6g.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g4xlargeSearch = "r6g.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g8xlargeSearch = "r6g.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR6g12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6g12xlargeSearch = "r6g.12xlarge.search"

	// OpenSearchPartitionInstanceTypeM6gLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6gLargeSearch = "m6g.large.search"

	// OpenSearchPartitionInstanceTypeM6gXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6gXlargeSearch = "m6g.xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g2xlargeSearch = "m6g.2xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g4xlargeSearch = "m6g.4xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g8xlargeSearch = "m6g.8xlarge.search"

	// OpenSearchPartitionInstanceTypeM6g12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeM6g12xlargeSearch = "m6g.12xlarge.search"

	// OpenSearchPartitionInstanceTypeC6gLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6gLargeSearch = "c6g.large.search"

	// OpenSearchPartitionInstanceTypeC6gXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6gXlargeSearch = "c6g.xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g2xlargeSearch = "c6g.2xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g4xlargeSearch = "c6g.4xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g8xlargeSearch = "c6g.8xlarge.search"

	// OpenSearchPartitionInstanceTypeC6g12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeC6g12xlargeSearch = "c6g.12xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gdLargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gdLargeSearch = "r6gd.large.search"

	// OpenSearchPartitionInstanceTypeR6gdXlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gdXlargeSearch = "r6gd.xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd2xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd2xlargeSearch = "r6gd.2xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd4xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd4xlargeSearch = "r6gd.4xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd8xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd8xlargeSearch = "r6gd.8xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd12xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd12xlargeSearch = "r6gd.12xlarge.search"

	// OpenSearchPartitionInstanceTypeR6gd16xlargeSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeR6gd16xlargeSearch = "r6gd.16xlarge.search"

	// OpenSearchPartitionInstanceTypeT4gSmallSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT4gSmallSearch = "t4g.small.search"

	// OpenSearchPartitionInstanceTypeT4gMediumSearch is a OpenSearchPartitionInstanceType enum value
	OpenSearchPartitionInstanceTypeT4gMediumSearch = "t4g.medium.search"
)

// OpenSearchPartitionInstanceType_Values returns all elements of the OpenSearchPartitionInstanceType enum
func OpenSearchPartitionInstanceType_Values() []string {
	return []string{
		OpenSearchPartitionInstanceTypeM3MediumSearch,
		OpenSearchPartitionInstanceTypeM3LargeSearch,
		OpenSearchPartitionInstanceTypeM3XlargeSearch,
		OpenSearchPartitionInstanceTypeM32xlargeSearch,
		OpenSearchPartitionInstanceTypeM4LargeSearch,
		OpenSearchPartitionInstanceTypeM4XlargeSearch,
		OpenSearchPartitionInstanceTypeM42xlargeSearch,
		OpenSearchPartitionInstanceTypeM44xlargeSearch,
		OpenSearchPartitionInstanceTypeM410xlargeSearch,
		OpenSearchPartitionInstanceTypeM5LargeSearch,
		OpenSearchPartitionInstanceTypeM5XlargeSearch,
		OpenSearchPartitionInstanceTypeM52xlargeSearch,
		OpenSearchPartitionInstanceTypeM54xlargeSearch,
		OpenSearchPartitionInstanceTypeM512xlargeSearch,
		OpenSearchPartitionInstanceTypeM524xlargeSearch,
		OpenSearchPartitionInstanceTypeR5LargeSearch,
		OpenSearchPartitionInstanceTypeR5XlargeSearch,
		OpenSearchPartitionInstanceTypeR52xlargeSearch,
		OpenSearchPartitionInstanceTypeR54xlargeSearch,
		OpenSearchPartitionInstanceTypeR512xlargeSearch,
		OpenSearchPartitionInstanceTypeR524xlargeSearch,
		OpenSearchPartitionInstanceTypeC5LargeSearch,
		OpenSearchPartitionInstanceTypeC5XlargeSearch,
		OpenSearchPartitionInstanceTypeC52xlargeSearch,
		OpenSearchPartitionInstanceTypeC54xlargeSearch,
		OpenSearchPartitionInstanceTypeC59xlargeSearch,
		OpenSearchPartitionInstanceTypeC518xlargeSearch,
		OpenSearchPartitionInstanceTypeT3NanoSearch,
		OpenSearchPartitionInstanceTypeT3MicroSearch,
		OpenSearchPartitionInstanceTypeT3SmallSearch,
		OpenSearchPartitionInstanceTypeT3MediumSearch,
		OpenSearchPartitionInstanceTypeT3LargeSearch,
		OpenSearchPartitionInstanceTypeT3XlargeSearch,
		OpenSearchPartitionInstanceTypeT32xlargeSearch,
		OpenSearchPartitionInstanceTypeUltrawarm1MediumSearch,
		OpenSearchPartitionInstanceTypeUltrawarm1LargeSearch,
		OpenSearchPartitionInstanceTypeUltrawarm1XlargeSearch,
		OpenSearchPartitionInstanceTypeT2MicroSearch,
		OpenSearchPartitionInstanceTypeT2SmallSearch,
		OpenSearchPartitionInstanceTypeT2MediumSearch,
		OpenSearchPartitionInstanceTypeR3LargeSearch,
		OpenSearchPartitionInstanceTypeR3XlargeSearch,
		OpenSearchPartitionInstanceTypeR32xlargeSearch,
		OpenSearchPartitionInstanceTypeR34xlargeSearch,
		OpenSearchPartitionInstanceTypeR38xlargeSearch,
		OpenSearchPartitionInstanceTypeI2XlargeSearch,
		OpenSearchPartitionInstanceTypeI22xlargeSearch,
		OpenSearchPartitionInstanceTypeD2XlargeSearch,
		OpenSearchPartitionInstanceTypeD22xlargeSearch,
		OpenSearchPartitionInstanceTypeD24xlargeSearch,
		OpenSearchPartitionInstanceTypeD28xlargeSearch,
		OpenSearchPartitionInstanceTypeC4LargeSearch,
		OpenSearchPartitionInstanceTypeC4XlargeSearch,
		OpenSearchPartitionInstanceTypeC42xlargeSearch,
		OpenSearchPartitionInstanceTypeC44xlargeSearch,
		OpenSearchPartitionInstanceTypeC48xlargeSearch,
		OpenSearchPartitionInstanceTypeR4LargeSearch,
		OpenSearchPartitionInstanceTypeR4XlargeSearch,
		OpenSearchPartitionInstanceTypeR42xlargeSearch,
		OpenSearchPartitionInstanceTypeR44xlargeSearch,
		OpenSearchPartitionInstanceTypeR48xlargeSearch,
		OpenSearchPartitionInstanceTypeR416xlargeSearch,
		OpenSearchPartitionInstanceTypeI3LargeSearch,
		OpenSearchPartitionInstanceTypeI3XlargeSearch,
		OpenSearchPartitionInstanceTypeI32xlargeSearch,
		OpenSearchPartitionInstanceTypeI34xlargeSearch,
		OpenSearchPartitionInstanceTypeI38xlargeSearch,
		OpenSearchPartitionInstanceTypeI316xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gLargeSearch,
		OpenSearchPartitionInstanceTypeR6gXlargeSearch,
		OpenSearchPartitionInstanceTypeR6g2xlargeSearch,
		OpenSearchPartitionInstanceTypeR6g4xlargeSearch,
		OpenSearchPartitionInstanceTypeR6g8xlargeSearch,
		OpenSearchPartitionInstanceTypeR6g12xlargeSearch,
		OpenSearchPartitionInstanceTypeM6gLargeSearch,
		OpenSearchPartitionInstanceTypeM6gXlargeSearch,
		OpenSearchPartitionInstanceTypeM6g2xlargeSearch,
		OpenSearchPartitionInstanceTypeM6g4xlargeSearch,
		OpenSearchPartitionInstanceTypeM6g8xlargeSearch,
		OpenSearchPartitionInstanceTypeM6g12xlargeSearch,
		OpenSearchPartitionInstanceTypeC6gLargeSearch,
		OpenSearchPartitionInstanceTypeC6gXlargeSearch,
		OpenSearchPartitionInstanceTypeC6g2xlargeSearch,
		OpenSearchPartitionInstanceTypeC6g4xlargeSearch,
		OpenSearchPartitionInstanceTypeC6g8xlargeSearch,
		OpenSearchPartitionInstanceTypeC6g12xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gdLargeSearch,
		OpenSearchPartitionInstanceTypeR6gdXlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd2xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd4xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd8xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd12xlargeSearch,
		OpenSearchPartitionInstanceTypeR6gd16xlargeSearch,
		OpenSearchPartitionInstanceTypeT4gSmallSearch,
		OpenSearchPartitionInstanceTypeT4gMediumSearch,
	}
}

const (
	// OpenSearchWarmPartitionInstanceTypeUltrawarm1MediumSearch is a OpenSearchWarmPartitionInstanceType enum value
	OpenSearchWarmPartitionInstanceTypeUltrawarm1MediumSearch = "ultrawarm1.medium.search"

	// OpenSearchWarmPartitionInstanceTypeUltrawarm1LargeSearch is a OpenSearchWarmPartitionInstanceType enum value
	OpenSearchWarmPartitionInstanceTypeUltrawarm1LargeSearch = "ultrawarm1.large.search"

	// OpenSearchWarmPartitionInstanceTypeUltrawarm1XlargeSearch is a OpenSearchWarmPartitionInstanceType enum value
	OpenSearchWarmPartitionInstanceTypeUltrawarm1XlargeSearch = "ultrawarm1.xlarge.search"
)

// OpenSearchWarmPartitionInstanceType_Values returns all elements of the OpenSearchWarmPartitionInstanceType enum
func OpenSearchWarmPartitionInstanceType_Values() []string {
	return []string{
		OpenSearchWarmPartitionInstanceTypeUltrawarm1MediumSearch,
		OpenSearchWarmPartitionInstanceTypeUltrawarm1LargeSearch,
		OpenSearchWarmPartitionInstanceTypeUltrawarm1XlargeSearch,
	}
}

// The state of a requested change. One of the following:
//
//    * Processing: The request change is still in progress.
//
//    * Active: The request change is processed and deployed to the domain.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"
)

// OptionState_Values returns all elements of the OptionState enum
func OptionState_Values() []string {
	return []string{
		OptionStateRequiresIndexDocuments,
		OptionStateProcessing,
		OptionStateActive,
	}
}

const (
	// OutboundConnectionStatusCodeValidating is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeValidating = "VALIDATING"

	// OutboundConnectionStatusCodeValidationFailed is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeValidationFailed = "VALIDATION_FAILED"

	// OutboundConnectionStatusCodePendingAcceptance is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodePendingAcceptance = "PENDING_ACCEPTANCE"

	// OutboundConnectionStatusCodeApproved is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeApproved = "APPROVED"

	// OutboundConnectionStatusCodeProvisioning is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeProvisioning = "PROVISIONING"

	// OutboundConnectionStatusCodeActive is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeActive = "ACTIVE"

	// OutboundConnectionStatusCodeRejecting is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeRejecting = "REJECTING"

	// OutboundConnectionStatusCodeRejected is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeRejected = "REJECTED"

	// OutboundConnectionStatusCodeDeleting is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeDeleting = "DELETING"

	// OutboundConnectionStatusCodeDeleted is a OutboundConnectionStatusCode enum value
	OutboundConnectionStatusCodeDeleted = "DELETED"
)

// OutboundConnectionStatusCode_Values returns all elements of the OutboundConnectionStatusCode enum
func OutboundConnectionStatusCode_Values() []string {
	return []string{
		OutboundConnectionStatusCodeValidating,
		OutboundConnectionStatusCodeValidationFailed,
		OutboundConnectionStatusCodePendingAcceptance,
		OutboundConnectionStatusCodeApproved,
		OutboundConnectionStatusCodeProvisioning,
		OutboundConnectionStatusCodeActive,
		OutboundConnectionStatusCodeRejecting,
		OutboundConnectionStatusCodeRejected,
		OutboundConnectionStatusCodeDeleting,
		OutboundConnectionStatusCodeDeleted,
	}
}

const (
	// PackageStatusCopying is a PackageStatus enum value
	PackageStatusCopying = "COPYING"

	// PackageStatusCopyFailed is a PackageStatus enum value
	PackageStatusCopyFailed = "COPY_FAILED"

	// PackageStatusValidating is a PackageStatus enum value
	PackageStatusValidating = "VALIDATING"

	// PackageStatusValidationFailed is a PackageStatus enum value
	PackageStatusValidationFailed = "VALIDATION_FAILED"

	// PackageStatusAvailable is a PackageStatus enum value
	PackageStatusAvailable = "AVAILABLE"

	// PackageStatusDeleting is a PackageStatus enum value
	PackageStatusDeleting = "DELETING"

	// PackageStatusDeleted is a PackageStatus enum value
	PackageStatusDeleted = "DELETED"

	// PackageStatusDeleteFailed is a PackageStatus enum value
	PackageStatusDeleteFailed = "DELETE_FAILED"
)

// PackageStatus_Values returns all elements of the PackageStatus enum
func PackageStatus_Values() []string {
	return []string{
		PackageStatusCopying,
		PackageStatusCopyFailed,
		PackageStatusValidating,
		PackageStatusValidationFailed,
		PackageStatusAvailable,
		PackageStatusDeleting,
		PackageStatusDeleted,
		PackageStatusDeleteFailed,
	}
}

const (
	// PackageTypeTxtDictionary is a PackageType enum value
	PackageTypeTxtDictionary = "TXT-DICTIONARY"
)

// PackageType_Values returns all elements of the PackageType enum
func PackageType_Values() []string {
	return []string{
		PackageTypeTxtDictionary,
	}
}

const (
	// ReservedInstancePaymentOptionAllUpfront is a ReservedInstancePaymentOption enum value
	ReservedInstancePaymentOptionAllUpfront = "ALL_UPFRONT"

	// ReservedInstancePaymentOptionPartialUpfront is a ReservedInstancePaymentOption enum value
	ReservedInstancePaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// ReservedInstancePaymentOptionNoUpfront is a ReservedInstancePaymentOption enum value
	ReservedInstancePaymentOptionNoUpfront = "NO_UPFRONT"
)

// ReservedInstancePaymentOption_Values returns all elements of the ReservedInstancePaymentOption enum
func ReservedInstancePaymentOption_Values() []string {
	return []string{
		ReservedInstancePaymentOptionAllUpfront,
		ReservedInstancePaymentOptionPartialUpfront,
		ReservedInstancePaymentOptionNoUpfront,
	}
}

// The rollback state while disabling Auto-Tune for the domain. Valid values
// are NO_ROLLBACK and DEFAULT_ROLLBACK.
const (
	// RollbackOnDisableNoRollback is a RollbackOnDisable enum value
	RollbackOnDisableNoRollback = "NO_ROLLBACK"

	// RollbackOnDisableDefaultRollback is a RollbackOnDisable enum value
	RollbackOnDisableDefaultRollback = "DEFAULT_ROLLBACK"
)

// RollbackOnDisable_Values returns all elements of the RollbackOnDisable enum
func RollbackOnDisable_Values() []string {
	return []string{
		RollbackOnDisableNoRollback,
		RollbackOnDisableDefaultRollback,
	}
}

// The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING, and JVM_YOUNG_GEN_TUNING.
const (
	// ScheduledAutoTuneActionTypeJvmHeapSizeTuning is a ScheduledAutoTuneActionType enum value
	ScheduledAutoTuneActionTypeJvmHeapSizeTuning = "JVM_HEAP_SIZE_TUNING"

	// ScheduledAutoTuneActionTypeJvmYoungGenTuning is a ScheduledAutoTuneActionType enum value
	ScheduledAutoTuneActionTypeJvmYoungGenTuning = "JVM_YOUNG_GEN_TUNING"
)

// ScheduledAutoTuneActionType_Values returns all elements of the ScheduledAutoTuneActionType enum
func ScheduledAutoTuneActionType_Values() []string {
	return []string{
		ScheduledAutoTuneActionTypeJvmHeapSizeTuning,
		ScheduledAutoTuneActionTypeJvmYoungGenTuning,
	}
}

// The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.
const (
	// ScheduledAutoTuneSeverityTypeLow is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeLow = "LOW"

	// ScheduledAutoTuneSeverityTypeMedium is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeMedium = "MEDIUM"

	// ScheduledAutoTuneSeverityTypeHigh is a ScheduledAutoTuneSeverityType enum value
	ScheduledAutoTuneSeverityTypeHigh = "HIGH"
)

// ScheduledAutoTuneSeverityType_Values returns all elements of the ScheduledAutoTuneSeverityType enum
func ScheduledAutoTuneSeverityType_Values() []string {
	return []string{
		ScheduledAutoTuneSeverityTypeLow,
		ScheduledAutoTuneSeverityTypeMedium,
		ScheduledAutoTuneSeverityTypeHigh,
	}
}

const (
	// TLSSecurityPolicyPolicyMinTls10201907 is a TLSSecurityPolicy enum value
	TLSSecurityPolicyPolicyMinTls10201907 = "Policy-Min-TLS-1-0-2019-07"

	// TLSSecurityPolicyPolicyMinTls12201907 is a TLSSecurityPolicy enum value
	TLSSecurityPolicyPolicyMinTls12201907 = "Policy-Min-TLS-1-2-2019-07"
)

// TLSSecurityPolicy_Values returns all elements of the TLSSecurityPolicy enum
func TLSSecurityPolicy_Values() []string {
	return []string{
		TLSSecurityPolicyPolicyMinTls10201907,
		TLSSecurityPolicyPolicyMinTls12201907,
	}
}

// The unit of a maintenance schedule duration. Valid value is HOUR. See Auto-Tune
// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
const (
	// TimeUnitHours is a TimeUnit enum value
	TimeUnitHours = "HOURS"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitHours,
	}
}

const (
	// UpgradeStatusInProgress is a UpgradeStatus enum value
	UpgradeStatusInProgress = "IN_PROGRESS"

	// UpgradeStatusSucceeded is a UpgradeStatus enum value
	UpgradeStatusSucceeded = "SUCCEEDED"

	// UpgradeStatusSucceededWithIssues is a UpgradeStatus enum value
	UpgradeStatusSucceededWithIssues = "SUCCEEDED_WITH_ISSUES"

	// UpgradeStatusFailed is a UpgradeStatus enum value
	UpgradeStatusFailed = "FAILED"
)

// UpgradeStatus_Values returns all elements of the UpgradeStatus enum
func UpgradeStatus_Values() []string {
	return []string{
		UpgradeStatusInProgress,
		UpgradeStatusSucceeded,
		UpgradeStatusSucceededWithIssues,
		UpgradeStatusFailed,
	}
}

const (
	// UpgradeStepPreUpgradeCheck is a UpgradeStep enum value
	UpgradeStepPreUpgradeCheck = "PRE_UPGRADE_CHECK"

	// UpgradeStepSnapshot is a UpgradeStep enum value
	UpgradeStepSnapshot = "SNAPSHOT"

	// UpgradeStepUpgrade is a UpgradeStep enum value
	UpgradeStepUpgrade = "UPGRADE"
)

// UpgradeStep_Values returns all elements of the UpgradeStep enum
func UpgradeStep_Values() []string {
	return []string{
		UpgradeStepPreUpgradeCheck,
		UpgradeStepSnapshot,
		UpgradeStepUpgrade,
	}
}

// The type of EBS volume, standard, gp2, or io1. See Configuring EBS-based
// Storage (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-createupdatedomains.html#opensearch-createdomain-configure-ebs)
// for more information.
const (
	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"

	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"
)

// VolumeType_Values returns all elements of the VolumeType enum
func VolumeType_Values() []string {
	return []string{
		VolumeTypeStandard,
		VolumeTypeGp2,
		VolumeTypeIo1,
	}
}
