// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package efs_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/efs"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleEFS_CreateFileSystem() {
	svc := efs.New(session.New())

	params := &efs.CreateFileSystemInput{
		CreationToken: aws.String("CreationToken"), // Required
	}
	resp, err := svc.CreateFileSystem(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_CreateMountTarget() {
	svc := efs.New(session.New())

	params := &efs.CreateMountTargetInput{
		FileSystemId: aws.String("FileSystemId"), // Required
		SubnetId:     aws.String("SubnetId"),     // Required
		IpAddress:    aws.String("IpAddress"),
		SecurityGroups: []*string{
			aws.String("SecurityGroup"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateMountTarget(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_CreateTags() {
	svc := efs.New(session.New())

	params := &efs.CreateTagsInput{
		FileSystemId: aws.String("FileSystemId"), // Required
		Tags: []*efs.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"),   // Required
				Value: aws.String("TagValue"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.CreateTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DeleteFileSystem() {
	svc := efs.New(session.New())

	params := &efs.DeleteFileSystemInput{
		FileSystemId: aws.String("FileSystemId"), // Required
	}
	resp, err := svc.DeleteFileSystem(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DeleteMountTarget() {
	svc := efs.New(session.New())

	params := &efs.DeleteMountTargetInput{
		MountTargetId: aws.String("MountTargetId"), // Required
	}
	resp, err := svc.DeleteMountTarget(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DeleteTags() {
	svc := efs.New(session.New())

	params := &efs.DeleteTagsInput{
		FileSystemId: aws.String("FileSystemId"), // Required
		TagKeys: []*string{ // Required
			aws.String("TagKey"), // Required
			// More values...
		},
	}
	resp, err := svc.DeleteTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DescribeFileSystems() {
	svc := efs.New(session.New())

	params := &efs.DescribeFileSystemsInput{
		CreationToken: aws.String("CreationToken"),
		FileSystemId:  aws.String("FileSystemId"),
		Marker:        aws.String("Marker"),
		MaxItems:      aws.Int64(1),
	}
	resp, err := svc.DescribeFileSystems(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DescribeMountTargetSecurityGroups() {
	svc := efs.New(session.New())

	params := &efs.DescribeMountTargetSecurityGroupsInput{
		MountTargetId: aws.String("MountTargetId"), // Required
	}
	resp, err := svc.DescribeMountTargetSecurityGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DescribeMountTargets() {
	svc := efs.New(session.New())

	params := &efs.DescribeMountTargetsInput{
		FileSystemId:  aws.String("FileSystemId"),
		Marker:        aws.String("Marker"),
		MaxItems:      aws.Int64(1),
		MountTargetId: aws.String("MountTargetId"),
	}
	resp, err := svc.DescribeMountTargets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_DescribeTags() {
	svc := efs.New(session.New())

	params := &efs.DescribeTagsInput{
		FileSystemId: aws.String("FileSystemId"), // Required
		Marker:       aws.String("Marker"),
		MaxItems:     aws.Int64(1),
	}
	resp, err := svc.DescribeTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEFS_ModifyMountTargetSecurityGroups() {
	svc := efs.New(session.New())

	params := &efs.ModifyMountTargetSecurityGroupsInput{
		MountTargetId: aws.String("MountTargetId"), // Required
		SecurityGroups: []*string{
			aws.String("SecurityGroup"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyMountTargetSecurityGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
