/* puzzle-view.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
enum  {
	PUZZLE_VIEW_0_PROPERTY,
	PUZZLE_VIEW_PUZZLE_PROPERTY,
	PUZZLE_VIEW_NUM_PROPERTIES
};
static GParamSpec* puzzle_view_properties[PUZZLE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gboolean piece_unmoved;
	gchar _piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base,
                                cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self,
                              cairo_t* cr,
                              gint x,
                              gint y,
                              gdouble kx,
                              gdouble ky);
static gchar puzzle_view_get_piece_id (PuzzleView* self);
gchar puzzle_get_piece_id (Puzzle* self,
                           gchar* src,
                           int src_length1,
                           gint x,
                           gint y);
gint puzzle_get_piece_nr (Puzzle* self,
                          gint x,
                          gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base,
                                              GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static void puzzle_view_set_piece_id (PuzzleView* self,
                               gchar value);
static gchar* _vala_array_dup7 (gchar* self,
                         int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base,
                                                GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self,
                         gint id);
gboolean puzzle_mapcmp (Puzzle* self,
                        gchar* m1,
                        int m1_length1,
                        gchar* m2,
                        int m2_length1);
static gchar* _vala_array_dup8 (gchar* self,
                         int length);
static gchar* _vala_array_dup9 (gchar* self,
                         int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base,
                                               GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self,
                            gchar id,
                            gint x1,
                            gint y1,
                            gint x2,
                            gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self,
                             Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender,
                                                    gpointer self);
static void puzzle_view_finalize (GObject * obj);
static void _vala_puzzle_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);


PuzzleView*
puzzle_view_construct (GType object_type)
{
	PuzzleView * self = NULL;
	self = (PuzzleView*) g_object_new (object_type, NULL);
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 250);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	puzzle_view_load_image (self);
	return self;
}


PuzzleView*
puzzle_view_new (void)
{
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
}


static void
puzzle_view_load_image (PuzzleView* self)
{
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
	_g_free0 (self->priv->image_filepath);
	self->priv->image_filepath = _tmp0_;
	{
		RsvgHandle* _tmp1_ = NULL;
		const gchar* _tmp2_;
		RsvgHandle* _tmp3_;
		RsvgHandle* _tmp4_;
		_tmp2_ = self->priv->image_filepath;
		_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->tiles_handle);
		self->priv->tiles_handle = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp7_);
		_tmp8_ = stderr;
		_tmp9_ = self->priv->image_filepath;
		fprintf (_tmp8_, "%s %s\n", "image path:", _tmp9_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gboolean
puzzle_view_real_draw (GtkWidget* base,
                       cairo_t* cr)
{
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkStyleContext* _tmp26_;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp27_;
	GdkRGBA _tmp28_ = {0};
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp29_;
	GdkRGBA _tmp30_ = {0};
	GtkStyleContext* _tmp31_;
	GdkRGBA _tmp32_;
	gint width = 0;
	gint height = 0;
	GdkRGBA _tmp33_;
	gdouble kwidth = 0.0;
	Puzzle* _tmp34_;
	Puzzle* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gdouble kheight = 0.0;
	Puzzle* _tmp39_;
	Puzzle* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gdouble _tmp45_;
	gint _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gdouble _tmp51_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = puzzle_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->render_size;
	if (_tmp1_ != _tmp2_) {
		RsvgHandle* _tmp3_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp3_ = self->priv->tiles_handle;
		if (_tmp3_ != NULL) {
			gint height = 0;
			gint _tmp4_;
			gint _tmp5_;
			gint width = 0;
			gint _tmp6_;
			gint _tmp7_;
			cairo_surface_t* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			cairo_surface_t* _tmp11_;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp12_;
			cairo_t* _tmp13_;
			gdouble sfw = 0.0;
			gint _tmp14_;
			gdouble sfh = 0.0;
			gint _tmp15_;
			cairo_t* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			RsvgHandle* _tmp19_;
			cairo_t* _tmp20_;
			_tmp4_ = puzzle_view_get_tile_size (self);
			_tmp5_ = _tmp4_;
			height = _tmp5_ * 2;
			_tmp6_ = puzzle_view_get_tile_size (self);
			_tmp7_ = _tmp6_;
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
			_tmp8_ = cairo_get_target (cr);
			_tmp9_ = width;
			_tmp10_ = height;
			_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_, _tmp10_);
			_cairo_surface_destroy0 (self->priv->surface);
			self->priv->surface = _tmp11_;
			_tmp12_ = self->priv->surface;
			_tmp13_ = cairo_create (_tmp12_);
			c = _tmp13_;
			_tmp14_ = width;
			sfw = ((gdouble) _tmp14_) / 918;
			_tmp15_ = height;
			sfh = ((gdouble) _tmp15_) / 68;
			_tmp16_ = c;
			_tmp17_ = sfw;
			_tmp18_ = sfh;
			cairo_scale (_tmp16_, _tmp17_, _tmp18_);
			_tmp19_ = self->priv->tiles_handle;
			_tmp20_ = c;
			rsvg_handle_render_cairo (_tmp19_, _tmp20_);
			_cairo_destroy0 (c);
		}
		_tmp21_ = puzzle_view_get_tile_size (self);
		_tmp22_ = _tmp21_;
		self->priv->render_size = _tmp22_;
	}
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp24_ = _g_object_ref0 (_tmp23_);
	style = _tmp24_;
	_tmp25_ = style;
	gtk_style_context_save (_tmp25_);
	_tmp26_ = style;
	gtk_style_context_set_state (_tmp26_, GTK_STATE_FLAG_NORMAL);
	_tmp27_ = style;
	gtk_style_context_get_color (_tmp27_, GTK_STATE_FLAG_NORMAL, &_tmp28_);
	fg = _tmp28_;
	_tmp29_ = style;
	gtk_style_context_get_background_color (_tmp29_, GTK_STATE_FLAG_NORMAL, &_tmp30_);
	bg = _tmp30_;
	_tmp31_ = style;
	gtk_style_context_restore (_tmp31_);
	_tmp32_ = bg;
	gdk_cairo_set_source_rgba (cr, &_tmp32_);
	cairo_paint (cr);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp33_ = fg;
	gdk_cairo_set_source_rgba (cr, &_tmp33_);
	cairo_set_line_width (cr, 1.0);
	_tmp34_ = puzzle_view_get_puzzle (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_->width;
	_tmp37_ = puzzle_view_get_tile_size (self);
	_tmp38_ = _tmp37_;
	kwidth = ((_tmp36_ * _tmp38_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
	_tmp39_ = puzzle_view_get_puzzle (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_->height;
	_tmp42_ = puzzle_view_get_tile_size (self);
	_tmp43_ = _tmp42_;
	kheight = ((_tmp41_ * _tmp43_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
	_tmp44_ = width;
	_tmp45_ = kwidth;
	self->priv->kx = (_tmp44_ - _tmp45_) / 2.0;
	_tmp46_ = height;
	_tmp47_ = kheight;
	self->priv->ky = (_tmp46_ - _tmp47_) / 2.0;
	_tmp48_ = self->priv->kx;
	_tmp49_ = self->priv->ky;
	_tmp50_ = kwidth;
	_tmp51_ = kheight;
	cairo_rectangle (cr, _tmp48_, _tmp49_, _tmp50_, _tmp51_);
	cairo_stroke (cr);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp52_ = FALSE;
			_tmp52_ = TRUE;
			while (TRUE) {
				gint _tmp54_;
				Puzzle* _tmp55_;
				Puzzle* _tmp56_;
				gint _tmp57_;
				if (!_tmp52_) {
					gint _tmp53_;
					_tmp53_ = y;
					y = _tmp53_ + 1;
				}
				_tmp52_ = FALSE;
				_tmp54_ = y;
				_tmp55_ = puzzle_view_get_puzzle (self);
				_tmp56_ = _tmp55_;
				_tmp57_ = _tmp56_->height;
				if (!(_tmp54_ < _tmp57_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp58_ = FALSE;
						_tmp58_ = TRUE;
						while (TRUE) {
							gint _tmp60_;
							Puzzle* _tmp61_;
							Puzzle* _tmp62_;
							gint _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							gdouble _tmp66_;
							gdouble _tmp67_;
							gchar _tmp68_;
							gchar _tmp69_;
							Puzzle* _tmp70_;
							Puzzle* _tmp71_;
							Puzzle* _tmp72_;
							Puzzle* _tmp73_;
							gchar* _tmp74_;
							gint _tmp74__length1;
							gint _tmp75_;
							gint _tmp76_;
							if (!_tmp58_) {
								gint _tmp59_;
								_tmp59_ = x;
								x = _tmp59_ + 1;
							}
							_tmp58_ = FALSE;
							_tmp60_ = x;
							_tmp61_ = puzzle_view_get_puzzle (self);
							_tmp62_ = _tmp61_;
							_tmp63_ = _tmp62_->width;
							if (!(_tmp60_ < _tmp63_)) {
								break;
							}
							_tmp64_ = x;
							_tmp65_ = y;
							_tmp66_ = self->priv->kx;
							_tmp67_ = self->priv->ky;
							puzzle_view_draw_square (self, cr, _tmp64_, _tmp65_, _tmp66_, _tmp67_);
							_tmp68_ = puzzle_view_get_piece_id (self);
							_tmp69_ = _tmp68_;
							_tmp70_ = puzzle_view_get_puzzle (self);
							_tmp71_ = _tmp70_;
							_tmp72_ = puzzle_view_get_puzzle (self);
							_tmp73_ = _tmp72_;
							_tmp74_ = _tmp73_->map;
							_tmp74__length1 = _tmp73_->map_length1;
							_tmp75_ = x;
							_tmp76_ = y;
							if (_tmp69_ == puzzle_get_piece_id (_tmp71_, _tmp74_, _tmp74__length1, _tmp75_, _tmp76_)) {
								GdkRGBA _tmp77_ = {0};
								gint _tmp78_;
								gint _tmp79_;
								gint _tmp80_;
								gdouble _tmp81_;
								gint _tmp82_;
								gint _tmp83_;
								gint _tmp84_;
								gdouble _tmp85_;
								gint _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								gint _tmp89_;
								_tmp77_.red = 1.0;
								_tmp77_.green = 1.0;
								_tmp77_.blue = 1.0;
								_tmp77_.alpha = 0.2;
								gdk_cairo_set_source_rgba (cr, &_tmp77_);
								_tmp78_ = x;
								_tmp79_ = puzzle_view_get_tile_size (self);
								_tmp80_ = _tmp79_;
								_tmp81_ = self->priv->kx;
								_tmp82_ = y;
								_tmp83_ = puzzle_view_get_tile_size (self);
								_tmp84_ = _tmp83_;
								_tmp85_ = self->priv->ky;
								_tmp86_ = puzzle_view_get_tile_size (self);
								_tmp87_ = _tmp86_;
								_tmp88_ = puzzle_view_get_tile_size (self);
								_tmp89_ = _tmp88_;
								cairo_rectangle (cr, (_tmp78_ * _tmp80_) + _tmp81_, (_tmp82_ * _tmp84_) + _tmp85_, (gdouble) _tmp87_, (gdouble) _tmp89_);
								cairo_fill (cr);
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (style);
	return result;
}


static void
puzzle_view_draw_square (PuzzleView* self,
                         cairo_t* cr,
                         gint x,
                         gint y,
                         gdouble kx,
                         gdouble ky)
{
	GdkRectangle rect = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkStyleContext* _tmp11_;
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp12_;
	GdkRGBA _tmp13_ = {0};
	GtkStyleContext* _tmp14_;
	GdkRectangle _tmp15_;
	GdkRGBA _tmp16_;
	Puzzle* _tmp17_;
	Puzzle* _tmp18_;
	Puzzle* _tmp19_;
	Puzzle* _tmp20_;
	gchar* _tmp21_;
	gint _tmp21__length1;
	Puzzle* _tmp34_;
	Puzzle* _tmp35_;
	Puzzle* _tmp36_;
	Puzzle* _tmp37_;
	gchar* _tmp38_;
	gint _tmp38__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	memset (&rect, 0, sizeof (GdkRectangle));
	_tmp0_ = puzzle_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	rect.x = (((x * _tmp1_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) kx)) - 1;
	_tmp2_ = puzzle_view_get_tile_size (self);
	_tmp3_ = _tmp2_;
	rect.y = (((y * _tmp3_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) ky)) - 1;
	_tmp4_ = puzzle_view_get_tile_size (self);
	_tmp5_ = _tmp4_;
	rect.width = _tmp5_;
	_tmp6_ = puzzle_view_get_tile_size (self);
	_tmp7_ = _tmp6_;
	rect.height = _tmp7_;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	style = _tmp9_;
	_tmp10_ = style;
	gtk_style_context_save (_tmp10_);
	_tmp11_ = style;
	gtk_style_context_set_state (_tmp11_, GTK_STATE_FLAG_NORMAL);
	_tmp12_ = style;
	gtk_style_context_get_background_color (_tmp12_, GTK_STATE_FLAG_NORMAL, &_tmp13_);
	bg = _tmp13_;
	_tmp14_ = style;
	gtk_style_context_restore (_tmp14_);
	_tmp15_ = rect;
	gdk_cairo_rectangle (cr, &_tmp15_);
	_tmp16_ = bg;
	gdk_cairo_set_source_rgba (cr, &_tmp16_);
	cairo_fill (cr);
	_tmp17_ = puzzle_view_get_puzzle (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = puzzle_view_get_puzzle (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_->map;
	_tmp21__length1 = _tmp20_->map_length1;
	if (puzzle_get_piece_id (_tmp18_, _tmp21_, _tmp21__length1, x, y) != ' ') {
		GdkRectangle _tmp22_;
		cairo_surface_t* _tmp23_;
		GdkRectangle _tmp24_;
		gint _tmp25_;
		Puzzle* _tmp26_;
		Puzzle* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GdkRectangle _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp22_ = rect;
		gdk_cairo_rectangle (cr, &_tmp22_);
		_tmp23_ = self->priv->surface;
		_tmp24_ = rect;
		_tmp25_ = _tmp24_.x;
		_tmp26_ = puzzle_view_get_puzzle (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = puzzle_view_get_tile_size (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = rect;
		_tmp31_ = _tmp30_.y;
		_tmp32_ = puzzle_view_get_tile_size (self);
		_tmp33_ = _tmp32_;
		cairo_set_source_surface (cr, _tmp23_, (gdouble) (_tmp25_ - (puzzle_get_piece_nr (_tmp27_, x, y) * _tmp29_)), (gdouble) (_tmp31_ - (_tmp33_ / 2)));
		cairo_fill (cr);
	}
	_tmp34_ = puzzle_view_get_puzzle (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = puzzle_view_get_puzzle (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_->map;
	_tmp38__length1 = _tmp37_->map_length1;
	if (puzzle_get_piece_id (_tmp35_, _tmp38_, _tmp38__length1, x, y) == '*') {
		gint value = 0;
		Puzzle* _tmp39_;
		Puzzle* _tmp40_;
		Puzzle* _tmp41_;
		Puzzle* _tmp42_;
		gchar* _tmp43_;
		gint _tmp43__length1;
		gint overlay_size = 0;
		gint _tmp44_;
		gint _tmp45_;
		gint overlay_offset = 0;
		gint _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		GdkRectangle _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		GdkRectangle _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		cairo_surface_t* _tmp57_;
		GdkRectangle _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		GdkRectangle _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		value = 22;
		_tmp39_ = puzzle_view_get_puzzle (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = puzzle_view_get_puzzle (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_->orig_map;
		_tmp43__length1 = _tmp42_->orig_map_length1;
		if (puzzle_get_piece_id (_tmp40_, _tmp43_, _tmp43__length1, x, y) == '.') {
			value = 20;
		}
		_tmp44_ = puzzle_view_get_tile_size (self);
		_tmp45_ = _tmp44_;
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp45_) / PUZZLE_VIEW_THEME_TILE_SIZE;
		_tmp46_ = puzzle_view_get_tile_size (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = overlay_size;
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp47_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp48_ / 2);
		_tmp49_ = rect;
		_tmp50_ = _tmp49_.x;
		_tmp51_ = overlay_offset;
		_tmp52_ = rect;
		_tmp53_ = _tmp52_.y;
		_tmp54_ = overlay_offset;
		_tmp55_ = overlay_size;
		_tmp56_ = overlay_size;
		cairo_rectangle (cr, (gdouble) (_tmp50_ + _tmp51_), (gdouble) (_tmp53_ + _tmp54_), (gdouble) _tmp55_, (gdouble) _tmp56_);
		_tmp57_ = self->priv->surface;
		_tmp58_ = rect;
		_tmp59_ = _tmp58_.x;
		_tmp60_ = value;
		_tmp61_ = puzzle_view_get_tile_size (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = rect;
		_tmp64_ = _tmp63_.y;
		_tmp65_ = puzzle_view_get_tile_size (self);
		_tmp66_ = _tmp65_;
		cairo_set_source_surface (cr, _tmp57_, (gdouble) (_tmp59_ - (_tmp60_ * _tmp62_)), (gdouble) (_tmp64_ - (_tmp66_ / 2)));
		cairo_fill (cr);
	}
	_g_object_unref0 (style);
}


static gchar*
_vala_array_dup7 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean
puzzle_view_real_button_press_event (GtkWidget* base,
                                     GdkEventButton* event)
{
	PuzzleView * self;
	gboolean result = FALSE;
	guint _tmp0_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->button;
	if (_tmp0_ == ((guint) GDK_BUTTON_PRIMARY)) {
		Puzzle* _tmp1_;
		Puzzle* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar new_piece_id = '\0';
		Puzzle* _tmp11_;
		Puzzle* _tmp12_;
		Puzzle* _tmp13_;
		Puzzle* _tmp14_;
		gchar* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		gint _tmp17_;
		gboolean _tmp18_ = FALSE;
		gchar _tmp19_;
		gchar _tmp20_;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gchar _tmp26_;
		gchar _tmp33_;
		Puzzle* _tmp34_;
		Puzzle* _tmp35_;
		Puzzle* _tmp36_;
		Puzzle* _tmp37_;
		gchar* _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gint _tmp39__length1;
		_tmp1_ = puzzle_view_get_puzzle (self);
		_tmp2_ = _tmp1_;
		if (puzzle_game_over (_tmp2_)) {
			result = FALSE;
			return result;
		}
		_tmp3_ = event->x;
		_tmp4_ = self->priv->kx;
		_tmp5_ = puzzle_view_get_tile_size (self);
		_tmp6_ = _tmp5_;
		self->priv->piece_x = ((gint) (_tmp3_ - _tmp4_)) / _tmp6_;
		_tmp7_ = event->y;
		_tmp8_ = self->priv->ky;
		_tmp9_ = puzzle_view_get_tile_size (self);
		_tmp10_ = _tmp9_;
		self->priv->piece_y = ((gint) (_tmp7_ - _tmp8_)) / _tmp10_;
		_tmp11_ = puzzle_view_get_puzzle (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = puzzle_view_get_puzzle (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->map;
		_tmp15__length1 = _tmp14_->map_length1;
		_tmp16_ = self->priv->piece_x;
		_tmp17_ = self->priv->piece_y;
		new_piece_id = puzzle_get_piece_id (_tmp12_, _tmp15_, _tmp15__length1, _tmp16_, _tmp17_);
		_tmp19_ = puzzle_view_get_piece_id (self);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != '\0') {
			gboolean _tmp21_;
			_tmp21_ = self->priv->piece_unmoved;
			_tmp18_ = _tmp21_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			puzzle_view_set_piece_id (self, '\0');
			result = FALSE;
			return result;
		}
		_tmp26_ = new_piece_id;
		if (_tmp26_ == ' ') {
			_tmp25_ = TRUE;
		} else {
			gchar _tmp27_;
			_tmp27_ = new_piece_id;
			_tmp25_ = _tmp27_ == '.';
		}
		if (_tmp25_) {
			_tmp24_ = TRUE;
		} else {
			gchar _tmp28_;
			_tmp28_ = new_piece_id;
			_tmp24_ = _tmp28_ == '-';
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			gchar _tmp29_;
			_tmp29_ = new_piece_id;
			_tmp23_ = _tmp29_ == '#';
		}
		if (_tmp23_) {
			_tmp22_ = TRUE;
		} else {
			gchar _tmp30_;
			gchar _tmp31_;
			gchar _tmp32_;
			_tmp30_ = new_piece_id;
			_tmp31_ = puzzle_view_get_piece_id (self);
			_tmp32_ = _tmp31_;
			_tmp22_ = _tmp30_ == _tmp32_;
		}
		if (_tmp22_) {
			result = FALSE;
			return result;
		}
		self->priv->piece_unmoved = TRUE;
		_tmp33_ = new_piece_id;
		puzzle_view_set_piece_id (self, _tmp33_);
		_tmp34_ = puzzle_view_get_puzzle (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = puzzle_view_get_puzzle (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_->map;
		_tmp38__length1 = _tmp37_->map_length1;
		_tmp39_ = (_tmp38_ != NULL) ? _vala_array_dup7 (_tmp38_, _tmp38__length1) : ((gpointer) _tmp38_);
		_tmp39__length1 = _tmp38__length1;
		_tmp35_->move_map = (g_free (_tmp35_->move_map), NULL);
		_tmp35_->move_map = _tmp39_;
		_tmp35_->move_map_length1 = _tmp39__length1;
	}
	result = FALSE;
	return result;
}


static gchar*
_vala_array_dup8 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gchar*
_vala_array_dup9 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean
puzzle_view_real_button_release_event (GtkWidget* base,
                                       GdkEventButton* event)
{
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event->button;
	if (_tmp1_ == ((guint) GDK_BUTTON_PRIMARY)) {
		gchar _tmp2_;
		gchar _tmp3_;
		_tmp2_ = puzzle_view_get_piece_id (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ != '\0';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
		Puzzle* _tmp6_;
		Puzzle* _tmp7_;
		gchar _tmp8_;
		gchar _tmp9_;
		_tmp4_ = self->priv->piece_unmoved;
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
		_tmp6_ = puzzle_view_get_puzzle (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = puzzle_view_get_piece_id (self);
		_tmp9_ = _tmp8_;
		if (puzzle_movable (_tmp7_, (gint) _tmp9_)) {
			Puzzle* _tmp10_;
			Puzzle* _tmp11_;
			Puzzle* _tmp12_;
			Puzzle* _tmp13_;
			gchar* _tmp14_;
			gint _tmp14__length1;
			Puzzle* _tmp15_;
			Puzzle* _tmp16_;
			gchar* _tmp17_;
			gint _tmp17__length1;
			_tmp10_ = puzzle_view_get_puzzle (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = puzzle_view_get_puzzle (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_->move_map;
			_tmp14__length1 = _tmp13_->move_map_length1;
			_tmp15_ = puzzle_view_get_puzzle (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->map;
			_tmp17__length1 = _tmp16_->map_length1;
			_tmp5_ = puzzle_mapcmp (_tmp11_, _tmp14_, _tmp14__length1, _tmp17_, _tmp17__length1);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp18_ = FALSE;
			gchar _tmp19_;
			gboolean _tmp35_ = FALSE;
			Puzzle* _tmp36_;
			Puzzle* _tmp37_;
			gint _tmp38_;
			Puzzle* _tmp52_;
			Puzzle* _tmp53_;
			Puzzle* _tmp54_;
			Puzzle* _tmp55_;
			gchar* _tmp56_;
			gint _tmp56__length1;
			gchar* _tmp57_;
			gint _tmp57__length1;
			Puzzle* _tmp58_;
			Puzzle* _tmp59_;
			_tmp19_ = self->priv->last_piece_id;
			if (_tmp19_ == '\0') {
				_tmp18_ = TRUE;
			} else {
				gchar _tmp20_;
				gchar _tmp21_;
				gchar _tmp22_;
				_tmp20_ = self->priv->last_piece_id;
				_tmp21_ = puzzle_view_get_piece_id (self);
				_tmp22_ = _tmp21_;
				_tmp18_ = _tmp20_ != _tmp22_;
			}
			if (_tmp18_) {
				Puzzle* _tmp23_;
				Puzzle* _tmp24_;
				Puzzle* _tmp25_;
				Puzzle* _tmp26_;
				gchar* _tmp27_;
				gint _tmp27__length1;
				gchar* _tmp28_;
				gint _tmp28__length1;
				Puzzle* _tmp29_;
				Puzzle* _tmp30_;
				gint _tmp31_;
				_tmp23_ = puzzle_view_get_puzzle (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = puzzle_view_get_puzzle (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp26_->lastmove_map;
				_tmp27__length1 = _tmp26_->lastmove_map_length1;
				_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup8 (_tmp27_, _tmp27__length1) : ((gpointer) _tmp27_);
				_tmp28__length1 = _tmp27__length1;
				_tmp24_->undomove_map = (g_free (_tmp24_->undomove_map), NULL);
				_tmp24_->undomove_map = _tmp28_;
				_tmp24_->undomove_map_length1 = _tmp28__length1;
				_tmp29_ = puzzle_view_get_puzzle (self);
				_tmp30_ = _tmp29_;
				_tmp31_ = _tmp30_->moves;
				if (_tmp31_ < 999) {
					Puzzle* _tmp32_;
					Puzzle* _tmp33_;
					gint _tmp34_;
					_tmp32_ = puzzle_view_get_puzzle (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = _tmp33_->moves;
					_tmp33_->moves = _tmp34_ + 1;
				}
			}
			_tmp36_ = puzzle_view_get_puzzle (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _tmp37_->moves;
			if (_tmp38_ > 0) {
				Puzzle* _tmp39_;
				Puzzle* _tmp40_;
				Puzzle* _tmp41_;
				Puzzle* _tmp42_;
				gchar* _tmp43_;
				gint _tmp43__length1;
				Puzzle* _tmp44_;
				Puzzle* _tmp45_;
				gchar* _tmp46_;
				gint _tmp46__length1;
				_tmp39_ = puzzle_view_get_puzzle (self);
				_tmp40_ = _tmp39_;
				_tmp41_ = puzzle_view_get_puzzle (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = _tmp42_->undomove_map;
				_tmp43__length1 = _tmp42_->undomove_map_length1;
				_tmp44_ = puzzle_view_get_puzzle (self);
				_tmp45_ = _tmp44_;
				_tmp46_ = _tmp45_->map;
				_tmp46__length1 = _tmp45_->map_length1;
				_tmp35_ = !puzzle_mapcmp (_tmp40_, _tmp43_, _tmp43__length1, _tmp46_, _tmp46__length1);
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				Puzzle* _tmp47_;
				Puzzle* _tmp48_;
				gint _tmp49_;
				_tmp47_ = puzzle_view_get_puzzle (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp48_->moves;
				_tmp48_->moves = _tmp49_ - 1;
				self->priv->last_piece_id = '\0';
			} else {
				gchar _tmp50_;
				gchar _tmp51_;
				_tmp50_ = puzzle_view_get_piece_id (self);
				_tmp51_ = _tmp50_;
				self->priv->last_piece_id = _tmp51_;
			}
			_tmp52_ = puzzle_view_get_puzzle (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = puzzle_view_get_puzzle (self);
			_tmp55_ = _tmp54_;
			_tmp56_ = _tmp55_->map;
			_tmp56__length1 = _tmp55_->map_length1;
			_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
			_tmp57__length1 = _tmp56__length1;
			_tmp53_->lastmove_map = (g_free (_tmp53_->lastmove_map), NULL);
			_tmp53_->lastmove_map = _tmp57_;
			_tmp53_->lastmove_map_length1 = _tmp57__length1;
			_tmp58_ = puzzle_view_get_puzzle (self);
			_tmp59_ = _tmp58_;
			g_signal_emit_by_name (_tmp59_, "moved");
		}
		puzzle_view_set_piece_id (self, '\0');
	}
	result = FALSE;
	return result;
}


static gboolean
puzzle_view_real_motion_notify_event (GtkWidget* base,
                                      GdkEventMotion* event)
{
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_;
	gchar _tmp1_;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = puzzle_view_get_piece_id (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != '\0') {
		gdouble _tmp2_;
		gdouble _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		Puzzle* _tmp14_;
		Puzzle* _tmp15_;
		gint _tmp16_;
		Puzzle* _tmp23_;
		Puzzle* _tmp24_;
		gchar _tmp25_;
		gchar _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp2_ = event->x;
		_tmp3_ = self->priv->kx;
		_tmp4_ = puzzle_view_get_tile_size (self);
		_tmp5_ = _tmp4_;
		new_piece_x = ((gint) (_tmp2_ - _tmp3_)) / _tmp5_;
		_tmp6_ = event->y;
		_tmp7_ = self->priv->ky;
		_tmp8_ = puzzle_view_get_tile_size (self);
		_tmp9_ = _tmp8_;
		new_piece_y = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
		_tmp13_ = new_piece_x;
		_tmp14_ = puzzle_view_get_puzzle (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_->width;
		if (_tmp13_ >= _tmp16_) {
			_tmp12_ = TRUE;
		} else {
			gdouble _tmp17_;
			_tmp17_ = event->x;
			_tmp12_ = _tmp17_ < ((gdouble) 0);
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gint _tmp18_;
			Puzzle* _tmp19_;
			Puzzle* _tmp20_;
			gint _tmp21_;
			_tmp18_ = new_piece_y;
			_tmp19_ = puzzle_view_get_puzzle (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_->height;
			_tmp11_ = _tmp18_ >= _tmp21_;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gdouble _tmp22_;
			_tmp22_ = event->y;
			_tmp10_ = _tmp22_ < ((gdouble) 0);
		}
		if (_tmp10_) {
			result = FALSE;
			return result;
		}
		_tmp23_ = puzzle_view_get_puzzle (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = puzzle_view_get_piece_id (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->piece_x;
		_tmp28_ = self->priv->piece_y;
		_tmp29_ = new_piece_x;
		_tmp30_ = new_piece_y;
		if (puzzle_move_piece (_tmp24_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_)) {
			gint _tmp31_;
			gint _tmp32_;
			self->priv->piece_unmoved = FALSE;
			_tmp31_ = new_piece_x;
			self->priv->piece_x = _tmp31_;
			_tmp32_ = new_piece_y;
			self->priv->piece_y = _tmp32_;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void
puzzle_view_puzzle_changed_cb (PuzzleView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gchar
puzzle_view_get_piece_id (PuzzleView* self)
{
	gchar result;
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = self->priv->_piece_id;
	result = _tmp0_;
	return result;
}


static void
puzzle_view_set_piece_id (PuzzleView* self,
                          gchar value)
{
	g_return_if_fail (self != NULL);
	self->priv->_piece_id = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


Puzzle*
puzzle_view_get_puzzle (PuzzleView* self)
{
	Puzzle* result;
	Puzzle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_puzzle;
	result = _tmp0_;
	return result;
}


static void
_puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender,
                                               gpointer self)
{
	puzzle_view_puzzle_changed_cb ((PuzzleView*) self);
}


void
puzzle_view_set_puzzle (PuzzleView* self,
                        Puzzle* value)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp2_;
	Puzzle* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_;
		_tmp1_ = self->priv->_puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp2_;
	_tmp3_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
	self->priv->piece_x = 0;
	self->priv->piece_y = 0;
	puzzle_view_set_piece_id (self, '\0');
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY]);
}


static gint
puzzle_view_get_tile_size (PuzzleView* self)
{
	gint result;
	gint s = 0;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gint _tmp2_;
	Puzzle* _tmp3_;
	Puzzle* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = puzzle_view_get_puzzle (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	s = MIN ((gtk_widget_get_allocated_width ((GtkWidget*) self) - PUZZLE_VIEW_SPACE_PADDING) / _tmp2_, (gtk_widget_get_allocated_height ((GtkWidget*) self) - PUZZLE_VIEW_SPACE_PADDING) / _tmp5_);
	_tmp6_ = s;
	if ((_tmp6_ % 2) != 0) {
		gint _tmp7_;
		_tmp7_ = s;
		s = _tmp7_ - 1;
	}
	_tmp8_ = s;
	result = _tmp8_;
	return result;
}


static void
puzzle_view_class_init (PuzzleViewClass * klass)
{
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) puzzle_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) puzzle_view_real_button_press_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) puzzle_view_real_button_release_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget *, GdkEventMotion*)) puzzle_view_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY] = g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
puzzle_view_instance_init (PuzzleView * self)
{
	gchar* _tmp0_;
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
	self->priv->render_size = 0;
	self->priv->piece_x = 0;
	self->priv->piece_y = 0;
	self->priv->piece_unmoved = FALSE;
	self->priv->_piece_id = '\0';
	self->priv->last_piece_id = '\0';
	self->priv->kx = (gdouble) 0;
	self->priv->ky = (gdouble) 0;
	self->priv->tiles_handle = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->image_filepath = _tmp0_;
	self->priv->surface = NULL;
	self->priv->_puzzle = NULL;
}


static void
puzzle_view_finalize (GObject * obj)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	_g_object_unref0 (self->priv->tiles_handle);
	_g_free0 (self->priv->image_filepath);
	_cairo_surface_destroy0 (self->priv->surface);
	_g_object_unref0 (self->priv->_puzzle);
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
}


GType
puzzle_view_get_type (void)
{
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void
_vala_puzzle_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
		g_value_set_object (value, puzzle_view_get_puzzle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_puzzle_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
		puzzle_view_set_puzzle (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



