//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_6.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root6(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[6] = {2.228474543177195e-01,1.188936637351474e+00,2.992747743182503e+00,5.775165601190957e+00,9.837504948755466e+00,
    1.598293495740176e+01};
  constexpr double aw[6] = {2.294832124191948e-01,2.085012107548211e-01,5.668690726397824e-02,5.199618557721616e-03,1.305090990793173e-04,
    4.492756660008302e-07};
  constexpr double x[3162] = {  3.407170545114071e-02,  1.393320830998468e-03,  4.194378854416057e-05,  1.094389417815603e-06,  2.586300455966133e-08,
  5.601498338894908e-10,  1.103686194232192e-11,  1.920394077931276e-13,  2.697159592447926e-15,  1.983645008572856e-17, -4.709078035081051e-19, -2.842870425103341e-20,
  2.906031560639235e-01,  1.022025159210538e-02,  2.214768373282344e-04,  2.783424478251130e-06, -9.658155444057694e-09, -1.497774593366058e-09, -3.736284764229384e-11,
 -2.728366859158720e-13,  1.328386068681561e-14,  5.632197509925072e-16,  8.981656103106990e-18, -7.817455484401733e-20,  7.269791046474797e-01,  1.869819633593263e-02,
  1.473843688891832e-04, -3.732861345925863e-06, -9.294229016783074e-08,  9.075195018412979e-10,  5.929344757002501e-11,  7.319049295016837e-14, -3.611151204756005e-14,
 -4.287447771596095e-16,  1.972628522960075e-17,  5.161050053592608e-19,  1.223394002610361e+00,  1.881858611975847e-02, -1.321605705937928e-04, -3.789271260341545e-06,
  8.485414790269773e-08,  9.547529023034614e-10, -5.395781837623948e-11,  1.674120724542311e-14,  3.216854907248462e-14, -3.557298319718497e-16, -1.700835892722373e-17,
  4.309559752245798e-19,  1.657410237818695e+00,  1.105996488613752e-02, -2.149811183410999e-04,  2.181974086427583e-06,  2.089837261926181e-08, -1.410637604747973e-09,
  2.707063927210311e-11, -2.562641660748371e-14, -1.350813396707180e-14,  3.913379167672515e-16, -3.418859768595781e-18, -1.275054676586693e-19,  1.932119216683707e+00,
  2.528411288626788e-03, -6.832258745654562e-05,  1.563914451696565e-06, -3.130135095310530e-08,  5.396912318783311e-10, -7.401378018149511e-12,  5.426570508484112e-14,
  1.034525160991238e-15, -6.040180619385784e-17,  1.780018050163552e-18, -3.887542272399710e-20,  4.041044664971742e-02,  1.789391313745529e-03,  5.798106108253816e-05,
  1.614223800360804e-06,  4.020288189005595e-08,  8.997654153879886e-10,  1.768506883897352e-11,  2.827549455821946e-13,  2.622728909788959e-15, -4.123433576277868e-17,
 -3.137256152108158e-18, -1.055389805006205e-19,  3.352322125870640e-01,  1.212044200907608e-02,  2.527999481194873e-04,  2.339057690173988e-06, -4.886370285606435e-08,
 -2.417220243043465e-09, -3.558699804235733e-11,  5.310923140652510e-13,  3.791905107995623e-14,  7.077359162875275e-16, -6.013015502885943e-18, -6.528636756891553e-19,
  8.038130963779139e-01,  1.967468887163817e-02,  9.451296357369625e-05, -4.999190286155438e-06, -6.110796637056171e-08,  2.216686029787462e-09,  4.414049615383785e-11,
 -1.142541907485981e-12, -3.345507514093711e-14,  6.281543845680697e-16,  2.708141701798334e-17, -2.914188507651889e-19,  1.296299725148391e+00,  1.760349960082630e-02,
 -1.690785441435509e-04, -2.347143141145962e-06,  9.157432707674155e-08, -2.338268699345543e-10, -4.170648646623450e-11,  7.502722769462138e-13,  1.210923301089799e-14,
 -6.222098705050280e-16,  3.097370420347843e-18,  3.603399036665684e-19,  1.698381711370690e+00,  9.448615992252499e-03, -1.876103000037421e-04,  2.324979238088989e-06,
 -1.076819879103445e-09, -8.065147383775962e-10,  2.218897405710224e-11, -2.655929880952740e-13, -2.606984161011686e-15,  2.078242436221159e-16, -4.562316350324453e-18,
  3.740983196359286e-20,  1.941247544135389e+00,  2.049144903275288e-03, -5.223408490635357e-05,  1.140354449834575e-06, -2.214842417844767e-08,  3.824413298382728e-10,
 -5.664187249280052e-12,  6.349383743568918e-14, -1.932284828284304e-16, -1.519045508882888e-17,  6.491371543977181e-19, -1.572864374101693e-20,  4.863583667384912e-02,
  2.343189164328087e-03,  8.188747662620893e-05,  2.427328016521750e-06,  6.312308081028092e-08,  1.426189335999158e-09,  2.631666791255416e-11,  3.071225127220134e-13,
 -2.631822815674556e-15, -3.045559096888761e-16, -1.138710694580588e-17, -2.927061855867456e-19,  3.879126042755194e-01,  1.423788585274652e-02,  2.744523951203511e-04,
  1.131873470647772e-06, -1.037470417412109e-07, -2.935450934003998e-09, -6.062283623948518e-13,  2.039342335986896e-12,  5.065506834732985e-14, -2.589814433818258e-16,
 -4.429996103104639e-17, -8.883508087275185e-19,  8.836254936304420e-01,  2.017789169625283e-02,  3.027153750619389e-05, -5.577408251127246e-06, -9.284038982798771e-09,
  2.798629371210402e-09,  1.824789001074650e-12, -1.683621031321126e-12,  3.148002689373453e-15,  1.201230722216935e-15, -3.007402269337924e-18, -8.970395491697155e-19,
  1.363864380841915e+00,  1.616244561921591e-02, -1.887627594845675e-04, -9.660725654119960e-07,  7.873351629801782e-08, -9.581129110278729e-10, -1.832716943312135e-11,
  8.269476312367767e-13, -5.363672302359304e-15, -3.052626740885366e-16,  9.699232283400030e-18, -4.699986331069281e-20,  1.733349300200748e+00,  8.057988813146996e-03,
 -1.602596446249216e-04,  2.205021023168193e-06, -1.250780347060699e-08, -3.669002937965687e-10,  1.447964685392257e-11, -2.607638032177680e-13,  2.059747636715564e-15,
  6.470423296360236e-17, -2.616079812504881e-18,  3.706130288129638e-20,  1.948687249874979e+00,  1.680521122221005e-03, -4.044598416722713e-05,  8.403711141977025e-07,
 -1.572019808394935e-08,  2.667801907605460e-10, -4.026258098525923e-12,  5.241524667242605e-14, -4.105915399164790e-16, -5.746434564767053e-20,  1.626732906241511e-19,
 -7.916231236561033e-21,  5.953066430340281e-02,  3.134374222326314e-03,  1.181348960152145e-04,  3.702390995024566e-06,  9.855353157786135e-08,  2.137478541329954e-09,
  3.129208947876948e-11, -7.054224775179819e-14, -2.565290243301189e-14, -1.101167135947443e-15, -3.053777844932590e-17, -5.703153244427337e-19,  4.492958129492166e-01,
  1.645525770647282e-02,  2.761956746204213e-04, -9.760754374125167e-07, -1.571160420843081e-07, -2.104054069633300e-09,  7.498766472657870e-11,  3.110248834793811e-12,
  2.905688827340652e-15, -2.458603628836716e-15, -5.232200444824813e-17,  9.276756945051495e-19,  9.643994908117568e-01,  2.015401548770918e-02, -3.573605482262846e-05,
 -5.291127025633415e-06,  4.352747283874234e-08,  2.325406859143066e-09, -3.799477690011192e-11, -9.861636711245569e-13,  3.562443564163078e-14,  4.099964036263426e-16,
 -3.141379348626477e-17, -2.140998370116136e-19,  1.425448701206629e+00,  1.462581326986991e-02, -1.934865439277375e-04,  1.238854734485097e-07,  5.691410543502237e-08,
 -1.147167473785682e-09,  1.260800472620476e-12,  5.459918490154113e-13, -1.049163217702146e-14, -2.143824956742039e-17,  3.657546073605479e-18, -1.629276841110117e-19,
  1.763179284707999e+00,  6.877903820953757e-03, -1.351875471388001e-04,  1.962746146421304e-06, -1.691688281637725e-08, -9.805738018711518e-11,  8.323247060405619e-12,
 -1.750795607749090e-13,  2.825505709062654e-15, -1.502292732188342e-17, -1.513347950073049e-18,  1.818784584636065e-20,  1.954820524817648e+00,  1.393388933703964e-03,
 -3.171030207804477e-05,  6.267551084111175e-07, -1.123958645456148e-08,  1.863043306763056e-10, -2.737508661488347e-12,  3.989343918822214e-14, -3.679039089650472e-16,
  7.692009107588680e-19, -8.694037406590090e-20, -3.112078951525241e-21,  7.428214890118572e-02,  4.287476768923972e-03,  1.735605788346162e-04,  5.659146830002212e-06,
  1.479836818785869e-07,  2.725727850238479e-09,  9.894754347838969e-12, -1.811116174323549e-12, -9.330738207622126e-14, -2.801290652818052e-15, -5.080883197857616e-17,
 -2.759250237207740e-22,  5.193982194884368e-01,  1.857281680696684e-02,  2.484065294407023e-04, -3.700165438972754e-06, -1.744822549395060e-07,  6.578969580803391e-10,
  1.479034158170779e-10,  1.513607525611991e-12, -1.058321047456823e-13, -2.920694421189908e-15,  4.576405531824558e-17,  3.068288328170205e-18,  1.044062574188346e+00,
  1.962916829577525e-02, -9.369652939185156e-05, -4.279149968259059e-06,  7.937185416834387e-08,  1.215864750170886e-09, -4.917051448308045e-11,  1.480350337394483e-13,
  2.835654929372972e-14, -7.269075764297021e-16, -1.876418086942227e-17,  6.781112558411769e-19,  1.480885182583418e+00,  1.309763806999172e-02, -1.872754145296482e-04,
  8.571219871137852e-07,  3.531521667108450e-08, -9.714102621191238e-10,  1.186151863479431e-11,  2.140545636325094e-13, -1.004909256029251e-14,  1.768466787171196e-17,
 -5.577177405381142e-19, -1.217783878628030e-20,  1.788670454939745e+00,  5.885927771726690e-03, -1.132923079266454e-04,  1.685747228643159e-06, -1.722824136092953e-08,
  5.221370301105799e-11,  4.531759691177195e-12, -1.033317471940368e-13,  1.406009849698247e-15, -5.718060920748545e-17, -4.933925634141859e-19,  3.111498447165772e-20,
  1.959930379429136e+00,  1.166995373796419e-03, -2.515586319891167e-05,  4.735166111735943e-07, -8.086893145533140e-09,  1.326750103231684e-10, -1.786932727954163e-12,
  2.773785480108565e-14, -4.184737815714027e-16, -3.530746201630532e-18, -7.999800807318614e-20,  3.350841071285885e-21,  9.470137507209656e-02,  5.991964133573047e-03,
  2.574529548985265e-04,  8.451267802587138e-06,  1.985777881509484e-07,  1.910991969443033e-09, -1.003184908638462e-10, -6.747760457415702e-12, -2.217421579312803e-13,
 -3.733046337642758e-15,  4.687060513132466e-17,  6.002947637338989e-18,  5.973187237831903e-01,  2.033729474085071e-02,  1.883336316840456e-04, -6.187297469914970e-06,
 -1.247184095606537e-07,  4.255185862173411e-09,  1.310261558720792e-10, -2.958330641351520e-12, -1.491722243545165e-13,  1.108356600246498e-15,  1.313823478231265e-16,
 -1.790499589645219e-19,  1.120787294188470e+00,  1.869723083869337e-02, -1.368243205143624e-04, -2.875874633653201e-06,  9.263736370101743e-08,  1.602278692674555e-10,
 -3.692757440729203e-11,  5.544833749110965e-13, -3.585029862035916e-15, -8.369764513414629e-16,  1.234631176855540e-17,  5.644674990067754e-19,  1.530356219627066e+00,
  1.164881377895422e-02, -1.741867097786050e-04,  1.283597428729088e-06,  1.903345184296946e-08, -6.506911454866540e-10,  1.342497726565420e-11, -1.000981310805583e-13,
 -9.562622936155371e-15,  2.419651490764111e-17,  1.564305629703212e-18,  8.042235298131490e-20,  1.810523137629122e+00,  5.055932251934154e-03, -9.466617163923801e-05,
  1.423441584842887e-06, -1.531276653103302e-08,  1.293730606999209e-10,  1.948388449986906e-12, -9.218664749620816e-14, -6.467709406214888e-16, -4.655707390142190e-17,
  1.041762253474640e-18,  3.335903462119853e-20,  1.964228997279458e+00,  9.864653524491120e-04, -2.016933571735811e-05,  3.632593483848200e-07, -5.807719097321910e-09,
  9.746446989362121e-11, -1.219196125134185e-12,  1.206142723779076e-14, -5.564099752256345e-16, -2.646694548972487e-18,  1.396017958348149e-19,  5.474678829723071e-21,
  1.235093239636699e-01,  8.512934293947234e-03,  3.785559239664980e-04,  1.172345760904362e-05,  1.928471115587038e-07, -3.659878297762348e-09, -4.020717420561885e-10,
 -1.487619142666202e-11, -2.215565490757832e-13,  7.624565014571588e-15,  6.357290761996519e-16,  2.103043048050075e-17,  6.811728258302581e-01,  2.152045150177944e-02,
  1.053763799424112e-04, -7.368158825147639e-06, -1.738357440102928e-08,  5.937373745767776e-09, -5.966602563022277e-12, -6.189082241602440e-12, -3.062635222386854e-14,
  4.728005332614075e-15,  2.300522276653724e-17, -3.611827868993727e-18,  1.193203991220692e+00,  1.748974649751542e-02, -1.624786939630594e-04, -1.411463296806663e-06,
  8.806745616447781e-08, -5.761141024070532e-10, -2.662825071409551e-11,  9.111283233355243e-14, -2.042623496973485e-14, -1.867917647111700e-17,  2.473436865560632e-17,
  6.517401636724906e-20,  1.574268180209204e+00,  1.032122735693764e-02, -1.573331460388883e-04,  1.499969100442429e-06,  8.841430106700731e-09, -3.952968590549287e-10,
  6.594779556803760e-12, -3.732907010400684e-13, -6.733500104300336e-15,  1.551131289479182e-16,  4.954987379548509e-18,  8.338551613494651e-20,  1.829334783820871e+00,
  4.362971569408276e-03, -7.896381781876941e-05,  1.200741537995624e-06, -1.248416717140167e-08,  1.416263429958581e-10, -1.101793827522624e-12, -1.290280724641961e-13,
 -1.254625612361379e-15,  2.082067839921066e-17,  2.283858122394706e-18,  2.927022061040053e-20,  1.967877709688859e+00,  8.411056533484633e-04, -1.630836282815887e-05,
  2.844182935865003e-07, -4.134276601311286e-09,  7.020614495559692e-11, -1.134774602708638e-12, -5.742373402310397e-15, -4.964854770468482e-16,  7.424621655386950e-18,
  3.630827934460042e-19,  5.672071023665348e-21,  1.645704601531260e-01,  1.214684863587453e-02,  5.332264653688433e-04,  1.354842927493039e-05, -1.286424140635766e-08,
 -1.863433916584646e-08, -8.309884251395234e-10, -1.086068574034431e-11,  7.253621649354666e-13,  4.921657642042819e-14,  1.178867717235441e-15, -1.883526877415133e-17,
  7.683854752951422e-01,  2.201374326621375e-02,  1.902174253746554e-05, -6.762988739691233e-06,  8.599068552093736e-08,  3.760627314231312e-09, -1.677011796392316e-10,
 -4.529392680497928e-12,  1.261501584208108e-13,  3.499639971574704e-15, -4.594911401835717e-17,  1.359073697791554e-18,  1.260488425127261e+00,  1.614501885776944e-02,
 -1.714551998301185e-04, -1.296868572252067e-07,  7.000195960297516e-08, -1.252100604802913e-09, -3.193545031656943e-11, -3.764029773550363e-13, -2.473707794161393e-15,
  1.053389216295859e-15,  3.069183455875456e-17,  2.676238880696184e-19,  1.613152406957347e+00,  9.136401447081404e-03, -1.387283693591698e-04,  1.582873404158655e-06,
  1.573316544119072e-09, -3.800606475558840e-10, -5.711866047104552e-12, -4.522343106704651e-13,  3.579957368077104e-15,  4.584640903410530e-16,  1.104743720823618e-17,
  1.786153447093892e-19,  1.845609975740469e+00,  3.785700486334411e-03, -6.566809985888301e-05,  1.020923992665519e-06, -1.022668654940844e-08,  6.868919327770189e-11,
 -5.020751057428556e-12, -1.364210016865983e-13,  1.545688111181478e-15,  1.487687725331224e-16,  4.375084550269403e-18,  5.795190754654780e-20,  1.971001354837541e+00,
  7.232630168296024e-04, -1.325090912239186e-05,  2.279403939419557e-07, -3.023343896843267e-09,  3.960811572177284e-11, -1.454446604288875e-12, -1.394863102895310e-14,
  1.100218396961448e-16,  2.890610038478212e-17,  7.553119946606940e-19,  1.045961087048463e-20,  2.226677039267332e-01,  1.702388086442462e-02,  6.786459958337346e-04,
  9.244808046557268e-06, -5.882072173434047e-07, -3.773255033638719e-08, -5.019760908400807e-10,  4.532542398732272e-11,  2.699013975865870e-12,  2.886507321746006e-14,
 -3.602191882818411e-15, -1.974257948599228e-16,  8.562693604567341e-01,  2.186880274511780e-02, -5.220037165981722e-05, -5.037633978371050e-06,  1.135009655716949e-07,
 -1.221956066330666e-09, -2.205855810983107e-10,  1.347279964938198e-12,  2.413841011001822e-13,  3.454484851321423e-15,  2.021766323574192e-17, -2.319893811982814e-18,
  1.322339371545266e+00,  1.478400245500883e-02, -1.672615594433301e-04,  7.451560927421795e-07,  3.657660780222701e-08, -2.110003881580116e-09, -3.609602811505343e-11,
  4.020620881481854e-13,  5.861282326891996e-14,  2.250991810224632e-15,  1.264646337949291e-17, -2.122988785784138e-18,  1.647598414739727e+00,  8.102334623864041e-03,
 -1.198685284980511e-04,  1.535943847007603e-06, -8.280708188451579e-09, -6.375610863277265e-10, -1.361869754693539e-11,  2.097770168593541e-14,  2.884141117550074e-14,
  9.075597128358159e-16,  3.549884178518701e-18, -9.386201131477377e-19,  1.859775828261224e+00,  3.306634471571050e-03, -5.437778945456911e-05,  8.606180350111941e-07,
 -1.031270665380561e-08, -8.581461297586512e-11, -7.084003792381858e-12,  3.505074529034097e-14,  1.023482348088320e-14,  3.167574742512348e-16,  1.132502429450891e-18,
 -3.508212313821268e-19,  1.973698618005968e+00,  6.274218347520212e-04, -1.078618197210475e-05,  1.838964531001141e-07, -2.604936342223158e-09,  1.597705000961710e-12,
 -1.594530558683751e-12,  1.249308132571566e-14,  1.724835817879701e-15,  5.758487217712922e-17,  1.555323168341067e-19, -6.327572419591066e-20,  3.020207896159735e-01,
  2.267806009499328e-02,  7.076945780185388e-04, -6.251942838510058e-06, -1.310961712928246e-06, -2.522976903350384e-08,  1.841571192713709e-09,  1.051227298150276e-10,
 -6.055152273970095e-13, -2.338453268418821e-13, -5.909827712997387e-15,  2.980306650397872e-16,  9.425654462262604e-01,  2.123667194645115e-02, -1.034181159142007e-04,
 -3.674803571076112e-06,  4.415992636556105e-08, -5.081872745072751e-09, -5.794110190688117e-11,  1.063095694273524e-11,  2.958114941287338e-13, -4.456395952965365e-15,
 -5.778159852138538e-16, -2.200295048696127e-17,  1.378865305482946e+00,  1.348815108934006e-02, -1.563316986177198e-04,  9.542954451449405e-07, -1.196984552984984e-08,
 -2.557651798371469e-09,  1.264457049456809e-11,  3.367080497869104e-12,  1.075812339597319e-13, -1.150534236711722e-15, -2.266957732114632e-16, -7.343884243115192e-18,
  1.678201997519767e+00,  7.213784803699374e-03, -1.027045810816945e-04,  1.286134394168945e-06, -2.359124543272486e-08, -8.248063449593152e-10,  4.287394221661886e-12,
  1.364062357229569e-12,  4.665005817038765e-14, -5.823841479688503e-16, -9.410137192758416e-17, -2.817236882843440e-18,  1.872193526605701e+00,  2.909931129169676e-03,
 -4.512415299641957e-05,  6.737763839177916e-07, -1.341586314456241e-08, -1.972555053394789e-10,  1.062976778723761e-15,  5.066347420753601e-13,  1.617591217584678e-14,
 -2.207376794325552e-16, -3.318910661088487e-17, -9.497062296052796e-19,  1.976048689812068e+00,  5.492409145721142e-04, -8.834532429531877e-06,  1.406485025045723e-07,
 -2.887410662322149e-09, -2.446757414526228e-11, -1.979245980114283e-13,  9.364925537362767e-14,  2.792440700328580e-15, -3.954490914856765e-17, -5.888651238655994e-18,
 -1.639041393494021e-19,  4.030521079091758e-01,  2.766462683822654e-02,  5.003492509833685e-04, -2.800984075899683e-05, -1.182483240182063e-06,  4.362811605933487e-08,
  3.150155082440444e-09, -5.354611752941332e-11, -7.939135474570297e-12,  3.074754246846427e-16,  1.815337351647258e-14,  2.949552265876519e-16,  1.025585005451793e+00,
  2.023730093394141e-02, -1.465602453847510e-04, -3.740233846470161e-06, -4.308182430114509e-08, -2.176788034687420e-09,  3.078831727673681e-10,  1.175503422757161e-11,
 -4.110943251074955e-13, -3.315467005309583e-14, -2.132861572900694e-16,  6.302399016275263e-17,  1.430379765474356e+00,  1.227645106434742e-02, -1.475619725048624e-04,
  4.078883389590119e-07, -5.087218011922934e-08, -8.468095568806718e-10,  1.337587033951817e-10,  3.989314632749915e-12, -1.363231417190209e-13, -1.169616672150697e-14,
 -8.736262955235555e-17,  2.079818281901141e-17,  1.705501034699741e+00,  6.446323447995731e-03, -9.002033190960303e-05,  7.977757571968911e-07, -3.528474972497024e-08,
 -1.447000166602463e-10,  5.408281709128785e-11,  1.649202520318089e-12, -5.555739831541029e-14, -4.749820414591590e-15, -3.006592834179274e-17,  8.254275486025192e-18,
  1.883156958241384e+00,  2.577357818449963e-03, -3.844164248261102e-05,  4.332420671121408e-07, -1.597883473114655e-08,  1.353085290824520e-11,  1.809850882057593e-11,
  5.941835027325710e-13, -1.985391753965991e-14, -1.646623198307682e-15, -9.129487578001260e-18,  2.850405731714981e-18,  1.978113836469775e+00,  4.844965904572298e-04,
 -7.438126230753741e-06,  9.131529262262146e-08, -3.172023636387085e-09,  9.157885012417244e-12,  3.084132248372219e-12,  1.069389044130990e-13, -3.558735431780970e-15,
 -2.883531866528081e-16, -1.485270314857044e-18,  4.996639499733020e-19,  5.192490268996034e-01,  3.008984165878388e-02,  9.027867006648306e-05, -3.681753067832673e-05,
  1.947257835462598e-07,  7.752855029385945e-08, -9.322016003358614e-10, -1.773048316389823e-10,  2.926075705602632e-12,  4.148641838434334e-13, -8.080393256659569e-15,
 -9.825672217937181e-16,  1.103887860323128e+00,  1.887326876058384e-02, -1.955032916049550e-04, -4.304615021613142e-06,  1.879300828514285e-09,  6.677304298005176e-09,
  3.003428629245275e-10, -1.540030212359766e-11, -9.256294721821883e-13,  2.525809110158519e-14,  2.534617794367696e-15, -2.191169439346570e-17,  1.477135940526277e+00,
  1.110167837878196e-02, -1.474730843211940e-04, -3.428269261603522e-07, -3.077384711663895e-08,  2.851336588366876e-09,  1.289779328050204e-10, -5.565526925728101e-12,
 -3.451896057345240e-13,  7.168392898095649e-15,  8.687481194087768e-16, -2.583178300777934e-18,  1.729893441575760e+00,  5.755151257811525e-03, -8.367148912140002e-05,
  2.907363774325967e-07, -2.313049523077039e-08,  1.361193485391461e-09,  5.296602719196051e-11, -2.232227483410778e-12, -1.412694853673240e-13,  2.717522815610605e-15,
  3.406151487585872e-16, -7.454964846286567e-19,  1.892878359264672e+00,  2.286468429750423e-03, -3.468045615520238e-05,  2.070408307303887e-07, -1.060672163186839e-08,
  5.256179280275850e-10,  1.811819608677140e-11, -7.655754472565209e-13, -4.935176436160989e-14,  9.271832433478600e-16,  1.159851459461318e-16, -2.526625542748364e-19,
  1.979938590545146e+00,  4.285556745906581e-04, -6.625818864393725e-06,  4.671931537721650e-08, -2.110848281898687e-09,  9.748659749109030e-11,  3.136326744191212e-12,
 -1.332508513386636e-13, -8.690458171543064e-15,  1.621232416576082e-16,  2.015498365050419e-17, -4.561427518201796e-20,  6.384662125197336e-01,  2.920064323716219e-02,
 -2.894445284073817e-04, -2.386891228364592e-05,  1.219316815834235e-06,  1.616391257989651e-08, -3.131434576423570e-09,  3.851846978195322e-11,  6.381347328605423e-12,
 -2.313836285219880e-13, -1.002936937204162e-14,  7.561106096619049e-16,  1.175941926556978e+00,  1.711490941523658e-02, -2.418126703758097e-04, -3.004748958092849e-06,
  1.609625732920599e-07,  6.761625718340170e-09, -3.051215679158303e-10, -1.767543779093560e-11,  8.757535573191281e-13,  3.859477794273078e-14, -2.395648348689215e-15,
 -8.217781789352176e-17,  1.519151893936837e+00,  9.902157191306145e-03, -1.523024800635115e-04, -2.810896753851036e-07,  3.991159580431821e-08,  3.270735363330917e-09,
 -1.042002782621030e-10, -7.591645925000883e-12,  2.786493569710449e-13,  1.615387046946993e-14, -6.935197622940668e-16, -3.488213055857861e-17,  1.751591644362610e+00,
  5.095824731472675e-03, -8.135702620511750e-05,  1.790567362473112e-07,  9.789648958428539e-09,  1.542862468551730e-09, -4.275746498396170e-11, -3.222498058790335e-12,
  1.060437671883127e-13,  6.741824171028245e-15, -2.525399208473848e-16, -1.422520183236584e-17,  1.901482197493807e+00,  2.016983184522349e-03, -3.281697336147876e-05,
  1.352387330007437e-07,  1.829928039722926e-09,  5.832678239115577e-10, -1.515413130957009e-11, -1.136793062142793e-12,  3.560442906079688e-14,  2.359893744082800e-15,
 -8.308253665250850e-17, -4.892314164578635e-18,  1.981549759124732e+00,  3.773840507220285e-04, -6.194815072585775e-06,  3.091795935786850e-08,  1.678905328914434e-10,
  1.067651382720705e-10, -2.696171805055589e-12, -2.005887855535525e-13,  6.148027661652523e-15,  4.151089236920455e-16, -1.422304387671467e-17, -8.523032132723138e-19,
  7.492945968845035e-01,  2.607218860570434e-02, -4.596209066550467e-04, -5.188389702446481e-06,  9.599812420254617e-07, -3.188448005882321e-08, -6.410402139077270e-10,
  9.193627662795877e-11, -2.172248526595224e-12, -1.138670700996807e-13,  8.861223470610419e-15, -7.995911950028756e-17,  1.240375602423601e+00,  1.508708577774382e-02,
 -2.595446017463443e-04,  1.526109635135430e-07,  2.020315624028439e-07, -2.779358202034477e-09, -3.434339600034612e-10,  1.267996189614760e-11,  5.103994257857187e-13,
 -4.163604194314312e-14, -1.667967961963375e-16,  1.011649917679763e-16,  1.556322758922715e+00,  8.684921593979529e-03, -1.502688509694341e-04,  6.954134768518359e-07,
  6.974319249488891e-08, -4.700390214610965e-10, -1.516132226738395e-10,  3.996751085951182e-12,  2.521412133635501e-13, -1.412477695761699e-14, -2.508487453391424e-16,
  3.626887778203916e-17,  1.770693090320265e+00,  4.458092056162564e-03, -7.749350768420542e-05,  5.050363875975266e-07,  2.569140835554333e-08, -4.695786812579389e-11,
 -6.692075825487157e-11,  1.508021292759831e-12,  1.119514034053865e-13, -5.420995236962462e-15, -1.293314764490801e-16,  1.402867189422861e-17,  1.909036995413272e+00,
  1.762153092424648e-03, -3.071985732443920e-05,  2.302953804307517e-07,  8.172184537397173e-09,  1.521454110159437e-11, -2.427396349601499e-11,  5.046904288381583e-13,
  4.032454199535933e-14, -1.819420529937535e-15, -4.903146099278701e-17,  4.710866549638172e-18,  1.982962768626252e+00,  3.294873101894976e-04, -5.752572297839247e-06,
  4.578922627712474e-08,  1.356346237529014e-09,  5.589695014401445e-12, -4.349290199076843e-12,  8.708650326530966e-14,  7.183582726945052e-15, -3.137938409897559e-16,
 -8.909649470763689e-18,  8.120706276130534e-19,  8.461374896447599e-01,  2.235706776937237e-02, -4.514857950113430e-04,  4.940742179168351e-06,  3.281278683402567e-07,
 -2.591708594661209e-08,  7.483006175690788e-10,  1.017084841583239e-11, -1.853191319847621e-12,  6.891843562460325e-14,  1.684975583276204e-16, -1.347304047809964e-16,
  1.296651997642166e+00,  1.306654778513771e-02, -2.412304427448153e-04,  2.629716309859514e-06,  9.683290146433349e-08, -6.177528471732985e-09,  4.365108075229650e-11,
  9.859614471617151e-12, -4.360391289602877e-13, -3.663903438081394e-15,  1.015021331993239e-15, -3.127088911910163e-17,  1.588735501056587e+00,  7.533355925981111e-03,
 -1.360491841800352e-04,  1.586701166069794e-06,  3.570721136887038e-08, -2.325779137192851e-09, -1.672442697425039e-12,  4.520266039859802e-12, -1.490932072272293e-13,
 -3.716733218503509e-15,  4.183313075478153e-16, -7.266255734420707e-18,  1.787333114600706e+00,  3.868827846596110e-03, -6.922892911016795e-05,  8.405212875245059e-07,
  1.339722983230493e-08, -9.304005637634970e-10, -4.790105367375218e-12,  2.001984751282045e-12, -5.721142139287992e-14, -1.935909609398961e-15,  1.726101592623813e-16,
 -2.013389174976417e-18,  1.915614540458790e+00,  1.529520340690502e-03, -2.724664780602943e-05,  3.384268084199337e-07,  4.273206706419162e-09, -3.167216847722041e-10,
 -2.490623059262016e-12,  7.244780273749281e-13, -1.916609223035279e-14, -7.447065264799414e-16,  5.988350887799410e-17, -5.257457194836163e-19,  1.984192649005450e+00,
  2.860107019711997e-04, -5.084499812835982e-06,  6.386530622664981e-08,  7.080974094377674e-10, -5.483527951116024e-11, -5.099800573559206e-13,  1.295234453315821e-13,
 -3.301140115220240e-15, -1.364493713749596e-16,  1.048000124028171e-17, -7.783538908579145e-20,  9.287996522914417e-01,  1.903862311078627e-02, -3.746050066526903e-04,
  7.024218086089965e-06, -1.296403921944302e-08, -9.104755688389130e-09,  5.402367658166805e-10, -1.529422896761309e-11, -2.755392193432677e-14,  2.472926631448240e-14,
 -1.218917550481201e-15,  2.464319172245029e-17,  1.345284062760286e+00,  1.128060139029392e-02, -2.040814170024319e-04,  3.313681408875822e-06, -1.754660589829505e-09,
 -3.306595130725214e-09,  1.438436551722941e-10, -1.203900559938542e-12, -1.794223321380808e-13,  9.938201496810157e-15, -1.449367965980565e-16, -1.008890454054548e-17,
  1.616821970662440e+00,  6.527458904576694e-03, -1.150301940982756e-04,  1.816434123473707e-06, -3.914226551055536e-09, -1.415191596335820e-09,  5.606420928160790e-11,
 -3.257839172479382e-14, -9.089745687763743e-14,  3.898437452290947e-15, -1.471043868674560e-17, -5.818262728210258e-18,  1.801767967158317e+00,  3.357608621174024e-03,
 -5.844867685652596e-05,  9.146933057368374e-07, -3.010899563165808e-09, -6.033512976079782e-10,  2.296250877753823e-11,  8.465548207574040e-14, -4.172357397995049e-14,
  1.588650395000836e-15,  2.936435718133033e-18, -2.717157835557255e-18,  1.921323410476456e+00,  1.328479969184767e-03, -2.297940631101018e-05,  3.583539167587410e-07,
 -1.425689809182677e-09, -2.127781702598441e-10,  7.947942683630290e-12,  4.900169267833649e-14, -1.534083367077689e-14,  5.483255831613709e-16,  2.728129832416457e-18,
 -9.999032739570864e-19,  1.985260356439371e+00,  2.485102980956828e-04, -4.285706478903923e-06,  6.674214920325743e-08, -2.887626774456781e-10, -3.749263613351109e-11,
  1.389229644637666e-12,  1.031289594461567e-14, -2.761527457887449e-15,  9.574617648172191e-17,  6.237270068958409e-19, -1.797458017723105e-19,  9.994759889292183e-01,
  1.636545452192077e-02, -2.956711015535592e-04,  5.924782455932778e-06, -9.815886149999235e-08, -8.354343214053268e-10,  1.794783670173817e-10, -9.093447749458162e-12,
  2.588611001437241e-13, -2.012253121877898e-15, -2.189247808467430e-16,  1.365244801162311e-17,  1.387387129981061e+00,  9.802631001245680e-03, -1.661116228330580e-04,
  2.924722782379318e-06, -3.823275268848061e-08, -6.294669373121834e-10,  7.289982793231989e-11, -2.742308259387603e-12,  3.443440204932052e-14,  2.095662428164142e-15,
 -1.472807413551828e-16,  4.183341481635530e-18,  1.641225607288827e+00,  5.691645291706631e-03, -9.431763958414174e-05,  1.595808566530415e-06, -2.002837315336122e-08,
 -2.922256514772611e-10,  3.282433217007464e-11, -1.110033180141199e-12,  6.546317006144249e-15,  1.236318210831068e-15, -6.629211284079298e-17,  1.364105593407876e-18,
  1.814330613680823e+00,  2.932378218049486e-03, -4.806552869348909e-05,  7.986668101489404e-07, -9.941483061381865e-09, -1.252381295726914e-10,  1.446037106285086e-11,
 -4.637020316458019e-13,  1.038637711724468e-15,  6.006972338184068e-16, -2.881229648028545e-17,  4.820975060778437e-19,  1.926296004630275e+00,  1.161200890871141e-03,
 -1.892351559554704e-05,  3.115587078568787e-07, -3.874433111897237e-09, -4.363112402273622e-11,  5.209646374521433e-12, -1.623731174778868e-13,  2.304221861134786e-17,
  2.269013450318887e-16, -1.028494223951714e-17,  1.506751422136833e-19,  1.986190727427060e+00,  2.173044046449790e-04, -3.531475338771994e-06,  5.789328071311950e-08,
 -7.202332496166471e-10, -7.603178435030837e-12,  9.286759517690418e-13, -2.855243253171374e-14, -2.598921489885268e-17,  4.134685423641905e-17, -1.824855016616502e-18,
  2.488899654945812e-20,  1.060619453416963e+00,  1.425766107730530e-02, -2.339889365589236e-04,  4.383621345921331e-06, -8.800712678036027e-08,  1.248416352620219e-09,
  2.312056087045591e-11, -2.798381708439773e-12,  1.271840651037609e-13, -3.606891545945132e-15,  4.936030936196313e-17,  1.205776480095072e-18,  1.424146837330514e+00,
  8.603267774172012e-03, -1.348574813597442e-04,  2.284040350786766e-06, -3.872694409143046e-08,  3.607459759482826e-10,  1.673208140286902e-11, -1.239187459376944e-12,
  4.332885411629149e-14, -7.157902203171972e-16, -1.460146084668799e-17,  1.507616655243054e-18,  1.662596401127376e+00,  5.008039784999674e-03, -7.717189573863472e-05,
  1.261631088547588e-06, -2.027251485914278e-08,  1.721505589471780e-10,  8.434167292590527e-12, -5.771711322451793e-13,  1.830726523880731e-14, -2.090998790176253e-16,
 -1.126420915024534e-17,  7.711284235641468e-19,  1.825347836981633e+00,  2.583397091439339e-03, -3.946896683168772e-05,  6.342614346552064e-07, -9.948443660905419e-09,
  8.296166089069099e-11,  3.882426814288311e-12, -2.591162026138156e-13,  7.817014047716115e-15, -6.738818254122898e-17, -5.951293490172446e-18,  3.557226240118744e-19,
  1.930660181737513e+00,  1.023684145480647e-03, -1.556760733985712e-05,  2.479076848365091e-07, -3.841649510567479e-09,  3.202121161149036e-11,  1.426668691837218e-12,
 -9.440244677946552e-14,  2.770918227912762e-15, -1.946068454556978e-17, -2.335493058246734e-18,  1.310056500341075e-19,  1.987007557836062e+00,  1.916305779538016e-04,
 -2.907711086281601e-06,  4.610370357945055e-08, -7.104456661894184e-10,  5.934871797895797e-12,  2.564737144112489e-13, -1.692535632313266e-14,  4.902172912519974e-16,
 -3.052256544084399e-18, -4.329207413909695e-19,  2.359263140869091e-20,  1.114208256789600e+00,  1.257421538709433e-02, -1.889684829743670e-04,  3.185645313875536e-06,
 -6.191487046865231e-08,  1.217868618901228e-09, -1.479379639625591e-11, -3.868134918127890e-13,  3.625039697784893e-14, -1.515014076761571e-15,  4.224819229897293e-17,
 -7.141180590850988e-19,  1.456561747043202e+00,  7.624149975139823e-03, -1.108841696135020e-04,  1.734644805249962e-06, -2.960467082856665e-08,  4.772409378696967e-10,
 -2.678219797256930e-12, -2.873400576371123e-13,  1.724776310196997e-14, -5.740394063397502e-16,  1.104791242403993e-17,  2.052710102844855e-20,  1.681482316311181e+00,
  4.446019095297107e-03, -6.384162051231776e-05,  9.714006017419038e-07, -1.580872362711496e-08,  2.380861624410120e-10, -9.796832711568090e-13, -1.498492784362580e-13,
  8.260220047760797e-15, -2.527778440620139e-16,  3.923063385205572e-18,  6.031120494462875e-20,  1.835094500601047e+00,  2.295532606134396e-03, -3.274732760706167e-05,
  4.914248623116526e-07, -7.812488117372542e-09,  1.140750019401543e-10, -4.231705915771660e-13, -7.061641704760228e-14,  3.763356062187569e-15, -1.102758736954760e-16,
  1.486923771107230e-18,  3.811780123409736e-20,  1.934523277169448e+00,  9.100549132890372e-04, -1.293640215642417e-05,  1.926938733928473e-07, -3.025488616595037e-09,
  4.349881294206809e-11, -1.570065405769564e-13, -2.635092212005359e-14,  1.382541760557108e-15, -3.955826272300239e-17,  4.877176925036583e-19,  1.603388703448040e-20,
  1.987730801641808e+00,  1.703991420654330e-04, -2.418037114785379e-06,  3.588922216214748e-08, -5.601499672256522e-10,  7.996374959377009e-12, -2.873620183807655e-14,
 -4.776634634028814e-15,  2.489063528672455e-16, -7.039629975623270e-18,  8.275513917655191e-20,  3.060151022565428e-21,  1.161702225925919e+00,  1.120025285184984e-02,
 -1.559488472063568e-04,  2.368708278917083e-06, -4.148406867520158e-08,  8.237019682717493e-10, -1.560547786024743e-11,  1.673516013773923e-13,  4.939948324208868e-15,
 -4.018041950418141e-16,  1.569353817957460e-17, -4.267247702074454e-19,  1.485405580825750e+00,  6.812980031810780e-03, -9.261206150207233e-05,  1.332007673463459e-06,
 -2.110215110837042e-08,  3.626553448222730e-10, -5.518125279767932e-12,  1.460020788102664e-14,  3.847636259803680e-15, -2.031711959054926e-16,  6.487895065014348e-18,
 -1.350656638910489e-19,  1.698313142893027e+00,  3.977961738210747e-03, -5.355226893726688e-05,  7.542915422455599e-07, -1.149917182231940e-08,  1.868179803085866e-10,
 -2.617191729942853e-12,  3.938034631076452e-16,  2.056358942574564e-15, -9.966472068509992e-17,  2.961566006557495e-18, -5.362668055658387e-20,  1.843787243106670e+00,
  2.055184697742879e-03, -2.752806724883646e-05,  3.836552274637991e-07, -5.736302742752866e-09,  9.058457225180013e-11, -1.220513146022166e-12, -9.269526162645317e-16,
  9.832671860352117e-16, -4.597885733434898e-17,  1.316682352609357e-18, -2.190752498547918e-20,  1.937970081683824e+00,  8.150539229168943e-04, -1.088697926713604e-05,
  1.508648495159487e-07, -2.232148599653271e-09,  3.471404054580034e-11, -4.585717961145234e-13, -5.086967236392895e-16,  3.701532218456178e-16, -1.700903174019234e-17,
  4.773116973194188e-19, -7.546414025029762e-21,  1.988376237609306e+00,  1.526369084211780e-04, -2.036075917187286e-06,  2.813674832155962e-08, -4.141985883952052e-10,
  6.394267865388112e-12, -8.369911439346174e-14, -1.034591324890621e-16,  6.740386410734196e-17, -3.072728472514129e-18,  8.538038368141471e-20, -1.314891254631968e-21,
  1.204173642514174e+00,  1.005620495485240e-02, -1.310242658862415e-04,  1.818185439479480e-06, -2.832700556400702e-08,  5.134357413989090e-10, -1.019949183013048e-11,
  1.845632085324447e-13, -1.832190456499015e-15, -5.151012122209938e-17,  3.885901587806084e-18, -1.436263367591846e-19,  1.511269506953024e+00,  6.130786063428667e-03,
 -7.843690710418690e-05,  1.045520659705928e-06, -1.509140364143846e-08,  2.438035500998206e-10, -4.189993753017749e-12,  6.027733571308077e-14, -5.321565309608842e-17,
 -4.278284338793861e-17,  2.071667639216684e-18, -6.369418007247307e-20,  1.713421410993090e+00,  3.582884033048288e-03, -4.549219192701275e-05,  5.968850647473819e-07,
 -8.363064877236355e-09,  1.289651703243486e-10, -2.086947928140876e-12,  2.727780454892043e-14,  7.247270719964706e-17, -2.337298603953649e-17,  1.037821512832346e-18,
 -2.996089868477677e-20,  1.851594656572511e+00,  1.851942842528357e-03, -2.342016558087417e-05,  3.048151214275561e-07, -4.206577620345130e-09,  6.332401419990096e-11,
 -9.930976500133847e-13,  1.237528777513085e-14,  5.235986087690965e-17, -1.130868249832151e-17,  4.840386090792039e-19, -1.353397860558597e-20,  1.941066779025588e+00,
  7.346413896480788e-04, -9.269881788860961e-06,  1.201198976583270e-07, -1.644134678097876e-09,  2.442564314816561e-11, -3.765402564552464e-13,  4.576628797797026e-15,
  2.270586934241927e-17, -4.286012698357122e-18,  1.801433713766678e-19, -4.949809373243432e-21,  1.988956199300468e+00,  1.375952221931113e-04, -1.734325897797719e-06,
  2.242581003207167e-08, -3.057330979681002e-10,  4.512971643581752e-12, -6.899241484536489e-14,  8.287982973905430e-16,  4.370519770839403e-18, -7.831199397310411e-19,
  3.263962340885662e-20, -8.892656807922427e-22,  1.242430308680444e+00,  9.088280984886971e-03, -1.116251648868520e-04,  1.435427289628906e-06, -2.012601796102861e-08,
  3.231407727125412e-10, -5.975452245747711e-12,  1.166073696554196e-13, -2.012383702126917e-15,  1.937388633159448e-17,  4.499260585246549e-19, -3.320319285311909e-20,
  1.534611772430702e+00,  5.549708806365336e-03, -6.719469277316850e-05,  8.381598399228402e-07, -1.108955321930360e-08,  1.623369219016192e-10, -2.670192317570078e-12,
  4.547335485763780e-14, -6.240242013271360e-16,  2.593398599036321e-19,  4.073647959070887e-19, -1.857949939866410e-20,  1.727067461639599e+00,  3.245501854704814e-03,
 -3.905541964307770e-05,  4.812458799380268e-07, -6.223845297233660e-09,  8.775946103776875e-11, -1.372762149842645e-12,  2.201897074698512e-14, -2.720497299717646e-16,
 -1.048323200976502e-18,  2.275224875295543e-19, -9.485142102192281e-21,  1.858649372933797e+00,  1.678156879026948e-03, -2.012829471929728e-05,  2.464642317819502e-07,
 -3.150586981126395e-09,  4.356936984742206e-11, -6.634666292717176e-13,  1.030483061924641e-14, -1.204633964592819e-16, -7.259777946154237e-19,  1.113040502354408e-19,
 -4.467344044140375e-21,  1.943865569435573e+00,  6.658350399730619e-04, -7.971630066403955e-06,  9.727447139456754e-08, -1.235641409269472e-09,  1.690644544812363e-11,
 -2.536232648093326e-13,  3.869140430646545e-15, -4.389535188708920e-17, -3.138513654863794e-19,  4.244102544164865e-20, -1.671566828387223e-21,  1.989480426290688e+00,
  1.247202091041990e-04, -1.491857749526890e-06,  1.817410568685027e-08, -2.301536099016739e-10,  3.132730827066674e-12, -4.665147197542526e-14,  7.054431997172601e-16,
 -7.889110277595987e-18, -6.049875045005524e-20,  7.777752983893876e-21, -3.036630269924092e-22,  1.277099383992543e+00,  8.259151459504102e-03, -9.614136490054706e-05,
  1.158309737033871e-06, -1.486744846432138e-08,  2.123464901773240e-10, -3.494906949726509e-12,  6.478345681567008e-14, -1.226357667089629e-15,  2.023197317386207e-17,
 -1.953450755158253e-19, -3.296021768537596e-21,  1.555795233585955e+00,  5.049592695673815e-03, -5.810442123593163e-05,  6.836122256949297e-07, -8.391848785213837e-09,
  1.113637541214386e-10, -1.659998990715349e-12,  2.758528933915436e-14, -4.616976197658883e-16,  6.115681794150949e-18, -6.074391853148609e-21, -3.375406499165096e-21,
  1.739458929477567e+00,  2.954588146997308e-03, -3.382530537270579e-05,  3.941077433957330e-07, -4.753237811803194e-09,  6.123912890090147e-11, -8.750434428617990e-13,
  1.383775022370149e-14, -2.188412080011962e-16,  2.602601885290830e-18,  9.068872869085629e-21, -1.931681830425576e-21,  1.865057549978693e+00,  1.528164904180692e-03,
 -1.744697799217185e-05,  2.022509720081779e-07, -2.417327823113055e-09,  3.067170775583595e-11, -4.284939134967720e-13,  6.593237582883625e-15, -1.010567773171781e-16,
  1.132212729157171e-18,  6.767353779739971e-21, -9.558027511143549e-22,  1.946408313270734e+00,  6.064187997997071e-04, -6.912777371577620e-06,  7.991245115898638e-08,
 -9.504385035373136e-10,  1.195911708482620e-11, -1.649876382771450e-13,  2.499511711362291e-15, -3.763673661468515e-17,  4.078271202196153e-19,  3.000548659761889e-21,
 -3.666715648850667e-22,  1.989956736074416e+00,  1.135995001390298e-04, -1.293975588887619e-06,  1.493824484954699e-08, -1.772453140840479e-10,  2.221195146807520e-12,
 -3.045507357188390e-14,  4.578368475906009e-16, -6.833537362829737e-18,  7.284806417514261e-20,  5.845776951664385e-22, -6.739336597187525e-23,  1.308680442057474e+00,
  7.541871385632649e-03, -8.354202614756588e-05,  9.503936531767125e-07, -1.133263947138689e-08,  1.464166396535034e-10, -2.132465272519561e-12,  3.556153137724568e-14,
 -6.505290273767835e-16,  1.185938970994280e-17, -1.877352878807646e-19,  1.852863131030401e-21,  1.575112872600460e+00,  4.615444529824261e-03, -5.063955295793374e-05,
  5.652313276460205e-07, -6.508198615626774e-09,  7.931940324840542e-11, -1.062873852508509e-12,  1.609428585016747e-14, -2.674027056343139e-16,  4.372166257312673e-18,
 -5.651359659638397e-20,  1.254852813788288e-22,  1.750764318242669e+00,  2.701696265181963e-03, -2.951527354528983e-05,  3.268317482868220e-07, -3.710805169260141e-09,
  4.418219898174845e-11, -5.717450714390490e-13,  8.289276382388260e-15, -1.315673160369461e-16,  2.042509564418977e-18, -2.378789887634013e-20, -4.726291094765329e-23,
  1.870905558010911e+00,  1.397682891144571e-03, -1.523343968834183e-05,  1.679791250500373e-07, -1.893505826016197e-09,  2.227573016475857e-11, -2.830086150531126e-13,
  4.006212954304297e-15, -6.195560667673175e-17,  9.340703040847404e-19, -1.024702555252524e-20, -4.569947537810224e-23,  1.948729114748141e+00,  5.547107480996079e-04,
 -6.037814435382714e-06,  6.642527370638200e-08, -7.458290610382330e-10,  8.716947762480456e-12, -1.096260897645218e-13,  1.530949693559528e-15, -2.332272301457098e-17,
  3.457519006328128e-19, -3.665022798098576e-21, -2.158190996046939e-23,  1.990391501860581e+00,  1.039196586002710e-04, -1.130383946042150e-06,  1.242194337789167e-08,
 -1.392094553588860e-10,  1.621870210116240e-12, -2.029567218725773e-14,  2.815325330846858e-16, -4.256679067931673e-18,  6.257503312749819e-20, -6.520864716466454e-22,
 -4.303138003594341e-24,  1.337579405890642e+00,  6.916277605897346e-03, -7.313677504100078e-05,  7.900181500322065e-07, -8.846103363804881e-09,  1.051806122993616e-10,
 -1.373368102352574e-12,  2.029242150059630e-14, -3.383067018726568e-16,  6.036714678222285e-18, -1.056163892283565e-19,  1.610391199959869e-21,  1.592805024768605e+00,
  4.235801236730576e-03, -4.443332233580848e-05,  4.725428017510685e-07, -5.144833596177281e-09,  5.838157248658504e-11, -7.113426103028089e-13,  9.644559128492135e-15,
 -1.473329035983679e-16,  2.422778945047003e-18, -3.855173048809759e-20,  4.902745241957012e-22,  1.761122356069458e+00,  2.480315334697893e-03, -2.592258787631081e-05,
  2.738536225518365e-07, -2.947774066514282e-09,  3.283121566289802e-11, -3.888214373847817e-13,  5.076660996414591e-15, -7.440855114606513e-17,  1.175320936785131e-18,
 -1.785510897366575e-20,  2.063178078249993e-22,  1.876264635680946e+00,  1.283394973793110e-03, -1.338586487465521e-05,  1.409125839672385e-07, -1.507863529249610e-09,
  1.663381261497891e-11, -1.940995858071929e-13,  2.483076219869601e-15, -3.555025370897182e-17,  5.485214924660355e-19, -8.113946067509230e-21,  8.862727991796190e-23,
  1.950856131012305e+00,  5.094061679356375e-04, -5.306984144171371e-06,  5.575696253704987e-08, -5.947189544999829e-10,  6.526463382030985e-12, -7.554050402243627e-14,
  9.553580838315297e-16, -1.349359905092229e-17,  2.053493959177350e-19, -2.990910029210260e-21,  3.161326563482685e-23,  1.990789988011731e+00,  9.543728090877289e-05,
 -9.936933166577122e-07,  1.043005389693759e-08, -1.110758789790372e-10,  1.215875508473984e-12, -1.401749775001027e-14,  1.762782648552487e-16, -2.472892674810999e-18,
  3.737141650009125e-20, -5.400877118254431e-22,  5.615132538474405e-24,  1.364131169587212e+00,  6.366847253855017e-03, -6.444168511821154e-05,  6.636920080646589e-07,
 -7.031642270200632e-09,  7.798954202609876e-11, -9.291501472206297e-13,  1.225302233496060e-14, -1.820710800628429e-16,  2.997993442302209e-18, -5.178256424566993e-20,
  8.683413287936673e-22,  1.609071344113533e+00,  3.901700451486005e-03, -3.922095575578438e-05,  3.987220920098401e-07, -4.128497384748001e-09,  4.408812008670219e-11,
 -4.960768004320466e-13,  6.067630291187302e-15, -8.304745294276129e-17,  1.268551095120686e-18, -2.047466133483408e-20,  3.163689050018205e-22,  1.770648598847592e+00,
  2.285324642260414e-03, -2.289918309279750e-05,  2.314791536662658e-07, -2.374194229046047e-09,  2.497079689195647e-11, -2.745314556150868e-13,  3.251941746215677e-15,
 -4.285837110996482e-17,  6.308070086675720e-19, -9.837642888864832e-21,  1.459433724230246e-22,  1.881194203470435e+00,  1.182685467645514e-03, -1.182945083544412e-05,
  1.192166109602807e-07, -1.216734047336840e-09,  1.269738053703390e-11, -1.379342185213872e-13,  1.606288482963272e-15, -2.072890194995096e-17,  2.985564331396097e-19,
 -4.561949665194556e-21,  6.609041889542335e-23,  1.952812865418821e+00,  4.694741875429773e-04, -4.690982317476080e-06,  4.719548566771421e-08, -4.803786267706745e-10,
  4.991771381721570e-12, -5.387314840712202e-14,  6.214588399504829e-16, -7.923918354745965e-18,  1.126810317863965e-19, -1.700943532251750e-21,  2.430129119073650e-23,
  1.991156590369719e+00,  8.795990142733766e-05, -8.784484563046704e-07,  8.830632942223828e-09, -8.976421152158016e-11,  9.308491512246122e-13, -1.001422900237092e-14,
  1.149847877488157e-16, -1.457347249337293e-18,  2.059046312526018e-20, -3.088925437308610e-22,  4.382153735517816e-24,  1.388615379111483e+00,  5.881369590007760e-03,
 -5.710457757045571e-05,  5.625584008780214e-07, -5.670083602119268e-09,  5.923568335681361e-11, -6.538742918482670e-13,  7.818754667492295e-15, -1.036844104375712e-16,
  1.534339839823304e-18, -2.471676258492151e-20,  4.112489082597891e-22,  1.624079411547413e+00,  3.606011592306530e-03, -3.480547776764430e-05,  3.391261998919588e-07,
 -3.353423539324157e-09,  3.395786187527107e-11, -3.575079273113430e-13,  4.006794584490225e-15, -4.924224953020238e-17,  6.767708901261956e-19, -1.024592926608100e-20,
  1.612851381559730e-22,  1.779440238498854e+00,  2.112632169078625e-03, -2.033395637514505e-05,  1.971577991370904e-07, -1.934011293222904e-09,  1.933827185514399e-11,
 -1.997391999964354e-13,  2.179062414421822e-15, -2.589128674712865e-17,  3.434137317098877e-19, -5.036209514345685e-21,  7.703378120181902e-23,  1.885744291424251e+00,
  1.093459508916453e-03, -1.050782154438621e-05,  1.016146400598004e-07, -9.925969898470612e-10,  9.860518277839511e-12, -1.008499977110701e-13,  1.084804433347810e-15,
 -1.265483123141588e-17,  1.644642518013616e-19, -2.366303029541732e-21,  3.557141820859207e-23,  1.954619118305509e+00,  4.340882078406263e-04, -4.167670808075501e-06,
  4.024330504133983e-08, -3.921970172914890e-10,  3.882299641437480e-12, -3.949495321640812e-14,  4.215430659110966e-16, -4.866852461074148e-18,  6.250477421545440e-20,
 -8.890998153777258e-22,  1.322613980141936e-23,  1.991495013223525e+00,  8.133310342044047e-05, -7.805233846302197e-07,  7.531290717215867e-09, -7.331446888672147e-11,
  7.244810672567274e-13, -7.351116966738952e-15,  7.816396949611413e-17, -8.978162847157404e-19,  1.146195064989779e-20, -1.620900453676548e-22,  2.398289977768279e-24,
  1.411267873507333e+00,  5.450078352795744e-03, -5.086168275275722e-05,  4.805304027236945e-07, -4.626310198516637e-09,  4.583987829858662e-11, -4.742759487382714e-13,
  5.224281941954395e-15, -6.261727365717483e-17,  8.296558310132040e-19, -1.211770393848362e-20,  1.896304256991414e-22,  1.637971120601643e+00,  3.342982460990320e-03,
 -3.103689286245314e-05,  2.904736950378231e-07, -2.751814796361139e-09,  2.656588793263358e-11, -2.642081688307198e-13,  2.753817001231652e-15, -3.081787712678292e-17,
  3.798396339733508e-19, -5.206884220197517e-21,  7.752015066261642e-23,  1.787579701945829e+00,  1.958925839967022e-03, -1.814175538761781e-05,  1.690664761567022e-07,
 -1.590681112485190e-09,  1.519325456336678e-11, -1.487092104561678e-13,  1.515249587202085e-15, -1.646421572143210e-17,  1.962524184682582e-19, -2.606179798728034e-21,
  3.779059832448004e-23,  1.889957364613615e+00,  1.014018634643453e-03, -9.377626845924678e-06,  8.718883101671111e-08, -8.173457213373800e-10,  7.763738913527094e-12,
 -7.536918352922124e-14,  7.589897559798386e-16, -8.118164925970380e-18,  9.497716697504322e-20, -1.237888974250422e-21,  1.766119562094330e-23,  1.956291703672972e+00,
  4.025774276471113e-04, -3.719996313529284e-06,  3.454154018351913e-08, -3.231566931265597e-10,  3.060319969158993e-12, -2.957686970238156e-14,  2.959392638014264e-16,
 -3.137755288940669e-18,  3.631891753149029e-20, -4.681454823041603e-22,  6.613580092909179e-24,  1.991808402866041e+00,  7.543151916769110e-05, -6.967370762138774e-07,
  6.465280522744485e-09, -6.042714807821538e-11,  5.714120111835258e-13, -5.510568569296376e-15,  5.496543875674210e-17, -5.802794301064330e-19,  6.680839229276392e-21,
 -8.563066051125227e-23,  1.203574752795678e-24,  1.432289230886313e+00,  5.065057883790843e-03, -4.551106592279694e-05,  4.132713492853364e-07, -3.812554273331294e-09,
  3.601080481928734e-11, -3.521421343582716e-13,  3.618938225781169e-15, -3.979723073476714e-17,  4.764521830916499e-19, -6.263508243384357e-21,  8.961163893496914e-23,
  1.650867530031775e+00,  3.107919826141968e-03, -2.779889813882066e-05,  2.503750332617482e-07, -2.278188399973745e-09,  2.105008325716584e-11, -1.991043614084267e-13,
  1.952023890962406e-15, -2.020202365841794e-17,  2.258266276150414e-19, -2.780777882480732e-21,  3.775339680339700e-23,  1.795137404392855e+00,  1.821496223878558e-03,
 -1.625622665467009e-05,  1.458660134824570e-07, -1.319352010443079e-09,  1.207970412813968e-11, -1.127227832522361e-13,  1.084146884627815e-15, -1.093766563759170e-17,
  1.185860533048595e-19, -1.415027400010815e-21,  1.869605817556882e-23,  1.893869724408587e+00,  9.429715619430501e-04, -8.405001801198346e-06,  7.526195111260744e-08,
 -6.785775979024307e-10,  6.183395387040687e-12, -5.730069242407261e-14,  5.456841178561147e-16, -5.431986797050412e-18,  5.792069361894819e-20, -6.787856654140458e-22,
  8.822048615145930e-24,  1.957845000340791e+00,  3.743919667666386e-04, -3.334618757410261e-06,  2.982474356821023e-08, -2.684314931505182e-10,  2.439656191043426e-12,
 -2.252255744338946e-14,  2.133335505844495e-16, -2.107986416189554e-18,  2.226699162310720e-20, -2.582253612049629e-22,  3.322974126476016e-24,  1.992099450396084e+00,
  7.015234415330902e-05, -6.245995162077610e-07,  5.583174446838950e-09, -5.020676245830531e-11,  4.557293759349432e-13, -4.199523305446505e-15,  3.967406232003557e-17,
 -3.906143464941392e-19,  4.106976614505264e-21, -4.737627149499278e-23,  6.065614763895622e-25,  1.451851298572817e+00,  4.719821280674309e-03, -4.089544694421354e-05,
  3.576050669639370e-07, -3.169326750683278e-09,  2.864574187832932e-11, -2.663675575841901e-13,  2.578215876534167e-15, -2.635397535490596e-17,  2.889070936636856e-19,
 -3.438583910444796e-21,  4.455144894044188e-23,  1.662872620810335e+00,  2.896957371933042e-03, -2.500000397984650e-05,  2.170497583528275e-07, -1.900892808810526e-09,
  1.686122517575121e-11, -1.524123013623479e-13,  1.417007779718146e-15, -1.373497205894746e-17,  1.413533174002375e-19, -1.576064151313850e-21,  1.929227806298908e-23,
  1.802173891911727e+00,  1.698106570220116e-03, -1.462496923122913e-05,  1.265517999576993e-07, -1.102541519763990e-09,  9.702670249498127e-12, -8.669451201539545e-14,
  7.929334321048575e-16, -7.518726616147848e-18,  7.529339537213763e-20, -8.145766585836167e-22,  9.692814049802282e-24,  1.897512601771872e+00,  8.791684858262097e-04,
 -7.563149440374832e-06,  6.532419720666592e-08, -5.675182087762362e-10,  4.973642937369835e-12, -4.417502537943159e-14,  4.006492255933545e-16, -3.755818345702905e-18,
  3.706596324225926e-20, -3.943199435823666e-22,  4.614607867432314e-24,  1.959291382570935e+00,  3.490771180557792e-04, -3.000970981638224e-06,  2.589271788940484e-08,
 -2.245964322328483e-10,  1.963848248935222e-12, -1.738581606613057e-14,  1.569616139373915e-16, -1.462220338442873e-18,  1.431363160263710e-20, -1.508148841492166e-22,
  1.747624967329598e-24,  1.992370472092933e+00,  6.541054306565489e-05, -5.621372550345254e-07,  4.847660685164852e-09, -4.201684364427535e-11,  3.669835516587072e-13,
 -3.243754479318526e-15,  2.922018016414398e-17, -2.713804688010522e-19,  2.645936436198593e-21, -2.774524642311846e-23,  3.198999555973035e-25,  1.470102272212177e+00,
  4.409002091614930e-03, -3.689059726721737e-05,  3.111547589392501e-07, -2.654947631800197e-09,  2.303265234971850e-11, -2.045898921353969e-13,  1.878124124181383e-15,
 -1.802568357963086e-17,  1.832351820397738e-19, -1.996863891755225e-21,  2.350584816922258e-23,  1.674076248314109e+00,  2.706883087017828e-03, -2.256737313863393e-05,
  1.891471764176435e-07, -1.597271672797305e-09,  1.363408332663440e-11, -1.182024395113762e-13,  1.048208224375744e-15, -9.605215910138466e-18,  9.222734947881122e-20,
 -9.439378419878583e-22,  1.046782115679215e-23,  1.808741531808163e+00,  1.586895460653456e-03, -1.320613453876282e-05,  1.103576028449681e-07, -9.276270640232575e-10,
  7.863538466415570e-12, -6.749375404302080e-14,  5.901537949412778e-16, -5.306043389552263e-18,  4.973233167377655e-20, -4.949473997381117e-22,  5.334528438676973e-24,
  1.900913021553839e+00,  8.216516904985037e-04, -6.830634946968363e-06,  5.698566913906136e-08, -4.778040074937822e-10,  4.035612544600862e-12, -3.445847846406347e-14,
  2.991213555372687e-16, -2.663081091895100e-18,  2.464495951345757e-20, -2.415580989918655e-22,  2.561502752531967e-24,  1.960641560867601e+00,  3.262539552407972e-04,
 -2.710593055877748e-06,  2.259212445402507e-08, -1.891615202203015e-10,  1.594478286201834e-12, -1.357601358355094e-14,  1.173845423375037e-16, -1.039487600031785e-18,
  9.552414266379989e-21, -9.282602546498642e-23,  9.750786272347010e-25,  1.992623473059280e+00,  6.113523580376413e-05, -5.077697163845284e-07,  4.230140277466384e-09,
 -3.539412624891848e-11,  2.980510932809602e-13, -2.534230965421417e-15,  2.187034228135778e-17, -1.931674838544528e-19,  1.769039014711091e-21, -1.711769620118371e-23,
  1.789576279400622e-25,  1.487170703361067e+00,  4.128123956756992e-03, -3.339723157882090e-05,  2.721108160653294e-07, -2.239449430966392e-09,  1.869395359913961e-11,
 -1.591855645589507e-13,  1.393228108708197e-15, -1.265123150504363e-17,  1.204740197553449e-19, -1.216170129436758e-21,  1.312761578527131e-23,  1.684556490643832e+00,
  2.535008478011138e-03, -2.044242005168664e-05,  1.656275379649818e-07, -1.350748621611354e-09,  1.111751809489780e-11, -9.270382504806996e-14,  7.874821686847567e-16,
 -6.867961928060122e-18,  6.215710484006717e-20, -5.917513298637380e-22,  6.015896322802169e-24,  1.814885861537841e+00,  1.486302642050680e-03, -1.196597609719798e-05,
  9.669101712291781e-08, -7.853089297194947e-10,  6.424321545258946e-12, -5.310222427856567e-14,  4.455966148215439e-16, -3.822599383423598e-18,  3.386866810661958e-20,
 -3.143280682016810e-22,  3.108581248295449e-24,  1.904094493326865e+00,  7.696178160188468e-04, -6.190150764999608e-06,  4.994425344085067e-08, -4.047298995538125e-10,
  3.300242285505774e-12, -2.715489339187184e-14,  2.264312715988129e-16, -1.925998070668048e-18,  1.687648528091512e-20, -1.545064825323208e-22,  1.504750474319650e-24,
  1.961904854620010e+00,  3.056044947118962e-04, -2.456649158765979e-06,  1.980400724369047e-08, -1.602821342646566e-10,  1.304630426842161e-12, -1.070790476575772e-14,
  8.898189491900492e-17, -7.533704960478213e-19,  6.561368267102684e-21, -5.961545675765565e-23,  5.755349705554444e-25,  1.992860198157801e+00,  5.726693015644877e-05,
 -4.602193198486624e-07,  3.708414144233922e-09, -2.999509414657051e-11,  2.439339641072380e-13, -1.999687093827846e-15,  1.658964218175201e-17, -1.401421596809928e-19,
  1.216940020304337e-21, -1.101569352966659e-23,  1.058835043248694e-25, -2.004656560080161e+00,  2.817126134113778e-03, -5.921712354343237e-04,  1.253111379057221e-04,
 -2.669580156988315e-05,  5.725560616335810e-06, -1.236313109588078e-06,  2.687771401375887e-07, -5.883440899042303e-08,  1.296667473984316e-08, -2.871151650373816e-09,
  6.106966735508007e-10, -2.004305097484542e+00,  2.586387084934521e-03, -5.219066255157048e-04,  1.060815022702323e-04, -2.172692650440692e-05,  4.485732720362901e-06,
 -9.339171696073198e-07,  1.961478756303536e-07, -4.157318199377217e-08,  8.894144992550842e-09, -1.917337320982427e-09,  3.988809842961742e-10, -2.004101811729898e+00,
  2.454293956561900e-03, -4.833719060844903e-04,  9.598099755257860e-05, -1.922647155657778e-05,  3.887620731059485e-06, -7.939446417873951e-07,  1.638542179667559e-07,
 -3.419048174629981e-08,  7.215883695807852e-09, -1.537810240735358e-09,  3.171102940293189e-10, -2.003973776128387e+00,  2.371610807566342e-03, -4.598812161799983e-04,
  8.998321376410776e-05, -1.777931339473010e-05,  3.549969824916532e-06, -7.167945496591290e-07,  1.464555802606751e-07, -3.029744817442091e-08,  6.348415972070124e-09,
 -1.345182258177860e-09,  2.762363202235294e-10, -2.003895133662962e+00,  2.321021310538052e-03, -4.457485038529030e-04,  8.643399867843616e-05, -1.693657881562503e-05,
  3.356344990162309e-06, -6.731944038724736e-07,  1.367568059618227e-07, -2.815465219058849e-08,  5.876434123985677e-09, -1.241447785012443e-09,  2.544088408572128e-10,
 -2.003854332730731e+00,  2.294833555339180e-03, -4.385044039530214e-04,  8.463218915384943e-05, -1.651270284155217e-05,  3.259812686442079e-06, -6.516373829097389e-07,
  1.319983783115257e-07, -2.711075260657559e-08,  5.647955006929584e-09, -1.191509583176309e-09,  2.439476571717693e-10, -2.001913475857811e+00,  1.136457108966832e-03,
 -2.135232484140204e-04,  4.017077282487033e-05, -7.567390656835217e-06,  1.427417360084733e-06, -2.696015789821570e-07,  5.098685143537404e-08, -9.655065257053140e-09,
  1.830596031589906e-09, -3.471009560815749e-10,  6.367227070246248e-11, -2.001846813668263e+00,  1.093674231919393e-03, -2.017050392657413e-04,  3.725010119845928e-05,
 -6.888610050367148e-06,  1.275676688889769e-06, -2.365733723471063e-07,  4.393579894027985e-08, -8.171637533001026e-09,  1.522059351676475e-09, -2.836065705414361e-10,
  5.119359397444749e-11, -2.001805342281061e+00,  1.067176326909160e-03, -1.945290813439255e-04,  3.551187107925694e-05, -6.492674034559559e-06,  1.188926588111273e-06,
 -2.180661061407492e-07,  4.006296555364996e-08, -7.372913181134775e-09,  1.359188746476320e-09, -2.507380598105955e-10,  4.484929762112799e-11, -2.001778037650661e+00,
  1.049779504637828e-03, -1.898777481027426e-04,  3.439958386438489e-05, -6.242546581752924e-06,  1.134818130843591e-06, -2.066678341597283e-07,  3.770749319770049e-08,
 -6.893117228256621e-09,  1.262543843170074e-09, -2.314676386226825e-10,  4.117056775242279e-11, -2.001760790293215e+00,  1.038810722718839e-03, -1.869695201479525e-04,
  3.370993871086301e-05, -6.088748732458943e-06,  1.101821597763296e-06, -1.997734131579031e-07,  3.629417663575224e-08, -6.607507666374778e-09,  1.205460743895439e-09,
 -2.201720181131610e-10,  3.902921290370221e-11, -2.001751695045682e+00,  1.033032715000710e-03, -1.854451722032459e-04,  3.335025618730935e-05, -6.008930873467111e-06,
  1.084780423493666e-06, -1.962298507688097e-07,  3.557119709955794e-08, -6.462082383117853e-09,  1.176527631687248e-09, -2.144720867063125e-10,  3.795302446453850e-11,
 -2.000877199063619e+00,  5.171763440045322e-04, -9.265838830514621e-05,  1.660586149640270e-05, -2.976928230939514e-06,  5.338328506043594e-07, -9.575729899307191e-08,
  1.718176604342285e-08, -3.083843100534227e-09,  5.536454071863633e-10, -9.932873553786332e-11,  1.728537659740237e-11, -2.000862457804688e+00,  5.078030792557380e-04,
 -9.017563438317041e-05,  1.601813294635300e-05, -2.846194235147347e-06,  5.058808823801490e-07, -8.994234920315198e-08,  1.599607863658294e-08, -2.845751043552452e-09,
  5.064106837984037e-10, -9.006065947392227e-11,  1.554385834612589e-11, -2.000852992669550e+00,  5.017971235130467e-04, -8.859992290340666e-05,  1.564870709443929e-05,
 -2.764812101853309e-06,  4.886489042364640e-07, -8.639219150123189e-08,  1.527919246890382e-08, -2.703188821960522e-09,  4.784012593791152e-10, -8.461764069564188e-11,
  1.453025563580791e-11, -2.000846633192969e+00,  4.977672919262287e-04, -8.754929281365073e-05,  1.540394358222145e-05, -2.711233651904471e-06,  4.773759011973943e-07,
 -8.408438010587673e-08,  1.481611077758095e-08, -2.611677580237314e-09,  4.605344810855064e-10, -8.116718616296478e-11,  1.389142719914983e-11, -2.000842562718026e+00,
  4.951902495928042e-04, -8.688021691986676e-05,  1.524872223498966e-05, -2.677398041016640e-06,  4.702865471925553e-07, -8.263908476703912e-08,  1.452730195562652e-08,
 -2.554840464125832e-09,  4.494830666404405e-10, -7.904159607686269e-11,  1.349937674285496e-11, -2.000840399294181e+00,  4.938213064304253e-04, -8.652568558428584e-05,
  1.516667948607448e-05, -2.659558925379506e-06,  4.665581682603773e-07, -8.188087594589536e-08,  1.437616626187768e-08, -2.525170362658788e-09,  4.437281108231335e-10,
 -7.793738433385594e-11,  1.329617040101179e-11, -2.000420923241120e+00,  2.473429006468578e-04, -4.334481904113816e-05,  7.596372301078453e-06, -1.331393870574676e-06,
  2.333662729357689e-07, -4.090729967860971e-08,  7.171246787830946e-09, -1.257243107431499e-09,  2.204261173713675e-10, -3.861461729472781e-11,  6.569221802725729e-12,
 -2.000417446560519e+00,  2.451416378813573e-04, -4.277313379922744e-05,  7.463723016335069e-06, -1.302478440505805e-06,  2.273088192958180e-07, -3.967280159021059e-08,
  6.924691232038890e-09, -1.208756160387725e-09,  2.110068921750494e-10, -3.680495131285707e-11,  6.235841745492235e-12, -2.000415180881521e+00,  2.437085616680474e-04,
 -4.240269387484821e-05,  7.378175400026920e-06, -1.283918945990531e-06,  2.234393119809738e-07, -3.888795895006679e-08,  6.768688548084849e-09, -1.178223379717034e-09,
  2.051037811947452e-10, -3.567620164735966e-11,  6.028825340565651e-12, -2.000413643710624e+00,  2.427369247245432e-04, -4.215231427137303e-05,  7.320535516842414e-06,
 -1.271453403130784e-06,  2.208485393368316e-07, -3.836413569817209e-08,  6.664896651683978e-09, -1.157973241703322e-09,  2.012009976507717e-10, -3.493227412394965e-11,
  5.892785779017275e-12, -2.000412653469115e+00,  2.421112756416290e-04, -4.199142614817724e-05,  7.283574933017835e-06, -1.263476844654398e-06,  2.191942094556166e-07,
 -3.803035077826753e-08,  6.598897912973708e-09, -1.145123576088628e-09,  1.987296619825618e-10, -3.446217762375742e-11,  5.806987350951773e-12, -2.000412125131764e+00,
  2.417775531344959e-04, -4.190571525431132e-05,  7.263909480615739e-06, -1.259238143734653e-06,  2.183162153584477e-07, -3.785342581118391e-08,  6.563958796647530e-09,
 -1.138329614541083e-09,  1.974246355393224e-10, -3.421424448902759e-11,  5.761789049063714e-12, -2.000206282848640e+00,  1.210237955532873e-04, -2.098282142725051e-05,
  3.638016547023692e-06, -6.307730369127012e-07,  1.093677384023519e-07, -1.896325990320326e-08,  3.288095354178878e-09, -5.701421129494499e-10,  9.885949066686582e-11,
 -1.712740716641655e-11,  2.883277614151068e-12, -2.000205438052276e+00,  1.204900040663152e-04, -2.084551102565783e-05,  3.606463047833550e-06, -6.239615893424607e-07,
  1.079547281769801e-07, -1.867811046040897e-08,  3.231704738198497e-09, -5.591618993519276e-10,  9.674755578859527e-11, -1.672566486894529e-11,  2.809955436009581e-12,
 -2.000204883540276e+00,  1.201398042683929e-04, -2.075563610495459e-05,  3.585858497380696e-06, -6.195241612488324e-07,  1.070363715971736e-07, -1.849322131065780e-08,
  3.195227849251742e-09, -5.520760280443457e-10,  9.538788311551840e-11, -1.646763082032658e-11,  2.762965495632314e-12, -2.000204505525412e+00,  1.199011491700960e-04,
 -2.069448284425490e-05,  3.571860559890765e-06, -6.165142782454215e-07,  1.064144352232484e-07, -1.836820636954940e-08,  3.170602407850464e-09, -5.472999076096053e-10,
  9.447285918797679e-11, -1.629425267386391e-11,  2.731438360180593e-12, -2.000204261233965e+00,  1.197469526452493e-04, -2.065501227859308e-05,  3.562835221387312e-06,
 -6.145756553828704e-07,  1.060142754709764e-07, -1.828785505808202e-08,  3.154791429418487e-09, -5.442365770776885e-10,  9.388659242421206e-11, -1.618328315798256e-11,
  2.711279355002145e-12, -2.000204130644365e+00,  1.196645355381659e-04, -2.063392867914990e-05,  3.558017284572627e-06, -6.135414273278183e-07,  1.058009309389825e-07,
 -1.824504299157231e-08,  3.146372493824034e-09, -5.426064641161980e-10,  9.357481490303749e-11, -1.612430647629608e-11,  2.700571803416245e-12, -2.000102124854226e+00,
  5.986905816530304e-05, -1.032549911216308e-05,  1.780826378532528e-06, -3.071383200606144e-07,  5.297223858918018e-08, -9.136177846385935e-09,  1.575733072469031e-09,
 -2.717705111198272e-10,  4.687196320336699e-11, -8.077256645997943e-12,  1.352878015892088e-12, -2.000101916602889e+00,  5.973760458403803e-05, -1.029184351082046e-05,
  1.773129165594114e-06, -3.054846578059779e-07,  5.263083581787366e-08, -9.067612754088886e-09,  1.562239050590632e-09, -2.691556713565848e-10,  4.637145528936064e-11,
 -7.982506595166125e-12,  1.335663388087777e-12, -2.000101779424212e+00,  5.965103511725307e-05, -1.026970505396232e-05,  1.768071896132211e-06, -3.043994324508664e-07,
  5.240705151171269e-08, -9.022722248391967e-09,  1.553414729603423e-09, -2.674477291977009e-10,  4.604492224192128e-11, -7.920763865555676e-12,  1.324458022738545e-12,
 -2.000101685687040e+00,  5.959189001655017e-05, -1.025459154600695e-05,  1.764622090400848e-06, -3.036597287393071e-07,  5.225463704094832e-08, -8.992172371224546e-09,
  1.547414132106694e-09, -2.662872309003072e-10,  4.582322684009252e-11, -7.878877272709621e-12,  1.316861826273643e-12, -2.000101625013790e+00,  5.955361136996225e-05,
 -1.024481516321340e-05,  1.762391701876938e-06, -3.031817420286364e-07,  5.215620057762738e-08, -8.972452191296294e-09,  1.543542737533429e-09, -2.655389081092207e-10,
  4.568034641085503e-11, -7.851895920388784e-12,  1.311971118352906e-12, -2.000101592549116e+00,  5.953313081939034e-05, -1.023958605588917e-05,  1.761199107112329e-06,
 -3.029262421263855e-07,  5.210359966833155e-08, -8.961917777575039e-09,  1.541475315428484e-09, -2.651394116624639e-10,  4.560409305108873e-11, -7.837500880599665e-12,
  1.309362609009163e-12, -2.000050811688734e+00,  2.977612337721029e-05, -5.122049316385158e-06,  8.810890995769782e-07, -1.515641099281759e-07,  2.607194256154028e-08,
 -4.484880542073640e-09,  7.714873896771971e-10, -1.327110062260778e-10,  2.282837127992146e-11, -3.923603455765138e-12,  6.555414802937049e-13, -2.000050759988404e+00,
  2.974350498268550e-05, -5.113717660131501e-06,  8.791881010320550e-07, -1.511566686706688e-07,  2.598802506845759e-08, -4.468067205189039e-09,  7.681863088788776e-10,
 -1.320728567056848e-10,  2.270651440979792e-11, -3.900589904569277e-12,  6.513696098508439e-13, -2.000050725872529e+00,  2.972198347255729e-05, -5.108223631746075e-06,
  8.779352823464590e-07, -1.508883089711228e-07,  2.593278551883780e-08, -4.457006149616982e-09,  7.660158895234814e-10, -1.316535279368735e-10,  2.262648918404285e-11,
 -3.885485408853806e-12,  6.486329871578909e-13, -2.000050702532950e+00,  2.970726123862278e-05, -5.104466780385918e-06,  8.770789313263249e-07, -1.507049463895955e-07,
  2.589505671449326e-08, -4.449454378740797e-09,  7.645346506630680e-10, -1.313674625883487e-10,  2.257191758803725e-11, -3.875189235687600e-12,  6.467682183927047e-13,
 -2.000050687414043e+00,  2.969772499491330e-05, -5.102033930862489e-06,  8.765245232300385e-07, -1.505862672101838e-07,  2.587064362569117e-08, -4.444569157319220e-09,
  7.635766931560025e-10, -1.311825050352159e-10,  2.253664322730063e-11, -3.868535669250653e-12,  6.455634684856625e-13, -2.000050679320466e+00,  2.969262014363469e-05,
 -5.100731804442199e-06,  8.762278359288789e-07, -1.505227670000785e-07,  2.585758328606919e-08, -4.441956111393750e-09,  7.630643746387555e-10, -1.310836049005062e-10,
  2.251778438723171e-11, -3.864979015132221e-12,  6.449195667038850e-13, -2.000025343578584e+00,  1.484874346782240e-05, -2.550944830417919e-06,  4.382405357822568e-07,
 -7.528771967377929e-08,  1.293408940547120e-08, -2.222018607260529e-09,  3.817329361956546e-10, -6.557999535977445e-11,  1.126607744419310e-11, -1.933827528029361e-12,
  3.226992719453659e-13, -2.000025330698448e+00,  1.484061923144743e-05, -2.548872089501070e-06,  4.377681632371049e-07, -7.518659547650712e-08,  1.291328627429666e-08,
 -2.217855519919866e-09,  3.809165368798451e-10, -6.542236009701096e-11,  1.123601217120446e-11, -1.928156198713882e-12,  3.216723204641863e-13, -2.000025322191683e+00,
  1.483525385622117e-05, -2.547503612804166e-06,  4.374563815376994e-07, -7.511986962340558e-08,  1.289956354258093e-08, -2.215110155152970e-09,  3.803783169945506e-10,
 -6.531846788481283e-11,  1.121620295621350e-11, -1.924420601988414e-12,  3.209960725524692e-13, -2.000025316368559e+00,  1.483158125409406e-05, -2.546567070700686e-06,
  4.372430496352802e-07, -7.507422240985886e-08,  1.289017765186697e-08, -2.213232786052779e-09,  3.800103371926343e-10, -6.524745096492386e-11,  1.120266476339243e-11,
 -1.921868086680949e-12,  3.205340804731197e-13, -2.000025312594974e+00,  1.482920134624782e-05, -2.545960254199662e-06,  4.371048429206120e-07, -7.504465381760887e-08,
  1.288409861468742e-08, -2.212017014880402e-09,  3.797720673976859e-10, -6.520147300952839e-11,  1.119390098616910e-11, -1.920215964979341e-12,  3.202350917580864e-13,
 -2.000025310574389e+00,  1.482792703318590e-05, -2.545635361875699e-06,  4.370308522517740e-07, -7.502882516069330e-08,  1.288084464307561e-08, -2.211366291653251e-09,
  3.796445472094477e-10, -6.517686791242011e-11,  1.118921142469677e-11, -1.919331972524944e-12,  3.200751252466216e-13, -2.000012656274786e+00,  7.414577283766600e-06,
 -1.272964241451686e-06,  2.185475999179311e-07, -3.752112990262771e-08,  6.441778747619839e-09, -1.105950602386487e-09,  1.898740767171591e-10, -3.259832920266500e-11,
  5.596474911067229e-12, -9.600155030338578e-13,  1.601003681572086e-13, -2.000012653060347e+00,  7.412550003680446e-06, -1.272447321228103e-06,  2.184298641961820e-07,
 -3.749594021032677e-08,  6.436599816182700e-09, -1.104914815642807e-09,  1.896710745761400e-10, -3.255915552325177e-11,  5.589007860800170e-12, -9.586077945980512e-13,
  1.598456044518634e-13, -2.000012650936422e+00,  7.411210528667069e-06, -1.272105828201994e-06,  2.183520957547475e-07, -3.747930399310908e-08,  6.433179956182307e-09,
 -1.104230943541867e-09,  1.895370632570320e-10, -3.253329891691742e-11,  5.584079953605855e-12, -9.576789079922619e-13,  1.596775198139178e-13, -2.000012649482108e+00,
  7.410293369653369e-06, -1.271872025281358e-06,  2.182988568462989e-07, -3.746791624597686e-08,  6.430839238903917e-09, -1.103762914424496e-09,  1.894453574598217e-10,
 -3.251560662341137e-11,  5.580708381654643e-12, -9.570434452616105e-13,  1.595625416104981e-13, -2.000012648539478e+00,  7.409698910328513e-06, -1.271720495028340e-06,
  2.182643543759287e-07, -3.746053668740656e-08,  6.429322492430040e-09, -1.103459659167719e-09,  1.893859414245242e-10, -3.250414457034917e-11,  5.578524233418112e-12,
 -9.566318112251777e-13,  1.594880666992539e-13, -2.000012648034682e+00,  7.409380568848266e-06, -1.271639351577522e-06,  2.182458792594239e-07, -3.745658529482762e-08,
  6.428510381121770e-09, -1.103297293706337e-09,  1.893541308348464e-10, -3.249800817692075e-11,  5.577354961225354e-12, -9.564114538507655e-13,  1.594482000097857e-13,
 -2.000006324265233e+00,  3.704844399170591e-06, -6.358565427132503e-07,  1.091310474048673e-07, -1.872998846312532e-08,  3.214598247715997e-09, -5.517164136578547e-10,
  9.469021521060367e-11, -1.625152057813790e-11,  2.789153731337315e-12, -4.782949470546918e-13,  7.974016064446154e-14, -2.000006323462322e+00,  3.704338050512590e-06,
 -6.357274703704442e-07,  1.091016580132415e-07, -1.872370241886338e-08,  3.213306235181981e-09, -5.514580872725108e-10,  9.463960119465467e-11, -1.624175638773247e-11,
  2.787293090178791e-12, -4.779442771931583e-13,  7.967671477009959e-14, -2.000006322931686e+00,  3.704003414954090e-06, -6.356421752174666e-07,  1.090822379706017e-07,
 -1.871954900398323e-08,  3.212452618607315e-09, -5.512874267483987e-10,  9.460616604449746e-11, -1.623530672689710e-11,  2.786064148100809e-12, -4.777126788151781e-13,
  7.963481509009185e-14, -2.000006322568290e+00,  3.703774248951994e-06, -6.355837659860032e-07,  1.090689399761146e-07, -1.871670506660577e-08,  3.211868156638849e-09,
 -5.511705830835098e-10,  9.458327560999861e-11, -1.623089136516979e-11,  2.785222870207487e-12, -4.775541448534312e-13,  7.960613519482601e-14, -2.000006322332728e+00,
  3.703625698732076e-06, -6.355459051186527e-07,  1.090603204967884e-07, -1.871486174686953e-08,  3.211489345594866e-09, -5.510948549484498e-10,  9.456844046371380e-11,
 -1.622802989129837e-11,  2.784677679216801e-12, -4.774514101286719e-13,  7.958755034102833e-14, -2.000006322206573e+00,  3.703546142917555e-06, -6.355256291923010e-07,
  1.090557045306648e-07, -1.871387461845357e-08,  3.211286489997271e-09, -5.510543028811263e-10,  9.456049646915246e-11, -1.622649764615539e-11,  2.784385749368143e-12,
 -4.773964005281426e-13,  7.957759921309137e-14, -2.000003161165383e+00,  1.851811683996061e-06, -3.177720595673304e-07,  5.452988721339721e-08, -9.357363312965043e-09,
  1.605729500171427e-09, -2.755442052217678e-10,  4.728356037603544e-11, -8.113883237060371e-12,  1.392313046390196e-12, -2.387207332236306e-13,  3.979285921658625e-14,
 -2.000003160964743e+00,  1.851685155688874e-06, -3.177398111700465e-07,  5.452254542424354e-08, -9.355793221709276e-09,  1.605406836387896e-09, -2.754797009865274e-10,
  4.727092389393537e-11, -8.111445833030546e-12,  1.391848648971388e-12, -2.386332224022946e-13,  3.977702827275855e-14, -2.000003160832127e+00,  1.851601525923386e-06,
 -3.177184971344595e-07,  5.451769316860711e-08, -9.354755571899545e-09,  1.605193600520805e-09, -2.754370742224525e-10,  4.726257354911248e-11, -8.109835225115086e-12,
  1.391541791868381e-12, -2.385754005118896e-13,  3.976656849492578e-14, -2.000003160741301e+00,  1.851544249880025e-06, -3.177039000091314e-07,  5.451437013495697e-08,
 -9.354044962005611e-09,  1.605047574568378e-09, -2.754078837250136e-10,  4.725685543428494e-11, -8.108732346746867e-12,  1.391331673850258e-12, -2.385358083907199e-13,
  3.975940658307118e-14, -2.000003160682422e+00,  1.851507120395637e-06, -3.176944375019042e-07,  5.451221603161257e-08, -9.353584328074262e-09,  1.604952918690141e-09,
 -2.753889623847670e-10,  4.725314900153799e-11, -8.108017482264806e-12,  1.391195481647111e-12, -2.385101463850408e-13,  3.975476459396126e-14, -2.000003160650889e+00,
  1.851487235133792e-06, -3.176893697612741e-07,  5.451106239134322e-08, -9.353337635828717e-09,  1.604902226290154e-09, -2.753788292727062e-10,  4.725116408267996e-11,
 -8.107634652201924e-12,  1.391122547612067e-12, -2.384964039310682e-13,  3.975227875050046e-14,     0.998251786243607,     0.990672772444073,     0.976521126732143,
     0.954690154630256,     0.922812859937023,     0.874579763550291,     0.999127755372004,     0.995346379035634,     0.988285991033764,     0.977394985506802,
     0.961493627304672,     0.937437293049445,     0.999564321615593,       0.9976755647385,     0.994149006405293,     0.988709188910313,     0.980766983071475,
     0.968752040206435,     0.999782269353729,     0.998838362307223,     0.997075966886961,     0.994357430604149,      0.99038835195031,      0.98438398989132,
     0.999891161523311,     0.999419324486456,     0.998538344714071,     0.997179413882238,      0.99519536951987,     0.992193942940484,     0.999945587437861,
     0.999709697874766,     0.999269262106792,     0.998589880310019,     0.997597980520471,     0.996097453079505,     0.999972795383608,     0.999854857820348,
     0.999634653420661,     0.999294983339594,     0.998799063876354,     0.998048846278464,      0.99998639810743,     0.999927431127818,     0.999817332293425,
     0.999647502446353,     0.999399550301962,     0.999024452991578,     0.999993199157554,     0.999963716117934,     0.999908667541399,     0.999823753914874,
     0.999699779736913,     0.999512233948622,     0.999996599604728,     0.999981858197425,     0.999954334119235,     0.999911877630057,     0.999849891014313,
      0.99975611883624,     0.999998299808851,     0.999990929133321,     0.999977167146735,     0.999955938983145,     0.999924945793543,     0.999878059883443
  };
  constexpr double w[3162] = {  2.395553675671111e-01, -1.019821045288983e-01,  2.329234552891411e-02, -3.623591080035322e-03,  4.272865034927560e-04,
 -4.057406681527675e-05,  3.225729234857562e-06, -2.206086800200795e-07,  1.324002268905698e-08, -7.080421865970154e-10,  3.414885502442298e-11, -1.497744247843008e-12,
  2.403516487641265e-01, -9.148040477543919e-02,  1.883583699577774e-02, -2.679594270524030e-03,  2.927382820154860e-04, -2.604391086347973e-05,  1.958449422996717e-06,
 -1.277144393040904e-07,  7.359141169395744e-09, -3.800810446083796e-10,  1.779388143247152e-11, -7.609091846633365e-13,  2.376863355798457e-01, -7.093480253067533e-02,
  1.183662283012937e-02, -1.409392893537097e-03,  1.323541898404916e-04, -1.034661109499823e-05,  6.963055534164628e-07, -4.127174171069274e-08,  2.190346473626208e-09,
 -1.053863234772593e-10,  4.641852921214839e-12, -1.883883495646150e-13,  2.206975824747291e-01, -4.388688659248074e-02,  5.318337893556814e-03, -4.854459287727172e-04,
  3.638313666713282e-05, -2.343237997471196e-06,  1.333506347713942e-07, -6.832163548505781e-09,  3.193782511413271e-10, -1.375848767159374e-11,  5.504387202785566e-13,
 -2.055361263112294e-14,  1.729556705571549e-01, -1.888305217832016e-02,  1.478697121986493e-03, -9.426976252508329e-05,  5.202609629682176e-06, -2.569515265089923e-07,
  1.158931496661916e-08, -4.838424309327932e-10,  1.887753831295210e-11, -6.932023100807656e-13,  2.408820648996311e-14, -7.947328339741741e-16,  8.504140837964105e-02,
 -4.456045953407211e-03,  1.908897156309820e-04, -7.418806890105323e-06,  2.682659692055559e-07, -9.148293063126877e-09,  2.969757949534366e-10, -9.239770648219412e-12,
  2.769128089036079e-13, -8.024371467016975e-15,  2.254858977481979e-16, -6.154592634434865e-18,  3.659098671832652e-02, -1.544790124889838e-02,  3.500137289751164e-03,
 -5.406785305680983e-04,  6.336168559160702e-05, -5.983978990843939e-06,  4.734554089904208e-07, -3.224156601174611e-08,  1.927622278627017e-09, -1.027307248199994e-10,
  4.939351523323994e-12, -2.160290447044701e-13,  4.770799482814628e-02, -1.731989395234976e-02,  3.421676175825625e-03, -4.700949708445202e-04,  4.986547649076357e-05,
 -4.326432420518205e-06,  3.184125535644606e-07, -2.038220215550534e-08,  1.155678330106092e-09, -5.885451905131045e-11,  2.721607684809092e-12, -1.151317443784347e-13,
  7.190374443813877e-02, -1.921671192907726e-02,  2.934281431863305e-03, -3.245080309633778e-04,  2.862203379295905e-05, -2.119957724060990e-06,  1.361347621006850e-07,
 -7.744796668359814e-09,  3.964665600349890e-10, -1.847775313972563e-11,  7.912415846790757e-13, -3.131998806070345e-14,  1.037351942029054e-01, -1.743247418625764e-02,
  1.864476521541522e-03, -1.532640990911599e-04,  1.049265050916627e-05, -6.240278269538271e-07,  3.308243916487763e-08, -1.590632974828002e-09,  7.022140395186440e-11,
 -2.872657503738665e-12,  1.096709798121967e-13, -3.925264244924317e-15,  1.155017141799569e-01, -1.047443368774266e-02,  7.161122147501766e-04, -4.064713914199147e-05,
  2.022297779487310e-06, -9.090123408745888e-08,  3.760483549319290e-09, -1.449535518131921e-10,  5.252023575447217e-12, -1.800333428143556e-13,  5.867611620124388e-15,
 -1.823767489537176e-16,  6.979502355633287e-02, -3.223825839866068e-03,  1.226307426289965e-04, -4.275866319010146e-06,  1.398515038481898e-07, -4.339772493188003e-09,
  1.287964017252370e-10, -3.677923463221566e-12,  1.015029237560822e-13, -2.717914668246133e-15,  7.072543370258995e-17, -1.793890215227043e-18,  5.709991274204538e-03,
 -2.383329545942509e-03,  5.342952605018580e-04, -8.177681498318772e-05,  9.507448212791600e-06, -8.917323193106341e-07,  7.013133332242358e-08, -4.750662009157173e-09,
  2.827022528873112e-10, -1.500374051824204e-11,  7.187035555884685e-13, -3.132836788379712e-14,  1.043229657676365e-02, -3.553124803607829e-03,  6.651302656830864e-04,
 -8.738340043238872e-05,  8.928309648432724e-06, -7.504578794566301e-07,  5.375641308995152e-08, -3.361898230162470e-09,  1.868227799539080e-10, -9.349203445338194e-12,
  4.257805050583477e-13, -1.777265656331651e-14,  2.517065437694220e-02, -5.885939842334954e-03,  8.107184933394152e-04, -8.232494810062177e-05,  6.753900449468377e-06,
 -4.699538896231480e-07,  2.857944498553911e-08, -1.550014318308871e-09,  7.606937486467766e-11, -3.415211635895035e-12,  1.414654073840741e-13, -5.436750998102530e-15,
  5.524685065290218e-02, -7.747706733438629e-03,  7.279295658285163e-04, -5.364256185826818e-05,  3.339383247491990e-06, -1.825544164446495e-07,  8.973928283341435e-09,
 -4.030243005437423e-10,  1.672445747153316e-11, -6.466906697887011e-13,  2.345218662448039e-14, -8.009597825811222e-16,  8.260015476271661e-02, -6.258533158114784e-03,
  3.752883201456207e-04, -1.903258054238926e-05,  8.556248255005141e-07, -3.505028927445859e-08,  1.330719297440986e-09, -4.735691052668145e-11,  1.592473316828044e-12,
 -5.090096875890633e-14,  1.553612372115734e-15, -4.540772284130687e-17,  5.858304268020167e-02, -2.415637687733841e-03,  8.234391316004371e-05, -2.594058276987653e-06,
  7.719941489779047e-08, -2.191526676801782e-09,  5.973165173259056e-11, -1.572999465983681e-12,  4.007874714885310e-14, -9.960060173498615e-16,  2.409308132232761e-17,
 -5.667346482565116e-19,  9.173118468647526e-04, -3.767801386127569e-04,  8.324976295580902e-05, -1.258608093716575e-05,  1.448115103583682e-06, -1.346224552630920e-07,
  1.050695287317979e-08, -7.070310940246316e-10,  4.183053702315945e-11, -2.208728812822199e-12,  1.053226299950406e-13, -4.572509798922051e-15,  2.571112559077841e-03,
 -8.037751478897365e-04,  1.403935438999189e-04, -1.742781888314087e-05,  1.698654021100274e-06, -1.372173759143023e-07,  9.502393955125296e-09, -5.772962947699737e-10,
  3.128822334722397e-11, -1.532153106591938e-12,  6.847024092886638e-14, -2.811259517235545e-15,  1.022820380631455e-02, -2.044185485004868e-03,  2.507925626158454e-04,
 -2.314159038009964e-05,  1.750078572783322e-06, -1.134830753264259e-07,  6.487873274859980e-09, -3.331987025366501e-10,  1.557994016031937e-11, -6.699773455462517e-13,
  2.670426172942593e-14, -9.916206311287130e-16,  3.281941858438580e-02, -3.807680226350525e-03,  3.138607761448567e-04, -2.069111421086631e-05,  1.168293018055572e-06,
 -5.853559442061724e-08,  2.659638690436761e-09, -1.111837063044576e-10,  4.321237326994709e-12, -1.573436391002070e-13,  5.399225981559821e-15, -1.752728554058906e-16,
  6.239437605426562e-02, -3.980944882777075e-03,  2.105025765929249e-04, -9.580737092224950e-06,  3.904604377150801e-07, -1.461104351764583e-08,  5.099043753620366e-10,
 -1.676819294826488e-11,  5.235494983950785e-13, -1.560241012743491e-14,  4.456872871108087e-16, -1.223869455502765e-17,  5.006665675575657e-02, -1.863293067167677e-03,
  5.739680615580086e-05, -1.644356812689189e-06,  4.476616144558481e-08, -1.169082705768674e-09,  2.934235881356286e-11, -7.177578807496121e-13,  1.691493382084086e-14,
 -3.893328594657678e-16,  8.900845622613384e-18, -1.935247424150592e-19,  1.534648180223496e-04, -6.157118763978012e-05,  1.333019642459439e-05, -1.981768823494363e-06,
  2.248653039759999e-07, -2.066201955981584e-08,  1.596762791822561e-09, -1.065435669953603e-10,  6.257571372432557e-12, -3.283115264754982e-13,  1.556803363522067e-14,
 -6.725452681347671e-16,  7.309545383052916e-04, -2.040199223059971e-04,  3.266501976050035e-05, -3.778959163934972e-06,  3.474672227288373e-07, -2.672559857913571e-08,
  1.775219958946006e-09, -1.040647583785380e-10,  5.468927063007355e-12, -2.607461499339270e-13,  1.138440660530377e-14, -4.580295824471219e-16,  4.803980208328464e-03,
 -8.025893449383119e-04,  8.687657042806570e-05, -7.222747679622921e-06,  4.997208162298447e-07, -2.998551442629334e-08,  1.601006754849319e-09, -7.737550391316325e-11,
  3.426825577487379e-12, -1.403648272277516e-13,  5.355374062518177e-15, -1.912030340414779e-16,  2.139237116940227e-02, -2.042941705313168e-03,  1.479874830118538e-04,
 -8.728182845696114e-06,  4.467045352226959e-07, -2.048399645586857e-08,  8.588227224129279e-10, -3.334441885582569e-11,  1.210649570614529e-12, -4.139963952194953e-14,
  1.340160836663757e-15, -4.121958453169935e-17,  4.923577470433368e-02, -2.669157378341832e-03,  1.251618914798439e-04, -5.137411533320014e-06,  1.905446442296462e-07,
 -6.532094479584697e-09,  2.100512764539875e-10, -6.392555661196690e-12,  1.855182075023560e-13, -5.160505590758421e-15,  1.379418805824375e-16, -3.557128220171254e-18,
  4.342198613129905e-02, -1.472429731561927e-03,  4.129808334382372e-05, -1.082766290735611e-06,  2.706773091936234e-08, -6.557190347968612e-10,  1.512401661605734e-11,
 -3.457645684222678e-13,  7.684887309141038e-15, -1.586249538523103e-16,  3.487907066237542e-18, -7.393279361095654e-20,  2.721050386463170e-05, -1.053424628601962e-05,
  2.214880302512307e-06, -3.216547387169852e-07,  3.581112230194876e-08, -3.239606633701353e-09,  2.471219102780643e-10, -1.630913867330444e-11,  9.489490082559414e-13,
 -4.938789621115420e-14,  2.325548331344837e-15, -9.985176162398261e-17,  2.444890077237072e-04, -5.894454144947644e-05,  8.491372638000647e-06, -9.021116402282217e-07,
  7.731604660837437e-08, -5.604891187630725e-09,  3.539887014013447e-10, -1.987125030327946e-11,  1.005906301298619e-12, -4.642418070048820e-14,  1.970218988644477e-15,
 -7.732828138072814e-17,  2.580025240494280e-03, -3.532812968097235e-04,  3.356666739232254e-05, -2.498820459768512e-06,  1.573031415462536e-07, -8.685079427344743e-09,
  4.307371270325518e-10, -1.948613861610678e-11,  8.131032484323942e-13, -3.156327890020425e-14,  1.147060310774469e-15, -3.918951183550871e-17,  1.506311054536638e-02,
 -1.181658627560469e-03,  7.553111077527982e-05, -3.991717862764133e-06,  1.854081930567597e-07, -7.777640106080798e-09,  3.008083202402632e-10, -1.083952477385786e-11,
  3.668982795201002e-13, -1.176601477723010e-14,  3.586293368116899e-16, -1.042348889351461e-17,  4.023329483609926e-02, -1.871038844965137e-03,  7.823994100030104e-05,
 -2.910590190153711e-06,  9.867298832688066e-08, -3.107915159914087e-09,  9.237128481518565e-11, -2.608256781035538e-12,  7.036741592357721e-14, -1.831557099023781e-15,
  4.590283091768072e-17, -1.109499387032953e-18,  3.811996989748278e-02, -1.187538506896065e-03,  3.052657825969782e-05, -7.377268987966066e-07,  1.692319827417193e-08,
 -3.855835265566468e-10,  8.187021926859237e-12, -1.696658383878183e-13,  3.847760572283967e-15, -6.877846496769883e-17,  1.308288591611255e-18, -3.150004124225830e-20,
  5.253417144028497e-06, -1.922293094595039e-06,  3.871843229597451e-07, -5.438650655584020e-08,  5.897758418422028e-09, -5.223276317174744e-10,  3.915673413424348e-11,
 -2.547093862149130e-12,  1.464099070027761e-13, -7.541386157821835e-15,  3.519605687209649e-16, -1.499640452933292e-17,  9.735352149223843e-05, -1.953415679074067e-05,
  2.490613468438531e-06, -2.394728762354833e-07,  1.890694405330689e-08, -1.278481467005352e-09,  7.607538412943786e-11, -4.056501209283264e-12,  1.963713306446672e-13,
 -8.716523172751117e-15,  3.575200184126663e-16, -1.361911653644957e-17,  1.560740028097774e-03, -1.722018974976527e-04,  1.436554426710670e-05, -9.534019317044306e-07,
  5.445555354734151e-08, -2.755231086752542e-09,  1.263872368811741e-10, -5.331916945619592e-12,  2.086724269383210e-13, -7.643583879923019e-15,  2.634699550814325e-16,
 -8.575913272681197e-18,  1.129989712664531e-02, -7.282849712004005e-04,  4.133329202300975e-05, -1.960869241071992e-06,  8.296123091469243e-08, -3.184433467667210e-09,
  1.135297015805961e-10, -3.807684911734162e-12,  1.198529591339114e-13, -3.599490960849505e-15,  1.033828663744565e-16, -2.830556837230723e-18,  3.381229064356481e-02,
 -1.362037114609687e-03,  5.106610906055159e-05, -1.729561653053907e-06,  5.386431289912778e-08, -1.563199955512854e-09,  4.301739579975299e-11, -1.134356459278571e-12,
  2.840269642674527e-14, -6.909726275283421e-16,  1.639561925887795e-17, -3.699362780452772e-19,  3.380797837261470e-02, -9.746574832534565e-04,  2.307471090052948e-05,
 -5.193643480896736e-07,  1.085493048738560e-08, -2.341755065428893e-10,  4.846245301104181e-12, -7.836722885221610e-14,  2.038446401867657e-15, -3.800526205263642e-17,
  3.457613550444691e-19, -1.564897814185429e-20,  1.150615485128479e-06, -3.838964195693673e-07,  7.259073155961321e-08, -9.720418048520297e-09,  1.015945672546429e-09,
 -8.738514389955225e-11,  6.398330870476838e-12, -4.082439622110407e-13,  2.309300476345698e-14, -1.173572531528692e-15,  5.414828765357210e-17, -2.284708564202965e-18,
  4.619255201579309e-05, -7.410343029426330e-06,  8.282769894553754e-07, -7.109215464893708e-08,  5.118550093900207e-09, -3.197822508881548e-10,  1.776757613735630e-11,
 -8.928637073261895e-13,  4.102724619132907e-14, -1.739755404308671e-15,  6.854664696087514e-17, -2.520060637289364e-18,  1.045808105650252e-03, -9.155246342750089e-05,
  6.755949689727752e-06, -3.979893994333935e-07,  2.062784546138956e-08, -9.553055280951274e-10,  4.032769917851104e-11, -1.585178619383836e-12,  5.798337544355241e-14,
 -1.995190464418937e-15,  6.511034060506870e-17, -2.008393286454980e-18,  8.925563833820538e-03, -4.732063024014175e-04,  2.406182761870495e-05, -1.024702522287434e-06,
  3.970297950864448e-08, -1.401958951578544e-09,  4.566550199831120e-11, -1.439946309616866e-12,  4.221676755025813e-14, -1.172092330820108e-15,  3.225247757961673e-17,
 -8.193011307802849e-19,  2.906770607280769e-02, -1.023934740566752e-03,  3.460671477652681e-05, -1.070956684130074e-06,  3.079929130040967e-08, -8.283584677307610e-10,
  2.098743424879096e-11, -5.229282463326102e-13,  1.226634028299576e-14, -2.709351042137161e-16,  6.312287862325183e-18, -1.313628494341527e-19,  3.024281890976433e-02,
 -8.123548524949559e-04,  1.774857357578528e-05, -3.774629902587141e-07,  7.189755531978849e-09, -1.380270442012346e-10,  3.370998494392037e-12, -3.365597134519210e-14,
  7.599041035016149e-16, -3.733612138786099e-17, -3.056860405933712e-19, -1.365690565488255e-20,  3.031392020105000e-07, -8.660057301409376e-08,  1.497175560364903e-08,
 -1.871917526921356e-09,  1.858476735817305e-10, -1.535398491917947e-11,  1.088659219368174e-12, -6.768164036211514e-14,  3.747641688946208e-15, -1.871078260677118e-16,
  8.505651107896931e-18, -3.543869871034111e-19,  2.587388312379323e-05, -3.173311492866911e-06,  3.124363042919975e-07, -2.361304837259817e-08,  1.538097603664282e-09,
 -8.823257793745390e-11,  4.534584853199872e-12, -2.133614728773423e-13,  9.243484164747713e-15, -3.716524207710229e-16,  1.399423910426348e-17, -4.934113508533398e-19,
  7.638072501907103e-04, -5.217008575954790e-05,  3.466485966943873e-06, -1.802263862559391e-07,  8.461084026965956e-09, -3.623025206788169e-10,  1.390420588929596e-11,
 -5.094463363972043e-13,  1.754696373296244e-14, -5.571241132454330e-16,  1.736653525135428e-17, -5.085728311896406e-19,  7.352702769820023e-03, -3.209006953228799e-04,
  1.481270097326843e-05, -5.656062118298958e-07,  2.000881708615883e-08, -6.687143328086447e-10,  1.935444409920204e-11, -5.715866078419905e-13,  1.661897792325559e-14,
 -3.888414062975569e-16,  1.071754129301541e-17, -2.840534865605470e-19,  2.545464602099384e-02, -7.912126640975533e-04,  2.424199832549738e-05, -6.876183352575980e-07,
  1.827964089531940e-08, -4.635238736366235e-10,  1.066556583432136e-11, -2.472258244422088e-13,  5.929443621339949e-15, -1.067481553374776e-16,  2.353646446098601e-18,
 -6.730237122177837e-20,  2.725120795625424e-02, -6.867115642222632e-04,  1.383158226798037e-05, -2.804033409471212e-07,  5.170469863612397e-09, -6.703279881100692e-11,
  2.545162897028970e-12, -3.398159226589824e-14, -8.805723753923667e-16, -5.262349253353370e-17, -4.112296003114775e-20,  4.530608210131338e-20,  1.032537924555927e-07,
 -2.267153927370698e-08,  3.504683605190980e-09, -3.973933332380379e-10,  3.678576666228753e-11, -2.878424322769397e-12,  1.952818929607427e-13, -1.172667039460146e-14,
  6.311410011733271e-16, -3.077084784407533e-17,  1.372169662503706e-18, -5.624169324942960e-20,  1.683731044012653e-05, -1.492676649183179e-06,  1.332731212661033e-07,
 -8.764772918087374e-09,  5.094193586052917e-10, -2.701084523897259e-11,  1.268743062024750e-12, -5.534678408068350e-14,  2.270794481644729e-15, -8.528688953344827e-17,
  3.046171713912281e-18, -1.040923089238496e-19,  5.995402024488719e-04, -3.124069638211248e-05,  1.924704335009524e-06, -8.859239937534140e-08,  3.660389527459442e-09,
 -1.509691684591459e-10,  5.234725107899393e-12, -1.692824887288390e-13,  5.956452430354034e-15, -1.698872664028754e-16,  4.453665480474641e-18, -1.585576832540373e-19,
  6.269638666360769e-03, -2.249813856601717e-04,  9.574097834888964e-06, -3.317226065660087e-07,  1.024791052014757e-08, -3.466940458056795e-10,  9.153245392881422e-12,
 -2.027049634085545e-13,  7.723631071175449e-15, -1.693799155825364e-16,  9.672098493451702e-19, -1.733048913742209e-19,  2.263160009890815e-02, -6.259347526266673e-04,
  1.747895869977746e-05, -4.574080571349231e-07,  1.110584619281323e-08, -2.722185656201084e-10,  5.918807846607883e-12, -1.064093619728653e-13,  3.096178022265324e-15,
 -6.835664007388481e-17, -2.742146270464460e-19, -4.060004426102870e-20,  2.470623232719189e-02, -5.881941400525997e-04,  1.092854738694830e-05, -2.054844454295469e-07,
  4.340094868859048e-09, -2.217255042927155e-11,  9.463193437706991e-13, -8.652748000241416e-14, -1.967214788553535e-15,  2.391919252624355e-17,  4.604266090773388e-18,
  1.311333510754138e-19,  4.836219903190600e-08, -6.847800052325019e-09,  9.637411416894642e-10, -9.545867611452991e-11,  8.011727581518008e-12, -5.878195238374574e-13,
  3.752942034156767e-14, -2.145458895616547e-15,  1.117163918725581e-16, -5.271705772396906e-18,  2.281898132697360e-19, -9.217153291481259e-21,  1.248527971624249e-05,
 -7.410674077649441e-07,  6.338261247166944e-08, -3.690082706362808e-09,  1.810423263529461e-10, -9.122809698440816e-12,  4.013964884806708e-13, -1.510255207737969e-14,
  6.035895908912928e-16, -2.261655921544092e-17,  6.579496849341392e-19, -2.254034777177408e-20,  4.997904348859871e-04, -1.929164365904666e-05,  1.131856163516454e-06,
 -4.864186379603422e-08,  1.604276322108989e-09, -6.538560831579624e-11,  2.423313709710391e-12, -5.309036416386955e-14,  1.775710849845410e-15, -8.632742615693159e-17,
  8.544870925844005e-19, -8.224505996981709e-22,  5.501016332244280e-03, -1.619810747707678e-04,  6.382851048496780e-06, -2.127905761834685e-07,  5.171474871357226e-09,
 -1.728664465213315e-10,  6.006244803874571e-12, -5.662225922225756e-14,  1.127286236276672e-15, -2.053087684194453e-16,  5.006707171532070e-20,  2.020622593182549e-19,
  2.037653841864200e-02, -5.054058237220444e-04,  1.289921108329540e-05, -3.163932642517463e-07,  6.888416844181495e-09, -1.571237637384719e-10,  3.931293648259624e-12,
 -5.018924104868321e-14,  3.440994138134101e-16, -7.615569733555836e-17,  1.022913570212979e-18,  1.045819935598129e-19,  2.251432245530006e-02, -5.094787243030324e-04,
  8.866238484888340e-06, -1.392838361473194e-07,  3.899448925968128e-09, -3.337657292938824e-11, -1.930678079523807e-12, -9.352128213286740e-14,  2.815707475286437e-15,
  2.248629748632935e-16,  1.519034798407042e-18, -3.844746247856497e-19,  3.133917183436305e-08, -2.194382369125390e-09,  3.157193743109020e-10, -2.729450511767030e-11,
  1.918916712084119e-12, -1.317487283051599e-13,  8.056647595929052e-15, -4.185573791842544e-16,  2.048536900870819e-17, -9.778272038133290e-19,  4.045063312000013e-20,
 -1.459574103960507e-21,  1.030949309713879e-05, -3.729361954738819e-07,  3.183980092489451e-08, -1.842296321658550e-09,  6.929726031296155e-11, -2.988192075472722e-12,
  1.545879485322972e-13, -5.062181791043689e-15,  1.144275773361296e-16, -6.728335860927484e-18,  3.007852759524003e-19, -4.578752652788838e-22,  4.375450068244751e-04,
 -1.221625640847511e-05,  6.680680128927363e-07, -3.069916893071466e-08,  7.797518698146245e-10, -2.123047225834367e-11,  1.324869969114030e-12, -3.688216248969492e-14,
 -3.549661444803638e-16, -1.647698735398211e-17,  2.909449145664965e-18,  2.681518553190003e-20,  4.940745837020946e-03, -1.199401151933082e-04,  4.235625339540617e-06,
 -1.504222345284176e-07,  3.021115173298507e-09, -4.992874187152909e-11,  3.948992785218676e-12, -1.152412619104753e-13, -3.317268869481395e-15,  3.832673643501934e-17,
  1.090286773404389e-17,  1.586310340267631e-20,  1.853962594358629e-02, -4.157332649763595e-04,  9.675370639208713e-06, -2.266752567193005e-07,  4.573068949732120e-09,
 -8.041561481935450e-11,  2.376824631203990e-12, -6.629561988722940e-14, -6.257637365598843e-16,  4.016571067510942e-17,  3.346003982164800e-18, -8.277969910199452e-20,
  2.060908757501871e-02, -4.442442310849872e-04,  7.537207162382567e-06, -8.536534385851498e-08,  2.639224546742396e-09, -9.403002325927712e-11, -2.217730593851965e-12,
  9.761553423292349e-14,  7.024295576095373e-15, -1.194442534191096e-16, -1.600857356702155e-17,  7.706614052245067e-21,  2.607854232464100e-08, -6.043578695237613e-10,
  1.110731364227851e-10, -1.014459257873963e-11,  5.457407241133104e-13, -2.873297947650412e-14,  1.899470384261014e-15, -1.047718298754912e-16,  3.926756694589175e-18,
 -1.428216637170353e-19,  8.379421673411265e-21, -3.952570446986797e-22,  9.209177617646286e-06, -1.912480793732280e-07,  1.494714866699962e-08, -1.052888603834293e-09,
  3.663512079789407e-11, -7.092410718461932e-13,  4.337766822388136e-14, -3.135833104404678e-15,  6.013244618791680e-17,  2.012349009342215e-18,  4.534029194879471e-20,
 -1.076421674695019e-20,  3.973047126486818e-04, -8.156063195541559e-06,  3.651038410648472e-07, -2.026580461246870e-08,  5.833795107149198e-10, -2.877569711601421e-12,
  1.960507168139237e-13, -3.733556657823730e-14,  7.675922836078705e-16,  5.203807793517679e-17, -8.792035567257223e-19, -1.398571898176856e-19,  4.518417967351336e-03,
 -9.250225314572124e-05,  2.700887662339373e-06, -1.061925464258243e-07,  2.662420635024312e-09, -1.891660928000322e-12, -3.835832536842181e-14, -1.318032458253913e-13,
  3.415250249125572e-15,  2.121961410592483e-16, -6.332886928216334e-18, -4.789196366933459e-19,  1.701588784342195e-02, -3.480721496550052e-04,  7.349476949697747e-06,
 -1.639209664372501e-07,  3.381334978552947e-09, -4.591765266113990e-11,  5.771633441414739e-13, -4.895719846165967e-14,  1.731533519519801e-15,  4.393613382199880e-17,
 -3.144792936134065e-18, -8.068950418335073e-20,  1.894702704221492e-02, -3.874817864099300e-04,  6.698208295830773e-06, -5.977882135753153e-08,  5.476670737858658e-10,
 -9.690850362905106e-11,  2.276562736672843e-12,  1.582041495704522e-13, -4.670911988606531e-15, -3.372110238679948e-16,  1.087010479186714e-17,  6.987448191275601e-19,
  2.483455772289757e-08, -8.592635035356577e-11,  2.858010656971915e-11, -4.319142302474309e-12,  2.485930135047193e-13, -7.316155984164894e-15,  2.470295024642008e-16,
 -2.434103817687528e-17,  1.618293911016153e-18, -4.338688105825287e-20, -3.607026943641629e-22,  6.225606016637262e-25,  8.616271216019588e-06, -1.130847706611796e-07,
  5.474237388955891e-09, -5.487666000609190e-10,  2.713611759839650e-11, -4.450474700047447e-13, -8.661863940835003e-15, -4.506999768905749e-16,  8.111489317585317e-17,
 -1.927500170512008e-18, -1.115270470109400e-19,  5.144146731910904e-21,  3.692004285144499e-04, -6.053522400744487e-06,  1.760364234988950e-07, -1.142414786737280e-08,
  5.082370109091211e-10, -6.685250977654169e-12, -3.238359123184238e-13,  2.203029088106810e-15,  1.133483184704433e-15, -3.602763407456080e-17, -1.574330232506323e-18,
  1.000119078947690e-19,  4.184564457711186e-03, -7.527649888188670e-05,  1.678016324806809e-06, -6.491189938446452e-08,  2.401477439327968e-09, -3.014502080236715e-11,
 -1.552990997061177e-12,  2.713211417941573e-14,  4.129726204436232e-15, -1.608312911979181e-16, -5.112997742602045e-18,  4.179237525259779e-19,  1.572994322252765e-02,
 -2.962915417379967e-04,  5.678185955905580e-06, -1.167576302757926e-07,  2.525649802246959e-09, -4.171723702956804e-11,  3.696702482551839e-14,  6.625125177502470e-15,
  1.093835856325694e-15, -5.911956458759899e-17, -4.640289546709424e-19,  1.190836687461796e-19,  1.749977563158940e-02, -3.367386930348167e-04,  5.982241290276896e-06,
 -6.245626165563392e-08, -6.059126839705035e-10, -1.322656702163925e-11,  3.602152931707330e-12, -6.889599576164376e-14, -5.802031286672033e-15,  2.457466119854074e-16,
  7.497416834371332e-18, -6.466720400134378e-19,  2.470234245950422e-08, -6.803764354464238e-12, -3.591153580583141e-12, -1.335604782798355e-12,  1.302841423022271e-13,
 -5.198816282881967e-15,  5.042291527408279e-17,  2.393653660472706e-18,  1.591420706340106e-19, -2.611807607247614e-20,  1.108598622908730e-21,  2.457589037564939e-24,
  8.219245062344094e-06, -8.900387893611710e-08,  1.162549904438622e-09, -1.971300618240601e-10,  1.630588090383537e-11, -5.934976372152887e-13,  1.401679969399534e-15,
  6.741451686704476e-16, -8.076065882656135e-18, -1.646293903988587e-18,  8.313991705994317e-20,  4.464492431286481e-22,  3.471134076694185e-04, -5.067912774690609e-06,
  8.215324589903886e-08, -4.707450246495696e-09,  3.170228229188029e-10, -1.103523233122723e-11,  1.404148545932460e-14,  1.403781259727432e-14, -2.933499249058399e-16,
 -2.265799415989203e-17,  1.385329228405793e-18, -1.095138904135613e-21,  3.906221158958499e-03, -6.437180291401912e-05,  1.104347891913827e-06, -3.288510601910961e-08,
  1.539502388477094e-09, -4.927660413849240e-11,  1.009253414977062e-13,  6.005775812703091e-14, -1.493246024445683e-15, -7.856379137054790e-17,  5.524010981783306e-18,
 -2.986379373302688e-20,  1.462764171828757e-02, -2.558460249528783e-04,  4.492469013308732e-06, -8.286425314485599e-08,  1.727531704765998e-09, -3.653112109052961e-11,
  4.150380877558916e-13,  1.186727163639024e-14, -4.793768498349902e-16, -1.542127320528857e-17,  1.505818828435328e-18, -2.549080606695152e-20,  1.624356397864247e-02,
 -2.920374509214630e-04,  5.178633218864592e-06, -7.048875562866919e-08, -2.326267662077296e-10,  3.803867489190256e-11,  5.175442134578374e-13, -1.051886278466726e-13,
  2.602397177340504e-15,  1.124871442107488e-16, -8.395782240563930e-18,  5.415430942302213e-20,  2.455646482996247e-08, -7.155435784451068e-11, -1.026063551612175e-11,
  7.768315381345871e-15,  4.418155497560742e-14, -3.191706104264978e-15,  1.031496774338482e-16, -4.268840633024418e-20, -1.336422677827555e-19,  3.301811889578899e-21,
  2.195567653987236e-22, -2.001916807755610e-23,  7.871969747637697e-06, -8.559280028766934e-08, -8.252249179271570e-12, -2.395909923505783e-11,  5.998025166270988e-12,
 -3.956236243672372e-13,  1.197882323195597e-14,  3.731047870002280e-17, -1.833638453953328e-17,  5.587420422268330e-19,  1.349414815261628e-20, -1.664000493552946e-21,
  3.278989044429294e-04, -4.566505469603756e-06,  4.917938676930219e-08, -1.273988828942078e-09,  1.241375477463288e-10, -7.447043093393396e-12,  2.207811645192072e-13,
  6.627064652766347e-16, -3.385303834997175e-16,  1.117280028579481e-17,  1.551410671419925e-19, -2.594482169569570e-20,  3.664400646047106e-03, -5.676843530435298e-05,
  8.267058344739841e-07, -1.555085669687729e-08,  6.804370263721845e-10, -3.333316844344238e-11,  9.503760888449056e-13,  1.890820426126899e-15, -1.383560701688486e-15,
  4.796712667790692e-17,  4.320346532135462e-19, -9.740276186393875e-20,  1.367043455177397e-02, -2.234654570529889e-04,  3.641810086687486e-06, -6.044876170748612e-08,
  1.113586892398488e-09, -2.448427934030311e-11,  5.151742636645781e-13, -3.686667519484388e-15, -3.213696665694844e-16,  1.372724034734057e-17,  1.021019594857498e-20,
 -2.207582502003946e-20,  1.515290246160997e-02, -2.539970984185847e-04,  4.335461384955822e-06, -6.825463777133162e-08,  4.707029356422947e-10,  2.622294204593362e-11,
 -1.048259689882400e-12, -9.633207816887637e-15,  2.239202423184408e-15, -7.636226669637108e-17, -5.624925459200693e-19,  1.463006079647197e-19,  2.411830042215732e-08,
 -1.452580808253999e-10, -7.615105068406338e-12,  3.311329033060782e-13,  3.085782145005122e-15, -1.076560260292562e-15,  6.453791866930620e-17, -1.945897615577101e-18,
  5.636804149965030e-21,  2.391867316380092e-21, -1.088788585743420e-22,  9.015348994315891e-25,  7.529281275679971e-06, -8.567946221265222e-08,  6.818417032325615e-11,
  2.374387039827080e-11,  7.856935115593716e-13, -1.423602075133110e-13,  7.951471490925837e-15, -2.251614313658713e-16,  7.209399075189600e-20,  2.987802933292579e-19,
 -1.300126461558591e-20,  1.325139487803298e-22,  3.103579821473287e-04, -4.209946764630828e-06,  4.180103722731056e-08, -2.023040331099227e-10,  2.495280491658690e-11,
 -2.777862740824712e-12,  1.471107407696484e-13, -4.092588768419289e-15,  1.566833762638069e-18,  5.322070486980298e-18, -2.331909808949213e-19,  2.750467283920569e-21,
  3.449576720463714e-03, -5.075897100546763e-05,  6.873089567397422e-07, -8.809595852813672e-09,  2.269785149612629e-10, -1.333471785287006e-11,  6.314676223269518e-13,
 -1.715586708307027e-14,  1.601235080054263e-17,  2.134447200593842e-17, -9.472100333915203e-19,  1.224828026652752e-20,  1.283063133728228e-02, -1.969627123993811e-04,
  3.009211799717208e-06, -4.592748453713027e-08,  7.350098125521766e-10, -1.409575066454376e-11,  3.351754265929304e-13, -7.214706018338667e-15,  4.520401883875894e-17,
  5.099417294359546e-18, -2.506084106648962e-19,  3.948178963074247e-21,  1.420131622905356e-02, -2.224305965802743e-04,  3.574502297731780e-06, -5.787277727872987e-08,
  7.530154753436078e-10,  3.465456758335056e-12, -7.061638886858811e-13,  2.226009783933203e-14,  3.672461164209651e-17, -3.361115782831565e-17,  1.468089181218852e-18,
 -1.945289684298656e-20,  2.344020158602927e-08, -1.906225917849973e-10, -3.831254576314342e-12,  2.750045005091400e-13, -7.025463554638231e-15, -1.081866203454494e-16,
  2.035062780487123e-17, -1.080808918500414e-18,  3.239664131069562e-20, -3.066769705978921e-22, -2.434198308106951e-23,  1.519775127249542e-24,  7.189547631279590e-06,
 -8.393987709786350e-08,  3.625335248553867e-10,  2.186245181047510e-11, -6.320510202814091e-13, -2.015039538158600e-14,  2.680896713475969e-15, -1.332867196188689e-16,
  3.742731177860699e-18, -2.596451417119269e-20, -3.163679610920563e-21,  1.772633286851279e-22,  2.941769933863090e-04, -3.881624837574485e-06,  4.045444037263009e-08,
 -9.284813092500600e-11, -4.008707178085079e-12, -4.960868080610522e-13,  5.107008890739070e-14, -2.444790213063900e-15,  6.726145542268737e-17, -4.432914011965218e-19,
 -5.650066273665422e-20,  3.108281044465152e-21,  3.256934471475253e-03, -4.563732296389425e-05,  5.968215482415055e-07, -6.643558556772815e-09,  7.539289783303666e-11,
 -3.404082150269806e-12,  2.295733899360661e-13, -1.027018450053278e-14,  2.771392426826105e-16, -1.843477662427573e-18, -2.261950472862529e-19,  1.242069145309114e-20,
  1.208769456562871e-02, -1.749125239008199e-04,  2.520578437459209e-06, -3.604975257981964e-08,  5.185177902388300e-10, -8.202028015243390e-12,  1.695154715566103e-13,
 -4.366001464536793e-15,  9.787716940832939e-17, -8.300488446811131e-19, -5.488374876317663e-20,  3.191085390060576e-21,  1.336467736399640e-02, -1.964073432858426e-04,
  2.952183621799531e-06, -4.598733352946647e-08,  7.005829288574424e-10, -6.635207282185014e-12, -1.798860191650938e-13,  1.323982557148183e-14, -3.881065048389935e-16,
  2.297694608530368e-18,  3.531137488444955e-19, -1.907931641268387e-20,  2.263456129144577e-08, -2.100184908480155e-10, -1.214504662032079e-12,  1.634676880631398e-13,
 -6.210009995917242e-15,  1.199293426780177e-16,  2.198191502041808e-18, -3.103082510351499e-19,  1.511730344629480e-20, -4.545529404537476e-22,  6.801612073882009e-24,
  1.375024583653424e-25,  6.860989155732218e-06, -8.017541347690402e-08,  5.593134039592341e-10,  1.097897099954018e-11, -6.298177376001244e-13,  1.151452341909228e-14,
  3.816664147944512e-16, -4.119381012697812e-17,  1.879522925818490e-18, -5.295421077350506e-20,  6.660625098284849e-22,  2.127577200117099e-23,  2.792885992355676e-04,
 -3.563956558410026e-06,  3.879003375930885e-08, -1.889618037985546e-10, -6.062846426056805e-12,  1.264874488263478e-13,  8.483373224458704e-15, -7.780215321002052e-16,
  3.438475373276569e-17, -9.470375092156106e-19,  1.134920032585779e-20,  3.945446752729244e-22,  3.083453483536559e-03, -4.116478007115302e-05,  5.228332321009763e-07,
 -5.763523760513207e-09,  4.387939304321361e-11, -4.448820316955972e-13,  4.870847629645634e-14, -3.386691936605002e-15,  1.429152073356690e-16, -3.866574814712065e-18,
  4.551629821885041e-20,  1.602266989707322e-21,  1.142581820421774e-02, -1.563484606834326e-04,  2.132962584768545e-06, -2.888039760308096e-08,  3.869340202994625e-10,
 -5.283873917801049e-12,  8.487584994983881e-14, -1.925025017490520e-15,  5.278555829783151e-17, -1.229844901715691e-18,  1.441659783304157e-20,  3.988711736371928e-22,
  1.262304234604528e-02, -1.748177884865538e-04,  2.462739661922250e-06, -3.597175564955963e-08,  5.480502174873367e-10, -7.766948911003474e-12,  4.119226203694119e-14,
  3.604815668994523e-15, -1.971990249493099e-16,  5.617667055569124e-18, -6.534716767311100e-20, -2.508280867981933e-21,  2.178534410486302e-08, -2.133875711034349e-10,
  2.332978920768930e-13,  8.401800146841337e-14, -3.761987583600389e-15,  1.099745545143911e-16, -1.776964927186652e-18, -3.223305305875800e-20,  3.932679253884478e-21,
 -1.792806489129459e-22,  5.361948368209504e-24, -9.892576958486771e-26,  6.549854348841236e-06, -7.532601310529503e-08,  6.389879523559557e-10,  2.951479974082816e-12,
 -3.729496974276027e-13,  1.207719619270878e-14, -1.743135687641264e-16, -5.608722853053777e-18,  5.297161196997612e-19, -2.259332564631603e-20,  6.346653852213121e-22,
 -1.036198561255355e-23,  2.656370327865551e-04, -3.264120399922571e-06,  3.604411112762085e-08, -2.602053545156800e-10, -2.739690031310464e-12,  1.651191121455801e-13,
 -2.294427655452931e-15, -1.199928404251241e-16,  9.996372774515272e-18, -4.139595125427600e-19,  1.135870498616324e-20, -1.778500007268278e-22,  2.926737988688661e-03,
 -3.724721932625918e-05,  4.577264657006771e-07, -5.093569209145477e-09,  4.116824871197135e-11, -1.111074119564688e-14, -8.996216376942102e-17, -6.249302482247711e-16,
  4.284332202552114e-17, -1.712874696791579e-18,  4.621399383345109e-20, -7.087370977800980e-22,  1.083249565588283e-02, -1.405731641829770e-04,  1.820371774760924e-06,
 -2.343956788296298e-08,  2.980897694528616e-10, -3.739243000620418e-12,  4.886255437649372e-14, -8.176943854253243e-16,  2.036955289188144e-17, -5.809276872897117e-19,
  1.387619448473794e-20, -2.016432962584659e-22,  1.196063665392240e-02, -1.567047766155749e-04,  2.078806922992527e-06, -2.836827156279964e-08,  4.078044796447323e-10,
 -6.114487240596654e-12,  7.991327489409691e-14, -7.708062696176797e-17, -5.228127848789707e-17,  2.450407137338921e-18, -6.842993950299117e-20,  1.050868867980767e-21,
  2.094066789188840e-08, -2.083601873809321e-10,  9.450774067955742e-13,  3.899047980802670e-14, -2.009155413646061e-15,  6.603018711010316e-17, -1.640103628057945e-18,
  2.367354576931305e-20,  3.658333023636512e-22, -4.239753989199461e-23,  1.834122731730010e-24, -5.404974170113494e-26,  6.258877355651832e-06, -7.015715399939444e-08,
  6.457563872533123e-10, -1.337682839500976e-12, -1.786846885441030e-13,  7.326179945068119e-15, -1.865218858997880e-16,  2.348303467161720e-18,  6.642887637067223e-20,
 -5.821314754048999e-21,  2.350930069304358e-22, -6.526734545315303e-24,  2.531367313407350e-04, -2.988774577882119e-06,  3.275603934864752e-08, -2.812538820345955e-10,
 -1.215503895995513e-13,  9.486513183768775e-14, -2.880125703032692e-15,  3.384584187777996e-17,  1.409732897427294e-18, -1.102455909427975e-19,  4.325706658663285e-21,
 -1.173224426495232e-22,  2.784701383854755e-03, -3.381873921144995e-05,  4.005371651760873e-07, -4.440550977197613e-09,  4.010749560846069e-11, -1.140757116959731e-13,
 -5.477384705938336e-15,  5.494587767627425e-17,  6.985970223227886e-18, -4.692988555138143e-19,  1.788312559715536e-20, -4.773515841896939e-22,  1.029765499327689e-02,
 -1.270595125314686e-04,  1.565433522509284e-06, -1.921136629610706e-08,  2.334886019493897e-10, -2.783559604831507e-12,  3.261097006532774e-14, -4.107915522573848e-16,
  7.320644573578107e-18, -1.983877629673204e-19,  5.767335071972773e-21, -1.391465098871128e-22,  1.136506764867156e-02, -1.413337067915320e-04,  1.773830631809409e-06,
 -2.272076945077051e-08,  3.038265124568425e-10, -4.346618296496783e-12,  6.435921875333059e-14, -7.756887294402237e-16, -2.208254821758421e-18,  6.154587139258045e-19,
 -2.612432092941217e-20,  7.144699287862339e-22,  2.012465638392784e-08, -1.993868786517748e-10,  1.257378536799468e-12,  1.550540252051974e-14, -1.026113739028975e-15,
  3.494149434553777e-17, -9.646089767076144e-19,  2.130787841097252e-20, -2.877100359907579e-22, -3.271959884748641e-24,  3.957119526650543e-25, -1.643852202790171e-26,
  5.988423402222286e-06, -6.509423672956218e-08,  6.166650471662435e-10, -3.242937267132753e-12, -7.098395839155765e-14,  3.738011476526865e-15, -1.123575360598493e-16,
  2.468843944476985e-18, -2.891615215263737e-20, -6.473507207951671e-22,  5.558851387597585e-23, -2.147656083550818e-24,  2.416844693002470e-04, -2.740137876602983e-06,
  2.942078822122226e-08, -2.713990428629478e-10,  1.175701504669292e-12,  3.951973214574207e-14, -1.709700625900870e-15,  4.040987574978727e-17, -4.405193306532122e-19,
 -1.388840193330656e-20,  1.059456823542513e-21, -3.975466815147040e-23,  2.655512658692933e-03, -3.081689502114750e-05,  3.510046176264981e-07, -3.823406796019121e-09,
  3.671539918490236e-11, -2.133773875834333e-13, -2.569744248482334e-15,  1.117950678639437e-16, -1.099644585328269e-18, -6.738512859649660e-20,  4.501606993164246e-21,
 -1.645653265055710e-22,  9.813088223400440e-03, -1.153986534973989e-04,  1.355602936167267e-06, -1.588189898516732e-08,  1.848261146070516e-10, -2.117720309400499e-12,
  2.357195309777230e-14, -2.564187817969383e-16,  3.131055632591638e-18, -6.057077153734905e-20,  1.764892876072720e-21, -5.157087911145134e-23,  1.082649593418814e-02,
 -1.281571159891974e-04,  1.527731755726929e-06, -1.847840576842171e-08,  2.306048018924531e-10, -3.056016138283876e-12,  4.385023243226716e-14, -6.420204915165391e-16,
  7.218536686357703e-18,  3.878894808679265e-20, -6.156382088537526e-21,  2.435654441866531e-22,  1.934807217213595e-08, -1.888168262057358e-10,  1.364431203496260e-12,
  3.603949512715215e-15, -5.159985914003549e-16,  1.788170407804723e-17, -4.993312801024233e-19,  1.218948502407746e-20, -2.459139261444280e-22,  3.202275953795263e-24,
  2.229295472069981e-26, -3.234373966798686e-27,  5.737645799379990e-06, -6.033104662914876e-08,  5.729871635727966e-10, -3.905646789961217e-12, -1.817848568314833e-14,
  1.756430018599911e-15, -5.749005216671798e-17,  1.456532784693397e-18, -2.884065775913645e-20,  3.277146672791409e-22,  5.204692524096819e-24, -4.666371574125568e-25,
  2.311745386736625e-04, -2.517431568498516e-06,  2.629670223907329e-08, -2.481416868497899e-10,  1.638059316301299e-12,  1.023188923849334e-14, -8.084532232226374e-16,
  2.382674801138494e-17, -4.877436197878464e-19,  5.186930977044203e-21,  1.150404413467560e-22, -8.969692099469780e-24,  2.537584223270374e-03, -2.818273619795327e-05,
  3.084994239496378e-07, -3.272477874539313e-09,  3.205817106402949e-11, -2.427550707332076e-13, -1.155784631023029e-16,  6.147096060383523e-17, -1.573365588525389e-18,
  1.566525320570495e-20,  5.577777368801531e-22, -3.816109981314410e-23,  9.372043199060223e-03, -1.052689190586589e-04,  1.181459100154870e-06, -1.323503776301946e-08,
  1.475988529240929e-10, -1.628448745342595e-12,  1.754305472401078e-14, -1.810310659016718e-16,  1.806865022105561e-18, -2.143672962555642e-20,  4.597771933036394e-22,
 -1.428379688560965e-23,  1.033698968073216e-02, -1.167638029805656e-04,  1.326281639558432e-06, -1.522614988965223e-08,  1.786880297385429e-10, -2.193206065398081e-12,
  2.907671462873822e-14, -4.199018921639629e-16,  6.078447172288011e-18, -6.509118561781470e-20, -4.006588562432526e-22,  5.356529901208835e-23,  1.861474266010145e-08,
 -1.778452728101421e-10,  1.368117059428917e-12, -2.340656136155057e-15, -2.546967006072817e-16,  9.211661699922142e-18, -2.508101216266235e-19,  6.145396870792482e-21,
 -1.361982190137698e-22,  2.553384067582891e-24, -3.264950959433052e-26, -9.416176487167660e-29,  5.505188579604240e-06, -5.593732046488867e-08,  5.253243649600798e-10,
 -3.978303479333912e-12,  5.965901298215869e-15,  7.733460637980992e-16, -2.774106117403135e-17,  7.341432887245369e-19, -1.652918313378903e-20,  3.023454189819962e-22,
 -3.415252217832577e-24, -3.352344231328559e-26,  2.215073429883917e-04, -2.318513490600079e-06,  2.348014244530769e-08, -2.211523597749454e-10,  1.694391198317378e-12,
 -2.739460465382810e-15, -3.287721335378286e-16,  1.154245034784935e-17, -2.811591936880337e-19,  5.218630901293111e-21, -5.561207047168736e-23, -7.883442634520264e-25,
  2.429552386644922e-03, -2.586346737269547e-05,  2.721479365192513e-07, -2.798048156043679e-09,  2.728790597494687e-11, -2.299526180675250e-13,  1.001813906332337e-15,
  2.208277078230708e-17, -8.786012207209085e-19,  1.824872011072396e-20, -1.861893612867467e-22, -3.904030424944062e-24,  8.968918597428051e-03, -9.641471590670623e-05,
  1.035803018755654e-06, -1.111274573037140e-08,  1.188607538516774e-10, -1.262319332437699e-12,  1.318727550336660e-14, -1.329519406386812e-16,  1.256825260659165e-18,
 -1.123815064512488e-20,  1.291099091359609e-22, -3.171417034463957e-24,  9.890062296575151e-03, -1.068389075878358e-04,  1.159387163905599e-06, -1.268376846371771e-08,
  1.409542758020964e-10, -1.616660219442010e-12,  1.968811078626051e-14, -2.627280498782906e-16,  3.815615563627483e-18, -5.456079968936062e-20,  5.696738527724121e-22,
  3.001460175603928e-24,  1.792499184736877e-08, -1.670698304906094e-10,  1.320739297414807e-12, -5.218350618788769e-15, -1.189376230120599e-16,  4.840580475749621e-18,
 -1.277090996881116e-19,  3.011658168186060e-21, -6.677541665605142e-23,  1.365204302299769e-24, -2.406988007799323e-26,  3.051344384807055e-28,  5.289545718758538e-06,
 -5.192309017374191e-08,  4.785674496920467e-10, -3.789255042103704e-12,  1.617024776434848e-14,  3.035486598809508e-16, -1.314754805368565e-17,  3.522592771927927e-19,
 -8.149548626885555e-21,  1.674783281596422e-22, -2.875014275099153e-24,  3.268599557332734e-26,  2.125928059587017e-04, -2.140833260742921e-06,  2.098603964878676e-08,
 -1.948154753023674e-10,  1.582298436451822e-12, -7.611008276887633e-15, -1.065384687364469e-16,  5.096311143712478e-18, -1.355989732797677e-19,  2.916722167214811e-21,
 -5.032056785289074e-23,  5.442219528195643e-25,  2.330250261926799e-03, -2.381350808529497e-05,  2.410439132422639e-07, -2.396767416457067e-09,  2.296532588300173e-11,
 -2.011154203659180e-13,  1.314010417777814e-15,  2.886961661897701e-18, -3.708641441004513e-19,  1.002707976824811e-20, -1.845920702061963e-22,  1.937661952269288e-24,
  8.599031259716970e-03, -8.863118639690594e-05,  9.130800033094621e-07, -9.396936975089442e-09,  9.649979153643536e-11, -9.862954918745004e-13,  9.972735215876188e-15,
 -9.841336675584129e-17,  9.217276111561941e-19, -7.819978880789310e-21,  5.949712275663583e-23, -6.506647407628338e-25,  9.480343977179626e-03, -9.813659361108544e-05,
  1.019723435550974e-06, -1.066376701476444e-08,  1.128145337871524e-10, -1.220281212357853e-12,  1.377738936993176e-14, -1.676539324471385e-16,  2.256725767750812e-18,
 -3.283390605095292e-20,  4.631738593661801e-22, -4.811354853119623e-24,  1.727741057979158e-08, -1.567803457090557e-10,  1.249425446936429e-12, -6.488544119575655e-15,
 -4.702309119674509e-17,  2.585422994174916e-18, -6.708661572868414e-20,  1.500684514684214e-21, -3.188445691678334e-23,  6.507771615636554e-25, -1.240599608268946e-26,
  2.074305968555093e-28,  5.089229149253224e-06, -4.827167178141988e-08,  4.348015675632947e-10, -3.496220252586369e-12,  1.975341122708792e-14,  8.174537311517245e-17,
 -6.170783085305240e-18,  1.685583056404006e-19, -3.846511109092712e-21,  8.053034339694809e-23, -1.534720407331544e-24,  2.498780581368207e-26,  2.043510350427997e-04,
 -1.981877963549298e-06,  1.879479509472357e-08, -1.708145768948236e-10,  1.413898348304915e-12, -8.861578265467061e-15, -1.129719215406622e-17,  2.096497976914636e-18,
 -6.096417288131296e-20,  1.384753508227734e-21, -2.714416752475614e-23,  4.418786434875183e-25,  2.238679207612255e-03, -2.199424955798598e-05,  2.143602151244629e-07,
 -2.059780037731763e-09,  1.925924056911015e-11, -1.696633007258150e-13,  1.273813026705510e-15, -4.455879222378745e-18, -1.213396712188390e-19,  4.412262190567986e-21,
 -9.859860137492699e-23,  1.671513014423961e-24,  8.258436807390426e-03, -8.175277050104805e-05,  8.089694868635603e-07, -7.998623253242986e-09,  7.896031410021799e-11,
 -7.769286176334871e-13,  7.590786400964183e-15, -7.300672445701807e-17,  6.779327629402652e-19, -5.831121201868650e-21,  4.276218682949373e-23, -2.413200516361958e-25,
  9.103343744776008e-03, -9.046172686829881e-05,  9.018372009702219e-07, -9.037475817853745e-09,  9.137321536521484e-11, -9.387698679483240e-13,  9.939495956785823e-15,
 -1.111866568696366e-16,  1.357915786186801e-18, -1.840897904048002e-20,  2.668695212154616e-22, -3.708459491913068e-24,  1.666977336059995e-08, -1.471057576738387e-10,
  1.168506291842943e-12, -6.902267752101752e-15, -8.527023777014914e-18,  1.382905959010874e-18, -3.641954132775444e-20,  7.751997969753298e-22, -1.550631475765475e-23,
  3.028729365079855e-25, -5.752542575650983e-27,  1.030220307228381e-28,  4.902841266372613e-06, -4.495562585312636e-08,  3.947749879347815e-10, -3.173748138279573e-12,
  2.022772068331079e-14, -2.132281748705152e-17, -2.811745193622262e-18,  8.192041223233229e-20, -1.823315472483692e-21,  3.724125638034541e-23, -7.188842643067735e-25,
  1.283552707196817e-26,  1.967117831638810e-04, -1.839347602615874e-06,  1.687490419123723e-08, -1.496082715000366e-10,  1.237742009412073e-12, -8.609297724755602e-15,
  2.629320026102958e-17,  7.676547842892451e-19, -2.658916037929424e-20,  6.206420026333430e-22, -1.262217608712951e-23,  2.294940253371846e-25,  2.153982498388529e-03,
 -2.037324609871696e-05,  1.913850132778857e-07, -1.777165939617647e-09,  1.615985050540643e-11, -1.409048941674171e-13,  1.113898239790729e-15, -6.429942920540518e-18,
 -1.808847396099318e-20,  1.685929875219430e-21, -4.366947654495779e-23,  8.630499754323894e-25,  7.943790182609548e-03, -7.564459121896891e-05,  7.200836904964537e-07,
 -6.850321713484249e-09,  6.508983875175398e-11, -6.170112491047580e-13,  5.820994396299887e-15, -5.436086037417619e-17,  4.964414107752738e-19, -4.312912660097498e-21,
  3.344939839848708e-23, -1.960243524426945e-25,  8.755272690440335e-03, -8.365732222953700e-05,  8.015790208555000e-07, -7.713723782256668e-09,  7.475414843521639e-11,
 -7.332164601531989e-13,  7.347985387985192e-15, -7.656363055321683e-17,  8.528841272715139e-19, -1.046888744147104e-20,  1.423428320513947e-22, -2.043986079109014e-24,
  1.609952100679399e-08, -1.380895091240410e-10,  1.085637355541094e-12, -6.858440119936589e-15,  1.189638499636118e-17,  7.219163721897828e-19, -2.029307535872051e-20,
  4.166689777477975e-22, -7.837166580467813e-24,  1.437568033496782e-25, -2.612301701237030e-27,  4.650617902044241e-29,  4.729101656821261e-06, -4.194431671221192e-08,
  3.586077980252437e-10, -2.856507394906724e-12,  1.928278078754541e-14, -6.680768959370020e-17, -1.167194158629027e-18,  4.042842957251834e-20, -8.867602116257458e-22,
  1.736834086823632e-23, -3.253374402279159e-25,  5.855934732615022e-27,  1.896134793491861e-04, -1.711205733587202e-06,  1.519287341098200e-08, -1.311417886414411e-10,
  1.073186910818289e-12, -7.798876245216986e-15,  3.864067172470530e-17,  1.938866117921573e-19, -1.130539639257074e-20,  2.745322026396987e-22, -5.591099571938852e-24,
  1.042819127983438e-25,  2.075422544117711e-03, -1.892327952326549e-05,  1.715219067923226e-07, -1.539762367997113e-09,  1.359436647930757e-11, -1.163515362385211e-13,
  9.328548895912315e-16, -6.311015990067565e-18,  1.874936688161885e-20,  5.317164297673338e-22, -1.754982163334952e-23,  3.792419962701664e-25,  7.652236349476794e-03,
 -7.019592368699476e-05,  6.437444747897520e-07, -5.900502485445086e-09,  5.403206299363302e-11, -4.939121441189835e-13,  4.499699676951516e-15, -4.071725248641544e-17,
  3.632373248536887e-19, -3.141153959129079e-21,  2.531497541200094e-23, -1.716327840987528e-25,  8.432909733332414e-03, -7.759567132051047e-05,  7.157359817251454e-07,
 -6.626067774338472e-09,  6.169428059682724e-11, -5.798190630016077e-13,  5.536560444855549e-15, -5.435702154702244e-17,  5.600181838552099e-19, -6.231852819094909e-21,
  7.678275184772103e-23, -1.041102168908529e-24,  1.556401774667570e-08, -1.297294363830143e-10,  1.004878605664644e-12, -6.575541804216747e-15,  2.228087170966056e-17,
  3.506931089374431e-19, -1.148289074214168e-20,  2.319365431146148e-22, -4.136218154059038e-24,  7.101414448823648e-26, -1.211390529163854e-27,  2.063508068426020e-29,
  4.566852280505953e-06, -3.920743150298209e-08,  3.261327602278001e-10, -2.559860357388842e-12,  1.774378104414893e-14, -8.394388678955737e-17, -3.538223459876945e-19,
  1.997542066799400e-20, -4.445346936750061e-22,  8.353652900757589e-24, -1.489337074071861e-25,  2.593600607783660e-27,  1.830021725087206e-04, -1.595677165701387e-06,
  1.371721735114824e-08, -1.151670171224931e-10,  9.267453808519351e-13, -6.839448493924217e-15,  4.022810454523268e-17, -4.526411592484514e-20, -4.538329727307836e-21,
  1.218430696587809e-22, -2.467630576357291e-24,  4.548184444577809e-26,  2.002361751260008e-03, -1.762148443876927e-05,  1.542768051069785e-07, -1.339710983752133e-09,
  1.147731766712257e-11, -9.600216741996774e-14,  7.666215981057146e-16, -5.512681263588504e-18,  2.852356460978419e-20,  8.366379943534458e-23, -6.471166600985367e-24,
  1.548892144009526e-25,  7.381323932432146e-03, -6.531520974477959e-05,  5.778175426895656e-07, -5.109513082065041e-09,  4.514777039050162e-11, -3.983847379142449e-13,
  3.506657615173004e-15, -3.072172343238080e-17,  2.666513651039752e-19, -2.269730787655835e-21,  1.851249670205675e-23, -1.366540566320272e-25,  8.133497827373123e-03,
 -7.217189072458443e-05,  6.417851935840067e-07, -5.724994169228278e-09,  5.131304872397880e-11, -4.633686586405819e-13,  4.235487565520106e-15, -3.951174975422540e-17,
  3.815658556958390e-19, -3.901079688393225e-21,  4.341307783955203e-23, -5.350693951982425e-25,  1.506068746593337e-08, -1.219995274114063e-10,  9.282994667860358e-13,
 -6.175944413624463e-15,  2.699650837463457e-17,  1.401448369329673e-19, -6.515027720642132e-21,  1.326506719919647e-22, -2.270980550410757e-24,  3.670625059214063e-26,
 -5.851970226460781e-28,  9.362794254013142e-30,  4.415052771907423e-06, -3.671654616425888e-08,  2.970613984188295e-10, -2.289687825811507e-12,  1.601802819881055e-14,
 -8.708963692437891e-17,  4.448190602377962e-20,  9.603136895005797e-21, -2.283347524342593e-22,  4.170255524228283e-24, -7.052755610816617e-26,  1.164982368791897e-27,
  1.768305292196719e-04, -1.491225427296378e-06,  1.241983480270155e-08, -1.013816255873937e-10,  7.994386830197244e-13, -5.902135532755101e-15,  3.747090376590083e-17,
 -1.360255547799526e-19, -1.532630134555009e-21,  5.403366904838952e-23, -1.107167094910269e-24,  1.989018883862523e-26,  1.934246647126276e-03, -1.644859397614255e-05,
  1.392418336951270e-07, -1.170485177955173e-09,  9.729300036568302e-12, -7.935108303373087e-14,  6.252080582997310e-16, -4.590532836122665e-18,  2.819689247914335e-20,
 -7.287971286302843e-23, -2.035597970275906e-24,  6.045699091566181e-26,  7.128936425255331e-03, -6.092622305884295e-05,  5.205886904701284e-07, -4.446593674858020e-09,
  3.795667709082672e-11, -3.236539129730626e-13,  2.754579348310148e-15, -2.336444902579699e-17,  1.969180997154072e-19, -1.638868541486098e-21,  1.328639252512760e-23,
 -1.016328957136437e-25,  7.854662546672924e-03, -6.729912195619560e-05,  5.777224121868870e-07, -4.972954180519785e-09,  4.297920022517664e-11, -3.737319841671691e-13,
  3.281137070150616e-15, -2.925416921496253e-17,  2.675146527670642e-19, -2.549863591161353e-21,  2.592982896876287e-23, -2.883033824439520e-25,  1.458708336095075e-08,
 -1.148620704144201e-10,  8.568479007966124e-13, -5.728943413355908e-15,  2.849886126253370e-17,  2.122025559984690e-20, -3.647650343621129e-21,  7.729919543266469e-23,
 -1.288107217805567e-24,  1.979006535816476e-26, -2.961592519883169e-28,  4.428584195816526e-30,  4.272771530708452e-06, -3.444573468908547e-08,  2.710658015105254e-10,
 -2.047197541522558e-12,  1.430494889056582e-14, -8.349960620737593e-17,  2.302739776674571e-19,  4.240249404520018e-21, -1.187170272753823e-22,  2.153467758725273e-24,
 -3.479643290640697e-26,  5.424110284580640e-28,  1.710569354120122e-04, -1.396524280136117e-06,  1.127626054330850e-08, -8.948746063368449e-11,  6.900584784417606e-13,
 -5.052550970896035e-15,  3.321573286442544e-17, -1.610307120288815e-19, -2.106261960657277e-22,  2.333784096478539e-23, -5.067067556268160e-25,  8.907444388161804e-27,
  1.870594767135346e-03, -1.538831175203592e-05,  1.260801784569704e-07, -1.026739182498192e-09,  8.282431957028141e-12, -6.578942278434552e-14,  5.088246019394140e-16,
 -3.741605503849418e-18,  2.461779625595911e-20, -1.149160001978725e-22, -3.406801850760550e-25,  2.228183089507783e-26,  6.893236965819372e-03, -5.696509548704533e-05,
  4.706708527619357e-07, -3.887689778663909e-09,  3.209516866140551e-11, -2.647334621885664e-13,  2.180407855605081e-15, -1.791268615392940e-17,  1.464900657696184e-19,
 -1.187866252570653e-21,  9.472698092981528e-24, -7.294976789229526e-26,  7.594347461389764e-03, -6.290489570728449e-05,  5.219394403537755e-07, -4.341067608408782e-09,
  3.623034860148864e-11, -3.039249880965537e-13,  2.569363804561453e-15, -2.198438519264138e-17,  1.917303057952389e-19, -1.723911917348957e-21,  1.626162105017634e-23,
 -1.646072421669316e-25,  1.414092019724804e-08, -1.082745201095802e-10,  7.908368940993337e-13, -5.273663142580215e-15,  2.820159614883814e-17, -4.442356784978555e-20,
 -1.967581894778879e-21,  4.552399083279282e-23, -7.493242673186939e-25,  1.105703157731057e-26, -1.565900135282201e-28,  2.196037242638974e-30,  4.139175386198222e-06,
 -3.237170760945072e-08,  2.478186625759609e-10, -1.831344543628434e-12,  1.269789319809979e-14, -7.691452089900904e-17,  3.057944369083575e-19,  1.453536185205845e-21,
 -6.141884716585647e-23,  1.140816117146438e-24, -1.784519005915975e-26,  2.637084307018827e-28,  1.656447126154642e-04, -1.310429304103602e-06,  1.026545804671894e-08,
 -7.921315782770312e-11,  5.966129211481024e-13, -4.309587937042378e-15,  2.871482880037835e-17, -1.575812400216776e-19,  3.431232535163202e-22,  9.208708371293994e-24,
 -2.343167510992453e-25,  4.109382795476616e-27,  1.810983824638605e-03, -1.442679684331905e-05,  1.145130564115796e-07, -9.041171396456214e-10,  7.080719071660800e-12,
 -5.474966964408106e-14,  4.144570916138874e-16, -3.021091618133923e-18,  2.041970737954608e-20, -1.144306416763173e-22,  2.562033236904140e-25,  7.150297877515353e-27,
  6.672623669392237e-03, -5.337799262049927e-05,  4.269337535091313e-07, -3.413842662444250e-09,  2.728575030652886e-11, -2.179296744471436e-13,  1.738538534761494e-15,
 -1.384194756250108e-17,  1.098364381651710e-19, -8.663602882308707e-22,  6.758108632221025e-24, -5.157680486870534e-26,  7.350762318067010e-03, -5.892833796400475e-05,
  4.731344616691165e-07, -3.806857089544112e-09,  3.072199057537463e-11, -2.490068938668111e-13,  2.031186287179810e-15, -1.672922591146177e-17,  1.398400125606954e-19,
 -1.196113791650346e-21,  1.060196403569743e-23, -9.913271429055499e-26,  1.994213011738839e+00,  4.012235580637884e-03, -1.454127003319170e-03,  4.258629208248453e-04,
 -1.135467872697239e-04,  2.875535969481806e-05, -7.057376977082678e-06,  1.697597650910960e-06, -4.030278667257088e-07,  9.487277466692058e-08, -2.216349293078469e-08,
  4.911755153528552e-09,  1.998330205490956e+00,  1.299751990416847e-03, -6.165346523511083e-04,  1.937831233253994e-04, -5.292535539728367e-05,  1.348604846000513e-05,
 -3.302589112800584e-06,  7.893218824952370e-07, -1.858017294447825e-07,  4.332900640906446e-08, -1.002760556246985e-08,  2.204056362528203e-09,  2.000749657674853e+00,
 -2.809295258624350e-04, -1.448346688748510e-04,  6.735622600701356e-05, -2.093820154977820e-05,  5.670176396296053e-06, -1.435029030158566e-06,  3.495625341743962e-07,
 -8.322550024189503e-08,  1.954240390119118e-08, -4.541778679060891e-09,  1.000787468869268e-09,  2.002287690472030e+00, -1.280646963013236e-03,  1.472345074743050e-04,
 -9.354821807972133e-06, -1.896247595789083e-06,  1.099238352694693e-06, -3.605243828571320e-07,  1.002754673921569e-07, -2.584653164005665e-08,  6.391638784729755e-09,
 -1.539160714159605e-09,  3.473488666126610e-10,  2.003237795866217e+00, -1.896228893821274e-03,  3.246584374488279e-04, -5.536238274869198e-05,  9.389355845730143e-06,
 -1.580509065962850e-06,  2.632522651748987e-07, -4.318297481011865e-08,  6.922803119534542e-09, -1.070121197563239e-09,  1.554079293670508e-10, -1.994346931764660e-11,
  2.003732342943066e+00, -2.216051170084244e-03,  4.161092203992539e-04, -7.890053429545012e-05,  1.512382204030693e-05, -2.933719513031449e-06,  5.765050432742182e-07,
 -1.148772871031553e-07,  2.323152242785367e-08, -4.770838146067496e-09,  9.935008948789306e-10, -2.012283098326687e-10,  1.999880981848391e+00,  1.656952794362893e-04,
 -1.434027823245748e-04,  4.735449719799893e-05, -1.261720233208701e-05,  3.050323731917494e-06, -6.976544334050571e-07,  1.539631011113221e-07, -3.314455991637092e-08,
  7.006455205945735e-09, -1.458536652160928e-09,  2.888835551164682e-10,  2.000636928344031e+00, -3.203986985145664e-04, -7.987959526048516e-06,  1.361784655453390e-05,
 -4.716369877491513e-06,  1.271280323411065e-06, -3.077749680138309e-07,  7.019384339501951e-08, -1.541439848737515e-08,  3.297902685883033e-09, -6.913242480494930e-10,
  1.374088246262145e-10,  2.001110148121360e+00, -6.235240732018266e-04,  7.503350108960098e-05, -6.719143586984809e-06, -3.243902975620093e-08,  2.337782233681829e-07,
 -8.404756851482020e-08,  2.288008774516331e-08, -5.554747243350319e-09,  1.266773726173888e-09, -2.773165553958568e-10,  5.676374938031125e-11,  2.001422937848456e+00,
 -8.233908270738724e-04,  1.291744737073746e-04, -1.983790464931184e-05,  2.956903025343947e-06, -4.214841676771063e-07,  5.581963621736240e-08, -6.406498735715590e-09,
  4.895446731721847e-10,  3.325368155110523e-11, -2.815189153287787e-11,  8.623388216657737e-12,  2.001621014975066e+00, -9.497552005993567e-04,  1.631584469373517e-04,
 -2.801410734469049e-05,  4.807089322944556e-06, -8.243085656222021e-07,  1.412401000079925e-07, -2.417900445800283e-08,  4.134988340095905e-09, -7.063012322441126e-10,
  1.203861857839115e-10, -1.992897777513394e-11,  2.001725624592069e+00, -1.016427892026077e-03,  1.810121815811055e-04, -3.229141534368450e-05,  5.771017844404002e-06,
 -1.033338235009046e-06,  1.853943427253891e-07, -3.333141162029510e-08,  6.005553302917597e-09, -1.084473772341265e-09,  1.960910426000965e-10, -3.443829175087803e-11,
  2.000422356054859e+00, -2.282013929297003e-04,  1.640460194152131e-05,  1.376677618037229e-06, -1.007885884662291e-06,  3.149173489383807e-07, -8.014272945580718e-08,
  1.854947793457110e-08, -4.064199147486892e-09,  8.591364785504572e-10, -1.768498763789665e-10,  3.443113175647253e-11,  2.000586956312340e+00, -3.329674673308302e-04,
  4.428116868352305e-05, -5.252022745168461e-06,  4.730762189985232e-07, -3.081658419337427e-09, -1.371180210635375e-08,  4.948868535705321e-09, -1.322309613310698e-09,
  3.130814183914708e-10, -6.930710115321157e-11,  1.415477144272237e-11,  2.000692940026361e+00, -4.003005716593360e-04,  6.204686007042312e-05, -9.440879399322482e-06,
  1.401077351319708e-06, -2.006826338888861e-07,  2.722531866742406e-08, -3.363327531882288e-09,  3.397466468461975e-10, -1.524068933954571e-11, -5.162666936339364e-12,
  2.150397572304369e-12,  2.000764278700815e+00, -4.455683246577879e-04,  7.392432304820730e-05, -1.222582867710266e-05,  2.014648780450871e-06, -3.306159807135087e-07,
  5.399765926792007e-08, -8.770202091277773e-09,  1.415128149192308e-09, -2.265552071418174e-10,  3.590850504411813e-11, -5.499177247856809e-12,  2.000809994750712e+00,
 -4.745541220002800e-04,  8.150164866733551e-05, -1.399596752263042e-05,  2.403215116393728e-06, -4.126032794827138e-07,  7.083043888474249e-08, -1.215769151126904e-08,
  2.086519357353691e-09, -3.580304460847047e-10,  6.137564547301089e-11, -1.022766700140588e-11,  2.000834309812952e+00, -4.899634600375120e-04,  8.552096501375285e-05,
 -1.493284573147305e-05,  2.608420544689453e-06, -4.558077468757666e-07,  7.968175639751120e-08, -1.393520232504604e-08,  2.438083697567306e-09, -4.267343100852228e-10,
  7.465700656986585e-11, -1.268904546971343e-11,  2.000313029518368e+00, -1.790572596326385e-04,  2.564357391990904e-05, -3.496843064491188e-06,  4.394472107954758e-07,
 -4.686615457296517e-08,  2.970593822266463e-09,  3.912459245863540e-10, -2.271777238800421e-10,  6.740039536128518e-11, -1.658072820203668e-11,  3.581230647655905e-12,
  2.000351558102341e+00, -2.034640206405376e-04,  3.199713196368158e-05, -4.974536861373041e-06,  7.623116144887883e-07, -1.146585467071147e-07,  1.681805526329890e-08,
 -2.380615887639129e-09,  3.191416982923599e-10, -3.896238948347600e-11,  3.898302660621653e-12, -1.989845228331896e-13,  2.000376699850052e+00, -2.193762270544643e-04,
  3.612201372124658e-05, -5.929840203029821e-06,  9.701562052170919e-07, -1.581160166181813e-07,  2.565746845384104e-08, -4.142593364274091e-09,  6.649672942417216e-10,
 -1.060108533009276e-10,  1.675448489796073e-11, -2.562965742370193e-12,  2.000393772528316e+00, -2.301750485055700e-04,  3.891354614926762e-05, -6.574530485245733e-06,
  1.110027347439991e-06, -1.872793307382015e-07,  3.157286021635497e-08, -5.318446942066012e-09,  8.951159083832335e-10, -1.505092543726776e-10,  2.526357477118354e-11,
 -4.123637073273001e-12,  2.000404777131638e+00, -2.371329121296415e-04,  4.070882684111386e-05, -6.988365410073410e-06,  1.199644604703739e-06, -2.059298446312729e-07,
  3.534885586547111e-08, -6.067649590471173e-09,  1.041487498044209e-09, -1.787580415524792e-10,  3.065561961120554e-11, -5.110940698502381e-12,  2.000410650630641e+00,
 -2.408456498865322e-04,  4.166571934319083e-05, -7.208692700193931e-06,  1.247303513080059e-06, -2.158371715157242e-07,  3.735246424404182e-08, -6.464748761513627e-09,
  1.118983196266746e-09, -1.936978403797728e-10,  3.350419430503108e-11, -5.631999206700283e-12,  2.000179991278432e+00, -1.044145319111793e-04,  1.671428162027616e-05,
 -2.658037454924287e-06,  4.194237771616816e-07, -6.556531645049386e-08,  1.013212151282577e-08, -1.543308558899676e-09,  2.307218164100696e-10, -3.363670861838035e-11,
  4.732018318310975e-12, -6.229695331466192e-13,  2.000189318473292e+00, -1.103094988047610e-04,  1.823249305886953e-05, -3.007336586005396e-06,  4.949172609172805e-07,
 -8.124485513846403e-08,  1.330005338819598e-08, -2.170532541279929e-09,  3.529963943575822e-10, -5.718244905436438e-11,  9.216173175471025e-12, -1.442255104943352e-12,
  2.000195444692180e+00, -1.141796572395918e-04,  1.922713905744419e-05, -3.235694026822984e-06,  5.441672891272309e-07, -9.145212262408253e-08,  1.535798956145739e-08,
 -2.577125299126992e-09,  4.320925495232880e-10, -7.238146299648550e-11,  1.210467772215837e-11, -1.968970573178180e-12,  2.000199622789095e+00, -1.168183284043505e-04,
  1.990433831455450e-05, -3.390950531209384e-06,  5.776042491222320e-07, -9.837227526180014e-08,  1.675122562747127e-08, -2.852003375981907e-09,  4.854905119005010e-10,
 -8.262794992093467e-11,  1.404926251250407e-11, -2.323101216117794e-12,  2.000202323656756e+00, -1.185237179939490e-04,  2.034160666238540e-05, -3.491105292165451e-06,
  5.991538012086001e-07, -1.028279869100886e-07,  1.764744988011888e-08, -3.028657381998214e-09,  5.197752160704123e-10, -8.920065477767818e-11,  1.529547539107958e-11,
 -2.549853342583287e-12,  2.000203767696485e+00, -1.194354083050383e-04,  2.057523552212173e-05, -3.544586721100240e-06,  6.106544494697539e-07, -1.052045756639389e-07,
  1.812520678770926e-08, -3.122774288531902e-09,  5.380309393985492e-10, -9.269847884284099e-11,  1.595830665933460e-11, -2.670394373593664e-12,  2.000095634561658e+00,
 -5.577262084011453e-05,  9.277187375687396e-06, -1.541183872671875e-06,  2.556778586085429e-07, -4.235308070831098e-08,  7.004497350047119e-09, -1.156402627138061e-09,
  1.905518203757834e-10, -3.133315073218995e-11,  5.137013747776069e-12, -8.189151717854471e-13,  2.000097929558224e+00, -5.722146672670025e-05,  9.648353810614741e-06,
 -1.626123087112155e-06,  2.739372043582090e-07, -4.612505592735607e-08,  7.762494799933269e-09, -1.305671195073088e-09,  2.194941598592497e-10, -3.687634786883990e-11,
  6.187010104675066e-12, -1.009789739441965e-12,  2.000099441797331e+00, -5.817594064763166e-05,  9.892615568206240e-06, -1.681961849275950e-06,  2.859281126909990e-07,
 -4.859948222340503e-08,  8.259215374930208e-09, -1.403384022345001e-09,  2.384200304845601e-10, -4.049729311762884e-11,  6.872168735681382e-12, -1.134218890228850e-12,
  2.000100475365134e+00, -5.882819652163685e-05,  1.005941894193244e-05, -1.720066488867986e-06,  2.941049621308143e-07, -5.028564702515359e-08,  8.597458695890404e-09,
 -1.469874642330143e-09,  2.512893804540917e-10, -4.295774555549388e-11,  7.337409792784993e-12, -1.218653858380729e-12,  2.000101144458514e+00, -5.925040073695031e-05,
  1.016733984458555e-05, -1.744708321218469e-06,  2.993903271476747e-07, -5.137503531936570e-08,  8.815885358653962e-09, -1.512791771664971e-09,  2.595921108159039e-10,
 -4.454436799129448e-11,  7.637279125684558e-12, -1.273052087418407e-12,  2.000101502503921e+00, -5.947631719917980e-05,  1.022507068445616e-05, -1.757886373980592e-06,
  3.022160453063223e-07, -5.195728880833396e-08,  8.932596043623254e-09, -1.535716874528842e-09,  2.640259235159504e-10, -4.539141194453317e-11,  7.797323729416439e-12,
 -1.302077487278021e-12,  2.000049199281739e+00, -2.875888504450048e-05,  4.862277976504174e-06, -8.218319924781984e-07,  1.388664981293643e-07, -2.345732763390002e-08,
  3.961150793420744e-09, -6.686839796744427e-10,  1.128421978462439e-10, -1.903524406559433e-11,  3.207411441401191e-12, -5.257394664782228e-13,  2.000049768509904e+00,
 -2.911804131213425e-05,  4.954044335310489e-06, -8.427763161697337e-07,  1.433568698421587e-07, -2.438245726526395e-08,  4.146562331731965e-09, -7.050982526279202e-10,
  1.198837831285362e-10, -2.038026900193205e-11,  3.461506104045736e-12, -5.718145295096921e-13,  2.000050144190684e+00, -2.935505197955137e-05,  5.014570131577367e-06,
 -8.565831390129226e-07,  1.463154223719270e-07, -2.499166976108518e-08,  4.268593853635729e-09, -7.290521349700129e-10,  1.245133856752511e-10, -2.126410701813940e-11,
  3.628387529558809e-12, -6.020601790698342e-13,  2.000050401231394e+00, -2.951720258726999e-05,  5.055964269338365e-06, -8.660224064180409e-07,  1.483373681256656e-07,
 -2.540787205895490e-08,  4.351933770902183e-09, -7.454053178680999e-10,  1.276728645213379e-10, -2.186706889757177e-11,  3.742195145773557e-12, -6.226798645845682e-13,
  2.000050567749091e+00, -2.962224277194004e-05,  5.082772843355300e-06, -8.721342212526075e-07,  1.496462428392694e-07, -2.567722987941587e-08,  4.405856847952054e-09,
 -7.559837273699324e-10,  1.297161546252057e-10, -2.225692199667935e-11,  3.815761545379015e-12, -6.360056775066187e-13,  2.000050656894556e+00, -2.967847448397127e-05,
  5.097122382390553e-06, -8.754051588549305e-07,  1.503466293572122e-07, -2.582134409955612e-08,  4.434703102518414e-09, -7.616418539308618e-10,  1.308089021871774e-10,
 -2.246538470455743e-11,  3.855093429446029e-12, -6.431292971818620e-13,  2.000024941737846e+00, -1.459528577410519e-05,  2.486287485835385e-06, -4.235070023669097e-07,
  7.213397468663548e-08, -1.228538131102328e-08,  2.092215466528840e-09, -3.562809694535046e-10,  6.066615427719362e-11, -1.032898615890617e-11,  1.757081021382316e-12,
 -2.906979233035917e-13,  2.000025083484631e+00, -1.468469642114614e-05,  2.509102328420365e-06, -4.287072434648569e-07,  7.324739851245731e-08, -1.251446850193513e-08,
  2.138067048540279e-09, -3.652740427922944e-10,  6.240285729852209e-11, -1.066027283937496e-11,  1.819582459536947e-12, -3.020171622452424e-13,  2.000025177109630e+00,
 -1.474374967136743e-05,  2.524166954535067e-06, -4.321400518690410e-07,  7.398220226468868e-08, -1.266561435106696e-08,  2.168310698179471e-09, -3.712042846683798e-10,
  6.354777482156721e-11, -1.087861469726668e-11,  1.860764504844356e-12, -3.094735275842395e-13,  2.000025241202029e+00, -1.478417396004180e-05,  2.534477478649641e-06,
 -4.344891167685402e-07,  7.448493781284334e-08, -1.276900638995882e-08,  2.188995323149138e-09, -3.752594484966989e-10,  6.433054222012949e-11, -1.102786597991476e-11,
  1.888910192244252e-12, -3.145686991483520e-13,  2.000025282737600e+00, -1.481037057952569e-05,  2.541158341697972e-06, -4.360110489901181e-07,  7.481061562389244e-08,
 -1.283597694010453e-08,  2.202391860721518e-09, -3.778854891646138e-10,  6.483738573354845e-11, -1.112449495355233e-11,  1.907130239994987e-12, -3.178666793183160e-13,
  2.000025304978518e+00, -1.482439778862700e-05,  2.544735414417999e-06, -4.368258647047018e-07,  7.498496525190696e-08, -1.287182663298144e-08,  2.209562581837031e-09,
 -3.792910200534050e-10,  6.510864308499610e-11, -1.117620604157003e-11,  1.916880016066499e-12, -3.196313510804339e-13,  2.000012555971623e+00, -7.351318913877618e-06,
  1.256835416330904e-06, -2.148742510272767e-07,  3.673525863677313e-08, -6.280215238546558e-09,  1.073639780569785e-09, -1.835419033482024e-10,  3.137647030647503e-11,
 -5.363585214395647e-12,  9.161130763006458e-13, -1.521554475826902e-13,  2.000012591338588e+00, -7.373624488616155e-06,  1.262523370689216e-06, -2.161698603403917e-07,
  3.701247701944910e-08, -6.337214959762749e-09,  1.085040607467116e-09, -1.857765047471710e-10,  3.180771847216448e-11, -5.445793465690318e-12,  9.316123854529696e-13,
 -1.549606771013692e-13,  2.000012614708074e+00, -7.388362970749800e-06,  1.266281213483251e-06, -2.170257133254900e-07,  3.719557751245639e-08, -6.374857809103650e-09,
  1.092568758424337e-09, -1.872518518492493e-10,  3.209240279764380e-11, -5.500055223481173e-12,  9.418413855154228e-13, -1.568117998294499e-13,  2.000012630710271e+00,
 -7.398454922518715e-06,  1.268854113516434e-06, -2.176116423315525e-07,  3.732091954023247e-08, -6.400624045934740e-09,  1.097721259447555e-09, -1.882615352483403e-10,
  3.228721483629337e-11, -5.537183716497208e-12,  9.488399349515064e-13, -1.580782084448796e-13,  2.000012641082469e+00, -7.404996175827204e-06,  1.270521680115632e-06,
 -2.179913763429809e-07,  3.740214746165310e-08, -6.417320863208957e-09,  1.101059939769619e-09, -1.889157434772883e-10,  3.241343263625103e-11, -5.561237653336363e-12,
  9.533737209425393e-13, -1.588985648690000e-13,  2.000012646637036e+00, -7.408499151039620e-06,  1.271414664510232e-06, -2.181947171827059e-07,  3.744564201043469e-08,
 -6.426261069282099e-09,  1.102847550703895e-09, -1.892660098854562e-10,  3.248100784699799e-11, -5.574115323184340e-12,  9.558008703990170e-13, -1.593377255409797e-13,
  2.000006299209033e+00, -3.689043036472772e-06,  6.318287644135808e-07, -1.082139608582695e-07,  1.853384019748523e-08, -3.174283768821042e-09,  5.436561293243003e-10,
 -9.311100604769171e-11,  1.594687677103841e-11, -2.731103227503970e-12,  4.673546498914390e-13, -7.776081263859727e-14,  2.000006308042076e+00, -3.694613557681762e-06,
  6.332487888810860e-07, -1.085373086185482e-07,  1.860300312789958e-08, -3.188499833766608e-09,  5.464986142886353e-10, -9.366795700224860e-11,  1.605432497130125e-11,
 -2.751579093515077e-12,  4.712138275912520e-13, -7.845906974398553e-14,  2.000006313879861e+00, -3.698295080427532e-06,  6.341872127965072e-07, -1.087509790361628e-07,
  1.864870343475889e-08, -3.197892659418137e-09,  5.483765734273682e-10, -9.403589614811753e-11,  1.612530387015282e-11, -2.765104286108033e-12,  4.737628117721495e-13,
 -7.892023937522336e-14,  2.000006317877801e+00, -3.700816306432238e-06,  6.348298476927178e-07, -1.088972945564442e-07,  1.867999633364436e-08, -3.204324030782298e-09,
  5.496623754064106e-10, -9.428780565594378e-11,  1.617389739753449e-11, -2.774363481084389e-12,  4.755077401041020e-13, -7.923592371356832e-14,  2.000006320469391e+00,
 -3.702450633730408e-06,  6.352464088747645e-07, -1.089921346551730e-07,  1.870027943948092e-08, -3.208492525744869e-09,  5.504957433728441e-10, -9.445107110356153e-11,
  1.620539047891096e-11, -2.780364112686051e-12,  4.766385468439004e-13, -7.944049830494934e-14,  2.000006321857327e+00, -3.703325899947332e-06,  6.354694948248755e-07,
 -1.090429245875613e-07,  1.871114150150660e-08, -3.210724808847524e-09,  5.509420146691982e-10, -9.453849871045905e-11,  1.622225451860224e-11, -2.783577296552612e-12,
  4.772440538684898e-13, -7.955003891613992e-14,  2.000003154903780e+00, -1.847862995364822e-06,  3.167656678106522e-07, -5.430077168494096e-08,  9.308366123645377e-09,
 -1.595660412128295e-09,  2.735313071538490e-10, -4.688923623094298e-11,  8.037824635280025e-12, -1.377821850154574e-12,  2.359900592324988e-13, -3.929887969086152e-14,
  2.000003157110954e+00, -1.849254892443244e-06,  3.171204287497092e-07, -5.438153941629306e-08,  9.325639181191456e-09, -1.599210204172214e-09,  2.742409654659103e-10,
 -4.702826210325244e-11,  8.064641336241445e-12, -1.382931321921885e-12,  2.369529040883256e-13, -3.947306406486270e-14,  2.000003158569828e+00, -1.850174886281364e-06,
  3.173549052824096e-07, -5.443492046764752e-08,  9.337054920761802e-09, -1.601556178793536e-09,  2.747099464577533e-10, -4.712013493750056e-11,  8.082362097198549e-12,
 -1.386307602674847e-12,  2.375891198924702e-13, -3.958815571427062e-14,  2.000003159568987e+00, -1.850804972734472e-06,  3.175154903211586e-07, -5.447147853256103e-08,
  9.344872827223554e-09, -1.603162750257307e-09,  2.750311070799591e-10, -4.718304852758856e-11,  8.094496824499123e-12, -1.388619542391982e-12,  2.380247649028580e-13,
 -3.966696239626992e-14,  2.000003160216703e+00, -1.851213431409327e-06,  3.176195893504498e-07, -5.449517689583626e-08,  9.349940623536078e-09, -1.604204161460565e-09,
  2.752392865964957e-10, -4.722382913378349e-11,  8.102362440327464e-12, -1.390118097492271e-12,  2.383071374564417e-13, -3.971804190458601e-14,  2.000003160563598e+00,
 -1.851432188314974e-06,  3.176753408396510e-07, -5.450786872600746e-08,  9.352654694146764e-09, -1.604761886727849e-09,  2.753507756298238e-10, -4.724566869497807e-11,
  8.106574737832532e-12, -1.390920616073822e-12,  2.384583545730308e-13, -3.974539594678986e-14,   0.00180018740918054,   0.00163529054303039,  0.000444443771465736,
  4.07441454193779e-05,  1.02181248546637e-06,  3.51288127170273e-09,  0.000898207850563912,  0.000816048071997425,  0.000221847559426644,  2.03464368003711e-05,
  5.10594335021984e-07,  1.75720066515019e-09,  0.000448650459467003,  0.000407625398561331,  0.000110822236894537,  1.01648843028309e-05,  2.55124592412261e-07,
  8.78202523777645e-10,  0.000224213895496704,  0.000203713151402723,  5.53848724056572e-05,   5.0801513238827e-06,  1.27509110718825e-07,  4.38940960205703e-10,
   0.00011207935640703,   0.00010183170416874,  2.76857744192123e-05,  2.53947883639335e-06,   6.3740099065492e-08,  2.19423462169649e-10,  5.60328099545633e-05,
  5.09096362170702e-05,  1.38412096532582e-05,  1.26958730145898e-06,  3.18662959980129e-08,  1.09699146980879e-10,  2.80146915715273e-05,  2.54532643988639e-05,
  6.92018394933444e-06,  6.34755264060101e-07,  1.59321925159094e-08,  5.48463260545413e-11,  1.40069178888132e-05,  1.27262438044751e-05,  3.45998657089088e-06,
  3.17367991064731e-07,  7.96585527021095e-09,  2.74223386325166e-11,  7.00335202682052e-06,  6.36302480757552e-06,  1.72996691154229e-06,  1.58681579777813e-07,
  3.98286712481558e-09,  1.37109616592894e-11,  3.50164929108524e-06,  3.18148813063312e-06,  8.64976859431541e-07,  7.93401852626105e-08,  1.99141840199492e-09,
  6.85542872115795e-12,  1.75081796584469e-06,  1.59073799709184e-06,  4.32486780273271e-07,  3.96699413888673e-08,  9.95705406794108e-10,  3.42770130921044e-12
  };
  int offset = -6;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 6;
    if (std::isnan(t)) {
      fill_n(rr+offset, 6, 0.5);
      fill_n(ww+offset, 6, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 6; ++r) {
        ww[offset+r] = aw[6-r-1] / t;
        rr[offset+r] = 1.0 - ax[6-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=6; ++j) {
        const int boxof = it*72+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 3096 + (it - 32) * 6 + 6 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
