/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the mingw-w64 runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#include <_mingw_mac.h>

	.file	"ilogbl.S"
	.text
#ifdef __x86_64__
	.align 8
#else
	.align 4
#endif
.globl __MINGW_USYMBOL(ilogbl)
	.def	__MINGW_USYMBOL(ilogbl);	.scl	2;	.type	32;	.endef
__MINGW_USYMBOL(ilogbl):
#ifdef __x86_64__
	fldt	(%rcx)
	fxam			/* Is NaN or +-Inf?  */
	fstsw   %ax
	movb    $0x45, %dh
	andb    %ah, %dh
	cmpb    $0x05, %dh
	je      1f		/* Is +-Inf, jump.  */
	cmpb	$0x01, %dh
	je      1f		/* Is +-Inf, jump.  */
	cmpb	$0x40, %dh
	je	2f		/* Is +-Inf, jump.  */

	fxtract
	pushq	%rax
	fstp	%st

	fistpl	(%rsp)
	fwait
	popq	%rax

	ret

1:	fstp	%st
	movl	$0x7fffffff, %eax
	ret
2:	fstp    %st
	movl	$0x80000001, %eax	/* FP_ILOGB0  */
	ret
#else
	fldt	4(%esp)
/* I added the following ugly construct because ilogb(+-Inf) is
   required to return INT_MAX in ISO C99.
   -- jakub@redhat.com.  */
	fxam			/* Is NaN or +-Inf?  */
	fstsw   %ax
	movb    $0x45, %dh
	andb    %ah, %dh
	cmpb    $0x05, %dh
	je      1f		/* Is +-Inf, jump.  */
	cmpb	$0x01, %dh
	je      1f		/* Is +-Inf, jump.  */
	cmpb	$0x40, %dh
	je	2f		/* Is +-Inf, jump.  */

	fxtract
	pushl	%eax
	fstp	%st

	fistpl	(%esp)
	fwait
	popl	%eax

	ret

1:	fstp	%st
	movl	$0x7fffffff, %eax
	ret
2:	fstp    %st
	movl	$0x80000001, %eax	/* FP_ILOGB0  */
	ret
#endif
