#!/bin/bash

. ../MasterTest.sh

CleanFiles ptraj.in cpptraj.nc mop.xtc temp.crd total?.out

TESTNAME='XTC tests'
Requires xdr maxthreads 2

INPUT="-i ptraj.in"

GmxXtcRead() {
  UNITNAME='XTC read test'
  CheckFor netcdf pnetcdf
  if [ $? -eq 0 ] ; then
      cat > ptraj.in <<EOF
parm ../Test_GromacsTrr/nvt.protein.mol2
trajin nvt.2frame.xtc
trajout cpptraj.nc
EOF
      RunCpptraj "$UNITNAME"
      NcTest cpptraj.nc.save cpptraj.nc
  fi
}

GmxXtcWrite() {
  UNITNAME='XTC write test'
  CheckFor notparallel
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd
trajout mop.xtc xtc
EOF
    RunCpptraj "CRD => XTC"

    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin mop.xtc
trajout temp.crd title "trajectory generated by ptraj"
EOF
    RunCpptraj "XTC => CRD"
    DoTest temp.crd.save temp.crd
  fi
}

# Gromacs XTC append
GmxXtcAppend() {
  UNITNAME='GMX XTC append test'
  CheckFor notparallel
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd 1 5
trajout mop.xtc xtc
EOF
    RunCpptraj "CRD(1-5) => XTC"
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd 6 10
trajout mop.xtc xtc append
EOF
    RunCpptraj "CRD(6-10) => XTC"
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin mop.xtc
trajout temp.crd title "trajectory generated by ptraj"
EOF
    RunCpptraj "XTC (appended) => CRD"
    DoTest temp.crd.save temp.crd
  fi
}

# Gromacs XTC with offsets
GmxXtcOffset() {
  UNITNAME='GMX XTC offset test'
  CheckFor notparallel
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin temp.crd.save 2 10 2
trajout total1.out title "offset test"
EOF
    RunCpptraj "GMX: CRD with offset"
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin mop.xtc 2 10 2
trajout total2.out title "offset test"
EOF
    RunCpptraj "GMX: XTC with offset"
    DoTest total1.out total2.out
  fi
}

GmxXtcRead
GmxXtcWrite
GmxXtcAppend
GmxXtcOffset

EndTest
exit 0
